/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.AttachmentOperaClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.business.rejectbill.constant.RejectStatusEnum;
import kd.epm.eb.business.rejectbill.entity.RejectUserDto;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.AuditRecordObj;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.BillSaveEventArgs;
import kd.epm.eb.common.applybill.BillVerifyResult;
import kd.epm.eb.common.applybill.ColumnsContext;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.applybill.BgApplyBillBasePlugin;
import kd.epm.eb.formplugin.applybill.IApAuditBill;
import kd.epm.eb.formplugin.applybill.fileImport.BgApplyAuditDataExportPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class BgApplyAuditBillPlugin
extends BgApplyBillBasePlugin
implements IApAuditBill,
AttachmentOperaClickListener {
    private static final String KEY_ATTACHMENTPENAL = "attachmentpanelap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel panel = (AttachmentPanel)this.getControl(KEY_ATTACHMENTPENAL);
        panel.addOperaClickListener((AttachmentOperaClickListener)this);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (opKey.startsWith("rejectrow")) {
            this.rejectSelectedRows();
        }
    }

    @Override
    protected void doCheckBeforeSave(BillVerifyResult verifyResult) {
        super.doCheckBeforeSave(verifyResult);
        this.checkMainBillSave(verifyResult);
    }

    private void rejectSelectedRows() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String entityName = currentTab.replaceAll("tabentryentity", "entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityName);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u9a73\u56de\u7684\u8bb0\u5f55\u3002", (String)"BgApplyAuditBillPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryTemplateConfig tempConfig = this.getTempConfig(entityName);
        List entryColumns = tempConfig.getEntryColumns();
        BaseColumn baseColumn = entryColumns.stream().filter(t -> t.getKey().startsWith(ApplyTemplateUtils.FIELD_REJECT_STATUS)).findFirst().orElse(null);
        ArrayList<String> notSaveRowIndex = new ArrayList<String>(16);
        ArrayList<String> hasRejectRowIndex = new ArrayList<String>(16);
        ArrayList<String> hasSubtotalRowIndex = new ArrayList<String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityName);
        for (int selectRow : selectRows) {
            String rejectStatus;
            boolean subtotalstatus;
            String rowIndexStr = selectRow + 1 + "";
            DynamicObject entryRowEntity = (DynamicObject)entryEntity.get(selectRow);
            if (entryRowEntity == null) {
                notSaveRowIndex.add(rowIndexStr);
                continue;
            }
            long id = entryRowEntity.getLong("id");
            if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
                notSaveRowIndex.add(rowIndexStr);
            }
            if (subtotalstatus = entryRowEntity.getBoolean(tempConfig.getSubtotalKey())) {
                hasSubtotalRowIndex.add(rowIndexStr);
            }
            if (baseColumn == null || !StringUtils.equals((CharSequence)(rejectStatus = entryRowEntity.getString(baseColumn.getKey())), (CharSequence)RejectStatusEnum.reject.getDesc())) continue;
            hasRejectRowIndex.add(rowIndexStr);
        }
        if (CollectionUtils.isNotEmpty(notSaveRowIndex)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", notSaveRowIndex)}));
            return;
        }
        if (CollectionUtils.isNotEmpty(hasRejectRowIndex)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u5df2\u9a73\u56de\uff0c\u65e0\u6cd5\u91cd\u590d\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", hasRejectRowIndex)}));
            return;
        }
        if (CollectionUtils.isNotEmpty(hasSubtotalRowIndex)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u662f\u5c0f\u8ba1\u884c\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", hasSubtotalRowIndex)}));
            return;
        }
        List<RejectUserDto> rejectUserList = this.getRejectUserList(entityName);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_billrejectuserlist");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("rejectUser", (Object)SerializationUtils.serializeToBase64(rejectUserList));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_billrejectuserlist"));
        this.getView().showForm(formShowParameter);
    }

    private List<RejectUserDto> getRejectUserList(String entityName) {
        Object billNo = this.getView().getParentView().getModel().getValue("billno");
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityName);
        List<Map<String, String>> rejectDataList = this.getSelectedMemberScope(entityName);
        List<RejectUserDto> rejectUserList = RejectBillService.getInstance().getRejectUserList(billNo.toString(), rejectDataList, null, this.getModelId(), this.getDatasetId(entityName), entryTemplateConfig);
        rejectUserList = this.filterRejectUser(rejectUserList, entityName, entryTemplateConfig);
        return rejectUserList;
    }

    @Override
    protected void beforeFinishSaveData(BillSaveEventArgs saveEventArgs) {
        super.beforeFinishSaveData(saveEventArgs);
        this.saveAuditRecord(this.getEntryInfoFromFormParam(), saveEventArgs.getAllChangeRecord(), this.getIModelCacheHelper(), this.getView().getFormShowParameter());
    }

    @Override
    protected void getDataForSelectRows(String entityKey, int[] selectRows, int valLength, List<BaseColumn> main_columns, EntryTemplateConfig entryTemplateConfig, Set<String> currencyColumnKeys, BigDecimal unitData, List<Object[]> result) {
        String billNumber = this.getBillNumber();
        for (int rowIndex : selectRows) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity(entityKey, rowIndex);
            Long rowId = rowObj.getLong("id");
            if (rowId.equals(0L)) continue;
            int index = ApplyBillConstant.fixEntityTableKey.length;
            Object[] rowVal = new Object[valLength];
            rowVal[0] = rowId;
            rowVal[1] = this.billType;
            rowVal[2] = billNumber;
            rowVal[3] = EntityRowDataType.EDIT_DETAIL.getNumber();
            for (BaseColumn column : main_columns) {
                Object o = rowObj.get(column.getKey());
                rowVal[index] = column.getFieldtype() == FieldTypeEnum.BaseDataField ? (o == null ? Long.valueOf(0L) : ((DynamicObject)o).getPkValue()) : o;
                ++index;
            }
            result.add(rowVal);
        }
    }

    @Override
    protected void addCustomColumn(ColumnsContext columnsContext) {
        super.addCustomColumn(columnsContext);
        this.addAuditCustomColumn(columnsContext);
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryname = entryGrid.getEntryKey();
        this.refreshBizPlanTabs(row, entryname);
        this.entryentityRowClickToRefreshBizEntry(row, entryname);
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.doBizPlanUpAfterDelRow(e);
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.doBizPlanUpAfterAddRow(e);
    }

    @Override
    protected void saveBillData(BillSaveEventArgs eventArgs) {
        BgApplyENtryInfo entryInfo = this.getEntryInfoFromFormParam();
        String billNumber = this.getBillNumber();
        Map<String, Map<Long, Map<String, Object>>> preChangeAuditData = this.getOrCacheColumnInitData(null);
        HashMap newRowId = new HashMap(16);
        HashMap toDelRowIndexs = new HashMap(16);
        Long userId = IDUtils.toLong((Object)RequestContext.get().getUserId());
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        DBRoute route = new DBRoute("epm");
        HashMap<String, ArrayList<AuditRecordObj>> allChangeRecord = new HashMap<String, ArrayList<AuditRecordObj>>(16);
        for (Map.Entry entry : entryInfo.getEntryTemplateConfig().entrySet()) {
            String entityKey = (String)entry.getKey();
            if (!this.isMainEntry(entityKey)) continue;
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)entry.getValue();
            BigDecimal unitData = this.getUnitData(templateConfig.getUnit());
            HashMap<Integer, Long> rowIds = new HashMap<Integer, Long>(16);
            Map<Long, Map<String, Object>> entityPreChangeRecord = preChangeAuditData.get(entityKey);
            this.updateAuditRecord(templateConfig.getCurrencyColumnKeys(), entityPreChangeRecord, unitData);
            newRowId.put(entityKey, rowIds);
            List main_columns = templateConfig.selectEntryColumnsNoDimText();
            main_columns.removeIf(BaseColumn::isIgnoreDB);
            Map columnIndexKey = templateConfig.getColumnIndex();
            String billType = this.getBillType();
            String dataType = EntityRowDataType.NEW_DETAIL.getNumber();
            int valLength = ApplyBillConstant.fixEntityTableKey.length + main_columns.size();
            ArrayList<Object[]> toSaveNewRowData = new ArrayList<Object[]>(16);
            Set<Long> changeIds = entityPreChangeRecord == null ? null : entityPreChangeRecord.keySet();
            ArrayList<Integer> toDelRowIndex = new ArrayList<Integer>(16);
            toDelRowIndexs.put(entityKey, toDelRowIndex);
            int rowIndex = -1;
            HashMap<String, Object> changedVal = new HashMap<String, Object>(16);
            HashMap toUpdateVals = new HashMap(16);
            ArrayList<AuditRecordObj> auditRecordObjs = new ArrayList<AuditRecordObj>(16);
            String subtotalKey = templateConfig.getSubtotalKey();
            for (DynamicObject row : this.getModel().getEntryEntity(entityKey)) {
                AuditRecordObj recordObj;
                ++rowIndex;
                Long rowId = row.getLong("id");
                boolean isNewRow = rowId.equals(0L);
                if ((changeIds == null || !changeIds.contains(rowId)) && !isNewRow) continue;
                Object[] rowVal = new Object[valLength];
                if (isNewRow) {
                    rowId = GlobalIdUtil.genGlobalLongId();
                    rowIds.put(rowIndex, rowId);
                    this.setDefaultColumnVal(rowVal, rowId, billType, billNumber, dataType);
                    this.selectRowVal(main_columns, row, rowVal, templateConfig.getCurrencyColumnKeys(), unitData);
                    Pair<Boolean, Boolean> checkResult = this.checkRowValDimAndModifColVal(rowVal, templateConfig.getModifKeys(), templateConfig.getDimKeysList(), columnIndexKey);
                    if (((Boolean)checkResult.p2).booleanValue()) {
                        toDelRowIndex.add(rowIndex);
                        rowIds.remove(rowIndex);
                        continue;
                    }
                    if (((Boolean)checkResult.p1).booleanValue()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b0\u589e\u884c\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"BgApplyBillPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    toSaveNewRowData.add(rowVal);
                    recordObj = this.selectNewRowAuditRecord(rowVal, templateConfig);
                    this.addBaseInfo2AuditReocrd(templateConfig, billNumber, recordObj, auditRecordObjs);
                    continue;
                }
                Map<String, Object> rowPreChangeRecord = entityPreChangeRecord.get(rowId);
                if (rowPreChangeRecord == null) continue;
                this.selectChangeVal(changedVal, row, templateConfig.getCurrencyColumnKeys(), unitData, rowPreChangeRecord.keySet(), templateConfig.selectColumnMap());
                if (!row.getBoolean(subtotalKey)) {
                    ApplyBillPluginUitl.selectToUpdateVal(changedVal, (String)templateConfig.getEntryTable(), (Long)userId, (Timestamp)now, (Long)rowId, toUpdateVals);
                }
                recordObj = this.selectOldRowAuditRecord(changedVal, row, rowPreChangeRecord, templateConfig, false, true);
                this.addBaseInfo2AuditReocrd(templateConfig, billNumber, recordObj, auditRecordObjs);
            }
            if (toSaveNewRowData.size() > 0) {
                String tableName = templateConfig.getEntryTable();
                String insertSql = ApplyTemplateUtils.buildInsertSql((String)tableName, (List)main_columns);
                this.updateModifInfo(toSaveNewRowData, userId, now);
                this.batchExecute(route, insertSql, toSaveNewRowData);
            }
            if (toUpdateVals.size() > 0) {
                for (Map.Entry toUpVal : toUpdateVals.entrySet()) {
                    this.batchExecute(route, (String)toUpVal.getKey(), (List)toUpVal.getValue());
                }
            }
            allChangeRecord.put(entityKey, auditRecordObjs);
        }
        eventArgs.setNewRowIndexMapId(newRowId);
        eventArgs.setAllChangeRecord(allChangeRecord);
        eventArgs.setToDelRowIndexs(toDelRowIndexs);
    }

    private void batchExecute(DBRoute route, String sql, List<Object[]> rowData) {
        DB.executeBatch((DBRoute)route, (String)sql, rowData);
    }

    @Override
    protected void afterInitEntityData() {
        super.afterInitEntityData();
        CentralAppShowInfo centralAppShowInfo = this.getCentralAppShowInfo();
        this.selectRowDimEnableMemb(centralAppShowInfo);
        this.initAdjustRecord(this.getCentralAppShowInfo(), this.getEntryInfoFromFormParam());
    }

    public Long getBillId() {
        return this.getCenBillId();
    }

    public void saveAttachment() {
        AttachmentPanel attachmentPanel = this.getAttachmentPanel();
        List attachmentData = attachmentPanel.getAttachmentData();
        Long billId = this.getBillId();
        HashMap<String, List> saveMap = new HashMap<String, List>(4);
        saveMap.put(KEY_ATTACHMENTPENAL, attachmentData);
        AttachmentServiceHelper.saveTempAttachments((String)"eb_centralappbill", (Object)billId, (String)ApplicationTypeEnum.BGMD.getAppnum(), saveMap);
    }

    @Override
    protected void afterSaveData(BillSaveEventArgs eventArgs) {
        this.fillNewRowIdAndDelEmptyRow(eventArgs.getNewRowIndexMapId(), eventArgs.getToDelRowIndexs());
        super.afterSaveData(eventArgs);
        this.cleanChangeCache();
        this.lockDimColumnAfterSave(eventArgs.getNewRowIndexMapId());
    }

    @Override
    protected void saveQuoteInfo(BillSaveEventArgs eventArgs) {
        this.saveQuteInfo4AuditBill(eventArgs);
    }

    @Override
    protected void saveAllTemplateDataToOlap(BillSaveEventArgs eventArgs) {
        this.saveAuditDataToOlap(eventArgs);
    }

    private void selectChangeVal(Map<String, Object> changedVal, DynamicObject rowObj, Set<String> currencyColumnKeys, BigDecimal unitData, Set<String> changedKeySet, Map<String, BaseColumn> columnMap) {
        changedVal.clear();
        for (String key : changedKeySet) {
            BaseColumn column = columnMap.get(key);
            if (column == null) continue;
            Object columnVal = this.selectColumnVal(column, rowObj, currencyColumnKeys, unitData);
            changedVal.put(column.getKey(), columnVal);
        }
    }

    private void lockDimColumnAfterSave(Map<String, Map<Integer, Long>> newRowId) {
        if (newRowId != null && newRowId.size() > 0) {
            IFormView formView = this.getView();
            newRowId.forEach((entryKey, indexMapId) -> {
                EntryTemplateConfig tempConfig = this.getTempConfig((String)entryKey);
                String[] toLockKeys = tempConfig.getDimKeysList().toArray(new String[1]);
                DynamicObjectCollection collection = this.getModel().getEntryEntity(entryKey);
                Collection newRowIds = indexMapId.values();
                for (int index = collection.size() - 1; index >= 0; --index) {
                    Long rowId = ((DynamicObject)collection.get(index)).getLong("id");
                    if (newRowIds.contains(rowId)) {
                        formView.setEnable(Boolean.valueOf(false), index, toLockKeys);
                        continue;
                    }
                    if (rowId != 0L) break;
                }
            });
        }
    }

    private void fillNewRowIdAndDelEmptyRow(Map<String, Map<Integer, Long>> newRowId, Map<String, List<Integer>> toDelRowIndexs) {
        for (String entityKey : this.getEntryInfoFromFormParam().getEntryTemplateConfig().keySet()) {
            List<Integer> integers;
            if (!this.isMainEntry(entityKey)) continue;
            Map<Integer, Long> indexMapId = newRowId.get(entityKey);
            if (!indexMapId.isEmpty()) {
                DynamicObjectCollection collection = this.getModel().getEntryEntity(entityKey);
                for (Map.Entry<Integer, Long> idMap : indexMapId.entrySet()) {
                    ((DynamicObject)collection.get(idMap.getKey().intValue())).set("id", (Object)idMap.getValue());
                }
            }
            if ((integers = toDelRowIndexs.get(entityKey)) == null) continue;
            int[] indexs = integers.stream().mapToInt(Integer::intValue).toArray();
            this.getModel().deleteEntryRows(entityKey, indexs);
        }
    }

    @Override
    protected void initBillBaseInfo() {
        super.initBillBaseInfo();
        this.setAuditTypeBillBaseInfo();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    protected void setCellsStatus(BillFieldStatus fieldStatus) {
        super.setCellsStatus(fieldStatus);
        this.lockBizSumColumn();
    }

    @Override
    protected List<Long> getTempIdsFromFormParam(FormShowParameter formShowParameter) {
        return this.queryTempIdsByAuditConfig(formShowParameter);
    }

    @Override
    protected void setButtonStatus(BillFieldStatus fieldStatus) {
        super.setButtonStatus(fieldStatus);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_queryplan);
        fieldStatus.addShowKeys(new String[]{"statistics"});
        this.setAuditTypeBillBtnStatus(fieldStatus);
    }

    @Override
    protected void setColumnStatus(BillFieldStatus fieldStatus) {
        super.setColumnStatus(fieldStatus);
        this.addLog("applyaudit:showinfo", this.getCentralAppShowInfo());
        this.filterMetricCol4AuditBill(fieldStatus, this.getCentralAppShowInfo());
    }

    @Override
    protected void initSetRowRejectTxt() {
        Map entryTemplateConfigMap = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        for (Map.Entry entry : entryTemplateConfigMap.entrySet()) {
            String entityName = (String)entry.getKey();
            if (entityName.startsWith("bizentryentity")) continue;
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)entry.getValue();
            List mainColumn = templateConfig.getEntryColumns();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityName);
            List logs = RejectBillService.getInstance().listRejectLogBySpnumber(this.getBillNumber(), Long.valueOf(templateConfig.getTemplateID()));
            HashSet rowDimKeySets = new HashSet(templateConfig.getDimKeysList());
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                boolean subtotalstatus = row.getBoolean(templateConfig.getSubtotalKey());
                if (subtotalstatus) continue;
                ArrayList<Long> dimMemberIdList = new ArrayList<Long>(10);
                for (BaseColumn column : mainColumn) {
                    Object o;
                    String columnKey = column.getKey();
                    if (!rowDimKeySets.contains(columnKey) || "".equals(o = row.get(columnKey)) || o == null) continue;
                    Object memberId = ((DynamicObject)o).getPkValue();
                    dimMemberIdList.add(ConvertUtils.toLong((Object)memberId));
                }
                String rejectStatusTxt = RejectBillService.getInstance().getRejectStatusTxtByRowDimKey(dimMemberIdList.stream().map(Object::toString).collect(Collectors.joining(",")), templateConfig, logs);
                Optional<String> opt = mainColumn.stream().map(BaseColumn::getKey).filter(e -> e.startsWith(ApplyTemplateUtils.FIELD_REJECT_STATUS)).findFirst();
                if (!opt.isPresent()) continue;
                String rejectColumnKey = opt.get();
                this.getModel().setValue(rejectColumnKey, (Object)rejectStatusTxt, i);
                this.lockRejectRow(mainColumn, i, rejectStatusTxt);
            }
        }
    }

    @Override
    protected boolean needClearNotDetail() {
        return true;
    }

    @Override
    protected Map<String, List<Object[]>> getBillDataFromDB(BgApplyENtryInfo bgApplyENtryInfo) {
        return this.getAuditBillData(bgApplyENtryInfo, true);
    }

    @Override
    protected void fillEntryData(Map<String, List<Object[]>> billDataFromDB) {
        this.dealEntryData(billDataFromDB);
    }

    @Override
    protected void setOtherControlStatus(BillFieldStatus fieldStatus) {
        super.setOtherControlStatus(fieldStatus);
        fieldStatus.addDisableKeys(new String[]{"flexpanelap5"});
        this.lockBizPlanCheckBox(fieldStatus);
        this.dealDisableDimMemb(fieldStatus, this.getEntryInfoFromFormParam());
        this.setAdjustedColumnSign(this.getEntryInfoFromFormParam());
    }

    private void lockBizPlanCheckBox(BillFieldStatus fieldStatus) {
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        for (Map.Entry entry : entryTemplateConfig.entrySet()) {
            if (!((String)entry.getKey()).startsWith("entryentity")) continue;
            fieldStatus.addColumnDisableKeys(new String[]{((EntryTemplateConfig)entry.getValue()).getBusPlanDetailKey()});
        }
    }

    @Override
    protected FormShowParameter getAdjustRecordForm(EntryTemplateConfig entryTemplateConfig, DynamicObject currentRowObj, String entityNumber) {
        HashMap dims = new HashMap(16);
        Map columnMapDimNum = entryTemplateConfig.selectColumnMapDimNum();
        List dimKeysList = entryTemplateConfig.getDimKeysList();
        for (String dimKey : dimKeysList) {
            DynamicObject dimObj = currentRowObj.getDynamicObject(dimKey);
            if (dimObj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5168\u3002", (String)"BgApplyBillPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            dims.put(columnMapDimNum.get(dimKey), dimObj.getString("number"));
        }
        log.info("showAdjInfo:" + this.getBillNumber() + " dimInfo:" + ((Object)dims).toString());
        FormShowParameter adjustShowPage = CentralAppBillService.getInstance().getAdjustShowPage(this.getBillNumber(), null, dims, Long.valueOf(entryTemplateConfig.getTemplateID()), AdjustShowTypeEnum.Adjust, ApplyBillType.APPLYAUDIT, Long.valueOf(entryTemplateConfig.getDatasetId()), this.getModelId());
        return adjustShowPage;
    }

    @Override
    protected BaseShowParameter getStatsShowParameter() {
        BaseShowParameter baseShowParameter = BgApplyBillHelper.getInstance().getBgApplyTypeBillFormShow(this.getModelId(), this.getBillNumber(), ApplyBillType.AUDITSTATISTICS);
        String cacheStr = (String)this.getView().getFormShowParameter().getCustomParam("applyAuditParam");
        baseShowParameter.setCustomParam("applyAuditParam", (Object)cacheStr);
        return baseShowParameter;
    }

    @Override
    protected void mainEntryEntityExport() {
        Map<String, Long> templateIds = this.getTemplateIds();
        Map<Long, List<String>> enableCols = this.getEnableEditCols(templateIds);
        Map<String, String> entityUnitSet = this.getOrCacheEntityUnitSet(null);
        String fieldStatus = this.getView().getPageCache().get("fieldStatus");
        BillFieldStatus HideFieldStatus = null;
        if (fieldStatus != null && (HideFieldStatus = (BillFieldStatus)SerializationUtils.fromJsonString((String)fieldStatus, BillFieldStatus.class)) != null) {
            BillFieldStatus finalHideFieldStatus = HideFieldStatus;
            templateIds.entrySet().removeIf(e -> finalHideFieldStatus.getHideKeys().contains(((String)e.getKey()).replaceAll("entryentity", "tabentryentity")));
        }
        SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(this.getModelId(), this.getReportSchemeId(), this.getYearId(), this.getVersionId(), this.getDataTypeId());
        HashMap<String, Map<String, Map<String, String>>> RowDimMemberMap = new HashMap<String, Map<String, Map<String, String>>>(templateIds.size());
        HashMap<String, Map<String, Map<String, String>>> otherDimMemberMap = new HashMap<String, Map<String, Map<String, String>>>(templateIds.size());
        this.getRowDimMap(templateIds, RowDimMemberMap, otherDimMemberMap);
        BgApplyAuditDataExportPlugin.getInstance().colExport(null, templateIds, this.getModelId(), this.getView(), this.getBillNumber(), enableCols, entityUnitSet, null, Boolean.valueOf(false), schemeAssignDimGroup, RowDimMemberMap, null, otherDimMemberMap);
    }

    private void getRowDimMap(Map<String, Long> templateIds, Map<String, Map<String, Map<String, String>>> RowDimMemberMap, Map<String, Map<String, Map<String, String>>> otherDimMemberMap) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (String entryKey : templateIds.keySet()) {
            LinkedHashMap<String, HashMap<String, String>> RowDimMap = new LinkedHashMap<String, HashMap<String, String>>(templateIds.size());
            LinkedHashMap otherDimMap = new LinkedHashMap(templateIds.size());
            DynamicObjectCollection entryData = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
            EntryTemplateConfig tempConfig = this.getTempConfig(entryKey);
            Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(tempConfig.getDatasetId()));
            if (entryData == null) continue;
            for (int i = 0; i < entryData.size(); ++i) {
                HashMap<String, String> rowMap = new HashMap<String, String>(entryData.size());
                HashMap<String, String> otherMap = new HashMap<String, String>(entryData.size());
                DynamicObject entryDataObj = (DynamicObject)entryData.get(i);
                for (BaseColumn baseColumn : tempConfig.getEntryColumns()) {
                    DimensionColumn rowDimensionColumn;
                    String dimNumber = null;
                    String key = null;
                    if (baseColumn instanceof DimensionColumn) {
                        rowDimensionColumn = (DimensionColumn)baseColumn;
                        dimNumber = rowDimensionColumn.getDimNumber();
                        key = rowDimensionColumn.getKey();
                        this.getRowDimMap(modelCacheHelper, rowMap, entryDataObj, dimNumber, key, dimViewMap);
                        continue;
                    }
                    if (baseColumn instanceof RowDimensionColumn) {
                        rowDimensionColumn = (RowDimensionColumn)baseColumn;
                        dimNumber = rowDimensionColumn.getDimNumber();
                        key = rowDimensionColumn.getKey();
                        this.getRowDimMap(modelCacheHelper, rowMap, entryDataObj, dimNumber, key, dimViewMap);
                        continue;
                    }
                    key = "f" + baseColumn.getKey();
                    Object value = entryDataObj.get(baseColumn.getKey());
                    if (value == null) continue;
                    otherMap.put(key, String.valueOf(value));
                }
                RowDimMap.put(entryDataObj.getString("id"), rowMap);
                otherDimMap.put(entryDataObj.getString("id"), otherMap);
            }
            RowDimMemberMap.put(entryKey, RowDimMap);
            otherDimMemberMap.put(entryKey, otherDimMap);
        }
    }

    private void getRowDimMap(IModelCacheHelper modelCacheHelper, HashMap<String, String> rowMap, DynamicObject entryDataObj, String dimNumber, String key, Map<String, Long> dimViewMap) {
        DynamicObject dynamicObject = entryDataObj.getDynamicObject(key);
        if (dynamicObject != null) {
            Member member = modelCacheHelper.getMember(dimNumber, dimViewMap.get(dimNumber), Long.valueOf(dynamicObject.getLong("id")));
            if (member == null) {
                return;
            }
            rowMap.put(dimNumber, member.getNumber());
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.dealMemberShowTypeChange();
    }

    @Override
    protected boolean isChangeShowType(String[] split) {
        return split.length == 2 && split[1].equals("menuInfoClick");
    }

    @Override
    protected String getInitMemberShowType(String[] split) {
        return null;
    }

    @Override
    protected String getMemberShowTypeNumber() {
        return "changemembershow";
    }

    @Override
    protected void setMemberShowInfoBtnStatus(BillFieldStatus fieldStatus) {
        fieldStatus.addHideKeys(new String[]{"btn_changeshow0", "btn_changeshow1", "btn_changeshow2"});
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.contains(this.getMemberShowTypeNumber())) {
            this.updateEntryMemberShow(operateKey);
        }
    }

    private void updateEntryMemberShow(String operateKey) {
        String memberShowType;
        String type = operateKey.replace(this.getMemberShowTypeNumber(), "");
        if (type.equals(memberShowType = this.getView().getPageCache().get("memberShowType"))) {
            return;
        }
        this.getView().getPageCache().put("memberShowType", type);
        String currentEntityKey = this.getCurrentEntityKey();
        EntryTemplateConfig tempConfig = this.getTempConfig(currentEntityKey);
        EntryAp entryAp = this.createEntryAp(currentEntityKey, tempConfig);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map control = entryAp.createControl();
        clientViewProxy.preInvokeControlMethod(currentEntityKey, "createGridColumns", new Object[]{control});
    }

    @Override
    protected boolean isCacheMemberShowType() {
        return false;
    }
}

