/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applybill.util.CustomSelectUtil;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimRangeService;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.examinev2.service.ExamineCheckReportServiceImpl;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.AggTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBillEntityData;
import kd.epm.eb.common.applybill.ApplyBillEntityNodeData;
import kd.epm.eb.common.applybill.ApplyBillPathNodeHelper;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.AuditRecordObj;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.BillSaveEventArgs;
import kd.epm.eb.common.applybill.CellGroupStatusEnum;
import kd.epm.eb.common.applybill.ColumnsContext;
import kd.epm.eb.common.applybill.DetailMembBillData;
import kd.epm.eb.common.applybill.EntityCellBaseData;
import kd.epm.eb.common.applybill.EntityPathNode;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.applybill.RowDataStatus;
import kd.epm.eb.common.applybill.RowIndexInfo;
import kd.epm.eb.common.applybill.RowInfo;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applybill.ViewDataWayEnum;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationValueColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.SourceTextEnum;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.centralapproval.CustomSelectGroup;
import kd.epm.eb.common.centralapproval.CustomSelectItem;
import kd.epm.eb.common.centralapproval.CustomSelectItemSetting;
import kd.epm.eb.common.centralapproval.CustomShowParam;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.examine.bo.ExamineCheckMemGroup;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReportV1;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.util.ExamineReportUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.applybill.BgApplyBillBasePlugin;
import kd.epm.eb.formplugin.applybill.fileImport.BgStatisticsDataExportPlugin;
import org.apache.commons.lang3.StringUtils;

public class BgApplyBillMultColTreePlugin
extends BgApplyBillBasePlugin {
    protected Map<String, ApplyBillEntityNodeData> allNodeEntryData = null;
    protected Map<String, DetailMembBillData> allDetailData = null;
    private static final String LEVELCOLUMNPREKEY = "h_level_";

    protected void dealDimColumnChange4CollectBill(PropertyChangedArgs e) {
        String itemKey = e.getProperty().getName();
        if ((this.isCollectBill() || this.isCollectAuditBill() || this.isSplitBill()) && e.getProperty() instanceof BasedataProp && itemKey.startsWith("h_")) {
            String entityKey = e.getProperty().getParent().getName();
            EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityKey);
            if (entryTemplateConfig.getDimKeysList().contains(itemKey)) {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                String refKey = itemKey + "_text";
                Object refNameText = this.getModel().getValue(refKey, rowIndex);
                if (newValue == null && !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)((String)refNameText))) {
                    this.getModel().setValue(refKey, null);
                } else if (newValue != null) {
                    this.getModel().setValue(refKey, (Object)newValue.getString("name"), rowIndex);
                }
            }
        }
    }

    protected void dealDimTextColumnChange(PropertyChangedArgs e) {
        String itemKey = e.getProperty().getName();
        if ((this.isCollectBill() || this.isCollectAuditBill() || this.isSplitBill()) && itemKey.endsWith("_text")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)newValue)) {
                if (itemKey.startsWith(ApplyTemplateUtils.FIELD_REJECT_STATUS)) {
                    return;
                }
                String refDimKey = itemKey.replace("_text", "");
                Object dimMemb = this.getModel().getValue(refDimKey, rowIndex);
                if (dimMemb != null) {
                    this.getModel().setValue(refDimKey, null, rowIndex);
                }
            }
        }
    }

    protected Long getOrCacheLastCollectOrg(Long orgId) {
        if (orgId == null) {
            String lastCollectOrg = this.getPageCache().get("LastCollectOrg");
            if (lastCollectOrg != null) {
                orgId = Long.valueOf(lastCollectOrg);
            }
        } else {
            this.getPageCache().put("LastCollectOrg", orgId.toString());
        }
        return orgId;
    }

    @Override
    protected void dealModifColumnCellChange(String entityKey, Object newValue, Object oldValue, Long currentRowId, String columnKey, int rowIndex) {
        Object[] rows;
        Object oldValueCopy = oldValue;
        ApplyBillEntityNodeData billEntityNodeData = this.getOrCacheBillEntityNodeData(entityKey, null);
        ApplyBillEntityData billEntityData = billEntityNodeData.getCurrentNodeData();
        int currentRowIndexOfCacheEntry = billEntityData.getRowIndexByRowId(currentRowId);
        DetailMembBillData detailMembBillData = this.getOrCacheDetailData(entityKey, null);
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        StringBuilder sb = new StringBuilder();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Map<String, Long> viewIds = this.getViewIds();
        Map columnMapDimNum = tempConfig.selectColumnMapDimNum();
        this.cacheEntityCellChange(billEntityData, currentRowId, newValue, columnKey);
        boolean isDetail = true;
        for (String key : tempConfig.getDimKeysList()) {
            EntityCellBaseData cellBaseData = billEntityData.getCellBaseData(currentRowIndexOfCacheEntry, key);
            String dimNum = (String)columnMapDimNum.get(key);
            Member member = modelCacheHelper.getMember(dimNum, viewIds.get(dimNum), cellBaseData.getId());
            if (member != null && !member.isLeaf()) {
                isDetail = false;
            }
            sb.append(cellBaseData.getId()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        RowDataStatus rowDataStatus = (RowDataStatus)detailMembBillData.getDetailRowStatus().get(sb.toString());
        Map columnIndexMap = tempConfig.getColumnIndex();
        Set aggKeys = tempConfig.getAggKeys();
        Integer index = (Integer)columnIndexMap.get(columnKey);
        if (rowDataStatus == null) {
            Integer columnIndex;
            rows = new Object[((Object[])detailMembBillData.getAllRowData().get(0)).length];
            for (String key : billEntityData.getBaseDataKeys()) {
                columnIndex = (Integer)columnIndexMap.get(key);
                rows[columnIndex.intValue()] = billEntityData.getCellBaseData(currentRowIndexOfCacheEntry, key).getId();
            }
            for (String key : billEntityData.getOtherDataKeys()) {
                columnIndex = (Integer)columnIndexMap.get(key);
                rows[columnIndex.intValue()] = billEntityData.getCellOtherData(currentRowIndexOfCacheEntry, key);
                if (!aggKeys.contains(key)) continue;
                rows[columnIndex.intValue()] = null;
            }
            if (aggKeys.contains(columnKey)) {
                if (oldValue == null) {
                    oldValue = this.getZero();
                }
                BigDecimal subData = ((BigDecimal)newValue).subtract((BigDecimal)oldValue);
                rows[index.intValue()] = subData;
                oldValue = this.getZero();
            }
            this.addNewRow(rows, billEntityData.getRowIbByIndex(currentRowIndexOfCacheEntry), isDetail, detailMembBillData, sb.toString());
        } else {
            rows = (Object[])detailMembBillData.getAllRowData().get(rowDataStatus.getRowIndex());
            if (aggKeys.contains(columnKey)) {
                Object oldSubData = rows[index];
                if (rowDataStatus.isDetail()) {
                    rows[index.intValue()] = newValue;
                } else {
                    BigDecimal subData = ((BigDecimal)newValue).subtract((BigDecimal)oldValue);
                    rows[index.intValue()] = oldSubData == null ? subData : subData.add((BigDecimal)oldSubData);
                }
                oldValue = oldSubData;
            } else {
                rows[index.intValue()] = newValue;
            }
        }
        this.recordColumnInitData(entityKey, currentRowId, oldValue, columnKey);
        if (aggKeys.contains(columnKey)) {
            this.updateAggDataToForm(entityKey, Collections.singleton(columnKey), null, rowIndex, false);
        }
        this.dealOthModifColumnCellChange(entityKey, newValue, oldValueCopy, currentRowId, columnKey, rowIndex);
        this.getOrCacheDetailData(entityKey, detailMembBillData);
        this.getOrCacheBillEntityNodeData(entityKey, billEntityNodeData);
    }

    public void addNewRow(Object[] newRow, Long rowId, boolean isDetail, DetailMembBillData sourceData, String membIdStrs) {
        if (rowId == null) {
            rowId = GlobalIdUtil.genGlobalLongId();
        }
        newRow[0] = rowId;
        newRow[3] = isDetail ? EntityRowDataType.NEW_DETAIL.getNumber() : EntityRowDataType.NEW_NOTDETAIL.getNumber();
        RowDataStatus rowDataStatus = new RowDataStatus(isDetail, sourceData.getAllRowData().size(), true);
        sourceData.getDetailRowStatus().put(membIdStrs, rowDataStatus);
        sourceData.getAllRowData().add(newRow);
    }

    protected void dealOthModifColumnCellChange(String entityKey, Object newValue, Object oldValue, Long currentRowId, String columnKey, int rowIndex) {
    }

    @Override
    protected void saveAllTemplateDataToOlap(BillSaveEventArgs eventArgs) {
        eventArgs.setAllEntitySourceData(this.getAllSourceData());
        this.saveAuditDataToOlap(eventArgs);
    }

    @Override
    protected void afterSaveData(BillSaveEventArgs eventArgs) {
        super.afterSaveData(eventArgs);
        this.cleanChangeCache();
        if (eventArgs.isReloadPage()) {
            this.reloadEntityData();
            this.showMemberInfo();
        } else {
            this.delErrorRow(eventArgs.getToDelRowIndexs());
            this.setAllEntityNoChange();
        }
    }

    private void delErrorRow(Map<String, List<Integer>> toDelRowIndexs) {
        if (toDelRowIndexs != null) {
            toDelRowIndexs.forEach((entityKey, rowIndex) -> {
                if (rowIndex != null && rowIndex.size() > 0) {
                    int[] indexs = new int[rowIndex.size()];
                    for (int i = 0; i < rowIndex.size(); ++i) {
                        indexs[i] = (Integer)rowIndex.get(i);
                    }
                    this.getModel().deleteEntryRows(entityKey, indexs);
                }
            });
        }
    }

    private void setAllEntityNoChange() {
        Map<String, ApplyBillEntityNodeData> billEntityNodeData = this.getAllBillEntityNodeData();
        billEntityNodeData.forEach((entryKey, entityNodeData) -> {
            ApplyBillEntityData currentNodeData = entityNodeData.getCurrentNodeData();
            if (currentNodeData != null) {
                for (ApplyBillEntityData nodeData : entityNodeData.getNodeEntityData()) {
                    if (currentNodeData == nodeData) continue;
                    boolean hasChangeRow = this.syncChangeOnNodeData(currentNodeData, nodeData, null);
                    if (hasChangeRow) {
                        this.updateNowEntryAggData((String)entryKey, nodeData);
                    }
                    for (int i = 0; i < nodeData.getRowChanged().size(); ++i) {
                        nodeData.setRowChanged(i, false);
                    }
                }
                for (int i = 0; i < currentNodeData.getRowChanged().size(); ++i) {
                    currentNodeData.setRowChanged(i, false);
                }
            }
        });
        Map<String, DetailMembBillData> entrySourceData = this.getAllSourceData();
        entrySourceData.values().forEach(sourceData -> sourceData.getDetailRowStatus().forEach((k, status) -> status.setNewEdit(false)));
        this.cacheAllSourceData();
        this.cacheAllBillEntityNodeData(false);
    }

    @Override
    public void cellClick(CellClickEvent cellClickEvent) {
        super.cellClick(cellClickEvent);
        String columnKey = cellClickEvent.getFieldKey();
        if (this.isDimTextCol(columnKey)) {
            ApplyBillEntityNodeData entityNodeData;
            String currentDimColumnKey;
            int rowIndex = cellClickEvent.getRow();
            EntryGrid source = (EntryGrid)cellClickEvent.getSource();
            String entityKey = source.getEntryKey();
            DynamicObject rowObj = this.getModel().getEntryRowEntity(entityKey, rowIndex);
            if (rowObj == null) {
                return;
            }
            if (this.isNewRow(rowObj)) {
                if (this.beforeOpenF7Form(rowObj, columnKey, entityKey, rowIndex)) {
                    this.openF7Form(columnKey, entityKey, rowIndex);
                }
                return;
            }
            Object value = this.getModel().getValue(columnKey, rowIndex);
            if (value == null || !(value instanceof String)) {
                return;
            }
            String showName = (String)value;
            showName = showName.trim();
            if (!(columnKey = columnKey.replaceAll("_text", "")).equals(currentDimColumnKey = (entityNodeData = this.getOrCacheBillEntityNodeData(entityKey, null)).getCurrentDimColumnKey())) {
                if (this.dealDeffDimCellClick()) {
                    this.createNewNode(rowIndex, columnKey, entityKey, false);
                }
                this.examineCheckMarkerColor();
            } else {
                this.setNeedDealPropchange(false);
                if (showName.startsWith("+")) {
                    this.openChildRow(rowIndex, columnKey, entityKey, false);
                    this.examineCheckMarkerColor();
                } else if (showName.startsWith("-")) {
                    this.closeChildRow(rowIndex, columnKey, entityKey);
                }
                this.setNeedDealPropchange(true);
                this.upNodePathShow4CellClick(rowIndex, rowIndex, columnKey, entityKey, false);
                this.getOrCacheBillEntityNodeData(entityKey, entityNodeData);
            }
        }
    }

    private void examineCheckMarkerColor() {
        try {
            this.restoreCellColor();
            this.examineRemark();
        }
        catch (Exception e) {
            log.error("examine remark color error:", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u6807\u8bb0\u989c\u8272\u5931\u8d25\u3002", (String)"ReportPreparationListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void restoreCellColor() {
        String changeColorMapStr = this.getView().getPageCache().get("changeColorMapList");
        if (changeColorMapStr == null) {
            return;
        }
        List changeColorMapList = (List)SerializationUtils.fromJsonString((String)changeColorMapStr, ArrayList.class);
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        for (Map changeColorMap : changeColorMapList) {
            for (Map.Entry entry : changeColorMap.entrySet()) {
                AbstractGrid grid = (AbstractGrid)this.getView().getControl((String)entry.getKey());
                for (Map.Entry rowColEntry : ((Map)entry.getValue()).entrySet()) {
                    for (String rowkey : (List)rowColEntry.getValue()) {
                        csList.clear();
                        CellStyle cs = new CellStyle();
                        cs.setBackColor("#ffffff");
                        cs.setFieldKey(rowkey);
                        cs.setRow(Integer.parseInt((String)rowColEntry.getKey()));
                        csList.add(cs);
                        grid.setCellStyle(csList);
                    }
                }
            }
        }
    }

    private void examineRemark() {
        Long billId = this.getBillId();
        if (billId == null || billId == 0L) {
            return;
        }
        List examineCheckReportV1List = ExamineCheckReportServiceImpl.getInstance().queryCheckReportByReportProcessListNew(Collections.singletonList(this.getBillId()));
        if (examineCheckReportV1List == null || examineCheckReportV1List.isEmpty()) {
            return;
        }
        Set examineNumbers = examineCheckReportV1List.stream().map(ExamineCheckReportV1::getExamineNumber).collect(Collectors.toSet());
        Map examineSignColor = ExamineServiceImpl.getInstance().getExamineSignColor(examineNumbers, this.getModelId());
        this.updateCellColorByExamineCheckResult(examineCheckReportV1List, examineSignColor);
    }

    @Override
    public void updateCellColorByExamineCheckResult(List<ExamineCheckReportV1> examineCheckReportV1List, Map<String, String> examineNoPassSignColor) {
        if (examineCheckReportV1List == null || examineCheckReportV1List.isEmpty() || examineNoPassSignColor.size() == 0) {
            return;
        }
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        ArrayList<Map<String, Map<Integer, Set<String>>>> changeColorMapList = new ArrayList<Map<String, Map<Integer, Set<String>>>>(16);
        for (ExamineCheckReportV1 examineCheckReportV1 : examineCheckReportV1List) {
            if (examineCheckReportV1.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoExamine || examineCheckReportV1.getExamineCheckResultEnum() == ExamineCheckResultEnum.Pass) continue;
            List noPassMemberGroups = ExamineReportUtils.getNoPassMemberGroupV1((ExamineCheckReportV1)examineCheckReportV1);
            for (ExamineCheckMemGroup noPassMemberGroup : noPassMemberGroups) {
                Map<String, Map<Integer, Set<String>>> changeColorMap;
                if (noPassMemberGroup.getDimNums() == null || noPassMemberGroup.getDimNums().length == 0 || noPassMemberGroup.getMemberKeys().size() == 0 || (changeColorMap = this.obtainDimensionMember(entryInfoFromFormParam, noPassMemberGroup)).isEmpty()) continue;
                this.updateCellColorByPosition(changeColorMap, examineNoPassSignColor, examineCheckReportV1);
                changeColorMapList.add(changeColorMap);
            }
        }
        this.getView().getPageCache().put("changeColorMapList", SerializationUtils.toJsonString(changeColorMapList));
    }

    private void updateCellColorByPosition(Map<String, Map<Integer, Set<String>>> changeColorMap, Map<String, String> examineNoPassSignColor, ExamineCheckReportV1 examineCheckReportV1) {
        String backColor = examineNoPassSignColor.get(examineCheckReportV1.getExamineNumber());
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        for (Map.Entry<String, Map<Integer, Set<String>>> entry : changeColorMap.entrySet()) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(entry.getKey());
            for (Map.Entry<Integer, Set<String>> rowColEntry : entry.getValue().entrySet()) {
                for (String rowkey : rowColEntry.getValue()) {
                    csList.clear();
                    CellStyle cs = new CellStyle();
                    cs.setBackColor(backColor);
                    cs.setFieldKey(rowkey);
                    cs.setRow(rowColEntry.getKey().intValue());
                    csList.add(cs);
                    grid.setCellStyle(csList);
                }
            }
        }
    }

    @Override
    protected Map<String, Map<Integer, Set<String>>> obtainDimensionMember(BgApplyENtryInfo bgApplyENtryInfo, ExamineCheckMemGroup noPassMemberGroup) {
        String billType1 = this.getBillType();
        Map entryTemplateConfig = bgApplyENtryInfo.getEntryTemplateConfig();
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        Map viewMap = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
        HashMap<String, Map<Integer, Set<String>>> changeColorMap = new HashMap<String, Map<Integer, Set<String>>>(16);
        for (Map.Entry entry : entryTemplateConfig.entrySet()) {
            EntryTemplateConfig entryConfig = (EntryTemplateConfig)entry.getValue();
            String entityKey = (String)entry.getKey();
            EntryGrid control = (EntryGrid)this.getView().getControl(entityKey);
            DynamicObject[] entryData = control.getEntryData().getDataEntitys();
            if (entityKey.startsWith("bizentryentity") || entryData == null || entryData.length == 0) continue;
            ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
            ArrayList<BaseColumn> dimensionCols = new ArrayList<BaseColumn>(16);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List entryColumns = entryConfig.getEntryColumns();
            List columns = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
            for (BaseColumn column : columns) {
                if (column.getType() == ColumnEnum.RowDimension || column.getType() == ColumnEnum.RelationDimension) {
                    dimensionCols.add(column);
                    continue;
                }
                if (column.getType() != ColumnEnum.DimensionData) continue;
                measureCols.add(column);
            }
            Map columnIndexes = entryConfig.getColumnIndex();
            Map allColDimMembers = BgApplyBillUtils.getInstance().getAllColDimMembers(measureCols, Long.valueOf(entryConfig.getDatasetId()), modelCacheHelper, Boolean.valueOf(true));
            HashMap allRowDimMembers = new HashMap(16);
            for (int i = 0; i < entryData.length; ++i) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity(entityKey, i);
                HashMap<String, String> rowMemMap = new HashMap<String, String>(16);
                for (BaseColumn column : dimensionCols) {
                    String dimNumber = null;
                    if (column instanceof RowDimensionColumn) {
                        dimNumber = ((RowDimensionColumn)column).getDimNumber();
                    }
                    Object o = rowObj.get(column.getKey());
                    long memberId = (Long)((DynamicObject)o).getPkValue();
                    Member member = modelCacheHelper.getMember(dimNumber, (Long)viewMap.get(dimNumber), Long.valueOf(memberId));
                    if (member == null) continue;
                    rowMemMap.put(dimNumber, member.getNumber());
                }
                allRowDimMembers.put(i, rowMemMap);
            }
            Map hideDimMembers = BgApplyBillUtils.getInstance().getHideDimMembersFromTempConfig(modelCacheHelper, entryConfig);
            HashMap dimGroups = new HashMap(16);
            BgApplyBillUtils.getInstance().mergeMap(hideDimMembers, dimGroups);
            allRowDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap(e, dimGroups));
            allColDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap(e, dimGroups));
            HashSet<String> dimNumberSet = new HashSet<String>(Arrays.asList(noPassMemberGroup.getDimNums()));
            boolean isContains = dimNumberSet.containsAll(dimGroups.keySet());
            if (!isContains) continue;
            HashMap<Integer, Set> colorMap = new HashMap<Integer, Set>(16);
            for (String[] memberKey : noPassMemberGroup.getMemberKeys()) {
                Integer index = null;
                String key = null;
                HashSet<String> memberSet = new HashSet<String>(Arrays.asList(memberKey));
                for (Map.Entry mapEntry : allRowDimMembers.entrySet()) {
                    if (!memberSet.containsAll(((Map)mapEntry.getValue()).values())) continue;
                    index = (Integer)mapEntry.getKey();
                    break;
                }
                if (index == null) continue;
                for (Map.Entry colMapEntry : allColDimMembers.entrySet()) {
                    if (!memberSet.containsAll(((Map)colMapEntry.getValue()).values())) continue;
                    key = (String)colMapEntry.getKey();
                    break;
                }
                if (key == null) continue;
                colorMap.computeIfAbsent(index, k -> new HashSet(16)).add(key);
            }
            if (colorMap.isEmpty()) continue;
            changeColorMap.put(entityKey, colorMap);
        }
        return changeColorMap;
    }

    protected boolean dealDeffDimCellClick() {
        return true;
    }

    protected boolean isDimTextCol(String columnKey) {
        return columnKey.endsWith("_text") && !columnKey.startsWith(ApplyTemplateUtils.FIELD_REJECT_STATUS);
    }

    protected void upNodePathShow4CellClick(int currentIndex, int preIndex, String columnKey, String entityKey, boolean isUp) {
        boolean firstNode;
        ApplyBillEntityNodeData entityNodeData = this.getOrCacheBillEntityNodeData(entityKey, null);
        long rowId = this.getModel().getEntryRowEntity(entityKey, currentIndex).getLong("id");
        ApplyBillEntityData currentNodeData = entityNodeData.getCurrentNodeData();
        int rowIndexOnCache = currentNodeData.getRowIndexByRowId(Long.valueOf(rowId));
        EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(rowIndexOnCache, columnKey);
        List nodes = entityNodeData.getNodes();
        EntityPathNode lastNode = (EntityPathNode)nodes.get(nodes.size() - 1);
        boolean bl = firstNode = nodes.size() == 1;
        if (currentIndex == 0 && lastNode.isInitNode() && nodes.size() > 1 && !isUp) {
            return;
        }
        if (isUp) {
            if (lastNode.isInitNode()) {
                if (preIndex != 0 && !firstNode) {
                    EntityCellBaseData preBaseData = currentNodeData.getCellBaseData(currentIndex, lastNode.getRefDimColumnKey());
                    ApplyBillPathNodeHelper.addNewPathNode((boolean)false, (Long)lastNode.getPreNodeFocusRowId(), (String)preBaseData.getName(), (String)lastNode.getRefDimColumnKey(), (List)nodes);
                }
            } else if (preIndex != 0 && !firstNode) {
                EntityCellBaseData preBaseData = currentNodeData.getCellBaseData(currentIndex, lastNode.getRefDimColumnKey());
                lastNode.setNodeText(preBaseData.getName());
                lastNode.setPreNodeFocusRowId(Long.valueOf(rowId));
            } else {
                nodes.remove(nodes.size() - 1);
            }
            ApplyBillPathNodeHelper.addNewPathNode((boolean)isUp, (Long)rowId, (String)cellBaseData.getName(), (String)columnKey, (List)nodes);
        } else if (lastNode.isInitNode()) {
            ApplyBillPathNodeHelper.addNewPathNode((boolean)isUp, (Long)rowId, (String)cellBaseData.getName(), (String)columnKey, (List)nodes);
        } else {
            lastNode.setNodeText(cellBaseData.getName());
        }
        this.updatePathShow(entityKey, nodes);
    }

    private void createNewNode(int rowIndex, String columnKey, String entityKey, boolean isOpenAll) {
        ApplyBillEntityNodeData entityData = this.getOrCacheBillEntityNodeData(entityKey, null);
        ApplyBillEntityData currentNodeData = entityData.getCurrentNodeData();
        IDataModel dataModel = this.getModel();
        DynamicObject rowObj = dataModel.getEntryRowEntity(entityKey, rowIndex);
        if (rowObj == null) {
            return;
        }
        Long rowId = rowObj.getLong("id");
        int currentRowIndexOfCacheEntry = currentNodeData.getRowIndexByRowId(Long.valueOf(rowObj.getLong("id")));
        EntityCellBaseData clickCellData = currentNodeData.getCellBaseData(currentRowIndexOfCacheEntry, columnKey);
        if (clickCellData == null || clickCellData.isLeaf()) {
            return;
        }
        this.updateAllEntryModifiedData(entityKey, currentNodeData, null);
        int rowIndexOnCacheData = currentNodeData.getRowIndexByRowId(rowId);
        List<DynamicObject> newRowObjs = this.cacheNewRowB4ChangeNode(entityKey);
        dataModel.deleteEntryData(entityKey);
        ApplyBillEntityData newNodeData = new ApplyBillEntityData();
        for (String baseDataKey : currentNodeData.getBaseDataKeys()) {
            EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(rowIndexOnCacheData, baseDataKey);
            EntityCellBaseData cellBaseDataNew = cellBaseData.clone();
            cellBaseDataNew.setLevel(1);
            if (!cellBaseDataNew.isLeaf()) {
                cellBaseDataNew.setOpened(false);
                cellBaseDataNew.setGroupStatus(CellGroupStatusEnum.CLOSE);
                rowObj.set(baseDataKey + "_text", (Object)("+" + cellBaseDataNew.getName()));
            } else {
                rowObj.set(baseDataKey + "_text", (Object)cellBaseDataNew.getName());
            }
            newNodeData.addCellBaseData(0, baseDataKey, cellBaseDataNew);
        }
        for (String otherDataKey : currentNodeData.getOtherDataKeys()) {
            newNodeData.addCellOtherData(0, otherDataKey, currentNodeData.getCellOtherData(rowIndexOnCacheData, otherDataKey));
        }
        newNodeData.addRowId(0, rowId);
        newNodeData.getRowChanged().add(0, false);
        rowObj.set(this.getLevelColKey(this.getEntrySeqByMainEntryKey(entityKey)), (Object)1);
        dataModel.createNewEntryRow(entityKey, rowObj);
        entityData.addNodeData(newNodeData);
        this.upNodePathShow4CellClick(0, rowIndex, columnKey, entityKey, true);
        entityData.getCurrentNode().setOpenAll(isOpenAll);
        this.setNeedDealPropchange(false);
        this.openChildRow(0, columnKey, entityKey, isOpenAll);
        this.setNeedDealPropchange(true);
        this.getOrCacheBillEntityNodeData(entityKey, entityData);
        this.backNewRowAfterChangeNode(newRowObjs, entityKey);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object retData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("viewData".equals(actionId) && returnData != null) {
            this.updateEntityByViewData(returnData);
        } else if ("openCusDimSelForm".equals(actionId) && (retData = closedCallBackEvent.getReturnData()) instanceof Map) {
            String customDimJson = this.getPageCache().get("userSelCusDimOfExport");
            HashMap<Long, String> customDim = null;
            customDim = kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)customDimJson) ? (HashMap<Long, String>)SerializationUtils.deSerializeFromBase64((String)customDimJson) : new HashMap<Long, String>(16);
            Map retDataMap = (Map)retData;
            if (retDataMap.size() != 0) {
                this.mergeCustomDimMap(customDim, retDataMap);
                this.getPageCache().put("userSelCusDimOfExport", SerializationUtils.serializeToBase64(customDim));
            }
            this.mainEntryEntityExport();
        }
    }

    private void mergeCustomDimMap(Map<Long, String> customDim, Map<String, Object> retDataMap) {
        retDataMap.forEach((key, value) -> {
            List retValue = (List)value;
            if (retValue != null && retValue.size() > 0) {
                customDim.put(ConvertUtils.toLong((Object)key), (String)retValue.get(0));
            }
        });
    }

    private void updateEntityByViewData(Object returnData) {
        Map viewDataWay = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
        String currentEntityKey = this.getCurrentEntityKey();
        ApplyBillEntityNodeData entityNodeData = this.getOrCacheBillEntityNodeData(currentEntityKey, null);
        String currentDimColumnKey = entityNodeData.getCurrentDimColumnKey();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(currentEntityKey);
        String selectDimColumn = (String)viewDataWay.get("viewDimColumn");
        String viewWay = (String)viewDataWay.get("viewWay");
        boolean isOpenAll = ViewDataWayEnum.ALLDETAIL.getNumber().equals(viewWay);
        if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)currentDimColumnKey, (CharSequence)selectDimColumn) || currentRowIndex != 0) {
            this.createNewNode(currentRowIndex, selectDimColumn, currentEntityKey, isOpenAll);
        } else {
            EntityPathNode currentNode = entityNodeData.getCurrentNode();
            if (currentNode.isInitNode()) {
                ApplyBillPathNodeHelper.addNewPathNode((boolean)false, (Long)currentNode.getPreNodeFocusRowId(), (String)currentNode.getNodeText(), (String)currentDimColumnKey, (List)entityNodeData.getNodes());
            }
            if (!isOpenAll) {
                this.backToNode(currentNode.getNodeKey(), true);
            } else {
                IDataModel dataModel = this.getModel();
                List<DynamicObject> newRowObjs = this.cacheNewRowB4ChangeNode(currentEntityKey);
                DynamicObject rowObj = dataModel.getEntryRowEntity(currentEntityKey, 0);
                dataModel.deleteEntryData(currentEntityKey);
                dataModel.createNewEntryRow(currentEntityKey, rowObj);
                this.setNeedDealPropchange(false);
                this.openChildRow(0, currentDimColumnKey, currentEntityKey, true);
                dataModel.updateEntryCache(dataModel.getEntryEntity(currentEntityKey));
                this.setNeedDealPropchange(true);
                this.getOrCacheBillEntityNodeData(currentEntityKey, entityNodeData);
                this.backNewRowAfterChangeNode(newRowObjs, currentEntityKey);
                this.updatePathShow(currentEntityKey, entityNodeData.getNodes());
            }
        }
    }

    protected void updatePathShow(String entityKey, List<EntityPathNode> allNode) {
        String seq = entityKey.replace("entryentity", "");
        String pathContrlKey = "path" + seq;
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(pathContrlKey);
        flexPanelAp.setId(pathContrlKey);
        for (int i = 0; i < allNode.size(); ++i) {
            EntityPathNode pathNode = allNode.get(i);
            LabelAp labelAp = new LabelAp();
            labelAp.setKey(pathNode.getNodeKey());
            labelAp.setName(new LocaleString(pathNode.getNodeText()));
            flexPanelAp.getItems().add(labelAp);
            if (i == allNode.size() - 1) {
                labelAp.setClickable(false);
                continue;
            }
            labelAp.setClickable(true);
            labelAp.setForeColor("blue");
            LabelAp labelSignAp = new LabelAp();
            labelSignAp.setKey(pathNode.getNodeKey() + "_sign");
            labelSignAp.setName(new LocaleString(">>"));
            flexPanelAp.getItems().add(labelSignAp);
        }
        this.getView().updateControlMetadata(flexPanelAp.getKey(), flexPanelAp.createControl());
    }

    protected void initRowDataToCache(int beginIndex, String baseEditKey, String entityKey, Long currentMembId, List<Member> members, Set<String> allAggColumnKeys) {
        ApplyBillEntityNodeData entityNodeData = this.getOrCacheBillEntityNodeData(entityKey, null);
        ApplyBillEntityData entityData = entityNodeData.getCurrentNodeData();
        int cacheRowIndex = this.getCacheRowIndex(beginIndex, baseEditKey, currentMembId, entityData);
        if (cacheRowIndex == -1) {
            return;
        }
        EntityCellBaseData currentCellData = entityData.getCellBaseData(cacheRowIndex, baseEditKey);
        if (currentCellData == null || currentCellData.isLeaf()) {
            return;
        }
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        DetailMembBillData billDetailData = this.getOrCacheDetailData(entityKey, null);
        Map columnIndex = tempConfig.getColumnIndex();
        int newRowIndex = cacheRowIndex;
        boolean isFormCache = currentCellData.isOpened();
        if (!isFormCache) {
            if (members.isEmpty()) {
                return;
            }
            boolean isMainBill = this.isMainBill();
            Map<Integer, Map<String, String>> noDetailMembers = this.getNoDetailMembers(entityData, baseEditKey, cacheRowIndex, members);
            Map aggColumnDataMap = BgApplyBillUtils.getInstance().getOlapDataForNoDetail(tempConfig, noDetailMembers, allAggColumnKeys);
            ArrayList<Member> toDelMembs = new ArrayList<Member>(16);
            int row = 0;
            for (Member child : members) {
                HashMap<String, String> dimMembParam = new HashMap<String, String>(16);
                HashMap<String, String> dimMembIdParam = new HashMap<String, String>(16);
                Set baseDataKeys = entityData.getBaseDataKeys();
                HashMap<String, EntityCellBaseData> cellMap = new HashMap<String, EntityCellBaseData>(16);
                for (String columnKey : baseDataKeys) {
                    EntityCellBaseData cellData;
                    if (columnKey.equals(baseEditKey)) {
                        cellData = new EntityCellBaseData();
                        cellData.setNumber(child.getNumber());
                        cellData.setName(child.getName());
                        if (!child.isLeaf()) {
                            cellData.setLeaf(false);
                            cellData.setGroupStatus(CellGroupStatusEnum.CLOSE);
                        } else {
                            cellData.setLeaf(true);
                            cellData.setGroupStatus(CellGroupStatusEnum.NONE);
                        }
                        cellData.setId(child.getId());
                        cellData.setOpened(false);
                        cellData.setLevel(currentCellData.getLevel() + 1);
                    } else {
                        EntityCellBaseData pCellData = entityData.getCellBaseData(cacheRowIndex, columnKey);
                        cellData = pCellData.clone();
                        if (pCellData.isOpened()) {
                            cellData.setGroupStatus(CellGroupStatusEnum.NONE);
                        }
                    }
                    cellMap.put(columnKey, cellData);
                    dimMembParam.put(columnKey, cellData.getNumber());
                    dimMembIdParam.put(columnKey, cellData.getId().toString());
                }
                HashSet<Long> matchChildRowIds = new HashSet<Long>(16);
                Map bizData = null;
                ArrayList numberColumnKeys = new ArrayList(tempConfig.getEntryColumns().size());
                tempConfig.getEntryColumns().forEach(col -> {
                    if (col instanceof NumberColumn) {
                        numberColumnKeys.add(col.getKey());
                    }
                });
                if (isMainBill) {
                    Object unitData = this.getUnitData(tempConfig.getUnit());
                    List columns = tempConfig.getEntryColumns();
                    unitData = BigDecimal.ONE.divide((BigDecimal)unitData);
                    Map<Object, Object> newDataMap = Maps.newHashMap();
                    if (aggColumnDataMap != null && aggColumnDataMap.get(row) != null) {
                        newDataMap = this.changeBigDecimalUnit((Map)aggColumnDataMap.get(row), (BigDecimal)unitData, columns, tempConfig.getCurrencyColumnKeys());
                    }
                    if (CollectionUtils.isNotEmpty((Map)(bizData = ApplyBillAggHelper.getInstance().getDataNew(dimMembParam, billDetailData, allAggColumnKeys, tempConfig, matchChildRowIds, (Map)newDataMap))) && !numberColumnKeys.isEmpty()) {
                        Map bizDataNumber = ApplyBillAggHelper.getInstance().getData(dimMembParam, billDetailData, allAggColumnKeys, tempConfig, false, matchChildRowIds);
                        for (String columnKey : numberColumnKeys) {
                            bizData.put(columnKey, bizDataNumber.get(columnKey));
                        }
                    }
                    ++row;
                } else {
                    bizData = ApplyBillAggHelper.getInstance().getData(dimMembParam, billDetailData, allAggColumnKeys, tempConfig, false, matchChildRowIds);
                }
                if (!this.childRowCanShow(bizData, tempConfig, entityKey, matchChildRowIds)) {
                    toDelMembs.add(child);
                    continue;
                }
                entityData.getRowChanged().add(++newRowIndex, false);
                for (String columnKey : baseDataKeys) {
                    EntityCellBaseData cellData = (EntityCellBaseData)cellMap.get(columnKey);
                    entityData.addCellBaseData(newRowIndex, columnKey, cellData);
                }
                Object[] rowData = ApplyBillAggHelper.getInstance().getRowData(dimMembIdParam, billDetailData, tempConfig.getDimKeysList());
                Long rowId = rowData != null ? (Long)rowData[0] : Long.valueOf(GlobalIdUtil.genGlobalLongId());
                entityData.addRowId(newRowIndex, rowId);
                for (Map.Entry column : columnIndex.entrySet()) {
                    String key = (String)column.getKey();
                    if (key.endsWith("_text") || baseDataKeys.contains(key)) continue;
                    if (bizData.containsKey(key)) {
                        BigDecimal data = (BigDecimal)bizData.get(key);
                        entityData.addCellOtherData(newRowIndex, key, (Object)data);
                        continue;
                    }
                    if (rowData != null) {
                        entityData.addCellOtherData(newRowIndex, key, rowData[(Integer)column.getValue()]);
                        continue;
                    }
                    entityData.addCellOtherData(newRowIndex, key, null);
                }
            }
            members.removeAll(toDelMembs);
        } else {
            Set<Long> directChildMembIds = this.getDirectChildMembIds(beginIndex, baseEditKey, currentCellData, entityData);
            members.removeIf(memb -> !directChildMembIds.contains(memb.getId()));
        }
        currentCellData.setOpened(true);
        currentCellData.setGroupStatus(CellGroupStatusEnum.OPEN);
    }

    protected boolean childRowCanShow(Map<String, BigDecimal> bizData, EntryTemplateConfig templateConfig, String entryKey, Set<Long> matchRowIds) {
        return !bizData.isEmpty();
    }

    private Set<Long> getDirectChildMembIds(int beginIndex, String baseEditKey, EntityCellBaseData currentCell, ApplyBillEntityData entityData) {
        HashSet<Long> childMembId = new HashSet<Long>(16);
        List listDataOfColumn = entityData.getListDataOfColumn(baseEditKey);
        int targetLevel = currentCell.getLevel() + 1;
        for (int i = beginIndex + 1; i < listDataOfColumn.size(); ++i) {
            EntityCellBaseData baseData = (EntityCellBaseData)listDataOfColumn.get(i);
            if (targetLevel == baseData.getLevel()) {
                childMembId.add(baseData.getId());
            }
            if (baseData.getLevel() <= currentCell.getLevel()) break;
        }
        return childMembId;
    }

    private int getCacheRowIndex(int beginIndex, String baseEditKey, Long membId, ApplyBillEntityData entityData) {
        List listDataOfColumn = entityData.getListDataOfColumn(baseEditKey);
        int rowIndex = -1;
        for (int i = beginIndex; i < listDataOfColumn.size(); ++i) {
            EntityCellBaseData baseData = (EntityCellBaseData)listDataOfColumn.get(i);
            if (!membId.equals(baseData.getId())) continue;
            rowIndex = i;
            break;
        }
        return rowIndex;
    }

    private void openChildRow(int rowIndex, String baseEditKey, String entityKey, boolean isOpenAll) {
        ApplyBillEntityData entityData = this.getOrCacheBillEntityNodeData(entityKey, null).getCurrentNodeData();
        int currentRowIndexOfCacheEntry = entityData.getRowIndexByRowId(Long.valueOf(this.getModel().getEntryRowEntity(entityKey, rowIndex).getLong("id")));
        EntityCellBaseData currentCellData = entityData.getCellBaseData(currentRowIndexOfCacheEntry, baseEditKey);
        Set allAggColumnKeys = this.getTempConfig(entityKey).getAggKeys();
        if (currentCellData == null || currentCellData.isLeaf() || allAggColumnKeys.isEmpty()) {
            return;
        }
        DetailMembBillData billDetailData = this.getOrCacheDetailData(entityKey, null);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Map<String, Long> viewIds = this.getViewIds();
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        String dimNum = (String)tempConfig.selectColumnMapDimNum().get(baseEditKey);
        Member member = modelCacheHelper.getMember(dimNum, viewIds.get(dimNum), currentCellData.getId());
        Set<String> allParentNums = this.getAllParentNums(baseEditKey, billDetailData);
        this.initRowDataToCache(currentRowIndexOfCacheEntry, baseEditKey, entityKey, member, allParentNums, allAggColumnKeys, isOpenAll);
        int[] childRowIndex = this.getChildRowIndexs(isOpenAll, entityData, currentRowIndexOfCacheEntry, baseEditKey);
        Map columnIndex = tempConfig.getColumnIndex();
        IDataModel dataModel = this.getModel();
        String value = this.formatSign("-", currentCellData);
        value = this.chackvalue(value, dimNum, modelCacheHelper, currentCellData, "-");
        dataModel.setValue(baseEditKey + "_text", (Object)value, rowIndex);
        this.updateSameLevelMemberShowType(dataModel, entityData, baseEditKey, currentRowIndexOfCacheEntry, rowIndex);
        this.openChildRowFromCache(dataModel, entityData, rowIndex, currentRowIndexOfCacheEntry, childRowIndex, entityKey, columnIndex, baseEditKey);
    }

    private void updateSameLevelMemberShowType(IDataModel dataModel, ApplyBillEntityData entityData, String baseEditKey, int currentRowIndexOfCacheEntry, int rowIndex) {
        MemberShowType memberShowType = this.getMemberShowType();
        if (MemberShowType.NAME == memberShowType) {
            return;
        }
        String entityKey = this.getCurrentEntityKey();
        Map<String, BaseColumn> collect = this.getcollect(entityKey);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        List<String> curEntryDimKeys = this.getCurEntryDimKeys();
        for (String curEntryDimKey : curEntryDimKeys) {
            if (curEntryDimKey.equals(baseEditKey)) continue;
            EntityCellBaseData currentCellData = entityData.getCellBaseData(currentRowIndexOfCacheEntry, curEntryDimKey);
            BaseColumn baseColumn = collect.get(curEntryDimKey);
            String dimNumber = this.getdimNumber(baseColumn);
            String value = this.formatSign(this.getMemberStatusSign(currentCellData), currentCellData);
            value = this.chackvalue(value, dimNumber, modelCacheHelper, currentCellData, this.getMemberStatusSign(currentCellData));
            dataModel.setValue(curEntryDimKey + "_text", (Object)value, rowIndex);
        }
    }

    private int[] getChildRowIndexs(boolean isOpenAll, ApplyBillEntityData entityData, int currentRowIndexOfCacheEntry, String dimColumnKey) {
        int[] childRowIndex;
        if (isOpenAll) {
            childRowIndex = new int[entityData.getRowIds().size() - 1];
            for (int i = 1; i < entityData.getRowIds().size(); ++i) {
                childRowIndex[i - 1] = i;
            }
        } else {
            childRowIndex = this.getChildCacheRowIndexs(currentRowIndexOfCacheEntry, entityData, dimColumnKey);
        }
        return childRowIndex;
    }

    protected int initRowDataToCache(int rowIndex, String baseEditKey, String entityKey, Member member, Set<String> allRangeMembNums, Set<String> allAggColumnKeys, boolean isOpenAll) {
        List<Member> dimMemberChilds = this.getDimMemberChilds(allRangeMembNums, member);
        this.initRowDataToCache(rowIndex, baseEditKey, entityKey, member.getId(), dimMemberChilds, allAggColumnKeys);
        if (isOpenAll) {
            for (Member childMemb : dimMemberChilds) {
                ++rowIndex;
                rowIndex = this.initRowDataToCache(rowIndex, baseEditKey, entityKey, childMemb, allRangeMembNums, allAggColumnKeys, isOpenAll);
            }
        } else {
            rowIndex += dimMemberChilds.size();
        }
        return rowIndex;
    }

    protected void lockRowByDetailAt() {
        this.getEntryInfoFromFormParam().getEntryTemplateConfig().forEach((entityKey, tempConfig) -> {
            if (!this.isBizEntry((String)entityKey)) {
                int rowCount = this.getModel().getEntryRowCount(entityKey);
                List rowsIndex = CommonServiceHelper.buildIntArrays((int)rowCount);
                this.lockRowByDetailAt((String)entityKey, rowsIndex);
            }
        });
    }

    protected void lockRowByDetailAt(String entityKey, List<Integer> rowNums) {
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        Set detailAtColumn = tempConfig.getDetailAtColumn();
        if (!detailAtColumn.isEmpty()) {
            ApplyBillEntityNodeData entityNodeData = this.getOrCacheBillEntityNodeData(entityKey, null);
            ApplyBillEntityData currentNodeData = entityNodeData.getCurrentNodeData();
            DynamicObjectCollection entityData = this.getModel().getEntryEntity(entityKey);
            Object[] toLockColumns = detailAtColumn.toArray(new String[detailAtColumn.size()]);
            ArrayList<Integer> lockIndex = new ArrayList<Integer>(16);
            block0: for (int rowIndex : rowNums) {
                DynamicObject rowObj = (DynamicObject)entityData.get(rowIndex);
                Long rowId = rowObj.getLong("id");
                int rowIndexOnCache = currentNodeData.getRowIndexByRowId(rowId);
                if (rowIndexOnCache == -1) continue;
                for (String dimColumnKey : currentNodeData.getBaseDataKeys()) {
                    EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(rowIndexOnCache, dimColumnKey);
                    if (cellBaseData == null || cellBaseData.isLeaf()) continue;
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, (String[])toLockColumns);
                    lockIndex.add(rowIndex);
                    continue block0;
                }
            }
            if (lockIndex.size() > 0 && this.getLogSignsFromForm().contains("lockRowByDetailAt")) {
                log.info("lockRowByDetailAt:" + Arrays.toString(toLockColumns) + ":" + detailAtColumn.toString());
            }
        }
    }

    protected void afterOpenChildRow(List<Integer> rowNums, String entityKey) {
        int[] newRowIndex = CommonServiceHelper.changeIntArrays(rowNums);
        this.lockCellsByRows(entityKey, newRowIndex, true, true);
        EntryTemplateConfig entryTemplateConfig = this.getTempConfig(entityKey);
        this.updateRowsRelationValues(rowNums, entryTemplateConfig);
        ArrayList<Integer> rows = new ArrayList<Integer>(4);
        if (rowNums.size() > 0) {
            rows.add(rowNums.get(0));
            this.setRowRejectTxt(entityKey, rows);
        }
    }

    protected String getDimColTextKey(String dimColKey) {
        return dimColKey + "_text";
    }

    protected void afterOpenChildRow(String entityKey, List<RowInfo> insertRowsInfo) {
        ArrayList<Integer> rowNums = new ArrayList<Integer>(insertRowsInfo.size());
        for (RowInfo row : insertRowsInfo) {
            rowNums.add(row.getIndexOnPage());
        }
        this.afterOpenChildRow(rowNums, entityKey);
    }

    protected void setRowRejectTxt(String entityKey, List<Integer> rowNums) {
        EntryTemplateConfig templateConfig = this.getTempConfig(entityKey);
        List mainColumn = templateConfig.getEntryColumns();
        Map<String, Integer> dimKeyMap = this.getDimKeyMap(entityKey, rowNums.toArray(new Integer[rowNums.size()]));
        List logs = RejectBillService.getInstance().listRejectLogBySpnumber(this.getBillNumber(), Long.valueOf(templateConfig.getTemplateID()));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityKey);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        dimKeyMap.forEach((rowDimKey, rowNum) -> {
            String txt = RejectBillService.getInstance().getRejectStatusTxtByRowDimKey(rowDimKey, templateConfig, logs);
            Optional<String> opt = mainColumn.stream().map(BaseColumn::getKey).filter(e -> e.startsWith(ApplyTemplateUtils.FIELD_REJECT_STATUS)).findFirst();
            if (opt.isPresent()) {
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)txt)) {
                    txt = this.getModel().getEntryRowEntity(entityKey, rowNum.intValue()).getString(ApplyTemplateUtils.FIELD_REJECT_STATUS + entityKey.replace("entryentity", "") + "_text");
                }
                this.setRowRejectStatus(txt, entityKey, (int)rowNum, entryEntity, mainColumn, modelCacheHelper, logs);
            }
        });
    }

    private void cacheEntityCellChange(ApplyBillEntityData billEntityData, Long currentRowId, Object newValue, String name) {
        int currentRowIndexOfCacheEntry;
        if (billEntityData != null && (currentRowIndexOfCacheEntry = billEntityData.getRowIndexByRowId(currentRowId)) != -1) {
            List otherDataOfColumn;
            if (!this.isAggDataUpdate() && !this.isSplitDataUpdate()) {
                billEntityData.setRowChanged(currentRowIndexOfCacheEntry, true);
            }
            if ((otherDataOfColumn = billEntityData.getOtherDataOfColumn(name)) != null) {
                otherDataOfColumn.set(currentRowIndexOfCacheEntry, newValue);
            }
        }
    }

    public Map<String, Integer> getDimKeyMap(String entityName, Integer[] selectRows) {
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityName);
        ApplyBillEntityData entityData = this.getOrCacheBillEntityNodeData(entityName, null).getCurrentNodeData();
        HashMap<String, Integer> dimKeyMap = new HashMap<String, Integer>(16);
        Integer[] integerArray = selectRows;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int rowIndex = integerArray[i];
            DynamicObject rowObj = this.getModel().getEntryRowEntity(entityName, rowIndex);
            Long rowId = rowObj.getLong("id");
            int rowIndexForCacheData = entityData.getRowIndexByRowId(rowId);
            ArrayList<Long> dimMemberIdList = new ArrayList<Long>(10);
            for (BaseColumn column : entryTemplateConfig.getEntryColumns()) {
                EntityCellBaseData memb;
                if (!entryTemplateConfig.getDimKeysList().contains(column.getKey()) || (memb = entityData.getCellBaseData(rowIndexForCacheData, column.getKey())) == null) continue;
                dimMemberIdList.add(memb.getId());
            }
            dimKeyMap.put(StringUtils.join(dimMemberIdList, (String)","), rowIndex);
        }
        return dimKeyMap;
    }

    @Override
    protected FormShowParameter getAdjustRecordForm(EntryTemplateConfig entryTemplateConfig, DynamicObject currentRowObj, String entityNumber) {
        return this.getAdjustRecordFormBase(entryTemplateConfig, currentRowObj, entityNumber);
    }

    protected FormShowParameter getAdjustRecordFormBase(EntryTemplateConfig entryTemplateConfig, DynamicObject currentRowObj, String entityNumber) {
        ApplyBillEntityData billEntityData = this.getOrCacheBillEntityNodeData(entityNumber, null).getCurrentNodeData();
        HashMap<String, String> dims = new HashMap<String, String>(16);
        Map columnMapDimNum = entryTemplateConfig.selectColumnMapDimNum();
        List dimKeysList = entryTemplateConfig.getDimKeysList();
        if (billEntityData != null) {
            Long rowId = currentRowObj.getLong("id");
            int rowIndexByRowId = billEntityData.getRowIndexByRowId(rowId);
            for (String dimKey : dimKeysList) {
                String dimNum = (String)columnMapDimNum.get(dimKey);
                EntityCellBaseData membId = billEntityData.getCellBaseData(rowIndexByRowId, dimKey);
                dims.put(dimNum, membId.getNumber());
            }
            log.info("showAdjInfo:" + this.getBillNumber() + " dimInfo:" + ((Object)dims).toString());
            DynamicObject org = (DynamicObject)this.getModel().getValue("collectorg");
            FormShowParameter adjustShowPage = CentralAppBillService.getInstance().getAdjustShowPage(this.getBillNumber(), Long.valueOf(org == null ? 0L : org.getLong("id")), dims, Long.valueOf(entryTemplateConfig.getTemplateID()), AdjustShowTypeEnum.Adjust, ApplyBillType.getBillTypeByNumber((String)this.getBillType()), Long.valueOf(entryTemplateConfig.getDatasetId()), this.getModelId());
            return adjustShowPage;
        }
        return null;
    }

    private List<Member> getDimMemberChilds(Set<String> allRangeMembNums, Member member) {
        ArrayList<Member> childs = new ArrayList<Member>(16);
        if (member != null && !member.isLeaf()) {
            for (Member m : member.getChildren()) {
                if (!this.checkChildMembCanShow(m, allRangeMembNums)) continue;
                childs.add(m);
            }
        }
        return childs;
    }

    protected boolean checkChildMembCanShow(Member childMemb, Set<String> allRangeMembNums) {
        return allRangeMembNums.contains(childMemb.getNumber());
    }

    protected Set<String> getAllParentNums(String columnKey, DetailMembBillData billData) {
        HashSet<String> parentNums = new HashSet<String>(16);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        billData.iteratorMembersOnRow(modelCacheHelper, columnKey, member -> {
            if (member != null && member.isLeaf()) {
                Collections.addAll(parentNums, member.getLongNumber().split("!"));
            }
        });
        return parentNums;
    }

    protected void openChildRowFromCache(IDataModel dataModel, ApplyBillEntityData entityData, int insertIndex, int insertIndexOnCache, int[] childCacheRowIndexs, String entityKey, Map<String, Integer> columnIndex, String focusDimKey) {
        RowIndexInfo rowIndexInfo = new RowIndexInfo(insertIndex, insertIndexOnCache, childCacheRowIndexs);
        this.openChildRowFromCache1(dataModel, entityData, Collections.singletonList(rowIndexInfo), entityKey, columnIndex, focusDimKey);
    }

    protected void openChildRowFromCache1(IDataModel dataModel, ApplyBillEntityData entityData, List<RowIndexInfo> indexInfoList, String entityKey, Map<String, Integer> columnIndex, String focusDimKey) {
        ArrayList<RowInfo> inserRowsInfo = new ArrayList<RowInfo>(16);
        int entrySeq = this.getEntrySeqByMainEntryKey(entityKey);
        int offset = 0;
        Map<String, BaseColumn> collect = this.getcollect(entityKey);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (RowIndexInfo rowIndexInfo : indexInfoList) {
            int[] childCacheRowIndexs;
            int insertIndex = rowIndexInfo.getBeginIndexOnPage() + offset;
            if (insertIndex == 0) {
                int insertIndexOnCache = rowIndexInfo.getBeginIndexOnCache();
                Long firstRowId = entityData.getRowIbByIndex(insertIndexOnCache);
                RowInfo rowInfo = new RowInfo(insertIndex, insertIndexOnCache, firstRowId);
                inserRowsInfo.add(rowInfo);
            }
            for (int index : childCacheRowIndexs = rowIndexInfo.getAllInsertIndexOnCache()) {
                ++offset;
                dataModel.insertEntryRow(entityKey, ++insertIndex);
                DynamicObject rowObj = dataModel.getEntryRowEntity(entityKey, insertIndex);
                Long rowId = entityData.getRowIbByIndex(index);
                rowObj.set("id", (Object)rowId);
                inserRowsInfo.add(new RowInfo(insertIndex, index, rowId));
                int level = 1;
                boolean isFocusDimCol = false;
                for (String string : entityData.getBaseDataKeys()) {
                    String value;
                    EntityCellBaseData cellData = entityData.getCellBaseData(index, string);
                    String sign = this.getMemberStatusSign(cellData);
                    isFocusDimCol = string.equals(focusDimKey);
                    if (isFocusDimCol) {
                        level = cellData.getLevel();
                    }
                    BaseColumn baseColumn = collect.get(focusDimKey);
                    String dimNumber = this.getdimNumber(baseColumn);
                    if (this.signNotFocusDimCell() || isFocusDimCol) {
                        value = this.formatSign(sign, cellData);
                        value = this.chackvalue(value, dimNumber, modelCacheHelper, cellData, sign);
                        dataModel.setValue(string + "_text", (Object)value, insertIndex);
                    } else {
                        value = this.getCellData(cellData);
                        value = this.chackvalue(value, dimNumber, modelCacheHelper, cellData, sign);
                        dataModel.setValue(string + "_text", (Object)value, insertIndex);
                    }
                    dataModel.setValue(string, (Object)cellData.getId(), insertIndex);
                }
                dataModel.setValue(this.getLevelColKey(entrySeq), (Object)level, insertIndex);
                for (Map.Entry entry : columnIndex.entrySet()) {
                    Object val;
                    String key = (String)entry.getKey();
                    if (ApplyBillConstant.fixEntityTableKeySet.contains(key) || key.endsWith("_text") || key.startsWith(LEVELCOLUMNPREKEY) || (val = entityData.getCellOtherData(index, key)) == null) continue;
                    dataModel.setValue(key, val, insertIndex);
                }
            }
        }
        this.afterOpenChildRow(entityKey, inserRowsInfo);
    }

    protected boolean signNotFocusDimCell() {
        return true;
    }

    private void closeChildRow(int rowIndex, String itemKey, String entityKey) {
        ApplyBillEntityData entityData = this.getCurrentNodeData(entityKey);
        int pRowIndexOnCache = entityData.getRowIndexByRowId(Long.valueOf(this.getModel().getEntryRowEntity(entityKey, rowIndex).getLong("id")));
        int[] rowIndexs = this.getChildRowIndex(rowIndex, entityKey);
        EntityCellBaseData currentCellData = entityData.getCellBaseData(pRowIndexOnCache, itemKey);
        if (currentCellData == null || currentCellData.isLeaf()) {
            return;
        }
        Map<String, BaseColumn> collect = this.getcollect(entityKey);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        BaseColumn baseColumn = collect.get(itemKey);
        String dimNumber = this.getdimNumber(baseColumn);
        String value = this.formatSign("+", currentCellData);
        value = this.chackvalue(value, dimNumber, modelCacheHelper, currentCellData, "+");
        this.getModel().setValue(itemKey + "_text", (Object)value, rowIndex);
        if (rowIndexs != null) {
            this.getModel().deleteEntryRows(entityKey, rowIndexs);
        }
        currentCellData.setGroupStatus(CellGroupStatusEnum.CLOSE);
    }

    private int[] getChildRowIndex(int parentRowIndex, String entryKey) {
        int cLevel;
        ArrayList<Integer> indexs = new ArrayList<Integer>(16);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryKey);
        DynamicObject parentRow = (DynamicObject)rows.get(parentRowIndex);
        String levelColKey = this.getLevelColKey(entryKey);
        int pLevel = parentRow.getInt(levelColKey);
        for (int index = parentRowIndex + 1; index < rows.size() && (cLevel = ((DynamicObject)rows.get(index)).getInt(levelColKey)) > pLevel; ++index) {
            indexs.add(index);
        }
        return CommonServiceHelper.changeIntArrays(indexs);
    }

    private int[] getChildCacheRowIndexs(int rowIndex, ApplyBillEntityData entityData, String currentColumn) {
        EntityCellBaseData cellObj;
        List listData = entityData.getListDataOfColumn(currentColumn);
        EntityCellBaseData crrentCellObj = null;
        ArrayList<Integer> indexs = new ArrayList<Integer>(16);
        int pLevel = -1;
        if (rowIndex != -1) {
            crrentCellObj = (EntityCellBaseData)listData.get(rowIndex);
            pLevel = crrentCellObj.getLevel();
        }
        int maxIndex = listData.size();
        block0: for (int i = rowIndex + 1; i < maxIndex && (cellObj = (EntityCellBaseData)listData.get(i)).getLevel() > pLevel; ++i) {
            indexs.add(i);
            if (cellObj.getGroupStatus() != CellGroupStatusEnum.CLOSE) continue;
            int cpLevel = cellObj.getLevel();
            ++i;
            while (i < maxIndex) {
                EntityCellBaseData cCellObj = (EntityCellBaseData)listData.get(i);
                if (cCellObj.getLevel() <= cpLevel) {
                    --i;
                    continue block0;
                }
                ++i;
            }
        }
        return CommonServiceHelper.changeIntArrays(indexs);
    }

    protected boolean beforeOpenF7Form(DynamicObject rowObj, String columnKey, String entityKey, int rowIndex) {
        return true;
    }

    private void openF7Form(String columnKey, String entityKey, int rowIndex) {
        columnKey = columnKey.replaceAll("_text", "");
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityKey);
        List entryColumns = entryTemplateConfig.getEntryColumns();
        BaseColumn column = null;
        for (BaseColumn col : entryColumns) {
            if (!col.getKey().equals(columnKey) || !(col instanceof DimensionColumn) && !(col instanceof RowDimensionColumn)) continue;
            column = col;
            break;
        }
        if (column != null) {
            String currentDimNumber = this.getCurrentDimNumber(columnKey);
            long dataSetId = 0L;
            List dimensionMemberRanges = new ArrayList();
            if (column instanceof DimensionColumn) {
                dataSetId = ((DimensionColumn)column).getBussinessModelId();
                dimensionMemberRanges = ((DimensionColumn)column).getDimensionMemberRanges();
            } else if (column instanceof RowDimensionColumn) {
                dataSetId = ((RowDimensionColumn)column).getBussinessModelId();
                dimensionMemberRanges = ((RowDimensionColumn)column).getDimensionMemberRanges();
            }
            Long bizCtrlRangeId = this.getBizCtrlRangeId();
            Long viewId = DatasetServiceHelper.getViewIdByBusModelIdOfDim((Long)bizCtrlRangeId, (String)currentDimNumber);
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            HashSet<String> membNums = new HashSet<String>(16);
            for (DimensionMemberRange memberRange : dimensionMemberRanges) {
                int range;
                String memberNumber = memberRange.getNumber();
                List members = modelCacheHelper.getMember(currentDimNumber, viewId, memberNumber, range = Integer.parseInt(memberRange.getScope()));
                if (members == null || members.isEmpty()) continue;
                for (Member member : members) {
                    if (!member.isLeaf()) continue;
                    membNums.add(member.getNumber());
                }
            }
            Set<String> qfMembNums = this.getQfDimMembNumberByType(modelCacheHelper, currentDimNumber, viewId);
            Set<String> customDimMembFilter = this.getCustomDimMembFilter(modelCacheHelper, currentDimNumber, columnKey, viewId, entityKey, rowIndex);
            if (qfMembNums != null) {
                membNums.retainAll(qfMembNums);
            }
            if (customDimMembFilter != null) {
                membNums.retainAll(customDimMembFilter);
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dimMembSelect" + columnKey + "_" + rowIndex);
            Long modelId = this.getModelId();
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)currentDimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(bizCtrlRangeId);
            f7Param.setDatasetId(Long.valueOf(dataSetId));
            if (IDUtils.isNotNull((Long)viewId)) {
                f7Param.setViewId(viewId);
            }
            QFilter filter = new QFilter("number", "in", membNums);
            Set memberIds = NewF7Utils.transMemberNumber((String)currentDimNumber, (Long)f7Param.getViewId(), membNums, (IModelCacheHelper)modelCacheHelper);
            if (column instanceof RowDimensionColumn) {
                this.setDimensionRelationFilter(entryTemplateConfig, (RowDimensionColumn)column, rowIndex, modelCacheHelper, memberIds, filter);
            }
            f7Param.addCustomFilter(filter);
            this.filterSubBillMember(memberIds, currentDimNumber, entryTemplateConfig, rowIndex);
            f7Param.setSelectRangeIds(memberIds);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
        }
    }

    private void setDimensionRelationFilter(EntryTemplateConfig entryTemplateConfig, RowDimensionColumn column, int rowIndex, IModelCacheHelper modelCache, Set<Long> memberIds, QFilter filter) {
        Map dimViewMap = modelCache.getViewsByDataSet(Long.valueOf(entryTemplateConfig.getDatasetId()));
        if (column.getEnableDimensionRelation().booleanValue() && !column.getDimensionRelationSchemas().isEmpty()) {
            Map rowDimisionAutoUpdateColumnKeys = entryTemplateConfig.getRowDimisionAutoUpdateColumnKeys();
            ArrayList<String> sourceKeys = new ArrayList<String>(16);
            for (Map.Entry rowDim : rowDimisionAutoUpdateColumnKeys.entrySet()) {
                String key = (String)rowDim.getKey();
                List value = (List)rowDim.getValue();
                if (!value.contains(column.getKey()) || sourceKeys.contains(key)) continue;
                sourceKeys.add(key);
            }
            if (!sourceKeys.isEmpty()) {
                QFilter qFilter2 = new QFilter("relationid", "in", (Object)column.getDimensionRelationSchemas());
                qFilter2.and(new QFilter("status", "=", (Object)"1"));
                Map querys = BusinessDataServiceHelper.loadFromCache((String)"epm_dimmemberrelation", (String)"dimension1,dimension2,dimension3,dimension4,dimension5,dimension6", (QFilter[])new QFilter[]{qFilter2});
                ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(querys.values());
                HashSet<Long> ids = new HashSet<Long>(16);
                for (String key : sourceKeys) {
                    ArrayList<String> matchSourceKeys = new ArrayList<String>(16);
                    if (key.contains("|")) {
                        String[] arrs = key.split("\\|");
                        matchSourceKeys.addAll(Arrays.asList(arrs));
                    } else {
                        matchSourceKeys.add(key);
                    }
                    if (matchSourceKeys.isEmpty()) continue;
                    ArrayList<Long> compareValues = new ArrayList<Long>(16);
                    HashMap<String, Long> matchKeyMapValue = new HashMap<String, Long>(16);
                    for (String matchSourceKey : matchSourceKeys) {
                        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(matchSourceKey, rowIndex);
                        Long id = dynamicObject == null ? 0L : dynamicObject.getLong("id");
                        compareValues.add(id);
                        matchKeyMapValue.put(matchSourceKey, id);
                    }
                    List columns = entryTemplateConfig.getEntryColumns().stream().filter(s -> matchSourceKeys.contains(s.getKey())).collect(Collectors.toList());
                    ArrayList allArrays = new ArrayList();
                    for (BaseColumn findcolumn : columns) {
                        DimensionColumn colum;
                        Long dimId = 0L;
                        if (findcolumn instanceof DimensionColumn) {
                            colum = (DimensionColumn)findcolumn;
                            dimId = colum.getDimensionId();
                        } else if (findcolumn instanceof RelationDimensionColumn) {
                            colum = (RelationDimensionColumn)findcolumn;
                            dimId = colum.getDimensionId();
                        } else if (findcolumn instanceof RowDimensionColumn) {
                            colum = (RowDimensionColumn)findcolumn;
                            dimId = colum.getDimensionId();
                        }
                        if (dimId == 0L) continue;
                        Dimension dimension = modelCache.getDimension(dimId);
                        Long value = (Long)matchKeyMapValue.get(findcolumn.getKey());
                        Long _viewId = (Long)dimViewMap.get(dimension.getNumber());
                        Member member = modelCache.getMember(dimension.getNumber(), _viewId, value);
                        List parentOrgList = modelCache.getParents(_viewId, member, true);
                        ArrayList subArrays = new ArrayList(16);
                        parentOrgList.forEach(s -> subArrays.add(s.getId()));
                        allArrays.add(subArrays);
                    }
                    ArrayList results = new ArrayList();
                    ApplyBillPluginUitl.arrangeCombine(allArrays, new ArrayList(), (int)0, results);
                    if (results.isEmpty()) continue;
                    for (List result : results) {
                        Set<Long> allRelationValue = this.getAllRelationValue(datas, result, matchSourceKeys, true);
                        ids.addAll(allRelationValue);
                    }
                    filter.and(new QFilter("id", "in", ids));
                }
                List matchSourceKeys = ApplyBillPluginUitl.getMatchSourceKeys(sourceKeys, (int)rowIndex, (IDataModel)this.getModel());
                if (!ids.isEmpty()) {
                    String dimNumber = column.getDimNumber();
                    ArrayList<Object> arrids = new ArrayList<Object>();
                    for (Long id : ids) {
                        Member member = modelCache.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), id);
                        if (member == null) continue;
                        List leaf = member.getLeaf();
                        if (leaf != null && !leaf.isEmpty()) {
                            List mids = leaf.stream().map(s -> s.getId()).collect(Collectors.toList());
                            arrids.addAll(mids);
                            continue;
                        }
                        arrids.add(id);
                    }
                    if (!arrids.isEmpty()) {
                        filter.and(new QFilter("id", "in", arrids));
                    }
                }
            }
        }
    }

    private Set<Long> getAllRelationValue(List<DynamicObject> datas, List<Long> compareValues, List<String> matchSourceKeys, boolean isall) {
        HashSet<Long> results = new HashSet<Long>(16);
        for (DynamicObject query : datas) {
            long id1 = query.getLong("dimension1");
            long id2 = query.getLong("dimension2");
            long id3 = query.getLong("dimension3");
            long id4 = query.getLong("dimension4");
            long id5 = query.getLong("dimension5");
            long id6 = query.getLong("dimension6");
            ArrayList<Long> values = new ArrayList<Long>(6);
            values.add(id1);
            values.add(id2);
            values.add(id3);
            values.add(id4);
            values.add(id5);
            values.add(id6);
            values.removeIf(s -> s.equals(0L));
            int length = matchSourceKeys.size() + 1;
            if (length != values.size()) continue;
            List subs = values.stream().filter(s -> !compareValues.contains(s)).collect(Collectors.toList());
            if (subs.size() == 1) {
                results.add((Long)subs.get(0));
            }
            if (isall || results.size() <= 1) continue;
            return results;
        }
        return results;
    }

    private void filterSubBillMember(Set<Long> memberIds, String currentDimNumber, EntryTemplateConfig entryTemplateConfig, int rowIndex) {
        CentralAppShowInfo centralAppShowInfo = this.getCentralAppShowInfo();
        if ((this.isApplyAuditBill() || this.isCollectAuditBill()) && centralAppShowInfo != null && !centralAppShowInfo.isMainBill()) {
            List approveBillConfigs = centralAppShowInfo.getApproveBillConfigs();
            if (approveBillConfigs == null || approveBillConfigs.isEmpty()) {
                return;
            }
            long templateID = entryTemplateConfig.getTemplateID();
            List approveconfigs = approveBillConfigs.stream().filter(s -> s.getTemplateId().equals(templateID)).collect(Collectors.toList());
            if (!approveconfigs.isEmpty()) {
                List<Map<String, Set<Long>>> allMemberIds = new ArrayList<Map<String, Set<Long>>>(16);
                for (Object approveBillConfig : approveBillConfigs) {
                    List list = approveBillConfig.getMatchMemberIds();
                    allMemberIds.addAll(list);
                }
                HashSet dimNumbers = new HashSet(16);
                for (Map map : allMemberIds) {
                    dimNumbers.addAll(map.keySet());
                }
                Map<String, String> dimNumberMapkey = entryTemplateConfig.selectColumnMapDimNum().entrySet().stream().collect(Collectors.toMap(s -> (String)s.getValue(), s -> (String)s.getKey()));
                List list = dimNumbers.stream().filter(s -> !s.equals(currentDimNumber)).collect(Collectors.toList());
                if (!list.isEmpty()) {
                    for (String otherDim : list) {
                        String string = dimNumberMapkey.get(otherDim);
                        Object value = this.getModel().getValue(string);
                        long id = 0L;
                        if (value != null) {
                            id = ((DynamicObject)value).getLong("id");
                        }
                        allMemberIds = this.filterSubByEveryDim(allMemberIds, otherDim, id);
                    }
                }
                ArrayList ids = new ArrayList(16);
                for (Map map : allMemberIds) {
                    Set mids = (Set)map.get(currentDimNumber);
                    if (mids == null) {
                        return;
                    }
                    ids.addAll(mids);
                }
                memberIds.retainAll(ids);
            }
        }
    }

    private List<Map<String, Set<Long>>> filterSubByEveryDim(List<Map<String, Set<Long>>> datas, String dim, long dimid) {
        ArrayList<Map<String, Set<Long>>> result = new ArrayList<Map<String, Set<Long>>>(16);
        if (!datas.isEmpty()) {
            if (dimid == 0L) {
                result.addAll(datas);
                return result;
            }
            for (Map<String, Set<Long>> data : datas) {
                Set<Long> ids = data.get(dim);
                if (!ids.contains(dimid)) continue;
                result.add(data);
            }
        }
        return result;
    }

    @Override
    protected void addCustomColumn(ColumnsContext columnsContext) {
        this.addTextFieldForBaseDataField(columnsContext.getMainColumns());
        super.addCustomColumn(columnsContext);
        this.addLevelColumn(columnsContext);
    }

    private void addTextFieldForBaseDataField(List<BaseColumn> collect) {
        List dimColumnList = ApplyTemplateUtils.getDimKeyList(collect);
        ArrayList<Object> collectNew = new ArrayList<Object>(16);
        for (BaseColumn column : collect) {
            if (dimColumnList.contains(column.getKey())) {
                column.setEnable(false);
                TextColumn textColumn = new TextColumn();
                textColumn.setKey(column.getKey() + "_text");
                textColumn.setTitle(column.getTitle());
                textColumn.setType(ColumnEnum.Text);
                textColumn.setFieldtype(FieldTypeEnum.TextField);
                textColumn.setEditStyle(1);
                textColumn.setIsmustinput(true);
                textColumn.setCategory("h");
                textColumn.setIgnoreDB(true);
                textColumn.setBaseVisible(column.isBaseVisible());
                collectNew.add(textColumn);
            }
            collectNew.add(column);
        }
        collect.clear();
        collect.addAll(collectNew);
    }

    private void addLevelColumn(ColumnsContext columnsContext) {
        BaseColumn levelColumn = new BaseColumn();
        levelColumn.setKey(this.getLevelColKey(columnsContext.getEntitySeq()));
        levelColumn.setTitle("");
        levelColumn.setIgnoreDB(true);
        levelColumn.setEnable(false);
        levelColumn.setType(ColumnEnum.Others);
        levelColumn.setFieldtype(FieldTypeEnum.TextField);
        levelColumn.setBaseVisible(false);
        columnsContext.getMainColumns().add(levelColumn);
    }

    protected String getLevelColKey(String mainEntryKey) {
        int entrySeq = this.getEntrySeqByMainEntryKey(mainEntryKey);
        return LEVELCOLUMNPREKEY + entrySeq + "_text";
    }

    protected String getLevelColKey(int entrySeq) {
        return LEVELCOLUMNPREKEY + entrySeq + "_text";
    }

    private void selectNewRowInfo(List<Object[]> toSaveRowsData, EntryTemplateConfig templateConfig, String billType, String billNumber, String entityKey, DetailMembBillData detailData, BigDecimal unitData, Map<Integer, Long> rowIndexMapId, List<Integer> todelRowIndexs) {
        List columns = templateConfig.selectEntryColumnsNoDimText();
        columns.removeIf(BaseColumn::isIgnoreDB);
        int valLength = ApplyBillConstant.fixEntityTableKey.length + columns.size();
        DynamicObjectCollection allrow = this.getModel().getEntryEntity(entityKey);
        String subtotalKey = templateConfig.getSubtotalKey();
        int rowIndex = 0;
        for (DynamicObject row : allrow) {
            Long rowId = row.getLong("id");
            boolean subtotal = row.getBoolean(subtotalKey);
            if (subtotal) continue;
            if (rowId == null || rowId.equals(0L)) {
                Object[] rowVal = new Object[valLength];
                rowId = GlobalIdUtil.genGlobalLongId();
                this.setDefaultColumnVal(rowVal, rowId, billType, billNumber, EntityRowDataType.NEW_DETAIL.getNumber());
                this.selectRowVal(columns, row, rowVal, templateConfig.getCurrencyColumnKeys(), unitData);
                Pair<Boolean, Boolean> checkResult = this.checkRowValDimAndModifColVal(rowVal, templateConfig.getModifKeys(), templateConfig.getDimKeysList(), templateConfig.getColumnIndex());
                if (((Boolean)checkResult.p2).booleanValue()) {
                    todelRowIndexs.add(rowIndex);
                    continue;
                }
                if (((Boolean)checkResult.p1).booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b0\u589e\u884c\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"BgApplyBillPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String membIdStr = this.seletRowDimMembIds(rowVal, templateConfig.getDimKeysList(), templateConfig.getColumnIndex());
                if (detailData.getDetailRowStatus().containsKey(membIdStr)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7ef4\u5ea6\u7ec4\u5408\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"BgApplyBillPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex + 1}));
                }
                rowIndexMapId.put(rowIndex, rowId);
                toSaveRowsData.add(rowVal);
            }
            ++rowIndex;
        }
    }

    protected List<RowInfo> updateAggDataToForm(String entityKey, Set<String> toUpAggKeys, Set<Long> ignoreRowIds, int rowIndex, AggTypeEnum aggType) {
        ArrayList<RowInfo> updatedRowInfo = new ArrayList<RowInfo>(16);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entityKey);
        if (rowIndex > rows.size()) {
            return updatedRowInfo;
        }
        this.setIsAggDataUpdate(true);
        DetailMembBillData detailMembBillData = this.getOrCacheDetailData(entityKey, null);
        ApplyBillEntityNodeData billEntityNodeData = this.getOrCacheBillEntityNodeData(entityKey, null);
        ApplyBillEntityData billEntityData = billEntityNodeData.getCurrentNodeData();
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        String levelColKey = this.getLevelColKey(entityKey);
        Map<String, Set<String>> allParentNumsOnRow = null;
        if (aggType == AggTypeEnum.ALL) {
            rowIndex = rows.size();
        } else if (aggType == AggTypeEnum.ROWPARENTS) {
            DynamicObject currentRowObj = (DynamicObject)rows.get(rowIndex);
            allParentNumsOnRow = this.selectAllParentNumsOnRow(tempConfig, this.getModelCacheHelper(), currentRowObj);
        }
        HashMap<String, String> membParam = new HashMap<String, String>(16);
        for (int i = rowIndex - 1; i >= 0; --i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            Long rowId = row.getLong("id");
            int rowLevel = row.getInt(levelColKey);
            if (!(this.isNewRow(row) || ignoreRowIds != null && ignoreRowIds.contains(rowId))) {
                this.selectRowDimMembs(tempConfig.getDimKeysList(), row, membParam);
                if (membParam.isEmpty() || allParentNumsOnRow != null && !this.matchParentRow(tempConfig.getDimKeysList(), allParentNumsOnRow, membParam)) continue;
                int rowIndexOnCache = billEntityData.getRowIndexByRowId(rowId);
                Map data = ApplyBillAggHelper.getInstance().getData(membParam, detailMembBillData, toUpAggKeys, tempConfig);
                for (String auditKey : toUpAggKeys) {
                    BigDecimal auditData = (BigDecimal)data.get(auditKey);
                    List otherDataOfColumn = billEntityData.getOtherDataOfColumn(auditKey);
                    if (otherDataOfColumn != null) {
                        otherDataOfColumn.set(rowIndexOnCache, auditData);
                    }
                    this.getModel().setValue(auditKey, (Object)auditData, i);
                }
                updatedRowInfo.add(new RowInfo(i, rowIndexOnCache, rowId));
            }
            if (rowLevel == 1 && aggType != AggTypeEnum.ALL) break;
        }
        this.afterUpdateAggDataToForm(updatedRowInfo, entityKey, toUpAggKeys, ignoreRowIds, rowIndex, aggType, allParentNumsOnRow);
        this.getOrCacheBillEntityNodeData(entityKey, billEntityNodeData);
        this.setIsAggDataUpdate(false);
        return updatedRowInfo;
    }

    protected List<RowInfo> updateAggDataToForm(String entityKey, Set<String> toUpAggKeys, Set<Long> ignoreRowIds, int rowIndex, boolean updateAll) {
        return this.updateAggDataToForm(entityKey, toUpAggKeys, ignoreRowIds, rowIndex, updateAll ? AggTypeEnum.ALL : AggTypeEnum.ROWPARENTS);
    }

    protected boolean matchParentRow(List<String> dimKeysList, Map<String, Set<String>> allParentNums, Map<String, String> rowDimMembNums) {
        for (String dimColKey : dimKeysList) {
            Set<String> parentNums = allParentNums.get(dimColKey);
            String membNum = rowDimMembNums.get(dimColKey);
            if (membNum != null && parentNums != null && parentNums.contains(membNum)) continue;
            return false;
        }
        return true;
    }

    private void selectRowDimMembs(List<String> dimKeysList, DynamicObject pRowObj, Map<String, String> rowDimMembNums) {
        rowDimMembNums.clear();
        for (String dimColKey : dimKeysList) {
            DynamicObject membObj = pRowObj.getDynamicObject(dimColKey);
            if (membObj == null) {
                rowDimMembNums.clear();
                break;
            }
            rowDimMembNums.put(dimColKey, membObj.getString("number"));
        }
    }

    protected Map<String, Set<String>> selectAllParentNumsOnRow(EntryTemplateConfig tempConfig, IModelCacheHelper modelCacheHelper, DynamicObject rowObj) {
        HashMap<String, Set<String>> allParentNums = new HashMap<String, Set<String>>(tempConfig.getDimKeysList().size());
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(tempConfig.getDatasetId()));
        for (int seq = 0; seq < tempConfig.getDimKeysList().size(); ++seq) {
            String dimNum = (String)tempConfig.getRowDimNums().get(seq);
            String dimColKey = (String)tempConfig.getDimKeysList().get(seq);
            Long viewId = (Long)viewIds.get(dimNum);
            DynamicObject membObj = rowObj.getDynamicObject(dimColKey);
            Long membId = membObj.getLong("id");
            Member member = modelCacheHelper.getMember(dimNum, viewId, membId);
            String longNumber = member.getLongNumber();
            Set longNumSet = CommonServiceHelper.changeLongNumToSet((String)longNumber);
            allParentNums.put(dimColKey, longNumSet);
        }
        return allParentNums;
    }

    protected void afterUpdateAggDataToForm(List<RowInfo> updatedRowInfo, String entityKey, Set<String> toUpAggKeys, Set<Long> ignoreRowIds, int rowIndex, AggTypeEnum aggType, Map<String, Set<String>> allParentNumsOnRow) {
    }

    private void replateFirstRowMemb(Map<String, String> sameParentNum, EntryTemplateConfig templateConfig, Map<String, Set<Long>> dimsMembId) {
        if (sameParentNum.isEmpty()) {
            return;
        }
        List notTreeDimKeys = templateConfig.getNotTreeDimKeys();
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map viewsByDataSet = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        for (String dimColumnKey : templateConfig.getDimKeysList()) {
            Member parent;
            String dimNum;
            if (notTreeDimKeys.contains(dimColumnKey) || (dimNum = (String)columnMapDimNum.get(dimColumnKey)) == null) continue;
            SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimNum);
            if (enumByNumber == null || enumByNumber.getMemberTreemodel().equals("epm_userdefinedmembertree")) {
                sameParentNum.put(dimColumnKey, dimNum);
                continue;
            }
            Set<Long> detailMembIds = dimsMembId.get(dimColumnKey);
            if (detailMembIds == null || detailMembIds.size() != 1) continue;
            Long membId = detailMembIds.iterator().next();
            Long viewId = (Long)viewsByDataSet.get(dimNum);
            Member member = modelCacheHelper.getMember(dimNum, viewId, membId);
            if (member == null || (parent = modelCacheHelper.getMember(dimNum, viewId, member.getParentId())) == null) continue;
            sameParentNum.put(dimColumnKey, parent.getNumber());
        }
    }

    private Map<String, String> getSameParentNum(EntryTemplateConfig templateConfig, Map<String, Set<Long>> detailRowMembIds) {
        HashMap<String, String> sameParentNums = new HashMap<String, String>(16);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        for (Map.Entry<String, Set<Long>> rowMembIds : detailRowMembIds.entrySet()) {
            String dimNum = (String)templateConfig.selectColumnMapDimNum().get(rowMembIds.getKey());
            Long viewId = modelCacheHelper.getViewByDataSetAndDimNumber(Long.valueOf(templateConfig.getDatasetId()), dimNum);
            List<String> parentNums = new ArrayList<String>(16);
            boolean isInit = true;
            for (Long membId : rowMembIds.getValue()) {
                Member member = modelCacheHelper.getMember(dimNum, viewId, membId);
                if (member == null || !member.isLeaf()) continue;
                String[] membNums = member.getLongNumber().split("!");
                int index = 0;
                for (String number : membNums) {
                    if (number.equals("")) continue;
                    if (isInit) {
                        parentNums.add(number);
                        continue;
                    }
                    if (index >= parentNums.size()) break;
                    String num = (String)parentNums.get(index);
                    if (!num.equals(number)) {
                        parentNums = parentNums.subList(0, index);
                        break;
                    }
                    ++index;
                }
                if (!isInit) continue;
                isInit = false;
            }
            if (parentNums.isEmpty()) {
                sameParentNums.clear();
                return sameParentNums;
            }
            sameParentNums.put(rowMembIds.getKey(), (String)parentNums.get(parentNums.size() - 1));
        }
        return sameParentNums;
    }

    protected void setEntityInitData(int newEntryRowIndex, Map<String, String> sameParentNum, DetailMembBillData detailMembBillData, IModelCacheHelper modelCacheHelper, ApplyBillEntityData billEntityData, String entityKey, EntryTemplateConfig templateConfig, Map<String, BigDecimal> data) {
        IDataModel dataModel = this.getModel();
        this.initFirstRow(dataModel, newEntryRowIndex, sameParentNum, detailMembBillData, modelCacheHelper, billEntityData, entityKey, templateConfig, data);
        Long newRowId = billEntityData.getRowIbByIndex(newEntryRowIndex);
        DynamicObject rowObj = dataModel.getEntryRowEntity(entityKey, newEntryRowIndex);
        rowObj.set("id", (Object)newRowId);
        rowObj.set(this.getLevelColKey(this.getEntrySeqByMainEntryKey(entityKey)), (Object)1);
    }

    protected void initFirstRow(IDataModel dataModel, int newEntryRowIndex, Map<String, String> sameParentNum, DetailMembBillData detailMembBillData, IModelCacheHelper modelCacheHelper, ApplyBillEntityData billEntityData, String entityKey, EntryTemplateConfig templateConfig, Map<String, BigDecimal> data) {
        List baseDataKeySeq = templateConfig.getDimKeysList();
        HashMap<String, String> membParam = new HashMap<String, String>(16);
        HashMap<String, String> membIdParam = new HashMap<String, String>(16);
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        boolean isMainBill = this.isMainBill();
        for (String baseDataKey : baseDataKeySeq) {
            String membNum = sameParentNum.get(baseDataKey);
            String dimNum = (String)columnMapDimNum.get(baseDataKey);
            Member member = modelCacheHelper.getMember(dimNum, (Long)viewIds.get(dimNum), membNum);
            this.setData(billEntityData, newEntryRowIndex, dataModel, baseDataKey, member);
            membParam.put(baseDataKey, member.getNumber());
            membIdParam.put(baseDataKey, member.getId().toString());
        }
        Set allAggColumnKeys = this.getTempConfig(entityKey).getAggKeys();
        Map bizData = null;
        ArrayList numberColumnKeys = new ArrayList(templateConfig.getEntryColumns().size());
        templateConfig.getEntryColumns().forEach(col -> {
            if (col instanceof NumberColumn) {
                numberColumnKeys.add(col.getKey());
            }
        });
        if (isMainBill) {
            bizData = ApplyBillAggHelper.getInstance().getDataNew(membParam, detailMembBillData, (Collection)allAggColumnKeys, templateConfig, null, data);
            if (CollectionUtils.isNotEmpty((Map)bizData) && !numberColumnKeys.isEmpty()) {
                Map bizDataNumber = null;
                bizDataNumber = ApplyBillAggHelper.getInstance().getData(membParam, detailMembBillData, (Collection)allAggColumnKeys, templateConfig);
                for (String columnKey : numberColumnKeys) {
                    bizData.put(columnKey, bizDataNumber.get(columnKey));
                }
            }
        } else {
            bizData = ApplyBillAggHelper.getInstance().getData(membParam, detailMembBillData, (Collection)allAggColumnKeys, templateConfig);
        }
        Map columnIndex = templateConfig.getColumnIndex();
        Object[] rowData = ApplyBillAggHelper.getInstance().getRowData(membIdParam, detailMembBillData, templateConfig.getDimKeysList());
        Long rowId = rowData != null ? ApplyBillAggHelper.getInstance().getRowId(rowData) : Long.valueOf(GlobalIdUtil.genGlobalLongId());
        billEntityData.addRowId(newEntryRowIndex, rowId);
        this.setOtherData(dataModel, bizData, columnIndex, rowData, templateConfig.selectColumnMapDimNum().keySet(), newEntryRowIndex, newEntryRowIndex, billEntityData);
        billEntityData.getRowChanged().add(newEntryRowIndex, false);
    }

    protected void setData(ApplyBillEntityData entityData, int rowIndex, IDataModel dataModel, String key, Member member) {
        EntityCellBaseData cellData = new EntityCellBaseData();
        cellData.setLevel(1);
        cellData.setOpened(false);
        if (member != null) {
            String showName;
            cellData.setId(member.getId());
            cellData.setName(member.getName());
            cellData.setNumber(member.getNumber());
            if (!member.isLeaf()) {
                showName = "+" + cellData.getName();
                cellData.setLeaf(false);
                cellData.setGroupStatus(CellGroupStatusEnum.CLOSE);
            } else {
                showName = cellData.getName();
                cellData.setGroupStatus(CellGroupStatusEnum.NONE);
                cellData.setLeaf(true);
            }
            if (dataModel != null) {
                dataModel.setValue(key + "_text", (Object)showName, rowIndex);
                dataModel.setValue(key, (Object)member.getId(), rowIndex);
            }
        } else {
            cellData.setId(Long.valueOf(0L));
            cellData.setName("");
            cellData.setNumber("");
            cellData.setLeaf(true);
        }
        entityData.addCellBaseData(rowIndex, key, cellData);
    }

    @Override
    protected void setOtherControlStatus(BillFieldStatus fieldStatus) {
        super.setOtherControlStatus(fieldStatus);
        fieldStatus.addShowKeys(ApplyBillConstant.lab_pathpanel);
    }

    protected void setOtherData(IDataModel dataModel, Map<String, BigDecimal> aggData, Map<String, Integer> columnIndex, Object[] rowData, Set<String> rowDimColumnKeys, int newEntryRow, int cacheRowIndex, ApplyBillEntityData billEntityData) {
        for (Map.Entry<String, Integer> column : columnIndex.entrySet()) {
            String key = column.getKey();
            if (key.endsWith("_text") || rowDimColumnKeys.contains(key)) continue;
            if (aggData.containsKey(key)) {
                BigDecimal data = aggData.get(key);
                if (dataModel != null) {
                    dataModel.setValue(key, (Object)data, newEntryRow);
                }
                billEntityData.addCellOtherData(cacheRowIndex, key, (Object)data);
                continue;
            }
            if (rowData != null) {
                if (!ApplyBillConstant.fixEntityTableKeySet.contains(key) && dataModel != null) {
                    if (column.getValue() < rowData.length) {
                        dataModel.setValue(key, rowData[column.getValue()], newEntryRow);
                    } else {
                        dataModel.setValue(key, null, newEntryRow);
                    }
                }
                if (column.getValue() >= rowData.length) continue;
                billEntityData.addCellOtherData(cacheRowIndex, key, rowData[column.getValue()]);
                continue;
            }
            billEntityData.addCellOtherData(cacheRowIndex, key, null);
        }
    }

    private Map<String, Map<Long, Long>> getOrCacheColumnRefMembInfo(Map<String, Map<Long, Long>> columnRefMembInfo) {
        if (columnRefMembInfo == null) {
            if (this.columnRefMembInfo == null) {
                String cacheStr = this.getPageCache().get("ColumnRefMembInfo");
                columnRefMembInfo = cacheStr == null ? new HashMap(16) : (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheStr);
                this.columnRefMembInfo = columnRefMembInfo;
            }
        } else {
            this.getPageCache().put("ColumnRefMembInfo", SerializationUtils.serializeToBase64(columnRefMembInfo));
            this.columnRefMembInfo = columnRefMembInfo;
        }
        return this.columnRefMembInfo;
    }

    @Override
    protected void setButtonStatus(BillFieldStatus fieldStatus) {
        super.setButtonStatus(fieldStatus);
        fieldStatus.addShowKeys(ApplyBillConstant.btns_viewdata);
    }

    @Override
    protected void setColumnStatus(BillFieldStatus fieldStatus) {
        super.setColumnStatus(fieldStatus);
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        for (EntryTemplateConfig templateConfig : entryInfoFromFormParam.getEntryTemplateConfig().values()) {
            if (templateConfig.getDimKeysList() == null) continue;
            for (String key : templateConfig.getDimKeysList()) {
                fieldStatus.addHideKeys(new String[]{key});
            }
        }
    }

    @Override
    protected void fillEntryData(Map<String, List<Object[]>> datas) {
        List<ApproveBill> query;
        BgApplyENtryInfo entryInfo = this.getEntryInfoFromFormParam();
        String billNumber = this.getBillNumber();
        FormShowParameter formShowParameterBillType = this.getView().getFormShowParameter();
        String billType = formShowParameterBillType.getCustomParam("bill_type").toString();
        String parentFormId = formShowParameterBillType.getParentFormId();
        if (!"eb_centralappbill".equals(parentFormId) && (query = this.getCenAppBillByRptOrColBill(billNumber, billType)) != null && query.size() == 1) {
            ApproveBill bill = query.get(0);
            billNumber = bill.getBillNo();
        }
        Map entryTemplateConfig = entryInfo.getEntryTemplateConfig();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        this.allDetailData = new HashMap<String, DetailMembBillData>(16);
        this.allNodeEntryData = new HashMap<String, ApplyBillEntityNodeData>(16);
        this.columnRefMembInfo = new HashMap(16);
        Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
        for (Map.Entry entry : entryTemplateConfig.entrySet()) {
            String entityKey = (String)entry.getKey();
            long templateID = ((EntryTemplateConfig)entry.getValue()).getTemplateID();
            if (entityKey.startsWith("bizentryentity")) continue;
            ApplyBillEntityData billEntityData = new ApplyBillEntityData();
            DetailMembBillData detailMembBillData = new DetailMembBillData();
            List<Object[]> data = datas.get(entityKey);
            if (data == null) {
                data = new ArrayList<Object[]>(16);
            }
            EntryTemplateConfig entryConfig = (EntryTemplateConfig)entry.getValue();
            List<BaseColumn> main_collect = entryConfig.getEntryColumns().stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
            Map columnIndexes = entryConfig.getColumnIndex();
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)entry.getValue();
            BigDecimal unitData = this.getUnitData(templateConfig.getUnit());
            unitData = BigDecimal.ONE.divide(unitData);
            this.initCentralOrg(billNumber, data, main_collect, columnIndexes, templateID);
            Map groupMembsByStats = ApplyBillAggHelper.getInstance().initDetailDataGroup(detailMembBillData, data, modelCacheHelper, viewIds, unitData, templateConfig);
            this.allDetailData.put(entityKey, detailMembBillData);
            this.getModel().deleteEntryData(entityKey);
            if (groupMembsByStats.size() > 0) {
                this.setEntityInitData(templateConfig, groupMembsByStats, detailMembBillData, entityKey, bizCtrlRangeId, modelCacheHelper, billEntityData);
            }
            EntityPathNode pathNode = new EntityPathNode(Long.valueOf(0L), ResManager.loadKDString((String)"\u5168\u90e8", (String)"BgApplyBillMultColTreePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            pathNode.setNodeDataIndex(0);
            pathNode.setNodeIndex(1);
            ApplyBillEntityNodeData nodeData = new ApplyBillEntityNodeData();
            nodeData.addNodeData(billEntityData);
            nodeData.addNode(pathNode);
            this.allNodeEntryData.put(entityKey, nodeData);
        }
        this.cacheAllSourceData();
        this.getOrCacheColumnRefMembInfo(this.columnRefMembInfo);
        this.cacheAllBillEntityNodeData(false);
    }

    private void initCentralOrg(String billNumber, List<Object[]> billRowData, List<BaseColumn> main_collect, Map<String, Integer> columnIndexes, Long templateID) {
        boolean ishassubitems;
        HashMap<String, String> centralOrgMap;
        List approveBills = Lists.newArrayList();
        DynamicObject ebCentralAppBillId = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"parentid,id,billno,ishassubitems,splitnode,centralorg.name,approveconfig_tag", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNumber)});
        if (ebCentralAppBillId != null) {
            centralOrgMap = this.QueryCentralOrg(ebCentralAppBillId.getLong("id"));
            ishassubitems = ebCentralAppBillId.getBoolean("ishassubitems");
            QFilter qFilter = new QFilter("parentid", "=", ebCentralAppBillId.get("id"));
            qFilter.and("billstatus", "!=", (Object)"F");
            approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter);
        } else {
            centralOrgMap = null;
            ishassubitems = false;
            approveBills = new ArrayList(16);
        }
        HashMap<String, String> dimkeyMapfieldKey = new HashMap<String, String>(16);
        for (BaseColumn baseColumn : main_collect) {
            String dimNumber;
            DimensionColumn ncolumn;
            if (baseColumn instanceof DimensionColumn) {
                ncolumn = (DimensionColumn)baseColumn;
                dimNumber = ncolumn.getDimNumber();
                dimkeyMapfieldKey.put(dimNumber, ncolumn.getKey());
                continue;
            }
            if (!(baseColumn instanceof RowDimensionColumn)) continue;
            ncolumn = (RowDimensionColumn)baseColumn;
            dimNumber = ncolumn.getDimNumber();
            dimkeyMapfieldKey.put(dimNumber, ncolumn.getKey());
        }
        for (Object[] billRowDatum : billRowData) {
            List finalApproveBills = approveBills;
            main_collect.forEach(column -> {
                if (column instanceof TextColumn) {
                    TextColumn textColumn = (TextColumn)column;
                    if (SourceTextEnum.CentralOrg.getValue() == textColumn.getSourceTextEnum()) {
                        if (ishassubitems) {
                            for (ApproveBill approveBill : finalApproveBills) {
                                Object approveBillConfig2;
                                List approveConfig = approveBill.getApproveconfig();
                                List filterList = approveConfig.stream().filter(s -> Objects.equals(s.getTemplateId(), templateID)).collect(Collectors.toList());
                                ArrayList matchMemberIds = new ArrayList(16);
                                for (Object approveBillConfig2 : filterList) {
                                    matchMemberIds.addAll(approveBillConfig2.getMatchMemberIds());
                                }
                                boolean ismatch = false;
                                approveBillConfig2 = matchMemberIds.iterator();
                                while (approveBillConfig2.hasNext()) {
                                    Map filterMemberIds = (Map)approveBillConfig2.next();
                                    HashSet<Boolean> isrowmatch = new HashSet<Boolean>(16);
                                    for (Map.Entry stringSetEntry : filterMemberIds.entrySet()) {
                                        String memberKey = (String)stringSetEntry.getKey();
                                        Set values = (Set)stringSetEntry.getValue();
                                        if (dimkeyMapfieldKey.get(memberKey) == null) {
                                            isrowmatch.add(true);
                                            break;
                                        }
                                        Integer index = (Integer)columnIndexes.get(dimkeyMapfieldKey.get(memberKey));
                                        Object value = billRowDatum[index];
                                        isrowmatch.add(values.contains(value));
                                    }
                                    if (isrowmatch.contains(false)) continue;
                                    ismatch = true;
                                    break;
                                }
                                if (!ismatch) continue;
                                Integer index = (Integer)columnIndexes.get(column.getKey());
                                billRowDatum[index.intValue()] = centralOrgMap.get(approveBill.getBillNo());
                                break;
                            }
                        } else if (ebCentralAppBillId != null) {
                            Integer index = (Integer)columnIndexes.get(column.getKey());
                            billRowDatum[index.intValue()] = ebCentralAppBillId.getString("centralorg.name");
                        }
                    }
                }
            });
        }
    }

    private HashMap<String, String> QueryCentralOrg(Long id) {
        HashMap<String, String> centralOrgMap = new HashMap<String, String>(16);
        DynamicObjectCollection ebCentralAppBills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"parentid,id,billno,ishassubitems,splitnode,centralorg.name,approveconfig_tag", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)id)});
        if (ebCentralAppBills.size() > 0) {
            for (DynamicObject ebCentralAppBill : ebCentralAppBills) {
                centralOrgMap.put(ebCentralAppBill.getString("billno"), ebCentralAppBill.getString("centralorg.name"));
            }
        }
        return centralOrgMap;
    }

    private List<ApproveBill> getCenAppBillByRptOrColBill(String billNo, String billType) {
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL.getNumber());
        String billNoField = "sumbillno";
        if (billType.equals(ApplyBillType.APPLY.getNumber())) {
            billNoField = "reportbillno";
            qFilter.and(new QFilter("centralapprptentity.sumbillno", "=", (Object)""));
        }
        qFilter.and(new QFilter("centralapprptentity." + billNoField, "=", (Object)billNo));
        return ApproveBillUtil.getInstance().getApproveBills(qFilter);
    }

    protected void setEntityInitData(EntryTemplateConfig templateConfig, Map<String, Map<String, Set<Long>>> groupMembsByStats, DetailMembBillData detailMembBillData, String entityKey, Long bizCtrlRangeId, IModelCacheHelper modelCacheHelper, ApplyBillEntityData billEntityData) {
        List<Map<String, String>> allFirstRow = this.getAllFirstRow(templateConfig, groupMembsByStats, detailMembBillData);
        if (allFirstRow.size() > 0) {
            List dimKeysList = templateConfig.getDimKeysList();
            List notTreeDimKeys = templateConfig.getNotTreeDimKeys();
            Set noDetailKeys = dimKeysList.stream().filter(dimKey -> !notTreeDimKeys.contains(dimKey)).collect(Collectors.toSet());
            HashMap<Integer, Map<String, String>> noDetailMembers = new HashMap<Integer, Map<String, String>>(allFirstRow.size());
            if (CollectionUtils.isNotEmpty(noDetailKeys)) {
                for (int i = 0; i < allFirstRow.size(); ++i) {
                    noDetailMembers.put(i, allFirstRow.get(i));
                }
            }
            Map aggColumnDataMap = BgApplyBillUtils.getInstance().getOlapDataForNoDetail(templateConfig, noDetailMembers, templateConfig.getAggKeys());
            int[] newRowIndexs = this.getModel().batchCreateNewEntryRow(entityKey, allFirstRow.size());
            int count = 0;
            for (Map<String, String> sameParentNum : allFirstRow) {
                BigDecimal unitData = this.getUnitData(templateConfig.getUnit());
                List columns = templateConfig.getEntryColumns();
                unitData = BigDecimal.ONE.divide(unitData);
                Map<Object, Object> data = Maps.newHashMap();
                if (aggColumnDataMap != null && aggColumnDataMap.get(count) != null) {
                    data = this.changeBigDecimalUnit((Map)aggColumnDataMap.get(count), unitData, columns, templateConfig.getCurrencyColumnKeys());
                }
                int rowIndex = newRowIndexs[count++];
                this.setEntityInitData(rowIndex, sameParentNum, detailMembBillData, modelCacheHelper, billEntityData, entityKey, templateConfig, data);
            }
        }
    }

    private Map<String, BigDecimal> changeBigDecimalUnit(Map<String, BigDecimal> data, BigDecimal unitData, List<BaseColumn> columns, Set<String> currencyColumnKeys) {
        if (data == null) {
            return null;
        }
        Map<String, BigDecimal> modifiedMap = data.entrySet().stream().collect(Collectors.toMap(s -> (String)s.getKey(), entry -> {
            if (!this.isCurrencyColumn((String)entry.getKey(), currencyColumnKeys)) {
                return (BigDecimal)entry.getValue();
            }
            if (entry.getValue() != null) {
                return ((BigDecimal)entry.getValue()).multiply(unitData);
            }
            return BigDecimal.ZERO;
        }));
        return modifiedMap;
    }

    private boolean isCurrencyColumn(String key, Set<String> currencyColumnKeys) {
        return currencyColumnKeys.contains(key);
    }

    protected List<Map<String, String>> getAllFirstRow(EntryTemplateConfig templateConfig, Map<String, Map<String, Set<Long>>> groupMembsByStats, DetailMembBillData detailMembBillData) {
        ArrayList<Map<String, String>> allFirstRow = new ArrayList<Map<String, String>>(16);
        for (Map.Entry<String, Map<String, Set<Long>>> entry : groupMembsByStats.entrySet()) {
            Map<String, Set<Long>> dimsMembId = entry.getValue();
            if (entry.getKey().length() > 0) {
                String[] membIds = entry.getKey().split(",");
                for (int i = 0; i < membIds.length; ++i) {
                    HashSet<Long> ids = new HashSet<Long>(1);
                    ids.add(Long.valueOf(membIds[i]));
                    dimsMembId.put((String)templateConfig.getNotTreeDimKeys().get(i), (Set<Long>)ids);
                }
            }
            Map<String, String> sameParentNum = this.getSameParentNum(templateConfig, dimsMembId);
            this.replateFirstRowMemb(sameParentNum, templateConfig, dimsMembId);
            if (sameParentNum.isEmpty()) continue;
            allFirstRow.add(sameParentNum);
        }
        return allFirstRow;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("path_")) {
            this.backToNode(key, false);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (opKey.startsWith("viewdata")) {
            this.doViewData(opKey);
        } else if (opKey.startsWith("queryplan")) {
            this.doQueryPlan();
        }
    }

    @Override
    protected Boolean beforeEntryEntityExport() {
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        ArrayList<CustomSelectGroup> groups = new ArrayList<CustomSelectGroup>(16);
        HashMap<Long, String> definedDimensions = new HashMap<Long, String>(16);
        for (Map.Entry entry : entryTemplateConfig.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (!entryKey.startsWith("entryentity")) continue;
            CustomSelectGroup group = new CustomSelectGroup();
            ArrayList customSelectItems = new ArrayList(16);
            EntryTemplateConfig tempConfig = (EntryTemplateConfig)entry.getValue();
            long templateId = tempConfig.getTemplateID();
            Set dims = ApplyTemplateDimCfgService.getInstance().getStatisticsDimCfg(Long.valueOf(templateId));
            List entryColumns = tempConfig.getEntryColumns();
            entryColumns.forEach(col -> {
                String colDimNumber = null;
                if (col instanceof DimensionColumn || col instanceof RelationDimensionColumn || col instanceof RowDimensionColumn) {
                    colDimNumber = BgApplyBillUtils.getInstance().getDimOrRelateDimNumber(col, modelCacheHelper);
                }
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)colDimNumber) && col.isFinalVisible() && !SysDimensionEnum.include((String)colDimNumber, (Boolean)true) && dims.contains(colDimNumber)) {
                    customSelectItems.add(new CustomSelectItem(colDimNumber, col.getTitle()));
                }
            });
            if (customSelectItems.size() > 1) {
                group.setKey(String.valueOf(templateId));
                group.setName(tempConfig.getName());
                CustomSelectItemSetting setting = new CustomSelectItemSetting();
                setting.setMultiply(Boolean.valueOf(false));
                group.setSetting(setting);
                group.setCustomSelectItems(customSelectItems);
                groups.add(group);
                continue;
            }
            if (customSelectItems.size() != 1) continue;
            definedDimensions.put(templateId, ((CustomSelectItem)customSelectItems.get(0)).getKey());
        }
        this.getPageCache().put("userSelCusDimOfExport", SerializationUtils.serializeToBase64(definedDimensions));
        if (groups.size() != 0) {
            this.openCustomDimSel(groups);
            return true;
        }
        return false;
    }

    private void openCustomDimSel(List<CustomSelectGroup> groups) {
        CustomSelectUtil instance = CustomSelectUtil.getInstance();
        CustomShowParam customShowParam = instance.createCustomShowParam(groups, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u9009\u62e9", (String)"", (String)"", (Object[])new Object[0]), null, 10);
        FormShowParameter formShowParameter = instance.getCustomPageParameter(customShowParam);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openCusDimSelForm"));
        this.getView().showForm(formShowParameter);
    }

    private void doQueryPlan() {
        Tab tabap = (Tab)this.getView().getControl("tabap");
        String currentTab = tabap.getCurrentTab();
        String entryentityname = currentTab.substring(3);
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl(entryentityname);
        int focusRow = entrygrid.getEntryState().getFocusRow();
        if (focusRow == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BgApplyBillPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entityEntryTemplateConfig = (EntryTemplateConfig)entryTemplateConfig.get(entryentityname);
        String bizentityName = "biz" + entryentityname;
        EntryTemplateConfig bizentityEntryTemplateConfig = (EntryTemplateConfig)entryTemplateConfig.get(bizentityName);
        if (entityEntryTemplateConfig == null || bizentityEntryTemplateConfig == null) {
            return;
        }
        String busPlanDetailKey = entityEntryTemplateConfig.getBusPlanDetailKey();
        Object value = this.getModel().getValue(busPlanDetailKey, focusRow);
        if (value == null || !Boolean.parseBoolean(value.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9884\u7b97\u7533\u62a5\u4fe1\u606f\u5f53\u524d\u884c\u7684\u201c\u4e1a\u52a1\u8ba1\u5212\u660e\u7ec6\u201d\u3002", (String)"BgApplyBillPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List<String> bizTableKeys = this.openBizTableKeys(focusRow, entryentityname);
        if (bizTableKeys == null || bizTableKeys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9884\u7b97\u7533\u62a5\u4fe1\u606f\u5f53\u524d\u884c\u7684\u201c\u4e1a\u52a1\u8ba1\u5212\u660e\u7ec6\u201d\u3002", (String)"BgApplyBillPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        ApplyBillEntityData entityNodeData = this.getOrCacheBillEntityNodeData(entryentityname, null).getCurrentNodeData();
        DynamicObject dataentity = this.getModel().getEntryRowEntity(entryentityname, focusRow);
        FormShowParameter formShowParameter = new FormShowParameter();
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1200");
        styleCss.setHeight("600");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        formShowParameter.setFormId("eb_queryplan");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String paramStr = (String)this.getView().getFormShowParameter().getCustomParam("bgApplyENtryInfo");
        formShowParameter.setCustomParam("bgApplyENtryInfo", (Object)paramStr);
        formShowParameter.setCustomParam("dny", (Object)SerializationUtils.serializeToBase64((Object)dataentity));
        formShowParameter.setCustomParam("allApplyBillEntityData", (Object)SerializationUtils.serializeToBase64((Object)entityNodeData));
        formShowParameter.setCustomParam("entryentityname", (Object)bizentityName);
        formShowParameter.setCustomParam("entryname", (Object)entryentityname);
        formShowParameter.setCustomParam("bizCtrlRangeId", (Object)String.valueOf(bizCtrlRangeId));
        formShowParameter.setCustomParam("row", (Object)focusRow);
        formShowParameter.setCustomParam("bizEntryCache", (Object)this.getView().getPageCache().get("bizEntryCache"));
        formShowParameter.setCustomParam("BizPlanRangeSumKeys", (Object)SerializationUtils.serializeToBase64(bizTableKeys));
        this.getView().showForm(formShowParameter);
    }

    protected List<String> openBizTableKeys(int row, String entryname) {
        List<String> tabKeys = new ArrayList<String>(16);
        if (entryname.startsWith("entryentity") && row != -1) {
            DynamicObject dataentity = this.getModel().getEntryRowEntity(entryname, row);
            BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
            Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
            EntryTemplateConfig entryTemplateConfig1 = (EntryTemplateConfig)entryTemplateConfig.get(entryname);
            long templateID = entryTemplateConfig1.getTemplateID();
            HashSet dimKeysList = new HashSet(entryTemplateConfig1.getDimKeysList());
            List<BaseColumn> dimCollect = entryTemplateConfig1.getEntryColumns().stream().filter(ee -> dimKeysList.contains(ee.getKey())).collect(Collectors.toList());
            String dimStr = this.joinCombineDimensionIds(dimCollect, dataentity);
            String templateIdAndDimStr = ApplyTemplateDimRangeService.getInstance().getTemplateIdAndDimStr(String.valueOf(templateID), dimStr);
            Map<String, Set<String>> bizPlanRangeSumKeys = this.getBizPlanRangeSumKeys(templateIdAndDimStr, entryname, dataentity);
            String bizentityName = entryname.replace("entryentity", "bizentryentity");
            EntryTemplateConfig bizEntryCfg = (EntryTemplateConfig)entryTemplateConfig.get(bizentityName);
            if (bizPlanRangeSumKeys != null && !bizPlanRangeSumKeys.isEmpty()) {
                ArrayList keys = new ArrayList(16);
                for (Map.Entry<String, Set<String>> stringSetEntry : bizPlanRangeSumKeys.entrySet()) {
                    keys.addAll(stringSetEntry.getValue());
                }
                tabKeys = bizEntryCfg.getEntryColumns().stream().filter(s -> keys.contains(s.getKey())).map(BaseColumn::getBizPlanTabKey).collect(Collectors.toList());
            } else {
                for (BaseColumn entryColumn : bizEntryCfg.getEntryColumns()) {
                    tabKeys.add(entryColumn.getBizPlanTabKey());
                }
            }
        }
        return tabKeys;
    }

    private void doViewData(String opKey) {
        String currentEntityKey = this.getCurrentEntityKey();
        EntryTemplateConfig templateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(currentEntityKey);
        List notTreeDimKeys = templateConfig.getNotTreeDimKeys();
        List dimKeysList = templateConfig.getDimKeysList();
        ArrayList<Pair> dimInfo = new ArrayList<Pair>(16);
        for (BaseColumn column : templateConfig.getEntryColumns()) {
            String columnKey = column.getKey();
            if (!dimKeysList.contains(columnKey) || notTreeDimKeys.contains(columnKey)) continue;
            dimInfo.add(new Pair((Object)columnKey, (Object)column.getTitle()));
        }
        if (dimInfo.isEmpty()) {
            return;
        }
        ApplyBillEntityNodeData entityNodeData = this.getOrCacheBillEntityNodeData(currentEntityKey, null);
        String currentDimColumnKey = entityNodeData.getCurrentDimColumnKey();
        if (currentDimColumnKey == null) {
            currentDimColumnKey = (String)((Pair)dimInfo.get((int)0)).p1;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_viewdataway");
        formShowParameter.setCustomParam("ROWDIMINFO", (Object)SerializationUtils.toJsonString(dimInfo));
        formShowParameter.setCustomParam("DEFAULTDIMCOLUMN", (Object)currentDimColumnKey);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewData"));
        this.getView().showForm(formShowParameter);
    }

    private void backToNode(String nodeKey, boolean fromViewData) {
        boolean hasChangeRow;
        ApplyBillEntityData currentNodeData;
        int[] cacheDataRowIndexs;
        String entityKey = this.getCurrentEntityKey();
        ApplyBillEntityNodeData entityNodeData = this.getOrCacheBillEntityNodeData(entityKey, null);
        ApplyBillEntityData toNodeData = entityNodeData.getNodeDataByKey(nodeKey);
        EntityPathNode nodeByKey = entityNodeData.getNodeByKey(nodeKey);
        List<DynamicObject> newRowObjs = this.cacheNewRowB4ChangeNode(entityKey);
        this.getModel().deleteEntryData(entityKey);
        String nodeDimColumn = nodeByKey.getRefDimColumnKey();
        if (nodeByKey.isInitNode() || fromViewData) {
            boolean isFirstNode;
            boolean bl = isFirstNode = entityNodeData.getNodes().get(0) == nodeByKey;
            if (isFirstNode) {
                int rowSize = toNodeData.getRowIds().size();
                cacheDataRowIndexs = new int[rowSize];
                for (int i = 0; i < rowSize; ++i) {
                    cacheDataRowIndexs[i] = i;
                }
            } else {
                ArrayList<Integer> cacheDataRowIndexList = new ArrayList<Integer>(16);
                List listDataOfColumn = toNodeData.getListDataOfColumn(nodeDimColumn);
                for (int index = 0; index < listDataOfColumn.size(); ++index) {
                    EntityCellBaseData entityCellBaseData = (EntityCellBaseData)listDataOfColumn.get(index);
                    if (nodeByKey.isOpenAll()) {
                        cacheDataRowIndexList.add(index);
                        if (entityCellBaseData.isLeaf()) continue;
                        entityCellBaseData.setGroupStatus(CellGroupStatusEnum.OPEN);
                        continue;
                    }
                    int level = entityCellBaseData.getLevel();
                    if (level == 1 || level == 2) {
                        cacheDataRowIndexList.add(index);
                    }
                    if (!entityCellBaseData.isLeaf() && level != 1) {
                        entityCellBaseData.setGroupStatus(CellGroupStatusEnum.CLOSE);
                        continue;
                    }
                    if (entityCellBaseData.isLeaf() || level != 1) continue;
                    entityCellBaseData.setGroupStatus(CellGroupStatusEnum.OPEN);
                }
                cacheDataRowIndexs = new int[cacheDataRowIndexList.size()];
                for (int i = 0; i < cacheDataRowIndexList.size(); ++i) {
                    cacheDataRowIndexs[i] = (Integer)cacheDataRowIndexList.get(i);
                }
            }
        } else {
            cacheDataRowIndexs = this.getChildCacheRowIndexs(-1, toNodeData, nodeDimColumn);
        }
        if (toNodeData != (currentNodeData = entityNodeData.getCurrentNodeData()) && (hasChangeRow = this.updateAllEntryModifiedData(entityKey, currentNodeData, toNodeData))) {
            for (ApplyBillEntityData nodeData : entityNodeData.getNodeEntityData()) {
                this.updateNowEntryAggData(entityKey, nodeData);
                if (nodeData != toNodeData) continue;
                break;
            }
        }
        entityNodeData.removeNodeDataByKey(nodeKey);
        EntryTemplateConfig templateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityKey);
        this.setNeedDealPropchange(false);
        this.openChildRowFromCache(this.getModel(), toNodeData, -1, -1, cacheDataRowIndexs, entityKey, templateConfig.getColumnIndex(), nodeDimColumn);
        this.setNeedDealPropchange(true);
        this.updatePathShow(entityKey, entityNodeData.getNodes());
        this.getOrCacheBillEntityNodeData(entityKey, entityNodeData);
        this.backNewRowAfterChangeNode(newRowObjs, entityKey);
    }

    private List<DynamicObject> cacheNewRowB4ChangeNode(String entryKey) {
        DynamicObjectCollection entryRowObjs = this.getModel().getEntryEntity(entryKey);
        ArrayList<DynamicObject> newRowObjs = new ArrayList<DynamicObject>(16);
        entryRowObjs.forEach(row -> {
            Long rowId = row.getLong("id");
            if (rowId == null || rowId.equals(0L)) {
                newRowObjs.add((DynamicObject)row);
            }
        });
        return newRowObjs;
    }

    private void backNewRowAfterChangeNode(List<DynamicObject> newRowObjs, String entryKey) {
        IDataModel dataModel = this.getModel();
        for (DynamicObject rowObj : newRowObjs) {
            dataModel.createNewEntryRow(entryKey, rowObj);
        }
    }

    private void updateNowEntryAggData(String entityKey, ApplyBillEntityData entityData) {
        DetailMembBillData detailMembBillData = this.getOrCacheDetailData(entityKey, null);
        EntryTemplateConfig templateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityKey);
        List dimKeysList = templateConfig.getDimKeysList();
        Set allAggColumnKeys = templateConfig.getAggKeys();
        int rowSize = entityData.getRowIds().size();
        HashMap<String, String> dimMembNums = new HashMap<String, String>(16);
        StringBuilder sb = new StringBuilder();
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            for (String dimColumnKey : dimKeysList) {
                EntityCellBaseData cellBaseData = entityData.getCellBaseData(rowIndex, dimColumnKey);
                dimMembNums.put(dimColumnKey, cellBaseData.getNumber());
                sb.append(cellBaseData.getNumber()).append(',');
            }
            Map data = ApplyBillAggHelper.getInstance().getData(dimMembNums, detailMembBillData, (Collection)allAggColumnKeys, templateConfig);
            for (Map.Entry dataEntry : data.entrySet()) {
                entityData.addCellOtherData(rowIndex, (String)dataEntry.getKey(), dataEntry.getValue());
            }
            sb.setLength(0);
            dimMembNums.clear();
        }
    }

    private boolean updateAllEntryModifiedData(String entityKey, ApplyBillEntityData nowNodeData, ApplyBillEntityData toNodeData) {
        Map<String, Set<Long>> changedRowIds = this.getChangedRowIds();
        Set cRowIds = changedRowIds.computeIfAbsent(entityKey, key -> new HashSet(16));
        boolean hasChangedRow = this.syncChangeOnNodeData(nowNodeData, toNodeData, cRowIds);
        if (hasChangedRow) {
            this.cacheChangedRowIds(changedRowIds);
        }
        return hasChangedRow;
    }

    private boolean syncChangeOnNodeData(ApplyBillEntityData nowNodeData, ApplyBillEntityData toNodeData, Set<Long> cRowIds) {
        int rowIndexSource = 0;
        boolean hasChangedRow = false;
        Iterator iterator = nowNodeData.getRowChanged().iterator();
        while (iterator.hasNext()) {
            boolean rowChanged = (Boolean)iterator.next();
            if (rowChanged) {
                Long rowId = nowNodeData.getRowIbByIndex(rowIndexSource);
                if (cRowIds != null) {
                    cRowIds.add(rowId);
                }
                hasChangedRow = true;
                if (toNodeData != null) {
                    int rowIndexTarget = toNodeData.getRowIndexByRowId(rowId);
                    if (rowIndexTarget == -1) continue;
                    for (String key : toNodeData.getOtherDataKeys()) {
                        toNodeData.addCellOtherData(rowIndexTarget, key, nowNodeData.getCellOtherData(rowIndexSource, key));
                    }
                    toNodeData.setRowChanged(rowIndexTarget, true);
                }
            }
            ++rowIndexSource;
        }
        return hasChangedRow;
    }

    @Override
    protected void afterInitEntityData() {
        super.afterInitEntityData();
        this.updateAllEntryNodePathShow();
        this.afterInitRowData();
    }

    private void afterInitRowData() {
        this.getEntryInfoFromFormParam().getEntryTemplateConfig().forEach((entryKey, tempConfig) -> {
            int rowCount;
            if (!this.isBizEntry((String)entryKey) && (rowCount = this.getModel().getEntryRowCount(entryKey)) > 0) {
                List rowIndexs = CommonServiceHelper.buildIntArrays((int)rowCount);
                this.updateRowsRelationValues(rowIndexs, (EntryTemplateConfig)tempConfig);
                this.setRowRejectTxt((String)entryKey, rowIndexs);
            }
        });
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key != null && key.startsWith("path_")) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.setModel(this.getModel());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }

    protected void updateAllEntryNodePathShow() {
        Map<String, ApplyBillEntityNodeData> billEntityNodeData = this.getAllBillEntityNodeData();
        for (Map.Entry<String, ApplyBillEntityNodeData> entry : billEntityNodeData.entrySet()) {
            this.updatePathShow(entry.getKey(), entry.getValue().getNodes());
        }
    }

    protected DetailMembBillData getSourceData(String entryKey) {
        return this.getOrCacheDetailData(entryKey, null);
    }

    protected void cacheAllSourceData() {
        if (this.allDetailData != null) {
            this.allDetailData.forEach(this::getOrCacheDetailData);
        }
    }

    protected Map<String, DetailMembBillData> getAllSourceData() {
        Map entryTemplateConfig;
        if (this.allDetailData == null) {
            this.allDetailData = new HashMap<String, DetailMembBillData>(16);
        }
        if ((entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig()).size() > this.allDetailData.size() * 2) {
            for (String key : entryTemplateConfig.keySet()) {
                if (!this.isMainEntry(key)) continue;
                this.getOrCacheDetailData(key, null);
            }
        }
        return this.allDetailData;
    }

    protected void cacheSourceData(String entryKey) {
        DetailMembBillData detailMembBillData;
        if (this.allDetailData != null && (detailMembBillData = this.allDetailData.get(entryKey)) != null) {
            this.getOrCacheDetailData(entryKey, detailMembBillData);
        }
    }

    protected DetailMembBillData getOrCacheDetailData(String entryKey, DetailMembBillData detailMembBillData) {
        if (this.allDetailData == null) {
            this.allDetailData = new HashMap<String, DetailMembBillData>(16);
        }
        String cacheKey = "DetailRowBillData_" + entryKey;
        if (detailMembBillData == null) {
            detailMembBillData = this.allDetailData.computeIfAbsent(entryKey, key -> {
                String cacheStr = this.getPageCache().getBigObject(cacheKey);
                if (this.notEmpty(cacheStr)) {
                    DetailMembBillData billData = (DetailMembBillData)SerializationUtils.deSerializeFromBase64((String)cacheStr);
                    if (billData != null) {
                        billData.setTemplateConfig(this.getTempConfig(entryKey));
                    }
                    return billData;
                }
                return null;
            });
        } else {
            this.getPageCache().putBigObject(cacheKey, SerializationUtils.serializeToBase64((Object)detailMembBillData));
            this.allDetailData.put(entryKey, detailMembBillData);
        }
        return detailMembBillData;
    }

    protected ApplyBillEntityData getCurrentNodeData(String mainEntryKey) {
        ApplyBillEntityNodeData entityNodeData = this.getOrCacheBillEntityNodeData(mainEntryKey, null);
        if (entityNodeData == null) {
            return null;
        }
        return entityNodeData.getCurrentNodeData();
    }

    protected Map<String, ApplyBillEntityNodeData> getAllBillEntityNodeData() {
        Map entryTemplateConfig;
        if (this.allNodeEntryData == null) {
            this.allNodeEntryData = new HashMap<String, ApplyBillEntityNodeData>(16);
        }
        if ((entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig()).size() > this.allNodeEntryData.size() * 2) {
            for (String key : entryTemplateConfig.keySet()) {
                if (!this.isMainEntry(key)) continue;
                this.getOrCacheBillEntityNodeData(key, null);
            }
        }
        return this.allNodeEntryData;
    }

    protected void cacheAllBillEntityNodeData(boolean clearAll) {
        if (this.allNodeEntryData != null) {
            if (clearAll) {
                for (String entryKey : this.allNodeEntryData.keySet()) {
                    String cacheKey = "ApplyBillEntityNodeData_" + entryKey;
                    this.getPageCache().removeBigObject(cacheKey);
                }
                this.allNodeEntryData = new HashMap<String, ApplyBillEntityNodeData>(16);
            } else {
                this.allNodeEntryData.forEach(this::getOrCacheBillEntityNodeData);
            }
        }
    }

    protected ApplyBillEntityNodeData getOrCacheBillEntityNodeData(String entryKey, ApplyBillEntityNodeData entityNodeData, boolean backDefault) {
        String cacheKey = "ApplyBillEntityNodeData_" + entryKey;
        if (this.allNodeEntryData == null) {
            this.allNodeEntryData = new HashMap<String, ApplyBillEntityNodeData>(10);
        }
        if (entityNodeData == null) {
            entityNodeData = this.allNodeEntryData.computeIfAbsent(entryKey, key -> {
                String cacheStr = this.getPageCache().getBigObject(cacheKey);
                if (this.notEmpty(cacheStr)) {
                    return (ApplyBillEntityNodeData)SerializationUtils.deSerializeFromBase64((String)cacheStr);
                }
                if (backDefault) {
                    return new ApplyBillEntityNodeData();
                }
                return null;
            });
        } else {
            this.allNodeEntryData.put(entryKey, entityNodeData);
            this.getPageCache().putBigObject(cacheKey, SerializationUtils.serializeToBase64((Object)entityNodeData));
        }
        return entityNodeData;
    }

    protected void cacheBillEntryNodeData(String entryKey) {
        ApplyBillEntityNodeData entityNodeData;
        if (this.allNodeEntryData != null && (entityNodeData = this.allNodeEntryData.get(entryKey)) != null) {
            this.getOrCacheBillEntityNodeData(entryKey, entityNodeData);
        }
    }

    protected ApplyBillEntityNodeData getOrCacheBillEntityNodeData(String entryKey, ApplyBillEntityNodeData entityNodeData) {
        return this.getOrCacheBillEntityNodeData(entryKey, entityNodeData, false);
    }

    @Override
    protected void saveBillData(BillSaveEventArgs eventArgs) {
        Map<String, DetailMembBillData> detailDatas = this.getAllSourceData();
        Map<String, Map<Long, Map<String, Object>>> changeAuditData = this.getOrCacheColumnInitData(null);
        BgApplyENtryInfo eNtryInfo = this.getEntryInfoFromFormParam();
        String billNumber = this.getBillNumber();
        Long userId = UserUtils.getUserId();
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        Long currentOrgId = (Long)this.getValue("collectorg", "id");
        Long lastCollectOrg = this.getOrCacheLastCollectOrg(null);
        boolean needDelOldRecord = lastCollectOrg != null && !lastCollectOrg.equals(currentOrgId);
        HashMap<String, ArrayList<AuditRecordObj>> allAuditRecordObjs = new HashMap<String, ArrayList<AuditRecordObj>>(16);
        HashMap<String, ArrayList<Integer>> allToDelRowIndex = new HashMap<String, ArrayList<Integer>>(16);
        HashMap<String, HashMap<Integer, Long>> allNewRowIndexMapId = new HashMap<String, HashMap<Integer, Long>>(16);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (Map.Entry entry : eNtryInfo.getEntryTemplateConfig().entrySet()) {
            String entityKey = (String)entry.getKey();
            if (this.isBizEntry(entityKey)) continue;
            ArrayList<AuditRecordObj> auditRecordList = new ArrayList<AuditRecordObj>(16);
            allAuditRecordObjs.put(entityKey, auditRecordList);
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)entry.getValue();
            Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
            BigDecimal unitData = this.getUnitData(templateConfig.getUnit());
            List main_columns = templateConfig.selectEntryColumnsNoDimText();
            main_columns.removeIf(BaseColumn::isIgnoreDB);
            String tableName = templateConfig.getEntryTable();
            Map<Long, Map<String, Object>> entityAllChangeVals = changeAuditData.get(entityKey);
            DetailMembBillData detailData = detailDatas.get(entityKey);
            detailData.initRowStatusByRowId();
            Map columnMapIndex = templateConfig.getColumnIndex();
            Map<String, BaseColumn> columnMap = main_columns.stream().collect(Collectors.toMap(p -> p.getKey(), p -> p));
            List dimColumnKeys = templateConfig.getDimKeysList();
            ArrayList<Object[]> toSaveRowsData = new ArrayList<Object[]>(16);
            ArrayList<Object[]> toUpdateRowsData = new ArrayList<Object[]>(16);
            HashMap<Integer, Long> rowIndexMapId = new HashMap<Integer, Long>(16);
            ArrayList<Integer> todelRowIndexs = new ArrayList<Integer>(16);
            this.selectNewRowInfo(toSaveRowsData, templateConfig, this.getBillType(), billNumber, entityKey, detailData, unitData, rowIndexMapId, todelRowIndexs);
            allToDelRowIndex.put(entityKey, todelRowIndexs);
            this.updateAuditRecord(templateConfig.getCurrencyColumnKeys(), entityAllChangeVals, unitData);
            HashMap toUpdateVals = new HashMap(16);
            if (!toSaveRowsData.isEmpty()) {
                for (Object[] objectArray : toSaveRowsData) {
                    AuditRecordObj recordObj = this.selectNewRowAuditRecord(objectArray, templateConfig);
                    this.addBaseInfo2AuditReocrd(templateConfig, billNumber, recordObj, auditRecordList);
                }
                eventArgs.setReloadPage(true);
                eventArgs.setHasNewRow(true);
            }
            if (entityAllChangeVals != null) {
                HashMap<String, Object> moddifVals = new HashMap<String, Object>(16);
                for (Map.Entry<Long, Map<String, Object>> changedDataEntry : entityAllChangeVals.entrySet()) {
                    Object[] rowDataCopy;
                    Long rowId = changedDataEntry.getKey();
                    RowDataStatus rowDataStatus = (RowDataStatus)detailData.getSourceDataRowStatus().get(rowId);
                    if (rowDataStatus == null) continue;
                    Object[] rowData = (Object[])detailData.getAllRowData().get(rowDataStatus.getRowIndex());
                    Map bizData = null;
                    if (!rowDataStatus.isDetail()) {
                        Map<String, String> dimMembParam = this.selectRowDimMembNum(dimColumnKeys, rowData, columnMapIndex, templateConfig.selectColumnMapDimNum(), modelCacheHelper, dimViewMap);
                        bizData = ApplyBillAggHelper.getInstance().getData(dimMembParam, detailData, (Collection)templateConfig.getAggKeys(), templateConfig);
                    }
                    this.updateUnit(rowData, unitData, templateConfig.getCurrencyColumnKeys(), templateConfig.getColumnIndex(), false);
                    this.updateUnit(bizData, unitData, templateConfig.getCurrencyColumnKeys());
                    AuditRecordObj recordObj = this.selectRowAuditRecord(rowData, templateConfig, false, rowDataStatus.isDetail(), changedDataEntry.getValue(), bizData);
                    this.addBaseInfo2AuditReocrd(templateConfig, billNumber, recordObj, auditRecordList);
                    if (rowDataStatus.isNewEdit()) {
                        this.setDefaultColumnVal(rowData, rowId, this.getBillType(), billNumber, EntityRowDataType.EDIT_NOTDETAIL.getNumber(), main_columns, columnMapIndex);
                        rowDataCopy = Arrays.copyOf(rowData, rowData.length);
                        toSaveRowsData.add(rowDataCopy);
                    } else {
                        this.selectChangeVal(moddifVals, rowData, Collections.EMPTY_SET, unitData, changedDataEntry.getValue().keySet(), columnMap, columnMapIndex);
                        ApplyBillPluginUitl.selectToUpdateVal(moddifVals, (String)templateConfig.getEntryTable(), (Long)userId, (Timestamp)now, (Long)rowId, toUpdateVals);
                        rowDataCopy = Arrays.copyOf(rowData, rowData.length);
                        toUpdateRowsData.add(rowDataCopy);
                    }
                    this.updateUnit(rowData, unitData, templateConfig.getCurrencyColumnKeys(), templateConfig.getColumnIndex(), true);
                }
            }
            allToDelRowIndex.put(entityKey, todelRowIndexs);
            allNewRowIndexMapId.put(entityKey, rowIndexMapId);
            DBRoute route = new DBRoute("epm");
            if (needDelOldRecord) {
                String string = "delete from %s where fbillnumber = '%s'";
                this.executeOrBatch(route, String.format(string, tableName, billNumber), null, false);
            }
            if (!toSaveRowsData.isEmpty()) {
                String string = ApplyTemplateUtils.buildInsertSql((String)tableName, (List)main_columns);
                this.updateModifInfo(toSaveRowsData, userId, now);
                this.executeOrBatch(route, string, toSaveRowsData, true);
                eventArgs.setToSaveRowsData(toSaveRowsData);
                log.info("saveDB:" + billNumber + "entry:" + entityKey + ":count:" + toSaveRowsData.size());
            }
            if (toUpdateVals.isEmpty()) continue;
            for (Map.Entry toUpVal : toUpdateVals.entrySet()) {
                this.executeOrBatch(route, (String)toUpVal.getKey(), (List)toUpVal.getValue(), true);
            }
            eventArgs.setToUpdateRowsData(toUpdateRowsData);
            log.info("udpateDB:" + billNumber + "entry:" + entityKey + ":count:" + toUpdateVals.size());
        }
        eventArgs.setAllChangeRecord(allAuditRecordObjs);
        eventArgs.setToDelRowIndexs(allToDelRowIndex);
        eventArgs.setNewRowIndexMapId(allNewRowIndexMapId);
    }

    private void executeOrBatch(DBRoute route, String sql, List<Object[]> rowData, boolean isBatch) {
        if (isBatch) {
            DB.executeBatch((DBRoute)route, (String)sql, rowData);
        } else {
            DB.execute((DBRoute)route, (String)sql);
        }
    }

    private void updateUnit(Map<String, BigDecimal> bizData, BigDecimal unitData, Set<String> currencyColumnKeys) {
        if (bizData != null) {
            for (Map.Entry<String, BigDecimal> entry : bizData.entrySet()) {
                Object val;
                String key = entry.getKey();
                if (!currencyColumnKeys.contains(key) || (val = entry.getValue()) == null) continue;
                val = this.changeValByUnit(val, unitData);
                bizData.put(key, (BigDecimal)val);
            }
        }
    }

    protected void updateUnit(Object[] rowData, BigDecimal unitData, Set<String> currencyColumnKeys, Map<String, Integer> columnIndex, boolean isDiv) {
        if (!currencyColumnKeys.isEmpty()) {
            for (String key : currencyColumnKeys) {
                Object val;
                int index = columnIndex.get(key);
                if (!currencyColumnKeys.contains(key) || (val = rowData[index]) == null) continue;
                val = isDiv ? this.changeValByDivideUnit(val, unitData) : this.changeValByUnit(val, unitData);
                rowData[index] = val;
            }
        }
    }

    @Override
    protected void saveQuoteInfo(BillSaveEventArgs eventArgs) {
        this.saveQuteInfo4AuditBill(eventArgs);
    }

    protected void selectChangeVal(Map<String, Object> changedVal, Object[] rowVals, Set<String> currencyColumnKeys, BigDecimal unitData, Set<String> changedKeySet, Map<String, BaseColumn> columnMap, Map<String, Integer> columnIndex) {
        changedVal.clear();
        for (String key : changedKeySet) {
            BaseColumn column = columnMap.get(key);
            if (column == null) continue;
            Integer index = columnIndex.get(column.getKey());
            Object columnVal = rowVals[index];
            columnVal = this.selectColumnVal(column, columnVal, currencyColumnKeys, unitData);
            changedVal.put(column.getKey(), columnVal);
        }
    }

    private Map<String, String> selectRowDimMembNum(List<String> rowDimColumnKeys, Object[] rowData, Map<String, Integer> columnIndex, Map<String, String> columnMapDimNum, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap) {
        HashMap<String, String> dimMembInfo = new HashMap<String, String>(rowDimColumnKeys.size());
        for (String columnKey : rowDimColumnKeys) {
            Long membId = (Long)rowData[columnIndex.get(columnKey)];
            String dimNum = columnMapDimNum.get(columnKey);
            Member member = modelCacheHelper.getMember(dimNum, dimViewMap.get(dimNum), membId);
            dimMembInfo.put(columnKey, member.getNumber());
        }
        return dimMembInfo;
    }

    @Override
    protected void mainEntryEntityExport() {
        Map<String, Long> templateIds = this.getTemplateIds();
        Map<Long, List<String>> enableCols = this.getEnableEditCols(templateIds);
        Map<String, String> entityUnitSet = this.getOrCacheEntityUnitSet(null);
        CentralAppShowInfo showInfo = this.getCentralAppShowInfo();
        Map<Long, String> defineDimensions = this.getUserSelCusDimOfExport();
        SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(this.getModelId(), this.getReportSchemeId(), this.getYearId(), this.getVersionId(), this.getDataTypeId());
        ArrayList<String> billNumbers = new ArrayList<String>(16);
        HashMap<String, Map<String, Map<String, String>>> RowDimMemberMap = new HashMap<String, Map<String, Map<String, String>>>(templateIds.size());
        HashMap<String, String> centralOrgMap = new HashMap<String, String>(16);
        this.getChildRowDim(templateIds, billNumbers, RowDimMemberMap, centralOrgMap);
        String billNumber = this.getBillNumber();
        if (!billNumbers.isEmpty()) {
            billNumber = (String)billNumbers.get(0);
        }
        BgStatisticsDataExportPlugin.getInstance().colExport(showInfo, templateIds, this.getModelId(), this.getView(), billNumber, enableCols, entityUnitSet, defineDimensions, Boolean.valueOf(false), schemeAssignDimGroup, RowDimMemberMap, centralOrgMap, null);
    }

    private void getChildRowDim(Map<String, Long> templateIds, List<String> billNumbers, Map<String, Map<String, Map<String, String>>> RowDimMemberMap, HashMap<String, String> centralOrgMap) {
        DynamicObject ebCentralMainAppBill;
        DynamicObject ebCentralAppBillId = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"parentid,id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)this.getBillNumber())});
        if (ebCentralAppBillId != null && ebCentralAppBillId.getLong("parentid") != 0L && (ebCentralMainAppBill = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ebCentralAppBillId.getLong("parentid"))})) != null) {
            billNumbers.add(ebCentralMainAppBill.getString("billno"));
        }
        this.getRowData(templateIds, RowDimMemberMap, centralOrgMap);
    }

    private void getRowData(Map<String, Long> templateIds, Map<String, Map<String, Map<String, String>>> RowDimMemberMap, HashMap<String, String> centralOrgMap) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map<String, DetailMembBillData> allSourceData = this.getAllSourceData();
        for (String entryKey : templateIds.keySet()) {
            LinkedHashMap RowDimMap = new LinkedHashMap(templateIds.size());
            EntryTemplateConfig tempConfig = this.getTempConfig(entryKey);
            Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(tempConfig.getDatasetId()));
            DetailMembBillData detailMembBillData = allSourceData.get(entryKey);
            if (detailMembBillData == null) continue;
            List allRowData = detailMembBillData.getAllRowData();
            List RowColumns = tempConfig.getEntryColumns().stream().filter(e -> e instanceof RowDimensionColumn || e instanceof DimensionColumn || e instanceof RelationValueColumn).collect(Collectors.toList());
            List textColumns = tempConfig.getEntryColumns().stream().filter(e -> e instanceof TextColumn && ((TextColumn)e).getSourceTextEnum() == SourceTextEnum.CentralOrg.getValue()).collect(Collectors.toList());
            Map columnIndex = tempConfig.getColumnIndex();
            if (allRowData == null) continue;
            for (int i = 0; i < allRowData.size(); ++i) {
                HashMap<String, String> rowMap = new HashMap<String, String>(allRowData.size());
                Object[] entryDataObj = (Object[])allRowData.get(i);
                for (BaseColumn rowColumn : RowColumns) {
                    Member member;
                    Object dimMemberId;
                    DimensionColumn rowDimensionColumn;
                    String dimNumber = null;
                    String key = null;
                    if (rowColumn instanceof DimensionColumn) {
                        rowDimensionColumn = (DimensionColumn)rowColumn;
                        dimNumber = rowDimensionColumn.getDimNumber();
                        key = rowDimensionColumn.getKey();
                    } else if (rowColumn instanceof RowDimensionColumn) {
                        rowDimensionColumn = (RowDimensionColumn)rowColumn;
                        dimNumber = rowDimensionColumn.getDimNumber();
                        key = rowDimensionColumn.getKey();
                    }
                    if ((dimMemberId = entryDataObj[(Integer)columnIndex.get(key)]) == null || (member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), (Long)dimMemberId)) == null) continue;
                    rowMap.put(dimNumber, member.getNumber());
                }
                RowDimMap.put(String.valueOf(entryDataObj[0]), rowMap);
                for (BaseColumn textColumn : textColumns) {
                    Object centralOrg;
                    Integer integer = (Integer)columnIndex.get(textColumn.getKey());
                    if (integer == null || (centralOrg = entryDataObj[integer]) == null) continue;
                    centralOrgMap.put(String.valueOf(entryDataObj[0]), String.valueOf(centralOrg));
                }
            }
            RowDimMemberMap.put(entryKey, RowDimMap);
        }
    }

    private Map<Long, String> getUserSelCusDimOfExport() {
        String parStr = this.getPageCache().get("userSelCusDimOfExport");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)parStr)) {
            Map defineDimensions = (Map)SerializationUtils.deSerializeFromBase64((String)parStr);
            this.getPageCache().remove("userSelCusDimOfExport");
            return defineDimensions;
        }
        return new HashMap<Long, String>(16);
    }

    @Override
    protected boolean needCheckSameShowType() {
        return false;
    }

    @Override
    protected void showMemberName() {
        this.showMemberInfo();
    }

    @Override
    protected void showMemberNumber() {
        this.showMemberInfo();
    }

    @Override
    protected void showMemberNameNumber() {
        this.showMemberInfo();
    }

    @Override
    protected void showMemberSimpName() {
        this.showMemberInfo();
    }

    @Override
    protected void showMemberSimpNameNumber() {
        this.showMemberInfo();
    }

    protected void showMemberInfo() {
        String entityKey = this.getCurrentEntityKey();
        ApplyBillEntityNodeData applyBillEntityNodeData = this.getOrCacheBillEntityNodeData(entityKey, null);
        if (applyBillEntityNodeData == null) {
            return;
        }
        ApplyBillEntityData entityData = applyBillEntityNodeData.getCurrentNodeData();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(entityKey);
        if (entity == null) {
            return;
        }
        List<String> curEntryDimKeys = this.getCurEntryDimKeys();
        this.setNeedDealPropchange(false);
        Map<String, BaseColumn> collect = this.getcollect(entityKey);
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        int i = 0;
        while (i < entity.size()) {
            DynamicObject entry = (DynamicObject)entity.get(i);
            int finalI = i++;
            int currentRowIndexOfCacheEntry = entityData.getRowIndexByRowId(Long.valueOf(entry.getLong("id")));
            curEntryDimKeys.forEach(e -> {
                EntityCellBaseData currentCellData = entityData.getCellBaseData(currentRowIndexOfCacheEntry, e);
                BaseColumn baseColumn = (BaseColumn)collect.get(e);
                String dimNumber = this.getdimNumber(baseColumn);
                String sign = this.getMemberStatusSign(currentCellData);
                String value = null;
                if (currentCellData != null) {
                    value = this.formatSign(sign, currentCellData);
                } else {
                    DynamicObject dimDyn = entry.getDynamicObject(e);
                    value = this.formatSign(sign, dimDyn);
                }
                value = this.chackvalue(value, dimNumber, modelCache, currentCellData, sign);
                this.getModel().setValue(e + "_text", (Object)value, finalI);
            });
        }
        this.setNeedDealPropchange(true);
    }

    private String getdimNumber(BaseColumn baseColumn) {
        if (baseColumn instanceof DimensionColumn) {
            DimensionColumn aa = (DimensionColumn)baseColumn;
            String dimNumber = aa.getDimNumber();
            return dimNumber;
        }
        return "";
    }

    private Map<String, BaseColumn> getcollect(String entityKey) {
        EntryTemplateConfig entryTemplat = (EntryTemplateConfig)this.templateInfo.getEntryTemplateConfig().get(entityKey);
        Map<String, BaseColumn> collect = entryTemplat.getEntryColumns().stream().collect(Collectors.toMap(e -> e.getKey(), e -> e));
        return collect;
    }

    private String chackvalue(String value, String dimNumber, IModelCacheHelper modelCache, EntityCellBaseData currentCellData, String sign) {
        value = this.getDimensionColumn(dimNumber, modelCache, currentCellData, value, sign);
        return value;
    }

    private String getDimensionColumn(String dimNumber, IModelCacheHelper modelCache, EntityCellBaseData currentCellData, String value, String sign) {
        Dimension dimension;
        Member member;
        if (currentCellData == null) {
            return value;
        }
        Map<String, Long> viewIds = this.getViewIds();
        String name = currentCellData.getName();
        String number = currentCellData.getNumber();
        String simpleName = "";
        if (dimNumber.length() > 0 && (member = (dimension = modelCache.getDimension(dimNumber)).getMember(viewIds.get(dimNumber), number)) != null) {
            simpleName = member.getSimpleName();
        }
        value = this.getSimplname(value, simpleName, name, number, sign);
        return value;
    }

    private String getSimplname(String value, String simpleName, String name, String number, String sign) {
        MemberShowType memberShowType = this.getMemberShowType();
        switch (memberShowType) {
            case SIMPNAME: {
                if (simpleName.length() == 0) {
                    value = sign + name;
                    break;
                }
                value = sign + simpleName;
                break;
            }
            case SIMPNAME_NUMBER: {
                if (simpleName.length() == 0) {
                    value = sign + number + "#" + name;
                    break;
                }
                value = sign + number + "#" + simpleName;
                break;
            }
        }
        return value;
    }

    private String getMemberStatusSign(EntityCellBaseData currentCellData) {
        String sign = "";
        if (currentCellData == null) {
            return sign;
        }
        CellGroupStatusEnum groupStatus = currentCellData.getGroupStatus();
        if (CellGroupStatusEnum.OPEN == groupStatus) {
            sign = "-";
        } else if (CellGroupStatusEnum.CLOSE == groupStatus) {
            sign = "+";
        }
        return sign;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dealStatisticsInit();
    }

    private void dealStatisticsInit() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String obj = (String)formShowParameter.getCustomParam("memberShowType");
        if (obj == null) {
            return;
        }
        MemberShowType memberShowType = MemberShowType.getEnumByValue((String)obj);
        if (memberShowType == null) {
            return;
        }
        this.getPageCache().put("memberShowType", obj);
        this.showMemberInfo();
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.dealStatisticsInit();
    }

    @Override
    protected void afterMainEntityTabChange(String entityKey) {
        super.afterMainEntityTabChange(entityKey);
        this.showMemberInfo();
    }

    private Map<Integer, Map<String, String>> getNoDetailMembers(ApplyBillEntityData entityData, String baseEditKey, int cacheRowIndex, List<Member> members) {
        boolean isNoDetail = false;
        Set baseDataKeys = entityData.getBaseDataKeys();
        for (Object columnKey : baseDataKeys) {
            EntityCellBaseData pCellData;
            if (((String)columnKey).equals(baseEditKey) || (pCellData = entityData.getCellBaseData(cacheRowIndex, (String)columnKey)).isLeaf()) continue;
            isNoDetail = true;
            break;
        }
        HashMap<String, String> otherMemberMap = new HashMap<String, String>(baseDataKeys.size());
        for (String columnKey : baseDataKeys) {
            if (columnKey.equals(baseEditKey)) continue;
            EntityCellBaseData pCellData = entityData.getCellBaseData(cacheRowIndex, columnKey);
            otherMemberMap.put(columnKey, pCellData.getNumber());
        }
        HashMap<Integer, Map<String, String>> noDetailMembers = new HashMap<Integer, Map<String, String>>(16);
        int i = 0;
        if (isNoDetail) {
            for (Member child : members) {
                HashMap<String, String> noDetailMemberMap = new HashMap<String, String>(16);
                noDetailMemberMap.putAll(otherMemberMap);
                noDetailMemberMap.put(baseEditKey, child.getNumber());
                noDetailMembers.put(i++, noDetailMemberMap);
            }
        } else {
            for (Member child : members) {
                if (!child.isLeaf()) {
                    HashMap<String, String> noDetailMemberMap = new HashMap<String, String>(16);
                    noDetailMemberMap.putAll(otherMemberMap);
                    noDetailMemberMap.put(baseEditKey, child.getNumber());
                    noDetailMembers.put(i, noDetailMemberMap);
                }
                ++i;
            }
        }
        return noDetailMembers;
    }

    private boolean isMainBill() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("eb_bgapplybill_split".equals(formId)) {
            return true;
        }
        String cacheStr = (String)this.getView().getFormShowParameter().getCustomParam("applyAuditParam");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)cacheStr)) {
            cacheStr = this.getCacheOfPage().get("applyAuditParam");
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cacheStr)) {
            CentralAppShowInfo centralAppShowInfo = (CentralAppShowInfo)SerializationUtils.fromJsonString((String)cacheStr, CentralAppShowInfo.class);
            return centralAppShowInfo.isMainBill();
        }
        return true;
    }
}

