/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.business.rejectbill.constant.RejectStatusEnum;
import kd.epm.eb.business.rejectbill.entity.RejectLog;
import kd.epm.eb.business.rejectbill.entity.RejectLogDetail;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateColCfgEntity;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.applybill.EntryColumn;

public class BgRejectBillLogListPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BgRejectBillLogListPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Map<Long, EntryColumn> baseColsMap = this.getEntryColMap(formShowParameter);
        for (Map.Entry<Long, EntryColumn> entry : baseColsMap.entrySet()) {
            EntryColumn value = entry.getValue();
            if (value == null) continue;
            String entityKey = value.getEntityName();
            String index = this.getIndexFromEntityName(entityKey);
            EntryAp entryAp = this.initEntryAp(entityKey, value);
            HashMap<String, String> mapEntry = new HashMap<String, String>(16);
            mapEntry.put("id", entityKey);
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            e.getItems().add(mapEntry);
            String tabKey = "tabpageap" + index;
            HashMap<String, String> props = new HashMap<String, String>(1);
            props.put("id", tabKey);
            props.put("text", (String)new LocaleString(value.getTemplateName()));
            e.getItems().add(props);
        }
    }

    private String getIndexFromEntityName(String entityName) {
        return entityName.replace("entryentity", "");
    }

    private EntryAp initEntryAp(String entityKey, EntryColumn value) {
        EntryAp entryAp = this.createEntryAp(entityKey);
        for (BaseColumn allCol : value.getAllCols()) {
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId(allCol.getKey());
            fieldAp.setKey(allCol.getKey());
            fieldAp.setName(new LocaleString(allCol.getTitle()));
            fieldAp.setFireUpdEvt(true);
            fieldAp.setLock("new,edit,view");
            TextField textField = BgRejectBillLogListPlugin.createDynamicTextField(allCol.getKey(), allCol.getTitle());
            fieldAp.setField((Field)textField);
            entryAp.getItems().add(fieldAp);
        }
        return entryAp;
    }

    public static TextField createDynamicTextField(String fieldKey, String fieldName) {
        TextField textField = new TextField();
        textField.setKey(fieldKey);
        textField.setName(new LocaleString(fieldName));
        return textField;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            log.error((Throwable)exp);
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public static TextProp createDynamicTextProp(String propName, String displayName) {
        TextProp textProp = new TextProp();
        textProp.setName(propName);
        textProp.setDisplayName(new LocaleString(displayName));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        Map<Long, EntryColumn> entryColMap = this.getEntryColMap(null);
        for (Map.Entry<Long, EntryColumn> entry : entryColMap.entrySet()) {
            EntryColumn value = entry.getValue();
            if (value == null) continue;
            List<BaseColumn> allCols = value.getAllCols();
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(value.getEntityName());
            entryType.createPropIndexs();
            for (BaseColumn allCol : allCols) {
                TextProp dynamicTextProp = BgRejectBillLogListPlugin.createDynamicTextProp(allCol.getKey(), allCol.getTitle());
                entryType.addProperty((DynamicProperty)dynamicTextProp);
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith("h_")) {
            Map<Long, EntryColumn> entryColMap = this.getEntryColMap(null);
            for (Map.Entry<Long, EntryColumn> entry : entryColMap.entrySet()) {
                List<BaseColumn> allCols;
                BaseColumn baseColumn;
                EntryColumn value = entry.getValue();
                if (value == null || (baseColumn = (BaseColumn)(allCols = value.getAllCols()).stream().filter(t -> t.getKey().equals(key)).findFirst().orElse(null)) == null) continue;
                TextEdit textEdit = new TextEdit();
                textEdit.setKey(key);
                textEdit.setModel(this.getModel());
                textEdit.setView(this.getView());
                textEdit.setFieldKey(key);
                textEdit.setEntryKey(value.getEntityName());
                e.setControl((Control)textEdit);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map<Long, EntryColumn> entryColMap = this.getEntryColMap(null);
        for (Map.Entry<Long, EntryColumn> entry : entryColMap.entrySet()) {
            EntryColumn value = entry.getValue();
            if (value == null) continue;
            String entityKey = value.getEntityName();
            EntryAp entryAp = this.initEntryAp(entityKey, value);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityKey);
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(fieldEdit);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Map<Long, EntryColumn> entryColMap = this.getEntryColMap(null);
        for (Map.Entry<Long, EntryColumn> entry : entryColMap.entrySet()) {
            EntryColumn value = entry.getValue();
            if (value == null) continue;
            String entityKey = value.getEntityName();
            EntryAp entryAp = this.initEntryAp(entityKey, value);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityKey);
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(fieldEdit);
            }
        }
    }

    private Map<Long, EntryColumn> getEntryColMap(FormShowParameter formShowParameter) {
        List rejectLogs = RejectBillService.getInstance().listRejectLogBySpnumber(this.getSpNumber(formShowParameter));
        HashSet<Long> templateIds = new HashSet<Long>(16);
        for (RejectLog rejectLog : rejectLogs) {
            templateIds.add(rejectLog.getTemplateId());
        }
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id, number, name, entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", templateIds)});
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam(formShowParameter);
        Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        HashMap<Long, EntryColumn> baseColsMap = new HashMap<Long, EntryColumn>(16);
        for (Map.Entry entry : entryTemplateConfig.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("biz")) continue;
            EntryTemplateConfig entryValue = (EntryTemplateConfig)entry.getValue();
            long templateID = entryValue.getTemplateID();
            if (templateIds.contains(templateID)) {
                List colCfgListByTemplateId = ApplyTemplateColCfgService.getInstance().getColCfgListByTemplateId(Long.valueOf(templateID));
                List writeColKey = colCfgListByTemplateId.stream().filter(t -> t.getFormtype().equals(FormTypeEnum.APPROVE.getCode())).filter(t -> t.getEdittype().equals(ColCfgPropEnum.WRITE.getValue())).map(ApplyTemplateColCfgEntity::getColkey).collect(Collectors.toList());
                DynamicObject dynamicObject = templates.stream().filter(t -> t.getLong("id") == templateID).findFirst().get();
                String templateName = dynamicObject.getString("name");
                List entryColumns = entryValue.getEntryColumns();
                List<BaseColumn> collect = entryColumns.stream().filter(t -> writeColKey.contains(t.getKey())).filter(t -> !(t instanceof CalculateColumn)).collect(Collectors.toList());
                EntryColumn entryColumn = new EntryColumn(collect, templateName, key);
                entryColumn.setTabKey("tabpageap" + key.replace("entryentity", ""));
                entryColumn.setEntryTemplateConfig(entryValue);
                baseColsMap.put(templateID, entryColumn);
                continue;
            }
            baseColsMap.put(templateID, null);
        }
        return baseColsMap;
    }

    private EntryAp createEntryAp(String entryKey) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entryKey);
        entryAp.setPageRow(10000);
        return entryAp;
    }

    private List<BaseColumn> getBaseColumns(String entityName) {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam(null);
        Map entryTemplateConfigMap = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)entryTemplateConfigMap.get(entityName);
        List entryColumns = entryTemplateConfig.getEntryColumns();
        return entryColumns.stream().filter(t -> !t.getKey().endsWith("_text")).collect(Collectors.toList());
    }

    public void afterCreateNewData(EventObject e) {
        Set logSigns = LogSignHelper.getLogSignByGropNum((String)"BgApplyBillBasePlugin");
        for (int i = 1; i < 11; ++i) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap" + i});
        }
        Map<Long, EntryColumn> colMap = this.getEntryColMap(null);
        QFilter qf = new QFilter("spbillnumber", "=", (Object)this.getSpNumber(null));
        List rejectLogs = RejectBillService.getInstance().getRejectLogsByFilter(qf);
        for (Map.Entry<Long, EntryColumn> entry : colMap.entrySet()) {
            EntryColumn value = entry.getValue();
            if (value == null) continue;
            EntryTemplateConfig entryTemplateConfig = value.getEntryTemplateConfig();
            String tabKey = value.getTabKey();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{tabKey});
            List<BaseColumn> allCols = value.getAllCols();
            String entityName = value.getEntityName();
            if (logSigns.contains("rejectlogs:")) {
                CommonServiceHelper.handleLog((Log)log, (String)"rejectlogs:", (String)SerializationUtils.toJsonString((Object)rejectLogs));
            }
            for (RejectLog rejectLog : rejectLogs) {
                String dataJson;
                Long templateId = rejectLog.getTemplateId();
                if (!templateId.equals(entry.getKey())) continue;
                String bhbillNumber = rejectLog.getBhbillNumber();
                String rejectStatus = rejectLog.getRejectStatus();
                if (StringUtils.isEmpty((String)bhbillNumber) || StringUtils.isEmpty((String)(dataJson = rejectLog.getDataJson()))) continue;
                List dataJsonList = (List)SerializationUtils.fromJsonString((String)dataJson, List.class);
                List rejectLogDetails = rejectLog.getRejectLogDetails();
                ArrayList<Map<String, Object>> entryRowDimColList = new ArrayList<Map<String, Object>>(16);
                boolean flag = true;
                for (RejectLogDetail rejectLogDetail : rejectLogDetails) {
                    String isUpdate = rejectLogDetail.getIsUpdate();
                    Map oldAndNewRowData = RejectBillService.getInstance().getOldRowData(rejectLogDetail, this.getBaseColumns(entityName));
                    Object[] oldRowData = (Object[])oldAndNewRowData.get("old");
                    Object[] newRowData = (Object[])oldAndNewRowData.get("new");
                    if (oldRowData == null || newRowData == null) continue;
                    boolean b = RejectBillService.getInstance().compareTowRowDataDim(oldRowData, dataJsonList.toArray(), entryTemplateConfig.getDimKeysList());
                    if (b) {
                        isUpdate = "true";
                        flag = false;
                    }
                    if ("false".equals(isUpdate)) continue;
                    Map<String, Object> obj = this.getListItemMap(oldRowData, newRowData, value);
                    entryRowDimColList.add(obj);
                }
                if (flag) {
                    Map<String, Object> obj = this.getListItemMap(dataJsonList.toArray(), dataJsonList.toArray(), value);
                    entryRowDimColList.add(obj);
                }
                for (Map map : entryRowDimColList) {
                    DynamicObject dynamicObject = this.getModel().getEntryEntity(entityName).addNew();
                    for (BaseColumn allCol : allCols) {
                        String key = allCol.getKey();
                        if (key.startsWith("h_bhnumber")) {
                            dynamicObject.set(key, (Object)bhbillNumber);
                            continue;
                        }
                        if (key.startsWith("h_status")) {
                            dynamicObject.set(key, (Object)(RejectStatusEnum.reject.getCode().equals(rejectStatus) ? ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"BgRejectBillLogListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"BgRejectBillLogListPlugin_1", (String)"", (Object[])new Object[0])));
                            continue;
                        }
                        dynamicObject.set(key, map.get(key));
                    }
                }
            }
        }
    }

    private Map<String, Object> getListItemMap(Object[] oldData, Object[] newData, EntryColumn entryColumn) {
        Map valueMap;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String entityName = entryColumn.getEntityName();
        String index = entityName.replace("entryentity", "");
        for (Object o : oldData) {
            Object valueObj;
            String key;
            if (!(o instanceof Map)) continue;
            valueMap = (Map)o;
            for (BaseColumn baseColumn : entryColumn.getRowDimCols()) {
                String baseEntityId;
                DynamicObject dynamicObject;
                key = baseColumn.getKey();
                valueObj = valueMap.get(key);
                if (valueObj == null || (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(valueObj, (String)(baseEntityId = baseColumn.getBaseEntityId()))) == null) continue;
                result.put(key, dynamicObject.getString("name"));
            }
            for (BaseColumn measureCol : entryColumn.getMeasureCols()) {
                key = measureCol.getKey();
                valueObj = valueMap.get(key);
                if (valueObj == null) continue;
                if (valueObj instanceof BigDecimal) {
                    valueObj = new BigDecimal(String.format("%.2f", new BigDecimal(valueObj.toString())));
                }
                result.put(key, valueObj);
            }
        }
        for (Object o : newData) {
            if (!(o instanceof Map)) continue;
            valueMap = (Map)o;
            List<BaseColumn> endFixCols = entryColumn.getEndFixCols();
            for (BaseColumn measureCol : endFixCols) {
                Object valueObj;
                String key = measureCol.getKey();
                if (!key.endsWith("_reject_adj" + index) || (valueObj = valueMap.get(key.replace("_reject_adj" + index, ""))) == null) continue;
                if (valueObj instanceof BigDecimal) {
                    valueObj = new BigDecimal(String.format("%.2f", new BigDecimal(valueObj.toString())));
                }
                result.put(key, valueObj);
            }
            List<BaseColumn> otherCols = entryColumn.getOtherCols();
            for (BaseColumn otherCol : otherCols) {
                String key = otherCol.getKey();
                Object valueObj = valueMap.get(key);
                if (valueObj == null) continue;
                if (valueObj instanceof BigDecimal) {
                    valueObj = new BigDecimal(String.format("%.2f", new BigDecimal(valueObj.toString())));
                }
                result.put(key, valueObj);
            }
        }
        return result;
    }

    private String getSpNumber(FormShowParameter formShowParameter) {
        if (formShowParameter != null) {
            return (String)formShowParameter.getCustomParam("spNumber");
        }
        Object spNumber = this.getView().getFormShowParameter().getCustomParam("spNumber");
        if (spNumber == null) {
            return "";
        }
        return spNumber.toString();
    }

    private BgApplyENtryInfo getEntryInfoFromFormParam(FormShowParameter formShowParameter) {
        Object entryTemplateCfg = null;
        entryTemplateCfg = formShowParameter != null ? formShowParameter.getCustomParam("entryTemplateCfg") : this.getView().getFormShowParameter().getCustomParam("entryTemplateCfg");
        if (entryTemplateCfg == null) {
            return new BgApplyENtryInfo();
        }
        return (BgApplyENtryInfo)SerializationUtils.fromJsonString((String)entryTemplateCfg.toString(), BgApplyENtryInfo.class);
    }

    public Long getModelId() {
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (modelId != null) {
            this.getPageCache().put("modelId", modelId.toString());
            return IDUtils.toLong((Object)modelId);
        }
        return 0L;
    }
}

