/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.fileImport;

import java.awt.Color;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimCfgService;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applybill.exportcol.BaseExportCol;
import kd.epm.eb.common.applybill.exportcol.DimensionExportCol;
import kd.epm.eb.common.applybill.exportcol.EnumExportCol;
import kd.epm.eb.common.applybill.exportcol.MeasureExportCol;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.EnumColumn;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.SourceTextEnum;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.formplugin.applybill.fileImport.CellStyleEnum;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BgApplyBillDataExportPlugin {
    private static final BgApplyBillDataExportPlugin instance = new BgApplyBillDataExportPlugin();
    private final Map<String, XSSFCellStyle> cellStyleMap = new HashMap<String, XSSFCellStyle>(16);
    private final Map<Integer, XSSFCellStyle> rowCellStyleMap = new HashMap<Integer, XSSFCellStyle>(16);
    private final Map<Short, XSSFFont> rowCellFontMap = new HashMap<Short, XSSFFont>(16);
    private XSSFWorkbook workBook = null;
    private static final Log log = LogFactory.getLog(BgApplyBillDataExportPlugin.class);

    public static BgApplyBillDataExportPlugin getInstance() {
        return instance;
    }

    public void export(CentralAppShowInfo showInfo, Map<String, Long> templateIds, Long modelId, IFormView formView, String applyBillNumber, Map<Long, List<String>> enableCols, Map<String, String> entityUnitSet, Map<Long, String> definedDimensions, Boolean isTemplate, SchemeAssignDimGroup schemeAssignDimGroup) {
        log.info("export-definedDimensions: " + definedDimensions);
        XSSFWorkbook initExcel = this.getInitExcel();
        HashMap<String, List<String>> dimRanges = new HashMap<String, List<String>>(16);
        LinkedHashMap<String, List<Map<String, String>>> enumskeyMap = new LinkedHashMap<String, List<Map<String, String>>>(16);
        ArrayList<String> dimOrder = new ArrayList<String>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Set<Long> tempIds = new HashSet<Long>(templateIds.values());
        if (showInfo != null) {
            tempIds = showInfo.getTemplates();
        }
        Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
        DynamicObject[] templates = BusinessDataServiceHelper.load((Object[])tempIds.toArray(new Long[0]), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_applytemplate").getDynamicObjectType());
        HashMap<String, Long> allViewIdMap = new HashMap<String, Long>(16);
        String fieldStatus = formView.getPageCache().get("fieldStatus");
        BillFieldStatus HideFieldStatus = null;
        if (fieldStatus != null) {
            HideFieldStatus = (BillFieldStatus)SerializationUtils.fromJsonString((String)fieldStatus, BillFieldStatus.class);
        }
        for (Long templateId : templateIds.values()) {
            for (DynamicObject template : templates) {
                String define;
                int index;
                Long tempId = template.getLong("id");
                if (!tempId.equals(templateId)) continue;
                String templateName = template.getString("name");
                String entityKey = this.getEntityKeyByTemplate(templateIds, tempId);
                Long dataSetId = template.getLong("dataset_id");
                Map viewIds = modelCacheHelper.getViewsByDataSet(dataSetId);
                List<String> enableColIds = enableCols.get(tempId);
                if (enableColIds == null) continue;
                allViewIdMap.putAll(viewIds);
                XSSFSheet sheet = initExcel.createSheet(templateName);
                sheet.setDefaultColumnWidth(30);
                this.createFirstSheetRow(sheet);
                this.createSecondSheetRow(sheet, templateName, template.getString("number"));
                Map hiddenDimMemMap = BgApplyBillUtils.getInstance().getHiddenDimMemNumMap(template.getString("cachedata_tag"), viewIds, modelCacheHelper, varInfo);
                this.createHideDimRows(sheet, hiddenDimMemMap, viewIds, modelCacheHelper);
                Set colDimNums = ApplyTemplateUtils.getColDimNums((String)template.getString("cachedata_tag"));
                HashMap<Integer, String> measureOrCalCols = new HashMap<Integer, String>(16);
                Map entityInfo = BgApplyBillUtils.getInstance().getMainEntityInfoByTemplate(tempId, modelCacheHelper, varInfo);
                List colList = (List)entityInfo.get("col");
                List enableColumns = colList.stream().filter(e -> enableColIds.contains(e.getKey())).collect(Collectors.toList());
                colList.retainAll(enableColumns);
                if (HideFieldStatus != null) {
                    BillFieldStatus finalHideFieldStatus = HideFieldStatus;
                    colList.removeIf(x -> x instanceof DimensionDataColumn && finalHideFieldStatus.getHideKeys().contains(x.getKey()));
                }
                this.dealColRange(colList);
                Integer dimColIndex = this.getMeasureOrCalCols(colList, measureOrCalCols) - 1;
                Map<String, Map<String, Map<String, String>>> colRowDimMembers = this.getAllData(modelId, tempId, modelCacheHelper, formView.getModel(), applyBillNumber, varInfo);
                List enumColumns = colList.stream().filter(s -> s instanceof EnumColumn).collect(Collectors.toList());
                if (!enumColumns.isEmpty()) {
                    for (BaseColumn enumColumn : enumColumns) {
                        EnumColumn enumColumn1 = (EnumColumn)enumColumn;
                        String key = enumColumn1.getKey();
                        List enumdata = enumColumn1.getEnumdata();
                        if (enumdata == null || enumdata.isEmpty()) continue;
                        for (ComboItem enumdatum : enumdata) {
                            List maps = enumskeyMap.computeIfAbsent(key, s -> new ArrayList(16));
                            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
                            map.put("number", enumdatum.getValue());
                            map.put("name", enumdatum.getCaption().getLocaleValue());
                            maps.add(map);
                        }
                    }
                }
                int currentRow = this.createColDimRows(sheet, measureOrCalCols, colRowDimMembers.get("col"), modelCacheHelper, dimColIndex, viewIds);
                List<String> statisticsDims = this.getStatisticsDims(colList, modelCacheHelper, tempId);
                String definedDimension = null;
                if (statisticsDims.size() != 0 && definedDimensions != null && (index = statisticsDims.indexOf(define = definedDimensions.get(tempId))) != -1) {
                    definedDimension = define;
                }
                BigDecimal unitData = null;
                if (!isTemplate.booleanValue()) {
                    if (StringUtils.isEmpty((String)entityKey) || entityUnitSet == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u8f6c\u6362\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"BgApplyBillDataExportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    unitData = this.getUnitData(entityUnitSet.get(entityKey));
                }
                this.createRowDimRows(sheet, showInfo, colList, colRowDimMembers, modelCacheHelper, viewIds, hiddenDimMemMap, dimRanges, dimOrder, modelId, dataSetId, currentRow, unitData, statisticsDims, definedDimension, tempId, isTemplate, varInfo, colDimNums);
                sheet.groupRow(0, currentRow);
                sheet.setRowGroupCollapsed(0, true);
            }
        }
        this.createDimRangeSheet(dimRanges, dimOrder, allViewIdMap, modelCacheHelper, enumskeyMap);
        String url = null;
        String fileName = this.getFileName(isTemplate);
        try {
            url = ImportAndExportUtil.writeFile((Workbook)this.workBook, (String)fileName);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    public void colExport(CentralAppShowInfo showInfo, Map<String, Long> templateIds, Long modelId, IFormView formView, String applyBillNumber, Map<Long, List<String>> enableCols, Map<String, String> entityUnitSet, Map<Long, String> definedDimensions, Boolean isTemplate, SchemeAssignDimGroup schemeAssignDimGroup, Map<String, Map<String, Map<String, String>>> RowDimMemberMap, HashMap<String, String> centralOrgMap, Map<String, Map<String, Map<String, String>>> otherDimMemberMap) {
        log.info("export-definedDimensions: " + definedDimensions);
        XSSFWorkbook initExcel = this.getInitExcel();
        HashMap<String, List<String>> dimRanges = new HashMap<String, List<String>>(16);
        LinkedHashMap<String, List<Map<String, String>>> enumskeyMap = new LinkedHashMap<String, List<Map<String, String>>>(16);
        ArrayList<String> dimOrder = new ArrayList<String>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Set<Long> tempIds = new HashSet<Long>(templateIds.values());
        if (showInfo != null) {
            tempIds = showInfo.getTemplates();
        }
        Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
        DynamicObject[] templates = BusinessDataServiceHelper.load((Object[])tempIds.toArray(new Long[0]), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_applytemplate").getDynamicObjectType());
        HashMap<String, Long> allViewIdMap = new HashMap<String, Long>(16);
        String fieldStatus = formView.getPageCache().get("fieldStatus");
        BillFieldStatus HideFieldStatus = null;
        if (fieldStatus != null) {
            HideFieldStatus = (BillFieldStatus)SerializationUtils.fromJsonString((String)fieldStatus, BillFieldStatus.class);
        }
        for (Map.Entry<String, Long> templateId : templateIds.entrySet()) {
            for (DynamicObject template : templates) {
                String define;
                int index;
                Long tempId = template.getLong("id");
                if (!tempId.equals(templateId.getValue())) continue;
                String templateName = template.getString("name");
                String entityKey = this.getEntityKeyByTemplate(templateIds, tempId);
                Long dataSetId = template.getLong("dataset_id");
                Map viewIds = modelCacheHelper.getViewsByDataSet(dataSetId);
                List<String> enableColIds = enableCols.get(tempId);
                if (enableColIds == null) continue;
                allViewIdMap.putAll(viewIds);
                XSSFSheet sheet = initExcel.createSheet(templateName);
                sheet.setDefaultColumnWidth(30);
                this.createFirstSheetRow(sheet);
                this.createSecondSheetRow(sheet, templateName, template.getString("number"));
                Map hiddenDimMemMap = BgApplyBillUtils.getInstance().getHiddenDimMemNumMap(template.getString("cachedata_tag"), viewIds, modelCacheHelper, varInfo);
                this.createHideDimRows(sheet, hiddenDimMemMap, viewIds, modelCacheHelper);
                Set colDimNums = ApplyTemplateUtils.getColDimNums((String)template.getString("cachedata_tag"));
                HashMap<Integer, String> measureOrCalCols = new HashMap<Integer, String>(16);
                Map entityInfo = BgApplyBillUtils.getInstance().getMainEntityInfoByTemplate(tempId, modelCacheHelper, varInfo);
                List colList = (List)entityInfo.get("col");
                List enableColumns = colList.stream().filter(e -> enableColIds.contains(e.getKey())).collect(Collectors.toList());
                colList.retainAll(enableColumns);
                if (HideFieldStatus != null) {
                    BillFieldStatus finalHideFieldStatus = HideFieldStatus;
                    colList.removeIf(x -> x instanceof DimensionDataColumn && finalHideFieldStatus.getHideKeys().contains(x.getKey()));
                }
                this.dealColRange(colList);
                Integer dimColIndex = this.getMeasureOrCalCols(colList, measureOrCalCols) - 1;
                Map<String, Map<String, Map<String, String>>> colRowDimMembers = this.getAllDataNew(modelId, tempId, modelCacheHelper, formView.getModel(), applyBillNumber, varInfo, hiddenDimMemMap, dataSetId);
                List enumColumns = colList.stream().filter(s -> s instanceof EnumColumn).collect(Collectors.toList());
                if (!enumColumns.isEmpty()) {
                    for (BaseColumn enumColumn : enumColumns) {
                        EnumColumn enumColumn1 = (EnumColumn)enumColumn;
                        String key = enumColumn1.getKey();
                        List enumdata = enumColumn1.getEnumdata();
                        if (enumdata == null || enumdata.isEmpty()) continue;
                        for (ComboItem enumdatum : enumdata) {
                            List maps = enumskeyMap.computeIfAbsent(key, s -> new ArrayList(16));
                            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
                            map.put("number", enumdatum.getValue());
                            map.put("name", enumdatum.getCaption().getLocaleValue());
                            maps.add(map);
                        }
                    }
                }
                int currentRow = this.createColDimRows(sheet, measureOrCalCols, colRowDimMembers.get("col"), modelCacheHelper, dimColIndex, viewIds);
                List<String> statisticsDims = this.getStatisticsDims(colList, modelCacheHelper, tempId);
                String definedDimension = null;
                if (statisticsDims.size() != 0 && definedDimensions != null && (index = statisticsDims.indexOf(define = definedDimensions.get(tempId))) != -1) {
                    definedDimension = define;
                }
                colRowDimMembers.put("row", RowDimMemberMap.get(templateId.getKey()));
                if (otherDimMemberMap != null && !otherDimMemberMap.isEmpty()) {
                    colRowDimMembers.put("other", otherDimMemberMap.get(templateId.getKey()));
                }
                if (centralOrgMap != null && !centralOrgMap.isEmpty()) {
                    List textColum = colList.stream().filter(x -> x instanceof TextColumn && ((TextColumn)x).getSourceTextEnum() == SourceTextEnum.CentralOrg.getValue()).collect(Collectors.toList());
                    block6: for (Map.Entry<String, String> entry : centralOrgMap.entrySet()) {
                        if (colRowDimMembers.get("other") == null || colRowDimMembers.get("other").isEmpty() || textColum.size() <= 0 || colRowDimMembers.get("other").get(entry.getKey()) == null || colRowDimMembers.get("other").get(entry.getKey()).isEmpty()) continue;
                        for (BaseColumn baseColumn : textColum) {
                            String key = "f" + baseColumn.getKey();
                            Map<String, String> other = colRowDimMembers.get("other").get(entry.getKey());
                            if (!other.containsKey(key)) continue;
                            other.put(key, entry.getValue());
                            continue block6;
                        }
                    }
                }
                BigDecimal unitData = null;
                if (!isTemplate.booleanValue()) {
                    if (StringUtils.isEmpty((String)entityKey) || entityUnitSet == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u8f6c\u6362\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"BgApplyBillDataExportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    unitData = this.getUnitData(entityUnitSet.get(entityKey));
                }
                this.createRowDimRows(sheet, showInfo, colList, colRowDimMembers, modelCacheHelper, viewIds, hiddenDimMemMap, dimRanges, dimOrder, modelId, dataSetId, currentRow, unitData, statisticsDims, definedDimension, tempId, isTemplate, varInfo, colDimNums);
                sheet.groupRow(0, currentRow);
                sheet.setRowGroupCollapsed(0, true);
            }
        }
        this.createDimRangeSheet(dimRanges, dimOrder, allViewIdMap, modelCacheHelper, enumskeyMap);
        String url = null;
        String fileName = this.getFileName(isTemplate);
        try {
            url = ImportAndExportUtil.writeFile((Workbook)this.workBook, (String)fileName);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private void dealColRange(List<BaseColumn> colList) {
        ArrayList<BaseColumn> colList_tmp = new ArrayList<BaseColumn>(colList);
        colList.clear();
        HashSet<String> groupTitleSet = new HashSet<String>(16);
        for (int i = 0; i < colList_tmp.size(); ++i) {
            BaseColumn column = (BaseColumn)colList_tmp.get(i);
            String groupTitle = column.getGrouptitle();
            if (StringUtils.isEmpty((String)groupTitle)) {
                colList.add(column);
                continue;
            }
            if (groupTitleSet.contains(groupTitle)) continue;
            this.addSameTitleRows(colList_tmp, i, groupTitle, colList);
            groupTitleSet.add(groupTitle);
        }
    }

    protected Map<String, Map<String, Map<String, String>>> getAllData(Long modelId, Long tempId, IModelCacheHelper modelCacheHelper, IDataModel dataModel, String applyBillNumber, Map<String, Map<String, String>> varInfo) {
        Set<String> billNumbers = this.getBillNumbers(applyBillNumber, modelId);
        return BgApplyBillUtils.getInstance().getColRowDimMembers(tempId, modelCacheHelper, dataModel, billNumbers, null, Boolean.valueOf(false), varInfo);
    }

    protected Map<String, Map<String, Map<String, String>>> getAllDataNew(Long modelId, Long tempId, IModelCacheHelper modelCacheHelper, IDataModel dataModel, String applyBillNumber, Map<String, Map<String, String>> varInfo, Map<String, String> hiddenDimMemMap, Long dataSetId) {
        Set<String> billNumbers = this.getBillNumbers(applyBillNumber, modelId);
        return BgApplyBillUtils.getInstance().getColRowDimMembersNew(tempId, modelCacheHelper, dataModel, billNumbers, null, Boolean.valueOf(false), varInfo, hiddenDimMemMap, dataSetId);
    }

    private List<String> getStatisticsDims(List<BaseColumn> colList, IModelCacheHelper modelCacheHelper, Long tempId) {
        ArrayList<String> statisticsDim = new ArrayList<String>(16);
        Set dims = ApplyTemplateDimCfgService.getInstance().getStatisticsDimCfg(tempId);
        for (BaseColumn column : colList) {
            String dimNumber;
            if (!(column instanceof DimensionColumn) && !(column instanceof RelationDimensionColumn) && !(column instanceof RowDimensionColumn) || !dims.contains(dimNumber = BgApplyBillUtils.getInstance().getDimOrRelateDimNumber(column, modelCacheHelper))) continue;
            statisticsDim.add(dimNumber);
        }
        return statisticsDim;
    }

    protected String getFileName(Boolean isTemplate) {
        String fileName = ResManager.loadKDString((String)"\u7533\u62a5\u5355\u636e-\u5bfc\u51fa\u6570\u636e", (String)"BgApplyBillDataExportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (isTemplate.booleanValue()) {
            fileName = ResManager.loadKDString((String)"\u7533\u62a5\u5355\u636e-\u5bfc\u51fa\u6a21\u677f", (String)"BgApplyBillDataExportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return fileName;
    }

    protected Set<String> getBillNumbers(String applyBillNumber, Long modelId) {
        HashSet<String> billNumbers = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)applyBillNumber)) {
            billNumbers.add(applyBillNumber);
        }
        return billNumbers;
    }

    private String getEntityKeyByTemplate(Map<String, Long> templateIds, Long tempId) {
        for (Map.Entry<String, Long> templateId : templateIds.entrySet()) {
            Long id = templateId.getValue();
            if (!tempId.equals(id)) continue;
            return templateId.getKey();
        }
        return null;
    }

    protected void createDimRangeSheet(Map<String, List<String>> dimRanges, List<String> dimOrder, Map<String, Long> viewIdMap, IModelCacheHelper modelCacheHelper, Map<String, List<Map<String, String>>> enumskeyMap) {
        String sheetName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u8303\u56f4", (String)"BgApplyBillDataExportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        XSSFSheet sheet = this.workBook.createSheet(sheetName);
        sheet.setDefaultColumnWidth(20);
        this.createDimRangeTitle(sheet);
        int colIndex = 0;
        for (String string : dimOrder) {
            List<String> members = dimRanges.get(string);
            colIndex = this.createDimRowAndFillData(sheet, string, members, viewIdMap, modelCacheHelper, colIndex);
        }
        if (enumskeyMap != null && !enumskeyMap.isEmpty()) {
            for (Map.Entry entry : enumskeyMap.entrySet()) {
                List value = (List)entry.getValue();
                this.createEnumRowAndFillData(sheet, value, colIndex);
            }
        }
    }

    private int createDimRowAndFillData(XSSFSheet sheet, String dim, List<String> members, Map<String, Long> viewIdMap, IModelCacheHelper modelCacheHelper, int colIndex) {
        colIndex = colIndex == 0 ? colIndex + 1 : colIndex + 3;
        this.fillTitle(sheet, colIndex);
        this.fillDimMember(sheet, dim, members, viewIdMap, colIndex, modelCacheHelper);
        return colIndex;
    }

    private int createEnumRowAndFillData(XSSFSheet sheet, List<Map<String, String>> enums, int colIndex) {
        colIndex = colIndex == 0 ? colIndex + 1 : colIndex + 3;
        this.fillTitle(sheet, colIndex);
        this.filEnumMember(sheet, enums, colIndex);
        return colIndex;
    }

    private void filEnumMember(XSSFSheet sheet, List<Map<String, String>> maps, int colIndex) {
        int rowIndex = 2;
        for (Map<String, String> map : maps) {
            XSSFRow curRow = this.getRow(sheet, rowIndex++);
            XSSFCell firstCell = curRow.createCell(colIndex, CellType.STRING);
            firstCell.setCellValue(map.get("number"));
            XSSFCell secondCell = curRow.createCell(colIndex + 1, CellType.STRING);
            secondCell.setCellValue(map.get("name"));
        }
    }

    private void fillDimMember(XSSFSheet sheet, String dim, List<String> members, Map<String, Long> viewIdMap, int colIndex, IModelCacheHelper modelCacheHelper) {
        XSSFRow row = this.getRow(sheet, 1);
        XSSFCell dimNumberCell = row.createCell(colIndex, CellType.STRING);
        dimNumberCell.setCellValue(dim);
        XSSFCell dimNameCell = row.createCell(colIndex + 1, CellType.STRING);
        Dimension dimension = modelCacheHelper.getDimension(dim);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u83b7\u53d6\u5230\u7ef4\u5ea6%1\u4fe1\u606f\u3002", (String)"BgApplyBillDataExportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{dim}));
        }
        dimNameCell.setCellValue(dimension.getName());
        int rowIndex = 2;
        for (String member : members) {
            XSSFRow curRow = this.getRow(sheet, rowIndex++);
            XSSFCell firstCell = curRow.createCell(colIndex, CellType.STRING);
            firstCell.setCellValue(member);
            XSSFCell secondCell = curRow.createCell(colIndex + 1, CellType.STRING);
            Member memberInfo = modelCacheHelper.getMember(dim, viewIdMap.get(dim), member);
            if (memberInfo == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u83b7\u53d6\u5230\u7ef4\u5ea6%1\u7684\u6210\u5458%2\u4fe1\u606f\u3002", (String)"BgApplyBillDataExportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dim, member}));
            }
            secondCell.setCellValue(memberInfo.getName());
        }
    }

    private void fillTitle(XSSFSheet sheet, int colIndex) {
        XSSFRow row = this.getRow(sheet, 0);
        XSSFCell firstCell = row.createCell(colIndex, CellType.STRING);
        firstCell.setCellValue(ResManager.loadKDString((String)"\u7f16\u7801", (String)"BgApplyBillDataExportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        firstCell.setCellStyle((CellStyle)this.getCellStyle(CellStyleEnum.MUST_INPUT));
        XSSFCell secondCell = row.createCell(colIndex + 1, CellType.STRING);
        secondCell.setCellValue(ResManager.loadKDString((String)"\u540d\u79f0", (String)"BgApplyBillDataExportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        secondCell.setCellStyle((CellStyle)this.getCellStyle(CellStyleEnum.MUST_INPUT));
    }

    private XSSFRow getRow(XSSFSheet sheet, int rowIndex) {
        XSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    private void createDimRangeTitle(XSSFSheet sheet) {
        XSSFRow firstRow = sheet.createRow(0);
        XSSFCell cell = firstRow.createCell(0, CellType.STRING);
        cell.setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u67e5\u8be2\u5bf9\u7167\u8868", (String)"BgApplyBillDataExportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void createRowDimRows(XSSFSheet sheet, CentralAppShowInfo showInfo, List<BaseColumn> colList, Map<String, Map<String, Map<String, String>>> colRowDimMembers, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, Map<String, String> hiddenDimMemMap, Map<String, List<String>> dimRanges, List<String> dimOrder, Long modelId, Long dataSetId, int currentRow, BigDecimal unitData, List<String> statisticsDims, String definedDimension, Long tempId, Boolean isTemplate, Map<String, Map<String, String>> varInfo, Set<String> colDimNums) {
        ArrayList<BaseExportCol> rowInfos = new ArrayList<BaseExportCol>(16);
        Boolean hasMultiTitle = this.dealRowInfos(colList, rowInfos, viewIds, hiddenDimMemMap, tempId, modelCacheHelper);
        Map<String, String> calCols = this.getCalCols(colList, viewIds, modelCacheHelper);
        currentRow = this.createTitleRows(sheet, rowInfos, currentRow, modelCacheHelper, dimRanges, dimOrder, dataSetId, hasMultiTitle);
        if (!isTemplate.booleanValue()) {
            this.batchFillData(sheet, showInfo, rowInfos, colRowDimMembers, modelCacheHelper, viewIds, hiddenDimMemMap, calCols, modelId, dataSetId, unitData, statisticsDims, definedDimension, tempId, currentRow, varInfo, colDimNums);
        }
    }

    private Map<String, String> getCalCols(List<BaseColumn> colList, Map<String, Long> viewIds, IModelCacheHelper modelCacheHelper) {
        HashMap<String, String> calCols = new HashMap<String, String>(16);
        HashSet<String> rateCols = new HashSet<String>(16);
        for (BaseColumn column : colList) {
            String key;
            String formula;
            if (column instanceof CalculateColumn) {
                CalculateColumn calColumn = (CalculateColumn)column;
                formula = calColumn.getFormula();
                key = calColumn.getKey();
                calCols.put("f" + key, formula);
                List dataMapDimensions = calColumn.getDataMapDimensions();
                this.addRateCols(dataMapDimensions, rateCols, key, viewIds, modelCacheHelper);
                continue;
            }
            if (column instanceof NumberColumn) {
                NumberColumn numberColumn = (NumberColumn)column;
                formula = numberColumn.getFormula();
                calCols.put("f" + numberColumn.getKey(), formula);
                continue;
            }
            if (!(column instanceof MeasureColumn)) continue;
            MeasureColumn measureColumn = (MeasureColumn)column;
            List dataMapDimensions = measureColumn.getDataMapDimensions();
            key = measureColumn.getKey();
            this.addRateCols(dataMapDimensions, rateCols, key, viewIds, modelCacheHelper);
        }
        this.updateFormula(calCols, rateCols);
        return calCols;
    }

    private void addRateCols(List<DataMapDimension> dataMapDimensions, Set<String> rateCols, String key, Map<String, Long> viewIds, IModelCacheHelper modelCacheHelper) {
        for (DataMapDimension dataMapDimension : dataMapDimensions) {
            long dimensionId = dataMapDimension.getDimensionId();
            Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimensionId));
            if (dimension == null || !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) continue;
            long dimensionMemberId = dataMapDimension.getDimensionRememberId();
            Member member = dimension.getMember(viewIds.get(dimension.getNumber()), Long.valueOf(dimensionMemberId));
            if (member == null || !MetricDataTypeEnum.RATE.getIndex().equals(member.getDatatype())) continue;
            rateCols.add(key);
        }
    }

    private void updateFormula(Map<String, String> calCols, Set<String> rateCols) {
        if (rateCols.size() == 0 || calCols.size() == 0) {
            return;
        }
        HashMap<String, String> tmp = new HashMap<String, String>(calCols);
        for (Map.Entry entry : tmp.entrySet()) {
            String key = (String)entry.getKey();
            String formula = (String)entry.getValue();
            for (String rateCol : rateCols) {
                String filterKey = "[\"" + rateCol + "\"]";
                formula = formula.replace(filterKey, filterKey + "*0.01");
            }
            calCols.put(key, formula);
        }
    }

    protected void batchFillData(XSSFSheet sheet, CentralAppShowInfo showInfo, List<BaseExportCol> rowInfos, Map<String, Map<String, Map<String, String>>> colRowDimMembers, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, Map<String, String> hiddenDimMemMap, Map<String, String> calCols, Long modelId, Long dataSetId, BigDecimal unitData, List<String> statisticsDims, String definedDimension, Long tempId, int currentRow, Map<String, Map<String, String>> varInfo, Set<String> colDimNums) {
        Map<String, Map<String, String>> rows = colRowDimMembers.get("row");
        Map<String, Map<String, String>> cols = colRowDimMembers.get("col");
        Map<String, Map<String, String>> others = colRowDimMembers.get("other");
        this.replaceByOlapData(rows, rowInfos, cols, others, modelCacheHelper, hiddenDimMemMap, dataSetId, modelId);
        this.updateAllDataUnit(cols, others, unitData, modelCacheHelper);
        for (Map.Entry<String, Map<String, String>> entry : rows.entrySet()) {
            String index = entry.getKey();
            Map<String, String> rowDimMembers = entry.getValue();
            Map<String, String> otherInfoMap = others.get(index);
            this.fillRowDataToSheet(sheet, rowDimMembers, rowInfos, otherInfoMap, statisticsDims, modelCacheHelper, viewIds, null, ++currentRow, -1);
        }
    }

    protected void updateAllDataUnit(Map<String, Map<String, String>> cols, Map<String, Map<String, String>> others, BigDecimal unitData, IModelCacheHelper modelCacheHelper) {
        Set<String> currencyCols = this.getCurrencyCols(cols, modelCacheHelper);
        if (currencyCols.size() == 0) {
            return;
        }
        HashMap<String, Map<String, String>> otherMap_tmp = new HashMap<String, Map<String, String>>(others);
        for (Map.Entry otherMapEntry : otherMap_tmp.entrySet()) {
            String rowIndex = (String)otherMapEntry.getKey();
            Map values = (Map)otherMapEntry.getValue();
            Map<String, String> otherValue_real = others.get(rowIndex);
            if (otherValue_real == null) continue;
            for (Map.Entry value : values.entrySet()) {
                String key = (String)value.getKey();
                if (!currencyCols.contains(key)) continue;
                String data = (String)value.getValue();
                BigDecimal bigDecimal = ConvertUtils.toDecimal((Object)data);
                if (bigDecimal != null) {
                    bigDecimal = bigDecimal.divide(unitData, 2, RoundingMode.HALF_UP);
                    data = bigDecimal.toString();
                }
                otherValue_real.put(key, data);
            }
        }
    }

    protected Set<String> getCurrencyCols(Map<String, Map<String, String>> cols, IModelCacheHelper modelCacheHelper) {
        HashSet<String> currencyCols = new HashSet<String>(16);
        for (Map.Entry<String, Map<String, String>> col : cols.entrySet()) {
            Map<String, String> dimMap = col.getValue();
            String metricMember = dimMap.get(SysDimensionEnum.Metric.getNumber());
            if (!BgApplyBillUtils.getInstance().isCurrency(modelCacheHelper, metricMember)) continue;
            currencyCols.add("f" + col.getKey());
        }
        return currencyCols;
    }

    protected void replaceByOlapData(Map<String, Map<String, String>> rows, List<BaseExportCol> rowInfos, Map<String, Map<String, String>> cols, Map<String, Map<String, String>> others, IModelCacheHelper modelCacheHelper, Map<String, String> hiddenDimMemMap, Long dataSetId, Long modelId) {
        Map<MembersKey, Object> allOlapData = this.queryAllOlapData(rows, cols, modelCacheHelper, hiddenDimMemMap, modelId, dataSetId);
        for (Map.Entry<String, Map<String, String>> row : rows.entrySet()) {
            String index = row.getKey();
            Map<String, String> rowDimMembers = rows.get(index);
            Map<String, String> otherInfoMap = others.get(index);
            for (BaseExportCol rowInfo : rowInfos) {
                MembersKey membersKey;
                Object data;
                String rowValue;
                ColumnEnum columnEnum = rowInfo.getRowType();
                String number = rowInfo.getNumber();
                if (!this.isDimOrMeasureColumn(columnEnum) || this.isDimensionColumn(columnEnum)) continue;
                HashMap<String, String> dimMemForKey = new HashMap<String, String>(hiddenDimMemMap);
                dimMemForKey.putAll(rowDimMembers);
                Map<String, String> colDimMap = cols.get(number);
                if (colDimMap != null) {
                    dimMemForKey.putAll(colDimMap);
                }
                String string = rowValue = (data = allOlapData.get(membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimMemForKey, modelCacheHelper.getDimensionList(dataSetId)))) == null ? "" : data.toString();
                if (data instanceof Date) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    rowValue = simpleDateFormat.format((Date)data);
                }
                if (otherInfoMap == null) continue;
                otherInfoMap.put("f" + number, rowValue);
            }
        }
    }

    protected void fillRowDataToSheet(XSSFSheet sheet, Map<String, String> rowDimMembers, List<BaseExportCol> rowInfos, Map<String, String> otherInfoMap, List<String> statisticsDims, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, String definedDimension, int currentRow, int level) {
        XSSFRow xssfRow = sheet.createRow(currentRow);
        XSSFCellStyle rowColorCellStyle = this.getRowColorCellStyle(level);
        if (level != -1 && statisticsDims.size() != 0) {
            String dimNumber = statisticsDims.get(0);
            String memNum = rowDimMembers.get(dimNumber);
            Member member = modelCacheHelper.getMember(dimNumber, viewIds.get(dimNumber), memNum);
            if (member.isLeaf()) {
                rowColorCellStyle = this.getRowColorCellStyle(-1);
            }
        }
        int colIndex = -1;
        for (BaseExportCol rowInfo : rowInfos) {
            XSSFCell cell = xssfRow.createCell(++colIndex, CellType.STRING);
            cell.setCellStyle((CellStyle)rowColorCellStyle);
            ColumnEnum columnEnum = rowInfo.getRowType();
            String number = rowInfo.getNumber();
            if (this.isDimensionColumn(columnEnum)) {
                String memNum = rowDimMembers.get(number);
                Long viewId = viewIds.get(number);
                Member member = modelCacheHelper.getMember(number, viewId, memNum);
                String memName = "";
                if (member == null) {
                    memNum = "";
                } else if (statisticsDims.indexOf(number) < 1 || number.equals(definedDimension)) {
                    StringBuilder name = new StringBuilder();
                    if (statisticsDims.indexOf(number) == 0) {
                        for (int i = 0; i < level; ++i) {
                            name.append(" ");
                        }
                    }
                    name.append(member.getName());
                    memName = name.toString();
                } else {
                    memName = this.getMemberLongName(member, viewId);
                }
                cell.setCellValue(memNum);
                cell = xssfRow.createCell(++colIndex, CellType.STRING);
                cell.setCellStyle((CellStyle)rowColorCellStyle);
                cell.setCellValue(memName);
                continue;
            }
            String cellValue = "";
            if (otherInfoMap != null && otherInfoMap.size() != 0) {
                cellValue = otherInfoMap.get("f" + number);
            }
            if (rowInfo instanceof EnumExportCol) {
                Map enumMap = ((EnumExportCol)rowInfo).getEnumMap();
                cellValue = enumMap.getOrDefault(cellValue, cellValue);
            }
            cell.setCellValue(cellValue);
        }
    }

    private String getValueByColType(BaseExportCol rowInfo, String cellValue) {
        String retValue;
        MeasureExportCol measureExportCol = (MeasureExportCol)rowInfo;
        FieldTypeEnum fieldType = measureExportCol.getFieldType();
        switch (fieldType) {
            case EnumField: {
                Map enumMap = ((EnumExportCol)measureExportCol).getEnumMap();
                retValue = enumMap.getOrDefault(cellValue, cellValue);
                break;
            }
            default: {
                retValue = cellValue;
            }
        }
        return retValue;
    }

    private String getMemberLongName(Member member, Long viewId) {
        ArrayList<String> parentNames = new ArrayList<String>(16);
        String longNumber = member.getLongNumber();
        String[] parents = longNumber.split("!");
        Dimension dimension = member.getDimension();
        for (String parent : parents) {
            Member parentMember = dimension.getMember(viewId, parent);
            parentNames.add(parentMember.getName());
        }
        return String.join((CharSequence)"-", parentNames);
    }

    protected boolean isAllDetailMember(Map<String, String> dimMemForKey, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        boolean isAllDetail = true;
        for (Map.Entry<String, String> dimMember : dimMemForKey.entrySet()) {
            String dimNumber = dimMember.getKey();
            String memberNumber = dimMember.getValue();
            Member member = modelCacheHelper.getMember(dimNumber, viewIds.get(dimNumber), memberNumber);
            if (member.isLeaf()) continue;
            isAllDetail = false;
            break;
        }
        return isAllDetail;
    }

    private Map<MembersKey, Object> queryAllOlapData(Map<String, Map<String, String>> rows, Map<String, Map<String, String>> cols, IModelCacheHelper modelCacheHelper, Map<String, String> hiddenDimMemMap, Long modelId, Long dataSetId) {
        HashMap dimMemberGroups = new HashMap(16);
        BgApplyBillUtils instance = BgApplyBillUtils.getInstance();
        instance.mergeMap(hiddenDimMemMap, dimMemberGroups);
        if (rows.size() == 0) {
            return new HashMap<MembersKey, Object>(16);
        }
        rows.values().forEach(value -> instance.mergeMap(value, dimMemberGroups));
        if (cols.size() == 0) {
            return new HashMap<MembersKey, Object>(16);
        }
        cols.values().forEach(value -> instance.mergeMap(value, dimMemberGroups));
        return instance.queryOlapData(modelCacheHelper, modelId, dataSetId, dimMemberGroups, true, 0L);
    }

    private boolean dealRowInfos(List<BaseColumn> colList, List<BaseExportCol> rowInfos, Map<String, Long> viewIds, Map<String, String> hiddenDimMemMap, Long tempId, IModelCacheHelper modelCacheHelper) {
        boolean hasMultiTitle = false;
        Map colTypes = ApplyTemplateColCfgService.getInstance().queryColCfgMapByTemplateId(tempId, FormTypeEnum.APPLY);
        List limitInputCols = CentralAppBillService.getInstance().getConfigCols(colTypes, ColCfgPropEnum.READONLY);
        for (BaseColumn column : colList) {
            String number;
            DimensionExportCol exportCol;
            String key = column.getKey();
            boolean isRelateDimension = false;
            if (column instanceof DimensionColumn) {
                exportCol = new DimensionExportCol(((DimensionColumn)column).getDimensionMemberRanges());
                number = ((DimensionColumn)column).getDimNumber();
            } else if (column instanceof RowDimensionColumn) {
                exportCol = new DimensionExportCol(((RowDimensionColumn)column).getDimensionMemberRanges());
                number = ((RowDimensionColumn)column).getDimNumber();
            } else if (column instanceof RelationDimensionColumn) {
                exportCol = new DimensionExportCol();
                number = BgApplyBillUtils.getInstance().getRelationDimensionNumber((RelationDimensionColumn)column, modelCacheHelper);
                isRelateDimension = true;
            } else {
                if (column instanceof MeasureColumn) {
                    MeasureColumn measureColumn = (MeasureColumn)column;
                    exportCol = this.getExportCol(measureColumn);
                } else if (column instanceof DimensionDataColumn && FieldTypeEnum.EnumField == column.getFieldtype() && CollectionUtils.isNotEmpty((Collection)column.getEnumdata())) {
                    List enumDatas = column.getEnumdata();
                    HashMap enumMap = new HashMap(16);
                    enumDatas.forEach(e -> {
                        String cfr_ignored_0 = (String)enumMap.put(e.getValue(), e.getCaption().get((Object)LanguageUtils.getLang((Lang)Lang.zh_CN).toString()));
                    });
                    exportCol = new EnumExportCol(column.getFieldtype(), enumMap);
                } else {
                    exportCol = new BaseExportCol();
                }
                number = key;
            }
            exportCol.setName(column.getTitle());
            exportCol.setNumber(number);
            exportCol.setRowType(column.getType());
            String groupTitle = column.getGrouptitle();
            exportCol.setGroupTitle(groupTitle);
            if (limitInputCols.contains(key) || isRelateDimension) {
                exportCol.setMustInput(Boolean.valueOf(false));
            } else {
                exportCol.setMustInput(column.getIsmustinput());
            }
            rowInfos.add((BaseExportCol)exportCol);
            if (!StringUtils.isNotEmpty((String)groupTitle)) continue;
            hasMultiTitle = true;
        }
        return hasMultiTitle;
    }

    private BaseExportCol getExportCol(MeasureColumn measureColumn) {
        if (FieldTypeEnum.EnumField == measureColumn.getFieldtype()) {
            HashMap enumMap = new HashMap(16);
            List enumDatas = measureColumn.getEnumdata();
            enumDatas.forEach(e -> {
                String cfr_ignored_0 = (String)enumMap.put(e.getValue(), e.getCaption().get((Object)LanguageUtils.getLang((Lang)Lang.zh_CN).toString()));
            });
            return new EnumExportCol(measureColumn.getFieldtype(), enumMap);
        }
        return new MeasureExportCol(measureColumn.getFieldtype());
    }

    private void addSameTitleRows(List<BaseColumn> colList_tmp, int index, String groupTitle, List<BaseColumn> colList) {
        for (int i = index; i < colList_tmp.size(); ++i) {
            BaseColumn column = colList_tmp.get(i);
            String title = column.getGrouptitle();
            if (!groupTitle.equals(title)) continue;
            colList.add(column);
        }
    }

    private int createTitleRows(XSSFSheet sheet, List<BaseExportCol> rowInfos, int currentRow, IModelCacheHelper modelCacheHelper, Map<String, List<String>> dimRanges, List<String> dimOrder, Long dataSetId, Boolean hasMultiTitle) {
        XSSFRow numberRow = sheet.createRow(currentRow);
        XSSFRow nameRow = sheet.createRow(++currentRow);
        XSSFRow nameRowMerge = null;
        if (hasMultiTitle.booleanValue()) {
            nameRowMerge = sheet.createRow(++currentRow);
        }
        int groupTitleIndex = -1;
        int colIndex = 0;
        for (BaseExportCol rowInfo : rowInfos) {
            String number = rowInfo.getNumber();
            String name = rowInfo.getName();
            String groupTitle = rowInfo.getGroupTitle();
            Boolean isMustInput = rowInfo.getMustInput();
            ColumnEnum colEnum = rowInfo.getRowType();
            if (this.isDimensionColumn(colEnum)) {
                this.setRowTitleValue(sheet, numberRow, nameRow, nameRowMerge, groupTitle, number, name, colIndex, currentRow, colEnum, isMustInput, true);
                this.setRowTitleValue(sheet, numberRow, nameRow, nameRowMerge, groupTitle, number, name, ++colIndex, currentRow, colEnum, isMustInput, false);
                List dimRange = ((DimensionExportCol)rowInfo).getDimRange();
                List memberRanges = BgApplyBillUtils.getInstance().getMemberRanges(dimRange, modelCacheHelper, dataSetId, number);
                List members = dimRanges.computeIfAbsent(number, k -> new ArrayList(16));
                memberRanges.removeAll(members);
                members.addAll(memberRanges);
                if (!dimOrder.contains(number)) {
                    dimOrder.add(number);
                }
            } else {
                this.setRowTitleValue(sheet, numberRow, nameRow, nameRowMerge, groupTitle, number, name, colIndex, currentRow, colEnum, isMustInput, true);
            }
            groupTitleIndex = this.mergeGroupTitle(sheet, groupTitle, nameRow, currentRow - 1, colIndex, groupTitleIndex, this.isDimensionColumn(colEnum));
            ++colIndex;
        }
        return currentRow;
    }

    private int mergeGroupTitle(XSSFSheet sheet, String groupTitle, XSSFRow nameRow, int rowIndex, int currentCol, int groupTitleIndex, Boolean isDimension) {
        if (StringUtils.isEmpty((String)groupTitle)) {
            return -1;
        }
        if (groupTitleIndex == -1 && !isDimension.booleanValue()) {
            return currentCol;
        }
        CellRangeAddress titleRegion = null;
        if (groupTitleIndex == -1) {
            titleRegion = new CellRangeAddress(rowIndex, rowIndex, currentCol - 1, currentCol);
            sheet.addMergedRegion(titleRegion);
            groupTitleIndex = currentCol - 1;
        } else {
            XSSFCell mergeTitleRowCell = nameRow.getCell(groupTitleIndex);
            String mergeTitleValue = mergeTitleRowCell.getStringCellValue();
            if (groupTitle.equals(mergeTitleValue)) {
                titleRegion = new CellRangeAddress(rowIndex, rowIndex, groupTitleIndex, currentCol);
                this.mergeRowCellRangeAddress(sheet, titleRegion);
            } else if (isDimension.booleanValue()) {
                titleRegion = new CellRangeAddress(rowIndex, rowIndex, currentCol - 1, currentCol);
                sheet.addMergedRegion(titleRegion);
                groupTitleIndex = currentCol - 1;
            } else {
                groupTitleIndex = currentCol;
            }
        }
        XSSFCell mergeCell = nameRow.getCell(groupTitleIndex);
        mergeCell.setCellStyle((CellStyle)this.getCellStyle(CellStyleEnum.MERGE));
        return groupTitleIndex;
    }

    private void mergeRowCellRangeAddress(XSSFSheet sheet, CellRangeAddress titleRegion) {
        List mergedRegions = sheet.getMergedRegions();
        int toRemove = -1;
        int row = titleRegion.getFirstRow();
        int firstColumn = titleRegion.getFirstColumn();
        int lastColumn = titleRegion.getLastColumn();
        for (int i = 0; i < mergedRegions.size(); ++i) {
            CellRangeAddress mergedRegion = (CellRangeAddress)mergedRegions.get(i);
            if (mergedRegion.getFirstRow() != mergedRegion.getLastRow() || mergedRegion.getFirstRow() != row) continue;
            if (mergedRegion.getFirstColumn() <= firstColumn && mergedRegion.getLastColumn() >= lastColumn) {
                return;
            }
            if (mergedRegion.getFirstColumn() < firstColumn || mergedRegion.getLastColumn() > lastColumn) continue;
            toRemove = i;
            break;
        }
        if (toRemove != -1) {
            sheet.removeMergedRegion(toRemove);
        }
        sheet.addMergedRegion(titleRegion);
    }

    private void setRowTitleValue(XSSFSheet sheet, XSSFRow numberRow, XSSFRow nameRow, XSSFRow nameRowMerge, String groupTitle, String number, String name, Integer colIndex, Integer currentRow, ColumnEnum rowEnum, Boolean isMustInput, Boolean isMain) {
        XSSFCell numberCell = numberRow.createCell(colIndex.intValue(), CellType.STRING);
        XSSFCell nameCell = nameRow.createCell(colIndex.intValue(), CellType.STRING);
        String numberValue = number;
        if (this.isDimensionColumn(rowEnum)) {
            numberValue = isMain != false ? number + ".number" : number + ".name";
        }
        numberCell.setCellValue(numberValue);
        if (nameRowMerge != null && StringUtils.isNotEmpty((String)groupTitle)) {
            XSSFCell nameMergeCell = nameRowMerge.createCell(colIndex.intValue(), CellType.STRING);
            nameCell.setCellValue(groupTitle);
            this.setRowDimTitleNameValue(nameMergeCell, name, rowEnum, isMustInput, isMain);
        } else {
            this.setRowDimTitleNameValue(nameCell, name, rowEnum, isMustInput, isMain);
            if (nameRowMerge != null) {
                nameRowMerge.createCell(colIndex.intValue(), CellType.STRING);
                CellRangeAddress titleRegion = new CellRangeAddress(currentRow - 1, currentRow.intValue(), colIndex.intValue(), colIndex.intValue());
                sheet.addMergedRegion(titleRegion);
            }
        }
    }

    private void setRowDimTitleNameValue(XSSFCell nameCell, String name, ColumnEnum colEnum, Boolean isMustInput, Boolean isMain) {
        XSSFCellStyle cellStyle = null;
        String cellValue = name;
        if (isMustInput.booleanValue() && isMain.booleanValue()) {
            cellValue = "*" + cellValue;
            cellStyle = this.getCellStyle(CellStyleEnum.MUST_INPUT_TITLE);
        } else {
            cellStyle = this.getCellStyle(CellStyleEnum.TITLE);
        }
        nameCell.setCellStyle((CellStyle)cellStyle);
        if (!isMain.booleanValue()) {
            cellValue = ResManager.loadResFormat((String)"%1.\u540d\u79f0", (String)"BgApplyBillDataExportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{cellValue});
        } else if (this.isDimensionColumn(colEnum)) {
            cellValue = ResManager.loadResFormat((String)"%1.\u7f16\u7801", (String)"BgApplyBillDataExportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{cellValue});
        }
        nameCell.setCellValue(cellValue);
    }

    protected boolean isDimensionColumn(ColumnEnum colEnum) {
        return ColumnEnum.Dimension == colEnum || ColumnEnum.RelationDimension == colEnum || ColumnEnum.RowDimension == colEnum;
    }

    private boolean isDimOrMeasureColumn(ColumnEnum colEnum) {
        return this.isDimensionColumn(colEnum) || ColumnEnum.Measure == colEnum || ColumnEnum.DimensionData == colEnum;
    }

    private int createColDimRows(XSSFSheet sheet, Map<Integer, String> measureCols, Map<String, Map<String, String>> colMembers, IModelCacheHelper modelCacheHelper, Integer dimColIndex, Map<String, Long> viewIds) {
        int baseColIndex = 5;
        List<String> colDims = this.getColDims(colMembers);
        for (int i = 0; i <= colDims.size(); ++i) {
            XSSFRow row = sheet.createRow(baseColIndex + i);
            this.setColDimCellValue(row, dimColIndex, colDims, modelCacheHelper, i);
            for (Map.Entry<Integer, String> measureCol : measureCols.entrySet()) {
                Map<String, String> memberMap = colMembers.get(measureCol.getValue());
                if (memberMap == null) continue;
                this.setColMemCellValue(row, colDims, modelCacheHelper, memberMap, viewIds, measureCol.getKey(), i);
            }
        }
        return baseColIndex + colDims.size() + 1;
    }

    private void setColMemCellValue(XSSFRow row, List<String> colDims, IModelCacheHelper modelCacheHelper, Map<String, String> memberMap, Map<String, Long> viewIds, Integer colIndex, Integer i) {
        XSSFCell cell = row.createCell(colIndex.intValue(), CellType.STRING);
        String value = null;
        if (i == 0) {
            value = ResManager.loadKDString((String)"#\u7ef4\u5ea6\u6210\u5458", (String)"BgApplyBillDataExportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else {
            String dimNum = colDims.get(i - 1);
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            if (dimension == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u83b7\u53d6\u5230\u7ef4\u5ea6%1\u4fe1\u606f\u3002", (String)"BgApplyBillDataExportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNum}));
            }
            String membNum = memberMap.get(dimNum);
            if (membNum != null) {
                Member member = dimension.getMember(viewIds.get(dimNum), membNum);
                if (member == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u83b7\u53d6\u5230\u7ef4\u5ea6%1\u7684\u6210\u5458%2\u4fe1\u606f\u3002", (String)"BgApplyBillDataExportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNum, membNum}));
                }
                value = member.getName() + "#" + member.getNumber();
            }
        }
        cell.setCellValue(value);
    }

    private void setColDimCellValue(XSSFRow row, Integer dimColIndex, List<String> colDims, IModelCacheHelper modelCacheHelper, int i) {
        XSSFCell cell = row.createCell(dimColIndex.intValue(), CellType.STRING);
        String value = null;
        if (i == 0) {
            value = ResManager.loadKDString((String)"#\u5217\u7ef4\u5ea6", (String)"BgApplyBillDataExportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else {
            String dimNum = colDims.get(i - 1);
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            if (dimension == null) {
                throw new KDBizException("");
            }
            value = dimension.getName() + "#" + dimNum;
        }
        cell.setCellValue(value);
    }

    private List<String> getColDims(Map<String, Map<String, String>> colMembers) {
        HashSet allColDimNums = new HashSet(16);
        colMembers.values().forEach(colDimMemberInfo -> allColDimNums.addAll(colDimMemberInfo.keySet()));
        return new ArrayList<String>(allColDimNums);
    }

    private Integer getMeasureOrCalCols(List<BaseColumn> colList, Map<Integer, String> measureCols) {
        if (colList == null || colList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5217\u4fe1\u606f\u4e3a\u7a7a", (String)"BgApplyBillDataExportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        int index = -1;
        int minIndex = -1;
        for (BaseColumn column : colList) {
            index = ColumnEnum.Dimension == column.getType() || ColumnEnum.RowDimension == column.getType() || ColumnEnum.RelationDimension == column.getType() ? (index += 2) : ++index;
            if (ColumnEnum.Measure != column.getType() && ColumnEnum.DimensionData != column.getType() && ColumnEnum.Cal != column.getType()) continue;
            if (minIndex == -1) {
                minIndex = index;
            }
            measureCols.put(index, column.getKey());
        }
        return minIndex;
    }

    private void createHideDimRows(XSSFSheet sheet, Map<String, String> hiddenDimMemMap, Map<String, Long> viewIds, IModelCacheHelper modelCacheHelper) {
        sheet.createRow(2);
        XSSFRow dimRow = sheet.createRow(3);
        XSSFRow memRow = sheet.createRow(4);
        this.setHideDimDefaultCell(dimRow, memRow);
        int colIndex = 1;
        for (Map.Entry<String, String> hiddenDim : hiddenDimMemMap.entrySet()) {
            String dimNum = hiddenDim.getKey();
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            if (dimension == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u7f13\u5b58\u4e2d\u672a\u83b7\u53d6\u5230\u9690\u85cf\u7ef4%1\u3002", (String)"BgApplyBillDataExportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNum}));
            }
            String dimInfo = dimension.getName() + "#" + dimNum;
            XSSFCell dimCell = dimRow.createCell(colIndex, CellType.STRING);
            dimCell.setCellValue(dimInfo);
            Member member = dimension.getMember(viewIds.get(dimNum), hiddenDim.getValue());
            if (member == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u7f13\u5b58\u4e2d\u672a\u83b7\u53d6\u5230\u9690\u85cf\u7ef4%1\u7684\u6210\u5458\u3002", (String)"BgApplyBillDataExportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNum}));
            }
            String memInfo = member.getName() + "#" + member.getNumber();
            XSSFCell memCell = memRow.createCell(colIndex, CellType.STRING);
            memCell.setCellValue(memInfo);
            ++colIndex;
        }
    }

    private void setHideDimDefaultCell(XSSFRow dimRow, XSSFRow memRow) {
        XSSFCell dimCell = dimRow.createCell(0, CellType.STRING);
        dimCell.setCellValue(ResManager.loadKDString((String)"#\u9690\u85cf\u7ef4\u5ea6", (String)"BgApplyBillDataExportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        XSSFCell memCell = memRow.createCell(0, CellType.STRING);
        memCell.setCellValue(ResManager.loadKDString((String)"#\u7ef4\u5ea6\u6210\u5458", (String)"BgApplyBillDataExportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void createSecondSheetRow(XSSFSheet sheet, String name, String number) {
        XSSFRow row = sheet.createRow(1);
        XSSFCellStyle cellStyle = this.getCellStyle(CellStyleEnum.MUST_INPUT);
        XSSFCell cell = row.createCell(0, CellType.STRING);
        cell.setCellStyle((CellStyle)cellStyle);
        cell.setCellValue(ResManager.loadKDString((String)"#\u6a21\u677f\u7f16\u7801#", (String)"BgApplyBillDataExportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        cell = row.createCell(1, CellType.STRING);
        cell.setCellStyle((CellStyle)cellStyle);
        cell.setCellValue("#" + number + "#");
        cell = row.createCell(2, CellType.STRING);
        cell.setCellValue(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"BgApplyBillDataExportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        cell = row.createCell(3, CellType.STRING);
        cell.setCellValue(name);
    }

    private XSSFWorkbook getInitExcel() {
        this.workBook = new XSSFWorkbook();
        this.cellStyleMap.clear();
        this.rowCellStyleMap.clear();
        this.rowCellFontMap.clear();
        XSSFCellStyle style = this.workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return this.workBook;
    }

    private void createFirstSheetRow(XSSFSheet sheet) {
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = row.createCell(0, CellType.STRING);
        cell.setCellStyle((CellStyle)this.getCellStyle(CellStyleEnum.TOP));
        cell.setCellValue("#kingdee#");
    }

    private XSSFCellStyle getCellStyle(CellStyleEnum cellStyleEnum) {
        if (this.cellStyleMap.size() == 0) {
            this.initCellStyles();
        }
        return this.cellStyleMap.get(cellStyleEnum.getNumber());
    }

    private XSSFFont getRowCellFont(Short index) {
        XSSFFont xssfFont = this.rowCellFontMap.get(index);
        if (xssfFont == null) {
            xssfFont = this.createFont(index);
        }
        return xssfFont;
    }

    private XSSFCellStyle getRowColorCellStyle(int level) {
        XSSFCellStyle xssfCellStyle = this.rowCellStyleMap.get(level);
        if (xssfCellStyle == null) {
            xssfCellStyle = this.initRowColorCellStyle(level);
        }
        return xssfCellStyle;
    }

    private XSSFCellStyle initRowColorCellStyle(int level) {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        if (level != -1) {
            cellStyle.setFillForegroundColor(new XSSFColor(this.getColor(level), (IndexedColorMap)new DefaultIndexedColorMap()));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.rowCellStyleMap.put(level, cellStyle);
        return cellStyle;
    }

    private Color getColor(int level) {
        return new Color(155, 194, 230);
    }

    private int getColorIndex(int index) {
        return 16 * index + index;
    }

    private void initCellStyles() {
        this.createTopCellType();
        this.createMustInputCellType();
        this.createMergeCellType();
        this.createTextCellType();
        this.createTitleCellType();
        this.createMustInputTitleCellType();
    }

    private XSSFFont createFont(Short index) {
        XSSFFont font = this.workBook.createFont();
        font.setColor(index.shortValue());
        font.setBold(true);
        this.rowCellFontMap.put(index, font);
        return font;
    }

    private void createTopCellType() {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_BLUE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cellStyleMap.put(CellStyleEnum.TOP.getNumber(), cellStyle);
    }

    private void createMustInputCellType() {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        XSSFFont font = this.getRowCellFont(IndexedColors.RED.getIndex());
        cellStyle.setFont((Font)font);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cellStyleMap.put(CellStyleEnum.MUST_INPUT.getNumber(), cellStyle);
    }

    private void createMergeCellType() {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillForegroundColor(new XSSFColor(new Color(204, 204, 204), (IndexedColorMap)new DefaultIndexedColorMap()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont font = this.getRowCellFont(IndexedColors.BLACK.getIndex());
        cellStyle.setFont((Font)font);
        this.cellStyleMap.put(CellStyleEnum.MERGE.getNumber(), cellStyle);
    }

    private void createTextCellType() {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        XSSFDataFormat dataFormat = this.workBook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("@"));
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cellStyleMap.put(CellStyleEnum.TEXT.getNumber(), cellStyle);
    }

    private void createTitleCellType() {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        cellStyle.setFillForegroundColor(new XSSFColor(new Color(204, 204, 204), (IndexedColorMap)new DefaultIndexedColorMap()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont font = this.getRowCellFont(IndexedColors.BLACK.getIndex());
        cellStyle.setFont((Font)font);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cellStyleMap.put(CellStyleEnum.TITLE.getNumber(), cellStyle);
    }

    private void createMustInputTitleCellType() {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        cellStyle.setFillForegroundColor(new XSSFColor(new Color(204, 204, 204), (IndexedColorMap)new DefaultIndexedColorMap()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont font = this.getRowCellFont(IndexedColors.RED.getIndex());
        cellStyle.setFont((Font)font);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cellStyleMap.put(CellStyleEnum.MUST_INPUT_TITLE.getNumber(), cellStyle);
    }

    private BigDecimal getUnitData(String unitStr) {
        int unit = this.getUnit(unitStr);
        return BigDecimal.TEN.pow(unit);
    }

    private int getUnit(String val) {
        int unit = 0;
        switch (val) {
            case "1": {
                unit = 0;
                break;
            }
            case "2": {
                unit = 3;
                break;
            }
            case "3": {
                unit = 4;
                break;
            }
            case "4": {
                unit = 5;
                break;
            }
            case "5": {
                unit = 6;
                break;
            }
            case "6": {
                unit = 7;
                break;
            }
            case "7": {
                unit = 8;
            }
        }
        return unit;
    }
}

