/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applyschedule;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.Variable;
import kd.epm.eb.business.applybill.util.BgApplyBillHelper;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applybill.util.BgApplyTempHelper;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.centralapproval.CentralApprovePlanService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.reportscheme.service.ReportSchemeAssignService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.applybill.ApplyBillStatusEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.applyschedule.BgApplyScheduleQueryListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BgApplyScheduleQueryListPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BgApplyScheduleQueryListPlugin.class);
    private static final String MODEL = "model";
    private static final String DATATYPE_KEY = "datatype";
    private static final String YERA_KEY = "year";
    private static final String VERSION_KEY = "version";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BTN_TASKURGE = "btn_taskurge";
    private static final String BTN_REFRESH = "btn_refresh";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModel();
        this.setModelFilter();
        this.refreshEntry();
    }

    private void initModel() {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"BgApplyScheduleQueryListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.modelChanged(modelId);
            this.initDim();
        }
    }

    private void initDim() {
        HashMap userSelect = (HashMap)UserSelectUtils.getWholeUserSelect((IFormView)this.getView(), HashMap.class);
        if (userSelect != null) {
            this.getModel().setValue(YERA_KEY, userSelect.get("Period"));
            this.getModel().setValue(VERSION_KEY, userSelect.get("Version"));
            this.getModel().setValue(DATATYPE_KEY, userSelect.get("DataType"));
        } else {
            this.getModel().setValue(YERA_KEY, null);
            this.getModel().setValue(VERSION_KEY, null);
            this.getModel().setValue(DATATYPE_KEY, null);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addF7SelectListener(this, new String[]{YERA_KEY, DATATYPE_KEY, VERSION_KEY, MODEL});
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String auditId;
        super.hyperLinkClick(event);
        String fieldName = event.getFieldName();
        if ("applynumber".equals(fieldName)) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("apply", event.getRowIndex());
            if (dynamicObject != null && !this.isPastPage(dynamicObject.getLong("id"), "apply").booleanValue()) {
                this.openApplyBillPage(dynamicObject.getString("id"));
            }
        } else if ("collectnumber".equals(fieldName)) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("collect", event.getRowIndex());
            if (dynamicObject != null && !this.isPastPage(dynamicObject.getLong("id"), "collect").booleanValue()) {
                this.openApplyBillPage(dynamicObject.getString("id"));
            }
        } else if ("audit".equals(fieldName) && (auditId = (String)this.getModel().getValue("auditid", event.getRowIndex())) != null) {
            HashMap<String, String> entityMap = new HashMap<String, String>(16);
            HashMap<String, Set<String>> entityApprovePlanMap = new HashMap<String, Set<String>>(16);
            if (!ModelServiceHelper.isUserHasRootPermByModel((long)this.getUserId(), (Long)this.getModelId()) && this.isExistMultiApproveEntity(IDUtils.toLong((Object)auditId), entityMap, entityApprovePlanMap)) {
                this.openApproveBillOrgSelPage(IDUtils.toLong((Object)auditId), entityMap, entityApprovePlanMap);
            } else if (!this.isPastPage(IDUtils.toLong((Object)auditId), "audit").booleanValue()) {
                this.openApproveBillPage(auditId, null);
            }
        }
    }

    private Boolean isPastPage(Long billId, String billType) {
        Boolean existCurrentBill = false;
        if ("apply".equals(billType) || "collect".equals(billType)) {
            existCurrentBill = ReportSchemeService.getInstance().isExistCurrentApCoBill(this.getModelId(), billId);
        } else if ("audit".equals(billType)) {
            existCurrentBill = ReportSchemeService.getInstance().isExistCurrentAuditBill(this.getModelId(), billId);
        }
        if (!existCurrentBill.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"BgApplyScheduleQueryListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void openApproveBillOrgSelPage(Long billId, Map<String, String> entityMap, Map<String, Set<String>> entityApprovePlanMap) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_approvebillentitysel");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7", (String)"BgApplyScheduleQueryListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("billId", (Object)billId);
        showParameter.setCustomParam("entityMap", (Object)SerializationUtils.toJsonString(entityMap));
        showParameter.setCustomParam("entityApprovePlanMap", (Object)SerializationUtils.toJsonString(entityApprovePlanMap));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "select_entity");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private boolean isExistMultiApproveEntity(Long billId, Map<String, String> entityMap, Map<String, Set<String>> entityApprovePlanMap) {
        DynamicObject billObject = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"eb_centralappbill");
        HashSet<String> approvePlans = new HashSet<String>();
        this.getPlansInWorkFlow(billId.toString(), billObject, approvePlans);
        Map approvePlanInfo = CentralApprovePlanService.getInstance().getApprovePlanInfoByNumbers(approvePlans, this.getModelId());
        if (approvePlanInfo != null && approvePlanInfo.size() > 0) {
            for (Map object : approvePlanInfo.values()) {
                if (!((Boolean)object.get("centralizedstatus")).booleanValue()) continue;
                String centralizeApproveOrgNumber = (String)object.get("centralizeApproveOrgNumber");
                String centralizeApproveOrgName = (String)object.get("centralizeApproveOrgName");
                String approveSchemeNumber = (String)object.get("approveSchemeNumber");
                entityMap.put(centralizeApproveOrgNumber, centralizeApproveOrgName);
                Set orgApprovePlans = entityApprovePlanMap.computeIfAbsent(centralizeApproveOrgName, k -> new HashSet());
                orgApprovePlans.add(approveSchemeNumber);
                entityApprovePlanMap.put(centralizeApproveOrgNumber, orgApprovePlans);
            }
        }
        return entityMap.size() > 1;
    }

    private void openApplyBillPage(String billId) {
        IFormView parentView = this.getView().getParentView();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"eb_bgapplybill");
        ApplyBillType billType = ApplyBillType.getBillTypeByNumber((String)dynamicObject.getString("billtype"));
        String billNumber = dynamicObject.getString("billnumber");
        BaseShowParameter baseShowParameter = BgApplyBillHelper.getInstance().getBgApplyTypeBillFormShow(Long.valueOf(dynamicObject.getLong("applyscheme.id")), this.getModelId(), billNumber, billType);
        Long orgId = dynamicObject.getLong("org.id");
        baseShowParameter.setCustomParam("orgId", (Object)orgId);
        baseShowParameter.setPkId((Object)billId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String billStatus = dynamicObject.getString("billstatus");
        baseShowParameter.setStatus(OperationStatus.EDIT);
        if ("C".equals(billStatus) || "D".equals(billStatus) || "B".equals(billStatus)) {
            baseShowParameter.setStatus(OperationStatus.VIEW);
        } else {
            baseShowParameter.setStatus(OperationStatus.EDIT);
        }
        if (!this.checkCreator(dynamicObject)) {
            baseShowParameter.setStatus(OperationStatus.VIEW);
            baseShowParameter.setCustomParam("NOT_CREATOR", (Object)"true");
        }
        baseShowParameter.setPageId(this.getView().getPageId() + billId);
        if (parentView == null) {
            baseShowParameter.setParentPageId(this.getView().getPageId());
            baseShowParameter.setParentFormId(this.getView().getEntityId());
            this.getView().showForm((FormShowParameter)baseShowParameter);
        } else {
            baseShowParameter.setParentPageId(parentView.getPageId());
            baseShowParameter.setParentFormId(parentView.getEntityId());
            parentView.showForm((FormShowParameter)baseShowParameter);
            this.getView().sendFormAction(parentView);
        }
    }

    private boolean checkCreator(DynamicObject dynamicObject) {
        Long userId = this.getUserId();
        return this.checkCreator(dynamicObject, userId) || this.isModelManager(userId);
    }

    private boolean checkCreator(DynamicObject dynamicObject, Long currentUser) {
        Long creator = dynamicObject.getLong("creater.id");
        return creator != null && creator.equals(currentUser);
    }

    private boolean isModelManager(Long currentUser) {
        Long modelId = this.getModelId();
        return ModelServiceHelper.isUserHasRootPermByModel((long)currentUser, (Long)modelId);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String key = evt.getActionId();
        if ("select_entity".equals(key)) {
            this.openApproveBillPage(null, (Map)returnData);
        }
    }

    private void openApproveBillPage(String billId, Map<String, Object> returnData) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        if (returnData == null) {
            openParameter.put("formId", "eb_centralappbill");
            openParameter.put("pkId", billId);
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setShowTitle(true);
            this.getView().showForm(formShowParameter);
        } else {
            billId = returnData.get("billId").toString();
            if (returnData.get("selectedOrgNumber") == null) {
                return;
            }
            openParameter.put("formId", "eb_centralappbill");
            openParameter.put("pkId", billId);
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setShowTitle(true);
            Set<Long> centralPlans = this.getCentralPlansBySelOrg(billId, (Set)returnData.get("selectedOrgNumber"));
            Set<Long> templates = this.getApprovePlanTemplates((Set)returnData.get("approvePlanNumbers"), IDUtils.toLong((Object)billId));
            formShowParameter.setCustomParam("centralPlans", (Object)SerializationUtils.toJsonString(centralPlans));
            formShowParameter.setCustomParam("templates", (Object)SerializationUtils.toJsonString(templates));
            this.getView().showForm(formShowParameter);
        }
    }

    private Set<Long> getCentralPlansBySelOrg(String billId, Set<String> selectedOrgNumber) {
        DynamicObject billObject = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)billId), (String)"eb_centralappbill");
        HashSet<Long> centralPlans = new HashSet<Long>(16);
        HashSet<String> approvePlans = new HashSet<String>(16);
        this.getPlansInWorkFlow(billId, billObject, approvePlans);
        Map approvePlanInfo = CentralApprovePlanService.getInstance().getApprovePlanInfoByNumbers(approvePlans, this.getModelId());
        if (approvePlanInfo != null && approvePlanInfo.size() > 0) {
            for (Map object : approvePlanInfo.values()) {
                String centralizeApproveOrgNumber;
                if (!((Boolean)object.get("centralizedstatus")).booleanValue() || !selectedOrgNumber.contains(centralizeApproveOrgNumber = (String)object.get("centralizeApproveOrgNumber"))) continue;
                centralPlans.add((Long)object.get("centralizePlanId"));
            }
        }
        return centralPlans;
    }

    private Set<Long> getApprovePlanTemplates(Set<String> selectOrgNumber, Long billId) {
        DynamicObject billObject = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"eb_centralappbill");
        if (billObject != null) {
            Long modelId = billObject.getLong("model.id");
            return CentralApprovePlanService.getInstance().getApprovePlanTemplatesByNumbers(selectOrgNumber, modelId);
        }
        return null;
    }

    private void modelChanged(Long modelId) {
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
            this.getPageCache().put(MODEL, modelId.toString());
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        }
    }

    private void setModelFilter() {
        QFilter filter1 = new QFilter("id", "=", (Object)this.getModelId());
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(MODEL);
        this.getView().getFormShowParameter().setAppId("bgmd");
        List modelFilters = ModelUtil.getModelFilter((IFormView)this.getView());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(modelFilters.size());
        for (QFilter filter : modelFilters) {
            filter.or(filter1);
            filters.add(filter);
        }
        basedataEdit.setQFilters(filters);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (key.equals(MODEL)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            return;
        }
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BgApplyScheduleQueryListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)this.getCurrentDimNumber(key)), (String)ListSelectedRow.class.getName());
        if (key.equals(YERA_KEY)) {
            QFilter qFilter = new QFilter("level", "=", (Object)2);
            Set periodsOfSchemeHasApTem = ReportSchemeAssignService.getInstance().getPeriodsOfSchemeHasApTem(this.getModelId());
            if (periodsOfSchemeHasApTem.size() > 0) {
                qFilter.or("id", "in", (Object)periodsOfSchemeHasApTem);
            }
            f7Param.addCustomCommFilter(qFilter);
        }
        NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
    }

    public String getCurrentDimNumber(String controlKey) {
        String dimNum = null;
        if (controlKey.equals(YERA_KEY)) {
            dimNum = SysDimensionEnum.BudgetPeriod.getNumber();
        } else if (controlKey.equals(DATATYPE_KEY)) {
            dimNum = SysDimensionEnum.DataType.getNumber();
        } else if (controlKey.equals(VERSION_KEY)) {
            dimNum = SysDimensionEnum.Version.getNumber();
        }
        return dimNum;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemKey;
        switch (itemKey = e.getProperty().getName()) {
            case "model": {
                this.modelChanged((Long)this.getValue(MODEL, "id"));
                this.initDim();
                this.refreshEntry();
                break;
            }
            case "datatype": 
            case "year": 
            case "version": {
                this.refreshEntry();
                this.saveUserSelectYVD();
                break;
            }
        }
    }

    private void saveUserSelectYVD() {
        Long yearId = (Long)this.getValue(YERA_KEY, "id");
        Long versionId = (Long)this.getValue(VERSION_KEY, "id");
        Long datatypeId = (Long)this.getValue(DATATYPE_KEY, "id");
        1 userSelect = new /* Unavailable Anonymous Inner Class!! */;
        UserSelectUtils.saveWholeUserSelect((IFormView)this.getView(), (long)this.getModelId(), (Object)userSelect);
    }

    private void refreshEntry() {
        this.getModel().deleteEntryData("treeentryentity");
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        TreeNode root = this.getSchemeOrgTree();
        ArrayList<Integer> schemeRowIndex = new ArrayList<Integer>();
        this.createTreeEntryEntityAllRows(root, schemeRowIndex);
        int[] schemeRows = new int[schemeRowIndex.size()];
        for (int i = 0; i < schemeRowIndex.size(); ++i) {
            schemeRows[i] = schemeRowIndex.get(i);
        }
        treeEntryGrid.expandOne(schemeRows);
        this.getView().updateView("treeentryentity");
        treeEntryGrid.selectRows(0);
        this.countBillNumbers();
    }

    private void countBillNumbers() {
        Label label;
        DynamicObjectCollection entity = this.getModel().getEntryEntity("treeentryentity");
        HashMap<String, Set> billCount = new HashMap<String, Set>(16);
        if (CollectionUtils.isNotEmpty((Collection)entity)) {
            for (DynamicObject dynamicObject : entity) {
                Set collectNumbers;
                if (StringUtils.isNotEmpty((String)dynamicObject.getString("applynumber"))) {
                    Set applyNumbers = billCount.computeIfAbsent("apply", k -> new HashSet(16));
                    applyNumbers.add(dynamicObject.getString("applynumber"));
                }
                if (StringUtils.isNotEmpty((String)dynamicObject.getString("collectnumber"))) {
                    collectNumbers = billCount.computeIfAbsent("collect", k -> new HashSet(16));
                    collectNumbers.add(dynamicObject.getString("collectnumber"));
                }
                if (StringUtils.isNotEmpty((String)dynamicObject.getString("audit"))) {
                    collectNumbers = billCount.computeIfAbsent("audit", k -> new HashSet(16));
                    collectNumbers.add(dynamicObject.getString("audit"));
                }
                if (!StringUtils.isNotEmpty((String)dynamicObject.getString("audit")) || !StringUtils.isNotEmpty((String)dynamicObject.getString("billstatus"))) continue;
                String billStatus = ApplyBillStatusEnum.getStatusByNumber((String)dynamicObject.getString("billstatus")).toString();
                Set appBillStatusNumbers = billCount.computeIfAbsent(billStatus, k -> new HashSet(16));
                appBillStatusNumbers.add(dynamicObject.getString("audit"));
            }
        }
        billCount.computeIfAbsent("apply", k -> new HashSet());
        billCount.computeIfAbsent("collect", k -> new HashSet());
        billCount.computeIfAbsent("audit", k -> new HashSet());
        billCount.computeIfAbsent(AppBillStatusEnum.SUBMITTED.toString(), k -> new HashSet());
        billCount.computeIfAbsent(AppBillStatusEnum.AUDITED.toString(), k -> new HashSet());
        if (billCount.get("apply") != null) {
            label = (Label)this.getView().getControl("lable_apply");
            label.setText(ResManager.loadResFormat((String)"\u7533\u62a5\u5355\uff08%1\uff09", (String)"BgApplyScheduleQueryListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{((Set)billCount.get("apply")).size()}));
        }
        if (billCount.get("collect") != null) {
            label = (Label)this.getView().getControl("lable_collect");
            label.setText(ResManager.loadResFormat((String)"\u6c47\u603b\u5355\uff08%1\uff09", (String)"BgApplyScheduleQueryListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{((Set)billCount.get("collect")).size()}));
        }
        if (billCount.get("audit") != null) {
            label = (Label)this.getView().getControl("lable_audit");
            label.setText(ResManager.loadResFormat((String)"\u5ba1\u6279\u5355\uff08%1\uff09", (String)"BgApplyScheduleQueryListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{((Set)billCount.get("audit")).size()}));
        }
        if (billCount.get(AppBillStatusEnum.SUBMITTED.toString()) != null) {
            label = (Label)this.getView().getControl("lable_inapprove");
            label.setText(ResManager.loadResFormat((String)"\u5ba1\u6279\u4e2d\uff08%1\uff09", (String)"BgApplyScheduleQueryListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{((Set)billCount.get(AppBillStatusEnum.SUBMITTED.toString())).size()}));
        }
        if (billCount.get(AppBillStatusEnum.AUDITED.toString()) != null) {
            label = (Label)this.getView().getControl("lable_approved");
            label.setText(ResManager.loadResFormat((String)"\u5df2\u5ba1\u6279\uff08%1\uff09", (String)"BgApplyScheduleQueryListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{((Set)billCount.get(AppBillStatusEnum.AUDITED.toString())).size()}));
        }
    }

    private void setBillDataToNodeData(TreeNode root) {
        List schemeNodes = root.getChildren();
        if (CollectionUtils.isEmpty((Collection)schemeNodes)) {
            return;
        }
        Map<String, DynamicObject> bills = this.getBillData();
        Map<String, List<Long>> dealerIdsMap = this.getDealerIdsMap();
        for (TreeNode schemeNode : schemeNodes) {
            this.updateNodeData(schemeNode, bills, dealerIdsMap);
        }
    }

    private void updateNodeData(TreeNode node, Map<String, DynamicObject> bills, Map<String, List<Long>> dealerIdsMap) {
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        ArrayList<TreeNode> newEntry = new ArrayList<TreeNode>();
        for (TreeNode orgNode : children) {
            String billNumber;
            Map data = (Map)orgNode.getData();
            String orgId = (String)data.get("orgId");
            Long schemeId = (Long)data.get("schemeId");
            String applyKey = schemeId + "_" + orgId + "_" + ApplyBillType.APPLY.getNumber();
            String collectKey = schemeId + "_" + orgId + "_" + ApplyBillType.COLLECY.getNumber();
            if (bills.get(applyKey) != null) {
                data.put("apply", bills.get(applyKey));
                data.put("apply_id", bills.get(applyKey).getLong("id"));
                billNumber = bills.get(applyKey).getString("billnumber");
                data.put("apply_number", billNumber);
                this.setApproveBillInfo(billNumber, data, bills, dealerIdsMap);
            }
            if (bills.get(applyKey) != null && bills.get(collectKey) != null) {
                TreeNode node1 = new TreeNode();
                Long id1 = GlobalIdUtil.genGlobalLongId();
                node1.setId(id1.toString());
                node1.setText(orgNode.getText());
                node1.setParentid(node.getId());
                HashMap<String, Object> data1 = new HashMap<String, Object>(16);
                data1.put("schemeId", schemeId);
                data1.put("orgId", orgId);
                data1.put("isScheme", Boolean.FALSE);
                data1.put("collect", bills.get(collectKey));
                data1.put("collect_id", bills.get(collectKey).getLong("id"));
                String billNumber2 = bills.get(collectKey).getString("billnumber");
                data1.put("collect_number", billNumber2);
                this.setApproveBillInfo(billNumber2, data1, bills, dealerIdsMap);
                node1.setData(data1);
                newEntry.add(node1);
            } else if (bills.get(collectKey) != null) {
                data.put("collect", bills.get(collectKey));
                data.put("collect_id", bills.get(collectKey).getLong("id"));
                billNumber = bills.get(collectKey).getString("billnumber");
                data.put("collect_number", billNumber);
                this.setApproveBillInfo(billNumber, data, bills, dealerIdsMap);
            }
            this.updateNodeData(orgNode, bills, dealerIdsMap);
        }
        if (newEntry.size() > 0) {
            for (int i = 0; i < newEntry.size(); ++i) {
                for (int j = 0; j < node.getChildren().size(); ++j) {
                    if (((TreeNode)newEntry.get(i)).getText() == null || !((TreeNode)newEntry.get(i)).getText().equals(((TreeNode)node.getChildren().get(j)).getText())) continue;
                    node.getChildren().add(j, newEntry.get(i));
                    ++j;
                }
            }
        }
    }

    private Map<String, List<Long>> getDealerIdsMap() {
        String dealerIdsStr = this.getView().getPageCache().get("dealerIds");
        Map<String, List<Long>> dealerIdsMap = new HashMap<String, List<Long>>(16);
        if (dealerIdsStr != null) {
            dealerIdsMap = (Map)ObjectSerialUtil.parseObject((String)dealerIdsStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        }
        return dealerIdsMap;
    }

    private void createTreeEntryEntityAllRows(TreeNode root, ArrayList<Integer> schemeRowIndex) {
        List children = root.getChildren();
        if (children == null || children.size() == 0) {
            return;
        }
        for (TreeNode child : children) {
            int rowIndex = this.getModel().createNewEntryRow("treeentryentity");
            this.updateTreeEntryEntityData(rowIndex, child, schemeRowIndex);
            this.createTreeEntryEntityAllRows(child, schemeRowIndex);
        }
    }

    private void updateTreeEntryEntityData(int rowIndex, TreeNode node, ArrayList<Integer> schemeRowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
        rowEntity.set("applyinfo", (Object)node.getText());
        rowEntity.set("id", (Object)node.getId());
        rowEntity.set("pid", (Object)node.getParentid());
        Map data = (Map)node.getData();
        if (data != null) {
            rowEntity.set("apply", data.get("apply"));
            rowEntity.set("apply_id", data.get("apply_id"));
            rowEntity.set("collect", data.get("collect"));
            rowEntity.set("collect_id", data.get("collect_id"));
            rowEntity.set("applynumber", data.get("apply_number"));
            rowEntity.set("collectnumber", data.get("collect_number"));
            rowEntity.set("audit", data.get("audit"));
            rowEntity.set("auditid", data.get("audit_id"));
            rowEntity.set("billstatus", data.get("billstatus"));
            rowEntity.set("dealer", data.get("dealer"));
            rowEntity.set("approveorg", data.get("approveorg"));
            rowEntity.set("auditdate", data.get("auditdate"));
            List dealerids = (List)data.get("dealerids");
            if (CollectionUtils.isNotEmpty((Collection)dealerids)) {
                rowEntity.set("dealerids", (Object)StringUtils.join((Object[])dealerids.toArray(), (String)","));
            }
            if (data.get("isScheme") != null && ((Boolean)data.get("isScheme")).booleanValue()) {
                schemeRowIndex.add(rowIndex);
            }
        }
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            rowEntity.set("isgroupnode", (Object)Boolean.TRUE);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshEntry();
                break;
            }
            case "btn_taskurge": {
                this.openTaskUrgePage();
                break;
            }
        }
    }

    private void openTaskUrgePage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_taskurge");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u50ac\u529e", (String)"BgApplyScheduleQueryListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskUrge_close");
        showParameter.setCloseCallBack(closeCallBack);
        List<DynamicObject> rowEntity = this.getRowEntity();
        if (rowEntity.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5f85\u50ac\u529e\u4efb\u52a1\u3002", (String)"BgApplyScheduleQueryListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setCustomParam("rowEntity", (Object)SerializationUtils.toJsonString(rowEntity));
        showParameter.setCustomParam(MODEL, this.getValue(MODEL, "id"));
        showParameter.setCustomParam(YERA_KEY, this.getValue(YERA_KEY, "id"));
        showParameter.setCustomParam(VERSION_KEY, this.getValue(YERA_KEY, "id"));
        showParameter.setCustomParam(DATATYPE_KEY, this.getValue(DATATYPE_KEY, "id"));
        this.getView().showForm(showParameter);
    }

    private List<DynamicObject> getRowEntity() {
        ArrayList<DynamicObject> rowEntity = new ArrayList<DynamicObject>();
        if (this.getModel().getEntryEntity("treeentryentity") != null) {
            for (DynamicObject dynamicObject : this.getModel().getEntryEntity("treeentryentity")) {
                if (!StringUtils.isNotEmpty((String)dynamicObject.getString("dealerids"))) continue;
                rowEntity.add(dynamicObject);
            }
        }
        return rowEntity;
    }

    private TreeNode getSchemeOrgTree() {
        Long rootId = GlobalIdUtil.genGlobalLongId();
        TreeNode rootNode = new TreeNode("0", rootId.toString(), ResManager.loadKDString((String)"\u6839", (String)"BgBillTreeTypeEnum_2", (String)"epm-eb-common", (Object[])new Object[0]));
        Map<Long, TreeNode> schemeOrgMap = this.creatLeftTreeData();
        if (schemeOrgMap == null || schemeOrgMap.size() == 0) {
            return rootNode;
        }
        Map<String, String> schemeIdNameMap = this.getSchemeIdNameMap();
        for (Map.Entry<Long, TreeNode> longTreeNodeEntry : schemeOrgMap.entrySet()) {
            Long key = longTreeNodeEntry.getKey();
            TreeNode treeNode = longTreeNodeEntry.getValue();
            treeNode.setId(key.toString());
            if (schemeIdNameMap != null) {
                treeNode.setText(schemeIdNameMap.get(key.toString()));
            }
            treeNode.setParentid(rootId.toString());
            HashMap<String, Boolean> data = new HashMap<String, Boolean>(16);
            data.put("isScheme", Boolean.TRUE);
            treeNode.setData(data);
            this.resetOrgId(treeNode, key);
            List children = treeNode.getChildren();
            if (children != null && children.size() != 0) {
                for (TreeNode child : children) {
                    child.setParentid(key.toString());
                }
            }
            rootNode.addChild(treeNode);
        }
        this.setBillDataToNodeData(rootNode);
        return rootNode;
    }

    private Map<String, String> getSchemeIdNameMap() {
        String cacheSchemeIdNameMap = this.getPageCache().get("schemeIdNameMap");
        Map schemeIdNameMap = null;
        if (cacheSchemeIdNameMap != null) {
            schemeIdNameMap = (Map)SerializationUtils.fromJsonString((String)cacheSchemeIdNameMap, HashMap.class);
        }
        return schemeIdNameMap;
    }

    private Map<Long, TreeNode> creatLeftTreeData() {
        Map noAdminMap = BgApplyBillUtils.getInstance().getNoAdminMap(this.getModelId());
        DynamicObjectCollection dynamicObjects = this.getRecords();
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return null;
        }
        Set<Long> adminSchemes = this.getHasAdminSchemes(dynamicObjects, noAdminMap);
        if (adminSchemes.size() == 0) {
            return null;
        }
        DynamicObjectCollection proOrgobjects = ReportSchemeService.getInstance().queryRecordBySchemeIds(IDUtils.toLongs(adminSchemes));
        if (proOrgobjects == null) {
            return null;
        }
        Map<Long, Set<Long>> schemeOrgMap = this.getSchemeOrgMap(proOrgobjects, noAdminMap);
        if (schemeOrgMap.size() == 0) {
            return null;
        }
        Map<Long, TreeNode> schemeOrgTree = this.getOrgTree(schemeOrgMap);
        HashMap<Long, TreeNode> schemeOrgTreeMap = new HashMap<Long, TreeNode>(16);
        for (Long schemeId : adminSchemes) {
            if (schemeOrgTree.get(schemeId) == null) continue;
            schemeOrgTreeMap.put(schemeId, schemeOrgTree.get(schemeId));
        }
        return schemeOrgTreeMap;
    }

    private Map<Long, TreeNode> getOrgTree(Map<Long, Set<Long>> schemeOrgMap) {
        BgApplyBillUtils instance = BgApplyBillUtils.getInstance();
        Long modelId = this.getModelId();
        HashMap<Long, TreeNode> schemeOrgTree = new HashMap<Long, TreeNode>(16);
        for (Map.Entry<Long, Set<Long>> entry : schemeOrgMap.entrySet()) {
            Long scheme = entry.getKey();
            Set<Long> orgIds = entry.getValue();
            if (CollectionUtils.isEmpty(orgIds)) continue;
            Long schemeOrgViewId = ReportSchemeService.getInstance().getSchemeOrgViewId(scheme);
            TreeNode orgTreeNode = instance.buildOrgTreeByFilters(modelId, schemeOrgViewId, orgIds, null);
            schemeOrgTree.put(scheme, orgTreeNode);
        }
        return schemeOrgTree;
    }

    private void resetOrgId(TreeNode rootNode, Long schemeId) {
        List children = rootNode.getChildren();
        if (children != null) {
            for (TreeNode node : children) {
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                data.put("schemeId", schemeId);
                data.put("orgId", node.getId());
                data.put("isScheme", Boolean.FALSE);
                node.setData(data);
                Long id = GlobalIdUtil.genGlobalLongId();
                node.setId(id.toString());
                node.setParentid(rootNode.getId());
                this.resetOrgId(node, schemeId);
            }
        }
    }

    private void setApproveBillInfo(String key, Map<String, Object> data, Map<String, DynamicObject> bills, Map<String, List<Long>> dealerIdsMap) {
        if (bills.get(key) != null) {
            if (CollectionUtils.isNotEmpty((Collection)dealerIdsMap.get(bills.get(key).getString("id")))) {
                data.put("dealerids", dealerIdsMap.get(bills.get(key).getString("id")));
            }
            data.put("audit", bills.get(key).getString("billno"));
            data.put("audit_id", bills.get(key).getLong("id"));
            data.put("approveorg", bills.get(key).getString("approveorg"));
            data.put("dealer", bills.get(key).getString("dealer"));
            data.put("sourcebillno", bills.get(key).getString("sourcebillno"));
            data.put("auditdate", bills.get(key).getDate("auditdate"));
            data.put("billstatus", bills.get(key).getString("billstatus"));
        }
    }

    private Map<String, DynamicObject> getBillData() {
        String selectFiled1;
        DynamicObjectCollection list1;
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        String selectFiled = "id,billnumber,billtype,billstatus,applyscheme,org,modifier,modifydate,auditdate";
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId()).and(new QFilter(YERA_KEY, "=", this.getValue(YERA_KEY, "id"))).and(new QFilter(VERSION_KEY, "=", this.getValue(VERSION_KEY, "id"))).and(new QFilter(DATATYPE_KEY, "=", this.getValue(DATATYPE_KEY, "id")));
        DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_bgapplybill", (String)selectFiled, (QFilter[])new QFilter[]{qFilter});
        if (list != null) {
            for (DynamicObject dynamicObject : list) {
                map.put(dynamicObject.getString("applyscheme") + "_" + dynamicObject.getString("org") + "_" + dynamicObject.getString("billtype"), dynamicObject);
            }
        }
        if ((list1 = QueryServiceHelper.query((String)"eb_centralappbill", (String)(selectFiled1 = "id,billno,billstatus,reportscheme,reportentity,dealer,modifier.name,auditdate,sourcebillno,approveorg,model.id"), (QFilter[])new QFilter[]{qFilter.and(new QFilter("billstatus", "!=", (Object)"F"))})) != null) {
            HashSet<String> pkIds = new HashSet<String>(16);
            HashMap<String, DynamicObject> entities = new HashMap<String, DynamicObject>(16);
            for (DynamicObject dynamicObject : list1) {
                pkIds.add(dynamicObject.getString("id"));
                entities.put(dynamicObject.getString("id"), dynamicObject);
            }
            HashMap<String, List> dealerIdsMap = new HashMap<String, List>(16);
            Map<String, Map<String, Object>> entityInfos = this.getEntityInfos(pkIds);
            Map status = WorkflowServiceHelper.getBizProcessStatus((String[])pkIds.toArray(new String[0]));
            for (Map.Entry<String, DynamicObject> entry : entities.entrySet()) {
                List dealer;
                Set<String> approveOrgList;
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                String key = (String)entry.getKey();
                Map<String, Object> entryInfo = entityInfos.get(key);
                Object sumbillnoList = entryInfo.get("sumbillno");
                if (sumbillnoList != null && CollectionUtils.isNotEmpty((Collection)((Set)sumbillnoList))) {
                    dynamicObject.set("sourcebillno", (Object)String.join((CharSequence)"; ", (Set)sumbillnoList));
                    for (Object billNo : (Set)sumbillnoList) {
                        map.put((String)billNo, dynamicObject);
                    }
                } else {
                    Object reportbillnoList = entryInfo.get("reportbillno");
                    if (reportbillnoList != null && CollectionUtils.isNotEmpty((Collection)((Set)reportbillnoList))) {
                        Object billNo;
                        dynamicObject.set("sourcebillno", (Object)String.join((CharSequence)"; ", (Set)reportbillnoList));
                        billNo = ((Set)reportbillnoList).iterator();
                        while (billNo.hasNext()) {
                            String billNo2 = (String)billNo.next();
                            map.put(billNo2, dynamicObject);
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(approveOrgList = this.getApproveOrgStr(entry))) {
                    dynamicObject.set("approveorg", (Object)String.join((CharSequence)"; ", approveOrgList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(dealer = CentralAppBillService.getInstance().getDealer((List)status.get(key), key)))) {
                    dynamicObject.set("dealer", (Object)String.join((CharSequence)"; ", dealer));
                }
                List dealerIds = CentralAppBillService.getInstance().getBillDealerIds((List)status.get(key), key);
                dealerIdsMap.put(key, dealerIds);
            }
            this.getView().getPageCache().put("dealerIds", SerializationUtils.toJsonString(dealerIdsMap));
        }
        return map;
    }

    private Set<String> getApproveOrgStr(Map.Entry<String, DynamicObject> rowEntry) {
        Map approvePlanInfo;
        HashSet<String> approveOrg = new HashSet<String>(16);
        HashSet<String> approvePlans = new HashSet<String>();
        this.getPlansInWorkFlow(rowEntry.getKey(), rowEntry.getValue(), approvePlans);
        if (approvePlans.size() > 0 && (approvePlanInfo = CentralApprovePlanService.getInstance().getApprovePlanInfoByNumbers(approvePlans, Long.valueOf(rowEntry.getValue().getLong("model.id")))) != null && approvePlanInfo.size() != 0) {
            for (Map object : approvePlanInfo.values()) {
                if (((Boolean)object.get("centralizedstatus")).booleanValue()) {
                    approveOrg.add((String)object.get("centralizeApproveOrgName"));
                    continue;
                }
                approveOrg.add((String)object.get("approveSchemeName"));
            }
        }
        return approveOrg;
    }

    private boolean getPlansInWorkFlow(String businessKey, DynamicObject approveBill, Set<String> plans) {
        boolean adminPerm = false;
        List nextNode = WorkflowServiceHelper.getNextUserTaskNodeByBusinessKey((String)businessKey);
        if (nextNode == null || nextNode.size() == 0) {
            return false;
        }
        FlowElement flowElement = (FlowElement)((Map)nextNode.get(0)).get("nextNode");
        if (flowElement == null) {
            return false;
        }
        FlowElementsContainer parentContainer = flowElement.getParentContainer();
        List variables = ((Process)parentContainer).getVariables();
        Set nodeIds = CentralAppBillService.getInstance().getCurrentNodeNameOrId(null, businessKey, null, false);
        if (nodeIds == null || nodeIds.size() == 0) {
            if (!this.isModelAdmin(approveBill)) {
                return false;
            }
            List incomingFlows = null;
            incomingFlows = flowElement instanceof AuditTask ? ((AuditTask)flowElement).getIncomingFlows() : ((EndEvent)flowElement).getIncomingFlows();
            for (SequenceFlow incomingFlow : incomingFlows) {
                FlowElement sourceFlowElement = incomingFlow.getSourceFlowElement();
                String number = sourceFlowElement.getNumber();
                plans.addAll(this.getPlansInVariable(number, variables));
            }
            adminPerm = true;
        } else {
            for (String nodeId : nodeIds) {
                String[] node = nodeId.split("_");
                String nodeNum = node[node.length - 1];
                plans.addAll(this.getPlansInVariable(nodeNum, variables));
            }
        }
        return adminPerm;
    }

    private Set<String> getPlansInVariable(String number, List<Variable> variables) {
        HashSet<String> retPlans = new HashSet<String>(16);
        Object planObj = null;
        for (Variable variable : variables) {
            if (!number.equals(variable.getName())) continue;
            planObj = variable.getDefaultValue();
            break;
        }
        if (planObj != null) {
            retPlans.addAll(Arrays.asList(planObj.toString().split(",")));
        }
        return retPlans;
    }

    private boolean isModelAdmin(DynamicObject entry) {
        Long modelId = entry != null ? Long.valueOf(entry.getLong("model.id")) : this.getModelId();
        return CentralAppBillService.getInstance().isModelAdmin(modelId);
    }

    private Map<String, Map<String, Object>> getEntityInfos(Set<String> pkIds) {
        Set ids = pkIds.stream().map(Long::parseLong).collect(Collectors.toSet());
        List approveBills = ApproveBillUtil.getInstance().getApproveBills(new QFilter("id", "in", ids));
        return CentralAppBillService.getInstance().getCentralAppBillShowText(approveBills);
    }

    private Map<Long, Set<Long>> getSchemeOrgMap(DynamicObjectCollection proOrgobjects, Map<Long, Set<Long>> noAdminMap) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Set hasPermTemplateIds = BgApplyTempHelper.getInstance().getAdminApplyTemplate(modelId);
        HashMap<Long, Set<Long>> schemeOrgMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Long> orgOrgCache = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : proOrgobjects) {
            Long scheme = dynamicObject.getLong("scheme");
            Long orgViewId = dynamicObject.getLong("scheme.orgview");
            Long applyTemplate = dynamicObject.getLong("applytemplate");
            if (!hasPermTemplateIds.contains(applyTemplate)) continue;
            Long orgId = dynamicObject.getLong("org");
            String orgnumber = dynamicObject.getString("org.number");
            int orgrange = dynamicObject.getInt("orgrange");
            List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgnumber, orgrange);
            String schemeBizMap = this.getPageCache().get("schemeBizMap");
            Map schBizMap = new HashMap(16);
            if (schemeBizMap != null) {
                schBizMap = (Map)SerializationUtils.fromJsonString((String)schemeBizMap, HashMap.class);
            }
            for (Member member : members) {
                orgOrgCache.put(member.getId(), orgId);
                if (noAdminMap != null && noAdminMap.get(IDUtils.toLong(schBizMap.get(scheme.toString()))) != null && noAdminMap.get(IDUtils.toLong(schBizMap.get(scheme.toString()))).contains(member.getId())) continue;
                schemeOrgMap.computeIfAbsent(scheme, k -> new HashSet(16));
                Set set = (Set)schemeOrgMap.get(scheme);
                set.add(member.getId());
                schemeOrgMap.put(scheme, set);
            }
        }
        this.getPageCache().put("orgOrgCache", SerializationUtils.toJsonString(orgOrgCache));
        return schemeOrgMap;
    }

    private Set<Long> getHasAdminSchemes(DynamicObjectCollection dynamicObjects, Map<Long, Set<Long>> noAdminMap) {
        HashMap<Long, Long> schemeBizMap = new HashMap<Long, Long>(16);
        HashMap<Long, String> schemeIdNameMap = new HashMap<Long, String>(16);
        HashSet<Long> schemeSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long year = dynamicObject.getLong(YERA_KEY);
            Long version = dynamicObject.getLong(VERSION_KEY);
            Long datatype = dynamicObject.getLong(DATATYPE_KEY);
            String yearName = dynamicObject.getString("year.name");
            String versionName = dynamicObject.getString("version.name");
            String datatypeName = dynamicObject.getString("datatype.name");
            Long biz = dynamicObject.getLong("bizrange");
            if (noAdminMap != null && noAdminMap.get(biz) != null && (noAdminMap.get(biz).contains(version) || noAdminMap.get(biz).contains(datatype))) continue;
            String key = datatype + "_" + year + "_" + version;
            schemeSet.add(dynamicObject.getLong("scheme"));
            schemeBizMap.put(dynamicObject.getLong("scheme"), biz);
            schemeIdNameMap.put(dynamicObject.getLong("scheme"), dynamicObject.getString("scheme.name"));
        }
        this.getPageCache().put("schemeSet", SerializationUtils.toJsonString(schemeSet));
        this.getPageCache().put("schemeBizMap", SerializationUtils.toJsonString(schemeBizMap));
        this.getPageCache().put("schemeIdNameMap", SerializationUtils.toJsonString(schemeIdNameMap));
        return schemeSet;
    }

    private DynamicObjectCollection getRecords() {
        Long yearId = (Long)this.getValue(YERA_KEY, "id");
        Long versionId = (Long)this.getValue(VERSION_KEY, "id");
        Long datatypeId = (Long)this.getValue(DATATYPE_KEY, "id");
        if (yearId == null || versionId == null || datatypeId == null) {
            return null;
        }
        DynamicObjectCollection dynamicObjects = ReportSchemeAssignService.getInstance().querySchemesGroup(yearId, versionId, datatypeId, this.getModelId());
        return dynamicObjects;
    }

    public Long getModelId() {
        Long modelId = (Long)this.getValue(MODEL, "id");
        if (modelId != null && modelId != 0L) {
            return modelId;
        }
        return 0L;
    }
}

