/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;

public class ApproveBillListManagePlugin
extends AbstractListPlugin {
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<Long> approveBillIds = new HashSet<Long>(16);
        selectedRows.forEach(e -> approveBillIds.add(IDUtils.toLong((Object)e.getPrimaryKeyValue())));
        switch (itemKey) {
            case "btn_submit": {
                this.doSubmit(approveBillIds);
                break;
            }
            case "btn_cancel": {
                this.doUnSubmit(approveBillIds);
                break;
            }
        }
    }

    private void doSubmit(Set<Long> approveBillIds) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("fromApprove", "true");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"eb_approvebill", (Object[])approveBillIds.toArray(), (OperateOption)option);
        if (!operationResult.isSuccess()) {
            String errorMsg = this.getErrorMsg(operationResult);
            throw new KDBizException(errorMsg);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"BgApplybillListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void doUnSubmit(Set<Long> approveBillIds) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unsubmit01", (String)"eb_approvebill", (Object[])approveBillIds.toArray(), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            String errorMsg = this.getErrorMsg(operationResult);
            throw new KDBizException(errorMsg);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"BgApplybillListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private String getErrorMsg(OperationResult operationResult) {
        List errorInfoList;
        List validateResults;
        String errorMsg = operationResult.getMessage();
        ValidateResultCollection resultCollection = operationResult.getValidateResult();
        if (resultCollection != null && CollectionUtils.isNotEmpty((Collection)(validateResults = resultCollection.getValidateErrors())) && CollectionUtils.isNotEmpty((Collection)(errorInfoList = ((ValidateResult)validateResults.get(0)).getAllErrorInfo()))) {
            errorMsg = ((OperateErrorInfo)errorInfoList.get(0)).getMessage();
        }
        return errorMsg;
    }

    public void setFilter(SetFilterEvent e) {
        Long modelId = this.getModelId();
        boolean isModelManage = MemberPermHelper.getLimitedModelListByUser().contains(modelId);
        if (isModelManage) {
            return;
        }
        HashSet permOrgIds = new HashSet(16);
        Set<String> bizModelOrgGroup = this.getBizModelOrgGroup(modelId);
        if (CollectionUtils.isNotEmpty(bizModelOrgGroup)) {
            for (String bizModelOrg : bizModelOrgGroup) {
                String[] bizModelOrgArr = bizModelOrg.split("!");
                Long bizModelId = IDUtils.toLong((Object)bizModelOrgArr[0]);
                Long orgViewId = IDUtils.toLong((Object)bizModelOrgArr[1]);
                Set permIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)orgViewId, (boolean)true);
                if (!CollectionUtils.isNotEmpty((Collection)permIds)) continue;
                permOrgIds.addAll(permIds);
            }
        }
        QFilter qFilter = new QFilter("eborgid.id", "in", permOrgIds);
        List dataPermQFilters = e.getDataPermQFilters();
        e.setDataPermQFilters(new ArrayList(16));
        if (CollectionUtils.isNotEmpty((Collection)dataPermQFilters)) {
            QFilter dataFilter = null;
            for (QFilter dataPermQFilter : dataPermQFilters) {
                if (dataPermQFilter == null) continue;
                if (dataFilter == null) {
                    dataFilter = new QFilter(dataPermQFilter.getProperty(), dataPermQFilter.getCP(), dataPermQFilter.getValue());
                }
                List qFilterNestList = dataPermQFilter.getNests(true);
                for (QFilter.QFilterNest qFilterNest : qFilterNestList) {
                    String property = qFilterNest.getFilter().getProperty();
                    if ("modelid".equals(property)) continue;
                    if (qFilterNest.isAnd()) {
                        dataFilter.and(qFilterNest.getFilter());
                        continue;
                    }
                    dataFilter.or(qFilterNest.getFilter());
                }
            }
            if (dataFilter != null) {
                qFilter.and(dataFilter);
            }
        }
        e.getQFilters().add(qFilter);
    }

    public Long getModelId() {
        String modelCache = this.getPageCache().get("modelId");
        if (StringUtils.isEmpty((String)modelCache)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRow row = billlist.getCurrentSelectedRowInfo();
            if (row != null) {
                DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (DynamicObjectType)((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_approvebill").getDataEntityType()));
                return load.getLong("modelid.id");
            }
            return 0L;
        }
        return ConvertUtils.toLong((Object)modelCache);
    }

    private Set<String> getBizModelOrgGroup(Long modelId) {
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and(new QFilter("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber()));
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,bizmodelid.id,orgviewid.id,eborgid.id", (QFilter[])qFilter.toArray());
        HashSet<String> bizModelOrgGroup = new HashSet<String>(16);
        for (DynamicObject approveBill : approveBills) {
            Long bizModelId = approveBill.getLong("bizmodelid.id");
            Long orgViewId = approveBill.getLong("orgviewid.id");
            bizModelOrgGroup.add(bizModelId + "!" + orgViewId);
        }
        return bizModelOrgGroup;
    }
}

