/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.decompose.entity.AdjustParam;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.formplugin.adjustrecord.AdjustRecordHelper;
import kd.epm.eb.formplugin.reportscheme.command.IReportBySchemePlugin;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;

public class CommitCancel {
    private IFormView formView = null;
    private IFormPlugin formPlugin = null;

    public CommitCancel(IFormPlugin formPlugin) {
        this.formPlugin = formPlugin;
        this.formView = formPlugin instanceof IReportBySchemePlugin ? ((IReportBySchemePlugin)formPlugin).getView() : ((IBgTaskExecutePlugin)formPlugin).getView();
    }

    public void cancelCommit(ApproveBillSubMitInfo bgmBill) {
        Set approveBillIds = ApproveBillCommon.getApproveBillIds((Collection)bgmBill.getRptTemps());
        if (approveBillIds != null && approveBillIds.size() > 0 && approveBillIds.parallelStream().filter(e -> e.compareTo(0L) > 0).count() > 0L) {
            Set<Long> hasAdjs;
            if (this.checkParentSubmit(approveBillIds, bgmBill).booleanValue()) {
                ((IBgTaskExecutePlugin)this.formPlugin).getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u7ecf\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u6216\u53cd\u5ba1\u6838\u3002", (String)"ApproveBillStatusCheck_02", (String)"epm-eb-business", (Object[])new Object[0]));
                return;
            }
            ApproveBillSubMitDim submitDims = bgmBill.getSubmitDims();
            AdjustParam adjustParam = CommonUtils.getAdjustParam((Long)submitDims.getModelId());
            if (!adjustParam.isCanunsubmit() && !(hasAdjs = AdjustRecordHelper.hasAdjustRecords(submitDims.getModelId(), approveBillIds)).isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u4ee5\u4e0b\u62a5\u8868\u5df2\u88ab\u5ba1\u6279\u8c03\u6574\uff0c\u64a4\u9500\u5931\u8d25\u3002", (String)"CommitCancel_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                int index = 1;
                for (ApproveBillRptTemp rptTemp : bgmBill.getRptTemps()) {
                    if (index != 1) {
                        stringBuilder.append("\uff1b");
                    }
                    stringBuilder.append(String.format("%s.%s", index++, rptTemp.getTempName()));
                }
                stringBuilder.append("\u3002");
                ((IBgTaskExecutePlugin)this.formPlugin).getView().showTipNotification(stringBuilder.toString());
                return;
            }
            this.doUnsubmit(bgmBill, approveBillIds.toArray());
        } else {
            ((IBgTaskExecutePlugin)this.formPlugin).getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u64a4\u9500\u63d0\u4ea4\u7684\u5355\u636e\u3002", (String)"CommitCancel_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Boolean checkParentSubmit(Set<Long> approveBillIds, ApproveBillSubMitInfo bgmBill) {
        ApproveBillSubMitDim submitDims = bgmBill.getSubmitDims();
        Long modelId = submitDims.getModelId();
        Set tempIds = submitDims.getTempIds();
        Long viewId = submitDims.getViewId();
        HashMap<String, Long> dimMembers = new HashMap<String, Long>(16);
        dimMembers.put(SysDimensionEnum.BudgetPeriod.getNumber(), submitDims.getYearPeriodId());
        dimMembers.put(SysDimensionEnum.Version.getNumber(), submitDims.getVersionId());
        dimMembers.put(SysDimensionEnum.DataType.getNumber(), submitDims.getDataTypeId());
        dimMembers.put(SysDimensionEnum.Entity.getNumber(), submitDims.getOrgId());
        return ApproveUtils.getInstance().isParentEntityInApprove(dimMembers, new ArrayList(tempIds), modelId, viewId) != null;
    }

    private void doUnsubmit(ApproveBillSubMitInfo bgmBill, Object[] approveBills) {
        OperationResult operationResult;
        if (approveBills == null || approveBills.length == 0) {
            return;
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("currbizappid", "bgm");
        if (!this.isApproveBill()) {
            op.setVariableValue("fromreport", "fromreport");
        }
        if ((operationResult = OperationServiceHelper.executeOperate((String)"unsubmit01", (String)"eb_approvebill", (Object[])approveBills, (OperateOption)op)).isSuccess()) {
            this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"CommitCommand_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.formView.showOperationResult(operationResult);
        }
    }

    private boolean isApproveBill() {
        Map customParams = this.formView.getFormShowParameter().getCustomParams();
        return customParams.get("approveBill") != null && ("1".equals(customParams.get("approveBill")) || "2".equals(customParams.get("approveBill")));
    }
}

