/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.business.adjust.AdjustBillValidator;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.validator.AbstractAdjustValidator;
import kd.epm.eb.business.adjust.validator.IAdjustValidatorSource;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.ApproveBill.BasicInfoHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.formplugin.billimpexp.star.BillExportStart;
import kd.epm.eb.formplugin.billimpexp.util.BillImpExpStarFactory;
import kd.epm.eb.formplugin.custominterface.EpmCustomInterface;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public abstract class BaseEbAdjustBillEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
CellClickListener,
HyperLinkClickListener,
IAdjustValidatorSource {
    protected static final Log log = LogFactory.getLog(BaseEbAdjustBillEditPlugin.class);
    protected static final String BTN_ADDROW_FORM = "btn_addrow_form";
    private static final int ACCOUNT_MEMBER_NULL = -2;
    private static final String BTN_SUBMIT = "btn_submit";
    private static final String PROJECT_IMPORT = "projectimport";
    private static final String PROJECT_EXPORT = "projectexport";
    protected static final String ADJ_DETAIL_ENTITY = "adjdetailentity";
    protected static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_IMPORT = "btn_import";
    private static final String ENTRY_EXPORT = "btn_export";
    private static final String PERIODS_INFO_CACHE = "periodsInfoCache";
    protected static final String CUSTOM_DIMS_INFO_CACHE = "customDimsInfoCache";
    protected static final String NEED_RESPONSE_THE_CHANGED_CACHE = "needResponseTheChangedCache";
    private static final String ROW_NUM_CHANGE_CACHE = "rowNumChangedCache";
    protected static final String COMPLETED_ROW_DIMS_CACHE = "completedRowDimsCache";
    protected List<String> entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)false);
    protected String[] periodGroupKeys = AbstractAdjustValidator.getPeriodGroupKeys((boolean)false);
    protected String periodKey = "period";
    private static final int PERIOD_GROUP_COUNTS = 19;
    private static final String ORDER_SIGN_KEY = "ordersign";
    private static final String ADJUST_CHECK = "adjustcheck";
    protected static final String IS_SHOW_BUDGET_BALANCE = "isShowBudgetBalance";
    protected static final String IS_SHOW_LIMIT_BALANCE = "isShowLimitBalance";
    protected static final String IS_EXIST_CONTROL_DIM = "isExistControlDim";
    protected int needUpdateViewCount = 0;
    private int needChangePropertyCount = 0;
    protected boolean isCopy;
    private IModelCacheHelper modelCacheHelper = null;

    public boolean isExpenseBudget() {
        return AdjustUtil.isEB((IFormView)this.getView(), (long)this.getModelId());
    }

    public abstract void setF7Visible();

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        if (ApplicationTypeEnum.EB.getIndex().equals(((DynamicObject)this.getModel().getValue("model")).getString("reporttype"))) {
            this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)true);
            this.periodGroupKeys = AbstractAdjustValidator.getPeriodGroupKeys((boolean)true);
            this.periodKey = "period";
        } else {
            this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)false);
            this.periodGroupKeys = AbstractAdjustValidator.getPeriodGroupKeys((boolean)false);
            this.periodKey = "budgetperiod";
        }
        this.cacheCustomDimJson();
        this.setDefaultData();
        this.setBudgetPeriodsForCopy();
        String sourceApplier = (String)this.getView().getFormShowParameter().getCustomParam("applier");
        if (!this.getUserId().equals(IDUtils.toLong((Object)sourceApplier))) {
            this.updateUserInfoObject();
        }
        this.updateUserInfoShow();
        this.adjustPeriodGroup(false);
        this.backFillData(false);
        this.changeBudgetData(-1);
        this.setFinalData();
        this.checkAllAdjDataStyle();
        this.setF7Visible();
        this.setResponseTheChanged(false);
        this.setWorkFlowVisible();
        this.cachePeriodAdjustDataMap();
    }

    private void cachePeriodAdjustDataMap() {
        String needUpdateAdjustCache = this.getPageCache().get("needUpdateAdjustCache");
        if (StringUtils.isNotEmpty((String)needUpdateAdjustCache)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection periodList = dataEntity.getDynamicObjectCollection(this.getPeriodNameForHead());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap<Long, Map> periodAdjustCacheMap = new HashMap<Long, Map>(16);
        for (int j = 1; j <= periodList.size(); ++j) {
            DynamicObject period = (DynamicObject)periodList.get(j - 1);
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject rowObject = (DynamicObject)entryEntity.get(i);
                BigDecimal adjustData = rowObject.getBigDecimal("adjadjustdata" + j);
                if (adjustData.compareTo(BigDecimal.ZERO) == 0) continue;
                Map rowData = periodAdjustCacheMap.computeIfAbsent(period.getLong("fbasedataid_id"), v -> new HashMap(16));
                rowData.put(i, adjustData);
            }
        }
        this.getPageCache().put("periodAdjustCache", SerializationUtils.serializeToBase64(periodAdjustCacheMap));
    }

    private void setFinalData() {
        IDataModel dataModel = this.getModel();
        int periodSize = ((DynamicObjectCollection)dataModel.getValue(this.getPeriodNameForHead())).size();
        if (periodSize == 0) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 1; i <= periodSize; ++i) {
            for (int j = 0; j < entryEntity.size(); ++j) {
                BigDecimal budgetData = (BigDecimal)dataModel.getValue("adjbudgetdata" + i, j);
                BigDecimal adjustData = (BigDecimal)dataModel.getValue("adjadjustdata" + i, j);
                dataModel.setValue("adjfinaldata" + i, (Object)budgetData.add(adjustData), j);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.addModel();
        this.cacheCustomDimJson();
        this.setDefaultData();
        this.updateUserInfoObject();
        this.updateUserInfoShow();
        this.setUserSelect();
        this.setAdjustRuleMember(this.getModelId());
        this.setF7Visible();
        this.buildCustomDimInfo(-1);
        this.setWorkFlowVisible();
    }

    private void setWorkFlowVisible() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        SplitContainer splitcontainerap = (SplitContainer)this.getControl("splitcontainerap");
        switch (billStatus) {
            case "A": 
            case "H": 
            case "I": {
                splitcontainerap.hidePanel(SplitDirection.right, true);
                break;
            }
            case "B": 
            case "C": 
            case "D": 
            case "E": {
                splitcontainerap.hidePanel(SplitDirection.right, false);
                break;
            }
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        if (wfApps.contains(appId)) {
            splitcontainerap.hidePanel(SplitDirection.right, true);
        }
    }

    private void addModel() {
        Object bizModelId;
        Object modelId = this.getView().getFormShowParameter().getCustomParam("model");
        if (modelId != null) {
            this.getModel().setValue("model", modelId);
        }
        if ((bizModelId = this.getView().getFormShowParameter().getCustomParam("bizmodel")) != null) {
            this.getModel().setValue("bizmodel", bizModelId);
        }
        this.setDefDataTypeMember(IDUtils.toLong((Object)modelId));
        this.setDefChangeTypeMember(IDUtils.toLong((Object)modelId));
    }

    public void setAdjustRuleMember(Long modelId) {
    }

    public void setBudgetPeriodsForCopy() {
    }

    public void setDefaultData() {
        Long userId = UserUtils.getUserId();
        IDataModel dataModel = this.getModel();
        dataModel.setValue("applier", (Object)userId);
        dataModel.setValue("billno", null);
        dataModel.setValue("billstatus", (Object)"A");
        dataModel.setValue("applydate", (Object)TimeServiceHelper.now());
        boolean isEbParam = this.isExpenseBudget() || AdjustUtil.isBGModel((long)this.getModelId());
        boolean isShowBudgetBalance = ControlParamsSettingUtil.isShowBudgetBalance((Long)this.getModelId(), (String)this.getFormType(), (boolean)isEbParam);
        this.getPageCache().put(IS_SHOW_BUDGET_BALANCE, isShowBudgetBalance ? "true" : "false");
        boolean isShowLimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)this.getModelId(), (String)this.getFormType(), (boolean)isEbParam);
        this.getPageCache().put(IS_SHOW_LIMIT_BALANCE, isShowLimitBalance ? "true" : "false");
        if ((isShowBudgetBalance || isShowLimitBalance) && !this.isExpenseBudget()) {
            this.putControlDimCache();
        }
    }

    public abstract void setDefDataTypeMember(Long var1);

    public abstract void setDefChangeTypeMember(Long var1);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LogStats stats = new LogStats("adjustBill-afterBindData-log:");
        stats.addInfo("adjustBill-afterBindData-start.");
        this.setResponseTheChanged(false);
        this.checkRowsCompleted(ENTRY_ENTITY);
        stats.add("checkRowsCompleted end.");
        this.changeItemStatusByFormType();
        this.setResponseTheChanged(true);
        this.setF7Visible();
        this.buildCustomDimInfo(-1);
        stats.add("buildCustomDimInfo end.");
        this.cacheCustomDimJson();
        this.setWorkFlowVisible();
        String dataChange = this.getPageCache().get("dataChange");
        if (StringUtils.equals((String)"false", (String)dataChange)) {
            this.getModel().setDataChanged(false);
            this.getPageCache().remove("dataChange");
        }
        stats.addInfo("adjustBill-afterBindData-end.");
        log.info(stats.toString());
    }

    public void setEntryEntityNewAddUserDefinedDimNoneMember() {
        boolean isSaveStatus;
        String billStatus = (String)this.getModel().getValue("billstatus");
        boolean bl = isSaveStatus = AdjustBillStateEnum.SAVE.getShortNumber().equals(billStatus) || AdjustBillStateEnum.NOPASS.getShortNumber().equals(billStatus);
        if (isSaveStatus) {
            return;
        }
        IFormView formView = this.getView();
        DynamicInfoCollection customDimInfo = this.getCustomDimsInfoCache();
        if (!customDimInfo.isEmpty()) {
            IDataModel dataModel = this.getModel();
            boolean updateEntryEntity = false;
            int rowCounts = this.getModel().getEntryRowCount(ENTRY_ENTITY);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
            DynamicObjectCollection adjustRuleInfo = this.getAdjustRuleInfo();
            for (DynamicInfoCollection.InfoObject info : customDimInfo.getValues()) {
                String controlKey = (String)info.getValueByPropName("controlkey");
                String id = (String)info.getValueByPropName("id");
                String defMemberId = (String)info.getValueByPropName("defMemberId");
                for (int i = 0; i < rowCounts; ++i) {
                    String controlKeyValue;
                    Member accountMember;
                    DynamicObject rowObj = (DynamicObject)entryEntity.get(i);
                    Long adjAccountId = rowObj.getLong("adjaccount.id");
                    if (IDUtils.isNull((Long)adjAccountId) || (accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), adjAccountId)) == null) continue;
                    Long datasetId = IDUtils.toLong((Object)accountMember.getDatasetId());
                    List dimensions = modelCacheHelper.getDimensionList(datasetId);
                    ArrayList<String> ids = new ArrayList<String>();
                    for (Dimension dimension : dimensions) {
                        if (dimension.isPreset()) continue;
                        ids.add(String.valueOf(dimension.getId()));
                    }
                    if (!ids.contains(id) || !StringUtils.isEmpty((String)(controlKeyValue = rowObj.getString(controlKey))) || !this.judgeNeedPresetDefined(controlKey, i, adjustRuleInfo)) continue;
                    dataModel.setValue(controlKey, (Object)IDUtils.toLong((Object)defMemberId), i);
                    updateEntryEntity = true;
                }
            }
            if (updateEntryEntity) {
                formView.updateView(ENTRY_ENTITY);
                if (!AdjustBillStateEnum.SAVE.getShortNumber().equals(billStatus)) {
                    this.getModel().setDataChanged(false);
                }
            }
        }
    }

    public DynamicObjectCollection getAdjustRuleInfo() {
        return null;
    }

    public boolean judgeNeedPresetDefined(String propName, int row, DynamicObjectCollection adjustRuleInfo) {
        return true;
    }

    public void changeItemStatusByFormType() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!AdjustBillStateEnum.SAVE.getShortNumber().equals(billStatus) && !AdjustBillStateEnum.NOPASS.getShortNumber().equals(billStatus)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY, "baseinfoap", "accessoryap"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bnt_save", BTN_SUBMIT, "btn_audit", PROJECT_IMPORT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADJUST_CHECK});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_addrow", "btn_delrow", "btn_copy", ENTRY_IMPORT, BTN_ADDROW_FORM});
        }
        if (AdjustBillStateEnum.SUBMIT.getShortNumber().equals(billStatus)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_audit"});
        }
        if (this.isExpenseBudget()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjmetric", "changetype"});
        }
    }

    public final String getFormType() {
        return AbstractAdjustValidator.getFormType((IAdjustValidatorSource)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entry.addCellClickListener((CellClickListener)this);
        entry.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addF7SelectListeners("adjcustomdim1", "adjcustomdim2", "adjcustomdim3", "adjcustomdim4", "adjcustomdim5", "adjcustomdim6", "adjcustomdim7", "adjcustomdim8", "adjcustomdim9", "adjcustomdim10", "adjcustomdim11", "adjcustomdim12", "adjcustomdim13", "adjcustomdim14", "adjcustomdim15", "adjcustomdim16", "adjcustomdim17", "adjcustomdim18", "adjcustomdim19", "adjcustomdim20", "adjcustomdim21", "adjcustomdim22", "adjcustomdim23", "adjcustomdim24", "adjcustomdim25", "adjcustomdim26", "adjcustomdim27", "adjcustomdim28", "adjcustomdim29", "adjcustomdim30", "adjcustomdim31", "adjcustomdim32", "adjcustomdim33", "adjcustomdim34", "adjcustomdim35", "adjcustomdim36", "adjcustomdim37", "adjcustomdim38", "adjcustomdim39", "adjcustomdim40", "adjcustomdim41", "adjcustomdim42", "adjcustomdim43", "adjcustomdim44", "adjcustomdim45", "adjcustomdim46", "adjcustomdim47", "adjcustomdim48", "adjcustomdim49", "adjcustomdim50", "model", "multperiod", "ChangeType", "Year", "Currency", "Version", "DataType", "adjAccount", "adjEntity", "adjMetric", "budgetperiods", "bizmodel", "adjustrule");
        this.addClickListeners(new String[]{"switchdept"});
    }

    private void addF7SelectListeners(String ... f7Keys) {
        for (String f7Key : f7Keys) {
            BasedataEdit f7 = (BasedataEdit)this.getControl(f7Key);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propKey = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newData = e.getChangeSet()[0].getNewValue();
        int rowNum = e.getChangeSet()[0].getRowIndex();
        switch (propKey) {
            case "adjustrule": {
                if (oldValue != null) {
                    long oldRuleId = ((DynamicObject)oldValue).getLong("id");
                    this.getPageCache().put("oldRuleId", String.valueOf(oldRuleId));
                } else {
                    this.getPageCache().put("oldRuleId", null);
                }
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("adjustrule", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u8c03\u6574\u89c4\u5219\u5c06\u6e05\u7a7a\u5206\u5f55\u884c\u7684\u7ef4\u5ea6\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BaseEbAdjustBillEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                break;
            }
            case "version": 
            case "year": 
            case "currency": {
                DynamicObjectCollection multperiod = (DynamicObjectCollection)this.getModel().getValue("multperiod");
                if ("year".equals(propKey) && multperiod.size() > 0) {
                    this.selectControlVersions();
                }
                if (!this.needResponseTheChanged()) {
                    return;
                }
                this.clearAdjDataWhenDimChanged(-1);
                this.changeBudgetData(-1);
                break;
            }
            case "multperiod": {
                if (this.getModel().getValue("year") != null) {
                    this.selectControlVersions();
                }
                this.getPageCache().put("needUpdateAdjustCache", "false");
                this.adjustPeriodGroup(true);
                this.clearAdjDataWhenDimChanged(-1);
                this.changeBudgetData(-1);
                this.getAdjustValidator("other").checkDimPerm();
                this.backAdjustData();
                this.getPageCache().remove("needUpdateAdjustCache");
                break;
            }
            case "budgetperiods": {
                if (this.getModel().getValue("budgetperiods") == null) {
                    return;
                }
                this.getPageCache().put("needUpdateAdjustCache", "false");
                this.budgetPeriodChange();
                this.getAdjustValidator("other").checkDimPerm();
                this.getPageCache().remove("needUpdateAdjustCache");
                break;
            }
            case "adjaccount": {
                this.checkRowDimSame(e, propKey, rowNum);
                this.checkMetricAndCustomDimAfterSetAccount(e, rowNum);
                break;
            }
            case "adjentity": 
            case "adjmetric": 
            case "adjcustomdim1": 
            case "adjcustomdim2": 
            case "adjcustomdim3": 
            case "adjcustomdim4": 
            case "adjcustomdim5": 
            case "adjcustomdim6": 
            case "adjcustomdim7": 
            case "adjcustomdim8": 
            case "adjcustomdim9": 
            case "adjcustomdim10": 
            case "adjcustomdim11": 
            case "adjcustomdim12": 
            case "adjcustomdim13": 
            case "adjcustomdim14": 
            case "adjcustomdim15": 
            case "adjcustomdim16": 
            case "adjcustomdim17": 
            case "adjcustomdim18": 
            case "adjcustomdim19": 
            case "adjcustomdim20": 
            case "adjcustomdim21": 
            case "adjcustomdim22": 
            case "adjcustomdim23": 
            case "adjcustomdim24": 
            case "adjcustomdim25": 
            case "adjcustomdim26": 
            case "adjcustomdim27": 
            case "adjcustomdim28": 
            case "adjcustomdim29": 
            case "adjcustomdim30": 
            case "adjcustomdim31": 
            case "adjcustomdim32": 
            case "adjcustomdim33": 
            case "adjcustomdim34": 
            case "adjcustomdim35": 
            case "adjcustomdim36": 
            case "adjcustomdim37": 
            case "adjcustomdim38": 
            case "adjcustomdim39": 
            case "adjcustomdim40": 
            case "adjcustomdim41": 
            case "adjcustomdim42": 
            case "adjcustomdim43": 
            case "adjcustomdim44": 
            case "adjcustomdim45": 
            case "adjcustomdim46": 
            case "adjcustomdim47": 
            case "adjcustomdim48": 
            case "adjcustomdim49": 
            case "adjcustomdim50": {
                if ("adjentity".equals(propKey)) {
                    this.checkAccountAfterSetEntity(e, propKey, rowNum);
                }
                this.checkRowDimSame(e, propKey, rowNum);
                break;
            }
            case "adjgroupnum": {
                if (newData == null) break;
                String newGropNum = String.valueOf(newData);
                if (!StringUtils.isNotEmpty((String)(newGropNum = newGropNum.replaceAll("[a-zA-Z0-9]+", "")))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\u53ea\u80fd\u5305\u542b\u6570\u503c\u548c\u5b57\u6bcd\u3002", (String)"BaseEbAdjustBillEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(propKey, null, rowNum);
                break;
            }
            case "bizmodel": {
                this.bizModelChange(oldValue);
                break;
            }
            case "datatype": {
                this.clearAdjDataWhenDimChanged(-1);
                this.changeBudgetData(-1);
                break;
            }
            case "changetype": {
                this.clearAdjDataWhenDimChanged(-1);
                this.changeBudgetData(-1);
                break;
            }
        }
        if (propKey.contains("budgetdata") || propKey.contains("adjustdata")) {
            this.changeFinalData(propKey, rowNum);
        } else if (propKey.contains("adjfinaldata")) {
            this.changeAdjustData(propKey, rowNum);
        } else {
            this.checkGroupMemberPerm(propKey, rowNum);
        }
    }

    private void checkGroupMemberPerm(String propKey, int rowNum) {
        boolean isHeadDimension;
        if ("adjustreason".equals(propKey)) {
            return;
        }
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            return;
        }
        List permControlDims = DimMembPermUtil.getPermControlDim((Long)modelId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Long userId = UserUtils.getUserId();
        ArrayList<String> definedDim = new ArrayList<String>(10);
        ArrayList<String> permControlDim = new ArrayList<String>(10);
        List dimensionList = ModelUtil.isEbOrBgModel((Long)modelId) ? this.getModelCache(modelId).getDimensionList() : this.getModelCache(modelId).getDimensionListByBusModel(this.getBizModelId());
        for (Dimension dimension : dimensionList) {
            if (!dimension.isPreset()) {
                definedDim.add(dimension.getNumber());
            }
            if (!permControlDims.contains(dimension.getNumber())) continue;
            permControlDim.add(dimension.getNumber());
        }
        boolean bl = isHeadDimension = "changetype".equals(propKey) || "datatype".equals(propKey) || "version".equals(propKey);
        if (StringUtils.isNotEmpty((String)propKey)) {
            String currentDimNumber = this.getCurrentDimNumber(propKey);
            if (!permControlDim.contains(currentDimNumber)) {
                return;
            }
            if (!isHeadDimension && !this.entryEntityKeys.contains("adj" + propKey.toLowerCase())) {
                return;
            }
        }
        DimMemberPermChecker permChecker = DimMembPermHelper.getPermChecker((Long)modelId, (Long)this.getBizModelId(), permControlDim, (Long)userId, (DimMembPermType)DimMembPermType.WRITE);
        boolean includeDetail = false;
        for (String dimNum : permControlDim) {
            if (!SysDimensionEnum.Entity.getNumber().equals(dimNum) && !SysDimensionEnum.Account.getNumber().equals(dimNum) && SysDimensionEnum.getEnumByNumber((String)dimNum) != null && (ModelUtil.isEbOrBgModel((Long)modelId) || !SysDimensionEnum.Metric.getNumber().equals(dimNum))) continue;
            includeDetail = true;
            break;
        }
        if (isHeadDimension) {
            if (includeDetail) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>(permControlDim.size());
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String dim : permControlDim) {
                        if (SysDimensionEnum.DataType.getNumber().equals(dim) || SysDimensionEnum.ChangeType.getNumber().equals(dim) || SysDimensionEnum.Version.getNumber().equals(dim)) {
                            Object value = this.getModel().getValue(dim.toLowerCase());
                            if (value == null) continue;
                            MemberItem memberItem = new MemberItem(true, Long.valueOf(((DynamicObject)value).getLong("id")));
                            memberItemMap.put(dim, memberItem);
                            stringBuilder.append(((DynamicObject)value).getString("number")).append(",");
                            continue;
                        }
                        DynamicObject object = null;
                        if (SysDimensionEnum.getEnumByNumber((String)dim) == null) {
                            int index = definedDim.indexOf(dim) + 1;
                            object = dynamicObject.getDynamicObject("adjcustomdim" + index);
                        } else if (SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.Account.getNumber().equals(dim) || SysDimensionEnum.Metric.getNumber().equals(dim)) {
                            object = dynamicObject.getDynamicObject("adj" + dim.toLowerCase());
                        }
                        if (object == null) continue;
                        MemberItem memberItem = new MemberItem(true, Long.valueOf(object.getLong("id")));
                        memberItemMap.put(dim, memberItem);
                        stringBuilder.append(object.getString("number")).append(",");
                    }
                    boolean check = permChecker.check(memberItemMap);
                    for (int j = 1; j < 21; ++j) {
                        this.getView().setEnable(Boolean.valueOf(check), i, new String[]{"adjadjustdata" + j, "adjfinaldata" + j});
                    }
                    if (check) continue;
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408%1\u65e0\u6743\uff0c\u5bf9\u5e94\u6570\u636e\u5df2\u9501\u5b9a\u3002", (String)"BaseEbAdjustBillEditPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[]{stringBuilder.substring(0, stringBuilder.length() - 1)}));
                }
            } else {
                HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>(permControlDim.size());
                StringBuilder stringBuilder = new StringBuilder();
                for (String dim : permControlDim) {
                    Object value;
                    if (!SysDimensionEnum.DataType.getNumber().equals(dim) && !SysDimensionEnum.ChangeType.getNumber().equals(dim) && !SysDimensionEnum.Version.getNumber().equals(dim) || (value = this.getModel().getValue(dim.toLowerCase())) == null) continue;
                    MemberItem memberItem = new MemberItem(true, Long.valueOf(((DynamicObject)value).getLong("id")));
                    memberItemMap.put(dim, memberItem);
                    stringBuilder.append(((DynamicObject)value).getString("number")).append(",");
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                boolean check = permChecker.check(memberItemMap);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    for (int j = 1; j < 21; ++j) {
                        this.getView().setEnable(Boolean.valueOf(check), i, new String[]{"adjadjustdata" + j, "adjfinaldata" + j});
                    }
                }
                if (!check) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408%1\u65e0\u6743\uff0c\u5bf9\u5e94\u6570\u636e\u5df2\u9501\u5b9a\u3002", (String)"BaseEbAdjustBillEditPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[]{stringBuilder.substring(0, stringBuilder.length() - 1)}));
                }
            }
        } else {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowNum);
            HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>(permControlDim.size());
            StringBuilder stringBuilder = new StringBuilder();
            for (String dim : permControlDim) {
                if (SysDimensionEnum.DataType.getNumber().equals(dim) || SysDimensionEnum.ChangeType.getNumber().equals(dim) || SysDimensionEnum.Version.getNumber().equals(dim)) {
                    Object value = this.getModel().getValue(dim.toLowerCase());
                    if (value == null) continue;
                    MemberItem memberItem = new MemberItem(true, Long.valueOf(((DynamicObject)value).getLong("id")));
                    memberItemMap.put(dim, memberItem);
                    stringBuilder.append(((DynamicObject)value).getString("number")).append(",");
                    continue;
                }
                DynamicObject object = null;
                if (SysDimensionEnum.getEnumByNumber((String)dim) == null) {
                    int index = definedDim.indexOf(dim) + 1;
                    object = dynamicObject.getDynamicObject("adjcustomdim" + index);
                } else if (SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.Account.getNumber().equals(dim) || SysDimensionEnum.Metric.getNumber().equals(dim)) {
                    object = dynamicObject.getDynamicObject("adj" + dim.toLowerCase());
                }
                if (object == null) continue;
                MemberItem memberItem = new MemberItem(true, Long.valueOf(object.getLong("id")));
                memberItemMap.put(dim, memberItem);
                stringBuilder.append(object.getString("number")).append(",");
            }
            boolean check = permChecker.check(memberItemMap);
            for (int j = 1; j < 21; ++j) {
                this.getView().setEnable(Boolean.valueOf(check), rowNum, new String[]{"adjadjustdata" + j, "adjfinaldata" + j});
            }
            if (!check) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408%1\u65e0\u6743\uff0c\u5bf9\u5e94\u6570\u636e\u5df2\u9501\u5b9a\u3002", (String)"BaseEbAdjustBillEditPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[]{stringBuilder.substring(0, stringBuilder.length() - 1)}));
            }
        }
    }

    public void checkMetricAndCustomDimAfterSetAccount(PropertyChangedArgs e, int rowNum) {
    }

    public void budgetPeriodChange() {
        DynamicObjectCollection budgetPeriods = (DynamicObjectCollection)this.getModel().getValue("budgetperiods");
        if (budgetPeriods.size() > 19) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e920\u4e2a\u4ee5\u5185\u7684\u671f\u95f4\u3002", (String)"BaseEbAdjustBillEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("budgetperiods", (Object)"");
            this.adjustPeriodGroup(true);
            return;
        }
        this.selectControlVersions();
        this.adjustPeriodGroup(true);
        this.clearAdjDataWhenDimChanged(-1);
        this.changeBudgetData(-1);
        this.buildCustomDimInfo(-1);
        this.backAdjustData();
    }

    private void backAdjustData() {
        String periodAdjustCache = this.getPageCache().get("periodAdjustCache");
        if (StringUtils.isEmpty((String)periodAdjustCache)) {
            return;
        }
        Map periodAdjustMap = (Map)SerializationUtils.deSerializeFromBase64((String)periodAdjustCache);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection(this.getPeriodNameForHead());
        for (int j = 1; j <= dynamicObjectCollection.size(); ++j) {
            DynamicObject object = (DynamicObject)dynamicObjectCollection.get(j - 1);
            Map rowData = (Map)periodAdjustMap.get(object.getLong("fbasedataid_id"));
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (MapUtils.isNotEmpty((Map)rowData)) {
                    BigDecimal bigDecimal = (BigDecimal)rowData.get(i);
                    this.getModel().setValue("adjadjustdata" + j, (Object)bigDecimal, i);
                    continue;
                }
                this.getModel().setValue("adjadjustdata" + j, null, i);
            }
        }
    }

    private void bizModelChange(Object oldValue) {
        if (oldValue != null) {
            this.getPageCache().put("oldBizModel", ((DynamicObject)oldValue).getString("id"));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("bizModelChange", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u6a21\u578b\u5c06\u6e05\u7a7a\u5206\u5f55\u884c\u7684\u7ef4\u5ea6\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BaseEbAdjustBillEditPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    public void checkAccountAfterSetEntity(PropertyChangedArgs e, String propKey, int rowNum) {
    }

    private void checkRowDimSame(PropertyChangedArgs e, String propKey, int rowNum) {
        if (!this.needChangeProperty()) {
            return;
        }
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        this.checkRowsCompleted(ENTRY_ENTITY);
        int resultRow = this.checkRowDimsRepetitive(rowNum);
        if (resultRow != -1) {
            this.setNeedChangeProperty(false);
            this.getModel().setValue(propKey, oldValue, rowNum);
            this.setNeedChangeProperty(true);
            if (resultRow == -2) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u79d1\u76ee\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BaseEbAdjustBillEditPlugin_new_02", (String)"epm-eb-formplugin", (Object[])new Object[]{rowNum + 1}));
            } else {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"BaseEbAdjustBillEditPlugin_new_01", (String)"epm-eb-formplugin", (Object[])new Object[]{resultRow + 1}));
            }
        } else {
            if ("adjaccount".equals(propKey) && !this.isExpenseBudget() && !this.isSameDataSet(oldValue, newValue)) {
                this.buildCustomDimInfo(rowNum);
            }
            this.clearAdjDataWhenDimChanged(rowNum);
            this.changeBudgetData(rowNum);
        }
    }

    protected boolean isSameDataSet(Object oldValue, Object newValue) {
        Long accountId;
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        long oldDataSet = 0L;
        if (oldValue instanceof Long) {
            accountId = (Long)oldValue;
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
            if (accountMember != null) {
                oldDataSet = accountMember.getDatasetId();
            }
        } else if (oldValue instanceof DynamicObject) {
            accountId = ((DynamicObject)oldValue).getLong("id");
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
            if (accountMember != null) {
                oldDataSet = accountMember.getDatasetId();
            }
        }
        long newDataSet = 0L;
        if (newValue instanceof Long) {
            Long accountId2 = (Long)newValue;
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId2);
            if (accountMember != null) {
                newDataSet = accountMember.getDatasetId();
            }
        } else if (newValue instanceof DynamicObject) {
            Long accountId3 = ((DynamicObject)newValue).getLong("id");
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId3);
            if (accountMember != null) {
                newDataSet = accountMember.getDatasetId();
            }
        }
        return oldDataSet == newDataSet;
    }

    private void changeAdjustData(String propKey, int rowNum) {
        if (!this.needResponseTheChanged()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        String periodOrder = propKey.replaceAll("[^0-9]", "");
        BigDecimal finalData = (BigDecimal)dataModel.getValue("adjfinaldata" + periodOrder, rowNum);
        BigDecimal budgetData = (BigDecimal)dataModel.getValue("adjbudgetdata" + periodOrder, rowNum);
        this.setResponseTheChanged(false);
        dataModel.setValue("adjadjustdata" + periodOrder, (Object)finalData.subtract(budgetData), rowNum);
        this.setResponseTheChanged(true);
    }

    private void clearAdjDataWhenDimChanged(int rowNum) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!"A".equals(billStatus)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        int beginRowNum = 0;
        int endRowNum = dataModel.getEntryRowCount(ENTRY_ENTITY);
        if (rowNum != -1) {
            beginRowNum = rowNum;
            endRowNum = rowNum + 1;
        }
        HashMap<Integer, List<String>> position = new HashMap<Integer, List<String>>(16);
        ArrayList<String> colNums = new ArrayList<String>(16);
        boolean done = false;
        for (int i = beginRowNum; i < endRowNum; ++i) {
            for (int j = 1; j <= 19; ++j) {
                if (dataModel.getValue(this.isExpenseBudget() ? "adjperiod" + j : "adjbudgetperiod" + j) == null) continue;
                dataModel.setValue("adjbudgetbalance" + j, null, i);
                dataModel.setValue("adjlimitbalance" + j, null, i);
                dataModel.setValue("adjlimitbalanceshow" + j, null, i);
                dataModel.setValue("adjbeyond" + j, (Object)true, i);
                dataModel.setValue("adjbudgetdata" + j, null, i);
                if (done) continue;
                colNums.add(String.valueOf(j));
            }
            position.put(i, colNums);
            done = true;
        }
        this.checkReasonAndSetStyle(position);
        this.setResponseTheChanged(true);
    }

    public void changeBudgetData(int rowNum) {
        if (!this.billHeadOver()) {
            return;
        }
        this.checkRowsCompleted(ENTRY_ENTITY);
        IDataModel dataModel = this.getModel();
        int rowCount = dataModel.getEntryRowCount(ENTRY_ENTITY);
        if (rowCount == 0) {
            return;
        }
        DynamicObject firstRow = dataModel.getEntryRowEntity(ENTRY_ENTITY, 0);
        if (firstRow == null) {
            return;
        }
        DynamicInfoCollection periodInfos = this.getCachePeriodInfo();
        List periodNums = periodInfos.getAllValOfOneProp("number");
        if (periodNums.isEmpty()) {
            return;
        }
        Set<Integer> completedRowNums = AdjustUtil.isEBModel((long)this.getModelId()) ? this.getCompletedRowNum() : this.getBgmCompletedRowNum();
        if (completedRowNums.isEmpty()) {
            return;
        }
        String billStatus = (String)dataModel.getValue("billstatus");
        if (AdjustBillStateEnum.PASS.getShortNumber().equals(billStatus) || AdjustBillStateEnum.DISCARD.getShortNumber().equals(billStatus)) {
            return;
        }
        if (rowNum != -1) {
            if (AdjustUtil.isEBModel((long)this.getModelId())) {
                if (completedRowNums.contains(rowNum)) {
                    completedRowNums.clear();
                    completedRowNums.add(rowNum);
                } else {
                    completedRowNums.clear();
                }
            } else if (completedRowNums.contains(rowNum)) {
                Set<Integer> sameDimRowNums = this.getSameDimRowNums(rowNum);
                if (CollectionUtils.isNotEmpty(sameDimRowNums)) {
                    completedRowNums = sameDimRowNums;
                }
            } else {
                completedRowNums.clear();
            }
        }
        if (completedRowNums.isEmpty()) {
            return;
        }
        this.changeBudgetDataForRow(periodNums, completedRowNums);
    }

    public abstract void changeBudgetDataForRow(List<Object> var1, Set<Integer> var2);

    private void changeFinalData(String propKey, int rowNum) {
        if (!this.needResponseTheChanged()) {
            return;
        }
        String periodOrder = propKey.replaceAll("[^0-9]", "");
        if (propKey.contains("adjadjustdata")) {
            HashMap<Integer, List<String>> position = new HashMap<Integer, List<String>>(16);
            position.put(rowNum, Collections.singletonList(periodOrder));
            this.checkReasonAndSetStyle(position);
        }
        IDataModel dataModel = this.getModel();
        BigDecimal budgetData = (BigDecimal)dataModel.getValue("adjbudgetdata" + periodOrder, rowNum);
        BigDecimal adjustData = dataModel.getValue("adjadjustdata" + periodOrder, rowNum) == null ? BigDecimal.ZERO : (BigDecimal)dataModel.getValue("adjadjustdata" + periodOrder, rowNum);
        this.setResponseTheChanged(false);
        dataModel.setValue("adjfinaldata" + periodOrder, (Object)budgetData.add(adjustData), rowNum);
        this.setResponseTheChanged(true);
        this.cachePeriodAdjustRowMap(Integer.parseInt(periodOrder), rowNum, adjustData);
        Set<Integer> sameDimRowNums = this.getSameDimRowNums(rowNum);
        if (CollectionUtils.isNotEmpty(sameDimRowNums) && propKey.contains("adjadjustdata") && sameDimRowNums.size() > 1) {
            this.changeBudgetData(rowNum);
        }
    }

    private void cachePeriodAdjustRowMap(Integer periodOrder, int rowNum, BigDecimal adjustData) {
        String needUpdateAdjustCache = this.getPageCache().get("needUpdateAdjustCache");
        if (StringUtils.isNotEmpty((String)needUpdateAdjustCache)) {
            return;
        }
        String periodAdjustCache = this.getPageCache().get("periodAdjustCache");
        Map<Long, Map> periodAdjustCacheMap = new HashMap(16);
        if (StringUtils.isNotEmpty((String)periodAdjustCache)) {
            periodAdjustCacheMap = (Map)SerializationUtils.deSerializeFromBase64((String)periodAdjustCache);
        }
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection(this.getPeriodNameForHead());
        DynamicObject object = (DynamicObject)dynamicObjectCollection.get(periodOrder - 1);
        Map rowData = periodAdjustCacheMap.computeIfAbsent(object.getLong("fbasedataid_id"), v -> new HashMap(16));
        rowData.put(rowNum, adjustData);
        this.getPageCache().put("periodAdjustCache", SerializationUtils.serializeToBase64(periodAdjustCacheMap));
    }

    private void checkReasonAndSetStyle(Map<Integer, List<String>> reasonPosition) {
        if (reasonPosition == null) {
            return;
        }
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        ArrayList cellStyles = new ArrayList(16);
        IDataModel dataModel = this.getModel();
        reasonPosition.forEach((rowIndex, colNums) -> {
            DynamicObject rowObj = dataModel.getEntryRowEntity(ENTRY_ENTITY, rowIndex.intValue());
            colNums.forEach(rolNum -> {
                BigDecimal adjustData = rowObj.getBigDecimal("adjadjustdata" + rolNum);
                String reason = rowObj.getString("adjadjexplain" + rolNum);
                if (StringUtils.isNotEmpty((String)reason)) {
                    if (adjustData.compareTo(BigDecimal.ZERO) == 0) {
                        rowObj.set("adjadjexplain" + rolNum, null);
                        cellStyles.add(this.getAdjustDataStyle((int)rowIndex, (String)rolNum, true));
                    } else {
                        cellStyles.add(this.getAdjustDataStyle((int)rowIndex, (String)rolNum, false));
                    }
                }
            });
        });
        if (!cellStyles.isEmpty()) {
            entry.setCellStyle(cellStyles);
        }
    }

    private int checkRowDimsRepetitive(int rowNum) {
        List customControlKey;
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        IDataModel dataModel = this.getModel();
        DynamicObject rowObj = dataModel.getEntryRowEntity(ENTRY_ENTITY, rowNum);
        String customDimStr = this.getPageCache().get(CUSTOM_DIMS_INFO_CACHE);
        if (customDimStr == null) {
            return -1;
        }
        DynamicInfoCollection customDims = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
        if (this.isExpenseBudget()) {
            customControlKey = customDims.getAllValOfOneProp("controlkey");
        } else {
            Long accountId = rowObj.getLong("adjaccount.id");
            if (IDUtils.isNull((Long)accountId)) {
                return -1;
            }
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
            if (accountMember == null) {
                return -2;
            }
            Long l = IDUtils.toLong((Object)accountMember.getDatasetId());
            DynamicInfoCollection rowCustomDim = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)this.getModelId(), (Long)l);
            customControlKey = rowCustomDim.getAllValOfOneProp("controlkey");
        }
        boolean rowCompleted = true;
        for (String string : this.entryEntityKeys) {
            if (!customControlKey.contains("adj" + string) && string.contains("custom") || rowObj.get("adj" + string) != null) continue;
            rowCompleted = false;
            break;
        }
        if (rowCompleted) {
            if (this.isExpenseBudget()) {
                Set<Integer> completedRowNums = this.getCompletedRowNum();
                for (int num : completedRowNums) {
                    if (num == rowNum) continue;
                    boolean isSame = true;
                    DynamicObject anotherRow = dataModel.getEntryRowEntity(ENTRY_ENTITY, num);
                    for (String key2 : this.entryEntityKeys) {
                        String valTwo;
                        String valOne;
                        key2 = "adj" + key2;
                        if (!customControlKey.contains(key2) && key2.contains("custom") || (valOne = rowObj.getString(key2 + ".id")).equals(valTwo = anotherRow.getString(key2 + ".id"))) continue;
                        isSame = false;
                        break;
                    }
                    if (!isSame) continue;
                    return num;
                }
            } else {
                Map<Integer, String> rowDimMap = this.getRowDimMap();
                String string = this.getDimMemsForRow(rowObj);
                if (StringUtils.isNotEmpty((String)string)) {
                    rowDimMap.put(rowNum, string);
                    this.getPageCache().put(COMPLETED_ROW_DIMS_CACHE, SerializationUtils.serializeToBase64(rowDimMap));
                }
            }
            this.updateCompletedRowNum(false, false, rowNum);
        }
        return -1;
    }

    public void updateCompletedRowNum(boolean delOrAdd, boolean isDelRow, Integer ... rowNumProps) {
        Set<Object> rowNums = new HashSet<Integer>(16);
        if (delOrAdd) {
            rowNums = this.getCompletedRowNum();
            rowNums.remove(rowNumProps[0]);
            if (isDelRow) {
                HashSet<Integer> newNums = new HashSet<Integer>(16);
                Iterator<Object> iterator = rowNums.iterator();
                while (iterator.hasNext()) {
                    Integer rowNum = (Integer)iterator.next();
                    if (rowNum <= rowNumProps[0]) continue;
                    iterator.remove();
                    newNums.add(rowNum - 1);
                }
                if (newNums.size() != 0) {
                    rowNums.addAll(newNums);
                }
            }
        } else {
            rowNums.addAll(Arrays.asList(rowNumProps));
        }
        this.getPageCache().put("CompletedRowNum", SerializationUtils.serializeToBase64(rowNums));
    }

    public Set<Integer> getCompletedRowNum() {
        String cacheStr = this.getPageCache().get("CompletedRowNum");
        HashSet<Integer> rowNums = cacheStr == null ? new HashSet<Integer>(16) : (HashSet<Integer>)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        return rowNums;
    }

    public void itemClick(ItemClickEvent evt) {
        String actionKey;
        super.itemClick(evt);
        switch (actionKey = evt.getItemKey()) {
            case "projectimport": {
                this.openAdjustCollect(null, PROJECT_IMPORT);
                break;
            }
            case "projectexport": {
                this.openAdjustCollect(null, PROJECT_EXPORT);
                break;
            }
            case "adjustcheck": {
                List<String> checkInfos = this.checkMustInput(ADJUST_CHECK);
                if (checkInfos != null) {
                    String errorMsg = String.join((CharSequence)"\n", checkInfos);
                    this.getView().showErrorNotification(errorMsg);
                    return;
                }
                String billStatus = (String)this.getModel().getValue("billstatus");
                if (!AdjustBillStateEnum.PASS.getShortNumber().equals(billStatus) && !AdjustBillStateEnum.DISCARD.getShortNumber().equals(billStatus)) {
                    this.changeBudgetData(-1);
                }
                this.checkAdjustment(ADJUST_CHECK);
                break;
            }
            case "btn_import": {
                if (!this.verifyPeriod()) break;
                this.entryImport();
                break;
            }
            case "btn_export": {
                if (!this.verifyPeriod()) break;
                this.entryExport();
                break;
            }
            case "btn_addrow_form": {
                this.openBudgetForm();
                break;
            }
        }
    }

    public boolean verifyPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object value = dataEntity.get(this.getPeriodNameForHead());
        if (value == null || ((DynamicObjectCollection)value).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4\uff0c\u518d\u64cd\u4f5c\u3002", (String)"BaseEbAdjustBillEditPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void entryImport() {
        String entityName;
        String entityKey;
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importEntryEntity");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        boolean specialBGRPApp = NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView());
        if (AdjustUtil.isBGModel((long)this.getModelId()) || AdjustUtil.isBGMModel((long)this.getModelId()) || specialBGRPApp) {
            boolean isBGRPBgModel;
            entityKey = "bgm_adjustbill";
            entityName = ResManager.loadKDString((String)"\u5168\u9762\u9884\u7b97\u8c03\u6574\u5355", (String)"AdjustBillListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            boolean bl = isBGRPBgModel = specialBGRPApp && NewEbAppUtil.isNewEbModel((Long)this.getModelId());
            if (AdjustUtil.isBGModel((long)this.getModelId()) || isBGRPBgModel) {
                entityName = ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u6574\u5355", (String)"AdjustBillListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            if ("2".equals(this.getFormType())) {
                entityKey = "bgm_adjpstbill";
                entityName = ResManager.loadKDString((String)"\u5168\u9762\u9884\u7b97\u8c03\u5242\u5355", (String)"AdjustBillListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if (AdjustUtil.isBGModel((long)this.getModelId()) || isBGRPBgModel) {
                    entityName = ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u5242\u5355", (String)"AdjustBillListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
            paramMap.put("bizmodel", this.getBizModelId());
            paramMap.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.bgadjust.impexp.OverallBudgetAdjustEntryImportHandler");
            Object adjustrule = this.getModel().getDataEntity().get("adjustrule");
            if (adjustrule != null) {
                paramMap.put("adjustrule", ((DynamicObject)adjustrule).getLong("id"));
            }
        } else {
            entityKey = "eb_adjustbill";
            entityName = ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u6574\u5355", (String)"AdjustBillListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if ("2".equals(this.getFormType())) {
                entityKey = "eb_adjpstbill";
                entityName = ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u5242\u5355", (String)"AdjustBillListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            paramMap.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.bgadjust.impexp.ExpenseBudgetAdjustEntryImportHandler");
        }
        paramMap.put("model", this.getModelId());
        paramMap.put("bizModel", this.getBizModelId());
        paramMap.put("billtype", this.getFormType());
        paramMap.put("importCategory", "adjustEntryEntity");
        paramMap.put("entityKey", entityKey);
        BillImpExpUtils.openImportPage((IFormView)this.getView(), (String)entityKey, (String)entityName, paramMap, (CloseCallBack)callBack);
    }

    private void entryExport() {
        String billKey;
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u5bfc\u51fa\u6570\u636e", (String)"BaseEbAdjustBillEditPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isExpenseBudget()) {
            this.getPageCache().put("exportEntry", "true");
        }
        this.changeDataB4SaveData();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        boolean specialBGRPApp = NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView());
        params.put("model", this.getModelId());
        if (AdjustUtil.isBGModel((long)this.getModelId()) || AdjustUtil.isBGMModel((long)this.getModelId()) || specialBGRPApp) {
            billKey = "bgm_adjustbill";
            if ("2".equals(this.getFormType())) {
                billKey = "bgm_adjpstbill";
            }
            params.put("bizmodel", this.getBizModelId());
            params.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.bgadjust.impexp.OverallBudgetAdjustEntryExportHandler");
        } else {
            billKey = "eb_adjustbill";
            if ("2".equals(this.getFormType())) {
                billKey = "eb_adjpstbill";
            }
            params.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.bgadjust.impexp.ExpenseBudgetAdjustEntryExportHandler");
        }
        params.put("specialBGRPApp", String.valueOf(specialBGRPApp));
        params.put("billtype", this.getFormType());
        params.put("dataModel", dataModel);
        params.put("exportCategory", "adjustEntryEntity");
        BillExportStart entryExportStart = BillImpExpStarFactory.getExportStart((String)billKey, params);
        entryExportStart.exportData(this.getView(), params);
        dataModel.setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("switchdept".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setShowTitle(true);
            formShowParameter.setFormId("eb_userdeptlist");
            Object user = this.getModel().getValue("applier");
            Object dept = this.getModel().getValue("department");
            String position = (String)this.getModel().getValue("position");
            if (user instanceof DynamicObject) {
                formShowParameter.setCustomParam("user", (Object)((DynamicObject)user).getString("id"));
                if (dept instanceof DynamicObject) {
                    formShowParameter.setCustomParam("dept.id", (Object)((DynamicObject)dept).getString("id"));
                    if (position != null) {
                        formShowParameter.setCustomParam("position", (Object)position);
                    }
                }
            }
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "switchdept"));
            this.getView().showForm(formShowParameter);
        }
    }

    protected AbstractAdjustValidator getAdjustValidator(@NotNull String operation) {
        return AbstractAdjustValidator.getInstance((IAdjustValidatorSource)this, (String)operation);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (ApplicationTypeEnum.EB.getIndex().equals(((DynamicObject)this.getModel().getValue("model")).getString("reporttype"))) {
            this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)true);
            this.periodGroupKeys = new String[]{"period", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
            this.periodKey = "period";
        } else {
            this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)false);
            this.periodGroupKeys = new String[]{"budgetperiod", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
            this.periodKey = "budgetperiod";
        }
        String opType = ((FormOperate)args.getSource()).getType();
        if (("save".equals(opType) || "submit".equals(opType)) && this.beforeCheck(args)) {
            LogStats stats = new LogStats("adjustBill-submit-log:");
            stats.addInfo("adjustBill-submit-start.");
            List errors = this.getAdjustValidator(opType).checkDimPerm();
            stats.add("checkDimPerm end.");
            if (CollectionUtils.isNotEmpty((Collection)errors)) {
                args.setCancel(true);
                this.getView().showErrorNotification(String.join((CharSequence)"\n", errors));
                return;
            }
            this.changeBudgetData(-1);
            stats.add("changeBudgetData end.");
            this.clearEmptyRow();
            this.changeDataB4SaveData();
            stats.add("changeDataB4SaveData end.");
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (AdjustBillStateEnum.NOPASS.getShortNumber().equals(billStatus)) {
                this.getModel().setValue("billstatus", (Object)AdjustBillStateEnum.SAVE.getShortNumber());
                if ("submit".equals(opType)) {
                    DynamicObject dataEntity = this.getModel().getDataEntity();
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                }
            }
            if (!AdjustUtil.isEBModel((long)this.getModelId())) {
                this.singleValidate(opType);
                stats.add("singleValidate end.");
            }
            if ("submit".equals(opType)) {
                List<String> checkInfos = this.checkMustInput("submit");
                stats.add("checkMustInput end.");
                if (checkInfos != null) {
                    args.setCancel(true);
                    String errorMsg = String.join((CharSequence)"\n", checkInfos);
                    this.getView().showErrorNotification(errorMsg);
                    return;
                }
                try {
                    String entityNumber = ((BaseView)this.getView()).getFormId();
                    this.getAdjustValidator(opType).checkOrgPerm(entityNumber, this.getBizAppId());
                    stats.add("checkOrgPerm end.");
                    if (this.checkAdjustment("submit")) {
                        args.setCancel(true);
                        return;
                    }
                    stats.add("checkAdjustment end.");
                    DynamicObject dataEntity = this.getModel().getDataEntity();
                    String billno = dataEntity.getString("billno");
                    if (StringUtils.isEmpty((String)billno)) {
                        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
                        String billNumber = service.getNumber(this.getView().getEntityId(), dataEntity, null);
                        dataEntity.set("billno", (Object)billNumber);
                    }
                    AdjustUtil.fillEntityBailOrg((long)this.getModelId(), (DynamicObject)dataEntity);
                    stats.add("fillEntityBailOrg end.");
                }
                catch (Exception ex) {
                    log.error("checkAdjustment error: ", (Throwable)ex);
                    this.getView().showErrorNotification(ex.getMessage());
                    args.setCancel(true);
                }
            }
            stats.addInfo("adjustBill-submit-end.");
            log.info(stats.toString());
        }
    }

    public void cacheCustomDimJson() {
    }

    public Map<String, String> getCustomDimMap() {
        return null;
    }

    private boolean beforeCheck(BeforeDoOperationEventArgs args) {
        String result = this.getAdjustValidator("other").beforeCheck();
        if (result != null) {
            this.getView().showTipNotification(result);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public void openAdjustCollect(DynamicObjectCollection dynamicObjects, String opType) {
        if (!this.isExpenseBudget() && this.getBizModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BaseEbAdjustBillEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("custom", (Object)this.getPageCache().get(CUSTOM_DIMS_INFO_CACHE));
        formShowParameter.setCustomParam("pageId", (Object)this.getView().getPageId());
        this.setFormShowParameter(formShowParameter);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "entryWin"));
        if (opType.equals(PROJECT_EXPORT)) {
            if (dynamicObjects != null) {
                formShowParameter.setCustomParam("agjustList", (Object)SerializationUtils.serializeToBase64((Object)dynamicObjects));
                formShowParameter.setCustomParam("ag", (Object)"1");
            } else {
                int count = 0;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                DynamicInfoCollection customDimsInfo = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CUSTOM_DIMS_INFO_CACHE));
                int size = customDimsInfo.getValues().size();
                for (DynamicObject dynamicObject : entryEntity) {
                    String metricNumber;
                    String adjentity = dynamicObject.getString("adjentity.id");
                    String adjaccount = dynamicObject.getString("adjaccount.id");
                    if (StringUtils.isEmpty((String)adjentity) || StringUtils.isEmpty((String)adjaccount)) {
                        ++count;
                    }
                    if (!this.isExpenseBudget() && StringUtils.isEmpty((String)(metricNumber = dynamicObject.getString("adjmetric.number")))) {
                        ++count;
                    }
                    if (size <= 0) continue;
                    for (int i = 1; i <= size; ++i) {
                        String objectString = dynamicObject.getString("adjcustomdim" + i + ".id");
                        if (!this.isExpenseBudget() || !StringUtils.isEmpty((String)objectString)) continue;
                        ++count;
                    }
                }
                if (entryEntity.size() == 0 || count != 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u8c03\u6574\u660e\u7ec6\u3002", (String)"BaseEbAdjustBillEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                formShowParameter.setCustomParam("agjustList", (Object)SerializationUtils.serializeToBase64((Object)entryEntity));
                formShowParameter.setCustomParam("ag", (Object)"1");
            }
        }
        this.getView().showForm(formShowParameter);
    }

    public abstract void setFormShowParameter(FormShowParameter var1);

    private void setUserSelect() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("applier", "=", (Object)UserUtils.getUserId()));
        qfBuilder.add(new QFilter("billtype", "=", (Object)this.getFormType()));
        DynamicObject[] adjustBillArr = BusinessDataServiceHelper.load((String)(!this.isExpenseBudget() ? "bgm_adjustbill" : "eb_adjustbill"), (String)"id,model,year,currency,multperiod,applydate,budgetperiods", (QFilter[])qfBuilder.toArray(), (String)"applydate desc", (int)1);
        if (adjustBillArr.length > 0) {
            DynamicObject dynamicObject = adjustBillArr[0];
            this.getModel().setValue("year", dynamicObject.get("year"));
            this.getModel().setValue("currency", dynamicObject.get("currency"));
            this.getModel().setValue("multperiod", dynamicObject.get("multperiod"));
            this.getModel().setValue("budgetperiods", dynamicObject.get("budgetperiods"));
            this.selectControlVersions();
            this.adjustPeriodGroup(true);
            this.clearAdjDataWhenDimChanged(-1);
            this.changeBudgetData(-1);
        }
    }

    public void selectControlVersions() {
        List<Date> periodDateList = this.getPeriodDateList();
        if (periodDateList.size() < 2) {
            return;
        }
        periodDateList.stream().sorted().collect(Collectors.toList());
        Date startDate = periodDateList.get(0);
        Date endDate = periodDateList.get(periodDateList.size() - 1);
        ArrayList<Long> versionList = new ArrayList<Long>();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        if (!this.isExpenseBudget()) {
            qfBuilder.add("bussmodel", "=", (Object)this.getBizModelId());
        }
        DynamicObjectCollection controlVersions = QueryServiceHelper.query((String)"eb_controlversion", (String)"model,version,effectivetime,invalidtime", (QFilter[])qfBuilder.toArray());
        for (DynamicObject versionObj : controlVersions) {
            try {
                Date effectiveTime = (Date)versionObj.get("effectivetime");
                Date effectiveDate = null;
                if (effectiveTime != null) {
                    effectiveDate = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)effectiveTime, (String)"yyyy/MM/dd"), (String)"yyyy/MM/dd");
                }
                Date invalidTime = (Date)versionObj.get("invalidtime");
                Date invalidDate = null;
                if (invalidTime != null) {
                    invalidDate = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)invalidTime, (String)"yyyy/MM/dd"), (String)"yyyy/MM/dd");
                }
                if (!this.isDateCross(startDate, endDate, effectiveDate, invalidDate)) continue;
                versionList.add((Long)versionObj.get("version"));
            }
            catch (ParseException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        if (versionList.size() == 1) {
            this.getModel().beginInit();
            Long bizModelId = this.isExpenseBudget() ? Long.valueOf(0L) : this.getBizModelId();
            Set writePermMembIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Version.getNumber(), (Long)this.getModelId(), (Long)bizModelId, (Long)0L, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
            if (writePermMembIds != null && !writePermMembIds.contains(versionList.get(0))) {
                this.getModel().setValue("version", null);
            } else {
                this.getModel().setValue("version", versionList.get(0));
            }
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    public abstract List<Date> getPeriodDateList();

    public boolean isDateCross(Date startDate, Date endDate, Date effectDate, Date invalidDate) {
        boolean flag = false;
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        long effectTime = 0L;
        if (effectDate != null) {
            effectTime = effectDate.getTime();
        }
        if (invalidDate != null) {
            long invalidTime = invalidDate.getTime();
            if (startTime <= effectTime && effectTime <= endTime || startTime <= invalidTime && invalidTime <= endTime || effectTime <= startTime && startTime <= invalidTime || effectTime <= endTime && endTime <= invalidTime) {
                flag = true;
            }
        } else if (startTime <= effectTime && effectTime <= endTime || effectTime <= startTime) {
            flag = true;
        }
        return flag;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            this.getModel().setDataChanged(false);
            this.changeItemStatusByFormType();
        } else if ("submit".equals(opType)) {
            this.getModel().setDataChanged(false);
            this.changeItemStatusByFormType();
            this.setWorkFlowVisible();
        }
    }

    public final List<String> checkMustInput(String operation) {
        return this.getAdjustValidator(operation).checkMustInput();
    }

    public void changeDataB4SaveData() {
        IDataModel dataModel = this.getModel();
        MainEntityType mainType = this.getModel().getDataEntityType();
        DynamicProperty prop = mainType.getProperty(ENTRY_ENTITY);
        DynamicObjectCollection dataRows = (DynamicObjectCollection)prop.getValueFast((Object)dataModel.getDataEntity(true));
        ArrayList<String> propKeys = new ArrayList<String>(this.entryEntityKeys);
        Collections.addAll(propKeys, "groupnum", this.getPeriodNameForGroup(), "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond", ORDER_SIGN_KEY);
        DynamicInfoCollection entryRowInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5c06\u5355\u636e\u4f53\u8f6c\u6362\u4e3a\u8981\u5b58\u50a8\u7684\u591a\u884c\u8bb0\u5f55", (String)"BaseEbAdjustBillEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), propKeys.toArray(new String[1]));
        int periodSize = ((DynamicObjectCollection)dataModel.getValue(this.getPeriodNameForHead())).size();
        int propCounts = entryRowInfo.getProps().size();
        int rowNum = 0;
        boolean isEntryChanged = false;
        for (DynamicObject row : dataRows) {
            ArrayList<Object> infoVals;
            if (row.getDataEntityState().isBizChanged()) {
                isEntryChanged = true;
            }
            if (periodSize == 0) {
                infoVals = new ArrayList<Object>(propCounts);
                for (String string : this.entryEntityKeys) {
                    infoVals.add(row.get("adj" + string));
                }
                entryRowInfo.addInfo(infoVals.toArray());
            } else {
                for (int i = 1; i <= periodSize; ++i) {
                    infoVals = new ArrayList(propCounts);
                    for (String key2 : this.entryEntityKeys) {
                        infoVals.add(row.get("adj" + key2));
                    }
                    DynamicObject dynamicObject = row.getDynamicObject("adj" + this.getPeriodNameForGroup() + i);
                    infoVals.add(row.get("adjgroupnum"));
                    if (dynamicObject == null) continue;
                    infoVals.add(dynamicObject);
                    infoVals.add(row.getBigDecimal("adjlimitbalanceshow" + i));
                    infoVals.add(row.getBigDecimal("adjlimitbalance" + i));
                    infoVals.add(row.getBigDecimal("adjbudgetbalance" + i));
                    infoVals.add(row.getBigDecimal("adjbudgetdata" + i));
                    infoVals.add(row.getBigDecimal("adjadjustdata" + i));
                    infoVals.add(row.getBigDecimal("adjfinaldata" + i));
                    infoVals.add(row.getString("adjadjexplain" + i));
                    infoVals.add(row.getBoolean("adjbeyond" + i));
                    infoVals.add(rowNum + ":" + i);
                    entryRowInfo.addInfo(infoVals.toArray());
                }
            }
            row.getDataEntityState().setBizChanged(2, true);
            ++rowNum;
        }
        if (isEntryChanged || this.getPageCache().get(ROW_NUM_CHANGE_CACHE) != null || this.isCopyNew().booleanValue() || this.getPageCache().get("exportEntry") != null) {
            dataModel.deleteEntryData(ADJ_DETAIL_ENTITY);
            if (entryRowInfo.getValues().size() > 0) {
                dataModel.batchCreateNewEntryRow(ADJ_DETAIL_ENTITY, entryRowInfo.getValues().size());
                rowNum = 0;
                for (DynamicInfoCollection.InfoObject row : entryRowInfo.getValues()) {
                    DynamicObject newRow = dataModel.getEntryRowEntity(ADJ_DETAIL_ENTITY, rowNum++);
                    for (String key : entryRowInfo.getProps()) {
                        newRow.set(key, row.getValueByPropName(key));
                    }
                }
            }
            this.getPageCache().remove(ROW_NUM_CHANGE_CACHE);
            this.getPageCache().remove("exportEntry");
            this.getPageCache().remove("isCopyNew");
        }
    }

    private String getPeriodNameForHead() {
        return this.isExpenseBudget() ? "multperiod" : "budgetperiods";
    }

    private String getPeriodNameForGroup() {
        return this.isExpenseBudget() ? "period" : "budgetperiod";
    }

    private void clearEmptyRow() {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection rows = dataModel.getEntryEntity(ENTRY_ENTITY);
        if (!rows.isEmpty()) {
            int periodSize = ((DynamicObjectCollection)dataModel.getValue("multperiod")).size();
            ArrayList<Integer> delRowIndexs = new ArrayList<Integer>(16);
            int rowNum = 0;
            for (DynamicObject row : rows) {
                boolean isEmpty = true;
                for (String key : this.entryEntityKeys) {
                    key = "adj" + key;
                    if (row.get(key) == null) continue;
                    isEmpty = false;
                    break;
                }
                if (isEmpty) {
                    for (int i = 1; i <= periodSize; ++i) {
                        if (row.getBigDecimal("adjadjustdata" + i).compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("adjfinaldata" + i).compareTo(BigDecimal.ZERO) == 0) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (isEmpty) {
                    delRowIndexs.add(rowNum);
                }
                ++rowNum;
            }
            if (!delRowIndexs.isEmpty()) {
                int[] indexs = new int[delRowIndexs.size()];
                for (int i = 0; i < delRowIndexs.size(); ++i) {
                    indexs[i] = (Integer)delRowIndexs.get(i);
                }
                dataModel.deleteEntryRows(ENTRY_ENTITY, indexs);
            }
        }
    }

    public void buildCustomDimInfo(int index) {
    }

    public void adjustPeriodGroup(boolean needClearData) {
        boolean isShowBudgetBalance = Boolean.parseBoolean(this.getPageCache().get(IS_SHOW_BUDGET_BALANCE));
        boolean isShowLimitBalance = Boolean.parseBoolean(this.getPageCache().get(IS_SHOW_LIMIT_BALANCE));
        boolean isExistControlDim = Boolean.parseBoolean(this.getPageCache().get(IS_EXIST_CONTROL_DIM));
        String billStatus = (String)this.getModel().getValue("billstatus");
        boolean isAuditOrDisCard = AdjustBillStateEnum.PASS.getShortNumber().equals(billStatus) || AdjustBillStateEnum.DISCARD.getShortNumber().equals(billStatus);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection periods = this.isExpenseBudget() ? (DynamicObjectCollection)this.getModel().getValue("multperiod") : (DynamicObjectCollection)this.getModel().getValue("budgetperiods");
        int rowCount = dataModel.getEntryRowCount(ENTRY_ENTITY);
        if (needClearData) {
            for (int j = 0; j < rowCount; ++j) {
                DynamicObject row = dataModel.getEntryRowEntity(ENTRY_ENTITY, j);
                for (int i = 1; i <= 19; ++i) {
                    row.set("adj" + this.getPeriodNameForGroup() + i, null);
                }
            }
        }
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int num = 1;
        ArrayList<String> groupNums = new ArrayList<String>(16);
        DynamicInfoCollection periodInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u591a\u9009\u671f\u95f4\u4fe1\u606f-id,\u7f16\u7801\uff0c\u540d\u79f0\uff0c\u5e8f\u53f7", (String)"BaseEbAdjustBillEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "number", "name", "order"});
        for (DynamicObject period : periods) {
            String name = period.getString("fbasedataid.name");
            String id = period.getString("fbasedataid.id");
            String number = period.getString("fbasedataid.number");
            periodInfos.addInfo(new Object[]{id, number, name, num});
            groupNums.add("adjperiodgroup" + num);
            if (needClearData) {
                for (int i = 0; i < rowCount; ++i) {
                    DynamicObject row = dataModel.getEntryRowEntity(ENTRY_ENTITY, i);
                    row.set("adj" + this.getPeriodNameForGroup() + num, period.get("fbasedataid"));
                }
            }
            this.getView().setVisible(Boolean.valueOf(isShowBudgetBalance), new String[]{"adjbudgetbalance" + num});
            this.getView().setVisible(Boolean.valueOf(isShowLimitBalance), new String[]{"adjlimitbalanceshow" + num});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjbeyond" + num});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjlimitbalance" + num});
            grid.setColumnProperty("adjperiodgroup" + num, "header", (Object)new LocaleString(name));
            if (isShowBudgetBalance && isExistControlDim && !isAuditOrDisCard) {
                grid.setColumnProperty("adjbudgetbalance" + num, "ln", (Object)Boolean.TRUE);
            } else {
                grid.setColumnProperty("adjbudgetbalance" + num, "ln", (Object)Boolean.FALSE);
            }
            ++num;
        }
        this.getView().updateView(ENTRY_ENTITY);
        this.invokeControlMethod(groupNums);
        this.getPageCache().put(PERIODS_INFO_CACHE, SerializationUtils.serializeToBase64((Object)periodInfos));
    }

    private void invokeControlMethod(List<String> groupNums) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        HashMap<String, Object> argTrueVals = new HashMap<String, Object>(16);
        argTrueVals.put("vi", true);
        argTrueVals.put("k", groupNums.toArray());
        args.put("o", "s");
        if (groupNums.size() < 19) {
            HashMap<String, Object> argFalseVals = new HashMap<String, Object>(16);
            argFalseVals.put("vi", false);
            ArrayList<String> falseKeys = new ArrayList<String>(19 - groupNums.size());
            for (int i = groupNums.size() + 1; i <= 19; ++i) {
                falseKeys.add("adjperiodgroup" + i);
            }
            argFalseVals.put("k", falseKeys.toArray());
            args.put("v", new Object[]{argTrueVals, argFalseVals});
        } else {
            args.put("v", new Object[]{argTrueVals});
        }
        JSONObject jsonObj = new JSONObject(args);
        clientViewProxy.invokeControlMethod(ENTRY_ENTITY, "visible", new Object[]{new Object[]{jsonObj}});
    }

    public DynamicInfoCollection getCachePeriodInfo() {
        String periodStr = this.getPageCache().get(PERIODS_INFO_CACHE);
        DynamicInfoCollection periodInfos = periodStr == null ? new DynamicInfoCollection(ResManager.loadKDString((String)"\u591a\u9009\u671f\u95f4\u4fe1\u606f-id,\u7f16\u7801\uff0c\u540d\u79f0\uff0c\u5e8f\u53f7", (String)"BaseEbAdjustBillEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "number", "name", "order"}) : (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)periodStr);
        return periodInfos;
    }

    public void updateUserInfoObject() {
        IDataModel dataModel = this.getModel();
        BasicInfoHelper.setFormInfo((IDataModel)dataModel, (IFormView)this.getView(), (boolean)true);
    }

    public void updateUserInfoShow() {
        IDataModel dataModel = this.getModel();
        DynamicObject object = (DynamicObject)dataModel.getValue("applier");
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"BaseEbAdjustBillEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Label label = (Label)this.getControl("appliertag");
        label.setText(object.getString("name"));
        label = (Label)this.getControl("userphone");
        label.setText(object.getString("phone"));
        Image pic = (Image)this.getControl("userpic");
        Long userId = object.getLong("id");
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map userPics = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
        pic.setUrl((String)userPics.get(userId));
        label = (Label)this.getControl("positiontag");
        label.setText((String)dataModel.getValue("position"));
        label = (Label)this.getControl("companytag");
        object = (DynamicObject)dataModel.getValue("company");
        if (object != null) {
            label.setText(object.getString("name"));
        }
        object = (DynamicObject)dataModel.getValue("department");
        label = (Label)this.getControl("departmenttag");
        if (object != null) {
            label.setText(object.getString("name"));
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        LogStats stats = new LogStats("adjustBill-afterLoadData-log:");
        stats.addInfo("adjustBill-afterLoadData-start.");
        if (ApplicationTypeEnum.EB.getIndex().equals(((DynamicObject)this.getModel().getValue("model")).getString("reporttype"))) {
            this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)true);
            this.periodGroupKeys = new String[]{"period", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
            this.periodKey = "period";
        } else {
            this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)false);
            this.periodGroupKeys = new String[]{"budgetperiod", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
            this.periodKey = "budgetperiod";
        }
        boolean isEbParam = this.isExpenseBudget() || AdjustUtil.isBGModel((long)this.getModelId());
        boolean isShowBudgetBalance = ControlParamsSettingUtil.isShowBudgetBalance((Long)this.getModelId(), (String)this.getFormType(), (boolean)isEbParam);
        this.getPageCache().put(IS_SHOW_BUDGET_BALANCE, isShowBudgetBalance ? "true" : "false");
        boolean isShowLimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)this.getModelId(), (String)this.getFormType(), (boolean)isEbParam);
        this.getPageCache().put(IS_SHOW_LIMIT_BALANCE, isShowLimitBalance ? "true" : "false");
        if ((isShowBudgetBalance || isShowLimitBalance) && !this.isExpenseBudget()) {
            this.putControlDimCache();
        }
        this.updateUserInfoShow();
        stats.add("updateUserInfoShow end.");
        this.addEmptyData();
        this.adjustPeriodGroup(false);
        stats.add("adjustPeriodGroup end.");
        this.updateDataAfterOpen();
        stats.add("updateDataAfterOpen end.");
        this.backFillData(false);
        stats.add("backFillData end.");
        this.checkAllAdjDataStyle();
        this.setF7Visible();
        this.cachePeriodAdjustDataMap();
        stats.add("cachePeriodAdjustDataMap end.");
        this.getPageCache().put("dataChange", "false");
        stats.addInfo("adjustBill-afterLoadData-end.");
        log.info(stats.toString());
    }

    private void checkAllAdjDataStyle() {
        int i;
        int periodCount = this.getCachePeriodInfo().getValues().size();
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        HashMap<Integer, List<String>> position = new HashMap<Integer, List<String>>(16);
        ArrayList<String> colNums = new ArrayList<String>(10);
        for (i = 1; i <= periodCount; ++i) {
            colNums.add(String.valueOf(i));
        }
        for (i = 0; i < rowCount; ++i) {
            position.put(i, colNums);
        }
        this.checkReasonAndSetStyle(position);
    }

    private void addEmptyData() {
        String rowNum;
        DynamicObject billEntity = this.getModel().getDataEntity();
        DynamicObjectCollection adjDetail = billEntity.getDynamicObjectCollection(ADJ_DETAIL_ENTITY);
        HashMap<String, Set> rowPeriodGroupCount = new HashMap<String, Set>(16);
        HashMap<String, DynamicObject> rowData4Copy = new HashMap<String, DynamicObject>(16);
        for (DynamicObject row : adjDetail) {
            String orderSign = row.getString(ORDER_SIGN_KEY);
            if (!StringUtils.isNotEmpty((String)orderSign)) continue;
            rowNum = orderSign.split(":")[0];
            String periodOrder = orderSign.split(":")[1];
            if (!rowData4Copy.containsKey(rowNum)) {
                rowData4Copy.put(rowNum, row);
            }
            Set countNum = rowPeriodGroupCount.computeIfAbsent(rowNum, key -> new HashSet(16));
            countNum.add(Integer.valueOf(periodOrder));
        }
        List<DynamicObject> periodObjs = this.loadPeriodObjs();
        for (Map.Entry groupCount : rowPeriodGroupCount.entrySet()) {
            rowNum = (String)groupCount.getKey();
            Set countNum = (Set)groupCount.getValue();
            DynamicObject copySource = (DynamicObject)rowData4Copy.get(rowNum);
            if (countNum.size() == periodObjs.size() || copySource == null) continue;
            for (int i = 1; i <= periodObjs.size(); ++i) {
                if (countNum.contains(i)) continue;
                DynamicObject newRow = adjDetail.addNew();
                for (String key2 : this.entryEntityKeys) {
                    newRow.set(key2, copySource.get(key2));
                }
                newRow.set("groupnum", copySource.get("groupnum"));
                newRow.set(ORDER_SIGN_KEY, (Object)(rowNum + ":" + i));
                newRow.set(this.periodKey, (Object)periodObjs.get(i - 1));
            }
        }
    }

    public void backFillData(boolean needQuery) {
        this.convertToAdjustEntity(needQuery);
        this.getView().updateView(ENTRY_ENTITY);
        if (this.getView().getFormShowParameter().getStatusValue() == OperationStatus.EDIT.getValue()) {
            this.getModel().setDataChanged(false);
        }
    }

    private List<DynamicObject> loadPeriodObjs() {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection periods = (DynamicObjectCollection)dataModel.getValue(this.getPeriodNameForHead());
        ArrayList ids = new ArrayList(periods.size());
        periods.forEach(info -> ids.add(info.getLong("fbasedataid.id")));
        String entityKey = this.isExpenseBudget() ? SysDimensionEnum.Period.getMemberTreemodel() : SysDimensionEnum.BudgetPeriod.getMemberTreemodel();
        Map objs = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)entityKey);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(ids.size());
        for (Long id : ids) {
            result.add((DynamicObject)objs.get(id));
        }
        return result;
    }

    public void updateDataAfterOpen() {
    }

    public void checkRowsCompleted(String entryEntity) {
        boolean needReplace = StringUtils.equals((String)ADJ_DETAIL_ENTITY, (String)entryEntity);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryEntity);
        if (!rows.isEmpty()) {
            HashSet<Integer> rowNums = new HashSet<Integer>(rows.getRowCount());
            DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
            List customDimKeys = customDims.getAllValOfOneProp("controlkey");
            int rowNum = 0;
            HashMap<Integer, String> rowDimMap = new HashMap<Integer, String>(16);
            for (DynamicObject row : rows) {
                boolean completed = true;
                for (String key : this.entryEntityKeys) {
                    key = "adj" + key;
                    if (key.contains("customdim") && !customDimKeys.contains(key)) continue;
                    if (needReplace) {
                        key = key.replace("adj", "");
                    }
                    if (row.get(key) != null) continue;
                    completed = false;
                    break;
                }
                if (completed) {
                    String rowDims;
                    if (!needReplace && StringUtils.isNotEmpty((String)(rowDims = this.getDimMemsForRow(row)))) {
                        rowDimMap.put(rowNum, rowDims);
                    }
                    rowNums.add(rowNum);
                }
                ++rowNum;
            }
            if (!rowDimMap.isEmpty()) {
                this.getPageCache().put(COMPLETED_ROW_DIMS_CACHE, SerializationUtils.serializeToBase64(rowDimMap));
            }
            if (!rowNums.isEmpty()) {
                this.updateCompletedRowNum(false, false, rowNums.toArray(new Integer[1]));
            } else {
                this.getPageCache().put("CompletedRowNum", null);
            }
        }
    }

    public boolean needResponseTheChanged() {
        boolean result = true;
        String responseTheChanged = this.getPageCache().get(NEED_RESPONSE_THE_CHANGED_CACHE);
        if ("false".equals(responseTheChanged)) {
            result = false;
        }
        return !this.isExpenseBudget() ? result || this.billHeadOver() : result;
    }

    public void setResponseTheChanged(boolean need) {
        String responseTheChanged = String.valueOf(need);
        this.getPageCache().put(NEED_RESPONSE_THE_CHANGED_CACHE, responseTheChanged);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String error;
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick((BeforeItemClickEvent)evt, (Long)this.getModelId(), (IFormView)this.getView(), (Set)Sets.newHashSet((Object[])new String[]{"btn_close"}));
        String key = evt.getItemKey();
        this.isCopy = "btn_copy".equals(key);
        if (this.isCopy) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u5206\u5f55\u884c\u3002", (String)"BgCenterSchemeListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (BTN_SUBMIT.equals(key) && StringUtils.isNotEmpty((String)(error = this.getAdjustValidator("submit").checkAdjustReason()))) {
            this.getView().showTipNotification(error);
            evt.setCancel(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entityKey = e.getEntryProp().getName();
        if (!entityKey.equals(ENTRY_ENTITY)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        RowDataEntity newRow = e.getRowDataEntities()[0];
        int rowIndex = newRow.getRowIndex();
        if (rowIndex != 0 && this.isCopy) {
            this.copyCheckSameRow(rowIndex);
            this.buildCustomDimInfo(rowIndex);
            this.checkGroupMemberPerm(null, rowIndex);
            this.cachePeriodAdjustDataMap();
            this.changeBudgetData(rowIndex);
        }
        DynamicInfoCollection periods = this.getCachePeriodInfo();
        for (DynamicInfoCollection.InfoObject period : periods.getValues()) {
            String id = (String)period.getValueByPropName("id");
            int order = (Integer)period.getValueByPropName("order");
            dataModel.setValue("adj" + this.getPeriodNameForGroup() + order, (Object)id, rowIndex);
        }
    }

    private void copyCheckSameRow(int rowIndex) {
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        int resultRow = this.checkRowDimsRepetitive(rowIndex);
        if (resultRow != -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
            DynamicObject account = entryRowEntity.getDynamicObject("adjaccount");
            if (this.isExpenseBudget()) {
                DynamicInfoCollection customDims = this.getCustomDimsInfo();
                List customDimCtlKeys = customDims.getAllValOfOneProp("controlkey");
                if (customDimCtlKeys != null && customDimCtlKeys.size() > 0) {
                    this.getModel().setValue((String)customDimCtlKeys.get(customDimCtlKeys.size() - 1), null, rowIndex);
                } else {
                    this.getModel().setValue("adjaccount", null, rowIndex);
                }
            } else if (account != null) {
                Long accountId = account.getLong("id");
                Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
                if (accountMember == null) {
                    return;
                }
                Long datasetId = IDUtils.toLong((Object)accountMember.getDatasetId());
                DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)this.getCustomDimsInfoCache(), (Long)this.getModelId(), (Long)datasetId);
                List customDimCtlKeys = rowCustomDims.getAllValOfOneProp("controlkey");
                if (customDimCtlKeys != null && customDimCtlKeys.size() > 0) {
                    this.getModel().setValue((String)customDimCtlKeys.get(customDimCtlKeys.size() - 1), null, rowIndex);
                } else {
                    this.getModel().setValue("adjmetric", null, rowIndex);
                }
            }
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"BaseEbAdjustBillEditPlugin_new_01", (String)"epm-eb-formplugin", (Object[])new Object[]{resultRow + 1}));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        int delRowNum = e.getRowIndexs()[0];
        this.updateCompletedRowNum(true, true, delRowNum);
        this.getPageCache().put(ROW_NUM_CHANGE_CACHE, "true");
        String sameDimRowCache = this.getPageCache().get(COMPLETED_ROW_DIMS_CACHE);
        if (StringUtils.isNotEmpty((String)sameDimRowCache)) {
            Map rowDimMap = (Map)SerializationUtils.deSerializeFromBase64((String)sameDimRowCache);
            HashMap newRowDimMap = new HashMap(16);
            for (Map.Entry entry : rowDimMap.entrySet()) {
                int rowNum = (Integer)entry.getKey();
                if (rowNum == delRowNum) continue;
                if (rowNum > delRowNum) {
                    --rowNum;
                }
                newRowDimMap.put(rowNum, entry.getValue());
            }
            this.getPageCache().put(COMPLETED_ROW_DIMS_CACHE, SerializationUtils.serializeToBase64(newRowDimMap));
            this.changeBudgetData(-1);
        }
    }

    public QFilter getDimQFilter(String ctrlKey) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BaseEbAdjustBillEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("level", ">", (Object)1);
        qf.and(new QFilter("isleaf", "=", (Object)true));
        String dimNum = this.getCurrentDimNum(ctrlKey);
        if (ctrlKey.contains("custom")) {
            qf.and(new QFilter("dimension.number", "=", (Object)dimNum));
        } else if ("adjentity".equals(ctrlKey)) {
            qf.and(new QFilter("number", "!=", (Object)"RatePreset"));
        } else if ("version".equals(ctrlKey)) {
            qf.and("isactual", "!=", (Object)"1");
        } else if ("year".equals(ctrlKey)) {
            qf.and("longnumber", "like", (Object)"Year!AllYear!%");
        } else if ("changetype".equals(ctrlKey)) {
            HashSet<String> noIn = new HashSet<String>();
            noIn.add("Occupation");
            noIn.add("Execute");
            noIn.add("ActualChanges");
            noIn.add("DataIntegration");
            Map viewIds = this.getModelCache(modelId).getViewsByBusModel(this.getBizModelId());
            Member actualChangesMember = this.getModelCache(modelId).getMember(SysDimensionEnum.ChangeType.getNumber(), (Long)viewIds.get(SysDimensionEnum.ChangeType.getNumber()), "ActualChanges");
            if (ModelServiceHelper.isBGMDModel((Long)modelId) && actualChangesMember != null) {
                List actualChangesLeafMemNumbers = actualChangesMember.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toList());
                noIn.addAll(actualChangesLeafMemNumbers);
            }
            qf.and(new QFilter("number", "not in", noIn));
        }
        return qf;
    }

    public List<QFilter> getDimQFilters(String ctrlKey) {
        QFBuilder builder = new QFBuilder();
        long modelId = this.getModelId();
        if (!ctrlKey.contains("custom")) {
            if ("adjentity".equals(ctrlKey)) {
                builder.add("number", "!=", (Object)"RatePreset");
            } else if ("version".equals(ctrlKey)) {
                builder.add("isactual", "!=", (Object)"1");
            } else if (!"year".equals(ctrlKey) && "changetype".equals(ctrlKey)) {
                HashSet<String> noIn = new HashSet<String>();
                noIn.add("Occupation");
                noIn.add("Execute");
                noIn.add("ActualChanges");
                Map viewIds = this.getModelCache(modelId).getViewsByBusModel(this.getBizModelId());
                Member actualChangesMember = this.getModelCache(modelId).getMember(SysDimensionEnum.ChangeType.getNumber(), (Long)viewIds.get(SysDimensionEnum.ChangeType.getNumber()), "ActualChanges");
                if (ModelServiceHelper.isBGMDModel((Long)modelId) && actualChangesMember != null) {
                    List actualChangesLeafMemNumbers = actualChangesMember.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toList());
                    noIn.addAll(actualChangesLeafMemNumbers);
                }
                builder.add("number", "not in", noIn);
            }
        }
        return builder.toList();
    }

    public String getCurrentDimNumber(String controlKey) {
        return this.getCurrentDimNum(controlKey);
    }

    protected String getCurrentDimNum(String ctrlKey) {
        String dimNum = null;
        if (ctrlKey.contains("custom")) {
            String customDimStr = this.getPageCache().get(CUSTOM_DIMS_INFO_CACHE);
            DynamicInfoCollection customDims = null;
            customDims = StringUtils.isEmpty((String)customDimStr) ? this.getCustomDimsInfoCache() : (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
            dimNum = (String)customDims.getValOfOnePropByAnotherProp("number", "controlkey", (Object)ctrlKey);
        } else {
            for (SysDimensionEnum dimensionEnum : SysDimensionEnum.values()) {
                if (!ctrlKey.contains(dimensionEnum.getNumber().toLowerCase())) continue;
                dimNum = dimensionEnum.getNumber();
            }
        }
        return dimNum;
    }

    public DynamicInfoCollection getCustomDimsInfoCache() {
        return this.getCustomDimsInfo();
    }

    public abstract DynamicInfoCollection getCustomDimsInfo();

    public Long getModelId() {
        long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    public Long getBizModelId() {
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue("bizmodel");
        return bizModel == null ? 0L : bizModel.getLong("id");
    }

    public IModelCacheHelper getModelCache(Long modelId) {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    public abstract boolean checkAdjustment(String var1);

    public void cellDoubleClick(CellClickEvent arg0) {
        String fieldName = arg0.getFieldKey();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (fieldName.contains("adjustdata")) {
            int rowNum = arg0.getRow();
            String order = fieldName.replaceAll("[^0-9]", "");
            BigDecimal adjustdata = (BigDecimal)this.getModel().getValue("adjadjustdata" + order, rowNum);
            if (adjustdata.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8c03\u6574\u6570\uff0c\u518d\u6dfb\u52a0\u8c03\u6574\u539f\u56e0\u3002", (String)"BaseEbAdjustBillEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String reason = (String)this.getModel().getValue("adjadjexplain" + order, rowNum);
            FormShowParameter formShow = new FormShowParameter();
            formShow.setFormId("eb_adjustreason_show");
            formShow.getOpenStyle().setShowType(ShowType.Modal);
            formShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adjexplain"));
            if (billStatus != null && !"A".equals(billStatus)) {
                formShow.setCustomParam("lock", (Object)"true");
            }
            if (!"".equals(reason)) {
                formShow.setCustomParam("reason", (Object)reason);
            }
            this.getView().showForm(formShow);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        if ("adjexplain".equals(actionKey)) {
            Object reason = closedCallBackEvent.getReturnData();
            if (reason != null) {
                String reasonStr = String.valueOf(reason).trim();
                this.changeRowAdjReason(reasonStr);
            }
        } else if ("entryWin".equals(actionKey)) {
            Map entryWinMap = (Map)closedCallBackEvent.getReturnData();
            if (entryWinMap != null) {
                for (Map.Entry entry : entryWinMap.entrySet()) {
                    if (!"import".equals(entry.getKey())) continue;
                    this.initEntityRow((DynamicObjectCollection)entry.getValue());
                    List errors = this.getAdjustValidator("import").checkDimPerm();
                    if (!CollectionUtils.isNotEmpty((Collection)errors)) continue;
                    this.getView().showErrorNotification(String.join((CharSequence)"\n", errors));
                    return;
                }
            }
        } else if ("switchdept".equals(actionKey)) {
            String data = (String)closedCallBackEvent.getReturnData();
            if (data != null) {
                IDataModel dataModel = this.getModel();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                BasicInfoHelper.setFormInfo((IDataModel)dataModel, (IFormView)this.getView(), (Map)dataMap);
            }
        } else if ("importEntryEntity".equals(actionKey)) {
            Object returnDataObj = closedCallBackEvent.getReturnData();
            this.updateEntryShowAfterImport(returnDataObj);
            this.cachePeriodAdjustDataMap();
        } else if (this.isEntryGridKey(actionKey) && CollectionUtils.isNotEmpty((Collection)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            this.backMultipleSelect(returnData, actionKey);
        }
    }

    protected boolean isEntryGridKey(String actionKey) {
        String key = actionKey.replace("adj", "");
        for (String entryEntityKey : this.entryEntityKeys) {
            if (!key.equalsIgnoreCase(entryEntityKey)) continue;
            return true;
        }
        return false;
    }

    private void backMultipleSelect(ListSelectedRowCollection returnData, String dimensionKey) {
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        EntryGrid control = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = control.getSelectRows();
        int selectRow = selectRows[0];
        this.getModel().setValue(dimensionKey, returnData.get(0).getPrimaryKeyValue(), selectRow);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, selectRow);
        String dimensionNumber = dimensionKey.replace("adj", "");
        boolean backAccount = false;
        DynamicInfoCollection customDimInfo = null;
        Set<Object> ids = new HashSet(16);
        if (SysDimensionEnum.Account.getNumber().equalsIgnoreCase(dimensionNumber)) {
            backAccount = true;
            customDimInfo = this.getCustomDimsInfoCache();
        }
        if (returnData.size() > 1) {
            returnData.remove(0);
            for (int i = 0; i < returnData.size(); ++i) {
                ListSelectedRow returnDatum = returnData.get(i);
                int newEntryRow = this.getModel().insertEntryRow(ENTRY_ENTITY, selectRow + 1 + i);
                this.getModel().updateCache();
                ArrayList<String> keys = new ArrayList<String>(this.entryEntityKeys);
                if (backAccount) {
                    Member member = modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber()).getMember(null, IDUtils.toLong((Object)returnDatum.getPrimaryKeyValue()));
                    Long datasetId = member.getDatasetId();
                    List dimensionList = new ArrayList(10);
                    dimensionList = IDUtils.isNull((Long)datasetId) ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionList(datasetId);
                    ids = dimensionList.stream().filter(dimension -> !dimension.isPreset()).map(BaseCache::getId).collect(Collectors.toSet());
                }
                for (String entryEntityKey : keys) {
                    String key = "adj" + entryEntityKey;
                    if (entryEntityKey.equalsIgnoreCase(dimensionNumber)) {
                        this.getModel().setValue(dimensionKey, returnDatum.getPrimaryKeyValue(), newEntryRow);
                        continue;
                    }
                    if (!"Entity".equals(entryEntityKey) && !"Metric".equals(entryEntityKey) && backAccount) {
                        if (customDimInfo == null) continue;
                        for (DynamicInfoCollection.InfoObject info : customDimInfo.getValues()) {
                            String id;
                            String controlKey = (String)info.getValueByPropName("controlkey");
                            if (!controlKey.equals(key) || !ids.contains(IDUtils.toLong((Object)(id = (String)info.getValueByPropName("id"))))) continue;
                            this.getModel().setValue(key, entryRowEntity.get(key), newEntryRow);
                        }
                        continue;
                    }
                    this.getModel().setValue(key, entryRowEntity.get(key), newEntryRow);
                }
            }
        }
    }

    protected void updateEntryShowAfterImport(Object returnDataObj) {
        int seq;
        if (ApplicationTypeEnum.EB.getIndex().equals(((DynamicObject)this.getModel().getValue("model")).getString("reporttype"))) {
            this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)true);
            this.periodGroupKeys = new String[]{"period", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
            this.periodKey = "period";
        } else {
            this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)false);
            this.periodGroupKeys = new String[]{"budgetperiod", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
            this.periodKey = "budgetperiod";
        }
        if (returnDataObj == null) {
            return;
        }
        Map returnData = (Map)returnDataObj;
        Object data = returnData.get("data");
        Object hasErrorStr = returnData.get("hasError");
        boolean hasError = Boolean.parseBoolean(hasErrorStr.toString());
        if (data == null) {
            return;
        }
        this.changeDataB4SaveData();
        Map detailObjMap = (Map)data;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String periodsKey = "budgetperiods";
        String periodKey = "budgetperiod.id";
        if (AdjustUtil.isEBModel((long)this.getModelId())) {
            periodKey = "period.id";
            periodsKey = "multperiod";
        }
        Set<Long> periodIds = this.getAllPeriodNumber(dataEntity, periodsKey);
        Map customDimMap = AdjustImpExpUtil.getCustomDimMap((Long)this.getModelId(), (Long)this.getBizModelId());
        DynamicObjectCollection adjdetailentity = dataEntity.getDynamicObjectCollection(ADJ_DETAIL_ENTITY);
        HashMap<String, DynamicObject> customDimObjMap = new HashMap<String, DynamicObject>(adjdetailentity.size());
        for (DynamicObject dynamicObject2 : adjdetailentity) {
            String rowCustomDim = AdjustImpExpUtil.getRowCustomDim((DynamicObject)dynamicObject2, (Long)this.getModelId(), (Map)customDimMap);
            customDimObjMap.put(rowCustomDim, dynamicObject2);
        }
        int beginSize = seq = adjdetailentity.size();
        HashMap<Integer, Set<String>> errorRow = new HashMap<Integer, Set<String>>(detailObjMap.size());
        Map fileCustomDimMap = AdjustImpExpUtil.getRowCustomDimMap((Map)detailObjMap, (Long)this.getModelId(), (Map)customDimMap);
        for (Map.Entry entry : detailObjMap.entrySet()) {
            HashSet<String> errorMsgSet;
            String errorMsg;
            DynamicObject value = (DynamicObject)entry.getValue();
            String rowCustomDim = AdjustImpExpUtil.getRowCustomDim((DynamicObject)value, (Long)this.getModelId(), (Map)customDimMap);
            long periodId = value.getLong(periodKey);
            if (!periodIds.contains(periodId)) {
                String errorMsg2 = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53\u5185\u6240\u9009\u671f\u95f4\u3002", (String)"BaseEbAdjustBillEditPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                HashSet<String> errorMsgSet2 = new HashSet<String>(1);
                errorMsgSet2.add(errorMsg2);
                errorRow.put((Integer)entry.getKey() + 3, errorMsgSet2);
                continue;
            }
            List integers = (List)fileCustomDimMap.get(rowCustomDim);
            if (!customDimObjMap.containsKey(rowCustomDim)) {
                if (integers != null && integers.size() == 1) {
                    if (!this.checkImportMemberPerm(dataEntity, value, errorRow, Sets.newHashSet(), (Integer)entry.getKey())) continue;
                    value.set("seq", (Object)(++seq));
                    adjdetailentity.add((Object)value);
                    continue;
                }
                errorMsg = ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7ec4\u5408\u6570\u636e\u3002", (String)"BaseEbAdjustBillEditPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                errorMsgSet = new HashSet<String>(1);
                errorMsgSet.add(errorMsg);
                errorRow.put((Integer)entry.getKey() + 3, errorMsgSet);
                continue;
            }
            if (integers != null && integers.size() == 1) {
                DynamicObject dynamicObject3 = (DynamicObject)customDimObjMap.get(rowCustomDim);
                adjdetailentity.remove((Object)dynamicObject3);
                if (!this.checkImportMemberPerm(dataEntity, value, errorRow, Sets.newHashSet(), (Integer)entry.getKey())) continue;
                value.set("seq", dynamicObject3.get("seq"));
                adjdetailentity.add((Object)value);
                continue;
            }
            errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u5206\u5f55\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\u6570\u636e\u3002", (String)"BaseEbAdjustBillEditPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            errorMsgSet = new HashSet(1);
            errorMsgSet.add(errorMsg);
            errorRow.put((Integer)entry.getKey() + 3, errorMsgSet);
        }
        if (errorRow.size() > 0 && seq == beginSize) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BaseEbAdjustBillEditPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            AdjustImpExpUtil.downErrorFile((IFormView)this.getView(), (Map)returnData, errorRow, (boolean)hasError);
            return;
        }
        if (errorRow.size() > 0 && seq > beginSize) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BaseEbAdjustBillEditPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            AdjustImpExpUtil.downErrorFile((IFormView)this.getView(), (Map)returnData, errorRow, (boolean)hasError);
        } else if (errorRow.size() == 0 && seq > beginSize && hasError) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BaseEbAdjustBillEditPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            AdjustImpExpUtil.downErrorFile((IFormView)this.getView(), (Map)returnData, errorRow, (boolean)true);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BaseEbAdjustBillEditPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(this.getPeriodNameForHead());
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        List periodNums = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getString("fbasedataid.number")).collect(Collectors.toList());
        AdjustImpExpUtil.setHiddenEntryData((DynamicObjectCollection)adjdetailentity, (Long)this.getModelId(), (Map)customDimMap, (String)this.getPeriodNameForGroup(), periodNums);
        this.addEmptyData();
        this.backFillData(true);
        this.buildCustomDimInfo(-1);
        this.changeBudgetData(-1);
        this.changeDataB4SaveData();
        String billno = dataEntity.getString("billno");
        if (IDUtils.isNull((long)dataEntity.getLong("id")) || StringUtils.isEmpty((String)billno)) {
            ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
            String billNumber = service.getNumber(this.getView().getEntityId(), dataEntity, null);
            boolean exists = QueryServiceHelper.exists((String)this.getView().getEntityId(), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNumber)});
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u5de5\u5177\u83b7\u53d6\u5355\u636e\u7f16\u7801\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseEbAdjustBillEditPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue("billno", (Object)billNumber);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        this.getModel().setDataChanged(false);
        this.getView().updateView(ENTRY_ENTITY);
    }

    protected boolean checkImportMemberPerm(DynamicObject dataEntity, DynamicObject detail, Map<Integer, Set<String>> errorRow, Set<String> newHashSet, Integer rowIndex) {
        Long modelId = this.getModelId();
        List permControlDims = DimMembPermUtil.getPermControlDim((Long)modelId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Long userId = UserUtils.getUserId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<String> definedDim = new ArrayList<String>(10);
        ArrayList<String> permControlDim = new ArrayList<String>(10);
        List dimensionList = ModelUtil.isEbOrBgModel((Long)modelId) ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionListByBusModel(this.getBizModelId());
        for (Dimension dimension : dimensionList) {
            if (!dimension.isPreset()) {
                definedDim.add(dimension.getNumber());
            }
            if (!permControlDims.contains(dimension.getNumber())) continue;
            permControlDim.add(dimension.getNumber());
        }
        DimMemberPermChecker permChecker = DimMembPermHelper.getPermChecker((Long)modelId, (Long)this.getBizModelId(), permControlDim, (Long)userId, (DimMembPermType)DimMembPermType.WRITE);
        boolean includeDetail = false;
        for (String dimNum : permControlDim) {
            if (!SysDimensionEnum.Entity.getNumber().equals(dimNum) && !SysDimensionEnum.Account.getNumber().equals(dimNum) && SysDimensionEnum.getEnumByNumber((String)dimNum) != null && (ModelUtil.isEbOrBgModel((Long)modelId) || !SysDimensionEnum.Metric.getNumber().equals(dimNum))) continue;
            includeDetail = true;
            break;
        }
        if (includeDetail) {
            HashSet headNeedCheck = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.ChangeType.getNumber()});
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder dimensionStr = new StringBuilder();
            HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(permControlDim.size());
            for (String dimNum : permControlDim) {
                DynamicObject dyObj = null;
                if (SysDimensionEnum.getEnumByNumber((String)dimNum) != null) {
                    if (!(SysDimensionEnum.Entity.getNumber().equals(dimNum) || SysDimensionEnum.Account.getNumber().equals(dimNum) || SysDimensionEnum.Metric.getNumber().equals(dimNum))) {
                        if (headNeedCheck.contains(dimNum)) {
                            dyObj = dataEntity.getDynamicObject(dimNum.toLowerCase());
                        }
                    } else {
                        dyObj = detail.getDynamicObject(dimNum.toLowerCase());
                    }
                } else {
                    int index = definedDim.indexOf(dimNum) + 1;
                    dyObj = detail.getDynamicObject("customdim" + index);
                }
                if (dyObj == null) continue;
                MemberItem memberItem = new MemberItem(true, Long.valueOf(dyObj.getLong("id")));
                dimensionStr.append(dimNum).append(",");
                stringBuilder.append(dyObj.getString("number")).append(",");
                memberGroup.put(dimNum, memberItem);
            }
            boolean check = permChecker.check(memberGroup);
            if (!check) {
                newHashSet.add(ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e2d\u5b58\u5728\u65e0\u6743\u7684\u6210\u5458", (String)"BaseEbAdjustBillEditPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionStr.substring(0, dimensionStr.length() - 1), stringBuilder.substring(0, stringBuilder.length() - 1)}));
                errorRow.put(rowIndex + 3, newHashSet);
                return false;
            }
        }
        return true;
    }

    protected Set<Long> getAllPeriodNumber(DynamicObject dataEntity, String periodsKey) {
        DynamicObjectCollection periods = dataEntity.getDynamicObjectCollection(periodsKey);
        HashSet<Long> periodIds = new HashSet<Long>(periods.size());
        for (DynamicObject period : periods) {
            periodIds.add(period.getLong("fbasedataid_id"));
        }
        return periodIds;
    }

    public void initEntityRow(DynamicObjectCollection entryWin) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getPageCache().remove(COMPLETED_ROW_DIMS_CACHE);
        String customList = this.getPageCache().get(CUSTOM_DIMS_INFO_CACHE);
        int count = 0;
        if (StringUtils.isNotEmpty((String)customList)) {
            DynamicInfoCollection custom = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customList);
            count = custom.getValues().size();
        }
        this.setRowEntity(entryWin, count);
        this.getView().updateView(ENTRY_ENTITY);
        HashSet<Integer> rowNums = new HashSet<Integer>(entryWin.size());
        for (int i = 0; i < entryWin.size(); ++i) {
            rowNums.add(i);
        }
        this.getPageCache().put("CompletedRowNum", SerializationUtils.serializeToBase64(rowNums));
        if (!this.isExpenseBudget()) {
            this.buildCustomDimInfo(-1);
        }
        this.changeBudgetData(-1);
        this.getView().updateView(ENTRY_ENTITY);
    }

    public abstract void setRowEntity(DynamicObjectCollection var1, int var2);

    public final boolean billHeadOver() {
        return this.getAdjustValidator("other").billHeadOver();
    }

    public void changeRowAdjReason(String reason) {
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        String fieldKey = entry.getEntryState().getFocusField();
        int row = entry.getEntryState().getFocusRow();
        String order = fieldKey.replaceAll("[^0-9]", "");
        this.getModel().setValue("adjadjexplain" + order, (Object)reason, row);
        ArrayList<CellStyle> list = new ArrayList<CellStyle>(16);
        CellStyle cellStyle = StringUtils.isEmpty((String)reason) ? this.getAdjustDataStyle(row, order, true) : this.getAdjustDataStyle(row, order, false);
        list.add(cellStyle);
        entry.setCellStyle(list);
    }

    public CellStyle getAdjustDataStyle(int row, String order, boolean isClean) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(row);
        cellStyle.setFieldKey("adjadjustdata" + order);
        if (isClean) {
            cellStyle.setForeColor("#000000");
        } else {
            cellStyle.setForeColor("#007fff");
        }
        return cellStyle;
    }

    public void cellClick(CellClickEvent arg0) {
    }

    public Long getAdjustRuleId() {
        DynamicObject adjustRule = (DynamicObject)this.getModel().getValue("adjustrule");
        return adjustRule == null ? 0L : adjustRule.getLong("id");
    }

    public String getBizModelKey() {
        return "dataset";
    }

    public void showMetricAndCustomDimValue(Long accountId, int rowNum) {
    }

    public abstract List<Map<String, String>> getDimList(Set<Integer> var1, boolean var2);

    protected void setNeedUpdateView(boolean needUpdate) {
        this.needUpdateViewCount = needUpdate ? --this.needUpdateViewCount : ++this.needUpdateViewCount;
    }

    protected boolean needUpdateView() {
        return this.needUpdateViewCount == 0;
    }

    protected void setNeedChangeProperty(boolean needChange) {
        this.needChangePropertyCount = needChange ? --this.needChangePropertyCount : ++this.needChangePropertyCount;
    }

    protected boolean needChangeProperty() {
        return this.needChangePropertyCount == 0;
    }

    protected Boolean isCopyNew() {
        return this.getPageCache().get("isCopyNew") != null;
    }

    public boolean isCheckModel() {
        IFormView formView = this.getView();
        if (formView == null) {
            return true;
        }
        String entityId = ((BaseView)formView).getFormId();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityId);
        if (formConfig != null) {
            List plugins = formConfig.getPlugins();
            try {
                for (Plugin plugin : plugins) {
                    Object instance;
                    String className = plugin.getClassName();
                    if (className == null || !plugin.isEnabled() || !((instance = TypesContainer.createInstance((String)className)) instanceof EpmCustomInterface)) continue;
                    EpmCustomInterface customInterface = (EpmCustomInterface)instance;
                    return !customInterface.isCheckOrg();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    protected Map<String, Set<Long>> getCurrMembers(String dimensionStr) {
        HashMap<String, Set<Long>> combMembers = new HashMap<String, Set<Long>>();
        String customDimStr = this.getPageCache().get(CUSTOM_DIMS_INFO_CACHE);
        if (customDimStr == null) {
            return combMembers;
        }
        DynamicInfoCollection customDims = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
        List customControlKey = new ArrayList(10);
        Set refDimGroupNums = DimMembPermHelper.getRefDimGroupNums((Long)this.getModelId(), (String)dimensionStr);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        ArrayList dimgroups = new ArrayList(refDimGroupNums.size());
        modelCacheHelper.getDimensionList().forEach(dimension -> {
            if (refDimGroupNums.contains(dimension.getNumber())) {
                dimgroups.add(dimension.getNumber());
            }
        });
        boolean isHeadDimension = SysDimensionEnum.DataType.getNumber().equals(dimensionStr) || SysDimensionEnum.Version.getNumber().equals(dimensionStr) || SysDimensionEnum.ChangeType.getNumber().equals(dimensionStr);
        for (String refDimGroupNum : dimgroups) {
            if (SysDimensionEnum.DataType.getNumber().equals(refDimGroupNum) || SysDimensionEnum.Version.getNumber().equals(refDimGroupNum) || SysDimensionEnum.ChangeType.getNumber().equals(refDimGroupNum)) {
                this.putMemberId(combMembers, refDimGroupNum, (DynamicObject)this.getModel().getValue(refDimGroupNum.toLowerCase()));
                continue;
            }
            if (isHeadDimension) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                if (entryEntity == null) {
                    return null;
                }
                for (DynamicObject rowObj : entryEntity) {
                    if (SysDimensionEnum.Entity.getNumber().equals(refDimGroupNum) || SysDimensionEnum.Account.getNumber().equals(refDimGroupNum) || SysDimensionEnum.Metric.getNumber().equals(refDimGroupNum)) {
                        this.putMemberId(combMembers, refDimGroupNum, rowObj.getDynamicObject("adj" + refDimGroupNum.toLowerCase()));
                        continue;
                    }
                    customControlKey = customDims.getAllValOfOneProp("controlkey");
                    Long accountId = rowObj.getLong("adjaccount.id");
                    if (IDUtils.isNotNull((Long)accountId)) {
                        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
                        if (accountMember == null) continue;
                        Long datasetId = IDUtils.toLong((Object)accountMember.getDatasetId());
                        DynamicInfoCollection rowCustomDim = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)this.getModelId(), (Long)datasetId);
                        customControlKey = rowCustomDim.getAllValOfOneProp("controlkey");
                    }
                    for (Object key : customControlKey) {
                        String longnumber;
                        DynamicObject customDimObj = (DynamicObject)rowObj.get(String.valueOf(key));
                        if (customDimObj == null || !(longnumber = customDimObj.getString("longnumber")).contains(refDimGroupNum)) continue;
                        this.putMemberId(combMembers, longnumber.split("!")[0], customDimObj);
                    }
                }
                continue;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            if (rowIndex < 0) {
                return null;
            }
            DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
            if (rowObj == null) continue;
            if (SysDimensionEnum.Entity.getNumber().equals(refDimGroupNum) || SysDimensionEnum.Account.getNumber().equals(refDimGroupNum) || SysDimensionEnum.Metric.getNumber().equals(refDimGroupNum)) {
                this.putMemberId(combMembers, refDimGroupNum, rowObj.getDynamicObject("adj" + refDimGroupNum.toLowerCase()));
                continue;
            }
            customControlKey = customDims.getAllValOfOneProp("controlkey");
            Long accountId = rowObj.getLong("adjaccount.id");
            if (IDUtils.isNotNull((Long)accountId)) {
                Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
                if (accountMember == null) continue;
                Long datasetId = IDUtils.toLong((Object)accountMember.getDatasetId());
                DynamicInfoCollection rowCustomDim = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)this.getModelId(), (Long)datasetId);
                customControlKey = rowCustomDim.getAllValOfOneProp("controlkey");
            }
            for (Object key : customControlKey) {
                String longnumber;
                DynamicObject customDimObj = (DynamicObject)rowObj.get(String.valueOf(key));
                if (customDimObj == null || !(longnumber = customDimObj.getString("longnumber")).contains(refDimGroupNum)) continue;
                this.putMemberId(combMembers, longnumber.split("!")[0], customDimObj);
            }
        }
        return combMembers;
    }

    private void putMemberId(Map<String, Set<Long>> memberMap, String dimensionNumber, DynamicObject member) {
        if (memberMap != null && dimensionNumber != null && member != null) {
            Set<Long> longs = memberMap.get(dimensionNumber);
            if (longs == null) {
                longs = new HashSet<Long>(16);
            }
            longs.add(member.getLong("id"));
            memberMap.put(dimensionNumber, longs);
        }
    }

    protected void openBudgetForm() {
    }

    protected Set<Integer> getSameDimRowNums(int rowNum) {
        return null;
    }

    protected Set<Integer> getBgmCompletedRowNum() {
        Set<Integer> completedRows = new HashSet<Integer>(16);
        String sameDimRowCache = this.getPageCache().get(COMPLETED_ROW_DIMS_CACHE);
        if (StringUtils.isNotEmpty((String)sameDimRowCache)) {
            Map rowDimMap = (Map)SerializationUtils.deSerializeFromBase64((String)sameDimRowCache);
            completedRows = rowDimMap.keySet();
        }
        return completedRows;
    }

    protected void putControlDimCache() {
        QFilter modelQF = new QFilter("model", "=", (Object)this.getModelId());
        QFilter bizModelQF = new QFilter("businessmodel", "=", (Object)this.getBizModelId());
        boolean exists = QueryServiceHelper.exists((String)"eb_bgmcontroldimension", (QFilter[])new QFilter[]{modelQF, bizModelQF});
        this.getPageCache().put(IS_EXIST_CONTROL_DIM, exists ? "true" : "false");
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public DynamicObjectCollection getEntryEntity(String prop) {
        return this.getModel().getEntryEntity(prop);
    }

    public Object getValue(String prop) {
        return this.getModel().getValue(prop);
    }

    public void setEnable(Boolean paramBoolean, int paramInt, String ... paramVarArgs) {
        this.getView().setEnable(paramBoolean, paramInt, paramVarArgs);
    }

    public void singleValidate(String opType) {
        AdjustBillValidator.singleValidate((IDataModel)this.getModel(), this.getBgmCompletedRowNum(), (String)opType);
    }

    public void batchCreateNewEntryRow(String prop, int rowNum) {
        this.getModel().batchCreateNewEntryRow(prop, rowNum);
    }

    public void deleteEntryData(String prop) {
        this.getModel().deleteEntryData(prop);
    }

    public DynamicObject getEntryRowEntity(String prop, int rowindex) {
        return this.getModel().getEntryRowEntity(prop, rowindex);
    }

    public boolean isExistControlDim() {
        return Boolean.parseBoolean(this.getPageCache().get(IS_EXIST_CONTROL_DIM));
    }

    public String getDimMemsForRow(DynamicObject rowObj) {
        return "";
    }

    public Map<Integer, String> getRowDimMap() {
        String sameDimRowCache = this.getPageCache().get(COMPLETED_ROW_DIMS_CACHE);
        HashMap<Integer, String> rowDimMap = StringUtils.isEmpty((String)sameDimRowCache) ? new HashMap<Integer, String>(16) : (HashMap<Integer, String>)SerializationUtils.deSerializeFromBase64((String)sameDimRowCache);
        return rowDimMap;
    }
}

