/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bizRuleGroup2;

import com.google.common.collect.Lists;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.pojo.DynamicAlertPojo;
import kd.epm.eb.common.rule.edit.RuleManageRowPojo;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.DynamicAlertUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;
import kd.epm.eb.formplugin.rulemanage.RuleJsUtils;
import kd.epm.eb.formplugin.rulemanage.RuleManageQueryOp;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections4.CollectionUtils;

public class BizRuleManagePlatformPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BizRuleManagePlatformPlugin.class);
    public static final String MODEL = "model";
    public static final String BUSS_MODEL = "bussmodel";
    public static final String RULEEXECSEQ_TOOLBARAP = "ruleexecseqtoolbarap";
    public static final String GET_RULE_EXEC_SEQ = "get_rule_exec_seq";
    public static final String CHECK_RULESCOPE = "checkrulescope";
    public static final String DEL_LOCKRULE = "dellockrule";
    public static final String RULE_EXEC_SEQ_JSON = "rule_exec_seq_json";
    public static final String RULE_NUMBER = "rulenumber";
    public static final String RULE_NAME = "rulename";
    public static final String MUL_RULE = "mulrule";
    public static final String RULE_ID = "ruleid";
    public static final String GET_RULE_RANGE = "get_rule_range";
    public static final String RULE_RANGE_JSON = "rule_range_json";
    public static final String RULE_RANGE_TOOL_BAR_AP = "rulerangetoolbarap";
    public static final String CREATE_RULE_CASE = "createrulecase";
    public static final String EXEC_RULE_CASE_TOOL_BAR_AP = "execrulecasetoolbarap";
    public static final String EXEC_RULE_CASE_JSON = "exec_rule_case_json";
    public static final String EXEC_RULE_CASE = "exec_rule_case";
    public static final String CHECK_CROSS_VIEW_RULE = "checkcrossviewrule";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{RULEEXECSEQ_TOOLBARAP, RULE_RANGE_TOOL_BAR_AP, EXEC_RULE_CASE_TOOL_BAR_AP});
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bussModel = (BasedataEdit)this.getControl(BUSS_MODEL);
        bussModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulRule = (MulBasedataEdit)this.getControl(MUL_RULE);
        mulRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKeyString;
        super.itemClick(evt);
        switch (itemKeyString = evt.getItemKey()) {
            case "get_rule_exec_seq": {
                try {
                    this.getRuleExecSeq();
                    break;
                }
                catch (Exception e) {
                    log.error("getRuleExecSeq-error:", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            case "get_rule_range": {
                try {
                    this.getRuleRange();
                    break;
                }
                catch (Exception e) {
                    log.error("getRuleExecSeq-error:", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            case "createrulecase": {
                try {
                    this.createRuleCase();
                    break;
                }
                catch (Exception e) {
                    log.error("createRuleCase-error:", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            case "checkrulescope": {
                try {
                    this.checkRuleScope();
                    break;
                }
                catch (Exception e) {
                    log.error("createRuleCase-error:", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            case "dellockrule": {
                try {
                    this.delLockRule();
                    break;
                }
                catch (Exception e) {
                    log.error("delLockRule-error:", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            case "exec_rule_case": {
                try {
                    this.execRuleCase();
                    break;
                }
                catch (Exception e) {
                    log.error("execRuleCase-error:", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            case "checkcrossviewrule": {
                try {
                    this.checkCrossViewRule();
                    break;
                }
                catch (Exception e) {
                    log.error("checkCrossViewRule-error:", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    private void checkCrossViewRule() {
        Long modelId = this.getModelId();
        long bussModelId = this.getBussModelId();
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"eb_bizruleset", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizctrlrange", "=", (Object)bussModelId)});
        if (rules == null || rules.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u6ca1\u6709\u89c4\u5219\u3002", (String)"BizRuleManagePlatformPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Set ruleIdSet = rules.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        List ruleManageRowPojoList = RuleManageQueryOp.getRuleManageRowPojoList(ruleIdSet);
        if (CollectionUtils.isEmpty((Collection)ruleManageRowPojoList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u6ca1\u6709\u89c4\u5219\u3002", (String)"BizRuleManagePlatformPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<String> crossViewRuleNumberSet = new HashSet<String>(ruleManageRowPojoList.size());
        for (int i = 0; i < ruleManageRowPojoList.size(); ++i) {
            HashMap<String, Set<Long>> dimViewMap = new HashMap<String, Set<Long>>(16);
            RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)ruleManageRowPojoList.get(i);
            try {
                RuleJsUtils.checkRuleManageRowPojoDifferentView(modelCache, i, dimViewMap, ruleManageRowPojo);
                continue;
            }
            catch (Exception e2) {
                crossViewRuleNumberSet.add(ruleManageRowPojo.getNumberString());
            }
        }
        if (crossViewRuleNumberSet.size() > 0) {
            DynamicAlertPojo dynamicAlertPojo = new DynamicAlertPojo();
            dynamicAlertPojo.setPageTitleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"bizRuleGroupListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            dynamicAlertPojo.setDescriptionString(ResManager.loadKDString((String)"\u4ee5\u4e0b\u89c4\u5219\u8de8\u89c6\u56fe\uff0c\u8bf7\u4fee\u6539\u5bf9\u5e94\u89c4\u5219", (String)"BizRuleManagePlatformPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            dynamicAlertPojo.setMessageString(String.join((CharSequence)"\n", crossViewRuleNumberSet));
            dynamicAlertPojo.setOperationTypeString("know");
            DynamicAlertUtils.openDynamicAlert((IFormView)this.getView(), (DynamicAlertPojo)dynamicAlertPojo);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u65e0\u8de8\u89c6\u56fe\u7684\u89c4\u5219\u3002", (String)"BizRuleManagePlatformPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void execRuleCase() {
        String paramStr = (String)this.getModel().getValue(EXEC_RULE_CASE_JSON);
        if (StringUtils.isEmpty((String)paramStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
            return;
        }
        Map param = (Map)JSONUtils.parse((String)paramStr, Map.class);
        Object result = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"RuleExecCaseService", (String)"executeRuleExecCase", (Object[])new Object[]{param});
        if (result instanceof ApiResult) {
            ApiResult apiResult = (ApiResult)result;
            if (apiResult.getSuccess()) {
                this.getView().showSuccessNotification(apiResult.getMessage());
            } else {
                this.getView().showTipNotification(apiResult.getMessage());
            }
        }
    }

    private void createRuleCase() {
        Long model = this.getModelId();
        Long bizModel = this.getBussModelId();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u751f\u6210\u6267\u884c\u65b9\u6848\u7684\u89c4\u5219", (String)"RuleManagePlugin3_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List bizRuleIds = entryEntity.stream().map(e -> e.getLong(RULE_ID)).collect(Collectors.toList());
        RuleCaseService.getInstance().createExecCaseByOrder(bizRuleIds, model, bizModel);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u89c4\u5219\u6267\u884c\u65b9\u6848\u6210\u529f", (String)"BizRuleManagePlatformPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void getRuleRange() {
        long bussModelId = this.getBussModelId();
        List allEnableRuleDto = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bussModelId)).getRuleDtoList();
        if (allEnableRuleDto.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5df2\u53d1\u5e03\u89c4\u5219", (String)"BizRuleManagePlatformPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulRules = (DynamicObjectCollection)this.getModel().getValue(MUL_RULE);
        if (mulRules == null || mulRules.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219", (String)"BizRuleManagePlatformPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Set mulRuleIds = mulRules.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
        List mulRuleDtoList = allEnableRuleDto.stream().filter(e -> mulRuleIds.contains(e.getId())).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        for (RuleDto ruleDto : mulRuleDtoList) {
            stringBuilder.append(JSONUtils.toString((Object)ruleDto)).append("\n");
        }
        this.getModel().setValue(RULE_RANGE_JSON, (Object)stringBuilder.toString());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u6790\u89c4\u5219\u8303\u56f4\u6210\u529f", (String)"BizRuleManagePlatformPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void getRuleExecSeq() {
        long bussModelId = this.getBussModelId();
        List allEnableRuleDto = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bussModelId)).getRuleDtoList();
        if (allEnableRuleDto.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5df2\u53d1\u5e03\u89c4\u5219", (String)"BizRuleManagePlatformPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        MutableGraph graph = RuleGraphService.getInstance().getDagGraphByBizmodel(allEnableRuleDto);
        ArrayList sortList = Lists.newArrayList();
        while (!graph.nodes().isEmpty()) {
            Set zeroNodes = RuleGraphService.getInstance().getZeroNodes((Graph)graph);
            sortList.addAll(zeroNodes);
            zeroNodes.forEach(arg_0 -> ((MutableGraph)graph).removeNode(arg_0));
        }
        List collect = sortList.stream().map(GraphNode::getNodeNumber).collect(Collectors.toList());
        this.getModel().setValue(RULE_EXEC_SEQ_JSON, (Object)StringUtils.join(collect, (String)"\n"));
        this.getModel().deleteEntryData("entryentity");
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        for (GraphNode obj : sortList) {
            int newRowIndex = dataModel.createNewEntryRow("entryentity");
            dataModel.setValue(RULE_NUMBER, (Object)obj.getNodeNumber(), newRowIndex);
            dataModel.setValue(RULE_NAME, (Object)obj.getNodeName(), newRowIndex);
            dataModel.setValue(RULE_ID, (Object)obj.getNodeId(), newRowIndex);
        }
        dataModel.endInit();
        this.getView().updateView("entryentity");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u89c4\u5219\u6267\u884c\u987a\u5e8f\u6210\u529f", (String)"BizRuleManagePlatformPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void checkRuleScope() {
        Long modelId = this.getModelId();
        List bizmodelIds = BusinessModelServiceHelper.getInstance().getBusModelIdsByModelId(modelId);
        if (CollectionUtils.isEmpty((Collection)bizmodelIds)) {
            return;
        }
        for (Long bussModelId : bizmodelIds) {
            List ruleDtoList = RuleService.getInstance().listRule(bussModelId, Boolean.valueOf(true), null);
            RuleUtils.checkScopeOfApplicationOverlap(ruleDtoList, null);
        }
    }

    private void delLockRule() {
        Long modelId = this.getModelId();
        Long bizModel = this.getBussModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(MODEL, "=", (Object)modelId);
        qfBuilder.add("bizmodel", "=", (Object)bizModel);
        DynamicObjectCollection caseList = QueryServiceHelper.query((String)"bgmd_datalockcase", (String)"id", (QFilter[])qfBuilder.toArray());
        for (DynamicObject caseObj : caseList) {
            DataLockService.getInstance().dropLockRule(Long.valueOf(caseObj.getLong("id")), bizModel, modelCache);
        }
        DataLockService.getInstance().clearCache(modelId, bizModel);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u591a\u7ef4\u9501\u5b9a\u89c4\u5219\u6210\u529f\u3002", (String)"BizRuleManagePlatformPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private long getBussModelId() {
        DynamicObject bussModel = (DynamicObject)this.getModel().getValue(BUSS_MODEL);
        if (bussModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6a21\u578b", (String)"BizRuleManagePlatformPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return bussModel.getLong("id");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String nameString;
        switch (nameString = e.getProperty().getName()) {
            case "model": {
                this.getModel().setValue(BUSS_MODEL, null);
                this.getModel().setValue(RULE_EXEC_SEQ_JSON, null);
                this.getModel().deleteEntryData("entryentity");
                this.getModel().setValue(MUL_RULE, null);
                this.getModel().setValue(RULE_RANGE_JSON, null);
                break;
            }
            case "bussmodel": {
                this.getModel().setValue(RULE_EXEC_SEQ_JSON, null);
                this.getModel().deleteEntryData("entryentity");
                this.getModel().setValue(MUL_RULE, null);
                this.getModel().setValue(RULE_RANGE_JSON, null);
                break;
            }
            case "mulrule": {
                this.getModel().setValue(RULE_RANGE_JSON, null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            PluginUtils.setModelFilter((BeforeF7SelectEvent)e, (IFormView)this.getView());
        } else if (BUSS_MODEL.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(BUSS_MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if (MUL_RULE.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
            qFilter.and(new QFilter("bizctrlrange", "=", (Object)this.getBussModelId()));
            qFilter.and(new QFilter("status", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public Long getModelId() {
        DynamicObject model = this.getSelModel();
        if (model != null) {
            return model.getLong("id");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BizRuleManagePlatformPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public DynamicObject getSelModel() {
        Object obj = this.getModel().getValue(MODEL);
        if (obj instanceof DynamicObject) {
            return (DynamicObject)obj;
        }
        return null;
    }
}

