/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.form.operate.flowchart.AbstractViewFlowchart;
import kd.epm.eb.business.applybill.util.ApplyBillAttachmentHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applybill.util.BgApplySplitUtil;
import kd.epm.eb.business.applybill.util.CustomSelectUtil;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.DecpRowData;
import kd.epm.eb.common.applybill.DecpStepData;
import kd.epm.eb.common.applybill.DecpStepManager;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillEntry;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.centralapproval.CustomSelectGroup;
import kd.epm.eb.common.centralapproval.CustomShowParam;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.applybill.util.BgApplyLockUtils;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.olap.transaction.OlapTX;
import kd.epm.eb.olap.transaction.OlapTXHandle;

public class ApproveBillListNew
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TREE_ENTRY_ENTITY = "treeentryentity";
    private static final String MODEL = "model";
    private static final String TOOLBAR_AP = "toolbarap";
    private static final String CACHE_SELECT_ROW = "cache_selectRow";
    private static final Log log = LogFactory.getLog(ApproveBillListNew.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addF7SelectListener((BeforeF7SelectListener)this, new String[]{MODEL});
        this.addItemClickListeners(new String[]{TOOLBAR_AP});
    }

    public void afterCreateNewData(EventObject e) {
        this.initModel();
        this.initData();
        this.setEntryGridEnable();
        this.getModel().setDataChanged(true);
        this.getView().updateView(TREE_ENTRY_ENTITY);
    }

    private void initModel() {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (modelId != null && modelId != 0L) {
            this.getModel().setValue(MODEL, (Object)modelId);
        }
    }

    private void initData() {
        long beforeTime = System.currentTimeMillis();
        List<Map<String, Object>> initData = this.getInitData();
        if (initData.size() == 0) {
            return;
        }
        long time = System.currentTimeMillis();
        log.info("getInitData(initData) ---- costTime: " + (time - beforeTime) + "ms");
        Collections.sort(initData, Comparator.comparing(objectMap -> objectMap.getOrDefault("billno", ""), Comparator.nullsLast(Comparator.reverseOrder())));
        int[] entryRows = this.getModel().batchCreateNewEntryRow(TREE_ENTRY_ENTITY, initData.size());
        HashSet<Integer> rows = new HashSet<Integer>(16);
        for (int i = 0; i < initData.size(); ++i) {
            int newEntryRow = entryRows[i];
            Map<String, Object> dataMap = initData.get(i);
            dataMap.forEach((key, value) -> {
                if (!"splitcentralizapproveno".equals(key)) {
                    this.getModel().setValue(key, value, newEntryRow);
                }
            });
            if (!"\u2714".equals(dataMap.get("splitcentralizapprove"))) continue;
            rows.add(newEntryRow);
        }
        log.info("setValue(initData) ---- costTime: " + (System.currentTimeMillis() - time) + "ms");
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        this.setTreeEntryEntityStyle(rows);
        AbstractGrid.GridState entryState = entryGrid.getEntryState();
        entryState.setCurrentPageIndex(Integer.valueOf(1));
        entryGrid.bindData(null);
    }

    private void setTreeEntryEntityStyle(Set<Integer> rows) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(16);
        for (Integer i : rows) {
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey("splitcentralizapprove");
            cellStyle.setForeColor("green");
            cellStyle.setRow(i.intValue());
            cellStyles.add(cellStyle);
        }
        entryGrid.setCellStyle(cellStyles);
    }

    private List<Map<String, Object>> getInitData() {
        HashMap<String, Object> data;
        ArrayList<Map<String, Object>> initData = new ArrayList<Map<String, Object>>(16);
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6709\u6743\u9650\u7684\u4f53\u7cfb\u3002", (String)"ApproveBillListNew_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return initData;
        }
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        ApproveBillUtil instance = ApproveBillUtil.getInstance();
        List approveBills = instance.getApproveBills(qFilter, "id desc");
        if (CollectionUtils.isEmpty((Collection)approveBills)) {
            return initData;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        CentralAppBillService appBillService = CentralAppBillService.getInstance();
        HashSet<Long> parentIds = new HashSet<Long>(16);
        HashMap approveBillHashMap = new HashMap(16);
        for (ApproveBill approveBill : approveBills) {
            Map dimViewMap = modelCacheHelper.getViewsByBusModel(approveBill.getBizModelId());
            data = new HashMap<String, Object>(16);
            List approveBillEntries = approveBill.getApproveBillEntries();
            HashSet centralEntities = new HashSet(16);
            HashSet entities = new HashSet(16);
            HashSet sourceBillNos = new HashSet(16);
            boolean isCollectAudit = instance.isCollectAudit(approveBill);
            approveBillEntries.forEach(e -> {
                appBillService.setEntryEntityField(e, centralEntities, modelCacheHelper, Boolean.valueOf(true), dimViewMap);
                appBillService.setEntryEntityField(e, entities, modelCacheHelper, Boolean.valueOf(false), dimViewMap);
                appBillService.setBillNo(e, sourceBillNos, Boolean.valueOf(isCollectAudit));
            });
            data.put("billno", approveBill.getBillNo());
            data.put("collectentity", String.join((CharSequence)";", centralEntities));
            data.put("auditentity", String.join((CharSequence)";", entities));
            data.put("source", String.join((CharSequence)";", sourceBillNos));
            approveBillHashMap.put(approveBill.getId(), data);
            if (!IDUtils.isNotNull((Long)approveBill.getParentId())) continue;
            parentIds.add(approveBill.getParentId());
        }
        Map processStatus = WorkflowServiceHelper.getBizProcessStatus((String[])((String[])approveBills.stream().map(e -> e.getId().toString()).toArray(String[]::new)));
        Map<String, String> auditMap = null;
        boolean isOpen = ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG069);
        if (!isOpen) {
            auditMap = this.getAuditMap(processStatus);
        }
        for (ApproveBill approveBill : approveBills) {
            Map billData;
            data = new HashMap(16);
            data.put("pid", approveBill.getParentId());
            data.put("id", approveBill.getId());
            data.put("pkid", approveBill.getId());
            data.put("billno", approveBill.getBillNo());
            data.put("billname", approveBill.getName());
            data.put("billstatus", approveBill.getBillStatus().getNumber());
            data.put("reportentity", approveBill.getReportEntity());
            data.put("modifier", approveBill.getModifier());
            data.put("submitdate", approveBill.getCreateDate());
            data.put("lastmodifydate", approveBill.getModifyDate());
            Long dataId = approveBill.getId();
            if (parentIds.contains(approveBill.getId()) && approveBill.isHasSubitems()) {
                data.put("splitcentralizapprove", "\u2714");
            }
            if (IDUtils.isNotNull((Long)approveBill.getParentId())) {
                dataId = approveBill.getParentId();
                if (IDUtils.isNotNull((Long)approveBill.getCentralorg())) {
                    Map dimViewMap = modelCacheHelper.getViewsByBusModel(approveBill.getBizModelId());
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber()), approveBill.getCentralorg());
                    if (member != null) {
                        String deptName = member.getName();
                        data.put("splitcentralizapprove", deptName);
                    }
                }
            }
            if ((billData = (Map)approveBillHashMap.get(dataId)) != null) {
                if (IDUtils.isNotNull((Long)approveBill.getParentId())) {
                    data.put("source", billData.get("billno"));
                } else {
                    data.put("source", billData.get("source"));
                }
                data.put("collectentity", billData.get("collectentity"));
                data.put("auditentity", billData.get("auditentity"));
            }
            if (!isOpen) {
                String auditInfo = auditMap.get(approveBill.getId().toString());
                if (StringUtils.isNotEmpty((String)auditInfo)) {
                    String[] auditArr = auditInfo.split("!");
                    data.put("curnode", auditArr[0]);
                    data.put("dealer", auditArr[1]);
                }
            } else {
                List<IApprovalRecordItem> recordItems = this.getInApproveRecords(approveBill);
                List<IApprovalRecordItem> filterItems = this.getItemsByCurUser(recordItems);
                if (!appBillService.isModelAdmin(modelId) && filterItems.size() == 0 && !this.isReporter(approveBill)) continue;
                String dealer = this.getDealer(recordItems);
                HashSet<String> dealNodes = new HashSet<String>(16);
                List bizProcessStatuses = (List)processStatus.get(approveBill.getId().toString());
                HashSet<String> currentNodes = new HashSet<String>(16);
                String currentNodeName = this.getCurrentNode(recordItems);
                if (bizProcessStatuses != null && bizProcessStatuses.size() != 0) {
                    String[] nodes;
                    for (String node : nodes = ((BizProcessStatus)bizProcessStatuses.get(0)).getCurrentNodeName().split(",")) {
                        if (!StringUtils.isEmpty((String)dealer) && (!StringUtils.isNotEmpty((String)dealer) || dealer.contains(node))) continue;
                        dealNodes.add(node);
                        currentNodes.add(node);
                    }
                }
                if (StringUtils.isEmpty((String)currentNodeName)) {
                    if (currentNodes.size() != 0) {
                        data.put("curnode", String.join((CharSequence)"; ", currentNodes));
                    }
                } else {
                    data.put("curnode", currentNodes.size() == 0 ? currentNodeName : currentNodeName + "; " + String.join((CharSequence)"; ", currentNodes));
                }
                if (StringUtils.isEmpty((String)dealer)) {
                    if (dealNodes.size() != 0) {
                        data.put("dealer", String.join((CharSequence)"; ", dealNodes));
                    }
                } else {
                    data.put("dealer", dealNodes.size() == 0 ? dealer : dealer + "; " + String.join((CharSequence)"; ", dealNodes));
                }
            }
            initData.add(data);
        }
        return initData;
    }

    private boolean isReporter(ApproveBill approveBill) {
        Long userId = this.getUserId();
        return userId.equals(approveBill.getCreator());
    }

    private List<IApprovalRecordItem> getItemsByCurUser(List<IApprovalRecordItem> recordItems) {
        ArrayList<IApprovalRecordItem> items = new ArrayList<IApprovalRecordItem>(16);
        if (recordItems.size() != 0) {
            for (IApprovalRecordItem recordItem : recordItems) {
                Long userId = recordItem.getUserId();
                if (userId == null || !userId.equals(this.getUserId())) continue;
                items.add(recordItem);
            }
        }
        return items;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if (key.equals(MODEL)) {
            PluginUtils.setModelFilter((BeforeF7SelectEvent)event, (IFormView)this.getView());
        }
    }

    private Set<String> getPlanNumsInWorkFlow(List<IApprovalRecordItem> filterItems, Long pkId) {
        HashSet<String> planNums = new HashSet<String>(16);
        Set activityIds = filterItems.stream().map(IApprovalRecordItem::getActivityId).collect(Collectors.toSet());
        List nextNode = WorkflowServiceHelper.getNextUserTaskNodeByBusinessKey((String)String.valueOf(pkId));
        if (nextNode == null || nextNode.size() == 0) {
            return planNums;
        }
        FlowElement flowElement = (FlowElement)((Map)nextNode.get(0)).get("nextNode");
        if (flowElement == null) {
            return planNums;
        }
        FlowElementsContainer parentContainer = flowElement.getParentContainer();
        List variables = ((Process)parentContainer).getVariables();
        List incomingFlows = null;
        incomingFlows = flowElement instanceof AuditTask ? ((AuditTask)flowElement).getIncomingFlows() : (flowElement instanceof EndEvent ? ((EndEvent)flowElement).getIncomingFlows() : ((CallActivity)flowElement).getIncomingFlows());
        for (SequenceFlow incomingFlow : incomingFlows) {
            FlowElement sourceFlowElement = incomingFlow.getSourceFlowElement();
            String activityId = sourceFlowElement.getId();
            if (!activityIds.contains(activityId)) continue;
            planNums.addAll(this.getPlansInVariable(sourceFlowElement.getNumber(), variables));
        }
        return planNums;
    }

    private Set<String> getPlansInVariable(String number, List<Variable> variables) {
        HashSet<String> retPlans = new HashSet<String>(16);
        Object planObj = null;
        for (Variable variable : variables) {
            if (!number.equals(variable.getName())) continue;
            planObj = variable.getDefaultValue();
            break;
        }
        if (planObj != null) {
            retPlans.addAll(Arrays.asList(planObj.toString().split(",")));
        }
        return retPlans;
    }

    private String getDealer(List<IApprovalRecordItem> recordItems) {
        if (recordItems.size() == 0) {
            return null;
        }
        ArrayList dealers = new ArrayList(16);
        HashMap<String, Set> dealerMap = new HashMap<String, Set>(16);
        for (IApprovalRecordItem recordItem : recordItems) {
            String activityName = recordItem.getActivityName();
            Set dealerSet = dealerMap.computeIfAbsent(activityName, k -> new HashSet(16));
            if (recordItem.getAssignee() == null) continue;
            dealerSet.add(recordItem.getAssignee().trim().split("\\|")[0]);
        }
        dealerMap.forEach((key, value) -> dealers.add(key + "/" + String.join((CharSequence)"\u3001", value)));
        return String.join((CharSequence)";", dealers);
    }

    private String getCurrentNode(List<IApprovalRecordItem> recordItems) {
        if (recordItems.size() == 0) {
            return null;
        }
        HashSet<String> nodeNames = new HashSet<String>(16);
        for (IApprovalRecordItem recordItem : recordItems) {
            String activityName = recordItem.getActivityName();
            nodeNames.add(activityName);
        }
        return String.join((CharSequence)";", nodeNames);
    }

    private List<IApprovalRecordItem> getInApproveRecords(ApproveBill approveBill) {
        ArrayList<IApprovalRecordItem> records = new ArrayList<IApprovalRecordItem>(16);
        AppBillStatusEnum billStatus = approveBill.getBillStatus();
        if (AppBillStatusEnum.CANCEL == billStatus) {
            return records;
        }
        String businessKey = String.valueOf(approveBill.getId());
        List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)businessKey);
        for (IApprovalRecordGroup iApprovalRecordGroup : allApprovalRecord) {
            List children = iApprovalRecordGroup.getChildren();
            for (IApprovalRecordItem child : children) {
                records.add(child);
            }
        }
        return records;
    }

    private Set<String> getPlanInBill(ApproveBill approveBill) {
        HashSet<String> plans = new HashSet<String>(16);
        Map centralProcessPlan = approveBill.getCentralProcessPlan();
        if (centralProcessPlan == null) {
            return plans;
        }
        Set processPlans = (Set)centralProcessPlan.get(this.getUserId());
        return processPlans == null ? plans : processPlans;
    }

    private void setEntryGridEnable() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{TREE_ENTRY_ENTITY});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (MODEL.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            Object oldValue = changeData.getOldValue();
            long model_old = 0L;
            if (oldValue != null) {
                model_old = ((DynamicObject)oldValue).getLong("id");
            }
            if (model_old == 0L) {
                return;
            }
            Object newValue = changeData.getNewValue();
            long model_new = 0L;
            if (newValue != null) {
                model_new = ((DynamicObject)newValue).getLong("id");
            }
            if (model_new == 0L) {
                this.getModel().setValue(MODEL, (Object)model_old);
                return;
            }
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)model_new);
            this.refreshList();
        }
    }

    private void refreshList() {
        this.getModel().deleteEntryData(TREE_ENTRY_ENTITY);
        this.getModel().updateCache();
        this.initData();
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        super.hyperLinkClick(event);
        int focusRow = this.getFocusRow();
        Object pkId = this.getModel().getValue("pkid", focusRow);
        if (pkId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u952e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApproveBillListNew_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!CentralAppBillService.getInstance().checkExist("eb_centralappbill", "id", pkId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApproveBillListNew_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String pageId = this.getView().getPageId() + "_" + pkId;
        IFormView childFormView = this.getView().getView(pageId);
        if (childFormView != null) {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
            return;
        }
        Long rowId = IDUtils.toLong((Object)pkId);
        ApproveBill approveBill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)rowId));
        CustomSelectGroup group = new CustomSelectGroup();
        if (approveBill != null && !ModelServiceHelper.isUserHasRootPermByModel((long)this.getUserId(), (Long)approveBill.getModel()) && this.isExistMultiApproveEntity(approveBill, group)) {
            this.openApproveBillOrgSelPage(group);
            return;
        }
        this.openApproveBillPage(pkId, null, null);
    }

    private void openApproveBillPage(Object pkId, Set<Long> centralPlans, Set<Long> templates) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "eb_centralappbill");
        openParameter.put("pkId", pkId.toString());
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setShowTitle(true);
        if (centralPlans != null && templates != null) {
            formShowParameter.setCustomParam("centralPlans", (Object)SerializationUtils.toJsonString(centralPlans));
            formShowParameter.setCustomParam("templates", (Object)SerializationUtils.toJsonString(templates));
        }
        String pageId = this.getView().getPageId() + "_" + pkId;
        formShowParameter.setPageId(pageId);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            formShowParameter.setParentPageId(parentView.getPageId());
        }
        this.getView().showForm(formShowParameter);
    }

    private void openApproveBillOrgSelPage(CustomSelectGroup group) {
        ArrayList<CustomSelectGroup> groups = new ArrayList<CustomSelectGroup>(16);
        groups.add(group);
        CustomSelectUtil instance = CustomSelectUtil.getInstance();
        CustomShowParam customShowParam = instance.createCustomShowParam(groups, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7", (String)"ApproveBillListNew_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), null, 16);
        FormShowParameter customPageParameter = instance.getCustomPageParameter(customShowParam);
        customPageParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_entity"));
        this.getView().showForm(customPageParameter);
    }

    private boolean isExistMultiApproveEntity(ApproveBill approveBill, CustomSelectGroup group) {
        Set<String> approvePlans = this.getPlanOfApproveBill(approveBill);
        Long modelId = approveBill.getModel();
        CentralAppBillService.getInstance().filterGroupItems(group, approvePlans, modelId);
        return group.getCustomSelectItems().size() > 1;
    }

    private Set<String> getPlanOfApproveBill(ApproveBill approveBill) {
        Set<String> plans = this.getPlanInBill(approveBill);
        List<IApprovalRecordItem> recordItems = this.getInApproveRecords(approveBill);
        List<IApprovalRecordItem> filterItems = this.getItemsByCurUser(recordItems);
        if (filterItems.size() == 0) {
            return plans;
        }
        plans.addAll(this.getPlanNumsInWorkFlow(filterItems, approveBill.getId()));
        return plans;
    }

    private int getFocusRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        return entryGrid.getEntryState().getFocusRow();
    }

    private boolean checkSelectRows(List<Integer> selectRows) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ApproveBillListNew_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (int row : rows) {
            selectRows.add(row);
        }
        return true;
    }

    private boolean checkSelectSingleRow(List<Integer> selectRows) {
        if (!this.checkSelectRows(selectRows)) {
            return false;
        }
        if (selectRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u3002", (String)"ApproveBillListNew_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public Long getModelId() {
        long modelId = 0L;
        Object value = this.getModel().getValue(MODEL);
        if (value instanceof DynamicObject) {
            DynamicObject modelDyn = (DynamicObject)value;
            modelId = modelDyn.getLong("id");
        }
        return modelId;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_audit": {
                this.openApproverPage();
                break;
            }
            case "btn_unaudit": {
                ArrayList<Integer> selectedRows = new ArrayList<Integer>(16);
                if (!this.checkSelectSingleRow(selectedRows)) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5c06\u56de\u6eda\u8be5\u5355\u636e\u4e0a\u7684\u4fee\u6539\u5e76\u5220\u9664\u8be5\u5355\u636e\u53ca\u5173\u8054\u4fe1\u606f\uff0c\u662f\u5426\u786e\u5b9a\uff1f", (String)"ApproveBillListNew_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("unaudit", (IFormPlugin)this));
                break;
            }
            case "btn_adjrecord": {
                this.openAppAdjPage();
                break;
            }
            case "btn_decompose": {
                this.showDecomposeForm();
                break;
            }
            case "btn_viewchart": {
                this.viewChart();
                break;
            }
            case "btn_updatestatus": {
                this.updateBillStatus();
                break;
            }
            case "btn_invalid": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f5c\u5e9f\u5c06\u56de\u6eda\u8be5\u5355\u636e\u4e0a\u7684\u4fee\u6539\u5e76\u5220\u9664\u8be5\u5355\u636e\u5173\u8054\u4fe1\u606f\uff0c\u662f\u5426\u786e\u5b9a\uff1f", (String)"ApproveBillListNew_32", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("invalid"));
                break;
            }
            case "btn_refresh": {
                this.refreshList();
                break;
            }
            case "btn_del": {
                this.deleteBill();
                break;
            }
            case "btn_cleanup": {
                this.refreshCleanup();
                break;
            }
        }
    }

    private void refreshCleanup() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ApproveBillListNew_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection treeEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(TREE_ENTRY_ENTITY);
        List idList = Arrays.stream(rows).mapToObj(row -> ((DynamicObject)treeEntryEntity.get(row)).getString("billno")).map(billno -> QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", billno)})).filter(Objects::nonNull).map(id -> String.valueOf(id.getLong("id"))).collect(Collectors.toList());
        BgApplyLockUtils.removeMutuallyExclusiveObject(idList);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9501\u91ca\u653e\u6210\u529f\u3002", (String)"ApproveBillListNew_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String key = evt.getActionId();
        if ("eb_decomposescheme".equals(key)) {
            ListSelectedRowCollection returnDataList = (ListSelectedRowCollection)returnData;
            this.createBgDecomposeBill(returnDataList);
        } else if ("select_entity".equals(key)) {
            this.dealRetEntity(returnData);
        }
    }

    private void dealRetEntity(Object returnData) {
        if (!(returnData instanceof Map)) {
            return;
        }
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        HashSet<Long> templates = new HashSet<Long>(16);
        Map retMap = (Map)returnData;
        CentralAppBillService.getInstance().dealRetEntity(retMap, schemeIds, templates, this.getModelId());
        int focusRow = this.getFocusRow();
        Object pkId = this.getModel().getValue("pkid", focusRow);
        this.openApproveBillPage(pkId, schemeIds, templates);
    }

    private void createBgDecomposeBill(ListSelectedRowCollection listSelectedRows) {
        if (listSelectedRows == null || listSelectedRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u5206\u89e3\u65b9\u6848\u3002", (String)"ApproveBillListNew_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map selRowData = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_SELECT_ROW), Map.class);
        Long billId = Long.parseLong((String)selRowData.get("billid"));
        long schemeId = (Long)listSelectedRows.get(0).getPrimaryKeyValue();
        DynamicObject schemeDy = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_decomposescheme");
        ApproveBill approveBill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)billId));
        AppBillStatusEnum billStatus = approveBill.getBillStatus();
        if (AppBillStatusEnum.AUDITED != billStatus) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u5b8c\u6210\u5ba1\u6838\u3002", (String)"ApproveBillListNew_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List<DynamicObject> bgDecomposeDys = this.createBgDecomposeBillsNew(schemeDy, approveBill);
        if (bgDecomposeDys.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u89e3\u64cd\u4f5c\u5df2\u5b8c\u6210\u3002", (String)"ApproveBillListNew_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String checkResult = BgApplySplitUtil.getInstance().checkCreateBillsRepeat(bgDecomposeDys, approveBill.getModel());
        if (StringUtils.isNotEmpty((String)checkResult)) {
            throw new KDBizException(checkResult);
        }
        SaveServiceHelper.save((DynamicObject[])bgDecomposeDys.toArray(new DynamicObject[0]));
        String billNos = bgDecomposeDys.stream().map(tem -> tem.getString("billnumber")).collect(Collectors.joining(","));
        this.getView().showSuccessNotification(ResManager.loadResFormat((String)"\u9884\u7b97\u5206\u89e3\u6210\u529f\u751f\u6210%1\u5f20\u5206\u89e3\u5355\uff0c\u5355\u53f7\u8be6\u7ec6\uff1a%2\u3002", (String)"ApproveBillListNew_10", (String)"epm-eb-formplugin", (Object[])new Object[]{bgDecomposeDys.size(), billNos}));
        this.writeLog(null, "decompose", new MultiLangEnumBridge("\u9884\u7b97\u5206\u89e3", "ApproveBillListNew_33", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5355\u636e\uff1a%1$s\u5206\u89e3\u6210\u529f\uff0c\u751f\u6210 %2$s \u5f20\u5206\u89e3\u5355\uff0c\u5355\u53f7\u8be6\u60c5\uff1a%3$s\u3002", "ApproveBillListNew_34", "epm-eb-formplugin"), new String[]{approveBill.getBillNo(), String.valueOf(bgDecomposeDys.size()), billNos});
    }

    private List<DynamicObject> createBgDecomposeBillsNew(DynamicObject schemeDy, ApproveBill appBill) {
        DecpStepManager stepManager = BgApplySplitUtil.getInstance().getStepDatasBySchemeObj(schemeDy);
        DecpStepData stepData = stepManager.getStepDataByIndex(0);
        ArrayList<DynamicObject> bgDecomposeDys = new ArrayList<DynamicObject>(16);
        DynamicObject bgApplyScheme = this.getBgAppSchemeId(appBill);
        for (DecpRowData rowData : stepData.getRowDataList()) {
            Long splitOrgId = rowData.getDecpOrgId();
            DynamicObject newBgDecomposeDy = BgApplySplitUtil.getInstance().createBgDecomposeBillNew(null, stepData.getNumber(), Long.valueOf(schemeDy.getLong("id")), rowData.getOrderOrgId(), splitOrgId, rowData.getChargePersonsId(), appBill, bgApplyScheme, true, "");
            bgDecomposeDys.add(newBgDecomposeDy);
        }
        return bgDecomposeDys;
    }

    private DynamicObject getBgAppSchemeId(ApproveBill appBill) {
        return BgApplyBillUtils.getInstance().getBgAppSchemeObj(appBill);
    }

    private void updateBillStatus() {
        ArrayList<Integer> selectRows = new ArrayList<Integer>(16);
        if (!this.checkSelectRows(selectRows)) {
            return;
        }
        Set pkIds = selectRows.stream().map(e -> this.getModel().getValue("pkid", e.intValue())).collect(Collectors.toSet());
        List approveBills = ApproveBillUtil.getInstance().getApproveBills(new QFilter("id", "in", pkIds));
        approveBills.forEach(e -> e.setBillStatus(AppBillStatusEnum.SUBMITTED));
        if (approveBills.size() != 0) {
            ApproveBillUtil.getInstance().save((Collection)approveBills);
        }
    }

    private void invalidBill() {
        ArrayList<Integer> selectRows = new ArrayList<Integer>(16);
        if (!this.checkSelectRows(selectRows)) {
            return;
        }
        HashMap<String, String> errInfos = new HashMap<String, String>(16);
        Long modelId = this.getModelId();
        CentralAppBillService instance = CentralAppBillService.getInstance();
        ArrayList<Long> pkIds = new ArrayList<Long>(16);
        HashSet<String> billNos = new HashSet<String>(16);
        HashSet errBillNos = new HashSet(16);
        HashSet billIds = new HashSet(16);
        HashSet hasParentIdBillNos = new HashSet(16);
        selectRows.forEach(e -> {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, e.intValue());
            String billStatus = entryRowEntity.getString("billstatus");
            String billNo = entryRowEntity.getString("billno");
            long id = entryRowEntity.getLong("id");
            String parentId = entryRowEntity.get("pid").toString();
            if (!AppBillStatusEnum.AUDITED.getNumber().equals(billStatus) || !AppBillStatusEnum.CANCEL.getNumber().equals(billStatus)) {
                if (!this.isInHzBill(billNo, modelId, errInfos) && !this.isSubBill(entryRowEntity.getLong("pkid"), billNo, errInfos)) {
                    pkIds.add(entryRowEntity.getLong("pkid"));
                    billNos.add(billNo);
                    billIds.add(id);
                }
            } else if (StringUtils.isNotEmpty((String)parentId) && !"0".equals(parentId)) {
                hasParentIdBillNos.add(billNo);
            } else {
                errBillNos.add(billNo);
            }
        });
        this.setSubBillPkids(pkIds, billNos);
        instance.stopWorkFlowProcess(pkIds.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        qFilter.and(new QFilter("billno", "in", billNos));
        List approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter);
        Map<String, ApproveBill> approveBillMap = approveBills.stream().collect(Collectors.toMap(ApproveBill::getBillNo, e -> e));
        try (OlapTXHandle txHandle = OlapTX.required((String)"invalidBill");){
            try {
                this.rollBackData(billNos, approveBillMap, modelId);
                Map refBillNumMap = RejectBillService.getInstance().getBhNumbersBySpNumbers(billNos);
                HashSet refBillNums = new HashSet(16);
                refBillNumMap.values().forEach(refBillNums::addAll);
                instance.deleteBillAndReferences(billIds, billNos, refBillNums, this.getModelId(), false);
                RejectBillService.getInstance().deleteRejectDataBySpNumbers(billNos, this.getModelId());
                ApplyBillAttachmentHelper.removeApproveBillAttachments(billNos, (Long)this.getModelId());
                approveBills.forEach(e -> e.setBillStatus(AppBillStatusEnum.CANCEL));
                ApproveBillUtil.getInstance().save((Collection)approveBills);
            }
            catch (Exception e2) {
                txHandle.markRollback();
                log.error((Throwable)e2);
                throw e2;
            }
        }
        ApproveBillUtil approveBillUtil = ApproveBillUtil.getInstance();
        HashSet sourceBillNos = new HashSet(16);
        for (ApproveBill approveBill : approveBills) {
            List approveBillEntries = approveBill.getApproveBillEntries();
            boolean isCollectAudit = approveBillUtil.isCollectAudit(approveBill);
            approveBillEntries.forEach(e -> instance.setBillNo(e, sourceBillNos, Boolean.valueOf(isCollectAudit)));
        }
        DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"eb_bgapplybill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("billnumber", "in", sourceBillNos)});
        for (int i = 0; i < applyBills.length; ++i) {
            applyBills[i].set("billstatus", (Object)"A");
        }
        Object[] result = SaveServiceHelper.save((DynamicObject[])applyBills);
        if (result == null || result.length == 0) {
            SaveServiceHelper.saveOperate((String)"eb_bgapplybill", (DynamicObject[])applyBills);
        }
        HashMap<String, HashSet<String>> successInfo = new HashMap<String, HashSet<String>>(16);
        if (billNos.size() != 0) {
            successInfo.put(ResManager.loadResFormat((String)"\u5df2\u4f5c\u5e9f\u5355\u636e", (String)"ApproveBillListNew_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), billNos);
        }
        if (hasParentIdBillNos.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u4f5c\u5e9f\u5f52\u53e3\u5ba1\u6838\u5b50\u5355\u636e\u3002", (String)"ApproveBillListNew_42", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            errInfos.putAll(hasParentIdBillNos.stream().collect(Collectors.toMap(e -> e, e -> msg)));
        }
        String errInfo = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u5df2\u5ba1\u6838\u6216\u8005\u5df2\u4f5c\u5e9f\u7684\u5355\u636e\u3002", (String)"ApproveBillListNew_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        errInfos.putAll(errBillNos.stream().collect(Collectors.toMap(e -> e, e -> errInfo)));
        String operateName = ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"ApproveBillListNew_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        CentralAppBillService.getInstance().showOperationResult(operateName, successInfo, errInfos, this.getView(), this.getPluginName());
        StringBuilder desc = new StringBuilder();
        if (billNos.size() != 0) {
            desc.append(ResManager.loadResFormat((String)"\u4f5c\u5e9f\u5355\u636e\uff1a%1\u6210\u529f\u3002", (String)"ApproveBillListNew_35", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", billNos)}));
        }
        HashSet errBills = new HashSet(errInfos.keySet());
        if (errBillNos.size() != 0) {
            if (desc.length() != 0) {
                desc.append(";");
            }
            desc.append(ResManager.loadResFormat((String)"\u4f5c\u5e9f\u5355\u636e\uff1a%1\u5931\u8d25\u3002", (String)"ApproveBillListNew_36", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", errBills)}));
        }
        if (desc.length() != 0) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4f5c\u5e9f", "ApproveBillListNew_13", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge();
            opDesc.setDescription(desc.toString());
            this.writeLog("cancellation", opName, opDesc);
        }
    }

    private void deleteBill() {
    }

    private void viewChart() {
        ArrayList<Integer> selectRows = new ArrayList<Integer>(16);
        if (!this.checkSelectSingleRow(selectRows)) {
            return;
        }
        Integer index = (Integer)selectRows.get(0);
        Object pkId = this.getModel().getValue("pkid", index.intValue());
        if (pkId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u952e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApproveBillListNew_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        AbstractViewFlowchart chart = new AbstractViewFlowchart();
        chart.setBillId(pkId);
        chart.showFlowchart(this.getView());
    }

    private void openAppAdjPage() {
        ArrayList<Integer> selectedRows = new ArrayList<Integer>(16);
        if (!this.checkSelectSingleRow(selectedRows)) {
            return;
        }
        Integer rowIndex = (Integer)selectedRows.get(0);
        String billNo = this.getModel().getValue("billno", rowIndex.intValue()).toString();
        if (StringUtils.isEmpty((String)billNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u7684\u5ba1\u6279\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"ApproveBillListNew_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = CentralAppBillService.getInstance().getAdjustShowPage(billNo, Long.valueOf(0L), null, Long.valueOf(0L), AdjustShowTypeEnum.ApproveAdjust, ApplyBillType.APPLYAUDIT, Long.valueOf(0L), this.getModelId());
        this.getView().showForm(formShowParameter);
        this.writeLog(billNo, "view", new MultiLangEnumBridge("\u8c03\u6574\u8bb0\u5f55", "ApproveBillListNew_37", "epm-eb-formplugin"), new MultiLangEnumBridge("\u67e5\u770b\u5355\u636e\uff1a%1$s\u7684\u8c03\u6574\u8bb0\u5f55\u3002", "ApproveBillListNew_38", "epm-eb-formplugin"), new String[]{billNo});
    }

    private void openApproverPage() {
        ArrayList<Integer> selectedRows = new ArrayList<Integer>(16);
        if (!this.checkSelectSingleRow(selectedRows)) {
            return;
        }
        Object pkId = this.getModel().getValue("pkid", ((Integer)selectedRows.get(0)).intValue());
        FormShowParameter approverPage = CentralAppBillService.getInstance().createApproverPage(pkId.toString());
        if (approverPage != null) {
            this.getView().showForm(approverPage);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5ba1\u6838\u8be5\u5355\u636e\u3002", (String)"ApproveBillListNew_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void unAuditApproveBill() {
        HashSet errBillNos;
        Object billNo2;
        ArrayList<Integer> selectedRows = new ArrayList<Integer>(16);
        if (!this.checkSelectRows(selectedRows)) {
            return;
        }
        long model = this.getModelId();
        HashSet<String> billNos = new HashSet<String>(16);
        HashMap<String, String> errMessages = new HashMap<String, String>(16);
        HashMap<String, ApproveBill> approveBills = new HashMap<String, ApproveBill>(16);
        ArrayList<Long> pkIds = new ArrayList<Long>(16);
        for (Integer selectedRow : selectedRows) {
            String billStatus = this.getModel().getValue("billstatus", selectedRow.intValue()).toString();
            billNo2 = this.getModel().getValue("billno", selectedRow.intValue()).toString();
            String parentId = this.getModel().getValue("pid", selectedRow.intValue()).toString();
            if (!AppBillStatusEnum.AUDITED.getNumber().equals(billStatus)) {
                errMessages.put((String)billNo2, ResManager.loadKDString((String)"\u53ea\u80fd\u53cd\u5ba1\u6838\u5df2\u5ba1\u6838\u7684\u5355\u636e\u3002", (String)"ApproveBillListNew_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.isNotEmpty((String)parentId) && !"0".equals(parentId)) {
                errMessages.put((String)billNo2, ResManager.loadKDString((String)"\u53ea\u80fd\u53cd\u5ba1\u6838\u4e3b\u5355\u7684\u5355\u636e\u3002", (String)"ApproveBillListNew_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            Object primaryKeyValue = this.getModel().getValue("pkid", selectedRow.intValue());
            pkIds.add(IDUtils.toLong((Object)primaryKeyValue));
        }
        this.setSubBillPkids(pkIds, billNos);
        Set<String> applyBillNos = this.getAdminOrCollectBill(pkIds, billNos, model, errMessages, approveBills);
        if (billNos.size() != 0 && applyBillNos.size() != 0) {
            Set<Long> approveBillIds = this.getApproveBillIds(billNos, model);
            CentralAppBillService.getInstance().stopWorkFlowProcess(approveBillIds.stream().map(Objects::toString).collect(Collectors.toList()));
            OlapTXHandle tx = OlapTX.required((String)"unAuditApproveBill");
            billNo2 = null;
            try {
                try {
                    this.rollBackData(billNos, approveBills, model);
                    CentralAppBillService.getInstance().deleteBillAndReferences(approveBillIds, billNos, new HashSet(16), Long.valueOf(model), true);
                    this.updateApplyBillStatus(applyBillNos, model);
                    RejectBillService.getInstance().deleteRejectDataBySpNumbers(billNos, Long.valueOf(model));
                    ApplyBillAttachmentHelper.removeApproveBillAttachments(billNos, (Long)model);
                }
                catch (Exception e) {
                    tx.markRollback();
                    String errMessage = ResManager.loadKDString((String)"\u5220\u9664\u5ba1\u6279\u5355\u636e\u4fe1\u606f\u6216\u8005\u66f4\u65b0\u7533\u62a5\u5355\u72b6\u6001\u5931\u8d25\u3002", (String)"ApproveBillListNew_18", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\n";
                    errMessage = errMessage + e.getMessage();
                    throw new KDBizException(errMessage);
                }
            }
            catch (Throwable e) {
                billNo2 = e;
                throw e;
            }
            finally {
                if (tx != null) {
                    if (billNo2 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable e) {
                            ((Throwable)billNo2).addSuppressed(e);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        StringBuilder successInfos = new StringBuilder();
        if (billNos.size() != 0 && applyBillNos.size() != 0) {
            successInfos.append(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u5ba1\u6279\u5355\u636e\u3002", (String)"ApproveBillListNew_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            billNos.stream().forEach(billNo -> successInfos.append((String)billNo).append("\u3001"));
            successInfos.deleteCharAt(successInfos.length() - 1);
            successInfos.append("\n");
            successInfos.append(ResManager.loadKDString((String)"\u7533\u62a5\u5355\u636e\u72b6\u6001\u5df2\u66f4\u65b0\u3002", (String)"ApproveBillListNew_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            applyBillNos.stream().forEach(billNo -> successInfos.append((String)billNo).append("\u3001"));
            successInfos.deleteCharAt(successInfos.length() - 1);
            successInfos.append("\n");
        }
        String operateName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"ApproveBillListNew_21", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        CentralAppBillService.getInstance().showOperationResultForUnAudit(operateName, successInfos.toString(), errMessages, this.getView(), this.getPluginName());
        this.refreshList();
        StringBuilder desc = new StringBuilder();
        if (billNos.size() != 0) {
            desc.append(ResManager.loadResFormat((String)"\u5355\u636e\uff1a%1\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"ApproveBillListNew_39", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", billNos)}));
        }
        if ((errBillNos = new HashSet(errMessages.keySet())).size() != 0) {
            if (desc.length() != 0) {
                desc.append(";");
            }
            desc.append(ResManager.loadResFormat((String)"\u5355\u636e\uff1a%1\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"ApproveBillListNew_40", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", errBillNos)}));
        }
        if (desc.length() != 0) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53cd\u5ba1\u6838", "ApproveBillListNew_21", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge();
            opDesc.setDescription(desc.toString());
            this.writeLog("unAudit", opName, opDesc);
        }
    }

    private Set<String> getAdminOrCollectBill(List<Long> pkIds, Set<String> billNos, long model, Map<String, String> errMessage, Map<String, ApproveBill> approveBills) {
        HashSet<String> applyOrCollects = new HashSet<String>(16);
        List approveBill = ApproveBillUtil.getInstance().getApproveBills(new QFilter("id", "in", pkIds));
        if (approveBill.size() == 0) {
            return applyOrCollects;
        }
        for (ApproveBill bill : approveBill) {
            String billNo = bill.getBillNo();
            if (this.isInHzBill(billNo, model, errMessage) || this.isInDecomposeBill(bill.getId(), billNo, model, errMessage)) continue;
            List approveBillEntries = bill.getApproveBillEntries();
            Set<String> bills = this.getAllBillNos(approveBillEntries, true);
            if (bills.size() == 0) {
                bills = this.getAllBillNos(approveBillEntries, false);
            }
            if ((bill.getParentId() == 0L || bill.getParentId() == null) && bills.size() == 0) {
                errMessage.put(billNo, ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u636e\u6570\u636e\u4e3a\u7a7a\u3002", (String)"ApproveBillListNew_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            applyOrCollects.addAll(bills);
            billNos.add(billNo);
            approveBills.put(billNo, bill);
        }
        return applyOrCollects;
    }

    private boolean isInDecomposeBill(Long pkId, String billNo, Long modelId, Map<String, String> errMessage) {
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)String.valueOf(pkId));
        qFilter.and(MODEL, "=", (Object)modelId);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_bgdecompose", (String)"billnumber", (QFilter[])new QFilter[]{qFilter});
        if (bills == null || bills.size() == 0) {
            return false;
        }
        List billNumbers = bills.stream().map(e -> e.getString("billnumber")).collect(Collectors.toList());
        errMessage.put(billNo, ResManager.loadResFormat((String)"\u5f53\u524d\u5355\u636e\u5df2\u751f\u6210\u5206\u89e3\u5355[%1]\u3002", (String)"ApproveBillListNew_23", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", billNumbers)}));
        return true;
    }

    private boolean isInHzBill(String billNo, long model, Map<String, String> errMessage) {
        Map applyBills = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (String)"auditpath, billnumber", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)"collect"), new QFilter(MODEL, "=", (Object)model)});
        if (applyBills == null || applyBills.size() == 0) {
            return false;
        }
        for (DynamicObject applyBill : applyBills.values()) {
            String auditPath = applyBill.getString("auditpath");
            if (!auditPath.contains(billNo)) continue;
            errMessage.put(billNo, ResManager.loadResFormat((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u6c47\u603b\u5355\u636e%1\u5f15\u7528\u3002", (String)"ApproveBillListNew_24", (String)"epm-eb-formplugin", (Object[])new Object[]{applyBill.getString("billnumber")}));
            return true;
        }
        return false;
    }

    private boolean isSubBill(Long pkid, String billNo, Map<String, String> errMessage) {
        DynamicObject approveBill = BusinessDataServiceHelper.loadSingleFromCache((Object)pkid, (String)"eb_centralappbill");
        if (approveBill != null && approveBill.getLong("parentid") != 0L) {
            errMessage.put(billNo, ResManager.loadResFormat((String)"\u5f53\u524d\u5355\u636e\u662f\u5b50\u5355\u636e\u3002", (String)"ApproveBillListNew_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setSubBillPkids(List<Long> pkIds, Set<String> billnos) {
        QFilter filter = new QFilter("parentid", "in", pkIds);
        DynamicObjectCollection subBills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,billno", (QFilter[])filter.toArray());
        if (subBills != null && !subBills.isEmpty()) {
            for (DynamicObject subBill : subBills) {
                pkIds.add(subBill.getLong("id"));
                billnos.add(subBill.getString("billno"));
            }
        }
    }

    private void setSubBillPkids(List<Long> pkIds) {
        QFilter filter = new QFilter("parentid", "in", pkIds);
        DynamicObjectCollection subBills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,billno", (QFilter[])filter.toArray());
        if (subBills != null && !subBills.isEmpty()) {
            for (DynamicObject subBill : subBills) {
                pkIds.add(subBill.getLong("id"));
            }
        }
    }

    private Set<String> getAllBillNos(List<ApproveBillEntry> approveBillEntries, boolean isSumBill) {
        HashSet<String> billNos = new HashSet<String>(16);
        if (approveBillEntries == null || approveBillEntries.size() == 0) {
            return billNos;
        }
        for (ApproveBillEntry approveBillEntry : approveBillEntries) {
            String billNo = approveBillEntry.getReportBillNo();
            if (isSumBill) {
                billNo = approveBillEntry.getSumBillNo();
            }
            if (StringUtils.isEmpty((String)billNo) || "0".equals(billNo)) continue;
            billNos.add(billNo);
        }
        return billNos;
    }

    private void rollBackData(Set<String> billNos, Map<String, ApproveBill> approveBills, Long modelId) {
        for (String billNum : billNos) {
            ApproveBill approveBill = approveBills.get(billNum);
            if (approveBill == null) continue;
            CentralAppShowInfo showInfo = CentralAppBillService.getInstance().createShowInfo(approveBill);
            if (showInfo.getTemplates().isEmpty()) {
                CentralAppShowInfo showInfoparent;
                DynamicObject applyBill = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"parentid", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNum), new QFilter(MODEL, "=", (Object)modelId)});
                Long pid = (Long)applyBill.get("parentid");
                DynamicObject applyBills = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pid), new QFilter(MODEL, "=", (Object)modelId)});
                String parentnum = (String)applyBills.get("billno");
                ApproveBill approveBillparent = approveBills.get(String.valueOf(parentnum));
                showInfo = showInfoparent = CentralAppBillService.getInstance().createShowInfo(approveBillparent);
            }
            Set refBillNumbs = RejectBillService.getInstance().getBhNumbersBySpNumber(billNum);
            String billType = CentralAppBillService.getInstance().getAuditBillType(approveBill.getApproveBillEntries());
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(modelId, approveBill.getReportScheme(), approveBill.getYear(), approveBill.getVersion(), approveBill.getDatatype());
            ApplyBillPluginUitl.rollbackBillData((String)billNum, (SchemeAssignDimGroup)schemeAssignDimGroup, (Set)refBillNumbs, (Long)modelId, (String)billType, (CentralAppShowInfo)showInfo);
        }
    }

    private Set<Long> getApproveBillIds(Set<String> billNos, long model) {
        HashSet<Long> ids = new HashSet<Long>(billNos.size());
        QFilter qFilter = new QFilter(MODEL, "=", (Object)model);
        QFilter qFilter1 = new QFilter("billno", "in", billNos);
        List approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter1.and(qFilter));
        for (ApproveBill bill : approveBills) {
            ids.add(bill.getId());
        }
        return ids;
    }

    private void updateApplyBillStatus(Set<String> billNos, long model) {
        DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"eb_bgapplybill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("billnumber", "in", billNos), new QFilter(MODEL, "=", (Object)model)});
        if (applyBills == null || applyBills.length == 0) {
            return;
        }
        for (DynamicObject applyBill : applyBills) {
            applyBill.set("billstatus", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])applyBills);
    }

    private void showDecomposeForm() {
        ArrayList<Integer> selectedRows = new ArrayList<Integer>(16);
        if (!this.checkSelectSingleRow(selectedRows)) {
            return;
        }
        Integer rowIndex = (Integer)selectedRows.get(0);
        Object objId = this.getModel().getValue("pkid", rowIndex.intValue());
        String billNo = this.getModel().getValue("billno", rowIndex.intValue()).toString();
        if (StringUtils.isEmpty((String)billNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ba1\u6279\u5355\u636e\u7f16\u53f7\u3002", (String)"ApproveBillListNew_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ApproveBill approveBills = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", objId));
        if (approveBills == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ba1\u6279\u5355\u636e\u5185\u5bb9\u3002", (String)"ApproveBillListNew_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Long> orgIdSet = approveBills.getApproveBillEntries().stream().map(ApproveBillEntry::getCentralEntity).collect(Collectors.toSet());
        Long modelId = approveBills.getModel();
        String splitedBillNumber = CentralAppBillService.getInstance().checkHasSplitBill(approveBills.getBillNo(), modelId);
        if (StringUtils.isNotEmpty((String)splitedBillNumber)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u5206\u89e3\uff0c\u5173\u8054\u5355\u636e\u201c%1\u201d\u5df2\u4ea7\u751f\u5206\u89e3\u5355\u3002", (String)"ApproveBillListNew_30", (String)"epm-eb-formplugin", (Object[])new Object[]{splitedBillNumber}));
            return;
        }
        Long bizRangeCtrlId = (Long)CommonServiceHelper.getValueFromDB((String)"eb_rptscheme", (String)"bizrange", (String)"id", (Object[])new Object[]{approveBills.getReportScheme()});
        HashMap<String, String> selRowData = new HashMap<String, String>(16);
        selRowData.put("billid", String.valueOf(objId));
        selRowData.put("billno", billNo);
        this.getPageCache().put(CACHE_SELECT_ROW, SerializationUtils.toJsonString(selRowData));
        this.showDecomposeScheme(modelId, bizRangeCtrlId, orgIdSet);
    }

    private void showDecomposeScheme(Long modelId, Long bizRangeCtrlId, Set<Long> orgIdSet) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"eb_decomposescheme", (boolean)false);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_decomposescheme"));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("ishide", "=", (Object)Character.valueOf('0')));
        filters.add(new QFilter(MODEL, "=", (Object)modelId));
        filters.add(new QFilter("releaseorg.id", "in", orgIdSet));
        filters.add(new QFilter("bizctrlrange.id", "=", (Object)bizRangeCtrlId));
        para.setListFilterParameter(new ListFilterParameter(filters, null));
        para.setHasRight(true);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("bos_listf7");
        this.getView().showForm((FormShowParameter)para);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("unaudit".equals(callBackId)) {
            this.unAuditApproveBill();
        } else if ("invalid".equals(callBackId)) {
            this.invalidBill();
        }
    }

    private Map<String, String> getAuditMap(Map<String, List<BizProcessStatus>> bizProcessStatusMap) {
        HashMap<String, String> auditMap = new HashMap<String, String>(16);
        for (Map.Entry<String, List<BizProcessStatus>> entry : bizProcessStatusMap.entrySet()) {
            String pkId = entry.getKey();
            List<BizProcessStatus> node = entry.getValue();
            node.forEach(e -> {
                String nodeStr = e.getCurrentNodeName();
                String auditor = e.getParticipantName();
                if (StringUtils.isNotEmpty((String)auditor)) {
                    nodeStr = nodeStr + "!" + auditor;
                }
                auditMap.put(pkId, nodeStr);
            });
        }
        return auditMap;
    }
}

