/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.EventObject;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.epm.eb.business.applybill.util.BgApplyBillHelper;
import kd.epm.eb.business.centralapproval.AppBillDataFilterService;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.centralapproval.ShowInfoCreateUtil;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.centralapproval.MutexLockInfo;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.centralapproval.CentralAppBillShowPlugin;

public class BaseAppBillShowPlugin
extends AbstractBillPlugIn {
    public static final Log log = LogFactory.getLog(CentralAppBillShowPlugin.class);
    protected final CentralAppShowInfo showInfo = new CentralAppShowInfo();
    protected ApproveBill approveBill = null;

    public void afterLoadData(EventObject e) {
        this.initBaseShowInfo();
        this.filterData();
        this.checkMutex();
        this.showApprovePage();
    }

    protected void checkMutex() {
    }

    private void initBaseShowInfo() {
        ApproveBill approveBill = this.getApproveBill();
        ShowInfoCreateUtil.getInstance().initBaseShowInfo(this.showInfo, approveBill, null);
    }

    private void filterData() {
        this.filterDataByAproveType();
        this.filterDataByPerm();
    }

    protected void filterDataByAproveType() {
    }

    protected void filterDataByPerm() {
    }

    private void showApprovePage() {
        this.beforeShowApprovePage();
        BaseShowParameter showParameter = this.getBaseShowParameter();
        String curNode = this.getCurNode();
        String currentNodeName = this.getCurrentName();
        showParameter.setCustomParam("approveNodeNumber", (Object)curNode);
        showParameter.setCustomParam("approveNodeName", (Object)currentNodeName);
        showParameter.setCustomParam("mutexInfo", (Object)this.getPageCache().get("curMutex"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected String getCurrentName() {
        DynamicObject taskDyn;
        TaskEntityImpl task;
        String name = "";
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        if (taskId != null && (task = (TaskEntityImpl)WorkflowServiceHelper.findTaskById((Long)taskId)) != null && (taskDyn = task.getDynamicObject()) != null) {
            name = taskDyn.getString("name");
        }
        return name;
    }

    protected MutexLockInfo getCurMutex() {
        String curMutex = this.getPageCache().get("curMutex");
        if (StringUtils.isEmpty((String)curMutex)) {
            return null;
        }
        return (MutexLockInfo)SerializationUtils.fromJsonString((String)curMutex, MutexLockInfo.class);
    }

    protected String getCurNode() {
        return (String)this.getView().getFormShowParameter().getCustomParam("CURNODE");
    }

    protected void beforeShowApprovePage() {
        ApproveBill approveBill = this.getApproveBill();
        ShowInfoCreateUtil.getInstance().initShowInfoBaseData(this.showInfo, approveBill);
        this.setApproveInfo();
    }

    protected void setApproveInfo() {
    }

    protected BaseShowParameter getBaseShowParameter() {
        this.getPageCache().put("applyshowinfo", SerializationUtils.toJsonString((Object)this.showInfo));
        BaseShowParameter baseShowParameter = BgApplyBillHelper.getInstance().openAuditForm(this.showInfo, this.getBillShowType(), true);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        return baseShowParameter;
    }

    protected ApproveBill getApproveBill() {
        if (this.approveBill == null) {
            this.approveBill = this.getCurApproveBill();
        }
        return this.approveBill;
    }

    protected ApproveBill getCurApproveBill() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        return ApproveBillUtil.getInstance().createApproveBill(dataEntity);
    }

    protected Set<Long> getDimMemInPerm(String dimNum, Set<Long> bizModels, DimMembPermType perm) {
        Long usrId = CentralAppBillService.getInstance().getUserId();
        return AppBillDataFilterService.getInstance().getDimMemInPerm(dimNum, bizModels, this.getModelId(), perm, usrId);
    }

    protected boolean isModelAdmin() {
        return CentralAppBillService.getInstance().isModelAdmin(this.getModelId());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if ("close".equals(key)) {
            this.getView().close();
        }
    }

    protected String getBillShowType() {
        return "";
    }

    protected Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue("model");
        if (modelObj == null) {
            return 0L;
        }
        return modelObj.getLong("id");
    }

    protected Long getUserId() {
        return UserUtils.getUserId();
    }

    protected boolean isFromApproveList() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return false;
        }
        String entityId = parentView.getEntityId();
        return entityId.startsWith("wf");
    }

    protected DimMembPermType getPermType() {
        return this.isFromApproveList() ? DimMembPermType.WRITE : DimMembPermType.READ;
    }
}

