/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.centralapproval.ShowInfoCreateUtil;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.business.rejectbill.constant.RejectStatusEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.centralapproval.ApproveAdjDimTypeEnum;
import kd.epm.eb.common.centralapproval.ApproveAdjustDimEntry;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillConfig;
import kd.epm.eb.common.centralapproval.ApprovePlan;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.centralapproval.MutexLockInfo;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.applybill.util.BgApplyLockUtils;
import kd.epm.eb.formplugin.applybill.util.BgApplyMutexPojo;
import kd.epm.eb.formplugin.approveBill.CommitExaminCheck;
import kd.epm.eb.formplugin.centralapproval.BaseAppBillShowPlugin;
import kd.epm.eb.formplugin.centralapproval.DefaultAdjustingdimensionsTool;
import org.apache.commons.collections4.CollectionUtils;

public class CentralAppBillShowPlugin
extends BaseAppBillShowPlugin {
    private static final Log log = LogFactory.getLog(AbstractListPlugin.class);

    public void initialize() {
        super.initialize();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (this.isFromApproveList()) {
            parentView.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap6"});
            this.getView().sendFormAction(parentView);
        }
        this.addClickListeners(new String[]{"selectchain"});
    }

    public void loadData(LoadDataEventArgs e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
    }

    @Override
    protected BaseShowParameter getBaseShowParameter() {
        BaseShowParameter baseShowParameter = super.getBaseShowParameter();
        this.getOrCacheBillPageId(baseShowParameter.getPageId());
        return baseShowParameter;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.ReleaseLock();
    }

    private void ReleaseLock() {
        ArrayList<String> stringArrayList = new ArrayList<String>();
        stringArrayList.add(this.getApproveBill().getId().toString());
        String userId = this.getUserId().toString();
        String loginIP = RequestContext.getOrCreate().getLoginIP();
        String billId = this.getApproveBill().getId().toString();
        String name = UserServiceHelper.getCurrentUser((String)"name").getString("name");
        List mutuallyExclusiveObject = BgApplyLockUtils.getMutuallyExclusiveObject(stringArrayList);
        if (mutuallyExclusiveObject.isEmpty()) {
            return;
        }
        for (BgApplyMutexPojo bgApplyMutexPojo : mutuallyExclusiveObject) {
            if (!bgApplyMutexPojo.getUserId().equals(userId) || !bgApplyMutexPojo.getUserIP().equals(loginIP) || !bgApplyMutexPojo.getApprovalId().equals(billId) || !bgApplyMutexPojo.getUserName().equals(name)) continue;
            BgApplyLockUtils.removeMutuallyExclusiveObject(stringArrayList);
        }
    }

    private String getOrCacheBillPageId(String billPageId) {
        if (billPageId == null) {
            billPageId = this.getPageCache().get("billPageId");
        } else {
            this.getPageCache().put("billPageId", billPageId);
        }
        return billPageId;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String billNo = (String)this.getModel().getValue("billno");
            List rejectLogs = RejectBillService.getInstance().listRejectLogBySpnumber(billNo);
            if (rejectLogs.stream().anyMatch(e -> e.getRejectStatus().equals(RejectStatusEnum.reject.getCode()))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u9a73\u56de\u5355\u636e\u3002", (String)"CentralAppBillShowPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String operateKey = ((Donothing)source).getOperateKey();
            if (operateKey.equals("auditpass")) {
                String examineCheckstatus = (String)this.getView().getFormShowParameter().getCustomParam("examineCheck");
                log.info("\u5ba1\u6279\u540c\u610f\u8282\u70b9\u52fe\u7a3d\u68c0\u67e5\u9875\u9762\u53c2\u6570\uff1a" + examineCheckstatus);
                IFormView formView = this.getView().getView(this.getOrCacheBillPageId(null));
                if (formView != null) {
                    ArrayList<String> stringArrayList = new ArrayList<String>();
                    stringArrayList.add(this.getApproveBill().getId().toString());
                    List mutuallyExclusiveObject = BgApplyLockUtils.getMutuallyExclusiveObject(stringArrayList);
                    if (mutuallyExclusiveObject == null || mutuallyExclusiveObject.size() == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u8be5\u5355\u636e\u4e3a\u4ec5\u67e5\u770b\u3002", (String)"CentralAppBillShowPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (!((BgApplyMutexPojo)mutuallyExclusiveObject.get(0)).getUserId().equals(String.valueOf(UserServiceHelper.getCurrentUserId())) && !((BgApplyMutexPojo)mutuallyExclusiveObject.get(0)).getUserId().equals(RequestContext.getOrCreate().getLoginIP())) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u8be5\u5355\u636e\u4e3a\u4ec5\u67e5\u770b\u3002", (String)"CentralAppBillShowPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (this.isCurNodeMutex()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u8be5\u5355\u636e\u4e3a\u4ec5\u67e5\u770b\u3002", (String)"CentralAppBillShowPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    OperationResult operationResult = formView.invokeOperation("save");
                    if (!operationResult.isSuccess() && StringUtils.isNotEmpty((String)operationResult.getMessage())) {
                        args.setCancel(true);
                        args.setCancelMessage(ResManager.loadResFormat((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%1\u3002", (String)"CentralAppBillShowPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{operationResult.getMessage()}));
                        return;
                    }
                    if (StringUtils.isNotEmpty((String)examineCheckstatus) && "true".equals(examineCheckstatus)) {
                        DynamicObject dynamicObject_sp = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"eb_centralappbill");
                        String cacheshowinfo = this.getView().getPageCache().get("applyshowinfo");
                        CentralAppShowInfo showInfo = (CentralAppShowInfo)SerializationUtils.fromJsonString((String)cacheshowinfo, CentralAppShowInfo.class);
                        boolean examineCheck = new CommitExaminCheck().examineCheck2((Collection)Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject_sp}), this.getView(), this.getBillShowType(), showInfo);
                        if (!examineCheck) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u52ff\u63d0\u4ea4\u3002", (String)"CentralAppBillShowPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                    }
                    this.ReleaseLock();
                    this.saveCurNodeToApproveBill();
                } else {
                    args.setCancel(true);
                    args.setCancelMessage(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u63d0\u4ea4\u3002", (String)"CentralAppBillShowPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void saveCurNodeToApproveBill() {
        ApproveBill approveBill = this.getCurApproveBill();
        String curNode = this.getCurNode();
        this.getModel().setValue("curnode", (Object)curNode);
        approveBill.setCurNode(curNode);
        ApproveBillUtil.getInstance().save(Collections.singletonList(approveBill));
    }

    @Override
    protected String getBillShowType() {
        DynamicObjectCollection entities = this.getModel().getEntryEntity("centralapprptentity");
        List approveBillEntries = ApproveBillUtil.getInstance().createApproveBillEntries(entities);
        Long parentid = (Long)this.getModel().getValue("parentid");
        if (parentid != null && parentid > 0L) {
            return ApplyBillType.COLLECYAUDIT.getNumber();
        }
        return CentralAppBillService.getInstance().getAuditBillType(approveBillEntries);
    }

    @Override
    protected void filterDataByAproveType() {
        super.filterDataByAproveType();
        String centralAppPlan = null;
        String billShowStatus = "notApprove";
        ApproveBill approveBill = this.getApproveBill();
        List<ApproveBillConfig> approveBillConfigs = this.getApproveBillConfigs(approveBill);
        if (this.isFromApproveList()) {
            Object onlyView = this.getView().getFormShowParameter().getCustomParam("onlyView");
            if (onlyView != null && !"true".equals(onlyView.toString())) {
                billShowStatus = "inApprove";
            }
            centralAppPlan = (String)this.getView().getFormShowParameter().getCustomParam("AdjdimPlan");
        }
        this.showInfo.setBillShowStatus(billShowStatus);
        this.showInfo.setApproveBillConfigs(approveBillConfigs);
        this.showInfo.setAdjustDimensionNumber(centralAppPlan);
        this.getAjdimPlanNumber(centralAppPlan);
        if (!approveBillConfigs.isEmpty()) {
            this.showInfo.setTemplates(approveBillConfigs.stream().map(s -> s.getTemplateId()).collect(Collectors.toSet()));
        }
        String curNode = this.getCurNode();
        String currentNodeName = this.getCurrentName();
        this.showInfo.setRejectNode(curNode);
        this.showInfo.setRejectNodeName(currentNodeName);
    }

    private String getAjdimPlanNumber(String centralAppPlan) {
        ArrayList<ApprovePlan> result = new ArrayList<ApprovePlan>(16);
        Long modelId = this.approveBill.getModel();
        Long parentId = this.approveBill.getParentId();
        QFilter modelfilter = new QFilter("model", "=", (Object)modelId);
        log.info("fananNumber:" + centralAppPlan);
        Boolean isjsutView = false;
        Map<Object, DynamicObject> approvePlanObjs = null;
        if (centralAppPlan == null) {
            DefaultAdjustingdimensionsTool.returnDefault((Long)modelId);
            QFilter isdefaultefilter = new QFilter("isdefaulte", "=", (Object)true);
            approvePlanObjs = this.queryAdjust(modelfilter.and(isdefaultefilter));
        } else {
            HashSet<String> plans = new HashSet<String>(Arrays.asList(centralAppPlan.trim().split(",")));
            QFilter qFilter = new QFilter("number", "in", plans);
            approvePlanObjs = this.queryAdjust(modelfilter.and(qFilter));
        }
        for (Map.Entry entry : approvePlanObjs.entrySet()) {
            ApprovePlan approvePlan = new ApprovePlan();
            DynamicObject value = (DynamicObject)entry.getValue();
            ArrayList<ApproveAdjustDimEntry> appDimMemLevel = new ArrayList<ApproveAdjustDimEntry>(16);
            DynamicObjectCollection adjdimentryentity = value.getDynamicObjectCollection("eb_adjustdimensionentity");
            if (CollectionUtils.isNotEmpty((Collection)adjdimentryentity)) {
                for (DynamicObject dynamicObject : adjdimentryentity) {
                    ApproveAdjustDimEntry approveAdjustDimEntry = new ApproveAdjustDimEntry();
                    DynamicObject dimensionid = dynamicObject.getDynamicObject("dimension");
                    if (dimensionid != null) {
                        String dimNum = dimensionid.getString("number");
                        approveAdjustDimEntry.setDimNumber(dimNum);
                    }
                    String dimmemlevel = dynamicObject.getString("dimmemlevel");
                    String type = dynamicObject.getString("type");
                    String orgreferencefield = dynamicObject.getString("orgreferencefield");
                    ApproveAdjDimTypeEnum.RangeTypeEnum typeByValue = ApproveAdjDimTypeEnum.RangeTypeEnum.getTypeByValue((String)type);
                    approveAdjustDimEntry.setLevel(dimmemlevel);
                    approveAdjustDimEntry.setEntityField(orgreferencefield);
                    approveAdjustDimEntry.setType(typeByValue);
                    Object dimsidw = dynamicObject.get("dimsid");
                    if (dimsidw != null && !dimsidw.equals("") && !isjsutView.booleanValue()) {
                        long[] membersa;
                        JSONObject jsonObject = JSONObject.parseObject((String)dimsidw.toString());
                        HashSet<Long> members = new HashSet<Long>(16);
                        long[] lArray = membersa = jsonObject.entrySet().stream().mapToLong(tmp -> Long.parseLong((String)tmp.getKey())).toArray();
                        int n = lArray.length;
                        for (int i = 0; i < n; ++i) {
                            Long membersid = lArray[i];
                            members.add(membersid);
                        }
                        approveAdjustDimEntry.setMembers(members);
                    }
                    appDimMemLevel.add(approveAdjustDimEntry);
                }
            }
            approvePlan.setAppDimMemLevel(appDimMemLevel);
            result.add(approvePlan);
        }
        Map appDimMemLevel = ShowInfoCreateUtil.getInstance().getAppDimMemLevel(this.showInfo, this.approveBill, result);
        this.showInfo.setAppDimMemLevel(appDimMemLevel);
        return null;
    }

    private Map<Object, DynamicObject> queryAdjust(QFilter filter) {
        Map approvePlanObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_adjustdimension", (QFilter[])filter.toArray());
        return approvePlanObjs;
    }

    private List<ApproveBillConfig> getApproveBillConfigs(ApproveBill approveBill) {
        Long parentId = approveBill.getParentId();
        ArrayList<ApproveBillConfig> configs = new ArrayList<ApproveBillConfig>(16);
        this.showInfo.setHasSubChildren(approveBill.isHasSubitems());
        if (parentId == null || parentId == 0L) {
            this.showInfo.setMainBill(true);
        } else {
            configs.addAll(approveBill.getApproveconfig());
            this.showInfo.setMainBill(false);
        }
        return configs;
    }

    @Override
    protected void filterDataByPerm() {
        ShowInfoCreateUtil.getInstance().filterDataByPerm(this.showInfo, this.getModelId(), this.getPermType());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("selectchain".equals(key)) {
            Object billNo = this.getModel().getValue("billno");
            if (billNo == null) {
                this.getView().showTipNotification("billNo input is empty!");
                return;
            }
            Long modelId = this.getModelId();
            if (modelId == 0L) {
                this.getView().showTipNotification("model input is empty!");
                return;
            }
            CentralAppChain centralAppChainByBills = CentralAppBillService.getInstance().getCentralAppChainByBills(billNo.toString(), modelId);
            List centralAppChains = CentralAppBillService.getInstance().getCentralAppChains(centralAppChainByBills);
            this.getView().showTipNotification("CentralAppChain: " + SerializationUtils.toJsonString((Object)centralAppChainByBills) + "\nChainList: " + SerializationUtils.toJsonString((Object)centralAppChains));
        }
    }

    @Override
    protected void setApproveInfo() {
        ShowInfoCreateUtil.getInstance().initApproveInfo(this.getApproveBill(), this.showInfo);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        String key = this.getPageCache().get("id");
        if (key != null) {
            BgApplyLockUtils.removeMutuallyExclusiveObject(Collections.singletonList(key));
        }
        this.releaseMutex();
    }

    @Override
    protected void checkMutex() {
        if (this.isFromApproveList()) {
            Long userId = this.getUserId();
            String loginIP = RequestContext.getOrCreate().getLoginIP();
            String Keys = this.getApproveBill().getId().toString();
            BgApplyLockUtils.lock((String)Keys, () -> {
                String returnVerificationInformation = BgApplyLockUtils.returnVerificationInformation(new ArrayList<String>(Collections.singleton(Keys)));
                if (returnVerificationInformation != null) {
                    this.getView().showTipNotification(returnVerificationInformation);
                    this.showInfo.setBillShowStatus("notApprove");
                    this.cacheCurNodeMutex();
                } else {
                    ArrayList<BgApplyMutexPojo> bgApplyMutexPojos = new ArrayList<BgApplyMutexPojo>();
                    BgApplyMutexPojo bgApplyMutexPojo = new BgApplyMutexPojo();
                    bgApplyMutexPojo.setUserId(userId.toString());
                    bgApplyMutexPojo.setUserIP(loginIP);
                    bgApplyMutexPojo.setApprovalId(this.getApproveBill().getId().toString());
                    bgApplyMutexPojo.setUserName(UserServiceHelper.getCurrentUser((String)"name").getString("name"));
                    bgApplyMutexPojos.add(bgApplyMutexPojo);
                    BgApplyLockUtils.setMutuallyExclusiveObject(bgApplyMutexPojos);
                    this.getView().getPageCache().put("id", Keys);
                }
            });
        }
    }

    private void cacheCurNodeMutex() {
        this.getPageCache().put("curNodeMutex", "true");
    }

    private boolean isCurNodeMutex() {
        String curNodeMutex = this.getPageCache().get("curNodeMutex");
        return !StringUtils.isEmpty((String)curNodeMutex) && "true".equals(curNodeMutex);
    }

    private void clearCurNodeMutexCache() {
        this.getPageCache().remove("curNodeMutex");
    }

    private void releaseMutex() {
        this.clearCurNodeMutexCache();
        MutexLockInfo curMutex = this.getCurMutex();
        if (curMutex == null) {
            return;
        }
        String billNo = curMutex.getBillNo();
        String curNode = curMutex.getCurNode();
        String uniqueKey = curMutex.getUniqueKey();
        Long userId = curMutex.getUserId();
        if (billNo == null || curNode == null || uniqueKey == null || userId == null || userId == 0L) {
            return;
        }
        ApproveBillUtil.getInstance().releaseMutex(billNo, curNode, userId, uniqueKey);
    }
}

