/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.combinoffset;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.PreMetricEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.combinoffset.OffsetEntryEntity;
import kd.epm.eb.formplugin.combinoffset.OffsetEntryService;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class OffsetEntryAddNewPluginV2
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log;
    private static final String MODEL = "model";
    private static final String BUSMODEL = "busmodel";
    private static final String AUDITTRIAL = "audittrail";
    private static final String CONSOLORG = "cslorg";
    private static final String CONSOLORG_VIEW = "cslorgview";
    private static final String PERIOD = "budgetperiod";
    private static final String METRICLIST = "metriclist";
    private static final String DATATYPE = "datatype";
    private static final String VERSION = "version";
    private static final String CURRENCY = "currency";
    private static final String METRIC = "metric";
    private static final String METRICQTY = "metricqty";
    private static final String SEND = "send_";
    private static final String REC = "rec_";
    private static final String MYCOMPANY = "mycompany";
    private static final String ICOMPANY = "icompany";
    private static final String ACCOUNT = "account";
    private static final String CHANGETYPE = "changetype";
    private static final String CHANGETYPE_VIEW = "changetypeview";
    private static final String OFFSETSUPDIM = "offsetsupdim";
    private static final String OFFSETCATALOG = "offsetcatalog";
    private static final String DIM = "dim";
    private static final String BTN_SAVE = "btn_save";
    private static final String ENTITY = "entity";
    private static final String MONEY;
    private static final String AMOUNT;
    private static final String CACHE_SELECTEDPERIOD = "selectedPeriod";
    private static final String CACHE_SUP_DIMENSION = "supDimNumber";
    private static final String CACHE_DIM_VIEW = "dimViewCache";
    private static final String K_DATASETID = "datasetid!";
    private static final String K_VALUE = "value!";
    private static final String MY_ORG_TXT = "my_orgtxt";
    private static final String SEND_NAME;
    private static final String REC_NAME;
    private static final List<String> PERIOD_PRESET_KEY;
    private static final Set<String> baseDataKeys;
    private static final Set<String> entryBaseDataKeys;
    private boolean ignorePropertyChanged = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, entryBaseDataKeys.toArray(new String[0]));
        this.addF7SelectListener(this, baseDataKeys.toArray(new String[0]));
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(MODEL);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{MY_ORG_TXT});
        this.setDefaultValue();
        this.reloadSupDimension();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isEdit() || this.isCopyAdd() || this.isReview()) {
            this.setSelfDims();
            this.setPeriod();
            if (this.isEdit()) {
                this.setEntryDisplay(this.getId());
                this.getView().setEnable(Boolean.FALSE, new String[]{MODEL, BUSMODEL, PERIOD});
            } else if (this.isReview()) {
                this.setEntryDisplay(this.getId());
                this.getView().setEnable(Boolean.FALSE, new String[]{MODEL, BUSMODEL, PERIOD, CONSOLORG, VERSION, DATATYPE, AUDITTRIAL, CURRENCY, CHANGETYPE, METRICLIST, OFFSETSUPDIM, OFFSETCATALOG});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE, "advcontoolbarap1", "advcontoolbarap"});
            }
        } else {
            this.hideSupDimCloumns();
            this.hidePeriodCloumns();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_SAVE.equals(itemKey)) {
            this.save();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        block16: {
            String key;
            block14: {
                block15: {
                    super.propertyChanged(e);
                    key = e.getProperty().getName();
                    if (!MODEL.equals(key)) break block14;
                    if (e.getChangeSet()[0].getNewValue() != null || e.getChangeSet()[0].getOldValue() == null) break block15;
                    this.ignorePropertyChanged = true;
                    this.getModel().setValue(key, e.getChangeSet()[0].getOldValue());
                    break block16;
                }
                if (this.ignorePropertyChanged) break block16;
                this.clearAllData();
                break block16;
            }
            if (BUSMODEL.equals(key)) {
                this.reloadSupDimension();
                this.getModel().beginInit();
                this.getModel().setValue(CONSOLORG, null);
                this.getModel().endInit();
                this.getModel().setValue(OFFSETSUPDIM, (Object)"");
                this.getModel().deleteEntryData("send_entity");
                this.getModel().deleteEntryData("rec_entity");
                this.getView().updateView(CONSOLORG);
                this.getPageCache().remove(CACHE_DIM_VIEW);
            } else if (PERIOD.equals(key)) {
                MulBasedataDynamicObjectCollection selectedPeriods = (MulBasedataDynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                if (selectedPeriods != null && selectedPeriods.size() > 24) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e924\u4e2a\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OffsetEntryAddNewPluginV2_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(key, e.getChangeSet()[0].getOldValue());
                    return;
                }
                this.setPeriod();
            } else if (OFFSETSUPDIM.equals(key)) {
                this.setSelfDims();
            } else if (METRICLIST.equals(key)) {
                this.setMetric();
            } else if (CONSOLORG.equals(key)) {
                DynamicObjectCollection recEntity;
                DynamicObjectCollection sendEntity = this.getModel().getEntryEntity("send_entity");
                if (sendEntity != null) {
                    for (int i = 0; i < sendEntity.size(); ++i) {
                        this.getModel().setValue("send_mycompany", null, i);
                        this.getModel().setValue("send_mycompanyview", null, i);
                        this.getModel().setValue("send_icompany", null, i);
                        this.getModel().setValue("send_icompanyview", null, i);
                    }
                }
                if ((recEntity = this.getModel().getEntryEntity("rec_entity")) != null) {
                    for (int i = 0; i < recEntity.size(); ++i) {
                        this.getModel().setValue("rec_mycompany", null, i);
                        this.getModel().setValue("rec_mycompanyview", null, i);
                        this.getModel().setValue("rec_icompany", null, i);
                        this.getModel().setValue("rec_icompanyview", null, i);
                    }
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (AdminModelUtil.checkAdminModeNeedResult((Long)this.getModelId(), (IFormView)this.getView())) {
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if (source instanceof EntryGridOperate && this.getModel().getValue(CONSOLORG) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5408\u5e76\u8303\u56f4\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OffsetEntryAddnewPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        if (MODEL.equals(key)) {
            if (evt.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>(16);
                }
                qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
                if (!this.isNewEbForm()) {
                    QFilter filter = new QFilter("reporttype", "=", (Object)"7");
                    qFilterList.add(filter);
                }
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
            return;
        }
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"OffsetEntryAddNewPluginV2_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (BUSMODEL.equals(key)) {
            qFilters.add(new QFilter("viewentry.dimension.number", "=", (Object)"InternalCompany"));
            qFilters.add(new QFilter(MODEL, "=", (Object)modelId));
            return;
        }
        Long busModelId = this.getBaseDataId(BUSMODEL);
        if (busModelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"OffsetEntryAddNewPluginV2_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (CONSOLORG.equals(key)) {
            qFilters.add(new QFilter("mergernode", "=", (Object)Boolean.TRUE));
        } else if (!key.endsWith("company")) {
            qFilters.add(new QFilter("isleaf", "=", (Object)Character.valueOf('1')));
        }
        if (AUDITTRIAL.equals(key)) {
            qFilters.add(new QFilter("use", "=", (Object)"20"));
        }
        this.setEntryF7Qfilter(evt);
        LeftTreeF7Parameter left = new LeftTreeF7Parameter();
        left.setMultiple(PERIOD.equals(key));
        if ("send_account".equals(key) || "rec_account".equals(key)) {
            left.setShowDrcrdirect(true);
        }
        left.setForceDisableView(true);
        if ("send_mycompany".equals(key) || "rec_icompany".equals(key)) {
            long viewId = this.getDimView(SysDimensionEnum.Entity.getNumber(), CONSOLORG);
            left.setViewId(Long.valueOf(viewId));
            left.setForceDisableView(false);
        } else if ("send_icompany".equals(key) || "rec_mycompany".equals(key)) {
            Object viewObj = this.getModel().getValue(key + "view");
            long viewId = viewObj != null ? ((DynamicObject)viewObj).getLong("id") : this.getDimView(SysDimensionEnum.InternalCompany.getNumber(), "");
            left.setViewId(Long.valueOf(viewId));
        } else if (key.startsWith("send_dim") || key.startsWith("rec_dim")) {
            Object viewObj = this.getModel().getValue(key + "view");
            long viewId = viewObj != null ? ((DynamicObject)viewObj).getLong("id") : this.getDimView(this.getCurrentDimNumber(key), "");
            left.setViewId(Long.valueOf(viewId));
        }
        this.switchLeftTreeF7(evt, this.getBaseDataId(BUSMODEL), left, new CloseCallBack((IFormPlugin)this, "F7_" + key));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if (actionId.startsWith("F7_")) {
            String key = actionId.replaceFirst("F7_", "");
            ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
            if (PERIOD.equals(key)) {
                A[] collect = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(Object[]::new);
                this.getModel().setValue(key, collect);
            } else {
                ListSelectedRow selectedRow = rows.get(0);
                this.getModel().setValue(key, selectedRow.getPrimaryKeyValue());
                Long viewId = (Long)selectedRow.getDataMap().get("viewid");
                if (viewId != null) {
                    this.getModel().setValue(key + "view", (Object)viewId);
                }
            }
        }
    }

    private void setDefaultValue() {
        IDataModel iDataModel = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.getView().getFormShowParameter().getCustomParam("id") == null) {
            iDataModel.setValue(MODEL, (Object)customParams.getOrDefault(MODEL, 0L));
            iDataModel.setValue(VERSION, (Object)customParams.getOrDefault(VERSION, 0L));
            iDataModel.setValue(DATATYPE, (Object)customParams.getOrDefault(DATATYPE, 0L));
            iDataModel.setValue(CURRENCY, (Object)customParams.getOrDefault(CURRENCY, 0L));
            iDataModel.setValue(CONSOLORG, (Object)customParams.getOrDefault(CONSOLORG, 0L));
        } else {
            DynamicObject ob;
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(customParams.get("id").toString()), (String)"eb_offsetentry");
            this.writeLog(null, "query", new MultiLangEnumBridge("\u67e5\u8be2", "OffsetPaperPlugin_21", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u67e5\u770b\u62b5\u6d88\u5206\u5f55\u6210\u529f\u3002", "OffsetPaperPlugin_22", "epm-eb-formplugin"), new String[]{this.getView().getFormShowParameter().getCustomParam("id").toString()});
            List<String> keys = Arrays.asList(MODEL, BUSMODEL, CONSOLORG, CONSOLORG_VIEW, AUDITTRIAL, DATATYPE, VERSION, CURRENCY, CHANGETYPE, CHANGETYPE_VIEW);
            for (String key : keys) {
                ob = object.getDynamicObject(key);
                if (ob != null) {
                    iDataModel.setValue(key, (Object)ob.getLong("id"));
                    continue;
                }
                if (CONSOLORG_VIEW.equals(key)) {
                    iDataModel.setValue(key, (Object)this.getDimView(SysDimensionEnum.Entity.getNumber(), ""));
                    continue;
                }
                if (!CHANGETYPE_VIEW.equals(key)) continue;
                iDataModel.setValue(key, (Object)this.getDimView(SysDimensionEnum.ChangeType.getNumber(), ""));
            }
            ob = object.getDynamicObject("period");
            if (ob != null) {
                Object[] o = new Object[]{object.getDynamicObject("period").getString("id")};
                iDataModel.setValue(PERIOD, (Object)o);
            }
            iDataModel.setValue(OFFSETCATALOG, (Object)object.getString(OFFSETCATALOG));
            ArrayList<String> numbers = new ArrayList<String>(9);
            if (object.getDynamicObject(METRIC) != null) {
                numbers.add("Money");
            }
            if (object.getDynamicObject(METRICQTY) != null) {
                numbers.add("Amount");
            }
            iDataModel.setValue(METRICLIST, (Object)String.join((CharSequence)",", numbers));
            numbers.clear();
            for (int i = 1; i < 7; ++i) {
                ob = object.getDynamicObject("selfdim" + i);
                if (ob == null) continue;
                numbers.add(ob.getString("dimension.number"));
            }
            iDataModel.setValue(OFFSETSUPDIM, (Object)String.join((CharSequence)",", numbers));
            iDataModel.setValue(OFFSETCATALOG, (Object)object.getString(OFFSETCATALOG));
        }
    }

    private void reloadSupDimension() {
        List<String> supDimNumbers = this.getSupDimNumbers();
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(OFFSETSUPDIM);
        ArrayList<ComboItem> lists = new ArrayList<ComboItem>(supDimNumbers.size());
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (String supDimNumber : supDimNumbers) {
            Dimension dim = orCreate.getDimension(supDimNumber);
            if (dim == null) continue;
            lists.add(new ComboItem(new LocaleString(dim.getName()), dim.getNumber()));
        }
        mulComboEdit.setComboItems(lists);
    }

    private void setPeriod() {
        this.hidePeriodCloumns();
        IFormView iFormView = this.getView();
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue(PERIOD);
        Map<String, String> selectedPeriod = this.getPeriodCahe();
        Map<String, List<List<Pair>>> selectedPeriodValues = this.getSelectedPeriodValues(selectedPeriod);
        HashMap<String, String> newSelectPeriods = new HashMap<String, String>(16);
        if (periods != null && periods.size() > 0) {
            boolean isMoney = this.isMoney();
            boolean isAmount = this.isAmount();
            EntryGrid send = (EntryGrid)this.getControl("send_entity");
            EntryGrid rec = (EntryGrid)this.getControl("rec_entity");
            ArrayList<String> relaKeys = new ArrayList<String>(periods.size() * 4);
            for (DynamicObject period : periods) {
                DynamicObject ob = period.getDynamicObject("fbasedataid");
                String name = ob.getString("name");
                String number = ob.getString("number");
                String key = this.getNewKey(null, newSelectPeriods, number);
                newSelectPeriods.put(number, key);
                send.setColumnProperty(SEND + key, "header", (Object)new LocaleString(name));
                rec.setColumnProperty(REC + key, "header", (Object)new LocaleString(name));
                relaKeys.add(SEND + key);
                relaKeys.add(REC + key);
                if (isMoney) {
                    relaKeys.add("send_m" + key);
                    relaKeys.add("rec_m" + key);
                }
                if (!isAmount) continue;
                relaKeys.add("send_a" + key);
                relaKeys.add("rec_a" + key);
            }
            iFormView.setVisible(Boolean.TRUE, relaKeys.toArray(new String[0]));
            iFormView.updateView("send_entity");
            iFormView.updateView("rec_entity");
        }
        this.clearEntryColumns(selectedPeriod.values(), true);
        this.restoreelectedPeriodValues(selectedPeriodValues, newSelectPeriods);
        this.getPageCache().put(CACHE_SELECTEDPERIOD, SerializationUtils.toJsonString(newSelectPeriods));
    }

    private void setSelfDims() {
        this.hideSupDimCloumns();
        EntryGrid send = (EntryGrid)this.getControl("send_entity");
        EntryGrid rec = (EntryGrid)this.getControl("rec_entity");
        List<String> values = this.getSelfDimCombValue();
        List<String> supDimCache = this.getSupDimCache();
        ArrayList<String> relaKeys = new ArrayList<String>(values.size() * 2);
        HashSet<Integer> usedIndex = new HashSet<Integer>(16);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (String s : values) {
            Dimension dimension;
            int index = supDimCache.indexOf(s) + 1;
            if (index == 0 || (dimension = orCreate.getDimension(s)) == null) continue;
            usedIndex.add(index);
            String key = DIM + index;
            relaKeys.add(SEND + key);
            relaKeys.add(SEND + key + "view");
            relaKeys.add(REC + key);
            relaKeys.add(REC + key + "view");
            send.setColumnProperty(SEND + key, "header", (Object)new LocaleString(dimension.getName()));
            rec.setColumnProperty(REC + key, "header", (Object)new LocaleString(dimension.getName()));
        }
        IFormView iFormView = this.getView();
        iFormView.setVisible(Boolean.TRUE, relaKeys.toArray(new String[0]));
        ArrayList<String> removeKeys = new ArrayList<String>(9);
        for (int i = 1; i < 7; ++i) {
            if (usedIndex.contains(i)) continue;
            removeKeys.add(DIM + i);
        }
        this.clearEntryColumns(removeKeys, Boolean.FALSE);
        iFormView.updateView("send_entity");
        iFormView.updateView("rec_entity");
    }

    private void setMetric() {
        Map<String, String> periodCahe = this.getPeriodCahe();
        if (periodCahe.isEmpty()) {
            return;
        }
        HashSet<String> relaKeys = new HashSet<String>(16);
        for (String value : periodCahe.values()) {
            relaKeys.add("send_a" + value);
            relaKeys.add("rec_a" + value);
            relaKeys.add("rec_m" + value);
            relaKeys.add("send_m" + value);
        }
        IFormView iFormView = this.getView();
        iFormView.setVisible(Boolean.FALSE, relaKeys.toArray(new String[0]));
        boolean isMoney = this.isMoney();
        boolean isAmount = this.isAmount();
        HashSet<String> clearKey = new HashSet<String>(16);
        for (String key : periodCahe.values()) {
            if (!isMoney) {
                relaKeys.remove("send_m" + key);
                relaKeys.remove("rec_m" + key);
                clearKey.add("m" + key);
            }
            if (isAmount) continue;
            relaKeys.remove("send_a" + key);
            relaKeys.remove("rec_a" + key);
            clearKey.add("a" + key);
        }
        this.clearEntryColumns(clearKey, false);
        iFormView.setVisible(Boolean.TRUE, relaKeys.toArray(new String[0]));
        this.clearEntryColumns(Collections.singletonList(ACCOUNT), false);
        iFormView.updateView("send_entity");
        iFormView.updateView("rec_entity");
    }

    private List<String> getSelfDimCombValue() {
        String dims;
        ArrayList<String> selfDims = new ArrayList<String>(12);
        Object value = this.getModel().getValue(OFFSETSUPDIM);
        String string = dims = value == null ? "" : ((String)value).trim();
        if (StringUtils.isNotEmpty((String)dims)) {
            String[] split;
            for (String s : split = dims.split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                selfDims.add(s);
            }
        }
        return selfDims;
    }

    private List<String> getSupDimNumbers() {
        ArrayList<String> numbers = new ArrayList<String>(10);
        Long modelId = this.getModelId();
        Long busModelId = this.getBaseDataId(BUSMODEL);
        if (modelId != 0L && busModelId != 0L) {
            String assistdim;
            QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
            qfBuilder.add(BUSMODEL, "=", (Object)busModelId);
            qfBuilder.add("level", "=", (Object)2);
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_offsetrulecatalog", (String)"assistdim", (QFilter[])qfBuilder.toArray());
            if (object != null && StringUtils.isNotEmpty((String)(assistdim = object.getString("assistdim")))) {
                String[] split;
                for (String dimNum : split = assistdim.split(",")) {
                    if (!StringUtils.isNotEmpty((String)dimNum)) continue;
                    numbers.add(dimNum);
                }
            }
        }
        this.getPageCache().put(CACHE_SUP_DIMENSION, SerializationUtils.toJsonString(numbers));
        return numbers;
    }

    private boolean isCopyAdd() {
        return this.getView().getFormShowParameter().getCustomParam("copytag") != null;
    }

    private boolean isEdit() {
        return this.getView().getFormShowParameter().getCustomParam("id") != null && !this.isCopyAdd() && !this.isReview();
    }

    private boolean isReview() {
        return this.getView().getFormShowParameter().getCustomParam("review") != null;
    }

    public Long getModelId() {
        Long id = (Long)this.getValue(MODEL, "id");
        if (id == null) {
            id = 0L;
        }
        return id;
    }

    private Long getBaseDataId(String key) {
        Long id = (Long)this.getValue(key, "id");
        if (id == null) {
            id = 0L;
        }
        return id;
    }

    private boolean isMoney() {
        return (this.getModel().getValue(METRICLIST) + "").contains(MONEY);
    }

    private boolean isAmount() {
        return (this.getModel().getValue(METRICLIST) + "").contains(AMOUNT);
    }

    private Map<String, String> getPeriodCahe() {
        String cache = this.getPageCache().get(CACHE_SELECTEDPERIOD);
        if (cache == null) {
            return new HashMap<String, String>(0);
        }
        return (Map)SerializationUtils.fromJsonString((String)cache, HashMap.class);
    }

    private List<String> getSupDimCache() {
        String cache = this.getPageCache().get(CACHE_SUP_DIMENSION);
        if (cache == null) {
            return new ArrayList<String>(0);
        }
        return (List)SerializationUtils.fromJsonString((String)cache, ArrayList.class);
    }

    private String getNewKey(Map<String, String> selectedPeriod, Map<String, String> newSelectPeriods, String number) {
        String key;
        HashSet oldKeys = selectedPeriod == null ? new HashSet(16) : new HashSet<String>(selectedPeriod.values());
        String string = key = selectedPeriod == null ? null : selectedPeriod.remove(number);
        if (key != null) {
            return key;
        }
        for (String periodKey : PERIOD_PRESET_KEY) {
            if (oldKeys.contains(periodKey) || newSelectPeriods.containsValue(periodKey)) continue;
            key = periodKey;
            break;
        }
        return key;
    }

    private void clearEntryColumns(Collection<String> keys, boolean isperiod) {
        IDataModel iDataModel = this.getModel();
        int rec = iDataModel.getEntryRowCount("rec_entity");
        int send = iDataModel.getEntryRowCount("send_entity");
        for (String key : keys) {
            int i;
            for (i = 0; i < send; ++i) {
                if (isperiod) {
                    iDataModel.setValue("send_a" + key, (Object)"", i);
                    iDataModel.setValue("send_m" + key, (Object)"", i);
                    continue;
                }
                iDataModel.setValue(SEND + key, (Object)"", i);
            }
            for (i = 0; i < rec; ++i) {
                if (isperiod) {
                    iDataModel.setValue("rec_a" + key, (Object)"", i);
                    iDataModel.setValue("rec_m" + key, (Object)"", i);
                    continue;
                }
                iDataModel.setValue(REC + key, (Object)"", i);
            }
        }
    }

    private Map<String, List<List<Pair>>> getSelectedPeriodValues(Map<String, String> periods) {
        HashMap<String, List<List<Pair>>> result = new HashMap<String, List<List<Pair>>>(16);
        if (periods != null && !periods.isEmpty()) {
            IDataModel iDataModel = this.getModel();
            int rec = iDataModel.getEntryRowCount("rec_entity");
            int send = iDataModel.getEntryRowCount("send_entity");
            for (Map.Entry<String, String> entry : periods.entrySet()) {
                int i;
                String periodNumber = entry.getKey();
                String ctrlKey = entry.getValue();
                ArrayList sendRecList = Lists.newArrayListWithCapacity((int)2);
                result.put(periodNumber, sendRecList);
                ArrayList<Pair> sendAMPairs = new ArrayList<Pair>(send);
                ArrayList<Pair> recAMPairs = new ArrayList<Pair>(rec);
                sendRecList.add(sendAMPairs);
                sendRecList.add(recAMPairs);
                for (i = 0; i < send; ++i) {
                    sendAMPairs.add(Pair.onePair((Object)iDataModel.getValue("send_a" + ctrlKey, i), (Object)iDataModel.getValue("send_m" + ctrlKey, i)));
                }
                for (i = 0; i < rec; ++i) {
                    recAMPairs.add(Pair.onePair((Object)iDataModel.getValue("rec_a" + ctrlKey, i), (Object)iDataModel.getValue("rec_m" + ctrlKey, i)));
                }
            }
        }
        return result;
    }

    private void restoreelectedPeriodValues(Map<String, List<List<Pair>>> oldSelectedPeriodValues, Map<String, String> newSelectPeriods) {
        if (oldSelectedPeriodValues == null || oldSelectedPeriodValues.isEmpty() || newSelectPeriods == null || newSelectPeriods.isEmpty()) {
            return;
        }
        IDataModel iDataModel = this.getModel();
        int rec = iDataModel.getEntryRowCount("rec_entity");
        int send = iDataModel.getEntryRowCount("send_entity");
        for (Map.Entry<String, String> entry : newSelectPeriods.entrySet()) {
            Pair amPair;
            int i;
            String periodNumber = entry.getKey();
            String key = entry.getValue();
            List<List<Pair>> periodValues = oldSelectedPeriodValues.get(periodNumber);
            if (periodValues == null || periodValues.isEmpty()) continue;
            List<Pair> sendAMPairs = periodValues.get(0);
            List<Pair> recAMPairs = periodValues.get(1);
            if (sendAMPairs != null && sendAMPairs.size() == send) {
                for (i = 0; i < send; ++i) {
                    amPair = sendAMPairs.get(i);
                    if (amPair == null) continue;
                    iDataModel.setValue("send_a" + key, amPair.p1, i);
                    iDataModel.setValue("send_m" + key, amPair.p2, i);
                }
            }
            if (recAMPairs == null || recAMPairs.size() != rec) continue;
            for (i = 0; i < rec; ++i) {
                amPair = recAMPairs.get(i);
                if (amPair == null) continue;
                iDataModel.setValue("rec_a" + key, amPair.p1, i);
                iDataModel.setValue("rec_m" + key, amPair.p2, i);
            }
        }
    }

    private void hidePeriodCloumns() {
        ArrayList filedsToHide = new ArrayList(16);
        ArrayList controls = new ArrayList(16);
        controls.addAll(((EntryGrid)this.getView().getControl("send_entity")).getControls());
        controls.addAll(((EntryGrid)this.getView().getControl("rec_entity")).getControls());
        controls.forEach(e -> {
            if (e.getKey().contains("_ap")) {
                filedsToHide.add(e.getKey());
                filedsToHide.add(e.getKey().replaceFirst("_a", "_"));
                filedsToHide.add(e.getKey().replaceFirst("_a", "_m"));
            }
        });
        this.getView().setVisible(Boolean.FALSE, filedsToHide.toArray(new String[0]));
    }

    private void hideSupDimCloumns() {
        ArrayList filedsToHide = new ArrayList(16);
        ArrayList controls = new ArrayList(16);
        controls.addAll(((EntryGrid)this.getView().getControl("send_entity")).getControls());
        controls.addAll(((EntryGrid)this.getView().getControl("rec_entity")).getControls());
        controls.forEach(e -> {
            if (e.getKey().contains("_dim")) {
                filedsToHide.add(e.getKey());
            }
        });
        this.getView().setVisible(Boolean.FALSE, filedsToHide.toArray(new String[0]));
    }

    private void setEntryDisplay(Long id) {
        IDataModel iDataModel = this.getModel();
        iDataModel.deleteEntryData("send_entity");
        iDataModel.deleteEntryData("rec_entity");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_offsetentry");
        DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            String prefix = "1".equals(entry.getString("source")) ? SEND : REC;
            int rowIndex = iDataModel.createNewEntryRow(prefix + ENTITY);
            this.setEntryValue(prefix, rowIndex, entry, object);
        }
        IFormView iFormView = this.getView();
        iFormView.updateView("send_entity");
        iFormView.updateView("rec_entity");
    }

    private void setEntryValue(String prefix, int row, DynamicObject entry, DynamicObject object) {
        String key;
        IDataModel iDataModel = this.getModel();
        ArrayList<String> entryKey = new ArrayList<String>(16);
        long orgViewId = entry.getDynamicObject("myorgview") != null ? entry.getDynamicObject("myorgview").getLong("id") : this.getDimView(SysDimensionEnum.Entity.getNumber(), "");
        long icOrgViewId = entry.getDynamicObject("interorgview") != null ? entry.getDynamicObject("interorgview").getLong("id") : this.getDimView(SysDimensionEnum.InternalCompany.getNumber(), "");
        if (SEND.equals(prefix)) {
            iDataModel.setValue("send_mycompany", (Object)entry.getDynamicObject("myorg").getString("id"), row);
            iDataModel.setValue("send_icompany", (Object)entry.getDynamicObject("interorg").getString("id"), row);
            iDataModel.setValue("send_mycompanyview", (Object)orgViewId, row);
            iDataModel.setValue("send_icompanyview", (Object)icOrgViewId, row);
            entryKey.add("send_mycompany");
            entryKey.add("send_icompany");
        } else {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Member member = modelCache.getMember(SysDimensionEnum.InternalCompany.getNumber(), Long.valueOf(icOrgViewId), entry.getString("myorg.number"));
            if (member != null) {
                Long id = member.getId();
                boolean exists = QueryServiceHelper.exists((String)"epm_icmembertree", (Object)id);
                if (!exists) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"rec_mycompany"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{MY_ORG_TXT});
                    OrmLocaleValue localeLang = (OrmLocaleValue)entry.getDynamicObject("myorg").get("name");
                    String langTag = RequestContext.get().getLang().getLangTag();
                    String orgName = localeLang.get((Object)langTag);
                    iDataModel.setValue(MY_ORG_TXT, (Object)orgName, row);
                } else {
                    iDataModel.setValue("rec_mycompany", (Object)member.getId(), row);
                    iDataModel.setValue("rec_mycompanyview", (Object)icOrgViewId, row);
                    entryKey.add("rec_mycompany");
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rec_mycompany"});
                this.getView().setVisible(Boolean.TRUE, new String[]{MY_ORG_TXT});
                iDataModel.setValue(MY_ORG_TXT, (Object)entry.getString("myorg.name"), row);
            }
            member = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(orgViewId), entry.getString("interorg.number"));
            if (member != null) {
                iDataModel.setValue("rec_icompany", (Object)member.getId(), row);
                iDataModel.setValue("rec_icompanyview", (Object)orgViewId, row);
                entryKey.add("rec_icompany");
            }
        }
        iDataModel.setValue(prefix + ACCOUNT, (Object)entry.getDynamicObject(ACCOUNT).getLong("id"), row);
        entryKey.add(prefix + ACCOUNT);
        for (int i = 1; i < 7; ++i) {
            key = DIM + i;
            DynamicObject dim = object.getDynamicObject("self" + key);
            DynamicObject dimView = object.getDynamicObject("self" + key + "view");
            if (dim == null) continue;
            iDataModel.setValue(prefix + key, (Object)dim.getLong("id"), row);
            long selfDimViewId = dimView != null ? dimView.getLong("id") : this.getDimView(dim.getString("dimension.number"), "");
            iDataModel.setValue(prefix + key + "view", (Object)selfDimViewId, row);
            entryKey.add(prefix + key);
        }
        Map<String, String> periodCahe = this.getPeriodCahe();
        for (Map.Entry<String, String> Node2 : periodCahe.entrySet()) {
            key = Node2.getValue();
            iDataModel.setValue(prefix + "m" + key, (Object)Double.parseDouble(entry.getString("amount")), row);
            iDataModel.setValue(prefix + "a" + key, (Object)Double.parseDouble(entry.getString("amountqty")), row);
            entryKey.add(prefix + "m" + key);
            entryKey.add(prefix + "a" + key);
        }
        if (this.isReview()) {
            IFormView view = this.getView();
            view.setEnable(Boolean.FALSE, row, entryKey.toArray(new String[0]));
        }
    }

    private Long getId() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("id"));
    }

    private void setEntryF7Qfilter(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        int row = evt.getRow();
        if (key.endsWith("company")) {
            Set<String> entityNumber = this.getEntityNumber();
            String removeNumber = null;
            String replaceKey = null;
            replaceKey = key.endsWith("_mycompany") ? key.replace(MYCOMPANY, ICOMPANY) : key.replace(ICOMPANY, MYCOMPANY);
            Object value = this.getModel().getValue(replaceKey, row);
            if (value != null) {
                removeNumber = ((DynamicObject)value).getString("number");
            }
            entityNumber.remove(removeNumber);
            if ("send_mycompany".equals(key) || "rec_icompany".equals(key)) {
                entityNumber.removeIf(k -> k.endsWith("offsetentry"));
                qFilters.add(new QFilter("mergernode", "=", (Object)Character.valueOf('0')));
                qFilters.add(new QFilter("view.id", "=", (Object)this.getDimView(SysDimensionEnum.Entity.getNumber(), CONSOLORG)));
                qFilters.add(new QFilter("number", "in", entityNumber));
            } else {
                showParameter.setShowUsed(Boolean.FALSE.booleanValue());
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
                List icViewIds = modelCache.getViewGroupViewsByBusModelAndDimNumber(this.getBaseDataId(BUSMODEL), SysDimensionEnum.InternalCompany.getNumber());
                DynamicObjectCollection org = QueryServiceHelper.query((String)"eb_viewmember", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.getModelId()), new QFilter("view.id", "in", (Object)icViewIds), new QFilter("parent.number", "=", (Object)"ICEntity")});
                Set number = org.stream().map(d -> d.getString("number")).collect(Collectors.toSet());
                number.retainAll(entityNumber);
                qFilters.add(new QFilter("number", "in", number));
            }
        } else if (key.endsWith("_account")) {
            if (this.isMoney() && this.isAmount()) {
                qFilters.add(new QFilter("id", "in", this.getAccountIds()));
            } else if (this.isMoney()) {
                qFilters.add(new QFilter("entryentity.metric.number", "=", (Object)"Money"));
            } else if (this.isAmount()) {
                qFilters.add(new QFilter("entryentity.metric.number", "=", (Object)"Amount"));
            } else {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            }
            qFilters.add(new QFilter("drcrdirect", "!=", (Object)Character.valueOf('0')));
        } else if (key.contains("_dim")) {
            qFilters.add(new QFilter("isleaf", "=", (Object)Character.valueOf('1')));
        }
    }

    private Set<String> getEntityNumber() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        long viewId = this.getDimView(SysDimensionEnum.Entity.getNumber(), CONSOLORG);
        List member = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId), this.getValue(CONSOLORG, "number").toString(), RangeEnum.ALL_EXCLUDE.getIndex());
        return member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
    }

    private long getDimView(String dimNum, String dimKey) {
        long viewId;
        if (StringUtils.isEmpty((String)dimNum)) {
            return 0L;
        }
        Object viewObj = null;
        if (StringUtils.isNotEmpty((String)dimKey)) {
            String viewKey = dimKey + "view";
            viewObj = this.getModel().getValue(viewKey);
        }
        if (viewObj == null) {
            Long bizModelId = this.getBaseDataId(BUSMODEL);
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            viewId = IDUtils.toLong((Object)modelCache.getViewByBusModelAndDimNumber(bizModelId, dimNum));
        } else {
            viewId = ((DynamicObject)viewObj).getLong("id");
        }
        return viewId;
    }

    private Map<String, Long> getViewMap() {
        HashMap<String, Long> viewMap = new HashMap<String, Long>(8);
        viewMap.put(SysDimensionEnum.Entity.getNumber(), this.getDimView(SysDimensionEnum.Entity.getNumber(), CONSOLORG));
        viewMap.put(SysDimensionEnum.InternalCompany.getNumber(), this.getDimView(SysDimensionEnum.InternalCompany.getNumber(), "send_icompany"));
        List<String> selfDimList = this.getSelfDimCombValue();
        for (int i = 1; i <= selfDimList.size(); ++i) {
            String dim = selfDimList.get(i - 1);
            viewMap.put(dim, this.getDimView(dim, "send_dim" + i));
        }
        return viewMap;
    }

    public String getCurrentDimNumber(String key) {
        if (key.equals(PERIOD)) {
            return "BudgetPeriod";
        }
        if (key.equals(CONSOLORG)) {
            return "Entity";
        }
        if (key.equals(VERSION)) {
            return "Version";
        }
        if (key.equals(DATATYPE)) {
            return "DataType";
        }
        if (key.equals(AUDITTRIAL)) {
            return "AuditTrail";
        }
        if (key.equals(CURRENCY)) {
            return "Currency";
        }
        if (key.equals(CHANGETYPE)) {
            return "ChangeType";
        }
        if (key.equals("send_mycompany") || key.equals("rec_icompany")) {
            return "Entity";
        }
        if (key.equals("rec_mycompany") || key.equals("send_icompany")) {
            return "InternalCompany";
        }
        if (key.endsWith("_account")) {
            return "Account";
        }
        if (key.contains("_dim")) {
            List<String> dimCache = this.getSupDimCache();
            int index = Integer.parseInt(key.substring(key.length() - 1)) - 1;
            return index >= dimCache.size() ? null : dimCache.get(index);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u7ef4\u5ea6\u7f16\u7801\u3002", (String)"OffsetEntryAddnewPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private Set<Long> getAccountIds() {
        HashSet<Long> ids = new HashSet<Long>(16);
        String sql = "select t1.fid from t_eb_accountmetric t1 , t_eb_structofmetric t2 where t1.fmetric = t2.fid  and t2.fmodelid = ? and t2.fnumber in ('Money','Amount') group by t1.fid having count(t1.fid) = 2;";
        DataSet queryDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{this.getModelId()});
        if (queryDataSet != null && !queryDataSet.isEmpty()) {
            for (Row row : queryDataSet) {
                ids.add(row.getLong("fid"));
            }
        }
        return ids;
    }

    private void clearAllData() {
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        for (String key : baseDataKeys) {
            dataModel.setValue(key, null);
        }
        dataModel.setValue(METRICLIST, (Object)"");
        dataModel.setValue(OFFSETSUPDIM, (Object)"");
        dataModel.endInit();
        this.getPageCache().put(CACHE_SELECTEDPERIOD, null);
        this.getModel().deleteEntryData("send_entity");
        this.getModel().deleteEntryData("rec_entity");
        this.getView().updateView();
    }

    private void save() {
        this.deleteInvalidLine();
        List<List<OffsetEntryEntity>> lists = this.groupByTag();
        if (lists.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u6216\u63a5\u6536\u65b9\u4e3a\u7a7a\u3002", (String)"OffsetEntryAddnewPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isEdit() && lists.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u65f6\uff0c\u65b0\u589e\u5206\u5f55\u884c\u7684\u7ef4\u5ea6\u7ec4\u5408\uff08\u4e0d\u5305\u542b\u79d1\u76ee\uff09\u8981\u4e0e\u539f\u5355\u636e\u5206\u5f55\u884c\u4e00\u81f4\u3002", (String)"OffsetEntryAddnewPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List<String> errorInfo = this.checkEntry(lists);
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue(PERIOD);
        Map<String, String> periodCahe = this.getPeriodCahe();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(10);
        ArrayList<Map<String, String>> olapData = new ArrayList<Map<String, String>>(10);
        for (DynamicObject period : periods) {
            DynamicObject pob = period.getDynamicObject("fbasedataid");
            String pnumber = pob.getString("number");
            Long periodId = pob.getLong("id");
            String periodKey = periodCahe.get(pnumber);
            for (List<OffsetEntryEntity> list : lists) {
                if (!this.checkValueBalacne(list, errorInfo, periodKey, pnumber)) continue;
                saveData.add(this.getDynamicObject(periodId, list, modelCache, periodKey));
                olapData.addAll(this.getOlapDatas(list, pnumber, modelCache, periodKey));
            }
        }
        this.compareMap(olapData);
        OffsetEntryService.getInstance().checkMemberPermission(this.getIModelCacheHelper(), olapData, DimMembPermType.WRITE);
        Map<String, Long> viewMap = this.getViewMap();
        try (TXHandle tx = TX.requiresNew((String)"save");){
            try {
                List<Map<String, String>> subOlapData = this.prepareSubData();
                String numberStr = null;
                if (saveData.size() > 0) {
                    numberStr = saveData.stream().map(e -> e.getString("number")).collect(Collectors.joining(","));
                    this.deleteDuplicateData();
                    SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[0]));
                }
                boolean executeSub = false;
                Map<Long, List<BGCell>> originalData = null;
                try {
                    if (olapData.size() > 0) {
                        OlapTraceServiceHelper.setTraceOpInfo((String)numberStr);
                        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.OffsetExecute));
                        originalData = this.subtractData(subOlapData, viewMap);
                        executeSub = true;
                        this.addData(olapData, viewMap);
                    }
                }
                catch (Exception e2) {
                    if (executeSub && originalData != null) {
                        OffsetEntryService.getInstance().rollBackOlapData(modelCache, originalData, "save");
                    }
                    throw e2;
                }
                if (!this.isEdit() && saveData.size() > 0) {
                    List dupIds = saveData.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                    this.getPageCache().put("duplicateIds", SerializationUtils.toJsonString(dupIds));
                }
            }
            catch (Exception e3) {
                tx.markRollback();
                log.error(e3.getMessage(), (Throwable)e3);
                throw e3;
            }
        }
        if (errorInfo.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OffsetEntryAddnewPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (lists.size() > 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_SAVE, "advcontoolbarap1", "advcontoolbarap"});
            }
        } else {
            this.openErrorTip(errorInfo, ResManager.loadResFormat((String)"\u4fdd\u5b58\u6210\u529f%1\u6761\uff0c\u5176\u4f59\u5931\u8d25\uff0c\u5931\u8d25\u8be6\u60c5\u5982\u4e0b\uff1a", (String)"OffsetEntryAddNewPluginV2_3", (String)"epm-eb-formplugin", (Object[])new Object[]{saveData.size()}));
        }
        if (this.isEdit()) {
            this.writeLog(null, "save", new MultiLangEnumBridge("\u7f16\u8f91", "OffsetEntryAddNewPluginV2_13", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u8f91\u6210\u529f%1$s\u6761\u3002", "OffsetEntryAddNewPluginV2_14", "epm-eb-formplugin"), new String[]{String.valueOf(saveData.size())});
        } else {
            this.writeLog(null, "addnew", new MultiLangEnumBridge("\u65b0\u589e", "OffsetEntryAddNewPluginV2_15", "epm-eb-formplugin"), new MultiLangEnumBridge("\u65b0\u589e\u6210\u529f%1$s\u6761\u3002", "OffsetEntryAddNewPluginV2_16", "epm-eb-formplugin"), new String[]{String.valueOf(saveData.size())});
        }
    }

    private List<Map<String, String>> getOlapDatas(List<OffsetEntryEntity> list, String periodNumber, IModelCacheHelper orCreate, String periodKey) {
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>(10);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("Version", this.getValue(VERSION, "number"));
        map.put("DataType", this.getValue(DATATYPE, "number"));
        map.put("AuditTrail", this.getValue(AUDITTRIAL, "number"));
        map.put("Currency", this.getValue(CURRENCY, "number"));
        map.put("ChangeType", this.getValue(CHANGETYPE, "number"));
        map.put("Entity", this.getOffsetEntryNumber());
        map.put("InternalCompany", "ICNone");
        map.put("BudgetPeriod", periodNumber);
        List<String> supDimNumbers = this.getSelfDimCombValue();
        int rowIndex = list.get(0).getSeq();
        String pre = list.get(0).getEntryName();
        List<String> supDimCache = this.getSupDimCache();
        for (String supDimNumber : supDimNumbers) {
            int i = supDimCache.indexOf(supDimNumber) + 1;
            if (i <= 0) continue;
            map.put(supDimNumber, ((DynamicObject)this.getModel().getValue(pre + DIM + i, rowIndex)).getString("number"));
        }
        Map<String, List<OffsetEntryEntity>> collect = list.stream().collect(Collectors.groupingBy(OffsetEntryEntity::getAccount));
        for (Map.Entry<String, List<OffsetEntryEntity>> entry : collect.entrySet()) {
            BigDecimal money = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            HashMap<String, String> map1 = new HashMap<String, String>(map);
            map1.put("Account", entry.getKey());
            List<OffsetEntryEntity> value = entry.getValue();
            map1.put(K_DATASETID, String.valueOf(value.get(0).getDataSetId()));
            List<Dimension> dims = orCreate.getDimensionList(value.get(0).getDataSetId()).stream().filter(d -> !d.isPreset()).collect(Collectors.toList());
            dims.forEach(d -> map1.computeIfAbsent(d.getNumber(), v -> d.getNoneNumber()));
            for (OffsetEntryEntity offset : value) {
                money = money.add((BigDecimal)this.getModel().getValue(offset.getEntryName() + "m" + periodKey, offset.getSeq()));
                amount = amount.add((BigDecimal)this.getModel().getValue(offset.getEntryName() + "a" + periodKey, offset.getSeq()));
            }
            if (this.isMoney()) {
                map1.put("Metric", "Money");
                map1.put(K_VALUE, money.toString());
                datas.add(map1);
            }
            if (!this.isAmount()) continue;
            HashMap<String, String> map2 = new HashMap<String, String>(map1);
            map2.put("Metric", "Amount");
            map2.put(K_VALUE, amount.toString());
            datas.add(map2);
        }
        return datas;
    }

    private DynamicObject getDynamicObject(Long pId, List<OffsetEntryEntity> list, IModelCacheHelper modelCache, String periodKey) {
        Long defaultViewId;
        DynamicObject offset;
        long user = UserUtils.getUserId();
        Date date = new Date();
        if (!this.isEdit()) {
            offset = BusinessDataServiceHelper.newDynamicObject((String)"eb_offsetentry");
            offset.set("id", (Object)DBServiceHelper.genGlobalLongId());
            offset.set("number", (Object)("I-" + offset.getLong("id")));
            offset.set("creator", (Object)user);
            offset.set("createtime", (Object)date);
            offset.set("status", (Object)2);
        } else {
            offset = BusinessDataServiceHelper.loadSingle((Object)this.getId(), (String)"eb_offsetentry");
            if (offset == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u53ef\u80fd\u5df2\u5220\u9664\u3002", (String)"OffsetEntryAddNewPluginV2_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        Long bizModelId = this.getBaseDataId(BUSMODEL);
        offset.set(MODEL, (Object)this.getModelId());
        offset.set(BUSMODEL, (Object)bizModelId);
        offset.set("period", (Object)pId);
        offset.set(VERSION, (Object)((DynamicObject)this.getModel().getValue(VERSION)).getLong("id"));
        offset.set(DATATYPE, (Object)((DynamicObject)this.getModel().getValue(DATATYPE)).getLong("id"));
        offset.set(CONSOLORG, (Object)((DynamicObject)this.getModel().getValue(CONSOLORG)).getLong("id"));
        offset.set(AUDITTRIAL, (Object)((DynamicObject)this.getModel().getValue(AUDITTRIAL)).getLong("id"));
        offset.set(CURRENCY, (Object)((DynamicObject)this.getModel().getValue(CURRENCY)).getLong("id"));
        offset.set(CHANGETYPE, (Object)((DynamicObject)this.getModel().getValue(CHANGETYPE)).getString("id"));
        offset.set("modifier", (Object)user);
        offset.set("modifytime", (Object)date);
        Dimension dimension = modelCache.getDimension("Metric");
        offset.set(METRIC, (Object)(this.isMoney() ? dimension.getMember(Long.valueOf(0L), "Money").getId() : 0L));
        offset.set(METRICQTY, (Object)(this.isAmount() ? dimension.getMember(Long.valueOf(0L), "Amount").getId() : 0L));
        offset.set(OFFSETCATALOG, this.getModel().getValue(OFFSETCATALOG));
        offset.set("offsetorg", (Object)this.getOffsetEntryId());
        if (this.getModel().getValue(CONSOLORG_VIEW) == null) {
            defaultViewId = this.getDimView(SysDimensionEnum.Entity.getNumber(), CONSOLORG);
            offset.set(CONSOLORG_VIEW, (Object)defaultViewId);
        } else {
            offset.set(CONSOLORG_VIEW, (Object)((DynamicObject)this.getModel().getValue(CONSOLORG_VIEW)).getLong("id"));
        }
        if (this.getModel().getValue(CHANGETYPE_VIEW) == null) {
            defaultViewId = this.getDimView(SysDimensionEnum.ChangeType.getNumber(), CHANGETYPE);
            offset.set(CHANGETYPE_VIEW, (Object)defaultViewId);
        } else {
            offset.set(CHANGETYPE_VIEW, (Object)((DynamicObject)this.getModel().getValue(CHANGETYPE_VIEW)).getString("id"));
        }
        HashSet<String> selectedDim = new HashSet<String>(this.getSelfDimCombValue());
        int rowIndex = list.get(0).getSeq();
        String pre = list.get(0).getEntryName();
        List<String> supDimCache = this.getSupDimCache();
        for (int i = 0; i < supDimCache.size(); ++i) {
            int index = i + 1;
            String selfDimKey = "selfdim" + index;
            String dimNum = supDimCache.get(i);
            if (selectedDim.contains(dimNum)) {
                offset.set(selfDimKey, (Object)((DynamicObject)this.getModel().getValue(pre + DIM + index, rowIndex)).getLong("id"));
            } else {
                Dimension dim = modelCache.getDimension(dimNum);
                Member noneMember = dim.getStructOfMember(dim.getNoneNumber());
                if (noneMember == null) {
                    throw new KDBizException("Miss noneMember, dim:" + dimNum);
                }
                offset.set(selfDimKey, (Object)noneMember.getId());
            }
            offset.set(selfDimKey + "view", (Object)this.getDimView(dimNum, pre + DIM + index));
        }
        DynamicObjectCollection entryentity = offset.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        for (OffsetEntryEntity offsetEntryEntity : list) {
            Member member;
            DynamicObject row = entryentity.addNew();
            String prefix = offsetEntryEntity.getEntryName();
            DynamicObject entryRow = this.getModel().getEntryRowEntity(prefix + ENTITY, offsetEntryEntity.getSeq());
            if (SEND.equals(prefix)) {
                row.set("source", (Object)1);
                member = modelCache.getMember("Entity", offsetEntryEntity.getMyCompanyView(), offsetEntryEntity.getMyCompany());
                if (member == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u53d1\u9001\u65b9\u7f16\u7801\u4e3a%1\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OffsetEntryAddNewPluginV2_19", (String)"epm-eb-formplugin", (Object[])new Object[]{offsetEntryEntity.getMyCompany()}));
                }
                row.set("myorg", (Object)member.getId());
                row.set("myorgview", (Object)offsetEntryEntity.getMyCompanyView());
                member = modelCache.getMember("InternalCompany", offsetEntryEntity.getiCompanyView(), offsetEntryEntity.getiCompany());
                if (member == null || !"ICEntity".equals(member.getParentNumber())) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u53d1\u9001\u65b9\u7f16\u7801\u4e3a%1\u7684\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u4e3a\u5185\u90e8\u5f80\u6765\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OffsetEntryAddNewPluginV2_21", (String)"epm-eb-formplugin", (Object[])new Object[]{offsetEntryEntity.getiCompany()}));
                }
                row.set("interorg", (Object)member.getId());
                row.set("interorgview", (Object)offsetEntryEntity.getiCompanyView());
                row.set("amountd", entryRow.get(prefix + "m" + periodKey));
            } else {
                row.set("source", (Object)2);
                member = modelCache.getMember("Entity", offsetEntryEntity.getMyCompanyView(), offsetEntryEntity.getiCompany());
                if (member == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u63a5\u6536\u65b9\u7f16\u7801\u4e3a%1\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OffsetEntryAddNewPluginV2_20", (String)"epm-eb-formplugin", (Object[])new Object[]{offsetEntryEntity.getiCompany()}));
                }
                row.set("myorg", (Object)member.getId());
                row.set("myorgview", (Object)offsetEntryEntity.getMyCompanyView());
                member = modelCache.getMember("InternalCompany", offsetEntryEntity.getiCompanyView(), offsetEntryEntity.getMyCompany());
                if (member == null || !"ICEntity".equals(member.getParentNumber())) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u63a5\u6536\u65b9\u7f16\u7801\u4e3a%1\u7684\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u4e3a\u5185\u90e8\u5f80\u6765\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OffsetEntryAddNewPluginV2_22", (String)"epm-eb-formplugin", (Object[])new Object[]{offsetEntryEntity.getMyCompany()}));
                }
                row.set("interorg", (Object)member.getId());
                row.set("interorgview", (Object)offsetEntryEntity.getiCompanyView());
                row.set("amountc", entryRow.get(prefix + "m" + periodKey));
            }
            row.set(ACCOUNT, (Object)entryRow.getLong(prefix + ACCOUNT + ".id"));
            row.set("amount", entryRow.get(prefix + "m" + periodKey));
            row.set("amountqty", entryRow.get(prefix + "a" + periodKey));
        }
        return offset;
    }

    private Long getOffsetEntryId() {
        return this.getOffsetEntryMember().getId();
    }

    private Member getOffsetEntryMember() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        long viewId = this.getDimView(SysDimensionEnum.Entity.getNumber(), CONSOLORG);
        Member member = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId), this.getValue(CONSOLORG, "number") + "offsetentry");
        if (member == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u8303\u56f4\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OffsetEntryAddNewPluginV2_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return member;
    }

    private String getOffsetEntryNumber() {
        return this.getOffsetEntryMember().getNumber();
    }

    private void deleteInvalidLine() {
        DynamicObjectCollection send = this.getModel().getEntryEntity("send_entity");
        DynamicObjectCollection recv = this.getModel().getEntryEntity("rec_entity");
        send.removeIf(a -> StringUtils.isEmpty((String)a.getString("send_mycompany")) && StringUtils.isEmpty((String)a.getString("send_icompany")) && StringUtils.isEmpty((String)a.getString("send_account")));
        recv.removeIf(a -> StringUtils.isEmpty((String)a.getString("rec_mycompany")) && StringUtils.isEmpty((String)a.getString("rec_icompany")) && StringUtils.isEmpty((String)a.getString("rec_account")));
        this.getModel().updateEntryCache(send);
        this.getModel().updateEntryCache(recv);
        this.getView().updateView("send_entity");
        this.getView().updateView("rec_entity");
    }

    private boolean checkValueBalacne(List<OffsetEntryEntity> list, List<String> errorInfo, String key, String periodNumber) {
        boolean isMoney = this.isMoney();
        boolean isAmount = this.isAmount();
        IDataModel iDataModel = this.getModel();
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal money_5 = BigDecimal.ZERO;
        BigDecimal money_6 = BigDecimal.ZERO;
        BigDecimal amount_5 = BigDecimal.ZERO;
        BigDecimal amount_6 = BigDecimal.ZERO;
        ArrayList<String> sendRow = new ArrayList<String>(10);
        ArrayList<String> recRow = new ArrayList<String>(10);
        for (OffsetEntryEntity offset : list) {
            String prefix = offset.getEntryName();
            int seq = offset.getSeq();
            boolean isSend = SEND.equals(prefix);
            if (isMoney) {
                String name = isSend ? SEND_NAME : REC_NAME;
                String dit = ((DynamicObject)iDataModel.getValue(prefix + ACCOUNT, seq)).getString("drcrdirect");
                if ("0".equals(dit)) {
                    errorInfo.add(ResManager.loadResFormat((String)"%1 \u7b2c( %2 )\u6240\u9009\u79d1\u76ee\u4e0d\u5b58\u5728\u501f\u8d37\u5c5e\u6027\u3002", (String)"OffsetEntryAddNewPluginV2_1", (String)"epm-eb-formplugin", (Object[])new Object[]{name, seq + 1}));
                    return false;
                }
                BigDecimal value = (BigDecimal)iDataModel.getValue(prefix + "m" + key, seq);
                if (BigDecimal.ZERO.compareTo(value) == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u6216\u63a5\u6536\u65b9\u4e2d\u7684\u91d1\u989d\u6216\u6570\u91cf\u5217\u4e0d\u5141\u8bb8\u4e3a0\u3002", (String)"OffsetEntryAddNewPluginV2_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if ("5".equals(dit)) {
                    money = money.add(value);
                    money_5 = money_5.add(value);
                } else {
                    money = money.subtract(value);
                    money_6 = money_6.add(value);
                }
            }
            if (isAmount) {
                BigDecimal value = (BigDecimal)iDataModel.getValue(prefix + "a" + key, seq);
                if (SEND.equals(prefix)) {
                    amount = amount.add(value);
                    amount_5 = amount_5.add(value);
                } else {
                    amount = amount.subtract(value);
                    amount_6 = amount_6.add(value);
                }
            }
            if (isSend) {
                sendRow.add(seq + 1 + "");
                continue;
            }
            recRow.add(seq + 1 + "");
        }
        if (money.compareTo(BigDecimal.ZERO) != 0 || amount.compareTo(BigDecimal.ZERO) != 0) {
            if (money.compareTo(BigDecimal.ZERO) != 0) {
                errorInfo.add(ResManager.loadResFormat((String)"\u53d1\u9001\u65b9\u6570\u636e( %1 )\u884c\u4e0e\u63a5\u6536\u65b9\u6570\u636e( %2 )\u884c\uff0c\u5728\u671f\u95f4( %3 )\u91d1\u989d\u4e0d\u5e73\u8861\uff0c\u501f\u65b9\u79d1\u76ee( %4 )\uff0c\u8d37\u65b9\u79d1\u76ee( %5 )\u3002", (String)"OffsetEntryAddNewPluginV2_2", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", sendRow), String.join((CharSequence)",", recRow), periodNumber, money_5, money_6}));
            }
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                errorInfo.add(ResManager.loadResFormat((String)"\u53d1\u9001\u65b9\u6570\u636e( %1 )\u884c\u4e0e\u63a5\u6536\u65b9\u6570\u636e( %2 )\u884c\uff0c\u5728\u671f\u95f4( %3 )\u6570\u91cf\u4e0d\u5e73\u8861\uff0c\u53d1\u9001\u65b9( %4 )\uff0c\u63a5\u6536\u65b9( %5 )\u3002", (String)"OffsetEntryAddNewPluginV2_18", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", sendRow), String.join((CharSequence)",", recRow), periodNumber, amount_5, amount_6}));
            }
            return false;
        }
        return true;
    }

    private List<String> checkEntry(List<List<OffsetEntryEntity>> lists) {
        ArrayList<String> errorInfo = new ArrayList<String>(lists.size());
        lists.removeIf(l -> {
            if (l.size() == 1) {
                errorInfo.add(this.getSingleErrorInfo((OffsetEntryEntity)l.get(0)));
                return true;
            }
            return this.checkAccount((List<OffsetEntryEntity>)l, (List<String>)errorInfo);
        });
        return errorInfo;
    }

    private boolean checkAccount(List<OffsetEntryEntity> list, List<String> errorInfo) {
        Map<String, List<OffsetEntryEntity>> collect = list.stream().collect(Collectors.groupingBy(l -> l.getEntryName() + "!" + l.getAccount()));
        boolean res = false;
        for (List<OffsetEntryEntity> value : collect.values()) {
            if (value.size() <= 1) continue;
            String name = SEND.equals(value.get(0).getEntryName()) ? SEND_NAME : REC_NAME;
            String rows = String.join((CharSequence)",", value.stream().map(v -> String.valueOf(v.getSeq() + 1)).collect(Collectors.toList()));
            errorInfo.add(ResManager.loadResFormat((String)"%1 \u7ec4\u5408\u6570\u636e( %2 )\u884c\uff0c\u5b58\u5728\u76f8\u540c\u7684\u79d1\u76ee\u3002", (String)"OffsetEntryAddNewPluginV2_0", (String)"epm-eb-formplugin", (Object[])new Object[]{name, rows}));
            res = true;
        }
        return res;
    }

    private String getSingleErrorInfo(OffsetEntryEntity offset) {
        String name = offset.getEntryName();
        StringBuilder error = new StringBuilder();
        int seq = offset.getSeq() + 1;
        if (SEND.equals(name)) {
            error.append(ResManager.loadResFormat((String)"'\u53d1\u9001\u65b9'\u7684\u7b2c ( %1 ) \u884c\u6570\u636e,\u5728'\u63a5\u6536\u65b9'\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e\u3002", (String)"OffsetEntryAddnewPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{seq}));
        } else {
            error.append(ResManager.loadResFormat((String)"'\u63a5\u6536\u65b9'\u7684\u7b2c ( %1 ) \u884c\u6570\u636e,\u5728'\u53d1\u9001\u65b9'\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e\u3002", (String)"OffsetEntryAddnewPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{seq}));
        }
        return error.toString();
    }

    private void deleteDuplicateData() {
        if (this.isEdit()) {
            return;
        }
        String duplicateIds = this.getPageCache().get("duplicateIds");
        if (duplicateIds != null) {
            List ids = (List)SerializationUtils.fromJsonString((String)duplicateIds, List.class);
            DeleteServiceHelper.delete((String)"eb_offsetentry", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        }
    }

    private List<Long> getDuplicateIds() {
        List<Long> ids = new ArrayList<Long>(10);
        if (this.isEdit()) {
            return ids;
        }
        String duplicateIds = this.getPageCache().get("duplicateIds");
        if (duplicateIds != null) {
            ids = (List)SerializationUtils.fromJsonString((String)duplicateIds, List.class);
        }
        return ids;
    }

    private Map<Long, List<BGCell>> subtractData(List<Map<String, String>> lists, Map<String, Long> viewMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (lists.size() > 0) {
            Map<Long, List<BGCell>> originalData = OffsetEntryService.getInstance().handleOlapData(lists, modelCache, viewMap, false);
            OffsetEntryService.getInstance().saveOlap(lists, modelCache, originalData, "subtractData");
            return originalData;
        }
        return null;
    }

    private void addData(List<Map<String, String>> lists, Map<String, Long> viewMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (lists.size() > 0) {
            Map<Long, List<BGCell>> originalData = OffsetEntryService.getInstance().handleOlapData(lists, modelCache, viewMap, true);
            OffsetEntryService.getInstance().saveOlap(lists, modelCache, originalData, "addData");
        }
    }

    private void openErrorTip(List<String> errorInfo, String title) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_errorinfo");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5", (String)"OffsetEntryAddnewPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("title", (Object)title);
        formShowParameter.setCustomParam("errorInfo", errorInfo);
        this.getView().showForm(formShowParameter);
    }

    private List<Map<String, String>> prepareSubData() {
        ArrayList<Map<String, String>> lists = new ArrayList<Map<String, String>>(10);
        List<Long> ids = null;
        ids = !this.isEdit() ? this.getDuplicateIds() : Collections.singletonList(this.getId());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        OffsetEntryService service = OffsetEntryService.getInstance();
        ids.forEach(d -> lists.addAll(service.convertOlapData((Long)d, modelCache, (Map<String, Long>)new HashMap<String, Long>(16))));
        return lists;
    }

    private List<List<OffsetEntryEntity>> groupByTag() {
        List<OffsetEntryEntity> lists = this.convertObjectList(this.getModel().getEntryEntity("send_entity"), true);
        lists.addAll(this.convertObjectList(this.getModel().getEntryEntity("rec_entity"), false));
        Set viewTags = lists.stream().map(OffsetEntryEntity::getViewTag).collect(Collectors.toSet());
        if (viewTags.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u548c\u63a5\u6536\u65b9\u76f8\u540c\u7ef4\u5ea6\u7684\u89c6\u56fe\u9700\u8981\u4fdd\u6301\u4e00\u81f4\u3002", (String)"OffsetEntryAddNewPluginV2_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map<String, List<OffsetEntryEntity>> groupBy = lists.stream().collect(Collectors.groupingBy(OffsetEntryEntity::getGropyTag));
        return new ArrayList<List<OffsetEntryEntity>>(groupBy.values());
    }

    private List<OffsetEntryEntity> convertObjectList(DynamicObjectCollection collection, boolean isSend) {
        String prifex = isSend ? SEND : REC;
        return collection.stream().map(c -> {
            OffsetEntryEntity offset = new OffsetEntryEntity();
            if (isSend) {
                offset.setMyCompany(c.getString(prifex + "mycompany.number"));
                offset.setMyCompanyView(this.getDimView(SysDimensionEnum.Entity.getNumber(), prifex + MYCOMPANY));
                offset.setiCompany(c.getString(prifex + "icompany.number"));
                offset.setiCompanyView(this.getDimView(SysDimensionEnum.InternalCompany.getNumber(), prifex + ICOMPANY));
            } else {
                offset.setMyCompany(c.getString(prifex + "icompany.number"));
                offset.setMyCompanyView(this.getDimView(SysDimensionEnum.Entity.getNumber(), prifex + ICOMPANY));
                offset.setiCompany(c.getString(prifex + "mycompany.number"));
                offset.setiCompanyView(this.getDimView(SysDimensionEnum.InternalCompany.getNumber(), prifex + MYCOMPANY));
            }
            offset.setSelfdim1(c.get(prifex + "dim1") == null ? "" : c.getString(prifex + "dim1.number"));
            offset.setSelfdim2(c.get(prifex + "dim2") == null ? "" : c.getString(prifex + "dim2.number"));
            offset.setSelfdim3(c.get(prifex + "dim3") == null ? "" : c.getString(prifex + "dim3.number"));
            offset.setSelfdim4(c.get(prifex + "dim4") == null ? "" : c.getString(prifex + "dim4.number"));
            offset.setSelfdim5(c.get(prifex + "dim5") == null ? "" : c.getString(prifex + "dim5.number"));
            offset.setSelfdim6(c.get(prifex + "dim6") == null ? "" : c.getString(prifex + "dim6.number"));
            offset.setSelfdim1view(this.getDimView(this.getCurrentDimNumber(prifex + "dim1"), prifex + "dim1"));
            offset.setSelfdim2view(this.getDimView(this.getCurrentDimNumber(prifex + "dim2"), prifex + "dim2"));
            offset.setSelfdim3view(this.getDimView(this.getCurrentDimNumber(prifex + "dim3"), prifex + "dim3"));
            offset.setSelfdim4view(this.getDimView(this.getCurrentDimNumber(prifex + "dim4"), prifex + "dim4"));
            offset.setSelfdim5view(this.getDimView(this.getCurrentDimNumber(prifex + "dim5"), prifex + "dim5"));
            offset.setSelfdim6view(this.getDimView(this.getCurrentDimNumber(prifex + "dim6"), prifex + "dim6"));
            offset.setSeq(c.getInt("seq") - 1);
            offset.setEntryName(prifex);
            offset.setAccount(c.getString(prifex + "account.number"));
            offset.setDataSetId(c.getLong(prifex + "account.dataset.id"));
            return offset;
        }).collect(Collectors.toList());
    }

    private void compareMap(List<Map<String, String>> olapData) {
        int size = olapData.size();
        for (int i = 0; i < size; ++i) {
            Map<String, String> first = olapData.get(i);
            if ("1".equals(first.get("toRemove"))) continue;
            for (int j = i + 1; j < size; ++j) {
                Map<String, String> second = olapData.get(j);
                if (first.size() != second.size() || !this.isEqualDimGroup(first, second)) continue;
                first.put(K_VALUE, new BigDecimal(first.get(K_VALUE)).add(new BigDecimal(second.get(K_VALUE))).toString());
                second.put("toRemove", "1");
            }
        }
        olapData.removeIf(e -> "1".equals(e.get("toRemove")));
    }

    private boolean isEqualDimGroup(Map<String, String> first, Map<String, String> second) {
        for (Map.Entry<String, String> entry : first.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (K_VALUE.equals(key) || value.equals(second.get(key))) continue;
            return false;
        }
        return true;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick((BeforeItemClickEvent)evt, (Long)this.getModelId(), (IFormView)this.getView(), (Set)Sets.newHashSet((Object[])new String[]{"btn_close"}));
    }

    static {
        int i;
        log = LogFactory.getLog(OffsetEntryAddNewPluginV2.class);
        MONEY = PreMetricEnum.Money.getNumber();
        AMOUNT = PreMetricEnum.Amount.getNumber();
        SEND_NAME = ResManager.loadKDString((String)"\u53d1\u9001\u65b9", (String)"OffsetEntryAddNewPluginV2_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        REC_NAME = ResManager.loadKDString((String)"\u63a5\u6536\u65b9", (String)"OffsetEntryAddNewPluginV2_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        PERIOD_PRESET_KEY = new ArrayList<String>(24);
        for (i = 1; i < 25; ++i) {
            if (i < 10) {
                PERIOD_PRESET_KEY.add("p0" + i);
                continue;
            }
            PERIOD_PRESET_KEY.add("p" + i);
        }
        baseDataKeys = new LinkedHashSet<String>();
        entryBaseDataKeys = new LinkedHashSet<String>();
        baseDataKeys.addAll(Arrays.asList(BUSMODEL, AUDITTRIAL, CONSOLORG, PERIOD, DATATYPE, VERSION, CURRENCY, CHANGETYPE));
        entryBaseDataKeys.addAll(Arrays.asList("send_mycompany", "send_icompany", "send_account", "rec_mycompany", "rec_icompany", "rec_account"));
        for (i = 1; i < 7; ++i) {
            entryBaseDataKeys.add("send_dim" + i);
            entryBaseDataKeys.add("rec_dim" + i);
        }
    }
}

