/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMetricType;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationPlan;
import kd.epm.eb.business.dataintegration.service.DataIntegrationService;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataintegration.plugin.DataIntegrationBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationPlugin
extends DataIntegrationBasePlugin {
    private static final String DIMSOURCE_KEY = "dimsource";
    private static final String METRICSOURCENAME_KEY = "metricsourcename";
    private static final String SRCSINGLEMETRIC_KEY = "srcsinglemetric";
    private static final String SRCMETRICTYPE_KEY = "srcmetrictype";
    private static final String DIMMEMBER_KEY = "dimmember";
    private static final String DIMMEMBMAP_KEY = "dimmembmap";
    private static final String TARGETSYS_KEY = "targetsys";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"metrictargetname"});
        this.addF7SelectListener((BeforeF7SelectListener)this, new String[]{"sourceobj", TARGETSYS_KEY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject datasetObj = (DynamicObject)this.getModel().getValue("datasetid");
        this.updataDimMapEntity4DataSet(datasetObj);
        this.updateIntegrationRangeEntry(false);
    }

    public void afterLoadData(EventObject e) {
        DynamicObject newSourceObj = (DynamicObject)this.getModel().getValue("sourceobj");
        this.updateMapEntity4SourceObj(newSourceObj, false);
        DynamicObject datasetObj = (DynamicObject)this.getModel().getValue("datasetid");
        this.checkDimChange(datasetObj);
        this.updateIntegrationRangeEntry(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "sourceobj": {
                this.afterSourceObjChange((DynamicObject)e.getChangeSet()[0].getNewValue());
                break;
            }
            case "datasetid": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.updataDimMapEntity4DataSet(newValue);
                this.updateIntegrationRangeEntry(true);
                break;
            }
            case "dimsource": {
                Object newValueDimsrc = e.getChangeSet()[0].getNewValue();
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                if (newValueDimsrc == null || !StringUtils.isNotBlank((CharSequence)newValueDimsrc.toString())) break;
                this.getModel().setValue(DIMMEMBER_KEY, null, rowIndex);
                this.getModel().setValue("dimmembnum", null, rowIndex);
                this.getModel().setValue(DIMMEMBMAP_KEY, null, rowIndex);
                break;
            }
            case "metricsourcename": {
                this.getModel().setValue("metricsource", e.getChangeSet()[0].getNewValue(), e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "dimmember": {
                Object newValueDimmember = e.getChangeSet()[0].getNewValue();
                int rowIndexDimmember = e.getChangeSet()[0].getRowIndex();
                if (newValueDimmember != null && StringUtils.isNotBlank((CharSequence)newValueDimmember.toString())) {
                    this.getModel().setValue(DIMSOURCE_KEY, null, rowIndexDimmember);
                    this.getModel().setValue(DIMMEMBMAP_KEY, null, rowIndexDimmember);
                    this.getModel().setValue("dimmemberview", null, rowIndexDimmember);
                } else {
                    this.getModel().setValue("dimmembnum", null, rowIndexDimmember);
                    this.getModel().setValue("dimmemberview", null, rowIndexDimmember);
                }
                this.updateIntegrationRangeEntry(false);
                break;
            }
            case "dimmembmap": {
                Object newValueMap = e.getChangeSet()[0].getNewValue();
                int rowIndexMap = e.getChangeSet()[0].getRowIndex();
                if (newValueMap != null && StringUtils.isNotBlank((CharSequence)newValueMap.toString())) {
                    this.getModel().setValue(DIMMEMBER_KEY, null, rowIndexMap);
                }
                this.updateIntegrationRangeEntry(false);
                DynamicObject dynamicObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
                String dimNum = null;
                Long viewId = 0L;
                if (dynamicObject != null) {
                    Map map;
                    dimNum = e.getChangeSet()[0].getDataEntity().getString("dimtarget");
                    String targetsysinfo = dynamicObject.getString("targetsysinfo");
                    if (StringUtils.isNotEmpty((CharSequence)targetsysinfo) && (map = (Map)JSON.parseObject((String)targetsysinfo, Map.class)).containsKey("view")) {
                        viewId = IDUtils.toLong(map.get("view"));
                    }
                }
                this.clearIntegrationRangeEntryWhenViewChange(dimNum, viewId);
                break;
            }
            case "srcmetrictype": {
                String newValMetricType = (String)e.getChangeSet()[0].getNewValue();
                this.setMetriTypeVisible(newValMetricType);
                this.updataDimMapEntity4MetricType(newValMetricType);
                this.updateIntegrationRangeEntry(false);
                break;
            }
        }
    }

    private void updataDimMapEntity4MetricType(String metricType) {
        DynamicObjectCollection dimMapInfo = this.getModel().getEntryEntity("dimmapentity");
        if (DataIntegrationMetricType.MUTIPLE.getCode().equals(metricType)) {
            for (int i = 0; i < dimMapInfo.size(); ++i) {
                if (!SysDimensionEnum.Metric.getNumber().equals(((DynamicObject)dimMapInfo.get(i)).getString("dimtarget"))) continue;
                this.getModel().deleteEntryRow("dimmapentity", i);
                break;
            }
        } else {
            DynamicObject datasetObj = (DynamicObject)this.getModel().getValue("datasetid");
            DynamicObjectCollection allDims = datasetObj.getDynamicObjectCollection("entryentity");
            DynamicObject metricDim = null;
            for (DynamicObject dim : allDims) {
                if (!SysDimensionEnum.Metric.getNumber().equals(dim.getString("datasetdim.number"))) continue;
                metricDim = dim;
                break;
            }
            if (metricDim != null) {
                int newRowIndex = this.getModel().createNewEntryRow("dimmapentity");
                this.getModel().setValue("dimtarget", (Object)metricDim.getString("datasetdim.number"), newRowIndex);
                this.getModel().setValue("dimtargetname", (Object)metricDim.getString("datasetdim.name"), newRowIndex);
                this.getModel().setValue("dimtargetid", (Object)metricDim.getLong("datasetdim.id"), newRowIndex);
            }
        }
    }

    private void setMetriTypeVisible(String metricType) {
        if (DataIntegrationMetricType.SINGLE.getCode().equals(metricType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexmetricmap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{SRCSINGLEMETRIC_KEY});
            this.getModel().deleteEntryData("metricmapentity");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexmetricmap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{SRCSINGLEMETRIC_KEY});
            this.getModel().setValue(SRCSINGLEMETRIC_KEY, null);
        }
    }

    private void afterSourceObjChange(DynamicObject newSourceObj) {
        DynamicObject sourceSysObj;
        Long sourceSysId = null;
        if (newSourceObj != null && (sourceSysObj = newSourceObj.getDynamicObject("group")) != null) {
            sourceSysId = sourceSysObj.getLong("id");
        }
        this.getModel().setValue("sourcesys", sourceSysId);
        this.updateMapEntity4SourceObj(newSourceObj, true);
    }

    private void updateMapEntity4SourceObj(DynamicObject newSourceObj, boolean needClear) {
        IDataModel dataModel = this.getModel();
        if (needClear) {
            int dimMampEntityRowCount = dataModel.getEntryRowCount("dimmapentity");
            for (int index = 0; index < dimMampEntityRowCount; ++index) {
                dataModel.setValue(DIMSOURCE_KEY, null, index);
                dataModel.setValue(DIMMEMBMAP_KEY, null, index);
            }
            int metricMampEntityRowCount = dataModel.getEntryRowCount("metricmapentity");
            for (int index = 0; index < metricMampEntityRowCount; ++index) {
                dataModel.setValue(METRICSOURCENAME_KEY, null, index);
            }
        }
        List itemList = EASDataIntegrationUtil.buildCombListOfSourceObj((DynamicObject)newSourceObj, (Long)((Long)this.getModel().getValue("easdb_id")));
        ComboEdit comboEdit1 = (ComboEdit)this.getControl(DIMSOURCE_KEY);
        ComboEdit comboEdit2 = (ComboEdit)this.getControl(METRICSOURCENAME_KEY);
        ComboEdit singleMetricCombo = (ComboEdit)this.getControl(SRCSINGLEMETRIC_KEY);
        comboEdit1.setComboItems(itemList);
        comboEdit2.setComboItems(itemList);
        singleMetricCombo.setComboItems(itemList);
    }

    protected void beforeDoSave() {
        super.beforeDoSave();
        this.baseValidate();
        Long sourceObjId = (Long)this.getPropValueOfF7Obj("sourceobj", "id");
        Long targetSysId = (Long)this.getPropValueOfF7Obj(TARGETSYS_KEY, "id");
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            id = DBServiceHelper.genGlobalLongId();
        }
        DataIntegrationPlan plan = DataIntegrationService.getInstance().createPlan(id.longValue(), this.getModelId().longValue(), this.getDatasetId(), sourceObjId, targetSysId);
        this.getModel().setValue("id", (Object)id);
        this.getModel().setValue("targetobj", (Object)plan.getTargetObjId());
        this.getModel().setValue("triggerid", (Object)plan.getTriggerId());
        this.getModel().setValue("tablename", (Object)plan.getTableName());
    }

    private void baseValidate() {
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection dimMapInfo = dataEntity.getDynamicObjectCollection("dimmapentity");
        for (DynamicObject row : dimMapInfo) {
            String[] dimsourceArr;
            String dimsource = row.getString(DIMSOURCE_KEY);
            String dimmember = row.getString(DIMMEMBER_KEY);
            String dimNum = row.getString("dimtarget");
            Long dimMappingId = row.getLong("dimmembmap_id");
            if (StringUtils.isBlank((CharSequence)dimsource) && StringUtils.isBlank((CharSequence)dimmember)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\u6709\u884c\u672a\u9009\u62e9\u201c\u6e90\u5b57\u6bb5\u201d\u4e14\u672a\u9009\u62e9\u6307\u5b9a\u7684\u201c\u7ef4\u5ea6\u6210\u5458\u201d\u3002", (String)"DataIntegrationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)dimsource) && (dimsourceArr = StringUtils.split((String)dimsource)).length > 5) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5b57\u6bb5\u540d\u79f0\u591a\u9009\u4e0d\u5141\u8bb8\u8d85\u8fc75\u4e2a\u503c\u3002", (String)"DataIntegrationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (View.NoViewDimNums.contains(dimNum) || !IDUtils.isNotEmptyLong((Long)dimMappingId).booleanValue()) continue;
            this.dimToDimMappingIdMap.computeIfAbsent(dimNum, e -> new HashSet(16)).add(dimMappingId);
        }
        String metricType = dataEntity.getString(SRCMETRICTYPE_KEY);
        if (DataIntegrationMetricType.MUTIPLE.getCode().equals(metricType)) {
            DynamicObjectCollection metricMapInfo = dataEntity.getDynamicObjectCollection("metricmapentity");
            if (metricMapInfo.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u6620\u5c04\u5206\u5f55\u672a\u8bbe\u7f6e\u3002", (String)"DataIntegrationPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject row : metricMapInfo) {
                if (!StringUtils.isBlank((CharSequence)row.getString("metricsource")) && !StringUtils.isBlank((CharSequence)row.getString("metrictarget"))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u6620\u5c04\u5206\u5f55\u6709\u884c\u672a\u8bbe\u7f6e\u5fc5\u5f55\u9879\u3002", (String)"DataIntegrationPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        this.checkInterRangeInfo();
        this.checkDimView();
    }

    public void afterBindData(EventObject ent) {
        super.afterBindData(ent);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap2"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"sourceobj", "sourcesys", SRCMETRICTYPE_KEY, SRCSINGLEMETRIC_KEY});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TARGETSYS_KEY});
        this.getView().setVisible(Boolean.valueOf(status == OperationStatus.EDIT), new String[]{"targetobj"});
        String metricType = this.getModel().getDataEntity().getString(SRCMETRICTYPE_KEY);
        this.setMetriTypeVisible(metricType);
        try {
            this.initIfEAS();
        }
        catch (Exception e) {
            log.error("error occur,", (Throwable)e);
        }
    }

    private void initIfEAS() {
        Long easdbId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long srcDsId = (Long)formShowParameter.getCustomParam("srcDsId");
        if (IDUtils.isNotNull((Long)srcDsId)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)srcDsId, (String)"isc_metadata_schema");
            if (dynamicObject == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u96c6\u6210\u5bf9\u8c61\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String easModelNumber = (String)formShowParameter.getCustomParam("easModelNumber");
            String easModelName = (String)formShowParameter.getCustomParam("easModelName");
            Long easdbId2 = (Long)formShowParameter.getCustomParam("easdbId");
            this.getModel().setValue("number", (Object)("EAS_" + easModelNumber + "_"));
            this.getModel().setValue("name", (Object)("EAS_" + easModelName + "_"));
            this.getModel().setValue("easdb", (Object)easdbId2);
            this.getModel().setValue("easdatacenter", (Object)EASUpgradeUtils.getDataCenter((Long)easdbId2));
            this.getModel().setValue("easmodel", formShowParameter.getCustomParam("easModelID"));
            this.getModel().setValue("sourceobj", (Object)srcDsId);
            this.getModel().setValue(SRCSINGLEMETRIC_KEY, (Object)"fvalue");
            IDataModel dataModel = this.getModel();
            IFormView view = this.getView();
            int dimMampEntityRowCount = dataModel.getEntryRowCount("dimmapentity");
            Long modelId = this.getModelId();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Long defaultMapCat = EASDataIntegrationUtil.getDefaultMapCat((Long)modelId);
            for (int index = 0; index < dimMampEntityRowCount; ++index) {
                this.setDefaultByEAS(dataModel, view, modelCache, index, defaultMapCat);
            }
            this.getView().updateView("dimmapentity");
        }
        if (IDUtils.isNotNull((Long)(easdbId = (Long)this.getModel().getValue("easdb_id")))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sourceobj"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SRCMETRICTYPE_KEY});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SRCSINGLEMETRIC_KEY});
            IDataModel dataModel = this.getModel();
            IFormView view = this.getView();
            int dimMampEntityRowCount = dataModel.getEntryRowCount("dimmapentity");
            for (int index = 0; index < dimMampEntityRowCount; ++index) {
                String dimtarget = (String)dataModel.getValue("dimtarget", index);
                if (!EasUpgradeConstants.EB_EAS_DIM_MAP.containsKey(dimtarget)) continue;
                view.setEnable(Boolean.valueOf(false), index, new String[]{DIMSOURCE_KEY});
            }
        }
    }

    private void checkDimChange(DynamicObject datasetObj) {
        IModelCacheHelper cacheHelper = this.getIModelCacheHelper();
        DynamicObjectCollection dimensions = datasetObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection dimMaperList = this.getModel().getEntryEntity("dimmapentity");
        Map<String, DynamicObject> dimMaperMap = dimMaperList.stream().collect(Collectors.toMap(e -> e.getString("dimtarget"), e -> e));
        for (DynamicObject dim : dimensions) {
            String dimNumber = dim.getString("datasetdim.number");
            Dimension dimension = cacheHelper.getDimension(dimNumber);
            if (dimension == null || SysDimensionEnum.Metric.getNumber().equals(dimNumber) || dimMaperMap.containsKey(dimNumber)) continue;
            int newRowIndex = this.getModel().createNewEntryRow("dimmapentity");
            this.getModel().setValue("dimtarget", (Object)dim.getString("datasetdim.number"), newRowIndex);
            this.getModel().setValue("dimtargetname", (Object)dim.getString("datasetdim.name"), newRowIndex);
            this.getModel().setValue("dimtargetid", (Object)dim.getLong("datasetdim.id"), newRowIndex);
            Member member = dimension.getMember(Long.valueOf(0L), dimension.getNoneNumber());
            if (member == null) continue;
            this.getModel().setValue(DIMMEMBER_KEY, (Object)member.getName(), newRowIndex);
            this.getModel().setValue("dimmembnum", (Object)member.getNumber(), newRowIndex);
        }
    }

    private void updataDimMapEntity4DataSet(DynamicObject newDataSetObj) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("dimmapentity");
        if (newDataSetObj == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        long datasetIdLong = newDataSetObj.getLong("id");
        if (datasetIdLong == 0L) {
            return;
        }
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(datasetIdLong));
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)dimensionList)) {
            return;
        }
        Dimension accountDimension = null;
        Dimension metricDimension = null;
        TreeMap<String, Dimension> otherDimensionMap = new TreeMap<String, Dimension>();
        for (Dimension dimension : dimensionList) {
            String dimensionNumberString = dimension.getNumber();
            if (SysDimensionEnum.Account.getNumber().equals(dimensionNumberString)) {
                accountDimension = dimension;
                continue;
            }
            if (SysDimensionEnum.Metric.getNumber().equals(dimensionNumberString)) {
                metricDimension = dimension;
                continue;
            }
            otherDimensionMap.put(dimensionNumberString, dimension);
        }
        if (accountDimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u79d1\u76ee\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"DataIntegrationPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Object> sortDimensionList = new ArrayList<Object>(dimensionList.size());
        sortDimensionList.add(accountDimension);
        sortDimensionList.addAll(otherDimensionMap.values());
        String metricType = dataModel.getDataEntity().getString(SRCMETRICTYPE_KEY);
        if (DataIntegrationMetricType.SINGLE.getCode().equals(metricType) && metricDimension != null) {
            sortDimensionList.add(metricDimension);
        }
        dataModel.batchCreateNewEntryRow("dimmapentity", sortDimensionList.size());
        Long easdbId = (Long)this.getModel().getValue("easdb_id");
        IFormView view = this.getView();
        Long defaultMapCat = EASDataIntegrationUtil.getDefaultMapCat((Long)this.getModelId());
        for (int i = 0; i < sortDimensionList.size(); ++i) {
            Dimension dimension = (Dimension)sortDimensionList.get(i);
            String dimensionNumber = dimension.getNumber();
            dataModel.setValue("dimtarget", (Object)dimensionNumber, i);
            dataModel.setValue("dimtargetname", (Object)dimension.getName(), i);
            dataModel.setValue("dimtargetid", (Object)dimension.getId(), i);
            if (!IDUtils.isNotNull((Long)easdbId)) continue;
            this.setDefaultByEAS(dataModel, view, modelCacheHelper, i, defaultMapCat);
        }
        this.getView().updateView("dimmapentity");
    }

    private void setDefaultByEAS(IDataModel dataModel, IFormView view, IModelCacheHelper modelCacheHelper, int index, Long defaultMapCat) {
        Member entityInput;
        String dimtarget = (String)dataModel.getValue("dimtarget", index);
        if (EasUpgradeConstants.EB_EAS_DIM_MAP.containsKey(dimtarget)) {
            dataModel.setValue(DIMSOURCE_KEY, EasUpgradeConstants.EB_EAS_DIM_MAP.get(dimtarget), index);
            view.setEnable(Boolean.valueOf(false), index, new String[]{DIMSOURCE_KEY});
            if (SysDimensionEnum.Metric.getNumber().equals(dimtarget) || SysDimensionEnum.Currency.getNumber().equals(dimtarget) || SysDimensionEnum.DataType.getNumber().equals(dimtarget) || SysDimensionEnum.Version.getNumber().equals(dimtarget)) {
                Long defaultMemberMap = EASDataIntegrationUtil.getDefaultMemberMapIfEAS((IModelCacheHelper)modelCacheHelper, (String)dimtarget, (Long)defaultMapCat);
                dataModel.setValue(DIMMEMBMAP_KEY, (Object)defaultMemberMap, index);
            }
        } else if (SysDimensionEnum.ChangeType.getNumber().equals(dimtarget)) {
            Member currentPeriod = modelCacheHelper.getMember(dimtarget, null, "CurrentPeriod");
            this.getModel().setValue(DIMMEMBER_KEY, (Object)currentPeriod.getName(), index);
            this.getModel().setValue("dimmembnum", (Object)currentPeriod.getNumber(), index);
        } else if (SysDimensionEnum.AuditTrail.getNumber().equals(dimtarget) && (entityInput = modelCacheHelper.getMember(dimtarget, null, "EntityInput")).isLeaf()) {
            this.getModel().setValue(DIMMEMBER_KEY, (Object)entityInput.getName(), index);
            this.getModel().setValue("dimmembnum", (Object)entityInput.getNumber(), index);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String propKey = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        switch (propKey) {
            case "sourceobj": {
                filterParameter.getQFilters().add(new QFilter("type", "=", (Object)"TABLE"));
                break;
            }
            case "targetsys": {
                filterParameter.getQFilters().add(new QFilter("dblink.database_type", "=", (Object)"self"));
                break;
            }
        }
    }

    protected QFilter getDimMappingFilter() {
        Long modelId = this.getModelId();
        long datasetId = this.getDatasetId();
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        String dimNumber = (String)this.getModel().getValue("dimtarget");
        List viewId = iModelCacheHelper.getViewGroupViewsByDataSetAndDimNumber(Long.valueOf(datasetId), dimNumber);
        Long dimensionId = iModelCacheHelper.getDimension(dimNumber).getId();
        Long sourceObjectId = this.getSourceObjectId();
        String dimSource = (String)this.getModel().getValue(DIMSOURCE_KEY);
        HashSet<String> fields = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)dimSource)) {
            String[] split;
            for (String s : split = dimSource.split(",")) {
                if (StringUtils.isEmpty((CharSequence)s) || ",".equals(s)) continue;
                fields.add(s);
            }
        }
        if (fields.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5b57\u6bb5\u540d\u79f0\u3002", (String)"DataIntegrationPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return EASDataIntegrationUtil.getEasDimMemberMapFilter((DataIntegrationType)DataIntegrationType.INPUT, (Long)sourceObjectId, (Long)modelId, (Long)datasetId, (Long)dimensionId, (List)viewId, (String[])fields.toArray(new String[0]));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ("metrictargetname".equals(sourceKey)) {
            String memberNum = (String)this.getModel().getValue("metrictarget");
            this.showDimMembSelectForm(SysDimensionEnum.Metric.getNumber(), memberNum);
        }
    }

    private void showDimMembSelectForm(String dimNum, String memberNum) {
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        Long busModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId);
        List dimensions = DatasetServiceHelper.getInstance().listDimensionByDatasetId(datasetId);
        Map<String, kd.epm.eb.common.model.Dimension> dimensionMap = dimensions.stream().collect(Collectors.toMap(kd.epm.eb.common.model.Dimension::getNumber, e -> e));
        kd.epm.eb.common.model.Dimension dimension = dimensionMap.get(dimNum);
        Long viewId = 0L;
        if (dimension != null) {
            viewId = dimension.getViewId();
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Member member = modelCacheHelper.getMember(dimNum, viewId, memberNum);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNum), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(busModelId);
        f7Param.setViewId(viewId);
        f7Param.setDatasetId(datasetId);
        if (member != null) {
            f7Param.setSelectId(member.getId());
        }
        f7Param.setOnlySelLeaf(true);
        f7Param.setCutTree(false);
        EASDataIntegrationUtil.setF7PermParam((MemberF7Parameter)f7Param, (Long)modelCacheHelper.getModelobj().getId(), (boolean)this.isInput());
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "dimMemberSelect!" + dimNum));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String backKey = closedCallBackEvent.getActionId();
        if (backKey.startsWith("dimMemberSelect")) {
            this.dimMemberSelectCloseBack(closedCallBackEvent, backKey);
        }
    }

    protected void pointDimMemberSelectCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            this.getModel().beginInit();
            ListSelectedRow selectedRow = ((ListSelectedRowCollection)returnData).get(0);
            String number = selectedRow.getNumber();
            String name = selectedRow.getName();
            this.getModel().setValue(this.getPointTarMemShowFieldKey(), (Object)name);
            this.getModel().setValue(this.getPointTarMemFieldKey(), (Object)number);
            this.getModel().setValue(this.getDimMappingFieldKey(), null);
            this.getModel().setValue(DIMSOURCE_KEY, null);
            if (selectedRow.getDataMap() != null) {
                this.getModel().setValue("dimmemberview", (Object)selectedRow.getDataMap().getOrDefault("viewid", 0L));
            }
            this.getModel().endInit();
            this.getView().updateView(this.getDimMappingEntryKey());
            this.updateIntegrationRangeEntry(false);
        }
    }

    protected void dimMemberSelectCloseBack(ClosedCallBackEvent closedCallBackEvent, String backKey) {
        ListSelectedRowCollection backData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (backData == null) {
            return;
        }
        String dimNum = backKey.split("!")[1];
        IDataModel dataModel = this.getModel();
        String metricType = this.getModel().getDataEntity().getString(SRCMETRICTYPE_KEY);
        if (DataIntegrationMetricType.MUTIPLE.getCode().equals(metricType) && dimNum.equals(SysDimensionEnum.Metric.getNumber())) {
            int rowIndex = dataModel.getEntryCurrentRowIndex("metricmapentity");
            if (backData.isEmpty()) {
                dataModel.setValue("metrictargetname", null, rowIndex);
                dataModel.setValue("metrictarget", null, rowIndex);
            } else {
                dataModel.setValue("metrictargetname", (Object)backData.get(0).getName(), rowIndex);
                dataModel.setValue("metrictarget", (Object)backData.get(0).getNumber(), rowIndex);
            }
        } else {
            int rowIndex = dataModel.getEntryCurrentRowIndex("dimmapentity");
            if (backData.isEmpty()) {
                dataModel.setValue(DIMMEMBER_KEY, null, rowIndex);
                dataModel.setValue("dimmembnum", null, rowIndex);
            } else {
                dataModel.setValue(DIMMEMBER_KEY, (Object)backData.get(0).getName(), rowIndex);
                dataModel.setValue("dimmembnum", (Object)backData.get(0).getNumber(), rowIndex);
            }
        }
    }

    protected Set<String> getDimMapNoSetMembersDimNums() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimmapentity");
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            HashSet<String> numbers = new HashSet<String>(16);
            for (DynamicObject object : entryEntity) {
                String dimTarget = object.getString("dimtarget");
                String dimMember = (String)object.get(DIMMEMBER_KEY);
                if (!StringUtils.isNotEmpty((CharSequence)dimTarget) || !StringUtils.isEmpty((CharSequence)dimMember)) continue;
                numbers.add(dimTarget);
            }
            return numbers;
        }
        return new HashSet<String>(0);
    }

    private Long getSourceObjectId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("sourceobj");
        if (value != null) {
            return value.getLong("id");
        }
        return 0L;
    }

    String getTarDimNumberFieldKey() {
        return "dimtarget";
    }

    String getDimMappingFieldKey() {
        return DIMMEMBMAP_KEY;
    }

    String getPointTarMemFieldKey() {
        return "dimmembnum";
    }

    String getPointTarMemShowFieldKey() {
        return DIMMEMBER_KEY;
    }

    String getDimMappingEntryKey() {
        return "dimmapentity";
    }

    Long getDimMappingEntryView(String dimnumber) {
        Map map;
        String info;
        DynamicObject dynamicObject;
        DynamicObject bcmdimmemmap;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimmapentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return 0L;
        }
        Optional<DynamicObject> bcmdimtarnumber = entryEntity.stream().filter(x -> dimnumber.equals(x.getString("dimtarget"))).findFirst();
        if (bcmdimtarnumber.isPresent() && (bcmdimmemmap = (dynamicObject = bcmdimtarnumber.get()).getDynamicObject(DIMMEMBMAP_KEY)) != null && StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("targetsysinfo"))) && (map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view")) {
            return IDUtils.toLong(map.get("view"));
        }
        return 0L;
    }

    Long getpointTarEntryView(String dimnumber) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimmapentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return 0L;
        }
        Optional<DynamicObject> bcmdimtarnumber = entryEntity.stream().filter(x -> dimnumber.equals(x.getString("dimtarget"))).findFirst();
        if (bcmdimtarnumber.isPresent()) {
            DynamicObject dynamicObject = bcmdimtarnumber.get();
            return dynamicObject.getLong("dimmemberview.id");
        }
        return 0L;
    }
}

