/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.dimensionrelation;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelation;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelationEntry;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.dimension.dimensionrelation.PropertyInfo;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimMemRelDao;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimRelDao;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimRelUpdateDao;
import kd.epm.eb.common.enums.PropRangeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimRelationScope;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.excel.CellDropdown;
import kd.epm.eb.common.utils.excel.ExcelImExportUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dimension.dimensionrelation.RelationEntryGridControl;
import kd.epm.eb.formplugin.utils.PluginUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionRelationListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
SearchEnterListener,
ListRowClickListener,
HyperLinkClickListener {
    private static final String BTN_ADDDIMRELAT = "btn_adddimrelat";
    private static final String BTN_EDITDIMRELAT = "btn_editdimrelat";
    private static final String BTN_DELDIMRELAT = "btn_deldimrelat";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_ADDMEMBER = "btn_addmember";
    private static final String BTN_DELMEMBER = "btn_delmember";
    private static final String BTN_SAVEMEMBER = "btn_savemember";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_UPMOVE = "btn_upmove";
    private static final String BTN_DOWNMOVE = "btn_downmove";
    private static final String BTN_CUT = "btn_cut";
    private static final String BTN_PASTE = "btn_paste";
    private static final String BTN_IMPORT = "btn_import";
    private static final String BTN_EXPORT = "btn_export";
    private static final String DIMRELATTREE = "dimrelattree";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String REALTIONSEARCH = "searchdimrelat";
    private static final String MEMBERSEARCH = "searchmember";
    private static final String UPDIMRELAT = "updimrelat";
    private static final String DOWNDIMRELAT = "downdimrelat";
    private static final String UPMEMBER = "upmember";
    private static final String DOWNMEMBER = "downmember";
    private static final String CURRENT_SCHEME_ID = "currentNodeId";
    private static final String CALLBCAK_IMPORT_CLOSE = "import_close";
    public static final String tempPath = "dimensionrelation/dimensionrelation.xlsx";
    private static final String TOOLBARAP = "toolbarap";
    private static final String DIMENSION_CALLBACK = "dimension_callback";
    private static final String START_PERIOD = "startperiod";
    private static final String END_PERIOD = "endperiod";
    private static final String STATUS = "status";
    private static final String SPILTSTR = "$_$";
    private static final Log log = LogFactory.getLog(DimensionRelationListPlugin.class);
    private static final Set<String> dimSet = new HashSet<String>(Arrays.asList("entity", "account", "year", "period", "budgetperiod", "version", "currency", "datatype", "changetype", "audittrail", "metric", "internalcompany", "scenario", "process"));
    private static final String DIMENSION1 = "dimension1";
    private static final String DIMENSION2 = "dimension2";
    private static final String DIMENSION3 = "dimension3";
    private static final String DIMENSION4 = "dimension4";
    private static final String DIMENSION5 = "dimension5";
    private static final String DIMENSION6 = "dimension6";
    private static final Set<String> DIMENSION_SET = new HashSet<String>(Arrays.asList("dimension1", "dimension2", "dimension3", "dimension4", "dimension5", "dimension6"));
    private static final Set<String> DIMENSION_RANGE_SET = DIMENSION_SET.stream().map(k -> k + "range").collect(Collectors.toSet());

    public void initialize() {
        super.initialize();
        BillList schemeBillList = (BillList)this.getControl("schemebilllist");
        schemeBillList.addCreateListDataProviderListener(this::schemeBeforeCreateListDataProvider);
        schemeBillList.addSetFilterListener(this::setSchemeFilter);
        schemeBillList.addListRowClickListener((ListRowClickListener)this);
        schemeBillList.addHyperClickListener((HyperLinkClickListener)this);
        this.getView().addCustomControls(new String[]{TREEENTRYENTITY});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)TREEENTRYENTITY)) {
            RelationEntryGridControl entryGrid = new RelationEntryGridControl();
            entryGrid.setView(this.getView());
            entryGrid.setModel(this.getModel());
            entryGrid.setKey(key);
            entryGrid.setEntryKey(key);
            entryGrid.setSplitPage(true);
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                this.findControl(TREEENTRYENTITY);
            }
            if (oldGrid instanceof EntryGrid) {
                entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADDDIMRELAT, BTN_EDITDIMRELAT, BTN_DELDIMRELAT, BTN_ADDMEMBER, BTN_DELMEMBER, BTN_UPMOVE, BTN_DOWNMOVE, BTN_CUT, BTN_PASTE, UPDIMRELAT, DOWNDIMRELAT, UPMEMBER, DOWNMEMBER, BTN_IMPORT, BTN_EXPORT, BTN_ENABLE, BTN_DISABLE});
        this.addItemClickListeners(new String[]{TOOLBARAP});
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addBeforeF7SelectListener();
        this.addEnterListeners(REALTIONSEARCH, MEMBERSEARCH);
        for (String dim : DIMENSION_SET) {
            TextEdit textEdit = (TextEdit)this.getControl(dim);
            if (dim == null) continue;
            textEdit.addClickListener((ClickListener)this);
        }
    }

    private void addEnterListeners(String ... keys) {
        for (String key : keys) {
            Search relationSearch = (Search)this.getControl(key);
            relationSearch.addEnterListener((SearchEnterListener)this);
        }
    }

    private void addBeforeF7SelectListener() {
        BasedataEdit f7 = null;
        for (String dim : dimSet) {
            f7 = (BasedataEdit)this.getControl(dim);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startPeriod = (BasedataEdit)this.getControl(START_PERIOD);
        BasedataEdit endPeriod = (BasedataEdit)this.getControl(END_PERIOD);
        startPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        endPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        DimRelUpdateDao.getInstance().updateRel(modelId, Collections.emptyList());
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("modelId", modelId.toString());
        this.initVisible();
        this.initTree();
    }

    private void initVisible() {
        for (String dim : dimSet) {
            this.setVisible(Boolean.FALSE, dim);
        }
        for (String dim : DIMENSION_SET) {
            this.setVisible(Boolean.FALSE, dim);
        }
    }

    private void setVisible(Boolean visible, String key) {
        this.getView().setVisible(visible, new String[]{key, StringUtils.join((Object[])new String[]{key, "name"}), StringUtils.join((Object[])new String[]{key, "range"}), StringUtils.join((Object[])new String[]{key, "vnumber"}), StringUtils.join((Object[])new String[]{key, "vname"})});
    }

    private void setVisible(Boolean visible, String key, String dimNumber, Boolean isProperty) {
        if (View.NoViewDimNums.contains(dimNumber) || isProperty.booleanValue()) {
            this.getView().setVisible(visible, new String[]{key, StringUtils.join((Object[])new String[]{key, "name"}), StringUtils.join((Object[])new String[]{key, "range"})});
        } else {
            this.getView().setVisible(visible, new String[]{key, StringUtils.join((Object[])new String[]{key, "name"}), StringUtils.join((Object[])new String[]{key, "range"}), StringUtils.join((Object[])new String[]{key, "vnumber"}), StringUtils.join((Object[])new String[]{key, "vname"})});
        }
    }

    private void refreshAll() {
        this.refreshTree();
    }

    private void refreshTree() {
        this.initTree();
    }

    private void initTree() {
        int maxSeq = 0;
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        treeView.deleteAllNodes();
        String selects = "id, name,dseq";
        DynamicObjectCollection relationId = QueryServiceHelper.query((String)"epm_dimensionrelation", (String)selects, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())}, (String)"dseq");
        String rootNodeId = "0";
        String text = ResManager.loadKDString((String)"\u5168\u90e8", (String)"DimensionRelationListPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        TreeNode root = this.createTreeNode("", rootNodeId, text, "1");
        if (relationId != null && relationId.size() != 0) {
            for (DynamicObject relation : relationId) {
                String id = relation.getString("id");
                String name = relation.getString("name");
                ArrayList<TreeNode> children = root.getChildren();
                if (children == null) {
                    children = new ArrayList<TreeNode>(16);
                    root.setChildren(children);
                }
                TreeNode relationNode = this.createTreeNode(rootNodeId, id, name, "2");
                children.add(relationNode);
            }
            maxSeq = ((DynamicObject)relationId.get(relationId.size() - 1)).getInt("dseq");
            treeView.addNode(root);
            treeView.expand(rootNodeId);
            this.getPageCache().put("biggestTreeSeq", String.valueOf(maxSeq));
        } else {
            this.clearAllCache();
            this.getModel().deleteEntryData(TREEENTRYENTITY);
            treeView.addNode(root);
        }
        this.getPageCache().put("rootNode", ObjectSerialUtil.toByteSerialized((Object)root));
        this.setDefaultNode();
    }

    private TreeNode createTreeNode(String parentId, String id, String name, String level) {
        TreeNode node = new TreeNode();
        node.setParentid(parentId);
        node.setId(id);
        node.setText(name);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("id", id);
        data.put("name", name);
        data.put("level", level);
        node.setData(data);
        return node;
    }

    private void setDefaultNode() {
        TreeNode currentNode;
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        TreeNode root = this.getRootNode();
        treeView.focusNode(root);
        List childNodeList = root.getChildren();
        String nodeId = null;
        DimRelation dimRelation = this.getCurRelation();
        if (dimRelation != null) {
            Long relateId = dimRelation.getRelationId();
            nodeId = String.valueOf(relateId);
        }
        if (StringUtils.isEmpty(nodeId)) {
            currentNode = root;
        } else {
            currentNode = this.getNode(nodeId);
            if (currentNode == null) {
                currentNode = (TreeNode)childNodeList.get(0);
            }
        }
        treeView.focusNode(currentNode);
        this.treeNodeClick(new TreeNodeEvent(new Object(), (Object)root.getId(), (Object)currentNode.getId()));
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String f7Key = event.getProperty().getName();
        if ("model".equals(f7Key)) {
            this.beforeF7SelectModel(event);
        } else {
            this.beforeF7SelectDim(event);
        }
    }

    private void beforeF7SelectModel(BeforeF7SelectEvent event) {
        PluginUtils.setModelFilter((BeforeF7SelectEvent)event, (IFormView)this.getView());
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)event);
    }

    private void beforeF7SelectDim(BeforeF7SelectEvent event) {
        String f7Key = event.getProperty().getName();
        ListShowParameter showP = (ListShowParameter)event.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        String dimNum = "";
        long modelId = this.getModelId();
        qs.add(new QFilter("model", "=", (Object)modelId));
        qs.add(new QFilter("level", ">", (Object)1));
        if (f7Key.equals(START_PERIOD) || f7Key.equals(END_PERIOD)) {
            dimNum = SysDimensionEnum.BudgetPeriod.getNumber();
            BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
            if (basedataEdit.isF7Click()) {
                event.setCancel(true);
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNum), (String)ListSelectedRow.class.getName());
                f7Param.setOnlySelLeaf(true);
                NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, f7Key));
            } else {
                qs.add(new QFilter("isleaf", "=", (Object)"1"));
                showP.setListFilterParameter(new ListFilterParameter(qs, null));
                event.setFormShowParameter((FormShowParameter)showP);
            }
        }
    }

    private void schemeBeforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setSchemeFilter(SetFilterEvent setFilterEvent) {
        List qFilters = setFilterEvent.getQFilters();
        long modelId = this.getModelId();
        QFilter qModel = new QFilter("model", "=", (Object)modelId);
        qFilters.add(qModel);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().remove("dimRelation");
        if ("0".equals(nodeId)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"schemepanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"memberpanel"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVEMEMBER});
            BillList schemeBillList = (BillList)this.getControl("schemebilllist");
            schemeBillList.refresh();
            schemeBillList.clearSelection();
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"memberpanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"schemepanel"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_SAVEMEMBER});
            this.initVisible();
            this.cacheDimRelationInfo(nodeId);
            this.refreshBillList();
            this.clearMemberSearchCache();
        }
    }

    private void cacheDimRelationInfo(String nodeId) {
        EntryGrid treeEntry = (EntryGrid)this.getControl(TREEENTRYENTITY);
        Long pkId = IDUtils.toLong((Object)nodeId);
        log.info("current relation scheme id = " + pkId);
        DynamicObject doc = DimRelDao.getInstance().getRelationById(this.getModelId(), pkId);
        if (doc != null) {
            DynamicObjectCollection dimCollection = doc.getDynamicObjectCollection("entryentity");
            DimRelation dimRelation = new DimRelation(this.getModelId().longValue(), doc);
            List businessmodels = doc.getDynamicObjectCollection("businessmodel").stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
            dimRelation.setBizModel(businessmodels);
            this.getPageCache().put("dimRelation", SerializationUtils.serializeToBase64((Object)dimRelation));
            if (DimRelationScope.BIZMODEL.getIndex().equals(dimRelation.getAffectRange())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{START_PERIOD, END_PERIOD});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{START_PERIOD, END_PERIOD});
            }
            for (int i = 0; i < dimCollection.size(); ++i) {
                DynamicObject object = (DynamicObject)dimCollection.get(i);
                DynamicObject dimension = object.getDynamicObject("dimension");
                if (dimension == null) continue;
                String dimName = dimension.getString("name");
                String dimensionControl = StringUtils.join((Object[])new Serializable[]{"dimension", Integer.valueOf(i + 1)});
                String dimensionControlName = StringUtils.join((Object[])new String[]{dimensionControl, "name"});
                String dimensionControlRange = StringUtils.join((Object[])new String[]{dimensionControl, "range"});
                DynamicObject dimproperty = object.getDynamicObject("dimproperty");
                this.setVisible(Boolean.TRUE, dimensionControl, dimension.getString("number"), dimproperty != null);
                if (dimproperty != null) {
                    dimName = dimName + new LocaleString(ResManager.loadKDString((String)"-", (String)"DimensionRelationListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    dimName = dimName + dimproperty.getString("name");
                } else {
                    String dimensionControlViewNumber = StringUtils.join((Object[])new String[]{dimensionControl, "vnumber"});
                    String dimensionControlViewName = StringUtils.join((Object[])new String[]{dimensionControl, "vname"});
                    treeEntry.setColumnProperty(dimensionControlViewNumber, "header", (Object)new LocaleString(StringUtils.join((Object[])new String[]{dimName, ResManager.loadKDString((String)"\u89c6\u56fe\u7f16\u7801", (String)"DimensionRelationListPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[0])})));
                    treeEntry.setColumnProperty(dimensionControlViewName, "header", (Object)new LocaleString(StringUtils.join((Object[])new String[]{dimName, ResManager.loadKDString((String)"\u89c6\u56fe\u540d\u79f0", (String)"DimensionRelationListPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[0])})));
                }
                treeEntry.setColumnProperty(dimensionControlName, "header", (Object)new LocaleString(StringUtils.join((Object[])new String[]{dimName, ResManager.loadKDString((String)"\u540d\u79f0", (String)"DimensionRelationListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0])})));
                treeEntry.setColumnProperty(dimensionControl, "header", (Object)new LocaleString(StringUtils.join((Object[])new String[]{dimName, ResManager.loadKDString((String)"\u5185\u7801", (String)"DimensionRelationListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0])})));
                treeEntry.setColumnProperty(dimensionControlRange, "header", (Object)new LocaleString(StringUtils.join((Object[])new String[]{dimName, ResManager.loadKDString((String)"\u8303\u56f4", (String)"DimensionRelationListPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0])})));
                if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getString("number"))) continue;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{START_PERIOD, END_PERIOD});
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_adddimrelat": 
            case "btn_editdimrelat": {
                this.openDimensionPage(key);
                break;
            }
            case "btn_deldimrelat": {
                this.deleteRelationConfirm();
                break;
            }
            case "btn_addmember": {
                this.addMemberEntry();
                break;
            }
            case "btn_delmember": {
                this.deleteMemberConfirm();
                break;
            }
            case "updimrelat": 
            case "downdimrelat": {
                this.dimUpAndDown(key);
                break;
            }
            case "upmember": 
            case "downmember": {
                this.memberUpAndDown(key);
                break;
            }
            case "btn_import": {
                this.importExcel();
                break;
            }
            case "btn_export": {
                this.exportExcel();
                break;
            }
            case "dimension1": 
            case "dimension2": 
            case "dimension3": 
            case "dimension4": 
            case "dimension5": 
            case "dimension6": {
                this.dimensionClick(key);
                break;
            }
            case "btn_enable": {
                this.enableMember(true);
                break;
            }
            case "btn_disable": {
                this.enableMember(false);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        String column = hyperLinkClickEvent.getFieldName();
        BillList billList = (BillList)this.getControl("schemebilllist");
        String focusRowPkId = String.valueOf(billList.getFocusRowPkId());
        if ("number".equals(column)) {
            this.showSchemeForm(focusRowPkId);
        }
    }

    private void showSchemeForm(String rowId) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "epm_dimensionrelation");
        openParameter.put("pkId", rowId);
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCustomParam("pkId", (Object)rowId);
        formShowParameter.setFormId("epm_dimensionrelation");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ADD&MODIFY"));
        this.getView().showForm(formShowParameter);
    }

    private void dimensionClick(String key) {
        this.getPageCache().put("dimensionKey", key);
        long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        String dimRelationStr = this.getPageCache().get("dimRelation");
        if (StringUtils.isEmpty((CharSequence)dimRelationStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DimRelation dimRelation = (DimRelation)SerializationUtils.deSerializeFromBase64((String)dimRelationStr);
        Map dimMap = dimRelation.getDimMap();
        DimRelationEntry entry = (DimRelationEntry)dimMap.get(key);
        Long dimensionId = entry.getDimensionId();
        Long viewId = IDUtils.toLong((Object)this.getModel().getValue(key + "vid"));
        List viewIds = entry.getViewIds();
        Long propertyId = entry.getPropertyId();
        Dimension dimension = modelCache.getDimension(dimensionId);
        if (propertyId != null && propertyId != 0L) {
            this.showDimPropertyForm(propertyId);
        } else {
            Object memberId = null;
            if (this.getModel().getProperty(key + "id") != null) {
                memberId = this.getModel().getValue(key + "id");
            }
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)dimensionId), (String)ListSelectedRow.class.getName());
            f7Param.setCanSelectRoot(false);
            if (StringUtils.equalsAny((CharSequence)dimension.getNumber(), (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber()}) || !dimension.isPreset()) {
                f7Param.setCanSelectRoot(true);
            }
            f7Param.setVerifyPermission(false);
            if (IDUtils.isNotNull((Long)viewId)) {
                f7Param.setViewId(viewId);
            } else if (CollectionUtils.isNotEmpty((Collection)viewIds)) {
                f7Param.setViewId((Long)viewIds.get(0));
            }
            if (CollectionUtils.isNotEmpty((Collection)viewIds)) {
                f7Param.setViewIds(viewIds);
            }
            f7Param.setEnableView(true);
            if (DimRelationScope.BIZMODEL.getIndex().equals(dimRelation.getAffectRange()) && SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                LinkedHashSet datasetIds = new LinkedHashSet();
                List bizModels = dimRelation.getBizModel();
                for (Long bizModel : bizModels) {
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and(new QFilter("businessmodel", "=", (Object)bizModel));
                    DynamicObjectCollection dataSets = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])qFilter.toArray());
                    Set dataSetIds = dataSets.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                    datasetIds.addAll(dataSetIds);
                }
                f7Param.setDatasetIds(new ArrayList(datasetIds));
            }
            if (memberId instanceof Long) {
                f7Param.setSelectId((Long)memberId);
            }
            f7Param.setLoadDefaultBusModel(false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DIMENSION_CALLBACK);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
        }
    }

    private void showDimPropertyForm(long propertyId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("eb_cuspropertyvalueselect");
        listShowParameter.setShowUsed(true);
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DIMENSION_CALLBACK));
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(new QFilter("property", "=", (Object)propertyId));
        if (listShowParameter.getCustomParams() != null) {
            listShowParameter.getCustomParams().put("noNeedDefaultQFilter", "true");
        }
        listShowParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void deleteMemberConfirm() {
        int[] rows = this.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"DimensionRelationListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u884c\uff1f", (String)"DimensionRelationListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteRelationMember", (IFormPlugin)this));
    }

    private int[] getSelectRows() {
        EntryGrid entity = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        return entity.getSelectRows();
    }

    private void deleteRelationConfirm() {
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId) || "0".equals(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7ef4\u5ea6\u5173\u7cfb\u65b9\u6848\u3002", (String)"DimensionRelationListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u65b9\u6848\u5c06\u540c\u65f6\u5220\u9664\u6240\u6709\u6210\u5458\u5173\u7cfb\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"DimensionRelationListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteRelation", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        if (mbce.getResult().equals((Object)MessageBoxResult.Cancel)) {
            return;
        }
        switch (callBackId = mbce.getCallBackId()) {
            case "deleteRelation": {
                this.deleteRelation();
                break;
            }
            case "deleteRelationMember": {
                this.deleteRelationMember();
                break;
            }
            case "refresh": {
                this.refreshAll();
                break;
            }
        }
    }

    private void deleteRelation() {
        Long nodeId = IDUtils.toLong((Object)this.getSchemeId());
        QFilter qFilter = new QFilter("dimrelationinfo2.fbasedataid_id", "=", (Object)nodeId);
        DimRelation curRelation = this.getCurRelation();
        if (curRelation == null) {
            return;
        }
        if (DimRelationScope.TEMPLATE.getIndex().equals(curRelation.getAffectRange()) && QueryServiceHelper.exists((String)"eb_templateentity", (QFilter[])qFilter.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u88ab\u6a21\u677f\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DimensionRelationListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        log.info("DimensionRelationList.deleteRelation: " + nodeId);
        DimRelDao.getInstance().deleteRelation(nodeId.longValue());
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u5173\u7cfb\u65b9\u6848\u5220\u9664", "DimensionRelationListPlugin_65", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "DimensionRelationListPlugin_5", "epm-eb-formplugin");
        this.writeLog("delete", opName, opDescription);
        this.getView().showSuccessNotification(opDescription.loadKDString());
        this.getView().getPageCache().remove("dimRelation");
        this.refreshAll();
    }

    private void deleteRelationMember() {
        int[] rows = this.getSelectRows();
        HashSet ids = Sets.newHashSetWithExpectedSize((int)rows.length);
        for (int row : rows) {
            Object id = this.getModel().getValue("id", row);
            if (Objects.isNull(id) || Objects.equals("", id)) continue;
            ids.add(IDUtils.toLong((Object)id));
        }
        RelationEntryGridControl entryGridControl = (RelationEntryGridControl)this.getView().getControl(TREEENTRYENTITY);
        AbstractGrid.GridState entryState = entryGridControl.getEntryState();
        int pageRows = entryState.getPageRows();
        int entryRowCount = this.getModel().getEntryRowCount(TREEENTRYENTITY);
        Integer currentPageIndex = entryState.getCurrentPageIndex();
        int maxPage = entryRowCount % pageRows == 0 ? entryRowCount / pageRows : entryRowCount / pageRows + 1;
        DimMemRelDao.getInstance().deleteById(this.getModelId().longValue(), IDUtils.toLong((Object)this.getSchemeId()).longValue(), (Set)ids);
        if (currentPageIndex != maxPage) {
            entryGridControl.setPageIndex(currentPageIndex);
        } else {
            int startRowIndex = (currentPageIndex - 1) * pageRows;
            this.getModel().deleteEntryRows(TREEENTRYENTITY, rows);
            entryGridControl.setEntryPageInfo(pageRows, entryRowCount -= rows.length, startRowIndex);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionRelationListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refresh();
                break;
            }
            case "btn_savemember": {
                RelationEntryGridControl entryGridControl = (RelationEntryGridControl)this.getView().getControl(TREEENTRYENTITY);
                List<Integer> rows = entryGridControl.getRowsToSave();
                if (rows.size() > 0) {
                    entryGridControl.saveMember(rows, true);
                    break;
                }
                DimRelDao.getInstance().updateVersion(this.getModelId().longValue(), IDUtils.toLong((Object)this.getSchemeId()).longValue());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DimensionRelationListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void enableMember(boolean enable) {
        DynamicObject[] objects;
        int[] rows = this.getSelectRows();
        if (rows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"DimensionRelationListPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)rows.length);
        for (int row : rows) {
            Object id = this.getModel().getValue("id", row);
            if (Objects.isNull(id) || Objects.equals("", id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u6240\u9009\u6570\u636e\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DimensionRelationListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ids.add(IDUtils.toLong((Object)id));
        }
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"epm_dimmemberrelation", (String)STATUS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)})) {
            object.set(STATUS, (Object)enable);
        }
        SaveServiceHelper.save((DynamicObject[])objects);
        for (int row : rows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, row);
            entryRowEntity.set(STATUS, (Object)enable);
        }
        this.getView().updateView(TREEENTRYENTITY);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DimensionRelationListPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void refresh() {
        RelationEntryGridControl entryGridControl = (RelationEntryGridControl)this.getView().getControl(TREEENTRYENTITY);
        List<Integer> rowsToSave = entryGridControl.getRowsToSave();
        if (rowsToSave.size() != 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u5237\u65b0\u540e\u5c06\u4e22\u5931\u8fd9\u4e9b\u4fee\u6539\uff0c\u662f\u5426\u5237\u65b0\uff1f", (String)"DimensionRelationListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("refresh", (IFormPlugin)this));
        } else {
            this.refreshTree();
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0) {
            Object newValue = changeSet[0].getNewValue();
            int rowIndex = changeSet[0].getRowIndex();
            if (START_PERIOD.equals(name)) {
                if (newValue instanceof DynamicObject) {
                    DynamicObject period = (DynamicObject)newValue;
                    this.validStartPeriod(rowIndex, period.getLong("id"));
                }
            } else if (END_PERIOD.equals(name) && newValue instanceof DynamicObject) {
                DynamicObject period = (DynamicObject)newValue;
                this.validEndPeriod(rowIndex, period.getLong("id"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            if (model != null) {
                this.getPageCache().put("modelId", model.getString("id"));
                DimRelUpdateDao.getInstance().updateRel(Long.valueOf(model.getLong("id")), Collections.emptyList());
            } else {
                this.getPageCache().put("modelId", "0");
            }
            this.initVisible();
            this.clearAllCache();
            this.refreshAll();
        } else if (DIMENSION_SET.contains(key) || DIMENSION_RANGE_SET.contains(key) || STATUS.equals(key) || START_PERIOD.equals(key) || END_PERIOD.equals(key)) {
            this.rowValueChange(e, key);
        }
    }

    private void rowValueChange(PropertyChangedArgs e, String key) {
        ChangeData changeData = e.getChangeSet()[0];
        int row = changeData.getRowIndex();
        RelationEntryGridControl entryGridControl = (RelationEntryGridControl)this.getView().getControl(TREEENTRYENTITY);
        String selectId = entryGridControl.getSelectId(row);
        if (StringUtils.isNotEmpty((CharSequence)selectId)) {
            this.getModel().setValue("rowtype", (Object)"2", row);
        } else {
            this.getModel().setValue("rowtype", (Object)"1", row);
        }
        entryGridControl.setRowBackcolor("", new int[]{row});
        if (DIMENSION_SET.contains(key) && (changeData.getNewValue() == null || StringUtils.isEmpty((CharSequence)String.valueOf(changeData.getNewValue())))) {
            this.getModel().setValue(key + "id", (Object)0L, row);
            this.getModel().setValue(key + "name", (Object)"", row);
            this.getModel().setValue(key + "vid", (Object)0L, row);
            this.getModel().setValue(key + "vnumber", (Object)"", row);
            this.getModel().setValue(key + "vname", (Object)"", row);
        }
    }

    private void clearAllCache() {
        this.getPageCache().remove("dimRelation");
        this.getPageCache().remove("biggestTreeSeq");
        this.clearAllSearchCache();
    }

    private void clearAllSearchCache() {
        this.clearTreeSearchCache();
        this.clearMemberSearchCache();
    }

    private void clearTreeSearchCache() {
        Search search = (Search)this.getControl(REALTIONSEARCH);
        search.setSearchKey("");
        this.getPageCache().remove("relatSearchResult");
    }

    private void clearMemberSearchCache() {
        Search search = (Search)this.getControl(MEMBERSEARCH);
        search.setSearchKey("");
        this.getPageCache().remove("memberSearchResult");
    }

    private void openDimensionPage(String key) {
        FormShowParameter formShowParameter = null;
        if (BTN_EDITDIMRELAT.equals(key)) {
            TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (StringUtils.isEmpty((CharSequence)nodeId) || "0".equals(nodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "epm_dimensionrelation");
            openParameter.put("pkId", nodeId);
            formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
            formShowParameter.setCustomParam("pkId", (Object)nodeId);
        } else {
            formShowParameter = new FormShowParameter();
            int seq = this.getIntCacheByKey("biggestTreeSeq");
            formShowParameter.setCustomParam("dseq", (Object)seq);
        }
        formShowParameter.setFormId("epm_dimensionrelation");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ADD&MODIFY"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "ADD&MODIFY": {
                this.refreshTree();
                break;
            }
            case "import_close": {
                this.importCloseBack(closedCallBackEvent);
                break;
            }
            case "dimension_callback": 
            case "endperiod": 
            case "startperiod": {
                this.setSelectValue(key, closedCallBackEvent);
                break;
            }
        }
    }

    private void setSelectValue(String key, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData.size() == 0) {
                return;
            }
            ListSelectedRow selectedRow = returnData.get(0);
            int[] rows = this.getSelectRows();
            int row = rows[0];
            if (DIMENSION_CALLBACK.equals(key)) {
                String dimensionKey = this.getPageCache().get("dimensionKey");
                this.getModel().setValue(dimensionKey + "id", selectedRow.getPrimaryKeyValue(), row);
                this.getModel().setValue(dimensionKey, (Object)selectedRow.getNumber(), row);
                this.getModel().setValue(dimensionKey + "name", (Object)selectedRow.getName(), row);
                if (selectedRow.getDataMap() != null && !View.NoViewDimNums.contains(selectedRow.getDataMap().get("dimNumber"))) {
                    Long viewId = IDUtils.toLong(selectedRow.getDataMap().get("viewid"));
                    DynamicObject viewInfo = DimensionViewServiceHelper.getInstance().getViewInfo(viewId);
                    if (viewInfo != null) {
                        this.getModel().setValue(dimensionKey + "vid", (Object)viewInfo.getLong("id"), row);
                        this.getModel().setValue(dimensionKey + "vnumber", (Object)viewInfo.getString("number"), row);
                        this.getModel().setValue(dimensionKey + "vname", (Object)viewInfo.getString("name"), row);
                    }
                }
            } else if (START_PERIOD.equals(key)) {
                Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
                this.validStartPeriod(row, primaryKeyValue);
                this.getModel().setValue(START_PERIOD, selectedRow.getPrimaryKeyValue(), row);
            } else if (END_PERIOD.equals(key)) {
                Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
                this.validEndPeriod(row, primaryKeyValue);
                this.getModel().setValue(END_PERIOD, (Object)primaryKeyValue, row);
            }
        }
    }

    private void validStartPeriod(int row, Long endPeriodId) {
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue(END_PERIOD, row);
        if (endPeriod != null) {
            String endNumber = endPeriod.getString("number");
            DynamicObject startPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriodId, (String)"epm_bperiodmembertree");
            if (startPeriod != null && BgPeriodHelper.comparePeriod((String)startPeriod.getString("number"), (String)endNumber) > 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u542f\u7528\u671f\u95f4\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7981\u7528\u671f\u95f4\u3002", (String)"DimensionRelationListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validEndPeriod(int row, Long endPeriodId) {
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue(START_PERIOD, row);
        if (startPeriod != null) {
            String startNumber = startPeriod.getString("number");
            DynamicObject endPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriodId, (String)"epm_bperiodmembertree");
            if (endPeriod != null && BgPeriodHelper.comparePeriod((String)startNumber, (String)endPeriod.getString("number")) > 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7981\u7528\u671f\u95f4\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u671f\u95f4\u3002", (String)"DimensionRelationListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void importCloseBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        Map resultMap = (Map)closedCallBackEvent.getReturnData();
        int count = (Integer)resultMap.get("count");
        if (count < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimensionRelationListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (count != 0) {
            boolean repeat = (Boolean)resultMap.get("repeat");
            if (repeat) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002\u5df2\u8df3\u8fc7\u91cd\u590d\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DimensionRelationListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList();
        }
    }

    public void search(SearchEnterEvent event) {
        Search search = (Search)event.getSource();
        String key = search.getKey();
        String text = event.getText().trim().toLowerCase();
        if (MEMBERSEARCH.equals(key)) {
            this.memberSearch(text);
        } else {
            this.relationSearch(text);
        }
    }

    private void refreshBillList() {
        RelationEntryGridControl entryGridControl = (RelationEntryGridControl)this.getView().getControl(TREEENTRYENTITY);
        entryGridControl.setPageIndex(1, false);
    }

    private DimRelation getCurRelation() {
        DimRelation dimRelation = null;
        String relationCache = this.getPageCache().get("dimRelation");
        if (StringUtils.isNotEmpty((CharSequence)relationCache)) {
            dimRelation = (DimRelation)SerializationUtils.deSerializeFromBase64((String)relationCache);
        }
        return dimRelation;
    }

    public Long getModelId() {
        Long model = IDUtils.toLong((Object)this.getCacheByKey("modelId"));
        if (model == 0L) {
            DynamicObject modelObj = (DynamicObject)this.getModel().getValue("model");
            model = modelObj != null ? modelObj.getLong("id") : 0L;
        }
        return model;
    }

    private String getSchemeId() {
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        return treeView.getTreeState().getFocusNodeId();
    }

    private String getCacheByKey(String key) {
        String cacheValue = this.getPageCache().get(key);
        return cacheValue == null ? "" : cacheValue;
    }

    private int getIntCacheByKey(String key) {
        String cacheValue = this.getCacheByKey(key);
        return StringUtils.isEmpty((CharSequence)cacheValue) ? 0 : Integer.parseInt(cacheValue);
    }

    private void focusRow(int row) {
        EntryGrid treeEntry = (EntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntry.selectRows(row);
    }

    private void addMemberEntry() {
        if (StringUtils.isNotEmpty((CharSequence)this.getSchemeId())) {
            RelationEntryGridControl entryGridControl = (RelationEntryGridControl)this.getView().getControl(TREEENTRYENTITY);
            entryGridControl.addRow();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private QFilter getMemberQFilter(Long relationId) {
        return new QFilter("relationid", "=", (Object)relationId);
    }

    private void memberSearch(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        int startIndex = entryGrid.getEntryData().getStartIndex();
        int maxIndex = entryGrid.getEntryData().getEndIndex();
        int selectRow = -1;
        DimRelation curRelation = this.getCurRelation();
        if (curRelation == null) {
            return;
        }
        ArrayList<Integer> searchResult = new ArrayList<Integer>(16);
        Map dimMap = curRelation.getDimMap();
        block0: for (int row = startIndex; row < maxIndex; ++row) {
            for (Map.Entry entry : dimMap.entrySet()) {
                String number = (String)this.getModel().getValue((String)entry.getKey(), row);
                String name = (String)this.getModel().getValue((String)entry.getKey() + "name", row);
                if (!number.toLowerCase().contains(text.toLowerCase()) && !name.toLowerCase().contains(text.toLowerCase())) continue;
                if (selectRow == -1) {
                    selectRow = row;
                }
                searchResult.add(row);
                continue block0;
            }
        }
        if (selectRow == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f\u3002", (String)"DimensionRelationListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.focusRow(selectRow);
        this.getPageCache().put("memberSearchResult", ObjectSerialUtil.toByteSerialized(searchResult));
    }

    private void relationSearch(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u67e5\u8be2\u7684\u5185\u5bb9\u3002", (String)"DecomposeTaskProcessPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkSelectEntry().booleanValue()) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(DIMRELATTREE);
        TreeNode focusNode = null;
        ArrayList<TreeNode> resultNode = new ArrayList<TreeNode>(16);
        TreeNode root = this.getRootNode();
        List childNode = root.getChildren();
        if (childNode != null) {
            for (TreeNode cNode : childNode) {
                String info = cNode.getText().trim();
                if (!info.toLowerCase().contains(text.toLowerCase())) continue;
                if (focusNode == null) {
                    focusNode = cNode;
                }
                resultNode.add(cNode);
            }
        }
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f\u3002", (String)"DimensionRelationListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        treeView.focusNode(focusNode);
        this.getPageCache().put("relatSearchResult", ObjectSerialUtil.toByteSerialized(resultNode));
    }

    private void dimUpAndDown(String key) {
        String resultCache = this.getCacheByKey("relatSearchResult");
        if (StringUtils.isEmpty((CharSequence)resultCache)) {
            return;
        }
        int currentNodeIndex = -1;
        List nodes = (List)ObjectSerialUtil.deSerializedBytes((String)resultCache);
        TreeView treeView = (TreeView)this.getControl(DIMRELATTREE);
        String nodeId = this.getSchemeId();
        TreeNode node = null;
        for (int i = 0; i < nodes.size(); ++i) {
            node = (TreeNode)nodes.get(i);
            if (!node.getId().equalsIgnoreCase(nodeId)) continue;
            currentNodeIndex = i;
            break;
        }
        TreeNode root = this.getRootNode();
        if (currentNodeIndex == -1) {
            TreeNode searchedNode = (TreeNode)nodes.get(0);
            treeView.focusNode(searchedNode);
            this.treeNodeClick(new TreeNodeEvent(new Object(), (Object)root.getId(), (Object)searchedNode.getId()));
        } else if (currentNodeIndex == 0 && UPDIMRELAT.equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (currentNodeIndex == nodes.size() - 1 && DOWNDIMRELAT.equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            currentNodeIndex = UPDIMRELAT.equals(key) ? --currentNodeIndex : ++currentNodeIndex;
            TreeNode searchedNode = (TreeNode)nodes.get(currentNodeIndex);
            treeView.focusNode(searchedNode);
            this.treeNodeClick(new TreeNodeEvent(new Object(), (Object)root.getId(), (Object)searchedNode.getId()));
        }
    }

    private void memberUpAndDown(String key) {
        String resultCache = this.getCacheByKey("memberSearchResult");
        if (StringUtils.isEmpty((CharSequence)resultCache)) {
            return;
        }
        int currentRowIndex = -1;
        List rows = (List)ObjectSerialUtil.deSerializedBytes((String)resultCache);
        int[] selectRows = this.getSelectRows();
        if (selectRows.length != 1) {
            this.focusRow((Integer)rows.get(0));
            return;
        }
        for (int i = 0; i < rows.size(); ++i) {
            int row = (Integer)rows.get(i);
            if (row != selectRows[0]) continue;
            currentRowIndex = i;
            break;
        }
        if (currentRowIndex == -1) {
            this.focusRow((Integer)rows.get(0));
        } else if (currentRowIndex == 0 && UPMEMBER.equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (currentRowIndex == rows.size() - 1 && DOWNMEMBER.equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            currentRowIndex = UPMEMBER.equals(key) ? --currentRowIndex : ++currentRowIndex;
            this.focusRow((Integer)rows.get(currentRowIndex));
        }
    }

    private TreeNode getNode(String nodeId) {
        TreeNode root = this.getRootNode();
        return root.getTreeNode(nodeId, 10);
    }

    private TreeNode getRootNode() {
        TreeNode root = null;
        String rootCache = this.getCacheByKey("rootNode");
        if (StringUtils.isEmpty((CharSequence)rootCache)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"DimensionRelationListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootCache);
        return root;
    }

    private Boolean checkSelectEntry() {
        RelationEntryGridControl entryGridControl = (RelationEntryGridControl)this.getView().getControl(TREEENTRYENTITY);
        List<Integer> rows = entryGridControl.getRowsToSave();
        if (rows.size() != 0) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5df2\u65b0\u589e\u6216\u4fee\u6539\u7b2c%1\u884c\u7684\u6570\u636e\uff0c\u8bf7\u4fdd\u5b58\u3002", (String)"DimensionRelationListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{rows.stream().map(e -> e + 1 + "").collect(Collectors.joining(", "))}));
            return true;
        }
        return false;
    }

    private void importExcel() {
        try {
            DimRelation curRelation = this.getCurRelation();
            if (curRelation == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long modelId = this.getModelId();
            String schemeId = this.getSchemeId();
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "epm_import");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("model", (Object)modelId);
            showParameter.setCustomParam(CURRENT_SCHEME_ID, (Object)schemeId);
            showParameter.setCustomParam("head", Arrays.asList((Object[])((List)this.getHeadDataInfo().getLeft()).get(0)));
            showParameter.setCustomParam("property", DimensionRelationUtils.getRelationDimension((String)this.getSchemeId()).stream().collect(Collectors.toMap(key -> key.getString("entryentity.dimension.number"), volue -> volue.getString("entryentity.dimproperty"))));
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
            formConfig.getPlugins().clear();
            showParameter.setFormConfig(formConfig);
            showParameter.addCustPlugin("kd.epm.eb.formplugin.dimension.dimensionrelation.DimensionRelationUploadPlugin");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBCAK_IMPORT_CLOSE));
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u4fee\u590d\u540e\u91cd\u8bd5\u3002", (String)"DimensionRelationListPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void exportExcel() {
        DimRelation curRelation = this.getCurRelation();
        if (curRelation == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<String[]> dataLists = this.getExportRowDys(curRelation);
        Pair<List<String[]>, List<CellDropdown>> headDataInfo = this.getHeadDataInfo();
        if (dataLists.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String filename = this.getFileName("");
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 2, 0, 0, Short.valueOf((short)10));
        sheet.setTitle(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5173\u7cfb\u8bb0\u5f55", (String)"DimensionRelationUploadPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        sheet.setTip(ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"DimensionRelationUploadPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        sheet.setTitlePosition(0, 0);
        sheet.setTipPosition(1, 0);
        String url = ExcelImExportUtils.getInstance().writeWithTemplate(tempPath, filename, (List)headDataInfo.getLeft(), dataLists, sheet, null, (List)headDataInfo.getRight());
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private List<String[]> getExportRowDys(DimRelation curRelation) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        ArrayList<String[]> dataLists = new ArrayList<String[]>(16);
        int[] rows = this.getSelectRows();
        IDataModel dataModel = this.getModel();
        boolean hasPeriodDim = false;
        ArrayList dimList = new ArrayList(10);
        for (Map.Entry entry : curRelation.getDimMap().entrySet()) {
            dimList.add(entry.getKey());
            if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(((DimRelationEntry)entry.getValue()).getDimNumber())) continue;
            hasPeriodDim = true;
        }
        Map dimMap = curRelation.getDimMap();
        if (rows == null || rows.length == 0) {
            QFilter qFilter = this.getMemberQFilter(curRelation.getRelationId());
            List data = DimMemRelDao.getInstance().getData(qFilter, 0, 0);
            Map propertyInfoMap = DimensionRelationUtils.getPropertyInfoMap((List)data, (DimRelation)curRelation);
            for (DynamicObject doj : data) {
                ArrayList<String> dataList = new ArrayList<String>(16);
                for (Map.Entry entry : dimMap.entrySet()) {
                    String rangeName;
                    DimRelationEntry relationEntry = (DimRelationEntry)entry.getValue();
                    Long propertyId = relationEntry.getPropertyId();
                    Long viewId = doj.getLong((String)entry.getKey() + "view_id");
                    Dimension dimension = modelCache.getDimension(relationEntry.getDimensionId());
                    long memberId = doj.getLong((String)entry.getKey());
                    String memberRange = doj.getString((String)entry.getKey() + "range");
                    if (propertyId == null || propertyId == 0L) {
                        String dimNumber = dimension.getNumber();
                        Member member = IDUtils.isEmptyLong((Long)viewId) != false ? modelCache.getMember(dimNumber, Long.valueOf(0L), Long.valueOf(memberId)) : modelCache.getMember(dimNumber, viewId, Long.valueOf(memberId));
                        dataList.add(member != null ? member.getNumber() : "");
                        dataList.add(member != null ? member.getName() : "");
                        RangeEnum range = RangeEnum.getRangeByVal((String)memberRange);
                        rangeName = range == null ? "" : range.getName();
                        dataList.add(rangeName);
                        if (View.NoViewDimNums.contains(dimNumber)) continue;
                        dataList.add(doj.getString((String)entry.getKey() + "view.number"));
                        dataList.add(doj.getString((String)entry.getKey() + "view.name"));
                        continue;
                    }
                    PropertyInfo propertyInfo = (PropertyInfo)propertyInfoMap.get(memberId);
                    dataList.add(propertyInfo != null ? propertyInfo.getNumber() : "");
                    dataList.add(propertyInfo != null ? propertyInfo.getName() : "");
                    PropRangeEnum range = PropRangeEnum.getRangeByVal((String)memberRange);
                    rangeName = range == null ? "" : range.getName();
                    dataList.add(rangeName);
                }
                String stateStr = doj.getBoolean(STATUS) ? ResManager.loadKDString((String)"\u542f\u7528", (String)"DimensionRelationListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"DimensionRelationListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                dataList.add(stateStr);
                if (!hasPeriodDim && !DimRelationScope.BIZMODEL.getIndex().equals(curRelation.getAffectRange())) {
                    Member startperiod = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), Long.valueOf(doj.getLong("startperiod_id")));
                    Member endperiod = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), Long.valueOf(doj.getLong("endperiod_id")));
                    dataList.add(startperiod != null ? startperiod.getNumber() : "");
                    dataList.add(endperiod != null ? endperiod.getNumber() : "");
                }
                dataLists.add(dataList.toArray(new String[0]));
            }
        } else {
            for (int i : rows) {
                DynamicObject row = dataModel.getEntryRowEntity(TREEENTRYENTITY, i);
                ArrayList<Object> dataList = new ArrayList<Object>(16);
                for (String entry : dimList) {
                    RangeEnum range;
                    dataList.add(row.get(entry).toString());
                    dataList.add(row.get(entry + "name").toString());
                    DimRelationEntry relationEntry = (DimRelationEntry)dimMap.get(entry);
                    Long propertyId = relationEntry.getPropertyId();
                    String rangeName = propertyId == null || propertyId == 0L ? ((range = RangeEnum.getRangeByVal((String)row.get(entry + "range").toString())) == null ? "" : range.getName()) : ((range = PropRangeEnum.getRangeByVal((String)row.get(entry + "range").toString())) == null ? "" : range.getName());
                    dataList.add(rangeName);
                    if (propertyId != null && propertyId != 0L || View.NoViewDimNums.contains(relationEntry.getDimNumber())) continue;
                    dataList.add(row.get(entry + "vnumber").toString());
                    dataList.add(row.get(entry + "vname").toString());
                }
                String stateStr = row.getBoolean(STATUS) ? ResManager.loadKDString((String)"\u542f\u7528", (String)"DimensionRelationListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"DimensionRelationListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                dataList.add(stateStr);
                if (!hasPeriodDim && !DimRelationScope.BIZMODEL.getIndex().equals(curRelation.getAffectRange())) {
                    dataList.add(row.getString("startperiod.number"));
                    dataList.add(row.getString("endperiod.number"));
                }
                dataLists.add(dataList.toArray(new String[0]));
            }
        }
        return dataLists;
    }

    private String getFileName(String extName) {
        return ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb%1_%2", (String)"DimensionRelationUploadPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{extName, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
    }

    private Pair<List<String[]>, List<CellDropdown>> getHeadDataInfo() {
        return DimensionRelationUtils.getHeadDataInfo((String)this.getSchemeId());
    }
}

