/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class CheckAdjustUtils {
    public static CheckAdjustUtils get() {
        return new CheckAdjustUtils();
    }

    public boolean checkAdjustBill(Long modelId, Set<Long> busModelIds, Object[] memberIdsAry) {
        if (IDUtils.isNull((Long)modelId) || busModelIds == null || busModelIds.isEmpty()) {
            return false;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top 1 e.fentity from t_eb_adjdetail e where ", new Object[0]).appendIn("e.fentity", memberIdsAry);
        sql.append(" and exists (select t.fid from t_eb_adjustbill t where t.fmodel = ? and ", new Object[]{modelId}).appendIn("fbizmodelid", busModelIds.toArray()).append(" and t.fid = e.fid)", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryAdjustBillEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null && ds.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Set<Long> getAdjustBill(Long modelId, Long dimensionId, Set<Long> busModelIds, Set<Long> datasetIds, Object[] memberIdsAry, IModelCacheHelper modelCacheHelper) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || CollectionUtils.isEmpty((Object[])memberIdsAry)) {
            return Collections.emptySet();
        }
        LinkedHashSet refMemberIds = Sets.newLinkedHashSet();
        refMemberIds.addAll(this.queryRefQuote(modelId, dimensionId, datasetIds, memberIdsAry));
        if (refMemberIds.isEmpty()) {
            refMemberIds.addAll(this.queryRefField(modelId, dimensionId, busModelIds, memberIdsAry, modelCacheHelper));
        }
        return refMemberIds;
    }

    private Set<Long> queryRefQuote(Long modelId, Long dimensionId, Set<Long> datasetIds, Object[] memberIdsAry) {
        return MemberQuote.get().queryQuote(modelId, dimensionId, datasetIds, memberIdsAry, MemberQuoteResourceEnum.AdjustBill.getType());
    }

    private Set<Long> queryRefField(Long modelId, Long dimensionId, Set<Long> busModelIds, Object[] memberIdsAry, IModelCacheHelper modelCacheHelper) {
        LinkedHashSet refMemberIds = Sets.newLinkedHashSet();
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"epm_dimension");
        String dimNumber = dimension.getString("number");
        String dimMemberModel = dimension.getString("membermodel");
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)50);
        switch (dimNumber) {
            case "Entity": {
                fields.add("fentity");
                break;
            }
            case "Account": {
                fields.add("faccount");
                break;
            }
            case "InternalCompany": {
                break;
            }
            default: {
                if (!StringUtils.equals((String)"epm_userdefinedmembertree", (String)dimMemberModel)) break;
                fields.addAll(this.getFields(busModelIds, modelCacheHelper));
            }
        }
        for (String _field : fields) {
            if (!DB.existColumn((DBRoute)BgBaseConstant.epm, (String)"t_eb_adjdetail", (String)_field)) continue;
            refMemberIds.addAll(this.queryRefMember(_field, modelId, busModelIds, memberIdsAry));
            if (refMemberIds.isEmpty()) continue;
            break;
        }
        return refMemberIds;
    }

    private List<String> getFields(Set<Long> busModelIds, IModelCacheHelper modelCacheHelper) {
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)50);
        int userDefinedSize = 50;
        HashSet userDefinedNums = Sets.newHashSetWithExpectedSize((int)32);
        List dimensions = Lists.newArrayListWithExpectedSize((int)50);
        if (CollectionUtils.isNotEmpty(busModelIds)) {
            for (Long busModelId : busModelIds) {
                dimensions.addAll(modelCacheHelper.getDimensionListByBusModel(busModelId));
            }
        } else {
            dimensions = modelCacheHelper.getDimensionList();
        }
        for (Dimension _dimension : dimensions) {
            if (!_dimension.hasUserDefinedDim()) continue;
            userDefinedNums.add(_dimension.getNumber());
        }
        userDefinedSize = userDefinedNums.size();
        for (int i = 1; i <= userDefinedSize; ++i) {
            fields.add("fcustomdim" + i);
        }
        return fields;
    }

    private Set<Long> queryRefMember(String field, Long modelId, Set<Long> busModelIds, Object[] memberIdsAry) {
        LinkedHashSet refMemberIds = Sets.newLinkedHashSet();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct e." + field + " from t_eb_adjdetail e where ", new Object[0]).appendIn("e." + field, memberIdsAry);
        sql.append(" and exists (select t.fid from t_eb_adjustbill t where t.fmodel = ?", new Object[]{modelId});
        if (CollectionUtils.isNotEmpty(busModelIds)) {
            sql.append(" and ", new Object[0]);
            sql.appendIn("fbizmodelid", busModelIds.toArray());
        }
        sql.append(" and t.fid = e.fid)", new Object[0]);
        sql.append(" and ", new Object[0]);
        sql.appendIn("e." + field, memberIdsAry);
        try (DataSet ds = DB.queryDataSet((String)"queryAdjustBillEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    refMemberIds.add(row.getLong(0));
                }
            }
        }
        return refMemberIds;
    }
}

