/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgControlUtils;

public class CheckControlUtils {
    public static CheckControlUtils get() {
        return new CheckControlUtils();
    }

    public boolean checkControlMapping(Long modelId, Set<Long> busModelIds, Object[] memberIdsAry) {
        if (IDUtils.isNull((Long)modelId) || busModelIds == null || busModelIds.isEmpty() || memberIdsAry == null || memberIdsAry.length == 0) {
            return false;
        }
        HashSet<Long> itemMappingIds = new HashSet<Long>();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_dimmembermapping where fmodel = ? and fdim = ? and ", new Object[]{modelId, SysDimensionEnum.Entity.getNumber()});
        sql.appendIn("fbussmodelid", busModelIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryControlMapping", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    itemMappingIds.add(row.getLong("fid"));
                }
            }
        }
        if (!itemMappingIds.isEmpty()) {
            sql = new SqlBuilder();
            sql.append("select top 1 fdimmemberid from t_eb_membermapping where ", new Object[0]).appendIn("fid", itemMappingIds.toArray());
            sql.append(" and ", new Object[0]).appendIn("fdimmemberid", memberIdsAry);
            ds = DB.queryDataSet((String)"queryControlMapping", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            var7_7 = null;
            try {
                if (ds != null && ds.hasNext()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var7_7 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return false;
    }

    public boolean checkControlRecord(Long modelId, Set<Long> busModelIds, Object[] memberIdsAry) {
        if (busModelIds == null || busModelIds.isEmpty()) {
            return false;
        }
        ArrayList tables = Lists.newArrayListWithExpectedSize((int)busModelIds.size());
        for (Long busModelId : busModelIds) {
            tables.add(BgControlUtils.getBgControlRecordTable((Long)modelId, (Long)busModelId));
        }
        for (String _table : tables) {
            if (!DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)_table)) continue;
            SqlBuilder sql = new SqlBuilder();
            sql.append("select top 1 forgunitid from " + _table + " where fmodelid = ? and ", new Object[]{modelId});
            sql.appendIn("forgunitid", memberIdsAry);
            DataSet ds = DB.queryDataSet((String)"queryControlOrg", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Throwable throwable = null;
            try {
                if (ds == null || !ds.hasNext()) continue;
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return false;
    }

    public Set<Long> getControlRecord(Long modelId, Long dimensionId, Set<Long> busModelIds, Object[] memberIdsAry, IModelCacheHelper modelCacheHelper) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || CollectionUtils.isEmpty((Object[])memberIdsAry)) {
            return Collections.emptySet();
        }
        if (!modelCacheHelper.getModelobj().isModelByEB() && CollectionUtils.isEmpty(busModelIds)) {
            return Collections.emptySet();
        }
        LinkedHashSet refMemberIds = Sets.newLinkedHashSet();
        refMemberIds.addAll(ControlRecord.get().queryControlRecord(modelId, dimensionId, busModelIds, memberIdsAry, modelCacheHelper));
        if (refMemberIds.isEmpty()) {
            refMemberIds.addAll(ControlMapping.get().queryMapping(modelId, dimensionId, busModelIds, memberIdsAry, modelCacheHelper));
        }
        return refMemberIds;
    }

    public static class ControlMapping {
        public static ControlMapping get() {
            return new ControlMapping();
        }

        public Set<Long> queryMapping(Long modelId, Long dimensionId, Set<Long> busModelIds, Object[] memberIdsAry, IModelCacheHelper modelCacheHelper) {
            if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || busModelIds == null || memberIdsAry == null || memberIdsAry.length == 0 || modelCacheHelper == null) {
                return Collections.emptySet();
            }
            HashSet<Long> itemMappingIds = new HashSet<Long>();
            Dimension dimension = modelCacheHelper.getDimension(dimensionId);
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid from t_eb_dimmembermapping where fmodel = ? and fdim = ?", new Object[]{modelId, dimension.getNumber()});
            if (!modelCacheHelper.getModelobj().isModelByEB()) {
                sql.append(" and ", new Object[0]).appendIn("fbussmodelid", busModelIds.toArray());
            }
            try (DataSet ds = DB.queryDataSet((String)"queryControlMapping", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        itemMappingIds.add(row.getLong("fid"));
                    }
                }
            }
            LinkedHashSet refMemberIds = Sets.newLinkedHashSet();
            if (!itemMappingIds.isEmpty()) {
                sql = new SqlBuilder();
                sql.append("select fdimmemberid from t_eb_membermapping where ", new Object[0]).appendIn("fid", itemMappingIds.toArray());
                sql.append(" and ", new Object[0]).appendIn("fdimmemberid", memberIdsAry);
                DataSet ds = DB.queryDataSet((String)"queryControlMapping", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
                Object object = null;
                try {
                    if (ds != null) {
                        for (Row row : ds) {
                            refMemberIds.add(row.getLong("fdimmemberid"));
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            return refMemberIds;
        }
    }

    public static class ControlRecord {
        public static ControlRecord get() {
            return new ControlRecord();
        }

        public Set<Long> queryControlRecord(Long modelId, Long dimensionId, Set<Long> busModelIds, Object[] memberIdsAry, IModelCacheHelper modelCacheHelper) {
            if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || busModelIds == null || memberIdsAry == null || memberIdsAry.length == 0 || modelCacheHelper == null) {
                return Collections.emptySet();
            }
            LinkedHashSet refMemberIds = Sets.newLinkedHashSet();
            ArrayList tables = Lists.newArrayListWithExpectedSize((int)busModelIds.size());
            ArrayList fields = Lists.newArrayListWithExpectedSize((int)32);
            if (modelCacheHelper.getModelobj().isModelByEB()) {
                tables.add("t_eb_bgcontrolrecord");
            } else {
                for (Long busModelId : busModelIds) {
                    tables.add(BgControlUtils.getBgControlRecordTable((Long)modelId, (Long)busModelId));
                }
            }
            Dimension dimension = modelCacheHelper.getDimension(dimensionId);
            switch (dimension.getNumber()) {
                case "Entity": {
                    fields.add("forgunitid");
                    break;
                }
                case "Account": {
                    fields.add("faccountid");
                    break;
                }
            }
            block10: for (String _table : tables) {
                if (!DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)_table) || !SqlBatchUtils.hasData((String)_table)) continue;
                this.checkFields(dimension, _table, fields);
                for (String _field : fields) {
                    refMemberIds.addAll(this.queryRefMember(_table, _field, modelId, memberIdsAry));
                    if (refMemberIds.isEmpty()) continue;
                    continue block10;
                }
            }
            return refMemberIds;
        }

        private void checkFields(Dimension dimension, String table, List<String> fields) {
            if (StringUtils.equals((String)"epm_userdefinedmembertree", (String)dimension.getMemberModel())) {
                String _column;
                fields.clear();
                int userDefinedSize = StringUtils.equals((String)"t_eb_bgcontrolrecord", (String)table) ? 10 : 20;
                for (int i = 1; i <= userDefinedSize && DB.existColumn((DBRoute)BgBaseConstant.epm, (String)table, (String)(_column = "fuserdefinedid" + i)); ++i) {
                    fields.add("fuserdefinedid" + i);
                }
            }
        }

        private Set<Long> queryRefMember(String table, String field, Long modelId, Object[] memberIdsAry) {
            LinkedHashSet refMemberIds = Sets.newLinkedHashSet();
            SqlBuilder sql = new SqlBuilder();
            sql.append("select distinct " + field + " from " + table + " where fmodelid = ? and ", new Object[]{modelId});
            sql.appendIn(field, memberIdsAry);
            try (DataSet ds = DB.queryDataSet((String)"queryControlRef", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                for (Row row : ds) {
                    refMemberIds.add(row.getLong(0));
                }
            }
            return refMemberIds;
        }
    }
}

