/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.importplugin;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.enums.ImportEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekDataUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.formplugin.importplugin.ImportContext;
import kd.epm.eb.formplugin.importplugin.ImportTemplateHeader;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.olap.service.view.context.MemberOperEnum;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import kd.epm.eb.olap.service.view.handler.MemberExcelImportHandler;
import kd.epm.eb.olap.service.view.valid.ValidResult;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class DimMemImportBasePlugin
extends MainSubAbstractFormPlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(DimMemImportBasePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.doImport();
        } else if ("btndownload".equals(key)) {
            this.downImportTemplate();
        }
    }

    protected void doImport() {
        LogStats stats = new LogStats("excel-import-log");
        stats.addInfo("begin-import.");
        try {
            this.$doImport(stats);
        }
        finally {
            stats.addInfo("end-import.");
            log.info(stats.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $doImport(@NotNull LogStats stats) {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        Dimension dimension = modelCache.getDimension(this.getDimensionNumber());
        SaveMemberContext saveCtx = new SaveMemberContext(modelCache, this.getDimensionNumber(), dimension.getMemberModel(), dimension.getMemberTable(), this.getViewId());
        saveCtx.setOperationType(this.isAddNew() ? MemberOperEnum.ADD : MemberOperEnum.ADD_AND_UPDATE);
        if (StringUtils.equals((String)"Account", (String)this.getDimensionNumber())) {
            if (NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
                DynamicObject datasetObj = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)this.getModelId());
                if (datasetObj != null) {
                    saveCtx.setDatasetId(Long.valueOf(datasetObj.getLong("id")));
                }
            } else {
                saveCtx.setDatasetId(this.getDatasetId());
            }
            if (!modelCache.getModelobj().isModelByEB() && IDUtils.isNull((Long)saveCtx.getDatasetId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMemberImport_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        ArrayList workbooks = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList<ValidResult<String>> workBookValid = new ArrayList<ValidResult<String>>();
        ValidResult valid = new ValidResult();
        MemberExcelImportHandler handle = new MemberExcelImportHandler(saveCtx);
        List<ImportEntity> importHeads = this.beforeDo(new ImportContext(this.getPageCache(), modelCache, this.getDimensionNumber(), this.getDimensionName(), this.getDimMemberKey()), workbooks);
        try {
            handle.execute((List)workbooks, workBookValid, stats);
            this.afterDo(saveCtx, workbooks, importHeads, (ValidResult<String>)valid, workBookValid);
            workbooks.clear();
            workBookValid.clear();
        }
        catch (Throwable ex) {
            try {
                CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"importMember", (Throwable)ex);
                valid = StringUtils.isNotEmpty((String)ex.getMessage()) ? new ValidResult(ex.getMessage()) : new ValidResult(CommonServiceHelper.getStackTraceStr((Throwable)ex));
                this.afterDo(saveCtx, workbooks, importHeads, (ValidResult<String>)valid, workBookValid);
                workbooks.clear();
                workBookValid.clear();
            }
            catch (Throwable throwable) {
                this.afterDo(saveCtx, workbooks, importHeads, (ValidResult<String>)valid, workBookValid);
                workbooks.clear();
                workBookValid.clear();
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u6279\u91cf\u5bfc\u5165", "DimMemImportBasePlugin_40", "epm-eb-formplugin");
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u5458\u7f16\u7801\uff1a%1$s\u3002", "DimMemImportBasePlugin_41", "epm-eb-formplugin");
                this.writeLog(null, "import", opName, opDescription, new String[]{StringUtils.join((Collection)handle.getSaveMemberNumbers(), (char)',')});
                throw throwable;
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u6279\u91cf\u5bfc\u5165", "DimMemImportBasePlugin_40", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u5458\u7f16\u7801\uff1a%1$s\u3002", "DimMemImportBasePlugin_41", "epm-eb-formplugin");
            this.writeLog(null, "import", opName, opDescription, new String[]{StringUtils.join((Collection)handle.getSaveMemberNumbers(), (char)',')});
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u6279\u91cf\u5bfc\u5165", "DimMemImportBasePlugin_40", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u5458\u7f16\u7801\uff1a%1$s\u3002", "DimMemImportBasePlugin_41", "epm-eb-formplugin");
        this.writeLog(null, "import", opName, opDescription, new String[]{StringUtils.join((Collection)handle.getSaveMemberNumbers(), (char)',')});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ImportEntity> beforeDo(ImportContext context, List<Workbook> workbooks) {
        List inputStreams = UploadUtil.getFileInputStreams((IPageCache)this.getPageCache(), (String)"file_url");
        try {
            BeforeDoCheck check = new BeforeDoCheck(context);
            check.execute(inputStreams);
            workbooks.addAll(check.getWorkbooks());
            List<ImportEntity> list = check.getImportHeads();
            return list;
        }
        finally {
            POIUtils.safeClose((Iterable)inputStreams);
        }
    }

    protected void afterDo(@NotNull SaveMemberContext context, List<Workbook> workbooks, List<ImportEntity> importHeads, @NotNull ValidResult<String> valid, @NotNull List<ValidResult<String>> validResults) {
        boolean result = valid.isOk();
        for (ValidResult<String> _valid : validResults) {
            result = result && _valid.isOk();
        }
        if (result) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DimMemImportBasePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().close();
            Long modelId = context.getModel().getId();
            Long dimensionId = context.getDimensionId();
            Long viewId = context.getViewId();
            CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimensionId);
            MemberPropCacheService.updateVersion((Long)modelId, (Long)dimensionId);
            DimMembPermVerHelper.updateVer4MembChanged((Long)viewId, (Long)modelId, (Long)dimensionId, (String)"afterBatViewMembChanged");
            CubeUtils.clearCentralizedCache((Long)modelId, (Long)dimensionId);
            this.syncOlapData();
        } else {
            this.downErrorFile(context, workbooks, importHeads, valid, validResults);
        }
    }

    private void downImportTemplate() {
        ImportContext context = new ImportContext(this.getPageCache(), this.getIModelCacheHelper(), this.getDimensionNumber(), this.getDimensionName(), this.getDimMemberKey());
        ImportEntity importEntity = ImportTemplateHeader.get((ImportContext)context).getTemplateData(true);
        FileImportUtils instance = FileImportUtils.getInstance((ImportEntity)importEntity);
        String url = instance.saveFileAsUrl(instance.createImportTemplate(), importEntity.getTemplateName());
        if (StringUtils.isNotEmpty((String)url)) {
            POIUtils.downloadFile((IFormView)this.getView(), (String)url);
        }
    }

    protected void downErrorFile(@NotNull SaveMemberContext context, List<Workbook> workbooks, List<ImportEntity> importHeads, ValidResult<String> valid, @NotNull List<ValidResult<String>> validResults) {
        int index = 0;
        POIUtils utils = POIUtils.get();
        try {
            XSSFWorkbook errorBook = new XSSFWorkbook();
            CellStyle errorStyle = POIUtils.getErrorStyle((Workbook)errorBook);
            POIUtils.POIConfig config = new POIUtils.POIConfig();
            config.getSheetConfig((int)0).COPY_ColBeginIndex = 1;
            for (Workbook workbook : workbooks) {
                Cell errorCell;
                Sheet sheet = workbook.getSheetAt(0);
                Sheet errorSheet = errorBook.createSheet(sheet.getSheetName());
                ValidResult<String> _valid = validResults.get(index++);
                utils.copySheet(sheet, errorSheet, config.getSheetConfig(0));
                if (!_valid.isOk()) {
                    for (Map.Entry entry : _valid.getValidResultMap().entrySet()) {
                        errorCell = POIUtils.getCell((Sheet)errorSheet, (int)Integer.parseInt((String)entry.getKey()), (int)0);
                        if (errorCell == null) continue;
                        errorCell.setCellStyle(errorStyle);
                        errorCell.setCellValue((String)entry.getValue());
                    }
                }
                if (!StringUtils.isNotEmpty((String)valid.getErrMsg()) || (errorCell = POIUtils.getCell((Sheet)errorSheet, (int)2, (int)0)) == null) continue;
                errorCell.setCellStyle(errorStyle);
                errorCell.setCellValue(valid.getErrMsg());
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"DimMemImportBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            POIUtils.downloadFile((IFormView)this.getView(), (Workbook)errorBook);
        }
        catch (Throwable ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private void checkOlapConnection() {
        if (!OlapServiceHelper.checkIsOnlineByCube((Long)this.getModelId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u94fe\u63a5\u4e0d\u53ef\u7528\u3002", (String)"DimMemImportBasePlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void syncOlapData() {
        ShrekDataUtils.syncData((long)this.getModelId(), (String)this.getDimensionNumber(), (Long)this.getDatasetId(), (Long)this.getViewId());
    }

    protected List<Dataset> getDataSets(DynamicObject modelObj, String dimensionNumber) {
        if ((ModelServiceHelper.isBGMDModel((Long)modelObj.getLong("id")) || NewEbAppUtil.isNewEbModel((Long)modelObj.getLong("id"))) && ShrekOlapServiceHelper.needDMLOlap((DynamicObject)modelObj) && SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            DynamicObject datasetObj;
            Long datasetId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("dataset"));
            if (NewEbAppUtil.isNewEbModel((Long)modelObj.getLong("id"))) {
                datasetObj = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)modelObj.getLong("id"));
                datasetId = datasetObj.getLong("id");
            }
            datasetObj = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"eb_dataset");
            Dataset dataset = new Dataset(Long.valueOf(datasetObj.getLong("id")), datasetObj.getString("number"));
            return Collections.singletonList(dataset);
        }
        return DatasetServiceHelper.getDatasets((DynamicObject)modelObj, (String)dimensionNumber);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (!urls.isEmpty()) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    protected boolean isAddNew() {
        return ImportEnum.IMPORTTYPE_NEW.getIndex().equals(this.getModel().getValue("radiogroupfield"));
    }

    protected boolean isAddAndUpdate() {
        return ImportEnum.IMPORTTYPE_ADDANDUPADTA.getIndex().equals(this.getModel().getValue("radiogroupfield"));
    }

    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }

    protected String getDimMemberKey() {
        return (String)this.getView().getFormShowParameter().getCustomParam("memberKey");
    }

    protected Long getDimensionId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("dimensionId");
    }

    protected String getDimensionNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("dimensionNumber");
    }

    protected String getDimensionName() {
        return (String)this.getView().getFormShowParameter().getCustomParam("dimensionName");
    }

    protected Long getViewId() {
        return IDUtils.toLong((Object)PluginUtils.getCustomParams((IFormView)this.getView(), (String)"viewId"));
    }

    protected Long getDatasetId() {
        return IDUtils.toLong((Object)PluginUtils.getCustomParams((IFormView)this.getView(), (String)"dataset"));
    }

    static class BeforeDoCheck {
        private final ImportContext context;
        private List<Workbook> workbooks = null;
        private List<ImportEntity> importHeads = new ArrayList<ImportEntity>();

        protected ImportContext getContext() {
            return this.context;
        }

        protected void setWorkbooks(List<Workbook> workbooks) {
            this.workbooks = workbooks;
        }

        public List<Workbook> getWorkbooks() {
            return this.workbooks;
        }

        public List<ImportEntity> getImportHeads() {
            return this.importHeads;
        }

        public BeforeDoCheck(ImportContext context) {
            this.context = context;
        }

        public void execute(List<InputStream> inputStreams) {
            this.checkInputStream(inputStreams);
            this.setWorkbooks(this.getWorkbooks(inputStreams));
            this.checkWorkBookStyle(this.getWorkbooks());
        }

        protected void checkInputStream(List<InputStream> inputStreams) {
            if (inputStreams == null || inputStreams.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\u3002", (String)"DimMemImportBasePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }

        protected List<Workbook> getWorkbooks(List<InputStream> inputStreams) {
            if (inputStreams == null || inputStreams.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Workbook> workbooks = new ArrayList<Workbook>(inputStreams.size());
            try {
                for (InputStream _inputStream : inputStreams) {
                    workbooks.add(WorkbookFactory.create((InputStream)_inputStream));
                }
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return workbooks;
        }

        protected void checkWorkBookStyle(List<Workbook> workbooks) {
            try {
                for (Workbook _workbook : workbooks) {
                    Sheet _sheet = _workbook.getSheetAt(0);
                    Row headRow = _sheet.getRow(this.getDefaultRowIndex());
                    if (headRow == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u7f3a\u5c11\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    ImportEntity importHead = ImportTemplateHeader.get((ImportContext)this.getContext()).getTemplateData(true);
                    this.getImportHeads().add(importHead);
                    Map sheetHeaderMap = importHead.getSheetHeaderMap();
                    for (Map.Entry entry : sheetHeaderMap.entrySet()) {
                        String _fileHead;
                        int colNum = Integer.parseInt((String)entry.getKey());
                        String _headStr = ((Header)entry.getValue()).getHeader();
                        if (_headStr != null) {
                            _headStr = _headStr.trim();
                        }
                        if ((_fileHead = headRow.getCell(colNum).getStringCellValue().trim()).equals(_headStr)) continue;
                        log.info("head1=" + _fileHead + ", head2=" + _headStr);
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
            }
            catch (KDBizException ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable ex) {
                log.error("checkWorkBookStyle-error", (Object)CommonServiceHelper.getStackTraceStr((Throwable)ex));
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }

        protected int getDefaultRowIndex() {
            return 2;
        }
    }
}

