/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.permission.DimPermBatchRequest;
import kd.epm.eb.common.permission.DimPermBatchResponse;
import kd.epm.eb.common.permission.DimPermPojo;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jetbrains.annotations.NotNull;

public class DimPermImportUtil {
    private final FileImportUtils fileImportUtils = FileImportUtils.getInstance();

    public static DimPermImportUtil getInstance() {
        return new DimPermImportUtil();
    }

    public void buildDimensionColumn(String dimensionStr, Sheet sheetAt) {
        String[] split = dimensionStr.split("#");
        Row columnTitleRow = this.fileImportUtils.getRow(sheetAt, 4);
        int startIndex = 3;
        for (int i = 0; i < split.length; ++i) {
            sheetAt.setColumnWidth(startIndex, 3500);
            Cell dimensionNumberCell = this.fileImportUtils.getCell(columnTitleRow, startIndex++);
            sheetAt.setColumnWidth(startIndex, 3500);
            Cell dimensionNameCell = this.fileImportUtils.getCell(columnTitleRow, startIndex++);
            sheetAt.setColumnWidth(startIndex, 6500);
            Cell membOrPropNumberCell = this.fileImportUtils.getCell(columnTitleRow, startIndex++);
            sheetAt.setColumnWidth(startIndex, 6500);
            Cell membOrPropNameCell = this.fileImportUtils.getCell(columnTitleRow, startIndex++);
            dimensionNumberCell.setCellValue(this.getLocalName("dimensionNumber"));
            dimensionNameCell.setCellValue(this.getLocalName("dimensionName"));
            membOrPropNumberCell.setCellValue(this.getLocalName("membOrPropNumber"));
            membOrPropNameCell.setCellValue(this.getLocalName("membOrPropName"));
        }
        sheetAt.setColumnWidth(startIndex, 2500);
        Cell includeCell = this.fileImportUtils.getCell(columnTitleRow, startIndex++);
        sheetAt.setColumnWidth(startIndex, 2500);
        Cell readCell = this.fileImportUtils.getCell(columnTitleRow, startIndex++);
        sheetAt.setColumnWidth(startIndex, 2500);
        Cell writeCell = this.fileImportUtils.getCell(columnTitleRow, startIndex++);
        sheetAt.setColumnWidth(startIndex, 2500);
        Cell giveCell = this.fileImportUtils.getCell(columnTitleRow, startIndex);
        includeCell.setCellValue(this.getLocalName("include"));
        readCell.setCellValue(DimMembPermType.READ.getName());
        writeCell.setCellValue(DimMembPermType.WRITE.getName());
        giveCell.setCellValue(DimMembPermType.GIVE.getName());
    }

    public String getLocalName(String key) {
        String localName = "";
        switch (key) {
            case "model": {
                localName = ResManager.loadKDString((String)"\u4f53\u7cfb*", (String)"DimMembPermImportPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "bizModel": {
                localName = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b*", (String)"DimMembPermImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "dimension": {
                localName = ResManager.loadKDString((String)"\u6388\u6743\u7ef4\u5ea6*", (String)"DimMembPermImportPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "user": {
                localName = ResManager.loadKDString((String)"\u7528\u6237", (String)"DimMembPermImportPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "userGroup": {
                localName = ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"DimMembPermImportPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "userType": {
                localName = ResManager.loadKDString((String)"\u7528\u6237\u7c7b\u578b*", (String)"DimMembPermImportPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "userNumber": {
                localName = ResManager.loadKDString((String)"\u7f16\u7801*", (String)"DimMembPermImportPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "dimensionNumber": {
                localName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801*", (String)"DimMembPermImportPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "memberNumber": {
                localName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801*", (String)"DimMembPermImportPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "include": {
                localName = ResManager.loadKDString((String)"\u5305\u542b\u4e0b\u7ea7", (String)"DimMembPermImportPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "dimensionName": {
                localName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u540d\u79f0", (String)"DimMembPermImportPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "membOrPropNumber": {
                localName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801/\u5c5e\u6027\u7f16\u7801*", (String)"DimMembPermImportPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "membOrPropName": {
                localName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458/\u5c5e\u6027\u540d\u79f0", (String)"DimMembPermImportPlugin_57", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "viewNumber": {
                localName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u89c6\u56fe\u7f16\u7801*", (String)"DimPermImportUtil_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "viewName": {
                localName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u89c6\u56fe\u540d\u79f0", (String)"DimPermImportUtil_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return localName;
    }

    public void transSheetName(Workbook sheets, String formType, String dimensionStr, Long modelId) {
        Sheet sheetAt = sheets.getSheetAt(0);
        Row modelRow = this.fileImportUtils.getRow(sheetAt, 0);
        Cell modelCell = this.fileImportUtils.getCell(modelRow, 0);
        modelCell.setCellValue(this.getLocalName("model"));
        Cell yesCell = this.fileImportUtils.getCell(modelRow, 6);
        yesCell.setCellValue(String.format("Y:%s", ResManager.loadKDString((String)"\u6709\u6743", (String)"DimMembPermImportPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        if ("member".equals(formType)) {
            Cell noCell = this.fileImportUtils.getCell(modelRow, 7);
            noCell.setCellValue(String.format("N:%s", ResManager.loadKDString((String)"\u65e0\u6743", (String)"DimMembPermImportPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        }
        Cell blankCell = this.fileImportUtils.getCell(modelRow, 8);
        blankCell.setCellValue(ResManager.loadKDString((String)"\u5176\u4ed6:\u4e0d\u5904\u7406", (String)"DimMembPermImportPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Row sheetRow = this.fileImportUtils.getRow(sheetAt, 4);
        Cell userTypeCell = this.fileImportUtils.getCell(sheetRow, 0);
        userTypeCell.setCellValue(this.getLocalName("userType"));
        Cell userNumberCell = this.fileImportUtils.getCell(sheetRow, 1);
        userNumberCell.setCellValue(this.getLocalName("userNumber"));
        Cell userNameCell = this.fileImportUtils.getCell(sheetRow, 2);
        userNameCell.setCellValue(ResManager.loadKDString((String)"\u540d\u79f0", (String)"DimMembPermImportPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if ("member".equals(formType)) {
            int dimPermGroupSize = 1;
            if (StringUtils.isNotEmpty((CharSequence)dimensionStr) && dimensionStr.contains("#")) {
                String[] split = dimensionStr.split("#");
                dimPermGroupSize = split.length;
                for (int i = 1; i <= split.length; ++i) {
                    Cell dimensionNumberCell = this.fileImportUtils.getCell(sheetRow, 3 + (i - 1) * 4);
                    dimensionNumberCell.setCellValue(this.getLocalName("dimensionNumber"));
                    Cell dimensionNameCell = this.fileImportUtils.getCell(sheetRow, 4 + (i - 1) * 4);
                    dimensionNameCell.setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u540d\u79f0", (String)"DimMembPermImportPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    Cell memberNumberCell = this.fileImportUtils.getCell(sheetRow, 5 + (i - 1) * 4);
                    memberNumberCell.setCellValue(this.getLocalName("membOrPropNumber"));
                    this.fileImportUtils.setCellTips(memberNumberCell, ResManager.loadKDString((String)"\u5982\u679c\u662f\u5c5e\u6027\u6210\u5458\uff0c\u7f16\u7801\u683c\u5f0f\u4e3a\u5c5e\u6027\u7f16\u7801!\u5c5e\u6027\u503c\u7f16\u7801", (String)"DimMembPermImportPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    Cell memberNameCell = this.fileImportUtils.getCell(sheetRow, 6 + (i - 1) * 4);
                    memberNameCell.setCellValue(this.getLocalName("membOrPropName"));
                }
            } else {
                Cell memberNumberCell = this.fileImportUtils.getCell(sheetRow, 5);
                memberNumberCell.setCellValue(this.getLocalName("membOrPropNumber"));
                this.fileImportUtils.setCellTips(memberNumberCell, ResManager.loadKDString((String)"\u5982\u679c\u662f\u5c5e\u6027\u6210\u5458\uff0c\u7f16\u7801\u683c\u5f0f\u4e3a\u5c5e\u6027\u7f16\u7801!\u5c5e\u6027\u503c\u7f16\u7801", (String)"DimMembPermImportPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Row bizModelRow = this.fileImportUtils.getRow(sheetAt, 1);
            Cell bizModelCell = this.fileImportUtils.getCell(bizModelRow, 0);
            bizModelCell.setCellValue(this.getLocalName("bizModel"));
            Row dimensionRow = this.fileImportUtils.getRow(sheetAt, 2);
            Cell dimensionCell = this.fileImportUtils.getCell(dimensionRow, 0);
            dimensionCell.setCellValue(this.getLocalName("dimension"));
            this.fileImportUtils.setCellTips(dimensionCell, ResManager.loadKDString((String)"\u591a\u4e2a\u7ef4\u5ea6\u4e4b\u95f4\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00\u3002\u7ef4\u5ea6\u7ec4\u5408\u53ea\u80fd\u5355\u4e2a\u5bfc\u5165\uff0c\u7ef4\u5ea6\u7ec4\u5408\u4e2d\u591a\u4e2a\u7ef4\u5ea6\u7528#\u8fde\u63a5\u3002", (String)"DimMembPermImportPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Cell includeCell = this.fileImportUtils.getCell(sheetRow, 7 + (dimPermGroupSize - 1) * 4);
            includeCell.setCellValue(this.getLocalName("include"));
            Cell readCell = this.fileImportUtils.getCell(sheetRow, 8 + (dimPermGroupSize - 1) * 4);
            readCell.setCellValue(DimMembPermType.READ.getName());
            Cell writeCell = this.fileImportUtils.getCell(sheetRow, 9 + (dimPermGroupSize - 1) * 4);
            writeCell.setCellValue(DimMembPermType.WRITE.getName());
            Cell giveCell = this.fileImportUtils.getCell(sheetRow, 10 + (dimPermGroupSize - 1) * 4);
            giveCell.setCellValue(DimMembPermType.GIVE.getName());
        } else if ("manage".equals(formType)) {
            Cell dimensionNumberCell = this.fileImportUtils.getCell(sheetRow, 3);
            dimensionNumberCell.setCellValue(this.getLocalName("dimensionNumber"));
            Cell dimensionNameCell = this.fileImportUtils.getCell(sheetRow, 4);
            dimensionNameCell.setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u540d\u79f0", (String)"DimMembPermImportPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Cell memberNumberCell = this.fileImportUtils.getCell(sheetRow, 5);
            memberNumberCell.setCellValue(this.getLocalName("membOrPropNumber"));
            this.fileImportUtils.setCellTips(memberNumberCell, ResManager.loadKDString((String)"\u5982\u679c\u662f\u5c5e\u6027\u6210\u5458\uff0c\u7f16\u7801\u683c\u5f0f\u4e3a\u5c5e\u6027\u7f16\u7801!\u5c5e\u6027\u503c\u7f16\u7801", (String)"DimMembPermImportPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Cell memberNameCell = this.fileImportUtils.getCell(sheetRow, 6);
            memberNameCell.setCellValue(this.getLocalName("membOrPropName"));
            if (AdjustUtil.isBGMModel((long)modelId) || AdjustUtil.isBGModel((long)modelId)) {
                Cell viewNumberCell = this.fileImportUtils.getCell(sheetRow, 7);
                sheetAt.setColumnWidth(7, 3500);
                viewNumberCell.setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u89c6\u56fe\u7f16\u7801*", (String)"DimMembPermImportPlugin_79", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                Cell viewNameCell = this.fileImportUtils.getCell(sheetRow, 8);
                sheetAt.setColumnWidth(8, 3500);
                viewNameCell.setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u89c6\u56fe\u540d\u79f0", (String)"DimMembPermImportPlugin_78", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                Cell giveCell = this.fileImportUtils.getCell(sheetRow, 9);
                giveCell.setCellValue(DimMembPermType.MANAGER.getName());
            } else {
                Cell giveCell = this.fileImportUtils.getCell(sheetRow, 7);
                giveCell.setCellValue(DimMembPermType.MANAGER.getName());
            }
        }
    }

    public String getMemberStr(DynamicObject dynamicObject, String dimensionStr) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dimensionStr.split("#").length; ++i) {
            long membOrPropId = dynamicObject.getLong("memberid" + i);
            boolean isMember = dynamicObject.getBoolean("ismember" + i);
            Long viewId = dynamicObject.getLong("viewid" + i);
            stringBuilder.append(membOrPropId).append("!").append(isMember ? RangeF7PropertyCataEnum.Member.getIndex() : RangeF7PropertyCataEnum.Property.getIndex()).append("!").append(viewId).append("_");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public Map<String, Boolean> getPermMap(DynamicObject dynamicObject, String dimensionStr, String formType) {
        HashMap<String, Boolean> permMap;
        if ("manage".equals(formType)) {
            permMap = new HashMap<String, Boolean>(1);
            permMap.put("manage", Boolean.parseBoolean(dynamicObject.getString(DimMembPermType.MANAGER.getBoxKey())));
        } else {
            permMap = new HashMap(4);
            permMap.put("extends", (Boolean)dynamicObject.get(DimMembPermType.DATAPERMEXTENDS.getBoxKey()));
            permMap.put("read", (Boolean)dynamicObject.get(DimMembPermType.READ.getBoxKey()));
            permMap.put("write", (Boolean)dynamicObject.get(DimMembPermType.WRITE.getBoxKey()));
            permMap.put("give", (Boolean)dynamicObject.get(DimMembPermType.GIVE.getBoxKey()));
        }
        return permMap;
    }

    public String translateToString(Boolean perm) {
        if (Boolean.TRUE.equals(perm)) {
            return "Y";
        }
        if (Boolean.FALSE.equals(perm)) {
            return "N";
        }
        return null;
    }

    public List<Integer> findAllIndex(String source, String target) {
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        String[] split = source.split("!");
        for (int i = 0; i < split.length; ++i) {
            if (!target.equals(split[i])) continue;
            list.add(i);
        }
        return list;
    }

    public boolean validLevel(String currentLevel, String targetLevel, String type, List<Integer> source, boolean containProp) {
        boolean isRef = "all".equals(type);
        if (isRef && currentLevel.equals(targetLevel)) {
            return false;
        }
        String[] currentSplit = currentLevel.split("!");
        String[] targetSplit = targetLevel.split("!");
        boolean isChild = "child".equals(type);
        boolean child = false;
        boolean parent = false;
        if (containProp) {
            List<Integer> target = this.findAllIndex(targetLevel, "0");
            if (source.size() != target.size()) {
                return false;
            }
            target.removeAll(source);
            if (CollectionUtils.isNotEmpty(target)) {
                return false;
            }
        }
        for (int i = 0; i < currentSplit.length; ++i) {
            int targetInt;
            int sourceInt = Integer.parseInt(currentSplit[i]);
            if (sourceInt > (targetInt = Integer.parseInt(targetSplit[i]))) {
                parent = true;
                break;
            }
            if (targetInt <= sourceInt) continue;
            child = true;
            break;
        }
        if ((isRef || isChild) && child) {
            return true;
        }
        return (isRef || !isChild) && parent;
    }

    public Set<String> validRepeatPerm(String rowKey, Map<String, Boolean> permMap, Map<String, List<Member>> currentMemberMap, Map<String, Map<String, Set<String>>> allFileRowDataMap, Map<String, Map<String, Map<String, Set<String>>>> dataPermMap, Map<String, Map<String, Set<String>>> dataMemberOrPropMap, Map<String, Map<String, Map<String, Set<String>>>> allFilePermLevelMap, Set<StringBuilder> groupLevelSet, boolean containProp) {
        Object value;
        Map<String, Map<String, Set<String>>> validDataPermMap;
        Map<String, Map<String, Set<String>>> validFilePermMap;
        HashSet<String> repeatKeys = new HashSet<String>(16);
        Boolean read = permMap.get("read");
        Boolean write = permMap.get("write");
        Boolean give = permMap.get("give");
        Boolean include = permMap.get("include");
        String validChildKey = read + "_" + write + "_" + give;
        String parentOrCrossPermKey = validChildKey + "_true";
        Map<String, Set<String>> currentMap = allFileRowDataMap.get(rowKey);
        ArrayList<Integer> source = new ArrayList(10);
        if (containProp) {
            StringBuilder next = groupLevelSet.iterator().next();
            source = this.findAllIndex(next.substring(0, next.length() - 1), "0");
        }
        if (containProp) {
            validFilePermMap = allFilePermLevelMap.get("prop");
            validDataPermMap = dataPermMap.get("prop");
        } else {
            validFilePermMap = allFilePermLevelMap.get("member");
            validDataPermMap = dataPermMap.get("member");
        }
        if (BooleanUtils.isTrue((Boolean)include)) {
            boolean needValidChild = false;
            for (Map.Entry<String, List<Member>> entry : currentMemberMap.entrySet()) {
                value = entry.getValue();
                Optional<Member> optional = value.stream().filter(member -> !member.isLeaf()).findFirst();
                if (!optional.isPresent()) continue;
                needValidChild = true;
                break;
            }
            if (needValidChild) {
                HashSet fileRowKeySet = new HashSet(16);
                HashSet<String> hashSet = new HashSet<String>(16);
                for (Map.Entry entry : validFilePermMap.entrySet()) {
                    String key;
                    Iterator keySet;
                    Map value2 = (Map)entry.getValue();
                    if (((String)entry.getKey()).startsWith(validChildKey)) {
                        for (Map.Entry stringSetEntry : value2.entrySet()) {
                            keySet = (Set)stringSetEntry.getValue();
                            key = (String)stringSetEntry.getKey();
                            for (StringBuilder stringBuilder : groupLevelSet) {
                                if (!this.validLevel(stringBuilder.substring(0, stringBuilder.length() - 1), key, "child", source, containProp)) continue;
                                fileRowKeySet.addAll(keySet);
                            }
                        }
                    }
                    if (!((String)entry.getKey()).startsWith(parentOrCrossPermKey)) continue;
                    for (Map.Entry stringSetEntry : value2.entrySet()) {
                        keySet = (Set)stringSetEntry.getValue();
                        key = (String)stringSetEntry.getKey();
                        for (StringBuilder stringBuilder : groupLevelSet) {
                            if (!this.validLevel(stringBuilder.substring(0, stringBuilder.length() - 1), key, "all", source, containProp)) continue;
                            hashSet.addAll((Collection<String>)((Object)keySet));
                        }
                    }
                }
                fileRowKeySet.remove(rowKey);
                this.findAllRefByType(currentMap, "child", fileRowKeySet, allFileRowDataMap, repeatKeys);
                hashSet.remove(rowKey);
                this.findAllRefByType(currentMap, "cross", hashSet, allFileRowDataMap, repeatKeys);
                HashSet<String> dataRowKeySet = new HashSet<String>(16);
                HashSet<String> hashSet2 = new HashSet<String>(16);
                if (validDataPermMap != null) {
                    for (Map.Entry entry : validDataPermMap.entrySet()) {
                        String key;
                        Set keySet;
                        Map value3 = (Map)entry.getValue();
                        if (((String)entry.getKey()).startsWith(validChildKey)) {
                            for (Map.Entry stringSetEntry : value3.entrySet()) {
                                keySet = (Set)stringSetEntry.getValue();
                                key = (String)stringSetEntry.getKey();
                                for (StringBuilder stringBuilder : groupLevelSet) {
                                    if (!this.validLevel(stringBuilder.substring(0, stringBuilder.length() - 1), key, "child", source, containProp)) continue;
                                    dataRowKeySet.addAll(keySet);
                                }
                            }
                        }
                        if (!((String)entry.getKey()).startsWith(parentOrCrossPermKey)) continue;
                        for (Map.Entry stringSetEntry : value3.entrySet()) {
                            keySet = (Set)stringSetEntry.getValue();
                            key = (String)stringSetEntry.getKey();
                            for (StringBuilder stringBuilder : groupLevelSet) {
                                if (!this.validLevel(stringBuilder.substring(0, stringBuilder.length() - 1), key, "all", source, containProp)) continue;
                                hashSet2.addAll(keySet);
                            }
                        }
                    }
                }
                dataRowKeySet.removeAll(allFileRowDataMap.keySet());
                this.findAllRefByType(currentMap, "child", dataRowKeySet, dataMemberOrPropMap, repeatKeys);
                hashSet2.removeAll(allFileRowDataMap.keySet());
                this.findAllRefByType(currentMap, "cross", hashSet2, dataMemberOrPropMap, repeatKeys);
            }
        }
        HashSet<String> fileRowKeySet = new HashSet<String>(16);
        for (Map.Entry<String, Map<String, Set<String>>> entry : validFilePermMap.entrySet()) {
            if (!entry.getKey().startsWith(parentOrCrossPermKey)) continue;
            value = entry.getValue();
            for (Map.Entry<String, Set<String>> stringSetEntry : value.entrySet()) {
                Set<String> set = stringSetEntry.getValue();
                String key = stringSetEntry.getKey();
                for (StringBuilder stringBuilder : groupLevelSet) {
                    if (!this.validLevel(stringBuilder.substring(0, stringBuilder.length() - 1), key, "parent", source, containProp)) continue;
                    fileRowKeySet.addAll(set);
                }
            }
        }
        fileRowKeySet.remove(rowKey);
        this.findAllRefByType(currentMap, "parent", fileRowKeySet, allFileRowDataMap, repeatKeys);
        HashSet<String> dataRowKeySet = new HashSet<String>(16);
        if (validDataPermMap != null) {
            for (Map.Entry<String, Map<String, Set<String>>> entry : validDataPermMap.entrySet()) {
                if (!entry.getKey().equals(parentOrCrossPermKey)) continue;
                Map<String, Set<String>> map = entry.getValue();
                for (Map.Entry<String, Set<String>> entry2 : map.entrySet()) {
                    for (StringBuilder stringBuilder : groupLevelSet) {
                        if (!this.validLevel(stringBuilder.substring(0, stringBuilder.length() - 1), entry2.getKey(), "parent", source, containProp)) continue;
                        dataRowKeySet.addAll((Collection<String>)entry2.getValue());
                    }
                }
            }
        }
        dataRowKeySet.removeAll(allFileRowDataMap.keySet());
        this.findAllRefByType(currentMap, "parent", dataRowKeySet, dataMemberOrPropMap, repeatKeys);
        return repeatKeys;
    }

    public void findAllRefByType(Map<String, Set<String>> currentMap, String type, Set<String> rowKeySet, Map<String, Map<String, Set<String>>> dataMemberOrPropMap, Set<String> repeatKeys) {
        for (String key : rowKeySet) {
            Map<String, Set<String>> map = dataMemberOrPropMap.get(key);
            if (map == null || !this.validMemberOrPropRef(currentMap, map, type)) continue;
            repeatKeys.add(key);
        }
    }

    public boolean validMemberOrPropRef(Map<String, Set<String>> currentMap, Map<String, Set<String>> map, String type) {
        Boolean isChild = null;
        Boolean isParent = null;
        boolean isAllParent = true;
        boolean isAllChild = true;
        block0: for (Map.Entry<String, Set<String>> entry : currentMap.entrySet()) {
            String key = entry.getKey();
            Set<String> currentValues = entry.getValue();
            Set<String> values = map.get(key);
            boolean hasRelation = true;
            for (String currentValue : currentValues) {
                for (String value : values) {
                    if (currentValue.equals(value)) continue block0;
                    if (!currentValue.startsWith(value + "!") && !value.startsWith(currentValue + "!")) {
                        hasRelation = false;
                        continue;
                    }
                    if (currentValue.startsWith(value + "!")) {
                        isParent = true;
                        isAllChild = false;
                        continue block0;
                    }
                    if (!value.startsWith(currentValue + "!")) continue;
                    isChild = true;
                    isAllParent = false;
                    continue block0;
                }
            }
            if (hasRelation) continue;
            return false;
        }
        if ("parent".equals(type) && BooleanUtils.isTrue((Boolean)isAllParent)) {
            return true;
        }
        if ("child".equals(type) && BooleanUtils.isTrue((Boolean)isAllChild)) {
            return true;
        }
        return "cross".equals(type) && BooleanUtils.isTrue(isChild) && BooleanUtils.isTrue(isParent);
    }

    public Map<String, Set<String>> getCurrentRefRowMap(Map<String, Map<String, List<Member>>> allFileDataMemberMap, Map<String, Set<String>> fileLevelKeyMap, Map<String, List<Member>> currentMemberMap, Map<String, Map<String, Map<String, List<Member>>>> dataLevelKeyMap, String substring, Set<StringBuilder> groupLevelSet, String[] dimensionSplit) {
        String key;
        HashMap<String, Set<String>> refMap = new HashMap<String, Set<String>>(16);
        ArrayList<Integer> source = new ArrayList<Integer>(10);
        HashSet fileRowKeys = new HashSet(256);
        for (Map.Entry<String, Set<String>> entry : fileLevelKeyMap.entrySet()) {
            key = entry.getKey();
            for (StringBuilder stringBuilder : groupLevelSet) {
                if (!this.validLevel(stringBuilder.substring(0, stringBuilder.length() - 1), key, "all", source, false)) continue;
                fileRowKeys.addAll(entry.getValue());
            }
        }
        fileRowKeys.remove(substring);
        for (String string : fileRowKeys) {
            Map<String, List<Member>> value = allFileDataMemberMap.get(string);
            Boolean isChild = null;
            Boolean isParent = null;
            block3: for (Map.Entry<String, List<Member>> memberEntry : value.entrySet()) {
                String dimension = memberEntry.getKey();
                List<Member> rowMembers = memberEntry.getValue();
                List<Member> members = currentMemberMap.get(dimension);
                boolean hasRelation = true;
                for (Member member : members) {
                    for (Member rowMember : rowMembers) {
                        String longNumber = rowMember.getLongNumber();
                        String currentLongNumber = member.getLongNumber();
                        if (currentLongNumber.equals(longNumber)) continue block3;
                        if (!currentLongNumber.startsWith(longNumber + "!") && !longNumber.startsWith(currentLongNumber + "!")) {
                            hasRelation = false;
                            continue;
                        }
                        if (currentLongNumber.startsWith(longNumber + "!") && isParent == null && isChild == null) {
                            isParent = true;
                            continue block3;
                        }
                        if (!longNumber.startsWith(currentLongNumber + "!") || isParent != null || isChild != null) continue;
                        isChild = true;
                        continue block3;
                    }
                }
                if (hasRelation) continue;
                isChild = false;
                isParent = false;
            }
            if (isParent != null && isParent.booleanValue()) {
                Set parent = refMap.computeIfAbsent("parent", v -> new HashSet(16));
                parent.add(string);
                refMap.put("parent", parent);
            }
            if (isChild == null || !isChild.booleanValue()) continue;
            Set child = refMap.computeIfAbsent("child", v -> new HashSet(16));
            child.add(string);
            refMap.put("child", child);
        }
        for (Map.Entry<String, Object> entry : dataLevelKeyMap.entrySet()) {
            key = entry.getKey();
            for (StringBuilder stringBuilder : groupLevelSet) {
                if (!this.validLevel(stringBuilder.substring(0, stringBuilder.length() - 1), key, "all", source, false)) continue;
                Map entryValue = (Map)entry.getValue();
                for (Map.Entry mapEntry : entryValue.entrySet()) {
                    Boolean isChild = null;
                    Boolean isParent = null;
                    Map value = (Map)mapEntry.getValue();
                    StringBuilder memberIdKey = new StringBuilder();
                    boolean hasRelation = true;
                    block9: for (String s : dimensionSplit) {
                        List<Member> currentMembers = currentMemberMap.get(s);
                        List members = (List)value.get(s);
                        for (Member currentMember : currentMembers) {
                            for (Member member : members) {
                                String longNumber = member.getLongNumber();
                                String currentLongNumber = currentMember.getLongNumber();
                                if (currentLongNumber.equals(longNumber)) {
                                    memberIdKey.append(member.getId()).append("!").append(RangeF7PropertyCataEnum.Member.getIndex()).append("#");
                                    continue block9;
                                }
                                if (!currentLongNumber.startsWith(longNumber + "!") && !longNumber.startsWith(currentLongNumber + "!")) {
                                    hasRelation = false;
                                    continue;
                                }
                                if (currentLongNumber.startsWith(longNumber + "!") && isParent == null && isChild == null) {
                                    isParent = true;
                                    continue block9;
                                }
                                if (!longNumber.startsWith(currentLongNumber + "!") || isParent != null || isChild != null) continue;
                                isChild = true;
                                continue block9;
                            }
                        }
                        memberIdKey.append(((Member)members.get(0)).getId()).append("!").append(RangeF7PropertyCataEnum.Member.getIndex()).append("#");
                    }
                    if (!hasRelation) {
                        isChild = false;
                        isParent = false;
                    }
                    if (isParent != null && isParent.booleanValue()) {
                        Set parent = refMap.computeIfAbsent("parent", v -> new HashSet(16));
                        parent.add(memberIdKey.substring(0, memberIdKey.length() - 1));
                        refMap.put("parent", parent);
                    }
                    if (isChild == null || !isChild.booleanValue()) continue;
                    Set child = refMap.computeIfAbsent("child", v -> new HashSet(16));
                    child.add(memberIdKey.substring(0, memberIdKey.length() - 1));
                    refMap.put("child", child);
                }
            }
        }
        return refMap;
    }

    public Map<String, DimMembPermDetailRecord[]> getRefDetailRecordMap(DimMembPermRecord mainPermRecord, boolean manager) {
        HashMap<String, DimMembPermDetailRecord[]> refDetailRecordMap = new HashMap<String, DimMembPermDetailRecord[]>(16);
        if (mainPermRecord != null) {
            Map allDetailRecords = mainPermRecord.getAllDetailRecords();
            for (Map.Entry next : allDetailRecords.entrySet()) {
                DimMembPermDetailRecord[] value = (DimMembPermDetailRecord[])next.getValue();
                StringBuilder stringBuilder = new StringBuilder();
                for (DimMembPermDetailRecord dimMembPermDetailRecord : value) {
                    if (dimMembPermDetailRecord == null) continue;
                    stringBuilder.append(dimMembPermDetailRecord.getMemberId()).append("!").append(dimMembPermDetailRecord.isMember() ? RangeF7PropertyCataEnum.Member.getIndex() : RangeF7PropertyCataEnum.Property.getIndex()).append("!");
                    if (!manager) continue;
                    stringBuilder.append(dimMembPermDetailRecord.getViewId()).append("!");
                }
                refDetailRecordMap.put(stringBuilder.substring(0, stringBuilder.length() - 1), value);
            }
        }
        return refDetailRecordMap;
    }

    public void setDetailRecord(DimMembPermDetailRecord[] records, DimMembPermType dimMembPermType, Boolean insertValue) {
        for (DimMembPermDetailRecord record : records) {
            if (record == null) continue;
            byte permVal = record.getPermVal();
            if (Boolean.TRUE.equals(insertValue)) {
                record.setPermVal((byte)(permVal | dimMembPermType.getDivNum()));
                continue;
            }
            if (!Boolean.FALSE.equals(insertValue)) continue;
            record.setPermVal((byte)(permVal & ~dimMembPermType.getDivNum()));
        }
    }

    public Boolean getPermFromDatabase(String memberStr, Map<String, DimMembPermDetailRecord[]> refDetailRecordMap, DimMembPermType type) {
        DimMembPermDetailRecord[] permDetailRecords;
        if (refDetailRecordMap != null && (permDetailRecords = refDetailRecordMap.get(memberStr)) != null) {
            byte permVal = permDetailRecords[0].getPermVal();
            return type.hasPerm(permVal);
        }
        return null;
    }

    public Map<String, Map<String, Set<String>>> getDataMemberOrProp(DimMembPermRecord mainPermRecord, List<Dimension> dimensionList, MemberPropCache propCache, Map<String, List<Long>> viewMap, Map<Long, Member> accountIdMemberMap) {
        HashMap<String, Map<String, Set<String>>> dataMemberOrPropMap = new HashMap<String, Map<String, Set<String>>>(16);
        if (mainPermRecord != null) {
            Map allDetailRecords = mainPermRecord.getAllDetailRecords();
            for (Map.Entry next : allDetailRecords.entrySet()) {
                DimMembPermDetailRecord[] value = (DimMembPermDetailRecord[])next.getValue();
                StringBuilder stringBuilder = new StringBuilder();
                HashMap<String, Set> longNumberData = new HashMap<String, Set>(dimensionList.size());
                for (int i = 0; i < value.length; ++i) {
                    DimMembPermDetailRecord record = value[i];
                    Dimension dimension = dimensionList.get(i);
                    String dimensionNumber = dimension.getNumber();
                    if (record == null) break;
                    Long memberId = record.getMemberId();
                    if (record.isMember()) {
                        List<Member> members = this.getMemberById(dimension, memberId, viewMap, accountIdMemberMap);
                        if (CollectionUtils.isEmpty(members)) break;
                        stringBuilder.append(members.get(0).getNumber()).append("!1").append("#");
                        for (Member member : members) {
                            Set strings = longNumberData.computeIfAbsent(dimensionNumber, v -> new HashSet(members.size()));
                            strings.add(member.getLongNumber());
                        }
                        continue;
                    }
                    CustomPropertyValue propertyValue = propCache.getPropertyValue(memberId);
                    stringBuilder.append(propertyValue.getLongNumber()).append("!2").append("#");
                    longNumberData.put(dimensionNumber, Sets.newHashSet((Object[])new String[]{propertyValue.getLongNumber() + "!"}));
                }
                dataMemberOrPropMap.put(stringBuilder.substring(0, stringBuilder.length() - 1), longNumberData);
            }
        }
        return dataMemberOrPropMap;
    }

    public Map<String, Map<String, Map<String, Set<String>>>> getRefPermMap(DimMembPermRecord mainPermRecord, List<Dimension> dimensionList, MemberPropCache propCache, Map<String, List<Long>> viewMap, Map<Long, Member> accountIdMemberMap) {
        HashMap<String, Map<String, Map<String, Set<String>>>> refPermMap = new HashMap<String, Map<String, Map<String, Set<String>>>>(256);
        if (mainPermRecord != null) {
            Map allDetailRecords = mainPermRecord.getAllDetailRecords();
            for (Map.Entry next : allDetailRecords.entrySet()) {
                DimMembPermDetailRecord detailRecord;
                DimMembPermDetailRecord[] value = (DimMembPermDetailRecord[])next.getValue();
                if (value.length == 0) continue;
                DimMembPermDetailRecord record = value[0];
                byte permVal = record.getPermVal();
                boolean read = DimMembPermType.READ.hasPerm(permVal);
                boolean write = DimMembPermType.WRITE.hasPerm(permVal);
                boolean give = DimMembPermType.GIVE.hasPerm(permVal);
                boolean include = DimMembPermType.DATAPERMEXTENDS.hasPerm(permVal);
                String permKey = read + "_" + write + "_" + give + "_" + include;
                StringBuilder stringBuilder = new StringBuilder();
                HashSet<StringBuilder> groupLevelSet = new HashSet<StringBuilder>(16);
                boolean containProp = false;
                for (int i = 0; i < value.length && (detailRecord = value[i]) != null; ++i) {
                    Long memberId = detailRecord.getMemberId();
                    if (detailRecord.isMember()) {
                        List<Member> members = this.getMemberById(dimensionList.get(i), memberId, viewMap, accountIdMemberMap);
                        if (CollectionUtils.isEmpty(members)) break;
                        HashSet<StringBuilder> tempLevelSet = new HashSet<StringBuilder>(16);
                        members.forEach(member -> {
                            StringBuilder memberLevel = new StringBuilder();
                            memberLevel.append(member.getLevel()).append("!");
                            tempLevelSet.add(memberLevel);
                        });
                        this.connectLevelStr(groupLevelSet, tempLevelSet, true);
                        stringBuilder.append(members.get(0).getNumber()).append("!1").append("#");
                        continue;
                    }
                    containProp = true;
                    stringBuilder.append(propCache.getPropertyValue(memberId).getLongNumber()).append("!2").append("#");
                    StringBuilder memberLevel = new StringBuilder();
                    memberLevel.append("0").append("!");
                    groupLevelSet.add(memberLevel);
                }
                Map dataPermMap = containProp ? refPermMap.computeIfAbsent("prop", v -> new HashMap(256)) : refPermMap.computeIfAbsent("member", v -> new HashMap(256));
                TreeMap<String, Set> memberMap = (TreeMap<String, Set>)dataPermMap.get(permKey);
                if (memberMap == null) {
                    memberMap = new TreeMap<String, Set>(String::compareTo);
                }
                if (!CollectionUtils.isNotEmpty(groupLevelSet)) continue;
                for (StringBuilder memberLevel : groupLevelSet) {
                    Set strings = memberMap.computeIfAbsent(memberLevel.substring(0, memberLevel.length() - 1), v -> new HashSet(16));
                    strings.add(stringBuilder.substring(0, stringBuilder.length() - 1));
                }
                dataPermMap.put(permKey, memberMap);
            }
        }
        return refPermMap;
    }

    public Map<String, Map<String, Map<String, List<Member>>>> getDataLevelKeyMap(DimMembPermRecord mainPermRecord, List<Dimension> dimensionList, Map<String, List<Long>> viewMap, Map<Long, Member> accountIdMemberMap) {
        HashMap<String, Map<String, Map<String, List<Member>>>> dataLevelKeyMap = new HashMap<String, Map<String, Map<String, List<Member>>>>(256);
        if (mainPermRecord != null) {
            Map allDetailRecords = mainPermRecord.getAllDetailRecords();
            for (Map.Entry next : allDetailRecords.entrySet()) {
                DimMembPermDetailRecord[] value = (DimMembPermDetailRecord[])next.getValue();
                StringBuilder stringBuilder = new StringBuilder();
                HashSet<StringBuilder> groupLevelSet = new HashSet<StringBuilder>(16);
                boolean containProp = false;
                HashMap<String, List<Member>> memberMap = new HashMap<String, List<Member>>(value.length);
                for (int i = 0; i < value.length; ++i) {
                    List<Member> members;
                    DimMembPermDetailRecord record = value[i];
                    Dimension dimension = dimensionList.get(i);
                    String dimensionNumber = dimension.getNumber();
                    if (record == null) break;
                    Long memberId = record.getMemberId();
                    HashSet<StringBuilder> tempLevelSet = new HashSet<StringBuilder>(16);
                    if (record.isMember()) {
                        members = this.getMemberById(dimension, memberId, viewMap, accountIdMemberMap);
                        if (CollectionUtils.isEmpty(members)) break;
                    } else {
                        containProp = true;
                        break;
                    }
                    members.forEach(memb -> {
                        StringBuilder builder = new StringBuilder();
                        builder.append(memb.getLevel()).append("!");
                        tempLevelSet.add(builder);
                    });
                    this.connectLevelStr(groupLevelSet, tempLevelSet, true);
                    memberMap.put(dimensionNumber, members);
                    stringBuilder.append(members.get(0).getNumber()).append("!1").append("#");
                }
                if (containProp || memberMap.size() <= 0) continue;
                for (StringBuilder builder : groupLevelSet) {
                    Map stringMapMap = dataLevelKeyMap.computeIfAbsent(builder.substring(0, builder.length() - 1), v -> new HashMap(256));
                    stringMapMap.put(stringBuilder.substring(0, stringBuilder.length() - 1), memberMap);
                }
            }
        }
        return dataLevelKeyMap;
    }

    public List<Member> getMemberById(Dimension dimension, Long memberId, Map<String, List<Long>> viewMap, Map<Long, Member> accountIdMemberMap) {
        ArrayList<Member> members = new ArrayList<Member>(10);
        if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
            Member member = accountIdMemberMap.get(memberId);
            if (member != null) {
                members.add(member);
            }
        } else {
            List<Long> viewIds = viewMap.get(dimension.getNumber());
            for (Long viewId : viewIds) {
                Member member = dimension.getMember(viewId, memberId);
                if (member == null || MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource())) continue;
                members.add(member);
            }
        }
        return members;
    }

    public List<Member> getMember(String dimensionStr, String membOrPropNum, boolean canNull, @NotNull Map<String, List<Long>> viewMap, IModelCacheHelper modelCache, Map<String, Member> accountMemberMap) {
        Dimension dimension = modelCache.getDimension(dimensionStr);
        ArrayList<Member> members = new ArrayList<Member>(10);
        if (SysDimensionEnum.Account.getNumber().equals(dimensionStr)) {
            Member member = accountMemberMap.get(membOrPropNum);
            if (member != null && !MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource())) {
                members.add(member);
            }
        } else {
            List<Long> viewIds = viewMap.get(dimensionStr);
            if (CollectionUtils.isNotEmpty(viewIds)) {
                for (Long viewId : viewIds) {
                    Member member = dimension.getMember(viewId, membOrPropNum);
                    if (member == null || MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource())) continue;
                    members.add(member);
                }
            } else {
                Member member = dimension.getStructOfMember(membOrPropNum);
                if (member != null) {
                    members.add(member);
                }
            }
        }
        if (CollectionUtils.isEmpty(members) && !canNull) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6%1\u6210\u5458%2\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)dimensionStr, (String)membOrPropNum, (Object[])new Object[0]));
        }
        members.sort((o1, o2) -> {
            Long refViewId1 = IDUtils.toLong((Object)o1.getRefViewId());
            Long refViewId2 = IDUtils.toLong((Object)o2.getRefViewId());
            return refViewId1.compareTo(refViewId2);
        });
        return members;
    }

    public boolean baseParamsCheck(DimPermBatchRequest request, DimPermBatchResponse dimPermBatchResponse) {
        Set errorMsg = dimPermBatchResponse.getBaseErrorMsg();
        if (request == null) {
            errorMsg.add(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"DimPermImportUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String modelNumber = request.getModelNumber();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray());
        if (dynamicObject == null) {
            errorMsg.add(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"DimPermImportUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        request.setModelId(Long.valueOf(dynamicObject.getLong("id")));
        Map permMap = request.getPermMap();
        if (permMap == null) {
            errorMsg.add(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u6743\u9650\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"DimPermImportUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void validUserOrGroupExist(Map<String, Long> userOrGroupMap, Set<Long> managersByModel, Set<Long> userOrGroupIds, Map<String, List<DimPermPojo[]>> userOrGroupPermMap, boolean isUser, Set<String> errorMsg, Long currentUserId) {
        if (userOrGroupPermMap == null) {
            return;
        }
        Iterator<Map.Entry<String, List<DimPermPojo[]>>> entryIterator = userOrGroupPermMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, List<DimPermPojo[]>> entry = entryIterator.next();
            String userNumber = entry.getKey();
            if (StringUtils.isNotEmpty((CharSequence)userNumber)) {
                Long userId = userOrGroupMap.get(userNumber);
                if (IDUtils.isNull((Long)userId)) {
                    if (isUser) {
                        errorMsg.add(String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"DimPermImportUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), userNumber));
                    } else {
                        errorMsg.add(String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4%1$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"DimPermImportUtil_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), userNumber));
                    }
                    entryIterator.remove();
                    continue;
                }
                if (isUser && userId.equals(currentUserId)) {
                    errorMsg.add(String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u4e0e\u6267\u884c\u5bfc\u5165\u7528\u6237\u76f8\u540c", (String)"DimPermImportUtil_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), userNumber));
                    entryIterator.remove();
                    continue;
                }
                if (managersByModel.contains(userId)) {
                    if (isUser) {
                        errorMsg.add(String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u4e3a\u5f53\u524d\u5bfc\u5165\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"DimPermImportUtil_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), userNumber));
                    } else {
                        errorMsg.add(String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4%1$s\u4e3a\u5f53\u524d\u5bfc\u5165\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"DimPermImportUtil_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), userNumber));
                    }
                    entryIterator.remove();
                    continue;
                }
                userOrGroupIds.add(userId);
                continue;
            }
            if (isUser) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"DimPermImportUtil_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), userNumber));
            } else {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4%1$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"DimPermImportUtil_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), userNumber));
            }
            entryIterator.remove();
        }
    }

    public Map<String, Map<String, Long>> getAllUserAndGroupData() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryUser", (String)"bos_user", (String)"number,id", (QFilter[])new QFilter[0], null);
        HashMap<String, Long> userMap = new HashMap<String, Long>(16);
        HashMap<String, Long> groupMap = new HashMap<String, Long>(16);
        while (dataSet.hasNext()) {
            kd.bos.algo.Row next = dataSet.next();
            String number = next.getString("number");
            Long id = next.getLong("id");
            userMap.put(number, id);
        }
        DataSet groupDataSet = QueryServiceHelper.queryDataSet((String)"queryGroup", (String)"bos_usergroup", (String)"number,id", (QFilter[])new QFilter[0], null);
        while (groupDataSet.hasNext()) {
            kd.bos.algo.Row next = groupDataSet.next();
            String number = next.getString("number");
            Long id = next.getLong("id");
            groupMap.put(number, id);
        }
        HashMap<String, Map<String, Long>> userAndGroupData = new HashMap<String, Map<String, Long>>(2);
        userAndGroupData.put("user", userMap);
        userAndGroupData.put("group", groupMap);
        return userAndGroupData;
    }

    public void connectLevelStr(Set<StringBuilder> groupLevelSet, Set<StringBuilder> levelTemSet, boolean tail) {
        HashSet<StringBuilder> tempSet = new HashSet<StringBuilder>(groupLevelSet.size() * levelTemSet.size() == 0 ? 16 : groupLevelSet.size() * levelTemSet.size());
        if (CollectionUtils.isEmpty(groupLevelSet)) {
            groupLevelSet.addAll(levelTemSet);
            return;
        }
        if (tail) {
            for (StringBuilder stringBuilder : groupLevelSet) {
                for (StringBuilder builder : levelTemSet) {
                    stringBuilder.append((CharSequence)builder);
                    tempSet.add(stringBuilder);
                }
            }
        } else {
            for (StringBuilder builder : levelTemSet) {
                for (StringBuilder stringBuilder : groupLevelSet) {
                    builder.append((CharSequence)stringBuilder);
                    tempSet.add(builder);
                }
            }
        }
        groupLevelSet.clear();
        groupLevelSet.addAll(tempSet);
    }

    public Member getSourceMemberById(String dimensionStr, Long memberId, IModelCacheHelper modelCacheHelper, Long bizModelId, Map<Long, Member> accountIdMemberMap) {
        Dimension dimension = modelCacheHelper.getDimension(dimensionStr);
        Map viewMap = modelCacheHelper.getViewGroupViewsByBusModel(bizModelId);
        Member member = null;
        if (SysDimensionEnum.Account.getNumber().equals(dimensionStr)) {
            member = accountIdMemberMap.get(memberId);
        } else {
            List viewIds = (List)viewMap.get(dimensionStr);
            if (CollectionUtils.isNotEmpty((Collection)viewIds)) {
                Long viewId;
                Iterator iterator = viewIds.iterator();
                while (iterator.hasNext() && ((member = dimension.getMember(viewId = (Long)iterator.next(), memberId)) == null || MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource()) || !IDUtils.isNull((Long)member.getRefViewId()))) {
                }
            } else {
                member = dimension.getStructOfMember(memberId);
            }
        }
        return member;
    }
}

