/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.userremember.entity.UserRememberEntity;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.JoinerTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.log.BcmLogFactory;
import kd.epm.eb.common.log.WatchLogger;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBaseListPlugin;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.report.excel.BgmReportExportFileRulePlugin;
import kd.epm.eb.formplugin.report.excel.controller.ExportReportListUserRememberController;
import kd.epm.eb.formplugin.report.excel.controller.ReportExportDataController;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportHelper;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.utils.ReportHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BgmReportExportDataPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final ReportExportDataController reportExportDataController = ReportExportDataController.getInstance();
    private static final ExportReportListUserRememberController userRememberController = ExportReportListUserRememberController.getInstance();
    private static final String REPORTPROCESS_ENTITY = "reportprocess_entity";
    private static final String PAGEDIM_ENTITY = "pagedim_entity";
    public static final String DIM_SELECTMEMBER_IDS = "allDimSelectMemberIds";
    private static final Log logger = LogFactory.getLog(BgmReportExportDataPlugin.class);
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractBaseListPlugin.class);
    private ReportExportHelper exportHelper = null;
    private Map<String, Set<String>> errorInfoMap = null;

    public void afterCreateNewData(EventObject e) {
        Object addItems;
        this.initPageData();
        this.setUserRememberCheckbox();
        this.setVisible();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object showDownloadPage = customParams.get("showDownloadPage");
        if (showDownloadPage != null && "true".equals(showDownloadPage.toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_export", "flexpanelap5", "flexpanelap4"});
            this.itemClick(new ItemClickEvent((Object)this, "btn_download", null));
        }
        if ((addItems = customParams.get("addItems")) == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_add", "btn_del"});
        }
    }

    private void setVisible() {
        ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
        this.getView().setVisible(Boolean.valueOf(ReportExportTypeEnum.EXPORT_DATA == exportTypeEnum), new String[]{"isdividecell", "isincludepagedim", "membershowtype", "byorgexport"});
        this.getView().setVisible(Boolean.valueOf(ReportExportTypeEnum.EXPORT_TEMPLATE == exportTypeEnum), new String[]{"isexportdata"});
        this.getView().setVisible(Boolean.valueOf(this.getSchemeId() != null), new String[]{"byorgexport"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long modelId = this.getModelId();
        if (ReportExportTypeEnum.EXPORT_DATA == this.getExportTypeEnum()) {
            ReportHelper.setLongNameNumDisVisible((Long)modelId, (IFormView)this.getView());
            ComboEdit membershowtype = (ComboEdit)this.getControl("membershowtype");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            List longNameNumDisplayParams = MemberParamsUtils.getLongNameNumDisplayParamsByCache((long)modelId);
            boolean longNameNumVisible = !CollectionUtils.isEmpty((Collection)longNameNumDisplayParams);
            for (MemberDisplayTypeEnum value : MemberDisplayTypeEnum.values()) {
                if (!longNameNumVisible && (value.getIndex() == 6 || value.getIndex() == 7 || value.getIndex() == 8)) continue;
                ComboItem comboItem = new ComboItem(new LocaleString(value.getDisplayName().loadKDString()), value.getIndex() + "");
                comboItems.add(comboItem);
            }
            membershowtype.setComboItems(comboItems);
            this.getModel().setValue("membershowtype", (Object)Integer.parseInt(((ComboItem)comboItems.get(0)).getValue()));
            this.getView().updateView("membershowtype");
        }
        this.setDefaultNameFormatInfo();
        this.setUserRememberFileName();
    }

    private void initPageData() {
        this.getModel().deleteEntryData(REPORTPROCESS_ENTITY);
        this.getModel().deleteEntryData(PAGEDIM_ENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object model = customParams.get("model");
        Object period = customParams.get("period");
        Object dataType = customParams.get("dataType");
        Object version = customParams.get("version");
        Object showDownloadPage = customParams.get("showDownloadPage");
        if (showDownloadPage == null) {
            Object reportProcessIdSetStr = customParams.get("reportProcessIdSet");
            if (reportProcessIdSetStr == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u62a5\u8868\u3002", (String)"BgmReportExportDataPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            List reportProcessIdSet = (List)SerializationUtils.fromJsonString((String)reportProcessIdSetStr.toString(), ArrayList.class);
            if (CollectionUtils.isEmpty((Collection)reportProcessIdSet)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u62a5\u8868\u3002", (String)"BgmReportExportDataPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(REPORTPROCESS_ENTITY, reportProcessIdSet.size());
            DynamicObjectCollection reportProcess = this.getReportProcess(reportProcessIdSet);
            int i = 0;
            for (DynamicObject obj : reportProcess) {
                this.getModel().setValue("reportprocess", (Object)obj.getLong("id"), i);
                this.getModel().setValue("reportname", (Object)obj.getString("template.name"), i);
                this.getModel().setValue("reportnumber", (Object)obj.getString("template.number"), i);
                this.getModel().setValue("entityname", (Object)obj.getString("entity.name"), i);
                ++i;
            }
        }
        this.getModel().setValue("model", model);
        this.getModel().setValue("datatype", dataType);
        this.getModel().setValue("version", version);
        this.getModel().setValue("period", period);
        this.getModel().endInit();
        this.getView().updateView(REPORTPROCESS_ENTITY);
        this.getView().setEnable(Boolean.FALSE, -1, new String[]{"reportname", "reportnumber", "entityname"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(REPORTPROCESS_ENTITY);
        entryGrid.selectRows(1);
    }

    private DynamicObjectCollection getReportProcess(List<Long> reportProcessIdSet) {
        QFilter filter = new QFilter("id", "in", reportProcessIdSet);
        DynamicObjectCollection eb_templateentity = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,template.name,template.number,entity.name", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        block0: for (Long idSet : reportProcessIdSet) {
            for (DynamicObject object : eb_templateentity) {
                Long id = IDUtils.toLong((Object)object.get("id"));
                if (!id.equals(idSet)) continue;
                dynamicObjects.add((Object)object);
                continue block0;
            }
        }
        return dynamicObjects;
    }

    private void setDefaultNameFormatInfo() {
        HashMap<String, Object> fileNameFormatInfo = new HashMap<String, Object>(4);
        ArrayList<BgmReportExportFileRulePlugin.FiledMember> fileFiledMembers = new ArrayList<BgmReportExportFileRulePlugin.FiledMember>(10);
        fileFiledMembers.add(new BgmReportExportFileRulePlugin.FiledMember("fixvalue", ResManager.loadKDString((String)"\u56fa\u5b9a\u503c", (String)"BgmReportExportDataPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), true));
        fileNameFormatInfo.put("selectedFiled", fileFiledMembers);
        fileNameFormatInfo.put("joiner", JoinerTypeEnum.NO.getIndex());
        ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            fileNameFormatInfo.put("fixvalue", ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa", (String)"BgmReportExportDataPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            fileNameFormatInfo.put("fixvalue", ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa", (String)"BgmReportExportDataPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ((Label)this.getControl("filename")).setText((String)fileNameFormatInfo.get("fixvalue"));
        HashMap<String, Object> sheetNameFormatInfo = new HashMap<String, Object>(4);
        ArrayList<BgmReportExportFileRulePlugin.FiledMember> filedMembers = new ArrayList<BgmReportExportFileRulePlugin.FiledMember>(10);
        String reportName = ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"BgmReportExportDataPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String entityName = ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"BgmReportExportDataPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        filedMembers.add(new BgmReportExportFileRulePlugin.FiledMember("report.name", reportName, true));
        filedMembers.add(new BgmReportExportFileRulePlugin.FiledMember("entity.name", entityName, true));
        sheetNameFormatInfo.put("selectedFiled", filedMembers);
        sheetNameFormatInfo.put("joiner", JoinerTypeEnum.UNDER_LINE.getIndex());
        sheetNameFormatInfo.put("fixvalue", "");
        ((Label)this.getControl("sheetname")).setText(reportName + "_" + entityName);
        this.cacheFileNameFormat("filename", fileNameFormatInfo);
        this.cacheFileNameFormat("sheetname", sheetNameFormatInfo);
    }

    private void setUserRememberCheckbox() {
        UserRememberEntity isIncludePageDim;
        ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            return;
        }
        UserRememberEntity userRemember = userRememberController.getIsDivideCell("bgm_reportexport");
        if (userRemember != null) {
            this.getModel().setValue("isdividecell", (Object)userRemember.getValue());
        }
        if ((isIncludePageDim = userRememberController.getIsIncludePageDim("bgm_reportexport")) != null) {
            this.getModel().setValue("isincludepagedim", (Object)isIncludePageDim.getValue());
        }
    }

    private void setUserRememberFileName() {
        String value;
        ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            return;
        }
        UserRememberEntity fileNameRemember = userRememberController.getFileNameRemember("bgm_reportexport");
        UserRememberEntity sheetNameRemember = userRememberController.getSheetNameRemember("bgm_reportexport");
        if (fileNameRemember != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(value = fileNameRemember.getValue()))) {
            try {
                Map fileNameInfo = (Map)SerializationUtils.deSerializeFromBase64((String)value);
                fileNameInfo.put("namesource", "filename");
                this.dealNameClosedCallBack(SerializationUtils.serializeToBase64((Object)fileNameInfo));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (sheetNameRemember != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(value = sheetNameRemember.getValue()))) {
            try {
                Map sheetNameInfo = (Map)SerializationUtils.deSerializeFromBase64((String)value);
                sheetNameInfo.put("namesource", "sheetname");
                this.dealNameClosedCallBack(SerializationUtils.serializeToBase64((Object)sheetNameInfo));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    private Map<String, Long> getDefaultDimensionNumberIdMap() {
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject datatype = (DynamicObject)this.getModel().getValue("datatype");
        DynamicObject version = (DynamicObject)this.getModel().getValue("version");
        result.put(SysDimensionEnum.BudgetPeriod.getNumber(), period.getLong("id"));
        result.put(SysDimensionEnum.DataType.getNumber(), datatype.getLong("id"));
        result.put(SysDimensionEnum.Version.getNumber(), version.getLong("id"));
        return result;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"pagedimmember", "filename", "sheetname"});
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(REPORTPROCESS_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"btn_export", (CharSequence)itemKey)) {
            evt.setCancel(this.beforeExportCheck());
        }
    }

    private boolean beforeExportCheck() {
        Map<Long, Map<String, String>> allPageDimMemberMap = this.getAllPageDimMemberMap();
        for (Map.Entry<Long, Map<String, String>> entry : allPageDimMemberMap.entrySet()) {
            Long templateId = entry.getKey();
            Map<String, String> pageDimMemberMap = entry.getValue();
            if (!pageDimMemberMap.containsValue("") && !pageDimMemberMap.containsValue(null)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u9875\u9762\u7ef4\u4fe1\u606f\u3002", (String)"BgmReportExportDataPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String clickKey = evt.getItemKey();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"btn_export", (CharSequence)clickKey)) {
            this.handleUserRemember();
            this.exportReportData();
        } else if ("btn_download".equals(clickKey)) {
            this.openDownloadPage();
        } else if ("btn_add".equals(clickKey)) {
            DynamicObjectCollection entity = this.getModel().getEntryEntity(REPORTPROCESS_ENTITY);
            List reportProcessIds = entity.stream().map(e -> e.getDynamicObject("reportprocess").getLong("id")).collect(Collectors.toList());
            List allProcessIds = new ArrayList(16);
            String allReportProcessJson = (String)this.getView().getFormShowParameter().getCustomParam("allReportProcessId");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)allReportProcessJson)) {
                allProcessIds = (List)SerializationUtils.fromJsonString((String)allReportProcessJson, ArrayList.class);
            }
            allProcessIds.removeAll(reportProcessIds);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bgm_addexportreport");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addReport"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("allReportProcessId", (Object)SerializationUtils.toJsonString(allProcessIds));
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            formShowParameter.setCustomParam("schemeId", customParams.get("schemeId"));
            formShowParameter.setCustomParam("sourceType", customParams.get("sourceType"));
            formShowParameter.setCustomParam("pageType", (Object)"add");
            this.getView().showForm(formShowParameter);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        if (!REPORTPROCESS_ENTITY.equals(name)) {
            return;
        }
        this.getModel().deleteEntryData(PAGEDIM_ENTITY);
    }

    private void openDownloadPage() {
        Long modelId = this.getModelId();
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("eb_exportfilelist");
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        openStyle.setInlineStyleCss(css);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(true);
        showParameter.setLookUp(false);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam("creater", (Object)this.getUserId());
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        filters.add(new QFilter("creater", "=", (Object)this.getUserId()));
        showParameter.getListFilterParameter().setQFilters((List)filters);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)opkey, (CharSequence)"pagedimmember")) {
            this.openPageDimMemberF7();
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)opkey, (CharSequence)"filename") || org.apache.commons.lang3.StringUtils.equals((CharSequence)"sheetname", (CharSequence)opkey)) {
            this.openFileNameRulePage(opkey);
        }
    }

    private void openFileNameRulePage(String closedCallBackId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bgm_filesheetnamerule");
        if ("sheetname".equals(closedCallBackId)) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fasheet\u9875\u547d\u540d\u89c4\u5219", (String)"BgmReportExportDataPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.addCustPlugin("kd.epm.eb.formplugin.report.excel.BgmReportExportFileRulePlugin");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closedCallBackId));
        formShowParameter.setCustomParam("source", (Object)closedCallBackId);
        Map<String, Object> fileNameFormat = this.getFileNameFormat(closedCallBackId);
        formShowParameter.setCustomParam("selectedFiledStr", (Object)SerializationUtils.serializeToBase64((Object)fileNameFormat.get("selectedFiled")));
        formShowParameter.setCustomParam("joiner", fileNameFormat.get("joiner"));
        formShowParameter.setCustomParam("fixvalue", fileNameFormat.get("fixvalue"));
        this.getView().showForm(formShowParameter);
    }

    private void openPageDimMemberF7() {
        Member member;
        EntryGrid entryGrid = (EntryGrid)this.getControl(PAGEDIM_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(REPORTPROCESS_ENTITY);
        int[] selectRows1 = entryGrid1.getSelectRows();
        DynamicObject pageDimension = (DynamicObject)this.getModel().getValue("pagedimension", selectRows[0]);
        String dimNumber = pageDimension.getString("number");
        DynamicObject reportprocess = (DynamicObject)this.getModel().getValue("reportprocess", selectRows1[0]);
        long templateId = reportprocess.getLong("template_id");
        long reportProcssId = reportprocess.getLong("id");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        long periodId = period.getLong("id");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"eb_templateentity", (String)"dataset");
        if (object == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u6a21\u677f\u6a21\u677f\u4e1a\u52a1\u6a21\u578b\u5931\u8d25\u3002", (String)"BgmReportExportDataPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long entityViewId = this.getOrgViewId();
        long datasetId = object.getLong("dataset.id");
        ITemplateModel templateModel = this.getTemplateModel(templateId);
        Map dimensionViews = templateModel.getDimemsionViews();
        dimensionViews.put(SysDimensionEnum.Entity.getNumber(), entityViewId);
        Long viewId = (Long)dimensionViews.get(dimNumber);
        List<QFilter> filters = this.getCurrentDimFilters(reportProcssId, templateId, templateModel, dimNumber, periodId, entityViewId);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        f7Param.setBusModelId(iModelCacheHelper.getBusModelByDataSet(Long.valueOf(datasetId)));
        f7Param.setViewId(viewId);
        if (dimNumber.equals("Account")) {
            f7Param.setDatasetId(Long.valueOf(datasetId));
        }
        f7Param.addCustomFilter(filters);
        Map<String, String> pageDimMemberMap = this.getPageDimMemberMap(reportProcssId);
        if (pageDimMemberMap != null && pageDimMemberMap.get(dimNumber) != null && (member = iModelCacheHelper.getMember(dimNumber, viewId, pageDimMemberMap.get(dimNumber))) != null) {
            f7Param.setSelectIds(Collections.singleton(member.getId()));
        }
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, PAGEDIM_ENTITY));
    }

    private List<QFilter> getCurrentDimFilters(Long reportProcssId, Long templateId, ITemplateModel templateModel, String dimNumber, Long periodId, Long entityViewId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(templateModel.getTemplateBaseInfo().getDatasetID());
        Map<String, List<Member>> dimSelectMembers = this.getDimSelectMembersMap(modelCacheHelper, templateModel, templateId, entityViewId);
        List selectMembers = dimSelectMembers.get(dimNumber);
        if ("Entity".equals(dimNumber)) {
            EntryGrid entryGrid1 = (EntryGrid)this.getControl(REPORTPROCESS_ENTITY);
            DynamicObject reportProcess = (DynamicObject)this.getModel().getValue("reportprocess", entryGrid1.getSelectRows()[0]);
            long orgId = reportProcess.getLong("entity.id");
            Member member = modelCacheHelper.getMember("Entity", entityViewId, Long.valueOf(orgId));
            selectMembers = member.getAllMembers();
        }
        this.getView().getPageCache().put("templateId", String.valueOf(templateId));
        Map dimRelationMap = ReportHelper.getDimRelationMap((IFormView)this.getView(), (Long)reportProcssId);
        if (!dimRelationMap.isEmpty() && dimRelationMap.containsKey(dimNumber)) {
            List dimRelationList = ReportHelper.getDimRelation((IFormView)this.getView(), (Long)reportProcssId);
            Map<String, String> pageDimMemberMap = this.getPageDimMemberMapBeforeDim(dimNumber);
            Set memberIdSet = DimensionRelationUtils.getRelationMemId((IModelCacheHelper)modelCacheHelper, (Long)bizModelId, (String)dimNumber, (Long)periodId, pageDimMemberMap, (Map)dimRelationMap, (List)dimRelationList);
            if (CollectionUtils.isNotEmpty((Collection)memberIdSet)) {
                selectMembers = selectMembers.stream().filter(e -> memberIdSet.contains(e.getId()) || !e.isLeaf()).collect(Collectors.toList());
            }
        }
        Set selectMemberIds = selectMembers.stream().map(BaseCache::getId).collect(Collectors.toSet());
        if (View.NoViewDimNums.contains(dimNumber)) {
            filters.add(new QFilter("id", "in", selectMemberIds));
        } else {
            filters.add(new QFilter("memberid", "in", selectMemberIds));
        }
        return filters;
    }

    private Map<String, List<Member>> getDimSelectMembersMap(IModelCacheHelper modelCacheHelper, ITemplateModel templateModel, Long templateId, Long entityViewId) {
        return this.getExportHelper().getDimSelectMembersMap(this.getView(), this.getModelId(), this.getProcessType(), this.getProcessId(), modelCacheHelper, templateModel, templateId, entityViewId);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.removeRelationCache();
    }

    private void removeRelationCache() {
        DynamicObjectCollection entryRowEntity = this.getModel().getEntryEntity(REPORTPROCESS_ENTITY);
        for (DynamicObject object : entryRowEntity) {
            Long reportProcssId = object.getLong("reportprocess.id");
            ReportHelper.removeDimRelationCache((IPageCache)this.getView().getPageCache(), (Long)reportProcssId);
            ReportHelper.removeDimMemRelationCache((IPageCache)this.getView().getPageCache(), (Long)reportProcssId);
        }
    }

    private void removeRelationCache(int row) {
        DynamicObject object = this.getModel().getEntryRowEntity(REPORTPROCESS_ENTITY, row);
        Long reportProcssId = object.getLong("reportprocess.id");
        ReportHelper.removeDimRelationCache((IPageCache)this.getView().getPageCache(), (Long)reportProcssId);
        ReportHelper.removeDimMemRelationCache((IPageCache)this.getView().getPageCache(), (Long)reportProcssId);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.setPageDimEntryEntity(row);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "filename": 
            case "sheetname": {
                this.dealNameClosedCallBack(returnData);
                break;
            }
            case "pagedim_entity": {
                this.dealPageDimCloseCallBack(returnData);
                this.cachePageDimMemberMapAfterF7();
                break;
            }
            case "exportCloseCallBack": {
                break;
            }
            case "addReport": {
                this.addReportToEntity(returnData);
                break;
            }
        }
    }

    private void addReportToEntity(Object returnDataJson) {
        if (returnDataJson == null) {
            return;
        }
        List returnData = (List)SerializationUtils.fromJsonString((String)returnDataJson.toString(), ArrayList.class);
        for (List obj : returnData) {
            int i = this.getModel().createNewEntryRow(REPORTPROCESS_ENTITY);
            this.getModel().setValue("reportprocess", obj.get(0), i);
            this.getModel().setValue("reportname", obj.get(2), i);
            this.getModel().setValue("reportnumber", obj.get(1), i);
            this.getModel().setValue("entityname", obj.get(3), i);
        }
    }

    private void handleExportCloseCallBack(Map<String, Object> returnData) {
    }

    private void cachePageDimMemberMapAfterF7() {
        DynamicObjectCollection entryRowEntity = this.getModel().getEntryEntity(PAGEDIM_ENTITY);
        HashMap<String, String> updatePageDimMap = new HashMap<String, String>();
        for (DynamicObject object : entryRowEntity) {
            updatePageDimMap.put(object.getString("pagedimension.number"), object.getString("pagedimmembernumber"));
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(REPORTPROCESS_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        Map<Long, Map<String, String>> allPageDimMemberMap = this.getAllPageDimMemberMap();
        DynamicObject reportProcess = (DynamicObject)this.getModel().getValue("reportprocess", selectRows[0]);
        Long reportProcessId = reportProcess.getLong("id");
        allPageDimMemberMap.put(reportProcessId, updatePageDimMap);
        this.getView().getPageCache().put("allPageDimMemberMap", SerializationUtils.serializeToBase64(allPageDimMemberMap));
    }

    private ReportExportHelper getExportHelper() {
        if (this.exportHelper == null) {
            this.exportHelper = ReportExportHelper.getInstance();
        }
        return this.exportHelper;
    }

    private Map<String, String> getDimMemberNumberMap(Map<Long, Map<String, String>> allPageDimMemberMap, DynamicObject row) {
        Map<String, Long> defaultDimensionNumberIdMap = this.getDefaultDimensionNumberIdMap();
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        Long templateId = row.getLong("reportprocess.template.id");
        Long reportProcssId = row.getLong("reportprocess.id");
        String orgNumber = row.getString("reportprocess.entity.number");
        return this.getExportHelper().getDimMemberNumberMap(this.getView(), allPageDimMemberMap, defaultDimensionNumberIdMap, this.getModelId(), Long.valueOf(period.getLong("id")), this.getProcessType(), this.getProcessId(), reportProcssId, templateId, Long.valueOf(row.getLong("reportprocess.entity.id")), orgNumber, Long.valueOf(this.getOrgViewId()), null);
    }

    private void cachePageDimMemberMap(int row) {
        DynamicObject object = this.getModel().getEntryRowEntity(REPORTPROCESS_ENTITY, row);
        Long reportProcssId = object.getLong("reportprocess.id");
        Map<Long, Map<String, String>> allPageDimMemberMap = this.getAllPageDimMemberMap();
        Map<String, String> dimMemberNumberMap = allPageDimMemberMap.get(reportProcssId);
        if (dimMemberNumberMap == null) {
            allPageDimMemberMap.put(reportProcssId, this.getDimMemberNumberMap(allPageDimMemberMap, object));
            this.getView().getPageCache().put("allPageDimMemberMap", SerializationUtils.serializeToBase64(allPageDimMemberMap));
        }
    }

    public Map<String, String> getPageDimMemberMapBeforeDim(String dimNumber) {
        DynamicObject object;
        String dim;
        DynamicObjectCollection entryRowEntity = this.getModel().getEntryEntity(PAGEDIM_ENTITY);
        HashMap<String, String> pageDimMemberMap = new HashMap<String, String>(entryRowEntity.size());
        Iterator iterator = entryRowEntity.iterator();
        while (iterator.hasNext() && !org.apache.commons.lang3.StringUtils.equals((CharSequence)dimNumber, (CharSequence)(dim = (object = (DynamicObject)iterator.next()).getString("pagedimension.number")))) {
            pageDimMemberMap.put(dim, object.getString("pagedimmembernumber"));
        }
        return pageDimMemberMap;
    }

    private Map<Long, Map<String, String>> getAllPageDimMemberMap() {
        String allPageDimMemberMapCache = this.getView().getPageCache().get("allPageDimMemberMap");
        if (allPageDimMemberMapCache != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)allPageDimMemberMapCache);
        }
        return new HashMap<Long, Map<String, String>>();
    }

    private Map<String, String> getPageDimMemberMap(Long processId) {
        return this.getAllPageDimMemberMap().get(processId);
    }

    private void dealPageDimCloseCallBack(Object returnData) {
        ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)returnData).get(0);
        String dimMemberNumber = listSelectedRow.getNumber();
        String name = listSelectedRow.getName();
        EntryGrid entryGrid = (EntryGrid)this.getControl(PAGEDIM_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        this.getModel().setValue("pagedimmember", (Object)name, selectRows[0]);
        this.getModel().setValue("pagedimmembernumber", (Object)dimMemberNumber, selectRows[0]);
    }

    private void dealNameClosedCallBack(Object returnData) {
        Map nameFormatInfo = (Map)SerializationUtils.deSerializeFromBase64((String)((String)returnData));
        List selectedFiled = (List)nameFormatInfo.get("selectedFiled");
        String joiner = (String)nameFormatInfo.get("joiner");
        String fixvalue = (String)nameFormatInfo.get("fixvalue");
        String namesource = (String)nameFormatInfo.get("namesource");
        ArrayList<String> selectedFiledNames = new ArrayList<String>(10);
        for (BgmReportExportFileRulePlugin.FiledMember filedMember : selectedFiled) {
            if ("fixvalue".equals(filedMember.getFiledNumber())) {
                selectedFiledNames.add(fixvalue);
                continue;
            }
            if (filedMember.getFiledNumber() != null) {
                String replace = filedMember.getFiledNumber().replace("org", "entity");
                filedMember.setFiledNumber(replace);
            }
            selectedFiledNames.add(filedMember.getFiledName());
        }
        Label nameLabel = (Label)this.getControl(namesource);
        if (selectedFiledNames.size() > 0) {
            nameLabel.setText(org.apache.commons.lang3.StringUtils.join(selectedFiledNames, (String)JoinerTypeEnum.getSignByIndex((String)joiner)));
        }
        this.cacheFileNameFormat(namesource, nameFormatInfo);
    }

    private void cacheFileNameFormat(String nameSource, Map<String, Object> nameFormatInfo) {
        this.getView().getPageCache().put(nameSource, SerializationUtils.serializeToBase64(nameFormatInfo));
    }

    private Map<String, Object> getFileNameFormat(String nameSource) {
        String nameFormatInfo = this.getView().getPageCache().get(nameSource);
        if (nameFormatInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u683c\u5f0f\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"BgmReportExportDataPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)nameFormatInfo);
    }

    public Long getModelId() {
        return ((DynamicObject)this.getModel().getValue("model")).getLong("id");
    }

    private void setPageDimEntryEntity(int row) {
        this.getModel().deleteEntryData(PAGEDIM_ENTITY);
        if (row == -1) {
            return;
        }
        try {
            this.cachePageDimMemberMap(row);
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(REPORTPROCESS_ENTITY, row);
        long reportProcessId = entryRowEntity.getLong("reportprocess.id");
        Map<String, String> dimMemberNumberMap = this.getPageDimMemberMap(reportProcessId);
        if (dimMemberNumberMap == null || dimMemberNumberMap.size() == 0) {
            return;
        }
        long templateId = entryRowEntity.getLong("reportprocess.template.id");
        Map dimensionViews = Collections.emptyMap();
        ITemplateModel templateModel = this.getTemplateModel(templateId);
        if (templateModel != null) {
            dimensionViews = templateModel.getDimensionView();
            dimensionViews.put(SysDimensionEnum.Entity.getNumber(), this.getOrgViewId());
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        int[] entryRows = this.getModel().batchCreateNewEntryRow(PAGEDIM_ENTITY, dimMemberNumberMap.size());
        int i = 0;
        for (Map.Entry<String, String> entry : dimMemberNumberMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Dimension dimension = modelCacheHelper.getDimension(key);
            Long viewId = (Long)dimensionViews.get(key);
            Member member = modelCacheHelper.getMember(key, viewId, value);
            this.getModel().setValue("pagedimension", (Object)dimension.getId(), entryRows[i]);
            if (member != null) {
                this.getModel().setValue("pagedimmember", (Object)member.getName(), entryRows[i]);
                this.getModel().setValue("pagedimmembernumber", (Object)member.getNumber(), entryRows[i]);
            }
            this.getView().setEnable(Boolean.valueOf(this.isPageDimMemberEnable(key)), entryRows[i], new String[]{"pagedimmember"});
            ++i;
        }
    }

    private void handleUserRemember() {
        ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            return;
        }
        userRememberController.saveIsDivideCell((Object)this.isDivideCell(), "bgm_reportexport");
        userRememberController.saveIsIncludePageDim((Object)this.isIncludePageDim(), "bgm_reportexport");
        Map<String, Object> filename = this.getFileNameFormat("filename");
        Map<String, Object> sheetname = this.getFileNameFormat("sheetname");
        userRememberController.saveFileNameRemember((Object)SerializationUtils.serializeToBase64(filename), "bgm_reportexport");
        userRememberController.saveSheetNameRemember((Object)SerializationUtils.serializeToBase64(sheetname), "bgm_reportexport");
    }

    private boolean isIncludePageDim() {
        Object checkbox_includepagedim = this.getModel().getValue("isincludepagedim");
        if (checkbox_includepagedim != null) {
            return Boolean.parseBoolean(checkbox_includepagedim.toString());
        }
        return false;
    }

    private boolean isDivideCell() {
        Object isDivideCell = this.getModel().getValue("isdividecell");
        if (isDivideCell != null) {
            return Boolean.parseBoolean(isDivideCell.toString());
        }
        return false;
    }

    private boolean isPageDimMemberEnable(String dimNumber) {
        return !dimNumber.equals(SysDimensionEnum.DataType.getNumber()) && !dimNumber.equals(SysDimensionEnum.Version.getNumber());
    }

    private void exportReportData() {
        try {
            List<ReportExportDataRequest> reportExportDataRequestList = this.createReportExportDataRequestList();
            if (this.errorInfoMap != null && this.errorInfoMap.size() > 0) {
                ArrayList<String> errorInfos = new ArrayList<String>(16);
                for (Map.Entry<String, Set<String>> entry : this.errorInfoMap.entrySet()) {
                    String key = entry.getKey();
                    Set<String> value = entry.getValue();
                    for (String s : value) {
                        errorInfos.add(ResManager.loadResFormat((String)"%1:%2", (String)"BgmReportExportDataPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{s, key}));
                    }
                }
                this.getPageCache().put("reportExportDataRequestList", SerializationUtils.serializeToBase64(reportExportDataRequestList));
                String errorTitle = ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u51fa\u4e2d\u5b58\u5728\u4e0d\u7b26\u5408\u5408\u6cd5\u6027\u6821\u9a8c\u7684\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5bfc\u51fa", (String)"BgmReportExportDataPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(errorTitle, String.join((CharSequence)"\n", errorInfos), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("exportDataConfirm"));
            } else {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exportCloseCallBack");
                Map<String, String> returnTipsMap = reportExportDataController.exportReportData(reportExportDataRequestList, this.getView(), closeCallBack);
                if (returnTipsMap != null) {
                    String success = returnTipsMap.get("success");
                    String failed = returnTipsMap.get("failed");
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)success)) {
                        this.getView().showSuccessNotification(success);
                    } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)failed)) {
                        this.getView().showTipNotification(failed);
                    }
                }
            }
        }
        catch (Exception exception) {
            DynamicObject dynamicObject;
            String exportFileId = this.getPageCache().get("exportfileid");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exportFileId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist")) != null) {
                dynamicObject.set("status", (Object)"2");
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
            log.error(((Object)((Object)this)).getClass().getName());
            log.error((Throwable)exception);
            if (exception instanceof KDBizException) {
                throw new KDBizException(exception.getMessage());
            }
            throw new KDBizException(ThrowableHelper.toString((Exception)exception));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("exportDataConfirm".equals(callBackId) && result == MessageBoxResult.Yes) {
            try {
                String reportExportDataRequestListStr = this.getPageCache().get("reportExportDataRequestList");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reportExportDataRequestListStr)) {
                    List reportExportDataRequestList = (List)SerializationUtils.deSerializeFromBase64((String)reportExportDataRequestListStr);
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exportCloseCallBack");
                    Map<String, String> returnTipsMap = reportExportDataController.exportReportData(reportExportDataRequestList, this.getView(), closeCallBack);
                    if (returnTipsMap != null) {
                        String success = returnTipsMap.get("success");
                        String failed = returnTipsMap.get("failed");
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)success)) {
                            this.getView().showSuccessNotification(success);
                        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)failed)) {
                            this.getView().showTipNotification(failed);
                        }
                    }
                }
            }
            catch (Exception exception) {
                DynamicObject dynamicObject;
                log.error((Throwable)exception);
                String exportFileId = this.getPageCache().get("exportfileid");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exportFileId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist")) != null) {
                    dynamicObject.set("status", (Object)"2");
                    SaveServiceHelper.update((DynamicObject)dynamicObject);
                }
                log.error(((Object)((Object)this)).getClass().getName());
                log.error((Throwable)exception);
                if (exception instanceof KDBizException) {
                    throw new KDBizException(exception.getMessage());
                }
                throw new KDBizException(ThrowableHelper.toString((Exception)exception));
            }
        }
    }

    private Map<Long, Long> getTaskProcessIdMap() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object taskProcessIdMap = formShowParameter.getCustomParam("taskProcessIdMap");
        if (taskProcessIdMap == null) {
            return null;
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)taskProcessIdMap.toString());
    }

    private boolean isExportData() {
        return (Boolean)this.getModel().getValue("isexportdata");
    }

    private Long getSchemeId() {
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeId");
        if (schemeId instanceof Long) {
            return Long.valueOf(schemeId.toString());
        }
        return null;
    }

    private Long getDatasetId() {
        Object dataSetId = this.getView().getFormShowParameter().getCustomParam("dataSetId");
        if (dataSetId instanceof Long) {
            return Long.valueOf(dataSetId.toString());
        }
        return null;
    }

    private List<ReportExportDataRequest> createReportExportDataRequestList() {
        this.errorInfoMap = new HashMap<String, Set<String>>(16);
        Map<Long, Long> taskProcessIdMap = this.getTaskProcessIdMap();
        Object membershowtype = this.getModel().getValue("membershowtype");
        ArrayList<ReportExportDataRequest> reportExportDataRequests = new ArrayList<ReportExportDataRequest>(16);
        Map<Long, Map<String, String>> allPageDimMemberMap = this.getAllPageDimMemberMap();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(REPORTPROCESS_ENTITY);
        int rowIndex = 0;
        ProcessTypeEnum processType = this.getProcessType();
        for (DynamicObject object : entity) {
            long templateId = object.getLong("reportprocess.template.id");
            long reportProcessId = object.getLong("reportprocess.id");
            long taskProcessId = taskProcessIdMap != null ? taskProcessIdMap.get(reportProcessId).longValue() : this.getProcessId().longValue();
            long entityId = object.getLong("reportprocess.entity.id");
            Map<String, String> pageDimMemberMap = allPageDimMemberMap.get(reportProcessId);
            if (pageDimMemberMap == null) {
                try {
                    pageDimMemberMap = this.getDimMemberNumberMap(allPageDimMemberMap, object);
                }
                catch (KDBizException e) {
                    log.error((Throwable)e);
                    String number = object.getString("reportprocess.template.number");
                    String name = object.getString("reportprocess.template.name");
                    Set strings = this.errorInfoMap.computeIfAbsent(e.getMessage(), t -> new HashSet(16));
                    strings.add(name + "\u3010" + number + "\u3011");
                    ++rowIndex;
                    continue;
                }
            }
            ReportExportDataRequest reportExportDataRequest = new ReportExportDataRequest(Long.valueOf(templateId), Long.valueOf(entityId), Long.valueOf(this.getOrgViewId()), Long.valueOf(reportProcessId), Long.valueOf(taskProcessId), processType, this.getModelId(), Boolean.valueOf(this.isDivideCell()), Boolean.valueOf(this.isIncludePageDim()), pageDimMemberMap, this.getName(rowIndex, "filename"), this.getName(rowIndex, "sheetname"), this.getExportTypeEnum(), this.isExportData());
            reportExportDataRequest.setFormId(this.getBizEntityNumber());
            this.removeRelationCache(rowIndex);
            if (membershowtype == null) {
                reportExportDataRequest.setShowDimName(true);
            } else {
                String memberShowTypeStr = membershowtype.toString();
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)(MemberDisplayTypeEnum.NAME.getIndex() + ""), (CharSequence)memberShowTypeStr)) {
                    reportExportDataRequest.setShowDimName(true);
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)(MemberDisplayTypeEnum.NUMBER.getIndex() + ""), (CharSequence)memberShowTypeStr)) {
                    reportExportDataRequest.setShowDimNumber(true);
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)(MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() + ""), (CharSequence)memberShowTypeStr)) {
                    reportExportDataRequest.setShowDimNameNumber(true);
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)(MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() + ""), (CharSequence)memberShowTypeStr)) {
                    reportExportDataRequest.setShowDimSimNameNumber(true);
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)(MemberDisplayTypeEnum.SIMPLENAME.getIndex() + ""), (CharSequence)memberShowTypeStr)) {
                    reportExportDataRequest.setShowSimName(true);
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)(MemberDisplayTypeEnum.LONGNUMBER.getIndex() + ""), (CharSequence)memberShowTypeStr)) {
                    reportExportDataRequest.setShowDimLongNumber(true);
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)(MemberDisplayTypeEnum.LONGNAME.getIndex() + ""), (CharSequence)memberShowTypeStr)) {
                    reportExportDataRequest.setShowDimLongName(true);
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)(MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() + ""), (CharSequence)memberShowTypeStr)) {
                    reportExportDataRequest.setShowDimLongNameNumber(true);
                }
            }
            reportExportDataRequest.setUserId(this.getUserId());
            reportExportDataRequests.add(reportExportDataRequest);
            reportExportDataRequest.setFilterMemberList(this.getFilter());
            ++rowIndex;
        }
        return reportExportDataRequests;
    }

    private List<Map<String, List<MemberCondition>>> getFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterInfo = (String)formShowParameter.getCustomParam("filterInfo");
        if (StringUtils.isNotEmpty((String)filterInfo)) {
            return (List)ObjectSerialUtil.deSerializedBytes((String)filterInfo);
        }
        return null;
    }

    private ReportExportTypeEnum getExportTypeEnum() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object exportType = formShowParameter.getCustomParam("exportType");
        if (exportType == null) {
            return null;
        }
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)exportType.toString(), (CharSequence)ReportExportTypeEnum.EXPORT_DATA.toString()) ? ReportExportTypeEnum.EXPORT_DATA : ReportExportTypeEnum.EXPORT_TEMPLATE;
    }

    private Long getProcessId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("processId"));
    }

    private ProcessTypeEnum getProcessType() {
        return (ProcessTypeEnum)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("processtype")));
    }

    private long getOrgViewId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("orgViewId"));
    }

    private String getName(int rowIndex, String nameSource) {
        Map<String, Object> nameFormat = this.getFileNameFormat(nameSource);
        List selectedFiled = (List)nameFormat.get("selectedFiled");
        String joiner = (String)nameFormat.get("joiner");
        String fixValue = (String)nameFormat.get("fixvalue");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject reportProcess = (DynamicObject)this.getModel().getValue("reportprocess", rowIndex);
        String reportNumber = (String)this.getModel().getValue("reportnumber", rowIndex);
        String reportName = (String)this.getModel().getValue("reportname", rowIndex);
        String orgNumber = reportProcess.getString("entity.number");
        String orgName = reportProcess.getString("entity.name");
        ArrayList<String> names = new ArrayList<String>(10);
        for (BgmReportExportFileRulePlugin.FiledMember filedMember : selectedFiled) {
            String filedNumber = filedMember.getFiledNumber();
            String filedName = "fixvalue".equals(filedNumber) ? fixValue : ("report.number".equals(filedNumber) ? reportNumber : ("report.name".equals(filedNumber) ? reportName : ("entity.number".equals(filedNumber) ? orgNumber : ("entity.name".equals(filedNumber) ? orgName : dataEntity.getString(filedNumber)))));
            names.add(filedName);
        }
        if ("filename".equals(nameSource) && names.size() == 0) {
            ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
            if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
                return ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa", (String)"BgmReportExportDataPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa", (String)"BgmReportExportDataPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return org.apache.commons.lang3.StringUtils.join(names, (String)JoinerTypeEnum.getSignByIndex((String)joiner));
    }

    private ITemplateModel getTemplateModel(Long templateId) {
        return this.getExportHelper().getTemplateModel(templateId);
    }
}

