/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.report.excel.constants.ImportDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.olap.service.OlapReportService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BgmReportImportDataPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BgmReportImportDataPlugin.class);
    private Long modelId = 0L;

    public Long getModelId() {
        String modelIdStr;
        if (this.modelId != 0L) {
            return this.modelId;
        }
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (modelId != null && StringUtils.isNotEmpty((CharSequence)(modelIdStr = modelId.toString())) && !"0".equals(modelIdStr)) {
            this.modelId = Long.valueOf(modelIdStr);
        }
        if (IDUtils.isEmptyLong((Long)this.modelId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgmReportImportDataPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return this.modelId;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            Object maxcell;
            String fileUrl = this.getAttachmentFileUrl();
            if (StringUtils.isEmpty((CharSequence)fileUrl)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"BgmReportImportDataPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Long modelId = this.getModelId();
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection eb_businessmodel = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])filter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)eb_businessmodel)) {
                for (DynamicObject dynamicObject : eb_businessmodel) {
                    OlapReportService.getInstance().checkBindRuleToTemplate(Long.valueOf(dynamicObject.getLong("id")), null);
                }
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            Object timeout = this.getModel().getValue("timeout");
            if (timeout != null) {
                customParams.put("timeout", timeout);
            }
            Object maxsheet = this.getModel().getValue("maxsheet");
            if (timeout != null) {
                customParams.put("maxsheet", maxsheet);
            }
            if ((maxcell = this.getModel().getValue("maxcell")) != null) {
                customParams.put("maxcell", maxcell);
            }
            ImportDataTypeEnum importDataTypeEnum = this.getImportDataTypeEnum();
            customParams.put("importDataType", importDataTypeEnum.getCode());
            map.put("customParams", customParams);
            map.put("fileUrl", fileUrl);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private String getAttachmentFileUrl() {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List attachmentData = panel.getAttachmentData();
        int maxFileCount = 1;
        if (CollectionUtils.isNotEmpty((Collection)attachmentData)) {
            Object maxfile = this.getView().getFormShowParameter().getCustomParam("maxfile");
            if (maxfile == null) {
                maxfile = this.getModel().getValue("maxfile");
            }
            if (maxfile != null) {
                maxFileCount = Math.min(Integer.parseInt(maxfile.toString()), 100);
            }
            if (attachmentData.size() > maxFileCount) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u5bfc\u5165\u4ec5\u5141\u8bb8\u4e0a\u4f20%1\u4e2a\u6587\u4ef6\u3002", (String)"BgmReportImportDataTask_006", (String)"epm-eb-formplugin", (Object[])new Object[]{maxFileCount}));
            }
            List urlList = attachmentData.stream().map(m -> m.get("url").toString()).collect(Collectors.toList());
            return SerializationUtils.toJsonString(urlList);
        }
        return "";
    }

    private ImportDataTypeEnum getImportDataTypeEnum() {
        Object importdatatype = this.getModel().getValue("importdatatype");
        if (importdatatype instanceof String) {
            ImportDataTypeEnum enumByCode = ImportDataTypeEnum.getEnumByCode((String)importdatatype.toString());
            return enumByCode == null ? ImportDataTypeEnum.value_cover_import : enumByCode;
        }
        return ImportDataTypeEnum.value_cover_import;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }
}

