/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.business.userremember.entity.UserRememberEntity;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.report.excel.controller.ExportReportListUserRememberController;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;

public class ExportReportListPlugin
extends AbstractBaseFormPlugin {
    private static final ExportReportListUserRememberController userRememberController = ExportReportListUserRememberController.getInstance();

    public void afterCreateNewData(EventObject e) {
        Long templateId = this.getTemplateId();
        if (IDUtils.isEmptyLong((Long)templateId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ExportReportListPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        QFilter filter = new QFilter("id", "=", (Object)templateId);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        billlistap.setFilterParameter(fp);
        this.setUserRememberValue();
        this.setVisible();
        this.setDefault();
    }

    private void setDefault() {
        this.getModel().setValue("isexportdata", (Object)this.getDefaultIncludeData());
    }

    private boolean getDefaultIncludeData() {
        String billstatus1;
        DynamicObject approvebill;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object billstatus = customParams.get("billstatus");
        Long reportProcessId = this.getReportProcessId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)reportProcessId, (String)"eb_reportprocess");
        if (dynamicObject != null && (approvebill = dynamicObject.getDynamicObject("approvebill")) != null && (StringUtils.equals((String)"B", (String)(billstatus1 = approvebill.getString("billstatus"))) || StringUtils.equals((String)"E", (String)billstatus1))) {
            return true;
        }
        return billstatus != null && (StringUtils.equals((String)"B", (String)billstatus.toString()) || StringUtils.equals((String)"E", (String)billstatus.toString()));
    }

    private void setVisible() {
        ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
        this.getView().setVisible(Boolean.valueOf(ReportExportTypeEnum.EXPORT_DATA == exportTypeEnum), new String[]{"checkbox_isdividecell", "checkbox_includepagedim"});
        this.getView().setVisible(Boolean.valueOf(ReportExportTypeEnum.EXPORT_TEMPLATE == exportTypeEnum), new String[]{"isexportdata"});
    }

    private void setUserRememberValue() {
        ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            return;
        }
        UserRememberEntity userRemember = userRememberController.getIsDivideCell("bgm_exportreportlist");
        if (userRemember == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5408\u5e76\u5355\u5143\u683c\u62c6\u5206\u7684\u7528\u6237\u8bb0\u5fc6\u5931\u8d25\u3002", (String)"ExportReportListPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("checkbox_isdividecell", (Object)userRemember.getValue());
        UserRememberEntity isIncludePageDim = userRememberController.getIsIncludePageDim("bgm_exportreportlist");
        if (isIncludePageDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5305\u542b\u9875\u9762\u7ef4\u7684\u7528\u6237\u8bb0\u5fc6\u5931\u8d25\u3002", (String)"ExportReportListPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("checkbox_includepagedim", (Object)isIncludePageDim.getValue());
    }

    private Long getCurrentOrgId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return IDUtils.toLong((Object)formShowParameter.getCustomParam("entityId"));
    }

    private Long getTemplateId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return IDUtils.toLong((Object)formShowParameter.getCustomParam("templateId"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_export"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((String)"btn_export", (String)clickKey)) {
            this.handleUserRemember();
            List<ReportExportDataRequest> reportExportDataRequests = this.exportReportData();
            this.getView().returnDataToParent(reportExportDataRequests);
            this.getView().close();
        }
    }

    private void handleUserRemember() {
        ReportExportTypeEnum exportTypeEnum = this.getExportTypeEnum();
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            return;
        }
        userRememberController.saveIsDivideCell((Object)this.isDivideCell(), "bgm_exportreportlist");
        userRememberController.saveIsIncludePageDim((Object)this.isIncludePageDim(), "bgm_exportreportlist");
    }

    private List<ReportExportDataRequest> exportReportData() {
        try {
            return this.createReportExportDataRequestList();
        }
        catch (Exception exception) {
            log.error(((Object)((Object)this)).getClass().getName());
            log.error((Throwable)exception);
            if (exception instanceof KDBizException) {
                throw new KDBizException(exception.getMessage());
            }
            throw new KDBizException(ThrowableHelper.toString((Exception)exception));
        }
    }

    private boolean isExportData() {
        return (Boolean)this.getModel().getValue("isexportdata");
    }

    private List<ReportExportDataRequest> createReportExportDataRequestList() {
        IDataEntityProperty MAX_EXPORT_ENTITY_SIZE_Prop;
        IDataEntityProperty MAX_EXPORT_SHEET_SIZE_Prop;
        IDataEntityProperty EXPORT_TIMOUT_Prop;
        ArrayList<ReportExportDataRequest> reportExportDataRequests = new ArrayList<ReportExportDataRequest>(16);
        Map<String, String> defaultDimMemberMap = this.getDefaultDimMemberMap();
        ReportExportDataRequest reportExportDataRequest = new ReportExportDataRequest(this.getTemplateId(), this.getCurrentOrgId(), this.getOrgViewId(), this.getReportProcessId(), this.getProcessId(), this.getProcessTypeEnum(), this.getModelId(), Boolean.valueOf(this.isDivideCell()), Boolean.valueOf(this.isIncludePageDim()), defaultDimMemberMap, this.getDataUnit(), this.getExcelFileName(), this.getExcelSheetName(), this.getExportTypeEnum(), true, this.isExportData());
        reportExportDataRequests.add(reportExportDataRequest);
        reportExportDataRequest.setShowEmptyRow(this.isShowEmptyRow());
        reportExportDataRequest.setShowEmptyCol(this.isShowEmptyCol());
        MemberDisplayTypeEnum showDimType = this.getShowDimType();
        reportExportDataRequest.setShowDimNumber(showDimType == MemberDisplayTypeEnum.NUMBER);
        reportExportDataRequest.setShowDimName(showDimType == MemberDisplayTypeEnum.NAME);
        reportExportDataRequest.setShowDimNameNumber(showDimType == MemberDisplayTypeEnum.NAMEANDNUMBER);
        reportExportDataRequest.setShowDimSimNameNumber(showDimType == MemberDisplayTypeEnum.SIMNAMENUMBER);
        reportExportDataRequest.setShowDimLongName(showDimType == MemberDisplayTypeEnum.LONGNAME);
        reportExportDataRequest.setShowDimLongNumber(showDimType == MemberDisplayTypeEnum.LONGNUMBER);
        reportExportDataRequest.setShowDimLongNameNumber(showDimType == MemberDisplayTypeEnum.LONGNAMENUMBER);
        reportExportDataRequest.setShowSimName(showDimType == MemberDisplayTypeEnum.SIMPLENAME);
        reportExportDataRequest.setFormId(this.getBizEntityNumber());
        reportExportDataRequest.setFilterMemberList(this.getFilter());
        IDataEntityProperty MAX_EXPORT_SIZE_Prop = this.getModel().getProperty("maxexportsize");
        if (MAX_EXPORT_SIZE_Prop != null) {
            Object maxExportSizeObj = this.getModel().getValue("maxexportsize");
            reportExportDataRequest.setMaxExportSize(Integer.parseInt(maxExportSizeObj.toString()));
        }
        if ((EXPORT_TIMOUT_Prop = this.getModel().getProperty("exporttimout")) != null) {
            Object exporttimoutObj = this.getModel().getValue("exporttimout");
            reportExportDataRequest.setExportTimeout(Integer.parseInt(exporttimoutObj.toString()));
        }
        if ((MAX_EXPORT_SHEET_SIZE_Prop = this.getModel().getProperty("maxexportsheet")) != null) {
            Object maxExportSheetSizeObj = this.getModel().getValue("maxexportsheet");
            reportExportDataRequest.setMaxExportSheet(Integer.parseInt(maxExportSheetSizeObj.toString()));
        }
        if ((MAX_EXPORT_ENTITY_SIZE_Prop = this.getModel().getProperty("maxexportentity")) != null) {
            Object maxExportEntitySizeObj = this.getModel().getValue("maxexportentity");
            reportExportDataRequest.setMaxExportEntity(Integer.parseInt(maxExportEntitySizeObj.toString()));
        }
        return reportExportDataRequests;
    }

    private ReportExportTypeEnum getExportTypeEnum() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object exportType = formShowParameter.getCustomParam("exportType");
        if (exportType == null) {
            return null;
        }
        return StringUtils.equals((String)exportType.toString(), (String)ReportExportTypeEnum.EXPORT_DATA.toString()) ? ReportExportTypeEnum.EXPORT_DATA : ReportExportTypeEnum.EXPORT_TEMPLATE;
    }

    private List<Map<String, List<MemberCondition>>> getFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterInfo = (String)formShowParameter.getCustomParam("filterInfo");
        if (StringUtils.isNotEmpty((String)filterInfo)) {
            return (List)ObjectSerialUtil.deSerializedBytes((String)filterInfo);
        }
        return null;
    }

    private MemberDisplayTypeEnum getShowDimType() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object showDimType = formShowParameter.getCustomParam("showDimType");
        if (showDimType == null) {
            return MemberDisplayTypeEnum.NAME;
        }
        int i = Integer.parseInt(showDimType.toString());
        for (MemberDisplayTypeEnum value : MemberDisplayTypeEnum.values()) {
            if (value.index != i) continue;
            return value;
        }
        return MemberDisplayTypeEnum.NAME;
    }

    private boolean isShowEmptyRow() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isShowEmptyRow = formShowParameter.getCustomParam("isShowEmptyRow");
        if (isShowEmptyRow == null) {
            return true;
        }
        return isShowEmptyRow instanceof Boolean ? (Boolean)isShowEmptyRow : false;
    }

    private boolean isShowEmptyCol() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isShowEmptyCol = formShowParameter.getCustomParam("isShowEmptyCol");
        if (isShowEmptyCol == null) {
            return true;
        }
        return StringUtils.equals((String)"true", (String)isShowEmptyCol.toString());
    }

    private ProcessTypeEnum getProcessTypeEnum() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object processType = formShowParameter.getCustomParam("processType");
        if (processType == null) {
            return null;
        }
        String s = String.valueOf(processType);
        for (ProcessTypeEnum value : ProcessTypeEnum.values()) {
            if (!value.getNumber().equals(s)) continue;
            return value;
        }
        return null;
    }

    private Long getOrgViewId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object orgViewId = formShowParameter.getCustomParam("orgViewId");
        if (orgViewId == null) {
            return null;
        }
        return IDUtils.toLong((Object)orgViewId);
    }

    private Integer getDataUnit() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object dataUnit = formShowParameter.getCustomParam("dataUnit");
        if (dataUnit == null) {
            return null;
        }
        return Integer.parseInt(dataUnit.toString());
    }

    private Map<String, String> getDefaultDimMemberMap() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object defaultDimMemberMap = formShowParameter.getCustomParam("defaultDimMemberMap");
        if (defaultDimMemberMap == null) {
            return new HashMap<String, String>(16);
        }
        return (Map)SerializationUtils.fromJsonString((String)defaultDimMemberMap.toString(), HashMap.class);
    }

    private Long getProcessId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object reportProcessIdObj = formShowParameter.getCustomParam("processId");
        return IDUtils.toLong((Object)reportProcessIdObj);
    }

    private Long getReportProcessId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object reportProcessIdObj = formShowParameter.getCustomParam("reportProcessId");
        return IDUtils.toLong((Object)reportProcessIdObj);
    }

    private String getEntityName() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam("entityName");
    }

    private String getTemplateName() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getTemplateId(), (String)"eb_templateentity");
        return dynamicObject == null ? "" : dynamicObject.getString("name");
    }

    private String getVersionName() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam("versionName");
    }

    private String getExcelFileName() {
        return this.getTemplateName() + "_" + this.getEntityName() + "_" + this.getVersionName();
    }

    private String getExcelSheetName() {
        return this.getTemplateName();
    }

    public Long getModelId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return IDUtils.toLong((Object)formShowParameter.getCustomParam("modelId"));
    }

    private boolean isDivideCell() {
        Object isDivideCell = this.getModel().getValue("checkbox_isdividecell");
        if (isDivideCell != null) {
            return Boolean.parseBoolean(isDivideCell.toString());
        }
        return false;
    }

    private boolean isIncludePageDim() {
        Object checkbox_includepagedim = this.getModel().getValue("checkbox_includepagedim");
        if (checkbox_includepagedim != null) {
            return Boolean.parseBoolean(checkbox_includepagedim.toString());
        }
        return false;
    }
}

