/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.report.excel.ExportExceptionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.report.reportview.DynamicReportProcess;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.command.event.CellValueEvent;
import kd.epm.eb.spread.command.stylecontroller.SpreadStyleControlContext;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.control.POISpreadContainer;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.pageviewpanel.PageViewPanelDraw;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIDynamicReportProcess
extends DynamicReportProcess {
    private XSSFWorkbook workbook = null;
    private String fileName = null;
    private String sheetName = null;
    private boolean batchRefreshRows = false;
    private int batchRowSize = 1000;
    private boolean isRefreshData = true;
    private boolean isImportData = false;
    private Long exportLogId;
    private int maxExportSize = 500000;
    private int totalValueSize = 0;
    private Member currentCellMetricMember = null;

    public POIDynamicReportProcess(ISpreadContainer spreadContainer, String sheetName, boolean isRefreshData) {
        this.spreadContainer = spreadContainer;
        this.isRefreshData = isRefreshData;
        this.sheetName = sheetName;
    }

    public POIDynamicReportProcess(Long exportLogId, ISpreadContainer spreadContainer, String sheetName, boolean isRefreshData, int maxExportSize) {
        this.exportLogId = exportLogId;
        this.spreadContainer = spreadContainer;
        this.isRefreshData = isRefreshData;
        this.sheetName = sheetName;
        this.maxExportSize = maxExportSize;
    }

    @Override
    public boolean isImportData() {
        return this.isImportData;
    }

    public void setImportData(boolean importData) {
        this.isImportData = importData;
    }

    public void setWorkbook(XSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isRefreshData() {
        return this.isRefreshData;
    }

    public void setRefreshData(boolean refreshData) {
        this.isRefreshData = refreshData;
    }

    @Override
    public void initialize() {
        this.initService();
    }

    @Override
    protected void beforeResolveStyles() {
        if (!this.isImportData) {
            super.beforeResolveStyles();
        }
    }

    protected void iniControl() {
    }

    @Override
    protected void hideOrShowMenu() {
    }

    protected void setPanelVisible() {
    }

    @Override
    protected void rebuildPageView() {
        ITemplateModel templateModel = this.getTemplateModel();
        this.setCacheVar(templateModel, SpreadTypeEnum.SPREADTYPE_REPORT.getIndex());
        PageViewPanelDraw pageViewPanelDraw = new PageViewPanelDraw(null, templateModel, this.getSpreadManager());
        pageViewPanelDraw.setNeedlockpage(false);
        pageViewPanelDraw.setNeedCheckPerm(true);
        pageViewPanelDraw.setShowHideDim(false);
        pageViewPanelDraw.setDefaultDimMember(this.getDefaultDimMember());
        pageViewPanelDraw.setExtraQfilter(this.getExtraQfilter());
        pageViewPanelDraw.setDrillthrough_key(this.getDrillthrough_key());
        pageViewPanelDraw.build();
    }

    @Override
    protected void firstRefreshData() {
        if (!this.isRefreshData) {
            return;
        }
        this.removeRefreshRows();
        int lastRowIndex = this.getSpreadManager().getEbook().getSheet(0).getRealMaxRows() - 1;
        if (this.isBatchRefreshRows()) {
            for (int i = 0; i < lastRowIndex; i += this.batchRowSize) {
                int endRow = i + this.batchRowSize;
                if (endRow > lastRowIndex) {
                    endRow = lastRowIndex;
                }
                this.refreshCellData(new OlapQuerySync.ViewArea(i, endRow, 0, 50));
            }
        } else {
            this.refreshCellData(new OlapQuerySync.ViewArea(0, lastRowIndex, 0, 50));
        }
        ExportExceptionHelper.getInstance().judgeMaxExportSize(this.totalValueSize, this.maxExportSize);
    }

    @Override
    protected void refreshCellData(OlapQuerySync.ViewArea viewArea) {
        if (!this.isRefreshData) {
            return;
        }
        if (viewArea == null) {
            return;
        }
        Pair<Map<String, Set<CellDimMember>>, Map<String, List<String[]>>> memInfoPair = this.getAllDimensionMembers(viewArea);
        if (memInfoPair != null) {
            Map alldimensionWithMembers = (Map)memInfoPair.p1;
            if (this.allDataIsRefresh || alldimensionWithMembers == null) {
                return;
            }
            OlapQuerySync olapQuerySync = new OlapQuerySync(this.getTemplateModel(), this.getSpreadManager(), this.getspreadContainer(), this.getView().getPageId(), viewArea, this.getRefreshedRows(), alldimensionWithMembers, (Map)memInfoPair.p2, this.getModelCacheHelper());
            olapQuerySync.setRptEntityId(IDUtils.toLong((Object)this.getPageCache().get("current_report_id")));
            olapQuerySync.setProcessId(this.getTaskProcessId());
            olapQuerySync.setProcessType(this.getProcessType());
            Set bizRuleSet = this.getBizRules();
            if (bizRuleSet != null && bizRuleSet.size() > 0) {
                olapQuerySync.setBizRules(bizRuleSet);
            }
            olapQuerySync.setIsRuleExecution(this.isRuleExecution());
            olapQuerySync.setExport(true);
            int dataSize = olapQuerySync.refreshCellData(false);
            this.totalValueSize += dataSize;
        }
        this.cacheRefreshRows(viewArea);
        this.cacheSpreadManager();
    }

    public void cacheSpreadManager() {
    }

    @Override
    public boolean beginSaveReportData() {
        HashMap<String, String> pageViewMemberMap = new HashMap<String, String>(16);
        for (Map.Entry pageviewdim : this.ebSpreadManager.getPageViewDims().entrySet()) {
            pageViewMemberMap.put((String)pageviewdim.getKey(), ((PageViewDimMember)pageviewdim.getValue()).getNumber());
        }
        return this.doSaveReportData(pageViewMemberMap);
    }

    protected void putInSaveDataContext(BgTemplate templateBaseInfo) {
        OlapTraceServiceHelper.setTraceOpInfo((String)templateBaseInfo.getNumber());
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.ReportImport));
    }

    public boolean isBatchRefreshRows() {
        return this.batchRefreshRows;
    }

    public void setBatchRefreshRows(boolean batchRefreshRows) {
        this.batchRefreshRows = batchRefreshRows;
    }

    public int getBatchRowSize() {
        return this.batchRowSize;
    }

    public void setBatchRowSize(int batchRowSize) {
        this.batchRowSize = batchRowSize;
    }

    public ISpreadContainer getspreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new POISpreadContainer(this.workbook, this.fileName, this.sheetName, this.exportLogId);
        }
        return this.spreadContainer;
    }

    public void setSpreadContainer(ISpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public void cellValueUpdate(CellValueEvent cellValueEvent) {
        super.cellValueUpdate(cellValueEvent);
        cellValueEvent.setSetValueNull(false);
    }

    public String getBizEntityNumber() {
        if (StringUtils.isEmpty((String)this.sheetName)) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"POIFixReportProcess_04", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return super.getBizEntityNumber();
    }

    @Override
    public void setFilterMemberMap(List<Map<String, List<MemberCondition>>> filterMemberMap) {
        if (CollectionUtils.isNotEmpty(filterMemberMap)) {
            this.getPageCache().put(this.getProcessId() + "filterMemberCache", ObjectSerialUtil.toByteSerialized(filterMemberMap));
        }
    }

    @Override
    public List<Map<String, List<MemberCondition>>> getFilterWithFilterAndCentralized() {
        String filterInfoStr = this.getPageCache().get(this.getProcessId() + "filterMemberCache");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)filterInfoStr)) {
            return new ArrayList<Map<String, List<MemberCondition>>>(16);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)filterInfoStr);
    }

    public Member getCurrentCellMetricMember() {
        return this.currentCellMetricMember;
    }

    public void afterEnumSpreadF7LookUpData(Member metricMember) {
        super.afterEnumSpreadF7LookUpData(metricMember);
        this.currentCellMetricMember = metricMember;
    }

    @Override
    protected void setEnumStyle() {
        SpreadStyleControlContext spreadStyleControlContext = this.getSpreadStyleControlContext();
        if (spreadStyleControlContext == null) {
            return;
        }
        if (spreadStyleControlContext.getRowEnumCells().size() > 0) {
            this.getspreadContainer().setFListCellsByRow(spreadStyleControlContext.getRowEnumCells(), true, true);
        }
        if (spreadStyleControlContext.getColEnumCells().size() > 0) {
            this.getspreadContainer().setFListCellsByCol(spreadStyleControlContext.getColEnumCells(), true, true);
        }
    }
}

