/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.olapdao.FloatRows;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.report.excel.ExportExceptionHelper;
import kd.epm.eb.common.report.excel.exception.KDEpmExportCancelException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportMaxException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportTimeoutException;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.formplugin.report.excel.helper.ExportTemplateHelper;
import kd.epm.eb.formplugin.report.reportview.FixReportProcess;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.command.event.CellValueEvent;
import kd.epm.eb.spread.command.stylecontroller.FixSpreadStyleControlContext;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.control.POISpreadContainer;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.pageviewpanel.PageViewPanelDraw;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.utils.AutoFloatHelper;
import kd.epm.eb.spread.utils.ReportDimFilterUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIFixReportProcess
extends FixReportProcess {
    private static final Log log = LogFactory.getLog(FixReportProcess.class);
    private XSSFWorkbook workbook = null;
    private String fileName = null;
    private String sheetName;
    private static final int MAX_REFRESH_ROWS = 500000;
    private boolean batchRefreshRows = true;
    private int batchRowSize = 1000;
    private boolean isRefreshData;
    private ReportExportTypeEnum exportTypeEnum;
    private Long exportLogId;
    private int maxExportSize = 500000;
    private boolean includePageDim = false;
    private ReportExportDataRequest request;
    private boolean isImportData = false;
    private Member currentCellMetricMember = null;

    public POIFixReportProcess(ISpreadContainer spreadContainer, String sheetName, ReportExportTypeEnum exportTypeEnum, boolean isRefreshData) {
        this.spreadContainer = spreadContainer;
        this.isRefreshData = isRefreshData;
        this.sheetName = sheetName;
        this.exportTypeEnum = exportTypeEnum;
    }

    public POIFixReportProcess(Long exportLogId, ISpreadContainer spreadContainer, boolean isRefreshData, ReportExportDataRequest request, int maxExportSize) {
        this.exportLogId = exportLogId;
        this.spreadContainer = spreadContainer;
        this.isRefreshData = isRefreshData;
        this.sheetName = request.getSheetName();
        this.exportTypeEnum = request.getExportTypeEnum();
        this.includePageDim = request.getIncludePageDim();
        this.request = request;
        this.maxExportSize = maxExportSize > 0 ? maxExportSize : (Integer)CommonUtils.getMetaDataFieldDefaultValue((String)"bgm_reportexport", (String)"maxexportsize", () -> 500000);
        log.info("ExportParam maxExportSize:{}", (Object)this.maxExportSize);
    }

    public void setImportData(boolean importData) {
        this.isImportData = importData;
    }

    public void setSpreadContainer(ISpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
    }

    public ReportExportTypeEnum getExportTypeEnum() {
        return this.exportTypeEnum;
    }

    public void setExportTypeEnum(ReportExportTypeEnum exportTypeEnum) {
        this.exportTypeEnum = exportTypeEnum;
    }

    public boolean isRefreshData() {
        return this.isRefreshData;
    }

    public void setRefreshData(boolean refreshData) {
        this.isRefreshData = refreshData;
    }

    protected void rebuildPageView() {
        ITemplateModel templateModel = this.getTemplateModel();
        this.setCacheVar(templateModel, SpreadTypeEnum.SPREADTYPE_REPORT.getIndex());
        PageViewPanelDraw pageViewPanelDraw = new PageViewPanelDraw(null, templateModel, this.getSpreadManager());
        pageViewPanelDraw.setNeedlockpage(false);
        pageViewPanelDraw.setShowHideDim(false);
        pageViewPanelDraw.setDefaultDimMember(this.getDefaultDimMember());
        pageViewPanelDraw.setExtraQfilter(this.getExtraQfilter());
        pageViewPanelDraw.setDrillthrough_key(this.getDrillthrough_key());
        pageViewPanelDraw.build();
    }

    @Override
    protected void invokeSpreadJson() {
        String serial;
        boolean rebuildWithPreviewData = false;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_exportinfo", (String)"spreadserial", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)this.getTemplateModel().getTemplateBaseInfo().getId())});
        if (dynamicObject != null && StringUtils.isNotEmpty((CharSequence)(serial = dynamicObject.getString("spreadserial")))) {
            rebuildWithPreviewData = true;
            this.getspreadContainer().rebuildSpread(serial);
            super.invokeDeleteRowCol(false);
        }
        if (!rebuildWithPreviewData) {
            super.invokeSpreadJson();
        }
        if (this.includePageDim || this.exportTypeEnum == ReportExportTypeEnum.EXPORT_BY_ORG) {
            this.preparePageRow();
        } else if (this.exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            this.prepareTemplateRow();
        }
        this.rebuildFormulaCell();
    }

    private void rebuildFormulaCell() {
        Map formulaMap = this.getSpreadManager().getFormulaMap();
        if (MapUtils.isNotEmpty((Map)formulaMap)) {
            String moveRowCountStr = this.getPageCache().get("TEMPLATE_MOVE_ROW_COUNT");
            int rowMoveCount = StringUtils.isBlank((CharSequence)moveRowCountStr) ? 0 : Integer.parseInt(moveRowCountStr);
            String moveColCountStr = this.getPageCache().get("TEMPLATE_MOVE_COL_COUNT");
            int colMoveCount = StringUtils.isBlank((CharSequence)moveColCountStr) ? 0 : Integer.parseInt(moveColCountStr);
            HashMap newFormulaMap = new HashMap(formulaMap.size());
            formulaMap.forEach((key, value) -> {
                RangeModel rangeModel = new RangeModel(key);
                int newRow = rangeModel.getYStart() + rowMoveCount;
                int newCol = rangeModel.getXStart() + colMoveCount;
                String point = ExcelUtils.xy2Pos((int)newCol, (int)newRow);
                newFormulaMap.put(point + ":" + point, value);
            });
            formulaMap.clear();
            formulaMap.putAll(newFormulaMap);
        }
    }

    private void preparePageRow() {
        if (!this.isPOISpreadContainer()) {
            return;
        }
        POISpreadContainer poiSpreadContainer = (POISpreadContainer)this.spreadContainer;
        XSSFWorkbook workbook = poiSpreadContainer.getWorkbook();
        Sheet sheet = workbook.getSheetAt(0);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        int lastRowNum = sheet.getLastRowNum();
        ExportTemplateHelper exportTemplateHelper = new ExportTemplateHelper(poiSpreadContainer);
        exportTemplateHelper.moveDownRow(sheet, 0, lastRowNum, 2);
        this.getPageCache().put("TEMPLATE_MOVE_ROW_COUNT", "2");
        this.getPageCache().put("TEMPLATE_MOVE_COL_COUNT", "0");
        this.getSpreadManager().getMultiAreaManager().forEach(multiAreaManager -> {
            RangeModel areaRange = multiAreaManager.getAreaRange();
            areaRange.setY_start(areaRange.getY_start() + 2);
            areaRange.setY_end(areaRange.getY_end() + 2);
        });
    }

    private void prepareTemplateRow() {
        if (!this.isPOISpreadContainer()) {
            return;
        }
        POISpreadContainer poiSpreadContainer = (POISpreadContainer)this.spreadContainer;
        XSSFWorkbook workbook = poiSpreadContainer.getWorkbook();
        Sheet sheet = workbook.getSheetAt(0);
        boolean isIncludeFilter = false;
        if (CollectionUtils.isNotEmpty((Collection)this.request.getFilterMemberList())) {
            Map stringListMap;
            List filterMemberList = this.request.getFilterMemberList();
            if (filterMemberList.size() >= 2) {
                isIncludeFilter = true;
            } else if (filterMemberList.size() == 1 && (stringListMap = (Map)filterMemberList.get(0)).size() > 1 && stringListMap.containsKey("templateFilter")) {
                isIncludeFilter = true;
            }
        }
        ExportTemplateHelper exportTemplateHelper = new ExportTemplateHelper(poiSpreadContainer);
        int moveCount = exportTemplateHelper.setTemplateInfo(sheet, this.templateModel, isIncludeFilter);
        this.getPageCache().put("TEMPLATE_MOVE_ROW_COUNT", String.valueOf(moveCount));
        this.getPageCache().put("TEMPLATE_MOVE_COL_COUNT", String.valueOf(1));
        this.getSpreadManager().getMultiAreaManager().forEach(multiAreaManager -> {
            RangeModel areaRange = multiAreaManager.getAreaRange();
            areaRange.setY_start(areaRange.getY_start() + moveCount);
            areaRange.setY_end(areaRange.getY_end() + moveCount);
            areaRange.setX_start(areaRange.getX_start() + 1);
            areaRange.setX_end(areaRange.getX_end() + 1);
        });
    }

    @Override
    protected void resolveSpreadLock() {
        if (!this.isImportData) {
            super.resolveSpreadLock();
        }
    }

    @Override
    protected void afterResolveStyles() {
        this.getPageCache().put("isExport", "true");
        super.afterResolveStyles();
        this.getPageCache().remove("isExport");
    }

    @Override
    public void setCellStyles() {
        ArrayList<ISpreadStyleControl> spreadStyleControls = new ArrayList<ISpreadStyleControl>(16);
        this.resolveSpreadStyleController(spreadStyleControls);
        FixSpreadStyleControlContext spreadStyleControlContext = this.getFixSpreadStyleControlContext();
        spreadStyleControlContext.setFormView(this.getView());
        spreadStyleControls.forEach(stylecontrol -> stylecontrol.controlFix(spreadStyleControlContext));
        if (spreadStyleControlContext.getAreasStyles().size() > 0) {
            this.getspreadContainer().setCellStyle(spreadStyleControlContext.getAreasStyles());
        }
        if (spreadStyleControlContext.getRowEnumCells().size() > 0) {
            this.getspreadContainer().setFListCellsByRow(spreadStyleControlContext.getRowEnumCells(), true, true);
        }
        if (spreadStyleControlContext.getColEnumCells().size() > 0) {
            this.getspreadContainer().setFListCellsByCol(spreadStyleControlContext.getColEnumCells(), true, true);
        }
    }

    @Override
    protected void firstRefreshData() {
        if (!this.isRefreshData) {
            return;
        }
        try {
            OlapQuerySync olapQuerySync = new OlapQuerySync(this.getTemplateModel(), this.getSpreadManager(), this.getspreadContainer(), this.getModelCacheHelper());
            olapQuerySync.setProcessId(this.getTaskProcessId());
            olapQuerySync.setProcessType(this.getProcessType());
            Member orgMember = this.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), IDUtils.toLong((Object)this.getCurrentEntityViewId()), this.getCurrentEntityNumber());
            if (orgMember != null) {
                olapQuerySync.setCurrentOrgLongNumber(orgMember.getLongNumber());
                olapQuerySync.setCurrentOrgNumber(orgMember.getNumber());
                this.setCurrentEntityLongNumber(orgMember.getLongNumber());
            }
            List<Map<String, List<MemberCondition>>> filterMemberList = this.getFilterWithFilterAndCentralized();
            ArrayList filterMemberNumberList = new ArrayList(filterMemberList.size());
            if (CollectionUtils.isNotEmpty(filterMemberList)) {
                MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getTemplateModel().getModelId());
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getTemplateModel().getModelId());
                Long bizModel = this.getTemplateModel().getTemplateBaseInfo().getBizModel();
                ReportDimFilterUtils.resolveFilterMember(filterMemberList, (MemberPropCache)memberPropCache, (IModelCacheHelper)modelCacheHelper, filterMemberNumberList, (Long)bizModel, (String)this.getCurrentEntityNumber());
            }
            if (CollectionUtils.isNotEmpty(filterMemberNumberList)) {
                olapQuerySync.setFilterMemberNumberList(filterMemberNumberList);
            }
            List floatRows = olapQuerySync.onlyQueryFloatMembers();
            List multiAreaManager = this.getSpreadManager().getMultiAreaManager();
            if (CollectionUtils.isNotEmpty(filterMemberNumberList) && CollectionUtils.isNotEmpty((Collection)floatRows)) {
                for (FloatRows floatRow : floatRows) {
                    MultiAreaManager multiAreaManager1;
                    List rowpartitionDims;
                    Optional<MultiAreaManager> multiAreaManagerFind = multiAreaManager.stream().filter(x -> x.getAreaIndex().equals(floatRow.getNumber())).findFirst();
                    if (CollectionUtils.isEmpty((Collection)floatRow.getFloatRows()) || !multiAreaManagerFind.isPresent() || CollectionUtils.isEmpty((Collection)(rowpartitionDims = (multiAreaManager1 = multiAreaManagerFind.get()).getRowpartitionDims()))) continue;
                    ArrayList<Map> needFilterCollection = new ArrayList<Map>(16);
                    for (Map filter : filterMemberNumberList) {
                        Set keys = filter.keySet();
                        if (keys.size() == 0) continue;
                        keys.retainAll(rowpartitionDims);
                        if (keys.size() != filter.size()) continue;
                        needFilterCollection.add(filter);
                    }
                    if (CollectionUtils.isEmpty(needFilterCollection)) continue;
                    List floatRows1 = floatRow.getFloatRows();
                    Iterator iterator = floatRows1.iterator();
                    while (iterator.hasNext()) {
                        FloatRows.FloatRow next = (FloatRows.FloatRow)iterator.next();
                        HashSet<Boolean> needRemove = new HashSet<Boolean>(needFilterCollection.size());
                        for (Map filterMap : needFilterCollection) {
                            boolean oneFilterNeedRemove = Boolean.FALSE;
                            for (int i = 0; i < floatRow.getFloatDims().size(); ++i) {
                                String dimnumber = (String)floatRow.getFloatDims().get(i);
                                if (!rowpartitionDims.contains(dimnumber)) continue;
                                Set filterMembers = (Set)filterMap.get(dimnumber);
                                String member = (String)next.getColItems().get(i);
                                if (CollectionUtils.isEmpty((Collection)filterMembers) || filterMembers.contains(member)) continue;
                                oneFilterNeedRemove = Boolean.TRUE;
                                break;
                            }
                            needRemove.add(oneFilterNeedRemove);
                        }
                        if (needRemove.contains(Boolean.FALSE)) continue;
                        iterator.remove();
                    }
                }
            }
            this.sortFloatRows(floatRows);
            this.setRowSeqAndRowForamt(floatRows);
            this.judgeMaxExportSize(floatRows, multiAreaManager);
            this.refreshFloatMembers(new OlapQuerySync.ViewArea(0, 500000, 0, 50), floatRows);
            this.removeRefreshRows();
            if (this.isBatchRefreshRows()) {
                int index = 0;
                for (int i = 0; i < 500000; i += this.batchRowSize) {
                    if (index++ % 1000 == 0) {
                        ExportExceptionHelper.getInstance().judgeExportCancel(this.exportLogId);
                    }
                    this.refreshCellData(new OlapQuerySync.ViewArea(i, i + this.batchRowSize, 0, 50), null);
                }
            } else {
                this.refreshCellData(new OlapQuerySync.ViewArea(0, 500000, 0, 50), null);
            }
        }
        catch (Exception e) {
            if (e instanceof KDEpmExportMaxException || e instanceof KDEpmExportCancelException || e instanceof KDEpmExportTimeoutException) {
                throw e;
            }
            if (e instanceof KDBizException) {
                throw new KDBizException(e.getMessage());
            }
            log.error("POIFixReportProcess firstRefreshData:" + e.getMessage(), (Throwable)e);
            String errorInfo = e.getMessage();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)errorInfo)) {
                errorInfo = ThrowableHelper.toString((Exception)e);
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u5bfc\u51fa\u6570\u636e\u67e5\u8be2\u591a\u7ef4\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%2\u3002", (String)"POIFixReportProcess_01", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getTemplateModel().getTemplateBaseInfo().getName(), errorInfo}));
        }
    }

    private void judgeMaxExportSize(List<FloatRows> floatRows, List<MultiAreaManager> multiAreaManager) {
        if (CollectionUtils.isNotEmpty(floatRows)) {
            int totalCellSize = 0;
            for (FloatRows floatRow : floatRows) {
                MultiAreaManager areaManager;
                Optional<MultiAreaManager> multiAreaManagerFind = multiAreaManager.stream().filter(x -> x.getAreaIndex().equals(floatRow.getNumber())).findFirst();
                if (CollectionUtils.isEmpty((Collection)floatRow.getFloatRows()) || CollectionUtils.isEmpty((Collection)floatRow.getFloatDims()) || !multiAreaManagerFind.isPresent() || CollectionUtils.isEmpty((Collection)(areaManager = multiAreaManagerFind.get()).getColpartitionDimMems())) continue;
                int rowCount = floatRow.getFloatRows().size();
                int floatCellCount = floatRow.getFloatDims().size() * rowCount;
                int dataCellCount = areaManager.getColpartitionDimMems().size() * rowCount;
                totalCellSize += floatCellCount + dataCellCount;
            }
            ExportExceptionHelper.getInstance().judgeMaxExportSize(totalCellSize, this.maxExportSize);
        }
    }

    @Override
    protected void refreshFloatMembers(OlapQuerySync.ViewArea viewArea, List<FloatRows> floatRows) {
        if (!this.isRefreshData) {
            return;
        }
        if (!this.getSpreadManager().isHasFloat()) {
            return;
        }
        if (floatRows != null && !floatRows.isEmpty()) {
            AutoFloatHelper autoFloatHelper = new AutoFloatHelper(this.getView(), this.getSpreadManager(), this.getspreadContainer(), this.getTemplateModel(), false, true);
            autoFloatHelper.setMemberDisplayType(this.getMemberDisplayType());
            String areaOverLap = "onlyone";
            if (this.getTemplateModel().getAreaRanges().size() > 1) {
                areaOverLap = FixTemplateProcessHelper.checkRowColOverlapOnAreas(this.getTemplateModel().getAreaRanges());
            }
            autoFloatHelper.setAreaOverLap(areaOverLap);
            autoFloatHelper.setCurrentEntityMember(this.getCurrentEntityNumber());
            int rows = viewArea.getEndrow() - viewArea.getStartrow();
            autoFloatHelper.autoFloatByMember(floatRows, rows, true);
            this.cacheSpreadManager();
            Set<Integer> needHiddenByTemplateFilter = this.hiddenByTemplateFilter(floatRows, viewArea);
            if (CollectionUtils.isNotEmpty(needHiddenByTemplateFilter)) {
                CommonServiceHelper.handleLog((Log)log, (String)"needHiddenByTemplateFilter", (String)JSONUtils.toString(needHiddenByTemplateFilter));
                this.getspreadContainer().setRowsVisible(new ArrayList<Integer>(needHiddenByTemplateFilter), false);
            }
        }
    }

    @Override
    protected void refreshCellData(OlapQuerySync.ViewArea viewArea, List<FloatRows> floatRows) {
        Map allDimMems;
        if (!this.isRefreshData) {
            return;
        }
        if (viewArea == null || this.getTemplateModel() == null || this.getTemplateModel().getAreaRanges() == null || this.getTemplateModel().getAreaRanges().isEmpty()) {
            return;
        }
        this.refreshFloatMembers(viewArea, floatRows);
        Pair<Map<String, Set<CellDimMember>>, Map<String, List<String[]>>> memInfoPair = this.getAllDimensionMembers(viewArea);
        if (memInfoPair != null && (allDimMems = (Map)memInfoPair.p1) != null && allDimMems.size() > 0) {
            OlapQuerySync olapQuerySync = new OlapQuerySync(this.getTemplateModel(), this.getSpreadManager(), this.getspreadContainer(), this.getView().getPageId(), viewArea, this.getRefreshedRows(), allDimMems, (Map)memInfoPair.p2, this.getModelCacheHelper());
            olapQuerySync.setRptEntityId(IDUtils.toLong((Object)this.getPageCache().get("current_report_id")));
            olapQuerySync.setProcessId(this.getTaskProcessId());
            olapQuerySync.setProcessType(this.getProcessType());
            Set bizRuleSet = this.getBizRules();
            if (bizRuleSet != null && bizRuleSet.size() > 0) {
                olapQuerySync.setBizRules(bizRuleSet);
            }
            olapQuerySync.setIsRuleExecution(this.isRuleExecution());
            olapQuerySync.setExport(true);
            Counter counter = new Counter();
            Map datas = olapQuerySync.onlyQueryData(counter, false);
            olapQuerySync.refreshFixCellData(datas, counter);
            this.cacheSpreadManager();
        }
    }

    @Override
    protected boolean outsideViewArea(Set<Integer> refreshedRows, int row, int relatedRow) {
        return relatedRow < 0;
    }

    @Override
    public boolean isExportTemplate() {
        return this.exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE;
    }

    @Override
    public boolean isImportData() {
        return this.isImportData;
    }

    @Override
    public void setRowColMemberForExportTemplate(Member member, ECell c, String memNumber) {
        if (member != null) {
            c.setValue((Object)member.getName());
        }
    }

    protected void setPanelVisible() {
    }

    protected void iniControl() {
    }

    @Override
    protected void hideOrShowMenu() {
    }

    @Override
    public IEbSpreadManager getSpreadManager() {
        if (this.ebSpreadManager != null) {
            return this.ebSpreadManager;
        }
        String serial = this.getPageCache().get("spread_mananger_cache_key");
        if (StringUtils.isNotEmpty((CharSequence)serial) && serial.contains("areaManager")) {
            this.ebSpreadManager = FixSpreadManagerSerializerUtil.read((String)serial);
        }
        return this.ebSpreadManager;
    }

    @Override
    public void cacheSpreadManager() {
    }

    public void cacheSpreadSelector() {
    }

    @Override
    public boolean beginSaveReportData() {
        IEbSpreadManager ebSpreadManager = this.getSpreadManager();
        HashMap<String, String> pageViewMemberMap = new HashMap<String, String>(16);
        for (Map.Entry pageviewdim : ebSpreadManager.getPageViewDims().entrySet()) {
            pageViewMemberMap.put((String)pageviewdim.getKey(), ((PageViewDimMember)pageviewdim.getValue()).getNumber());
        }
        return this.doSaveReportData(pageViewMemberMap);
    }

    public boolean isBatchRefreshRows() {
        return this.batchRefreshRows;
    }

    public void setBatchRefreshRows(boolean batchRefreshRows) {
        this.batchRefreshRows = batchRefreshRows;
    }

    public int getBatchRowSize() {
        return this.batchRowSize;
    }

    public void setBatchRowSize(int batchRowSize) {
        this.batchRowSize = batchRowSize;
    }

    public ISpreadContainer getspreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new POISpreadContainer(this.workbook, this.fileName, this.sheetName, this.exportLogId);
        }
        return this.spreadContainer;
    }

    private boolean isPOISpreadContainer() {
        return this.getspreadContainer() instanceof POISpreadContainer;
    }

    @Override
    protected boolean backFloatF7Scopes(String dimNumber, MemberF7Parameter f7Param, Set<Long> seletedIds, boolean isQuickAddNew) {
        if (this.isPOISpreadContainer()) {
            ((POISpreadContainer)this.spreadContainer).getOperateMaps().put("backFloatF7Scopes", this.getF7Result(dimNumber, f7Param));
        }
        return false;
    }

    public Boolean checkDimNeedRelationFilter(String dim) {
        if (this.isImportData) {
            return Boolean.FALSE;
        }
        return super.checkDimNeedRelationFilter(dim);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(XSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public void cellValueUpdate(CellValueEvent cellValueEvent) {
        super.cellValueUpdate(cellValueEvent);
        cellValueEvent.setSetValueNull(false);
    }

    public String getBizEntityNumber() {
        if (this.exportTypeEnum == null) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"POIFixReportProcess_04", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return super.getBizEntityNumber();
    }

    @Override
    public void setFilterMemberMap(List<Map<String, List<MemberCondition>>> filterMemberMap) {
        if (CollectionUtils.isNotEmpty(filterMemberMap)) {
            this.getPageCache().put(this.getProcessId() + "filterMemberCache", ObjectSerialUtil.toByteSerialized(filterMemberMap));
        }
    }

    @Override
    public void handleFilterHidden(List<Map<String, List<MemberCondition>>> filterMemberList) {
        super.handleFilterHidden(filterMemberList);
    }

    @Override
    public List<Map<String, List<MemberCondition>>> getFilterWithFilterAndCentralized() {
        String filterInfoStr = this.getPageCache().get(this.getProcessId() + "filterMemberCache");
        if (StringUtils.isEmpty((CharSequence)filterInfoStr)) {
            return new ArrayList<Map<String, List<MemberCondition>>>(16);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)filterInfoStr);
    }

    public Member getCurrentCellMetricMember() {
        return this.currentCellMetricMember;
    }

    public void afterEnumSpreadF7LookUpData(Member metricMember) {
        super.afterEnumSpreadF7LookUpData(metricMember);
        this.currentCellMetricMember = metricMember;
    }

    protected void putInSaveDataContext(BgTemplate templateBaseInfo) {
        OlapTraceServiceHelper.setTraceOpInfo((String)templateBaseInfo.getNumber());
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.ReportImport));
    }

    @Override
    protected void replaceFormulaCellValue(int displayTypeIndex) {
        super.replaceFormulaCellValue(displayTypeIndex);
        Map formulaMap = this.getSpreadManager().getFormulaMap();
        if (formulaMap != null && formulaMap.size() > 0) {
            if (!this.isPOISpreadContainer()) {
                return;
            }
            POISpreadContainer poiSpreadContainer = (POISpreadContainer)this.getspreadContainer();
            Map formulaCellsMap = poiSpreadContainer.getFormulaCellsMap();
            if (formulaCellsMap != null && formulaCellsMap.size() > 0) {
                XSSFFormulaEvaluator evaluator = poiSpreadContainer.getWorkbook().getCreationHelper().createFormulaEvaluator();
                for (Map.Entry entry : formulaCellsMap.entrySet()) {
                    XSSFCell cell1;
                    XSSFRow row;
                    String key = (String)entry.getKey();
                    String[] split = key.split(":");
                    if (split.length != 2 || (row = poiSpreadContainer.getSheet().getRow(Integer.parseInt(split[0]))) == null || (cell1 = row.getCell(Integer.parseInt(split[1]))) == null || cell1.getCellType() != CellType.FORMULA) continue;
                    evaluator.evaluateFormulaCell((Cell)cell1);
                }
            }
        }
    }
}

