/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.command;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.report.excel.POIDynamicReportProcess;
import kd.epm.eb.formplugin.report.excel.POIFixReportProcess;
import kd.epm.eb.formplugin.report.excel.command.ExportHelper;
import kd.epm.eb.formplugin.report.excel.helper.ExportTemplateHelper;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportHelper;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.control.DataSpreadContainer;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportTaskRequest;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.utils.ReportDimFilterUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class DataExportCommand {
    private static final Log log = LogFactory.getLog(DataExportCommand.class);
    private final ReportExportTaskRequest reportExportTaskRequest;
    private final Map<Long, Map<Integer, String>> floatRowRangeMap;
    private final IFormView formView;
    private final IPageCache pageCache;

    public DataExportCommand(ReportExportTaskRequest reportExportTaskRequest) {
        IFormView view;
        this.formView = view = this.initFormView();
        this.pageCache = view.getPageCache();
        this.reportExportTaskRequest = reportExportTaskRequest;
        this.floatRowRangeMap = new HashMap<Long, Map<Integer, String>>(16);
    }

    public final IFormView initFormView() {
        String formId = "bgm_exportbyorg";
        String pageId = UUID.randomUUID() + "";
        FormShowParameter params = new FormShowParameter();
        params.setPageId(pageId);
        params.setAppId("bgm");
        params.setFormId(formId);
        params.setCacheExpireTime(System.currentTimeMillis() - 3600000L);
        FormConfig cfg = new FormConfig();
        cfg.setEntityTypeId(formId);
        params.setFormConfig(cfg);
        FormView fv = new FormView();
        fv.addService(IPageCache.class, (Object)new PageCache(pageId));
        fv.initialize(params);
        IFormController srv = (IFormController)fv.getService(IFormController.class);
        try {
            MethodUtils.invokeMethod((Object)srv, (String)"loadData", (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("POIExportCommand:MethodUtils.invokeMethod error:");
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return fv;
    }

    public Map<Long, Map<String, Object>> getReportData() {
        HashMap<Long, Map<String, Object>> reportDataMap = new HashMap<Long, Map<String, Object>>(16);
        if (this.reportExportTaskRequest == null || CollectionUtils.isEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
            return reportDataMap;
        }
        ReportExportDataRequest reportExportDataRequest = (ReportExportDataRequest)this.reportExportTaskRequest.getExportDataRequests().get(0);
        Long modelId = reportExportDataRequest.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        log.info("exportCommand:modelId:" + modelId);
        try {
            for (ReportExportDataRequest request : this.reportExportTaskRequest.getExportDataRequests()) {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"period, datatype, version", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)request.getProcessId())});
                if (dynamicObject == null) continue;
                long periodId = dynamicObject.getLong("period");
                long dataTypeId = dynamicObject.getLong("datatype");
                long versionId = dynamicObject.getLong("version");
                request.setPeriodId(Long.valueOf(periodId));
                request.setDataTypeId(Long.valueOf(dataTypeId));
                request.setVersionId(Long.valueOf(versionId));
                Map<Long, Map<String, Object>> templateDataMap = this.doExportRequest(request, modelCache);
                if (!MapUtils.isNotEmpty(templateDataMap)) continue;
                reportDataMap.putAll(templateDataMap);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return reportDataMap;
    }

    private Map<Long, Map<String, Object>> doExportRequest(ReportExportDataRequest request, IModelCacheHelper modelCacheHelper) {
        AbstractReportPlugin abstractReportPlugin;
        log.info("---begin export doExportRequest");
        this.cacheContextParam(request);
        ITemplateModel templateModel = ExportHelper.buildTemplateModel((DynamicObject)ExportHelper.queryTemplateDynamicObj((Long)request.getTemplateId()), (IPageCache)this.pageCache, (Long)request.getEntityViewId());
        templateModel.setModelId(request.getModelId());
        if (request.getDataUnit() != null) {
            templateModel.getTemplateBaseInfo().setDataunit(request.getDataUnit() + "");
        }
        DataSpreadContainer spreadContainer = new DataSpreadContainer();
        try {
            log.info("export initReportPlugin begin.");
            abstractReportPlugin = this.initReportPlugin(request, templateModel, modelCacheHelper, (ISpreadContainer)spreadContainer, true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        this.buildFloatAreaRow(request.getTemplateId(), abstractReportPlugin);
        return ImmutableMap.of((Object)request.getTemplateId(), (Object)spreadContainer.getDataMap());
    }

    private void cacheContextParam(ReportExportDataRequest request) {
        this.pageCache.put("current_org", request.getEntityId() + "");
        this.pageCache.put("current_rpt", request.getTemplateId() + "");
        this.pageCache.put("current_rpt_type", request.getProcessType().getNumber());
        this.pageCache.put("current_processid", request.getReportProcessId() + "");
        this.pageCache.put("current_report_id", request.getProcessId() + "");
    }

    private AbstractReportPlugin initReportPlugin(ReportExportDataRequest request, ITemplateModel templateModel, IModelCacheHelper modelCacheHelper, ISpreadContainer spreadContainer, boolean isRefreshData) {
        Member orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), request.getEntityViewId(), request.getEntityId());
        if (orgMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5728\u7ec4\u7ec7\u89c6\u56fe\u201c%1\u201d\u91cc\u627e\u4e0d\u5230\u7ec4\u7ec7\u201c%2\u201d\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{request.getEntityViewId(), request.getEntityId()}));
        }
        boolean isFixReport = BgTemplateTypeEnum.EBFIX.getNumber().equals(String.valueOf(templateModel.getTemplateBaseInfo().getTemplatetype()));
        Long exportLogId = this.reportExportTaskRequest.getExportLogId();
        AbstractReportPlugin abstractReportPlugin = isFixReport ? new POIFixReportProcess(exportLogId, spreadContainer, isRefreshData, request, 0) : new POIDynamicReportProcess(exportLogId, spreadContainer, request.getSheetName(), isRefreshData, 500000);
        abstractReportPlugin.setView(this.formView);
        abstractReportPlugin.initialize();
        abstractReportPlugin.setProcessId(request.getProcessId());
        abstractReportPlugin.setTaskProcessId(request.getReportProcessId());
        abstractReportPlugin.setProcessType(request.getProcessType().getNumber());
        abstractReportPlugin.setTemplateModel(templateModel);
        templateModel = ExportHelper.setDefaultPageDimMapToTemplateModel((Map)request.getDefaultDimMemberMap(), (ITemplateModel)templateModel, (IModelCacheHelper)modelCacheHelper);
        Map dimensionView = templateModel.getDimensionView();
        dimensionView.put(SysDimensionEnum.Entity.getNumber(), request.getEntityViewId());
        abstractReportPlugin.setDefaultDimMember(ReportExportHelper.getInstance().getDefaultDimMemberIdMap(request.getDefaultDimMemberMap(), modelCacheHelper, dimensionView));
        abstractReportPlugin.setCurrentEntityNumber(orgMember.getNumber());
        abstractReportPlugin.setCurrentEntityLongNumber(orgMember.getLongNumber());
        abstractReportPlugin.setCurrentEntityViewId(request.getEntityViewId() + "");
        this.pageCache.put("bgtemplate_info", ObjectSerialUtil.toByteSerialized((Object)templateModel.getTemplateBaseInfo()));
        this.pageCache.put("CURRENT_PERIOD", request.getPeriodId() + "");
        if (CollectionUtils.isNotEmpty((Collection)request.getFilterMemberList())) {
            abstractReportPlugin.setFilterMemberMap(request.getFilterMemberList());
        } else {
            Map filterMember = ReportDimFilterUtils.getDefaultFilter(null, (IModelCacheHelper)modelCacheHelper, (String)orgMember.getNumber(), (ITemplateModel)templateModel, (IPageCache)this.pageCache, (Long)request.getProcessId(), (Long)request.getEntityViewId());
            ArrayList<Map> list = new ArrayList<Map>(16);
            list.add(filterMember);
            abstractReportPlugin.setFilterMemberMap(list);
            request.setFilterMemberList(list);
        }
        abstractReportPlugin.afterCreateNewData(null);
        abstractReportPlugin.handleFilterHidden(request.getFilterMemberList());
        return abstractReportPlugin;
    }

    private void buildFloatAreaRow(long templateId, AbstractReportPlugin abstractReportPlugin) {
        ExportTemplateHelper exportTemplateHelper = new ExportTemplateHelper();
        Map<Integer, String> floatAreaRow = exportTemplateHelper.getFloatAreaRow(abstractReportPlugin.getSpreadManager().getMultiAreaManager());
        this.floatRowRangeMap.put(templateId, floatAreaRow);
    }

    public Map<Long, Map<Integer, String>> getFloatRowRangeMap() {
        return this.floatRowRangeMap;
    }
}

