/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.controller;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.status.ExportFileStatusEnum;
import kd.epm.eb.common.report.excel.constants.ImportDataTypeEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.formplugin.report.excel.command.POIExportCommand;
import kd.epm.eb.formplugin.report.excel.domain.ImportBaseManager;
import kd.epm.eb.formplugin.report.excel.domain.ImportErrorManager;
import kd.epm.eb.formplugin.report.excel.domain.ImportManager;
import kd.epm.eb.formplugin.report.excel.entity.ImportExcelFileInfo;
import kd.epm.eb.formplugin.report.excel.entity.ImportExcelResult;
import kd.epm.eb.spread.report.excel.constant.ReportImportTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class BgmReportImportDataTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(BgmReportImportDataTask.class);
    public SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private IFormView formView;
    private IPageCache pageCache;
    private Long timeout = 900L;
    private int maxSheetCount = 20;
    private int maxCellCount = 500000;
    private Date lastUpdate;
    private String loginIp = "";
    private String traceId = "";
    public static ReentrantLock reentrantLock = new ReentrantLock(true);
    private Long modelId = 0L;
    private IModelCacheHelper modelCacheHelper1 = null;

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object maxcell;
        Object maxsheet;
        if (map == null) {
            return;
        }
        IFormView view = new POIExportCommand().initFormView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        formShowParameter.setCustomParam("importType", map.get("importType"));
        formShowParameter.setCustomParam("currentEntityId", map.get("currentEntityId"));
        formShowParameter.setCustomParam("currentPeriodId", map.get("currentPeriodId"));
        formShowParameter.setCustomParam("currentVersionId", map.get("currentVersionId"));
        formShowParameter.setCustomParam("currentDataTypeId", map.get("currentDataTypeId"));
        formShowParameter.setCustomParam("modelId", map.get("modelId"));
        formShowParameter.setCustomParam("bizRange", map.get("bizRange"));
        formShowParameter.setCustomParam("schemeId", map.get("schemeId"));
        formShowParameter.setCustomParam("currentTemplateNumber", map.get("currentTemplateNumber"));
        formShowParameter.setCustomParam("currentDataUnit", map.get("currentDataUnit"));
        formShowParameter.setCustomParam("current_taskp", map.get("current_taskp"));
        formShowParameter.setCustomParam("current_task", map.get("current_task"));
        formShowParameter.setCustomParam("filterCache", map.get("filterCache"));
        formShowParameter.setCustomParam("userRole", map.get("userRole"));
        formShowParameter.setCustomParam("currentEntityViewId", map.get("currentEntityViewId"));
        formShowParameter.setCustomParam("defaultPageDimMap", map.get("defaultPageDimMap"));
        formShowParameter.setCustomParam("processtype", map.get("processtype"));
        formShowParameter.setCustomParam("processId", map.get("processId"));
        formShowParameter.setCustomParam("taskprocessId", map.get("taskprocessId"));
        formShowParameter.setCustomParam("importDataType", map.get("importDataType"));
        view.cacheFormShowParameter();
        this.formView = view;
        this.pageCache = view.getPageCache();
        this.pageCache.put("fileUrl", (String)map.get("fileUrl"));
        Object timeout = map.get("timeout");
        if (timeout != null) {
            this.timeout = Math.min(Long.parseLong(timeout.toString()), 21600L);
        }
        if ((maxsheet = map.get("maxsheet")) != null) {
            this.maxSheetCount = Math.min(Integer.parseInt(maxsheet.toString()), 100);
        }
        if ((maxcell = map.get("maxcell")) != null) {
            this.maxCellCount = Math.min(Integer.parseInt(maxcell.toString()), 5000000);
        }
        this.loginIp = map.get("loginIP") == null ? RequestContext.get().getLoginIP() : map.get("loginIP") + "";
        this.traceId = map.get("traceId") == null ? RequestContext.get().getTraceId() : map.get("traceId") + "";
        this.execute();
    }

    private void saveImportLogEntry() {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"eb_exportfilelist");
        String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7", (String)"BgmReportImportDataTask_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        dy.set("model", (Object)this.getModelId());
        dy.set("fileName", (Object)fileName);
        dy.set("creater", (Object)UserUtils.getUserId());
        dy.set("createdate", (Object)TimeServiceHelper.now());
        dy.set("downloadcount", (Object)0);
        dy.set("status", (Object)ExportFileStatusEnum.IMPORT_ING.getIndex());
        dy.set("filetype", (Object)Character.valueOf('2'));
        dy.set("modifier", (Object)UserUtils.getUserId());
        dy.set("modifydate", (Object)TimeServiceHelper.now());
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        this.pageCache.put("errorFileId", ((DynamicObject)save[0]).getString("id"));
    }

    public void updatePercent(int process, String message, Map<String, Object> customData) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.feedbackProgress(process, message, customData);
        } else {
            this.feedbackProgress(process);
        }
        this.updateCache();
        String exportFileId = this.formView.getPageCache().get("errorFileId");
        if (StringUtils.isNotBlank((CharSequence)exportFileId) && process != 100) {
            DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set fmodifydate = ? ,fprogress = ?  where fid = ?", (Object[])new Object[]{TimeServiceHelper.now(), process + "%", IDUtils.toLong((Object)exportFileId)});
        }
    }

    private void updateCache() {
        String exportFileId = this.formView.getPageCache().get("errorFileId");
        if (this.lastUpdate == null) {
            this.lastUpdate = TimeServiceHelper.now();
            Cache.get().set("importprocess_" + exportFileId, this.simpleDateFormat.format(TimeServiceHelper.now()), 2, TimeUnit.DAYS);
        } else {
            Date now;
            Date temp = DateUtils.addMinutes((Date)this.lastUpdate, (int)5);
            if (temp.compareTo(now = TimeServiceHelper.now()) < 0) {
                Cache.get().set("importprocess_" + exportFileId, this.simpleDateFormat.format(TimeServiceHelper.now()), 2, TimeUnit.DAYS);
                this.lastUpdate = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        Map returnDataMap = new HashMap<String, Object>(16);
        boolean isSuccess = true;
        try {
            this.saveImportLogEntry();
            this.updatePercent(0, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"BgmReportImportDataTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
            Date now = TimeServiceHelper.now();
            Future submit = EpmThreadPools.importDataThreadPool.submit(() -> {
                RequestContext.getOrCreate().setLoginIP(this.loginIp);
                RequestContext.getOrCreate().setTraceId(this.traceId);
                try {
                    log.info("---importdata ip:" + this.loginIp);
                    log.info("---importdata traceId:" + this.traceId);
                    return this.handleImportData();
                }
                catch (Exception e) {
                    ImportExcelResult result = new ImportExcelResult();
                    result.setCode("exception");
                    result.setData((Object)e);
                    return result;
                }
            });
            try {
                ImportExcelResult importExcelResult = (ImportExcelResult)submit.get(this.timeout, TimeUnit.SECONDS);
                if (importExcelResult.getData() instanceof Exception) {
                    if (importExcelResult.getData() instanceof IOException) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0a\u4f20excel\u6587\u4ef6\u3002", (String)"BgmReportImportDataPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    throw (Exception)importExcelResult.getData();
                }
                if (importExcelResult.getData() instanceof Map) {
                    returnDataMap = (Map)importExcelResult.getData();
                }
            }
            catch (TimeoutException e) {
                submit.cancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"BgmReportImportDataPlugin_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            log.info("---\u5bfc\u5165\u6570\u636e\u8017\u8d39\uff1a" + (TimeServiceHelper.now().getTime() - now.getTime()));
        }
        catch (Exception e) {
            isSuccess = false;
            log.error((Throwable)e);
            returnDataMap.put("success", false);
            String message = e.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message) && message.contains("Java heap space")) {
                message = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5185\u5b58\u6ea2\u51fa\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"BgmReportImportDataTask_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            } else if (StringUtils.isEmpty((CharSequence)message)) {
                message = ResManager.loadResFormat((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%1\u3002", (String)"BgmReportImportDataTask_5", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()});
            }
            returnDataMap.put("errorMessage", message);
            returnDataMap.put("errorFileUrl", this.pageCache.get("errorFileUrl"));
            returnDataMap.put("errorFileId", this.pageCache.get("errorFileId"));
        }
        catch (OutOfMemoryError error) {
            log.error((Throwable)error);
            isSuccess = false;
            returnDataMap.put("success", false);
            returnDataMap.put("errorMessage", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5185\u5b58\u6ea2\u51fa\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"BgmReportImportDataTask_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            returnDataMap.put("errorFileUrl", this.pageCache.get("errorFileUrl"));
            returnDataMap.put("errorFileId", this.pageCache.get("errorFileId"));
        }
        Object success = returnDataMap.get("success");
        if (success instanceof Boolean && !((Boolean)success).booleanValue()) {
            isSuccess = false;
        }
        this.feedbackCustomdata(returnDataMap);
        this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"BgmReportImportDataTask_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
        String exportFileId = this.formView.getPageCache().get("errorFileId");
        if (StringUtils.isNotEmpty((CharSequence)exportFileId)) {
            if (!isSuccess) {
                DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set fmodifydate = ? ,fstatus = ? ,ferrormsg = ? where fid = ?", (Object[])new Object[]{TimeServiceHelper.now(), ExportFileStatusEnum.IMPORT_FAIL.getIndex(), returnDataMap.get("errorMessage"), IDUtils.toLong((Object)exportFileId)});
            } else {
                DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set fmodifydate = ? ,fprogress = ?  where fid = ?", (Object[])new Object[]{TimeServiceHelper.now(), "100%", IDUtils.toLong((Object)exportFileId)});
            }
            Cache.get().remove("importprocess_" + exportFileId);
        }
    }

    private ReportImportTypeEnum getImportType() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object importType = formShowParameter.getCustomParam("importType");
        if (importType == null) {
            return ReportImportTypeEnum.IMPORT_BATCH;
        }
        return (ReportImportTypeEnum)SerializationUtils.deSerializeFromBase64((String)importType.toString());
    }

    private Long getCurrentEntityId() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object currentEntityId = formShowParameter.getCustomParam("currentEntityId");
        return IDUtils.toLong((Object)currentEntityId);
    }

    private Long getCurrentPeriodId() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object currentPeriodId = formShowParameter.getCustomParam("currentPeriodId");
        return IDUtils.toLong((Object)currentPeriodId);
    }

    private Long getCurrentVersionId() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object currentVersionId = formShowParameter.getCustomParam("currentVersionId");
        return IDUtils.toLong((Object)currentVersionId);
    }

    private Long getCurrentDataTypeId() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object currentDataTypeId = formShowParameter.getCustomParam("currentDataTypeId");
        return IDUtils.toLong((Object)currentDataTypeId);
    }

    public Long getModelId() {
        String modelIdStr;
        if (this.modelId != 0L) {
            return this.modelId;
        }
        Object modelId = this.formView.getFormShowParameter().getCustomParam("modelId");
        if (modelId != null && StringUtils.isNotEmpty((CharSequence)(modelIdStr = modelId.toString())) && !"0".equals(modelIdStr)) {
            this.modelId = Long.valueOf(modelIdStr);
        }
        return this.modelId;
    }

    private Long getSchemeBizRange() {
        Object bizRange = this.formView.getFormShowParameter().getCustomParam("bizRange");
        if (bizRange == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)bizRange);
    }

    private Long getSchemeId() {
        Object schemeId = this.formView.getFormShowParameter().getCustomParam("schemeId");
        if (schemeId == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)schemeId);
    }

    private Long getSchemeAssignId() {
        Object schemeAssignId = this.formView.getFormShowParameter().getCustomParam("schemeAssignId");
        if (schemeAssignId == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)schemeAssignId);
    }

    private ImportManager initImportManager() {
        return new ImportManager(this.getImportStreamFromCache(this.pageCache), this.initImportBaseManager());
    }

    private ImportBaseManager initImportBaseManager() {
        ImportBaseManager importBaseManager = new ImportBaseManager();
        importBaseManager.setImportErrorManager(new ImportErrorManager());
        importBaseManager.setImportTypeEnum(this.getImportType());
        importBaseManager.setFormView(this.formView);
        importBaseManager.setCurrentPeriodId(this.getCurrentPeriodId());
        importBaseManager.setCurrentDataTypeId(this.getCurrentDataTypeId());
        importBaseManager.setCurrentVersionId(this.getCurrentVersionId());
        importBaseManager.setCurrentEntityId(this.getCurrentEntityId());
        importBaseManager.setCurrentEntityViewId(this.getCurrentEntityViewId());
        importBaseManager.setModelId(this.getModelId());
        importBaseManager.setCurrentReportProcessId(this.getProcessId());
        importBaseManager.setTaskProcessId(this.getTaskProcessId());
        importBaseManager.setCurrentTemplateNumber(this.getCurrentTemplateNumber());
        importBaseManager.setCurrentDataUnit(this.getCurrentDataUnit());
        importBaseManager.setModelCacheHelper(this.getModelCacheHelper(this.modelId));
        importBaseManager.setSchemeId(this.getSchemeId());
        importBaseManager.setSchemeAssignId(this.getSchemeAssignId());
        importBaseManager.setSchemeBizRange(this.getSchemeBizRange());
        importBaseManager.setProcessType(this.getProcessType());
        importBaseManager.setBgmReportImportDataTask(this);
        importBaseManager.setMaxSheetCount(this.maxSheetCount);
        importBaseManager.setMaxCellCount(this.maxCellCount);
        importBaseManager.setImportDataTypeEnum(this.getImportDataTypeEnum());
        return importBaseManager;
    }

    private ImportExcelResult handleImportData() {
        log.info("begin importData,traceId:" + RequestContext.get().getTraceId());
        ImportManager importManager = this.initImportManager();
        return importManager.execute();
    }

    private ImportDataTypeEnum getImportDataTypeEnum() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object importDataType = formShowParameter.getCustomParam("importDataType");
        if (importDataType == null) {
            log.info("importDataType is null.");
            return ImportDataTypeEnum.value_cover_import;
        }
        ImportDataTypeEnum enumByCode = ImportDataTypeEnum.getEnumByCode((String)importDataType.toString());
        if (enumByCode == null) {
            return ImportDataTypeEnum.value_cover_import;
        }
        return enumByCode;
    }

    private IModelCacheHelper getModelCacheHelper(Long modelId) {
        if (this.modelCacheHelper1 == null) {
            this.modelCacheHelper1 = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper1;
    }

    private String getCurrentTemplateNumber() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object currentTemplateNumber = formShowParameter.getCustomParam("currentTemplateNumber");
        if (currentTemplateNumber == null) {
            return "";
        }
        return currentTemplateNumber.toString();
    }

    private String getCurrentDataUnit() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object currentDataUnit = formShowParameter.getCustomParam("currentDataUnit");
        if (currentDataUnit == null) {
            return "";
        }
        return currentDataUnit.toString();
    }

    private Long getCurrentEntityViewId() {
        return IDUtils.toLong((Object)this.formView.getFormShowParameter().getCustomParam("currentEntityViewId"));
    }

    private String getProcessType() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object processtype = formShowParameter.getCustomParam("processtype");
        return processtype == null ? "" : processtype.toString();
    }

    private Long getProcessId() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object processId = formShowParameter.getCustomParam("processId");
        return IDUtils.toLong((Object)processId);
    }

    private Long getTaskProcessId() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        Object taskprocessId = formShowParameter.getCustomParam("taskprocessId");
        return IDUtils.toLong((Object)taskprocessId);
    }

    public List<ImportExcelFileInfo> getImportStreamFromCache(IPageCache pageCache) {
        String exportFileId;
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String fileUrl = pageCache.get("fileUrl");
        ArrayList<ImportExcelFileInfo> result = new ArrayList<ImportExcelFileInfo>(16);
        if (fileUrl != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
            if (CollectionUtils.isEmpty((Collection)urls)) {
                return result;
            }
            try {
                HashSet<String> fileNames = new HashSet<String>(16);
                int index = 0;
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    ImportExcelFileInfo importExcelFileInfo = new ImportExcelFileInfo();
                    String filename = content.getFilename();
                    if (fileNames.contains(content.getFilename())) {
                        importExcelFileInfo.setFileName(filename + "_" + index);
                    } else {
                        importExcelFileInfo.setFileName(filename);
                        fileNames.add(filename);
                    }
                    importExcelFileInfo.setInputStream(inputStream);
                    importExcelFileInfo.setLength(Integer.valueOf(content.getLength()));
                    result.add(importExcelFileInfo);
                    ++index;
                }
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u89e3\u6790\u5931\u8d25\u3002", (String)"BgmReportImportDataPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if (result.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"BgmReportImportDataPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (result.size() == 1 && StringUtils.isNotBlank((CharSequence)(exportFileId = pageCache.get("errorFileId")))) {
            DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set ffilename = ? where fid = ?", (Object[])new Object[]{((ImportExcelFileInfo)result.get(0)).getFileName(), IDUtils.toLong((Object)exportFileId)});
        }
        return result;
    }

    public void feedBackProgress(int progress) {
        this.feedbackProgress(progress);
    }
}

