/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.report.excel.controller.ReportExportDataController;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportJobCacheHelper;
import kd.epm.eb.formplugin.report.excel.mq.consumer.ReportExportConsumer;
import kd.epm.eb.formplugin.report.excel.service.ExportLogService;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportTaskRequest;
import org.apache.commons.collections4.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReportExportDataController {
    private static final Log log = LogFactory.getLog(ReportExportDataController.class);
    public static final Long currentQueueId = GlobalIdUtil.genGlobalLongId();

    public static ReportExportDataController getInstance() {
        return InnerClass.access$100();
    }

    private ReportExportDataController() {
    }

    private void writeHandleLog(List<ReportExportDataRequest> exportDataRequestList) {
        ReportExportDataRequest request = exportDataRequestList.get(0);
        ReportExportTypeEnum exportTypeEnum = request.getExportTypeEnum();
        MultiLangEnumBridge opName = null;
        MultiLangEnumBridge opDescription = null;
        String[] opDescArgs = null;
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_DATA) {
            opName = new MultiLangEnumBridge("\u5bfc\u51fa\u6570\u636e", "ReportExportDataController_01", "epm-eb-formplugin");
            opDescription = new MultiLangEnumBridge("\u5bfc\u51fa\u7684\u4e2a\u6570\uff1a%1$s", "ReportExportDataController_04", "epm-eb-formplugin");
            opDescArgs = new String[]{String.valueOf(exportDataRequestList.size())};
        } else if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            opName = new MultiLangEnumBridge("\u5bfc\u51fa\u6a21\u677f", "ReportExportDataController_02", "epm-eb-formplugin");
            opDescription = new MultiLangEnumBridge("\u5bfc\u51fa\u7684\u4e2a\u6570\uff1a%1$s", "ReportExportDataController_04", "epm-eb-formplugin");
            opDescArgs = new String[]{String.valueOf(exportDataRequestList.size())};
        } else if (exportTypeEnum == ReportExportTypeEnum.EXPORT_BY_ORG) {
            opName = new MultiLangEnumBridge("\u6309\u7ec4\u7ec7\u5bfc\u51fa", "ReportExportDataController_03", "epm-eb-formplugin");
            opDescription = new MultiLangEnumBridge("\u5bfc\u51fa\u7ec4\u7ec7\uff1a%1$s\uff0c\u7ec4\u7ec7\u8303\u56f4\uff1a%2$s", "ReportExportDataController_05", "epm-eb-formplugin");
            opDescArgs = new String[]{String.valueOf(exportDataRequestList.get(0).getEntityId()), exportDataRequestList.get(0).getExportByOrgRange().getName()};
        }
        if (opName != null) {
            AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)ApplicationTypeEnum.BGM.getAppnum(), (String)request.getFormId(), null, (String)"export", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, opDescArgs);
            OperationLogUtil.log((AppLogInfo)logInfo);
        }
    }

    public Map<String, String> exportReportData(List<ReportExportDataRequest> exportDataRequestList, IFormView formView, CloseCallBack closeCallBack) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (CollectionUtils.isEmpty(exportDataRequestList) || formView == null) {
            result.put("failed", ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u4efb\u52a1\u3002", (String)"ReportExportDataController_003", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        IDataEntityProperty MAX_EXPORT_SIZE_Prop = formView.getModel().getProperty("maxexportsize");
        Object maxExportSizeObj = null;
        if (MAX_EXPORT_SIZE_Prop != null) {
            maxExportSizeObj = formView.getModel().getValue("maxexportsize");
        }
        IDataEntityProperty EXPORT_TIMOUT_Prop = formView.getModel().getProperty("exporttimout");
        Object exportTimoutObj = null;
        if (EXPORT_TIMOUT_Prop != null) {
            exportTimoutObj = formView.getModel().getValue("exporttimout");
        }
        IDataEntityProperty MAX_EXPORT_SHEET_SIZE_Prop = formView.getModel().getProperty("maxexportsheet");
        Object maxExportSheetSizeObj = null;
        if (MAX_EXPORT_SHEET_SIZE_Prop != null) {
            maxExportSheetSizeObj = formView.getModel().getValue("maxexportsheet");
        }
        IDataEntityProperty MAX_EXPORT_ENTITY_SIZE_Prop = formView.getModel().getProperty("maxexportentity");
        Object maxExportEntitySizeObj = null;
        if (MAX_EXPORT_ENTITY_SIZE_Prop != null) {
            maxExportEntitySizeObj = formView.getModel().getValue("maxexportentity");
        }
        Long modelId = exportDataRequestList.get(0).getModelId();
        for (ReportExportDataRequest request : exportDataRequestList) {
            request.setFileName(this.getSecurityHeader(request.getFileName()));
        }
        this.writeHandleLog(exportDataRequestList);
        boolean isRepeatInQueue = this.checkRequestIsRepeatInQueue(exportDataRequestList, exportDataRequestList.get(0).getModelId());
        if (isRepeatInQueue) {
            result.put("failed", ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u62a5\u8868\u5bfc\u51fa\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportExportDataController_005", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        long timeoutMillions = exportTimoutObj != null ? (long)Integer.parseInt(exportTimoutObj.toString()) * 1000L : (long)exportDataRequestList.get(0).getExportTimeout() * 1000L;
        ReportExportTaskRequest reportExportTaskRequest = ExportLogService.getInstance().createReportExportTaskRequest(exportDataRequestList, timeoutMillions);
        if (maxExportSizeObj != null) {
            reportExportTaskRequest.setMaxExportSize(Integer.parseInt(maxExportSizeObj.toString()));
        }
        if (exportTimoutObj != null) {
            reportExportTaskRequest.setExportTimeout(Integer.parseInt(exportTimoutObj.toString()));
        }
        if (maxExportSheetSizeObj != null) {
            reportExportTaskRequest.setMaxExportSheet(Integer.parseInt(maxExportSheetSizeObj.toString()));
        }
        if (maxExportEntitySizeObj != null) {
            reportExportTaskRequest.setMaxExportEntity(Integer.parseInt(maxExportEntitySizeObj.toString()));
        }
        try {
            ReportExportConsumer reportExportConsumer = new ReportExportConsumer(reportExportTaskRequest);
            EpmThreadPools.exportConsumerThreadPool.submit((Runnable)reportExportConsumer);
            result.put("success", ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa\u4efb\u52a1\u5df2\u6210\u529f\u63d0\u4ea4\uff0c\u8bf7\u6ce8\u610f\u4e0b\u8f7d\u5217\u8868\u4e2d\u7684\u5bfc\u51fa\u8fdb\u5ea6\u3002", (String)"ReportExportDataController_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("reportExport submit error.");
            ReportExportJobCacheHelper.remove((String)this.getReportExportJobInfoCacheKey(modelId), (ReportExportTaskRequest)reportExportTaskRequest);
            String errorInfo = ResManager.loadResFormat((String)"\u63d0\u4ea4\u5bfc\u51fa\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002Trace ID\uff1a%1\u3002", (String)"ReportExportPublisher_002", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()});
            if (e instanceof KDBizException) {
                errorInfo = e.getMessage();
            }
            result.put("failed", errorInfo);
        }
        return result;
    }

    public String getSecurityHeader(String sourceHeader) {
        if (sourceHeader == null) {
            return sourceHeader;
        }
        Pattern pa = Pattern.compile("[`~!@#$%^&*()\\+\\=\\{}|:\"?><\u3010\u3011\\r\\n]");
        Matcher matcher = pa.matcher(sourceHeader);
        if (matcher.find()) {
            sourceHeader = matcher.replaceAll("");
        }
        return sourceHeader;
    }

    private String getReportExportJobInfoCacheKey(Long modelId) {
        return ReportExportJobCacheHelper.getReportExportJobInfoCacheKey((Long)modelId);
    }

    private boolean checkRequestIsRepeatInQueue(List<ReportExportDataRequest> requests, Long modelId) {
        String cacheKey = this.getReportExportJobInfoCacheKey(modelId);
        List currentRequestHashCodeSetList = ReportExportJobCacheHelper.getJobInfoHashCodeList((String)cacheKey);
        if (CollectionUtils.isEmpty((Collection)currentRequestHashCodeSetList)) {
            return false;
        }
        if (CollectionUtils.isEmpty(requests)) {
            return false;
        }
        for (Map currentRequestHashCodeSetMap : currentRequestHashCodeSetList) {
            for (Map.Entry entry : currentRequestHashCodeSetMap.entrySet()) {
                List currentRequestHashCodeSet = (List)entry.getValue();
                if (requests.size() != currentRequestHashCodeSet.size()) continue;
                boolean isCommon = true;
                for (ReportExportDataRequest request : requests) {
                    if (currentRequestHashCodeSet.contains(request.hashCode())) continue;
                    isCommon = false;
                    break;
                }
                if (!isCommon) continue;
                return true;
            }
        }
        return false;
    }
}

