/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.formplugin.report.excel.domain.ImportSheetManager;
import kd.epm.eb.formplugin.report.excel.entity.ImportCell;
import kd.epm.eb.formplugin.report.excel.entity.ReportImportDataErrorInfo;
import kd.epm.eb.spread.report.excel.helper.POIHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportErrorManager {
    private static final int MAX_ERROR_STR_LEN = 200;
    private final Map<String, Workbook> errorWorkBookMap = new HashMap<String, Workbook>(16);
    private final List<ReportImportDataErrorInfo> fileErrorList = new ArrayList<ReportImportDataErrorInfo>(16);
    private final Map<Integer, Map<String, List<ReportImportDataErrorInfo>>> sheetErrorMap = new HashMap<Integer, Map<String, List<ReportImportDataErrorInfo>>>(16);
    private final Map<Integer, Map<String, List<ReportImportDataErrorInfo>>> cellErrorMap = new HashMap<Integer, Map<String, List<ReportImportDataErrorInfo>>>(16);
    private final Map<Integer, Map<String, List<ReportImportDataErrorInfo>>> cellInfoMap = new HashMap<Integer, Map<String, List<ReportImportDataErrorInfo>>>(16);

    public Map<String, Workbook> getErrorWorkBookMap() {
        return this.errorWorkBookMap;
    }

    public void addFileError(String errorInfo) {
        ReportImportDataErrorInfo reportImportDataErrorInfo = new ReportImportDataErrorInfo(errorInfo);
        this.fileErrorList.add(reportImportDataErrorInfo);
    }

    public void addSheetError(Integer currentWorkbookIndex, String errorInfo, String sheetName) {
        ReportImportDataErrorInfo reportImportDataErrorInfo = new ReportImportDataErrorInfo(errorInfo, sheetName, 0);
        List reportImportDataErrorInfos = this.sheetErrorMap.computeIfAbsent(currentWorkbookIndex, t -> new HashMap(16)).computeIfAbsent(sheetName, t -> new ArrayList(16));
        reportImportDataErrorInfos.add(reportImportDataErrorInfo);
    }

    public void addCellError(Integer currentWorkbookIndex, String errorInfo, String sheetName, int rowIndex) {
        ReportImportDataErrorInfo reportImportDataErrorInfo = new ReportImportDataErrorInfo(errorInfo, sheetName, rowIndex);
        List reportImportDataErrorInfos = this.cellErrorMap.computeIfAbsent(currentWorkbookIndex, t -> new HashMap(16)).computeIfAbsent(sheetName, t -> new ArrayList(16));
        reportImportDataErrorInfos.add(reportImportDataErrorInfo);
    }

    public void addCellInfo(Integer currentWorkbookIndex, String errorInfo, String sheetName, int rowIndex) {
        ReportImportDataErrorInfo reportImportDataErrorInfo = new ReportImportDataErrorInfo(errorInfo, sheetName, rowIndex);
        List reportImportDataErrorInfos = this.cellInfoMap.computeIfAbsent(currentWorkbookIndex, t -> new HashMap(16)).computeIfAbsent(sheetName, t -> new ArrayList(16));
        reportImportDataErrorInfos.add(reportImportDataErrorInfo);
    }

    public List<ReportImportDataErrorInfo> getImportFileError() {
        return this.fileErrorList;
    }

    public boolean hasFileError() {
        return CollectionUtils.isNotEmpty(this.fileErrorList);
    }

    public boolean hasSheetOrCellError() {
        return MapUtils.isNotEmpty(this.sheetErrorMap) || MapUtils.isNotEmpty(this.cellErrorMap);
    }

    public boolean hasCellInfo() {
        return MapUtils.isNotEmpty(this.cellInfoMap);
    }

    public boolean hasSheetError(Integer currentWorkBookIndex, String sheetName) {
        if (this.sheetErrorMap.size() == 0) {
            return false;
        }
        Map<String, List<ReportImportDataErrorInfo>> reportImportDataSheetErrorInfosMap = this.sheetErrorMap.get(currentWorkBookIndex);
        if (reportImportDataSheetErrorInfosMap != null && reportImportDataSheetErrorInfosMap.size() > 0) {
            List<ReportImportDataErrorInfo> reportImportDataErrorInfos = reportImportDataSheetErrorInfosMap.get(sheetName);
            return CollectionUtils.isNotEmpty(reportImportDataErrorInfos);
        }
        return false;
    }

    public void writeTableData2ErrorWorkBook(Integer currentWorkBookIndex, String fileName, String sheetName, List<List<ImportCell>> tableData) {
        boolean hasErrorInfo;
        if (this.sheetErrorMap.size() == 0 && this.cellErrorMap.size() == 0 && this.cellInfoMap.size() == 0) {
            return;
        }
        ImportSheetManager importSheetManager = new ImportSheetManager(sheetName, tableData);
        DataFormatter formatter = new DataFormatter();
        Map<String, List<ReportImportDataErrorInfo>> sheetErrorData = this.sheetErrorMap.get(currentWorkBookIndex);
        Map<String, List<ReportImportDataErrorInfo>> cellErrorData = this.cellErrorMap.get(currentWorkBookIndex);
        Map<String, List<ReportImportDataErrorInfo>> cellInfoData = this.cellInfoMap.get(currentWorkBookIndex);
        List<Object> sheetErrorList = new ArrayList(16);
        if (sheetErrorData != null) {
            sheetErrorList = sheetErrorData.get(sheetName);
        }
        List<Object> cellErrorList = new ArrayList(16);
        if (cellErrorData != null) {
            cellErrorList = cellErrorData.get(sheetName);
        }
        List<Object> cellInfoList = new ArrayList(16);
        if (cellInfoData != null) {
            cellInfoList = cellInfoData.get(sheetName);
        }
        boolean bl = hasErrorInfo = CollectionUtils.isNotEmpty(sheetErrorList) || CollectionUtils.isNotEmpty(cellErrorList) || CollectionUtils.isNotEmpty(cellInfoList);
        if (hasErrorInfo) {
            Workbook workbook = this.errorWorkBookMap.get(fileName);
            if (workbook == null) {
                workbook = new XSSFWorkbook();
                this.errorWorkBookMap.put(fileName, workbook);
            }
            Sheet sheet = workbook.createSheet(sheetName);
            int rowOffset = 0;
            int colOffset = 0;
            if (CollectionUtils.isNotEmpty(sheetErrorList)) {
                rowOffset = 1;
            }
            if (CollectionUtils.isNotEmpty(cellErrorList) || CollectionUtils.isNotEmpty(cellInfoList)) {
                colOffset = 1;
            }
            for (int rowIndex = 0; rowIndex < tableData.size(); ++rowIndex) {
                List<ImportCell> colList = tableData.get(rowIndex);
                if (CollectionUtils.isEmpty(colList)) continue;
                int excelRowIndex = rowIndex + rowOffset;
                Row row = sheet.getRow(excelRowIndex);
                if (row == null) {
                    row = sheet.createRow(excelRowIndex);
                }
                for (int colIndex = 0; colIndex < colList.size(); ++colIndex) {
                    String cellValue = importSheetManager.getCellValue(rowIndex, colIndex);
                    ImportCell importCell = colList.get(colIndex);
                    if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                    int excelColIndex = colIndex + colOffset;
                    Cell cell = row.getCell(excelColIndex);
                    if (cell == null) {
                        cell = row.createCell(excelColIndex);
                    }
                    cell.setCellValue(importCell.getDataValue(formatter));
                }
            }
        }
    }

    private CellStyle createErrorInfoStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setColor(IndexedColors.RED.index);
        font.setBold(true);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    public void buildErrorWorkBook(String fileName, Integer currentWorkBookIndex) {
        String sheetName;
        if (this.sheetErrorMap.size() == 0 && this.cellErrorMap.size() == 0 && this.cellInfoMap.size() == 0) {
            return;
        }
        Map<String, List<ReportImportDataErrorInfo>> sheetErrorData = this.sheetErrorMap.get(currentWorkBookIndex);
        Map<String, List<ReportImportDataErrorInfo>> cellErrorData = this.cellErrorMap.get(currentWorkBookIndex);
        Map<String, List<ReportImportDataErrorInfo>> cellInfoData = this.cellInfoMap.get(currentWorkBookIndex);
        Workbook workbook = this.errorWorkBookMap.get(fileName);
        if (workbook == null) {
            return;
        }
        CellStyle cellStyle = this.createErrorInfoStyle(workbook);
        boolean hasErrorInfo = false;
        if (sheetErrorData != null && sheetErrorData.size() > 0) {
            hasErrorInfo = true;
            for (Map.Entry<String, List<ReportImportDataErrorInfo>> entry : sheetErrorData.entrySet()) {
                Cell cell;
                sheetName = entry.getKey();
                List<ReportImportDataErrorInfo> value = entry.getValue();
                List errorInfos = value.stream().map(ReportImportDataErrorInfo::getErrorDesc).collect(Collectors.toList());
                Sheet sheet = workbook.getSheet(sheetName);
                if (sheet == null) {
                    sheet = workbook.createSheet(sheetName);
                }
                sheet.setColumnWidth(0, 25784);
                Row row = sheet.getRow(0);
                if (row == null) {
                    row = sheet.createRow(0);
                }
                if ((cell = row.getCell(0)) == null) {
                    cell = row.createCell(0);
                } else {
                    errorInfos.add(POIHelper.getCellValue((Cell)cell) + "");
                }
                String errorInfoStr = "";
                if (CollectionUtils.isNotEmpty(errorInfos) && (errorInfoStr = String.join((CharSequence)";", errorInfos)).length() >= 200) {
                    errorInfoStr = errorInfoStr.substring(0, 200);
                }
                cell.setCellValue(errorInfoStr);
                cell.setCellStyle(cellStyle);
            }
        }
        if (MapUtils.isNotEmpty(cellInfoData)) {
            if (cellErrorData == null) {
                cellErrorData = new HashMap<String, List<ReportImportDataErrorInfo>>(16);
            }
            for (Map.Entry<String, List<ReportImportDataErrorInfo>> entry : cellInfoData.entrySet()) {
                String key = entry.getKey();
                List<ReportImportDataErrorInfo> dataList = cellErrorData.get(key);
                if (dataList == null) {
                    cellErrorData.put(key, entry.getValue());
                    continue;
                }
                dataList.addAll((Collection<ReportImportDataErrorInfo>)entry.getValue());
            }
        }
        if (cellErrorData != null && cellErrorData.size() > 0) {
            hasErrorInfo = true;
            for (Map.Entry<String, List<ReportImportDataErrorInfo>> entry : cellErrorData.entrySet()) {
                sheetName = entry.getKey();
                List<ReportImportDataErrorInfo> errorInfos = entry.getValue();
                Sheet sheet = workbook.getSheet(sheetName);
                if (sheet == null) {
                    sheet = workbook.createSheet(sheetName);
                }
                sheet.setColumnWidth(0, 25784);
                for (ReportImportDataErrorInfo errorInfo : errorInfos) {
                    Cell cell;
                    StringBuilder errorInfoStr = new StringBuilder();
                    int rowIndex = errorInfo.getRowIndex();
                    Row row = sheet.getRow(rowIndex);
                    if (row == null) {
                        row = sheet.createRow(rowIndex);
                    }
                    if ((cell = row.getCell(0)) == null) {
                        cell = row.createCell(0);
                    } else {
                        errorInfoStr.append(POIHelper.getCellValue((Cell)cell));
                    }
                    if (StringUtils.isNotBlank((CharSequence)errorInfoStr)) {
                        if (errorInfoStr.length() >= 200) {
                            String cellVal = errorInfoStr.length() == 200 ? errorInfoStr.toString() : errorInfoStr.substring(0, 200);
                            cell.setCellValue(cellVal);
                        } else {
                            cell.setCellValue(errorInfoStr + ";" + errorInfo.getErrorDesc());
                        }
                    } else {
                        cell.setCellValue(errorInfo.getErrorDesc());
                    }
                    cell.setCellStyle(cellStyle);
                }
            }
        }
        if (hasErrorInfo) {
            this.errorWorkBookMap.put(fileName, workbook);
        }
    }
}

