/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.domain;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.status.ExportFileStatusEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.formplugin.report.excel.command.POIExportCommand;
import kd.epm.eb.formplugin.report.excel.domain.ImportBaseManager;
import kd.epm.eb.formplugin.report.excel.domain.ImportErrorManager;
import kd.epm.eb.formplugin.report.excel.domain.ImportExcelManager;
import kd.epm.eb.formplugin.report.excel.entity.ImportExcelFileInfo;
import kd.epm.eb.formplugin.report.excel.entity.ImportExcelResult;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.spread.report.excel.constant.ReportImportTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportManager {
    private static final Log log = LogFactory.getLog(ImportManager.class);
    private final ImportBaseManager importBaseManager;
    private final List<ImportExcelFileInfo> importExcelFileInfos;
    private final List<ImportExcelManager> importExcelManagers = new ArrayList<ImportExcelManager>(16);

    public ImportManager(List<ImportExcelFileInfo> importExcelFileInfos, ImportBaseManager importBaseManager) {
        this.importExcelFileInfos = importExcelFileInfos;
        this.importBaseManager = importBaseManager;
        this.importBaseManager.setImportErrorManager(new ImportErrorManager());
        this.build();
    }

    private void build() {
        if (CollectionUtils.isEmpty(this.importExcelFileInfos)) {
            return;
        }
        this.importBaseManager.setImportFileCount(this.importExcelFileInfos.size());
        for (ImportExcelFileInfo importExcelFileInfo : this.importExcelFileInfos) {
            if (this.importBaseManager.getImportErrorManager().hasFileError()) break;
            this.importExcelManagers.add(new ImportExcelManager(importExcelFileInfo, this.importBaseManager));
        }
    }

    public ImportExcelResult execute() {
        boolean isPass = this.beforeImport();
        if (isPass) {
            this.doImport();
        }
        return this.afterImport();
    }

    private boolean beforeImport() {
        boolean taskNotEnable;
        DynamicObject dynamicObject;
        if (this.importBaseManager.getImportErrorManager().hasFileError()) {
            return false;
        }
        if (Objects.equals(this.importBaseManager.getProcessType(), ProcessTypeEnum.REPORT.getNumber())) {
            boolean status;
            DynamicObject dynamicObject2 = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.importBaseManager.getSchemeId())});
            if (dynamicObject2 != null && !(status = dynamicObject2.getBoolean("status"))) {
                String errorInfo = ResManager.loadKDString((String)"\u7f16\u5236\u65b9\u6848\u5df2\u88ab\u7981\u7528\u6216\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataTask_003", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addFileError(errorInfo);
                return false;
            }
        } else if (this.importBaseManager.getImportTypeEnum() == ReportImportTypeEnum.IMPORT_SINGLE && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_taskprocess", (String)"task", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.importBaseManager.getTaskProcessId())})) != null && (taskNotEnable = BgTaskExecuteHelper.isTaskNotEnable(dynamicObject.getLong("task")))) {
            String errorInfo = ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataTask_004", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addFileError(errorInfo);
            return false;
        }
        return true;
    }

    public void doImport() {
        int index = 0;
        for (ImportExcelManager importExcelManager : this.importExcelManagers) {
            importExcelManager.execute();
            this.importBaseManager.setCurrentWorkBookIndex(index++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportExcelResult afterImport() {
        ImportExcelResult result = new ImportExcelResult();
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        returnDataMap.put("success", true);
        returnDataMap.put("errorMessage", "");
        IPageCache pageCache = this.importBaseManager.getFormView().getPageCache();
        String exportFileId = pageCache.get("errorFileId");
        if (this.importBaseManager.getImportErrorManager().hasFileError()) {
            returnDataMap.put("success", false);
            returnDataMap.put("errorMessage", this.importBaseManager.getImportErrorManager().getImportFileError().get(0).getErrorDesc());
        } else {
            Map<String, Workbook> errorWorkBookMap;
            boolean hasSheetOrCellError = this.importBaseManager.getImportErrorManager().hasSheetOrCellError();
            boolean hasCellInfo = this.importBaseManager.getImportErrorManager().hasCellInfo();
            if ((hasSheetOrCellError || hasCellInfo) && (errorWorkBookMap = this.importBaseManager.getImportErrorManager().getErrorWorkBookMap()).size() > 0) {
                String url = "";
                String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e-\u65e5\u5fd7\u6587\u4ef6", (String)"BgmReportImportDataPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if (hasSheetOrCellError) {
                    returnDataMap.put("success", false);
                    returnDataMap.put("errorMessage", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BgmReportImportDataTask_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    result.setCode("failed");
                } else {
                    returnDataMap.put("success", true);
                    returnDataMap.put("errorMessage", ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff08\u5b58\u5728\u9501\u5b9a\u6216\u8005\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff0c\u4e0b\u8f7d\u65e5\u5fd7\u67e5\u770b\u5177\u4f53\u4fe1\u606f\uff09\u3002", (String)"BgmReportImportDataTask_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (errorWorkBookMap.size() > 1) {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    ZipOutputStream zipOutputStream = new ZipOutputStream(outStream);
                    try {
                        POIExportCommand poiExportCommand = new POIExportCommand();
                        for (Map.Entry<String, Workbook> entry : errorWorkBookMap.entrySet()) {
                            XSSFWorkbook xssfWorkbook = (XSSFWorkbook)entry.getValue();
                            poiExportCommand.zipWorkBook(zipOutputStream, (Workbook)xssfWorkbook, entry.getKey() + "_" + fileName);
                        }
                    }
                    finally {
                        try {
                            outStream.close();
                            zipOutputStream.close();
                            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".zip", (InputStream)inStream, 43200);
                            inStream.close();
                        }
                        catch (IOException e) {
                            log.error((Throwable)e);
                        }
                    }
                }
                for (Map.Entry<String, Workbook> entry : errorWorkBookMap.entrySet()) {
                    try {
                        url = ImportAndExportUtil.writeFile((Workbook)entry.getValue(), (String)(entry.getKey() + "_" + fileName), (int)43200);
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)exportFileId) && StringUtils.isNotBlank((CharSequence)url)) {
                    DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set fmodifydate = ? ,fstatus = ? ,furl =? where fid = ?", (Object[])new Object[]{TimeServiceHelper.now(), ExportFileStatusEnum.IMPORT_FAIL.getIndex(), url, IDUtils.toLong((Object)exportFileId)});
                }
                DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set fprogress = ?  where fid = ?", (Object[])new Object[]{"100%", IDUtils.toLong((Object)exportFileId)});
            }
        }
        boolean isSuccess = (Boolean)returnDataMap.get("success");
        if (StringUtils.isNotEmpty((CharSequence)exportFileId)) {
            if (isSuccess) {
                DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set fmodifydate = ?, fstatus = ?, ferrormsg = ?, ffinishtime = ? where fid = ?", (Object[])new Object[]{TimeServiceHelper.now(), ExportFileStatusEnum.IMPORT_END.getIndex(), returnDataMap.get("errorMessage"), TimeServiceHelper.formatUserNow(), IDUtils.toLong((Object)exportFileId)});
            } else {
                DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set fmodifydate = ?, fstatus = ?, ferrormsg = ?, ffinishtime = ? where fid = ?", (Object[])new Object[]{TimeServiceHelper.now(), ExportFileStatusEnum.IMPORT_FAIL.getIndex(), returnDataMap.get("errorMessage"), TimeServiceHelper.formatUserNow(), IDUtils.toLong((Object)exportFileId)});
            }
            Cache.get().remove("importprocess_" + exportFileId);
        }
        returnDataMap.put("errorFileUrl", pageCache.get("errorFileUrl"));
        returnDataMap.put("errorFileId", pageCache.get("errorFileId"));
        result.setData(returnDataMap);
        this.importBaseManager.getBgmReportImportDataTask().feedBackProgress(100);
        return result;
    }
}

