/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.domain;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.task.util.DateCheckUtil;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.report.excel.constants.ImportDataTypeEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.request.UpdateRptProcessStatusRequest;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.report.excel.POIDynamicReportProcess;
import kd.epm.eb.formplugin.report.excel.POIFixReportProcess;
import kd.epm.eb.formplugin.report.excel.command.ExportHelper;
import kd.epm.eb.formplugin.report.excel.domain.ImportBaseManager;
import kd.epm.eb.formplugin.report.excel.entity.ImportCell;
import kd.epm.eb.formplugin.report.excel.entity.ReportImportDataFloatArea;
import kd.epm.eb.formplugin.report.excel.helper.ExportTemplateHelper;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportHelper;
import kd.epm.eb.formplugin.reportscheme.helper.EntityDimPermHelper;
import kd.epm.eb.formplugin.reportscheme.helper.ReportPreparationListHelper;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.formplugin.task.command.ListPanelDraw;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.spread.adaptor.FixSpreadJsAction;
import kd.epm.eb.spread.adaptor.SpreadJsAction;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.lockcell.RealNoLeafCellLockController;
import kd.epm.eb.spread.command.lockcontroller.lockcell.fix.RealFixNoLeafCellLockController;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.control.POISpreadContainer;
import kd.epm.eb.spread.report.excel.constant.ReportImportTypeEnum;
import kd.epm.eb.spread.template.DefaultTemplateModel;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.IPartitionSetting;
import kd.epm.eb.spread.template.partition.PartitionInfo;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.AutoFloatHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportSheetManager {
    private static final Log log = LogFactory.getLog(ImportSheetManager.class);
    private ImportBaseManager importBaseManager;
    private ITemplateModel currentTemplateModel;
    private AbstractReportPlugin abstractReportPlugin;
    private IEbSpreadManager currentEbSpreadManager;
    private Map<String, String> pageDimMemberMap;
    private Long currentEntityId;
    private String fileName;
    private String sheetName;
    private Stopwatch stopwatch;
    private final List<List<ImportCell>> tableData;
    private static final Set<String> specialCharacters = Sets.newHashSet((Object[])new String[]{"--", "-", "/", "\u2014\u2014"});
    private final Map<ISpreadLockControl, Map<Integer, Set<Integer>>> lockCellsMap = new HashMap<ISpreadLockControl, Map<Integer, Set<Integer>>>(16);
    private final Set<String> templateLockCellSet = new HashSet<String>(128);
    private boolean pageAndViewMemIsNoleaf = false;
    private Map<Long, IMemberPermCache> memberPermCacheMap = new HashMap<Long, IMemberPermCache>(16);
    private Map<Long, Long> busModelIdMap = new HashMap<Long, Long>(16);
    private int preAreaInsertFloatRow = 0;
    private Map<String, Set<String>> validEnumValuesMap = null;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getCellValue(int rowIndex, int colIndex) {
        if (CollectionUtils.isEmpty(this.tableData)) {
            return "";
        }
        if (rowIndex >= this.tableData.size()) {
            return "";
        }
        List<ImportCell> colList = this.tableData.get(rowIndex);
        if (CollectionUtils.isEmpty(colList)) {
            return "";
        }
        if (colIndex >= colList.size()) {
            return "";
        }
        ImportCell importCell = colList.get(colIndex);
        String result = importCell.getValue();
        if (StringUtils.isEmpty((CharSequence)result)) {
            return "";
        }
        return result;
    }

    public ImportSheetManager(String sheetName, List<List<ImportCell>> tableData, ImportBaseManager importBaseManager) {
        this.sheetName = sheetName;
        this.tableData = tableData;
        this.importBaseManager = importBaseManager;
        this.currentEntityId = importBaseManager.getCurrentEntityId();
    }

    public ImportSheetManager(String sheetName, List<List<ImportCell>> tableData) {
        this.sheetName = sheetName;
        this.tableData = tableData;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String getKingdeeStr() {
        return this.getCellValue(0, 0);
    }

    public String getTemplateNumber() {
        if (CollectionUtils.isEmpty(this.tableData)) {
            return "";
        }
        return this.getCellValue(0, 1);
    }

    public String getDataUnit() {
        if (CollectionUtils.isEmpty(this.tableData)) {
            return "";
        }
        return this.getCellValue(0, 3);
    }

    public boolean getIncludeFilter() {
        if (CollectionUtils.isEmpty(this.tableData)) {
            return Boolean.FALSE;
        }
        String cellValue = this.getCellValue(0, 5);
        if (StringUtils.isNotBlank((CharSequence)cellValue) && "true".equals(cellValue)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private DynamicObject queryTemplateObj() {
        QFilter filter = new QFilter("model", "=", (Object)this.importBaseManager.getModelId());
        filter.and("number", "=", (Object)this.getTemplateNumber());
        String selectFields = "id,name,number,templatetype,dataunit,model,templateCatalog,dataset,isrelation,dimrelationinfo,dimrelationinfo2,data,spreadserial,isreadonly, varbaseforeb";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"eb_templateentity", (String)selectFields, (QFilter[])filter.toArray());
    }

    private boolean checkTemplateLegal() {
        String flagKey;
        if (StringUtils.isEmpty((CharSequence)this.getKingdeeStr()) || this.getKingdeeStr() != null && !this.getKingdeeStr().startsWith("Kingdee")) {
            String errorInfo = ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u5bfc\u5165\u6a21\u677f", (String)"BgmReportImportDataPlugin_08", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        Boolean nopagemumber = ParamQueryServiceHelper.getBoolean((long)this.importBaseManager.getModelId(), (ParamEnum)ParamEnum.BG018);
        String string = flagKey = nopagemumber != false ? "Kingdee_1" : "Kingdee";
        if (!StringUtils.equals((CharSequence)flagKey, (CharSequence)this.getKingdeeStr())) {
            String errorInfo = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u4e0e\u5f53\u524d\"\u5bfc\u51fa\u6a21\u677f\u4e0d\u542b\u9875\u9762\u7ef4\"\u53c2\u6570\u5173\u7cfb\u4e0d\u4e00\u81f4\u3002", (String)"BgmReportImportDataPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        DynamicObject templateDynamicObject = this.queryTemplateObj();
        if (templateDynamicObject == null) {
            String errorInfo = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e2dB2\u5355\u5143\u683c\u7684\u6a21\u677f\u7f16\u7801\u5bf9\u5e94\u7684\u6a21\u677f\u4e0d\u5b58\u5728", (String)"BgmReportImportDataPlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        boolean isreadonly = templateDynamicObject.getBoolean("isreadonly");
        if (isreadonly) {
            String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e3a\u53ea\u8bfb\u6a21\u677f\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        log.info("beforeImport templateNumber:" + templateDynamicObject.getString("number") + ";importType:" + this.importBaseManager.getImportDataTypeEnum().getDesc());
        return true;
    }

    private void initImportReportDataModel() {
        DynamicObject templateDynamicObject = this.queryTemplateObj();
        if (templateDynamicObject == null) {
            return;
        }
        IFormView iFormView = this.importBaseManager.getFormView();
        this.currentTemplateModel = ExportHelper.buildTemplateModel((DynamicObject)templateDynamicObject, (IPageCache)iFormView.getPageCache(), (Long)this.importBaseManager.getCurrentEntityViewId());
        if (StringUtils.isNotEmpty((CharSequence)this.importBaseManager.getCurrentDataUnit())) {
            this.currentTemplateModel.getTemplateBaseInfo().setDataunit(this.importBaseManager.getCurrentDataUnit());
        }
        this.pageDimMemberMap = this.getPageDimMemberMap(this.currentTemplateModel);
    }

    private void initSpreadManager() {
        try {
            this.abstractReportPlugin = this.initReportPlugin(this.pageDimMemberMap, this.importBaseManager.getModelCacheHelper());
        }
        catch (Exception e) {
            log.error("import initSpreadManager exception.");
            log.error((Throwable)e);
            if (e instanceof KDBizException) {
                String errorInfo = e.getMessage();
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            }
            throw e;
        }
        this.currentEbSpreadManager = this.abstractReportPlugin.getSpreadManager();
    }

    private boolean checkSingleImport() {
        if (this.importBaseManager.getImportTypeEnum() == ReportImportTypeEnum.IMPORT_SINGLE) {
            String dataUnitFromSheet;
            String templateNumberFromSheet;
            String currentTemplateNumber = this.importBaseManager.getCurrentTemplateNumber();
            if (!StringUtils.equals((CharSequence)currentTemplateNumber, (CharSequence)(templateNumberFromSheet = this.getTemplateNumber()))) {
                String errorInfo = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u7684\u9884\u7b97\u6a21\u677f\u7f16\u7801\u662f\u5426\u4e0e\u5f53\u524d\u62a5\u8868\u4e00\u81f4\u3002", (String)"BgmReportImportDataPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addFileError(errorInfo);
                return false;
            }
            String currentDataUnit = this.importBaseManager.getCurrentDataUnit();
            if (!StringUtils.equals((CharSequence)currentDataUnit, (CharSequence)(dataUnitFromSheet = this.getDataUnit()))) {
                String errorInfo = null;
                errorInfo = StringUtils.isEmpty((CharSequence)dataUnitFromSheet) ? ResManager.loadResFormat((String)"Excel\u6a21\u677f\u4e2d\u201c%1\u201d\u5355\u5143\u683c\u8bbe\u7f6e\u7684\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u6a21\u677f\u3002", (String)"BgmReportImportDataPlugin_011", (String)"epm-eb-formplugin", (Object[])new Object[]{"D1"}) : ResManager.loadResFormat((String)"Excel\u6a21\u677f\u4e2d\u201c%1\u201d\u5355\u5143\u683c\u8bbe\u7f6e\u7684\u5355\u4f4d\u4e0e\u62a5\u8868\u7684\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgmReportImportDataPlugin_010", (String)"epm-eb-formplugin", (Object[])new Object[]{"D1"});
                this.importBaseManager.getImportErrorManager().addFileError(errorInfo);
                return false;
            }
            boolean includeFilter = this.getIncludeFilter();
            if (includeFilter && this.importBaseManager.getImportDataTypeEnum() == ImportDataTypeEnum.empty_cover_import) {
                String errorInfo = ResManager.loadResFormat((String)"\u8bbe\u7f6e\u4e86\u7b5b\u9009\u7ef4\u5ea6\u4fe1\u606f\u7684\u6a21\u677f\u4e0d\u652f\u6301\u7a7a\u503c\u8986\u76d6\uff0c\u8bf7\u9009\u62e9\u975e\u7a7a\u503c\u8986\u76d6\u540e\u91cd\u8bd5\u3002", (String)"BgmReportImportDataPlugin_012", (String)"epm-eb-formplugin", (Object[])new Object[]{"D1"});
                this.importBaseManager.getImportErrorManager().addFileError(errorInfo);
                return false;
            }
            if (this.checkCurrentRptStatus(this.importBaseManager.getCurrentReportProcessId())) {
                String errorInfo = ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u63d0\u4ea4\uff0c\u7981\u6b62\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addFileError(errorInfo);
                return false;
            }
            Map pageDimMemberMapFromSingle = null;
            FormShowParameter formShowParameter = this.importBaseManager.getFormView().getFormShowParameter();
            Object defaultPageDimMap = formShowParameter.getCustomParam("defaultPageDimMap");
            if (defaultPageDimMap != null) {
                pageDimMemberMapFromSingle = (Map)SerializationUtils.deSerializeFromBase64((String)defaultPageDimMap.toString());
            }
            if (pageDimMemberMapFromSingle != null) {
                Boolean nopagenumber = ParamQueryServiceHelper.getBoolean((long)this.importBaseManager.getModelId(), (ParamEnum)ParamEnum.BG018);
                if (pageDimMemberMapFromSingle.size() != this.pageDimMemberMap.size() || !pageDimMemberMapFromSingle.keySet().equals(this.pageDimMemberMap.keySet())) {
                    Set keySet = pageDimMemberMapFromSingle.keySet();
                    keySet.removeAll(this.pageDimMemberMap.keySet());
                    String errorInfo = ResManager.loadResFormat((String)"\u5bfc\u5165\u6a21\u677f\u4e2d\u7684\u9875\u9762\u7ef4\u6570\u91cf\u4e0e\u5f53\u524d\u62a5\u8868\u4e0d\u4e00\u81f4\uff0c\u5dee\u5f02\u7ef4\u5ea6%1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgmReportImportDataPlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", keySet)});
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                    return false;
                }
                for (Map.Entry<String, String> entry : this.pageDimMemberMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    String s = (String)pageDimMemberMapFromSingle.get(key);
                    if (nopagenumber.booleanValue() && StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber()}) || StringUtils.equals((CharSequence)s, (CharSequence)value)) continue;
                    Dimension dimension = this.importBaseManager.getModelCacheHelper().getDimension(key);
                    String errorInfo = ResManager.loadResFormat((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u6a21\u677f\u4e2d\u7684\u9875\u9762\u7ef4\u201c%1\u201d\u4e0e\u5f53\u524d\u62a5\u8868\u662f\u5426\u4e00\u81f4\u3002", (String)"BgmReportImportDataPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension == null ? key : dimension.getName()});
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkBatchImport() {
        Long currentEntityViewId = this.importBaseManager.getCurrentEntityViewId();
        Long schemeId = this.importBaseManager.getSchemeId();
        Long schemeBizRange = this.importBaseManager.getSchemeBizRange();
        Long modelId = this.importBaseManager.getModelId();
        Long currentDataTypeId = this.importBaseManager.getCurrentDataTypeId();
        Long currentVersionId = this.importBaseManager.getCurrentVersionId();
        Long currentPeriodId = this.importBaseManager.getCurrentPeriodId();
        Long currentTemplateId = this.currentTemplateModel.getTemplateBaseInfo().getId();
        String currentDataUnit = this.currentTemplateModel.getTemplateBaseInfo().getDataunit();
        String processType = this.importBaseManager.getProcessType();
        if (this.importBaseManager.getImportTypeEnum() == ReportImportTypeEnum.IMPORT_BATCH) {
            String dataUnitFromSheet = this.getDataUnit();
            if (!StringUtils.equals((CharSequence)currentDataUnit, (CharSequence)dataUnitFromSheet)) {
                String errorInfo = null;
                errorInfo = StringUtils.isEmpty((CharSequence)dataUnitFromSheet) ? ResManager.loadResFormat((String)"Excel\u6a21\u677f\u4e2d\u201c%1\u201d\u5355\u5143\u683c\u8bbe\u7f6e\u7684\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u6a21\u677f\u3002", (String)"BgmReportImportDataPlugin_011", (String)"epm-eb-formplugin", (Object[])new Object[]{"D2"}) : ResManager.loadResFormat((String)"Excel\u6a21\u677f\u4e2d\u201c%1\u201d\u5355\u5143\u683c\u8bbe\u7f6e\u7684\u5355\u4f4d\u4e0e\u62a5\u8868\u7684\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgmReportImportDataPlugin_010", (String)"epm-eb-formplugin", (Object[])new Object[]{"D2"});
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            boolean includeFilter = this.getIncludeFilter();
            if (includeFilter && this.importBaseManager.getImportDataTypeEnum() == ImportDataTypeEnum.empty_cover_import) {
                String errorInfo = ResManager.loadResFormat((String)"\u8bbe\u7f6e\u4e86\u7b5b\u9009\u7ef4\u5ea6\u4fe1\u606f\u7684\u6a21\u677f\u4e0d\u652f\u6301\u7a7a\u503c\u8986\u76d6\uff0c\u8bf7\u9009\u62e9\u975e\u7a7a\u503c\u8986\u76d6\u540e\u91cd\u8bd5\u3002", (String)"BgmReportImportDataPlugin_012", (String)"epm-eb-formplugin", (Object[])new Object[]{"D1"});
                this.importBaseManager.getImportErrorManager().addFileError(errorInfo);
                return false;
            }
            if (StringUtils.equals((CharSequence)processType, (CharSequence)ProcessTypeEnum.REPORT.getNumber())) {
                return this.checkReportProcessPermByScheme(modelId, schemeId, schemeBizRange, currentEntityViewId, currentPeriodId, currentDataTypeId, currentVersionId, currentTemplateId);
            }
            if (BgTaskExecuteHelper.importDataTaskIsNotEnable(this.currentEntityId, currentTemplateId)) {
                String errorInfo = ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataTask_004", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            return this.checkReportProcessPermByTask();
        }
        return true;
    }

    private boolean checkReportProcessPermByTask() {
        List taskProcessList;
        Long currentEntityViewId = this.importBaseManager.getCurrentEntityViewId();
        Member currentMember = this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), currentEntityViewId, this.currentEntityId);
        if (currentMember == null) {
            return false;
        }
        List children = this.importBaseManager.getModelCacheHelper().getChildren(currentMember, true);
        Set hasPermOrgIdSet = new EntityDimPermHelper().getHasPermOrgIdSet(this.importBaseManager.getModelId(), this.currentTemplateModel.getTemplateBaseInfo().getBizModel(), currentEntityViewId);
        Set collect = children.stream().map(BaseCache::getId).collect(Collectors.toSet());
        if (hasPermOrgIdSet != null) {
            collect.retainAll(hasPermOrgIdSet);
        }
        if ((taskProcessList = new ListPanelDraw(this.importBaseManager.getModelId(), this.getUserRole(), this.getTaskPack(), this.currentEntityId + "", this.getTask(), this.getFilterCache(), this.importBaseManager.getFormView(), Boolean.valueOf(true)).hasTaskProcessList(this.currentTemplateModel.getTemplateBaseInfo().getId())) == null || taskProcessList.isEmpty()) {
            String errorInfo = ResManager.loadResFormat((String)"\u5f53\u524d\u5bfc\u5165\u6a21\u677f\u7684\u7ec4\u7ec7\u4e0e\u5de6\u6811\u9009\u62e9\u7684\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        String entityNumberStrInPageDim = this.pageDimMemberMap.get(SysDimensionEnum.Entity.getNumber());
        if (StringUtils.isNotBlank((CharSequence)entityNumberStrInPageDim)) {
            Member pageEntityDimMember = this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), currentEntityViewId, entityNumberStrInPageDim);
            if (pageEntityDimMember == null) {
                String errorInfo = ResManager.loadResFormat((String)"\u9875\u9762\u7ef4\u7ec4\u7ec7\u6210\u5458[%1]\u4e0d\u5b58\u5728\u3002", (String)"BgmReportImportDataPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumberStrInPageDim});
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            if (!collect.contains(pageEntityDimMember.getId())) {
                String errorInfo = ResManager.loadResFormat((String)"\u5f53\u524d\u5bfc\u5165\u6a21\u677f\u7684\u7ec4\u7ec7\u4e0e\u5de6\u6811\u9009\u62e9\u7684\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
        }
        return true;
    }

    private boolean checkReportProcessPermByScheme(Long modelId, Long schemeId, Long schemeBizRange, Long currentEntityViewId, Long currentPeriodId, Long currentDataTypeId, Long currentVersionId, Long currentTemplateId) {
        ReportPreparationListHelper reportPreparationListHelper = new ReportPreparationListHelper();
        Set entityTreeIdSet = reportPreparationListHelper.getEntityTreeIdSet(this.importBaseManager.getModelId(), schemeId, schemeBizRange, currentEntityViewId);
        Set templateTreeIdSet = reportPreparationListHelper.getTemplateTreeIdSet(this.importBaseManager.getModelId(), schemeId);
        if (CollectionUtils.isEmpty((Collection)entityTreeIdSet) || CollectionUtils.isEmpty((Collection)templateTreeIdSet)) {
            String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u7f16\u5236\u7684\u62a5\u8868\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataTask_007", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        Member leftTreeEntityMember = this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), currentEntityViewId, this.currentEntityId);
        if (leftTreeEntityMember != null) {
            Set hasPermOrgIdSet = new EntityDimPermHelper().getHasPermOrgIdSet(this.importBaseManager.getModelId(), this.currentTemplateModel.getTemplateBaseInfo().getBizModel(), currentEntityViewId);
            HashSet<Long> hasPermEntityIds = new HashSet<Long>(16);
            HashSet<Long> hasPermEntityIdsOnlyFilterDimPerm = new HashSet<Long>(16);
            List allRangeMembers = this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), currentEntityViewId, leftTreeEntityMember.getNumber(), RangeEnum.ALL.getIndex());
            for (Member allRangeMember : allRangeMembers) {
                if (entityTreeIdSet.contains(allRangeMember.getId())) {
                    hasPermEntityIds.add(allRangeMember.getId());
                }
                if (hasPermOrgIdSet != null && !hasPermOrgIdSet.contains(allRangeMember.getId())) continue;
                hasPermEntityIdsOnlyFilterDimPerm.add(allRangeMember.getId());
            }
            if (CollectionUtils.isEmpty(hasPermEntityIds)) {
                String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u9009\u4e2d\u7684\u5de6\u6811\u7ec4\u7ec7\u6ca1\u6709\u53ef\u7f16\u5236\u7684\u62a5\u8868\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataTask_008", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            List currentTemplateAllReportProcess = reportPreparationListHelper.getCurrentTemplateAllReportProcess(modelId, currentPeriodId, currentDataTypeId, currentVersionId, this.importBaseManager.getModelCacheHelper(), currentEntityViewId, schemeId, currentTemplateId, hasPermEntityIds);
            if (CollectionUtils.isEmpty((Collection)currentTemplateAllReportProcess)) {
                String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u9009\u4e2d\u7684\u5de6\u6811\u7ec4\u7ec7\u6ca1\u6709\u7f16\u5236\u5f53\u524d\u6a21\u677f\u7684\u62a5\u8868\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataTask_009", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            String entityNumberStrInPageDim = this.pageDimMemberMap.get(SysDimensionEnum.Entity.getNumber());
            if (StringUtils.isNotBlank((CharSequence)entityNumberStrInPageDim)) {
                Member pageEntityDimMember = this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), currentEntityViewId, entityNumberStrInPageDim);
                if (pageEntityDimMember == null) {
                    String errorInfo = ResManager.loadResFormat((String)"\u9875\u9762\u7ef4\u7ec4\u7ec7\u6210\u5458[%1]\u4e0d\u5b58\u5728\u3002", (String)"BgmReportImportDataPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumberStrInPageDim});
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                    return false;
                }
                if (!hasPermEntityIdsOnlyFilterDimPerm.contains(pageEntityDimMember.getId())) {
                    String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u6a21\u677f\u7684\u7ec4\u7ec7\u4e0e\u5de6\u6811\u9009\u62e9\u7684\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6570\u636e\u3002", (String)"BgmReportImportDataPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkViewDimension() {
        Map dimensionViews = this.currentEbSpreadManager.getDimemsionViews();
        Map pageViewDims = this.currentEbSpreadManager.getPageViewDims();
        List viewpointmembentry = this.currentTemplateModel.getViewpointmembentry();
        for (IViewPointDimensionEntry viewPointDimensionEntry : viewpointmembentry) {
            IDimension dimension = viewPointDimensionEntry.getDimension();
            PageViewDimMember pageViewDimMember = (PageViewDimMember)pageViewDims.get(dimension.getNumber());
            Long viewId = (Long)dimensionViews.get(dimension.getNumber());
            Member member = this.importBaseManager.getModelCacheHelper().getMember(dimension.getNumber(), viewId, pageViewDimMember.getNumber());
            if (member.isLeaf()) continue;
            this.pageAndViewMemIsNoleaf = true;
        }
        return true;
    }

    private boolean checkPageDimension() {
        if (MapUtils.isEmpty(this.pageDimMemberMap) && CollectionUtils.isNotEmpty((Collection)this.currentTemplateModel.getPagemembentry())) {
            String errorInfo = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9875\u9762\u7ef4\u6210\u5458\u540e\uff0c\u518d\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        Map dimensionViews = this.currentEbSpreadManager.getDimemsionViews();
        Long currentVersionId = this.importBaseManager.getCurrentVersionId();
        Long currentDataTypeId = this.importBaseManager.getCurrentDataTypeId();
        Long datasetID = this.currentTemplateModel.getTemplateBaseInfo().getDatasetID();
        Long entityViewId = this.importBaseManager.getCurrentEntityViewId();
        for (Map.Entry<String, String> entry : this.pageDimMemberMap.entrySet()) {
            String dimNum = entry.getKey();
            String memberNum = entry.getValue();
            Dimension dimension = this.importBaseManager.getModelCacheHelper().getDimension(dimNum);
            Member member = this.importBaseManager.getModelCacheHelper().getMember(dimNum, (Long)dimensionViews.get(dimNum), memberNum);
            if (StringUtils.equals((CharSequence)SysDimensionEnum.Entity.getNumber(), (CharSequence)dimNum)) {
                member = this.importBaseManager.getModelCacheHelper().getMember(dimNum, entityViewId, memberNum);
            }
            if (member == null) {
                String errorInfo = ResManager.loadResFormat((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u6a21\u677f\u4e2d\u7684\u9875\u9762\u7ef4\u201c%1\u201d\u6210\u5458\u662f\u5426\u5b58\u5728\u3002", (String)"BgmReportImportDataPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension == null ? dimNum : dimension.getName()});
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            if (!this.checkDimPermission(datasetID, dimNum, memberNum, (Long)dimensionViews.get(dimNum))) {
                String errorInfo = ResManager.loadResFormat((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u6a21\u677f\u4e2d\u201c%1\u201d\u9875\u9762\u7ef4\u7684\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5177\u6709\u7f16\u8f91\u6743\u9650\u3002", (String)"BgmReportImportDataPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension == null ? dimNum : dimension.getName()});
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            if (!member.isLeaf()) {
                this.pageAndViewMemIsNoleaf = true;
            }
            if (SysDimensionEnum.DataType.getNumber().equals(dimNum) && !currentDataTypeId.equals(member.getId())) {
                String errorInfo = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e0e\u5bfc\u5165\u62a5\u8868\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            if (!SysDimensionEnum.Version.getNumber().equals(dimNum) || currentVersionId.equals(member.getId())) continue;
            String errorInfo = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e0e\u5bfc\u5165\u62a5\u8868\u7684\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        return true;
    }

    protected boolean checkDimPermission(Long datasetId, String dimNum, String memberNum, Long viewId) {
        Long busModelId = this.busModelIdMap.computeIfAbsent(datasetId, t -> DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId));
        IMemberPermCache memberPermCache = this.memberPermCacheMap.computeIfAbsent(busModelId, t -> MemberPermCacheServiceHelper.build(null, (Long)this.importBaseManager.getModelId(), (Long)busModelId, null));
        return memberPermCache.hasWritePerm(dimNum, memberNum, viewId);
    }

    private boolean checkCurrentSheetReportProcess() {
        Long currentPeriodId = this.importBaseManager.getCurrentPeriodId();
        Long currentDataTypeId = this.importBaseManager.getCurrentDataTypeId();
        Long currentVersionId = this.importBaseManager.getCurrentVersionId();
        Long modelId = this.importBaseManager.getModelId();
        Long templateId = this.currentTemplateModel.getTemplateBaseInfo().getId();
        ReportProcess reportProcess = ReportProcessServiceImpl.getInstance().getReportProcess(modelId, templateId, this.currentEntityId, currentPeriodId, currentDataTypeId, currentVersionId);
        if (reportProcess != null) {
            String status = reportProcess.getStatus();
            if (BgTaskStateEnum.UNDERWAY.getNumber().equals(status)) {
                String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5bf9\u5e94\u7684\u62a5\u8868\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
            if (BgTaskStateEnum.COMPLETED.getNumber().equals(status)) {
                String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5bf9\u5e94\u7684\u62a5\u8868\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return false;
            }
        } else {
            Member member = this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), this.importBaseManager.getCurrentEntityViewId(), this.currentEntityId);
            List parents = this.importBaseManager.getModelCacheHelper().getParents(this.importBaseManager.getCurrentEntityViewId(), member, false);
            Set parentIds = parents.stream().map(BaseCache::getId).collect(Collectors.toSet());
            List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(modelId, currentPeriodId, currentDataTypeId, currentVersionId, parentIds, Collections.singleton(templateId));
            if (CollectionUtils.isNotEmpty((Collection)reportProcessList)) {
                for (ReportProcess process : reportProcessList) {
                    String status = process.getStatus();
                    if (BgTaskStateEnum.UNDERWAY.getNumber().equals(status)) {
                        String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u5bf9\u5e94\u7684\u62a5\u8868\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                        return false;
                    }
                    if (!BgTaskStateEnum.COMPLETED.getNumber().equals(status)) continue;
                    String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u5bf9\u5e94\u7684\u62a5\u8868\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean beforeImport() {
        this.stopwatch = Stopwatch.createStarted();
        if (this.importBaseManager.getImportErrorManager().hasSheetError(this.importBaseManager.getCurrentWorkBookIndex(), this.sheetName)) {
            return false;
        }
        boolean passLegal = this.checkTemplateLegal();
        if (!passLegal) {
            return false;
        }
        this.initImportReportDataModel();
        log.info("importSheetManager:templateNumber:" + this.currentTemplateModel.getTemplateBaseInfo().getNumber());
        boolean passSingleCheck = this.checkSingleImport();
        if (!passSingleCheck) {
            return false;
        }
        boolean passBatchCheck = this.checkBatchImport();
        if (!passBatchCheck) {
            return false;
        }
        this.setCurrentReportEntityId();
        boolean passCheckReportProcess = this.checkCurrentSheetReportProcess();
        if (!passCheckReportProcess) {
            return false;
        }
        this.initSpreadManager();
        boolean passPageDimensionCheck = this.checkPageDimension();
        if (!passPageDimensionCheck) {
            return false;
        }
        boolean passViewDimensionCheck = this.checkViewDimension();
        if (!passViewDimensionCheck) {
            return false;
        }
        if (this.pageAndViewMemIsNoleaf && !CommonUtils.editNoLeafCell((Long)this.importBaseManager.getModelId())) {
            String errorInfo = ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u6216\u9690\u85cf\u7ef4\u5b58\u5728\u975e\u660e\u7ec6\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return false;
        }
        boolean passLock = this.initLockCells();
        return passLock;
    }

    private boolean initLockCells() {
        this.lockCellsMap.clear();
        ArrayList spreadLockControls = new ArrayList(16);
        String lockTableErrorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u5df2\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6570\u636e\u3002", (String)"ImportSheetManager_01", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        this.abstractReportPlugin.resolveSpreadLockController(spreadLockControls);
        if (this.currentTemplateModel instanceof DefaultTemplateModel) {
            for (ISpreadLockControl spreadLockControl : spreadLockControls) {
                SpreadLockContext spreadLockContext = new SpreadLockContext(this.currentEbSpreadManager, this.currentTemplateModel);
                spreadLockContext.setImportData(true);
                spreadLockControl.control(spreadLockContext);
                if (spreadLockContext.isStopcommand()) {
                    log.info("lock table control:" + spreadLockControl.getClass().getSimpleName());
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), lockTableErrorInfo, this.sheetName);
                    return false;
                }
                Map lockCells = spreadLockContext.getLockCells();
                if (lockCells == null || lockCells.size() <= 0) continue;
                this.lockCellsMap.put(spreadLockControl, lockCells);
            }
        } else {
            for (ISpreadLockControl spreadLockControl : spreadLockControls) {
                FixSpreadLockContext fixSpreadLockContext = new FixSpreadLockContext(this.currentEbSpreadManager, this.currentTemplateModel);
                fixSpreadLockContext.setImportData(true);
                spreadLockControl.controlfix(fixSpreadLockContext);
                if (fixSpreadLockContext.isStopcommand()) {
                    log.info("lock table control:" + spreadLockControl.getClass().getSimpleName());
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), lockTableErrorInfo, this.sheetName);
                    return false;
                }
                if (!CollectionUtils.isNotEmpty((Collection)fixSpreadLockContext.getAreasStyles())) continue;
                HashMap<Integer, Set> lockCellsTemp = new HashMap<Integer, Set>(16);
                for (AreasStyle areasStyle : fixSpreadLockContext.getAreasStyles()) {
                    List range = areasStyle.getRange();
                    if (!CollectionUtils.isNotEmpty((Collection)range)) continue;
                    for (CellArea cellArea : range) {
                        int r = cellArea.getR();
                        int rc = cellArea.getRc();
                        int c = cellArea.getC();
                        int cc = cellArea.getCc();
                        for (int i = r; i < r + rc; ++i) {
                            Set integers = lockCellsTemp.computeIfAbsent(i, t -> new HashSet(16));
                            for (int i1 = c; i1 < c + cc; ++i1) {
                                integers.add(i1);
                            }
                        }
                    }
                }
                if (lockCellsTemp.size() <= 0) continue;
                this.lockCellsMap.put(spreadLockControl, lockCellsTemp);
            }
        }
        return true;
    }

    private void setCurrentReportEntityId() {
        Member member;
        Long currentEntityViewId = this.importBaseManager.getCurrentEntityViewId();
        List viewpointmembentry = this.currentTemplateModel.getViewpointmembentry();
        for (IViewPointDimensionEntry iViewPointDimensionEntry : viewpointmembentry) {
            IDimensionMember iDimensionMember = iViewPointDimensionEntry.getMember();
            IDimension dimension = iViewPointDimensionEntry.getDimension();
            if (dimension == null || !StringUtils.equals((CharSequence)SysDimensionEnum.Entity.getNumber(), (CharSequence)dimension.getNumber()) || (member = this.importBaseManager.getModelCacheHelper().getMember(dimension.getNumber(), currentEntityViewId, iDimensionMember.getNumber())) == null) continue;
            this.currentEntityId = member.getId();
            break;
        }
        for (Map.Entry entry : this.pageDimMemberMap.entrySet()) {
            String dimNum = (String)entry.getKey();
            String memberNum = (String)entry.getValue();
            if (!StringUtils.equals((CharSequence)SysDimensionEnum.Entity.getNumber(), (CharSequence)dimNum)) continue;
            member = this.importBaseManager.getModelCacheHelper().getMember(dimNum, currentEntityViewId, memberNum);
            if (member == null) break;
            this.currentEntityId = member.getId();
            break;
        }
    }

    private String getTaskPack() {
        FormShowParameter formShowParameter = this.importBaseManager.getFormView().getFormShowParameter();
        Object CURRENT_TASKP = formShowParameter.getCustomParam("current_taskp");
        return CURRENT_TASKP == null ? "" : CURRENT_TASKP + "";
    }

    private String getTask() {
        FormShowParameter formShowParameter = this.importBaseManager.getFormView().getFormShowParameter();
        Object CURRENT_TASKP = formShowParameter.getCustomParam("current_task");
        return CURRENT_TASKP == null ? "" : CURRENT_TASKP + "";
    }

    private String getFilterCache() {
        FormShowParameter formShowParameter = this.importBaseManager.getFormView().getFormShowParameter();
        Object CURRENT_TASKP = formShowParameter.getCustomParam("filterCache");
        return CURRENT_TASKP == null ? "" : CURRENT_TASKP + "";
    }

    private String getUserRole() {
        FormShowParameter formShowParameter = this.importBaseManager.getFormView().getFormShowParameter();
        Object CURRENT_TASKP = formShowParameter.getCustomParam("userRole");
        return CURRENT_TASKP == null ? "" : CURRENT_TASKP + "";
    }

    private AbstractReportPlugin initReportPlugin(Map<String, String> pageDimMemberMap, IModelCacheHelper modelCacheHelper) {
        Member orgMember;
        boolean isFixReport = BgTemplateTypeEnum.EBFIX.getNumber().equals(String.valueOf(this.currentTemplateModel.getTemplateBaseInfo().getTemplatetype()));
        Long currentEntityViewId = this.importBaseManager.getCurrentEntityViewId();
        POISpreadContainer poiSpreadContainer = new POISpreadContainer();
        poiSpreadContainer.setHasRebuild(true);
        poiSpreadContainer.setImportData(true);
        AbstractReportPlugin abstractReportPlugin = isFixReport ? new POIFixReportProcess((ISpreadContainer)poiSpreadContainer, "", null, false) : new POIDynamicReportProcess((ISpreadContainer)poiSpreadContainer, "", false);
        abstractReportPlugin.setView(this.importBaseManager.getFormView());
        abstractReportPlugin.initialize();
        abstractReportPlugin.setTaskProcessId(this.importBaseManager.getTaskProcessId());
        Long reportProcessId = this.importBaseManager.getCurrentReportProcessId();
        if (IDUtils.isEmptyLong((Long)reportProcessId).booleanValue()) {
            Long currentPeriodId = this.importBaseManager.getCurrentPeriodId();
            Long currentDataTypeId = this.importBaseManager.getCurrentDataTypeId();
            Long currentVersionId = this.importBaseManager.getCurrentVersionId();
            Long templateId = this.currentTemplateModel.getTemplateBaseInfo().getId();
            Long currentEntityId = this.importBaseManager.getCurrentEntityId();
            ReportProcess reportProcess = ReportProcessServiceImpl.getInstance().getReportProcess(this.importBaseManager.getModelId(), templateId, currentEntityId, currentPeriodId, currentDataTypeId, currentVersionId);
            if (reportProcess != null) {
                reportProcessId = reportProcess.getId();
            }
        }
        if ((orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), currentEntityViewId, this.importBaseManager.getCurrentEntityId())) != null) {
            abstractReportPlugin.setCurrentEntityNumber(orgMember.getNumber());
            abstractReportPlugin.setCurrentEntityViewId(IDUtils.toString((Object)currentEntityViewId));
            abstractReportPlugin.setCurrentEntityLongNumber(orgMember.getLongNumber());
        }
        abstractReportPlugin.setProcessId(reportProcessId);
        abstractReportPlugin.setProcessType(this.importBaseManager.getProcessType());
        this.currentTemplateModel = ExportHelper.setDefaultPageDimMapToTemplateModel(pageDimMemberMap, (ITemplateModel)this.currentTemplateModel, (IModelCacheHelper)modelCacheHelper);
        abstractReportPlugin.setTemplateModel(this.currentTemplateModel);
        Map dimensionView = this.currentTemplateModel.getDimensionView();
        dimensionView.put(SysDimensionEnum.Entity.getNumber(), this.importBaseManager.getCurrentEntityViewId());
        abstractReportPlugin.setDefaultDimMember(ReportExportHelper.getInstance().getDefaultDimMemberIdMap(pageDimMemberMap, modelCacheHelper, dimensionView));
        this.importBaseManager.getFormView().getPageCache().put("bgtemplate_info", ObjectSerialUtil.toByteSerialized((Object)this.currentTemplateModel.getTemplateBaseInfo()));
        this.importBaseManager.getFormView().getPageCache().put("CURRENT_PERIOD", this.importBaseManager.getCurrentPeriodId() + "");
        if (!isFixReport) {
            ((POIDynamicReportProcess)abstractReportPlugin).setImportData(true);
        } else {
            abstractReportPlugin.setImportData(true);
        }
        abstractReportPlugin.afterCreateNewData(null);
        return abstractReportPlugin;
    }

    private Map<String, String> getPageDimMemberMap(ITemplateModel templateModel) {
        LinkedHashMap<String, String> pageDimMemberMap = new LinkedHashMap<String, String>(16);
        List pagemembentry = templateModel.getPagemembentry();
        List iPageDimensionEntries = ReportExportHelper.getInstance().sortPageDimList(pagemembentry);
        Boolean nopagenumber = ParamQueryServiceHelper.getBoolean((long)templateModel.getModelId(), (ParamEnum)ParamEnum.BG018);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
        int notExportPageMumberCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)iPageDimensionEntries)) {
            for (int i = 0; i < iPageDimensionEntries.size(); ++i) {
                IPageDimensionEntry pageDimensionEntry = (IPageDimensionEntry)iPageDimensionEntries.get(i);
                IDimension dimension = pageDimensionEntry.getDimension();
                String dimensionNumber = dimension.getNumber();
                String memberNum = this.getPageDimMemberFromSheet(i - notExportPageMumberCount);
                if (nopagenumber.booleanValue() && StringUtils.equalsAny((CharSequence)dimensionNumber, (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber()}) && nopagenumber.booleanValue()) {
                    ++notExportPageMumberCount;
                    memberNum = null;
                }
                if (StringUtils.isBlank((CharSequence)memberNum)) {
                    if (nopagenumber.booleanValue() && StringUtils.equalsAny((CharSequence)dimensionNumber, (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber()})) {
                        FormShowParameter formShowParameter;
                        Object defaultPageDimMap;
                        Map pageDimMemberMapFromSingle = null;
                        if (this.importBaseManager.getImportTypeEnum() == ReportImportTypeEnum.IMPORT_SINGLE && (defaultPageDimMap = (formShowParameter = this.importBaseManager.getFormView().getFormShowParameter()).getCustomParam("defaultPageDimMap")) != null) {
                            pageDimMemberMapFromSingle = (Map)SerializationUtils.deSerializeFromBase64((String)defaultPageDimMap.toString());
                        }
                        switch (dimensionNumber) {
                            case "Entity": {
                                Member member = modelCacheHelper.getMember(dimensionNumber, this.importBaseManager.getCurrentEntityViewId(), this.importBaseManager.getCurrentEntityId());
                                if (pageDimMemberMapFromSingle != null && pageDimMemberMapFromSingle.containsKey(dimensionNumber)) {
                                    member = modelCacheHelper.getMember(dimensionNumber, this.importBaseManager.getCurrentEntityViewId(), (String)pageDimMemberMapFromSingle.get(dimensionNumber));
                                }
                                if (member != null) {
                                    pageDimMemberMap.put(dimensionNumber, member.getNumber());
                                    break;
                                }
                                pageDimMemberMap.put(dimensionNumber, null);
                                break;
                            }
                            case "Version": {
                                Member version = modelCacheHelper.getMember(dimensionNumber, null, this.importBaseManager.getCurrentVersionId());
                                if (pageDimMemberMapFromSingle != null && pageDimMemberMapFromSingle.containsKey(dimensionNumber)) {
                                    version = modelCacheHelper.getMember(dimensionNumber, null, (String)pageDimMemberMapFromSingle.get(dimensionNumber));
                                }
                                if (version != null) {
                                    pageDimMemberMap.put(dimensionNumber, version.getNumber());
                                    break;
                                }
                                pageDimMemberMap.put(dimensionNumber, null);
                                break;
                            }
                            case "DataType": {
                                Member dataType = modelCacheHelper.getMember(dimensionNumber, null, this.importBaseManager.getCurrentDataTypeId());
                                if (pageDimMemberMapFromSingle != null && pageDimMemberMapFromSingle.containsKey(dimensionNumber)) {
                                    dataType = modelCacheHelper.getMember(dimensionNumber, null, (String)pageDimMemberMapFromSingle.get(dimensionNumber));
                                }
                                if (dataType != null) {
                                    pageDimMemberMap.put(dimensionNumber, dataType.getNumber());
                                    break;
                                }
                                pageDimMemberMap.put(dimensionNumber, null);
                            }
                        }
                        continue;
                    }
                    pageDimMemberMap.put(dimensionNumber, null);
                    continue;
                }
                pageDimMemberMap.put(dimensionNumber, memberNum);
            }
        }
        return pageDimMemberMap;
    }

    private String getPageDimMemberFromSheet(int rowIndex) {
        return this.getCellValue(rowIndex + 1, 2);
    }

    private boolean checkCurrentRptStatus(Long currentRptId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentRptId)});
        if (dynamicObject == null) {
            return false;
        }
        String status = dynamicObject.getString("status");
        return BgTaskStateEnum.COMPLETED.getNumber().equals(status) || BgTaskStateEnum.UNDERWAY.getNumber().equals(status);
    }

    private String getSpreadKey() {
        return "report";
    }

    private boolean checkLeafFloatAreaRowIsOnlyOne(List<MultiAreaManager> multiAreaManager, ExportTemplateHelper exportTemplateHelper, Map<Integer, String> areaPosMap, Map<Integer, List<ReportImportDataFloatArea>> floatAreaMap) {
        for (int i = 0; i < multiAreaManager.size(); ++i) {
            MultiAreaManager areaManager = multiAreaManager.get(i);
            RangeModel areaRange = areaManager.getAreaRange();
            areaPosMap.put(i, areaRange.toString());
            Map<String, List<ECell>> floatAreaMapCells = exportTemplateHelper.getFloatAreaCellsList(areaManager);
            String rangeTypeStr = "";
            for (Map.Entry<String, List<ECell>> entry : floatAreaMapCells.entrySet()) {
                List<ECell> eCellList = entry.getValue();
                String floatAreaFirstPos = exportTemplateHelper.getFloatAreaFirstPos(eCellList, areaManager.getValueAreaStart());
                String floatAreaLastPos = exportTemplateHelper.getFloatAreaLastPos(eCellList, areaManager.getValueAreaStart());
                ECell eCell = eCellList.get(0);
                Object rangeType = eCell.getUserObject("rangeType", (Object)0);
                if (rangeType != null && StringUtils.equals((CharSequence)rangeType.toString(), (CharSequence)"0") && StringUtils.equals((CharSequence)floatAreaFirstPos, (CharSequence)floatAreaLastPos)) {
                    String errorInfo = ResManager.loadResFormat((String)"\u6d6e\u52a8\u6a21\u677f\u201c%1\u201d\u7684\u6bcf\u4e2a\u660e\u7ec6\u6d6e\u52a8\u533a\u57df\u8303\u56f4\u81f3\u5c11\u6709\u4e24\u884c\u624d\u5141\u8bb8\u5bfc\u5165\uff0c\u8bf7\u4fee\u6539\u6a21\u677f\u540e\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[]{this.currentTemplateModel.getTemplateBaseInfo().getName()});
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                    return true;
                }
                if (rangeType != null) {
                    rangeTypeStr = rangeType.toString();
                }
                ReportImportDataFloatArea reportImportDataFloatArea = new ReportImportDataFloatArea();
                reportImportDataFloatArea.setFloatAreaFirstPos(floatAreaFirstPos);
                reportImportDataFloatArea.setFloatAreaLastPos(floatAreaLastPos);
                reportImportDataFloatArea.setRangeType(rangeTypeStr);
                List reportImportDataFloatAreas = floatAreaMap.computeIfAbsent(i, t -> new ArrayList(16));
                reportImportDataFloatAreas.add(reportImportDataFloatArea);
            }
        }
        return false;
    }

    private Member getAreaHiddenMetricMember(MultiAreaManager areaManager, Map<String, Long> dimemsionViews) {
        PageViewDimMember pageViewDimMember;
        Map areaPageViewDims = areaManager.getAreaPageViewDims();
        if (areaPageViewDims != null && (pageViewDimMember = (PageViewDimMember)areaPageViewDims.get(SysDimensionEnum.Metric.getNumber())) != null) {
            Long metricViewId = dimemsionViews.get(SysDimensionEnum.Metric.getNumber());
            return this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), metricViewId, pageViewDimMember.getNumber());
        }
        return null;
    }

    private Member getPageViewMetricMember(Map<String, Long> dimemsionViews) {
        PageViewDimMember pageViewDimMember;
        Map pageViewDims = this.currentEbSpreadManager.getPageViewDims();
        if (pageViewDims != null && (pageViewDimMember = (PageViewDimMember)pageViewDims.get(SysDimensionEnum.Metric.getNumber())) != null) {
            String number = pageViewDimMember.getNumber();
            Long metricViewId = dimemsionViews.get(SysDimensionEnum.Metric.getNumber());
            return this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), metricViewId, number);
        }
        return null;
    }

    private boolean checkAreaHiddenDimPerm(IMultiAreaSetting setting, Long datasetID, Map<String, Long> dimemsionViews, String areaRangePos) {
        boolean flag1 = false;
        List areaViewpointmembentry = setting.getAreaViewpointmembentry();
        for (IViewPointDimensionEntry viewPointDimensionEntry : areaViewpointmembentry) {
            IDimension dimension = viewPointDimensionEntry.getDimension();
            IDimensionMember member = viewPointDimensionEntry.getMember();
            Long viewId = DimensionViewServiceHelper.getViewId(dimemsionViews, (String)dimension.getNumber(), (String)setting.getAreaRangeStart());
            if (this.checkDimPermission(datasetID, dimension.getNumber(), member.getNumber(), viewId)) continue;
            flag1 = true;
            Long entityViewId = dimemsionViews.get(dimension.getNumber());
            Member member1 = this.importBaseManager.getModelCacheHelper().getMember(dimension.getNumber(), entityViewId, member.getNumber());
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u6570\u636e\u533a\u57df\u201c%1\u201d\u9690\u85cf\u7ef4\u5b58\u5728\u6ca1\u6709\u7f16\u8f91\u6743\u9650\u7684\u6210\u5458\u201c%2\u201d\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{areaRangePos, member1 == null ? member.getNumber() : member1.getName()}), this.sheetName);
        }
        return !flag1;
    }

    private Map<Integer, Integer> updateFloatAreaMember(MultiAreaManager areaManager, List<ReportImportDataFloatArea> reportImportDataFloatAreas, int rowOffset, int yOffset, int colOffset, String areaOverlap, String areaRangePos, AutoFloatHelper autoFloatHelper, Map<String, Long> dimensionViews, Set<Integer> notUpdateValueRowIndexSet) {
        Map<Integer, Integer> excelMaRowMap = new LinkedHashMap<Integer, Integer>(16);
        if (CollectionUtils.isEmpty(reportImportDataFloatAreas)) {
            return excelMaRowMap;
        }
        if (this.importBaseManager.getImportErrorManager().hasSheetError(this.importBaseManager.getCurrentWorkBookIndex(), this.sheetName)) {
            return excelMaRowMap;
        }
        ExportTemplateHelper exportTemplateHelper = new ExportTemplateHelper();
        if (areaManager.getFloatonWhere() != -1) {
            MultiAreaManager.ValueArea valueAreaStart = areaManager.getValueAreaStart();
            int data_row_start = valueAreaStart.getData_row_start();
            int row_start = valueAreaStart.getRow_start();
            int col_start = valueAreaStart.getCol_start();
            String areaIndex = areaManager.getAreaIndex();
            Map<Integer, String> floatColDimMap = exportTemplateHelper.getFloatColDimMap(areaManager);
            LinkedHashMap<Integer, Map> floatMemberIndexMapMap = new LinkedHashMap<Integer, Map>(16);
            LinkedHashMap<String, List<Integer>> memberExcelRowMap = new LinkedHashMap<String, List<Integer>>(16);
            LinkedHashMap<Integer, List> memberNumberRowMap = new LinkedHashMap<Integer, List>(16);
            HashMap<String, Map> dimMemNameCountMap = new HashMap<String, Map>(8);
            LinkedHashMap<Integer, StringBuilder> rowDimMemStrMap = new LinkedHashMap<Integer, StringBuilder>(100);
            for (ReportImportDataFloatArea reportImportDataFloatArea : reportImportDataFloatAreas) {
                String floatFirstPos = reportImportDataFloatArea.getFloatAreaFirstPos();
                String floatLastPos = reportImportDataFloatArea.getFloatAreaLastPos();
                Point firstPoint = ExcelUtils.pos2Point((String)floatFirstPos);
                Point lastPoint = ExcelUtils.pos2Point((String)floatLastPos);
                int lastRowNum = this.tableData.size();
                int excelFloatAreaFirstRow = firstPoint.y + rowOffset + yOffset;
                int excelFloatAreaLastRow = lastPoint.y + rowOffset + yOffset;
                int excelFloatAreaFirstCol = firstPoint.x + colOffset;
                int excelFloatAreaLastCol = lastPoint.x + colOffset;
                boolean firstFlag = false;
                boolean lastFlag = false;
                for (int i = rowOffset; i < lastRowNum; ++i) {
                    String[] split;
                    String value = this.getCellValue(i, 0);
                    if (StringUtils.isBlank((CharSequence)value)) continue;
                    for (String s : split = value.split(";")) {
                        if (!firstFlag && StringUtils.equals((CharSequence)floatFirstPos, (CharSequence)s)) {
                            firstFlag = true;
                            excelFloatAreaFirstRow = i;
                            break;
                        }
                        if (lastFlag || !StringUtils.equals((CharSequence)floatLastPos, (CharSequence)s)) continue;
                        lastFlag = true;
                        excelFloatAreaLastRow = i;
                        break;
                    }
                    if (firstFlag && lastFlag) break;
                }
                if (!lastFlag && StringUtils.equals((CharSequence)floatFirstPos, (CharSequence)floatLastPos)) {
                    excelFloatAreaLastRow = excelFloatAreaFirstRow;
                } else if (!firstFlag || !lastFlag) {
                    String errorInfo = ResManager.loadResFormat((String)"\u672a\u627e\u5230\u6d6e\u52a8\u533a\u57df\u201c%1\u201d\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u6a21\u677f\uff0c\u586b\u5199\u6570\u636e\u540e\u518d\u5bfc\u5165\u3002", (String)"BgmReportImportDataTask_002", (String)"epm-eb-formplugin", (Object[])new Object[]{floatFirstPos + ":" + floatLastPos});
                    this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                    return excelMaRowMap;
                }
                for (int rowIndex = excelFloatAreaFirstRow; rowIndex <= excelFloatAreaLastRow; ++rowIndex) {
                    for (int colIndex = excelFloatAreaFirstCol; colIndex <= excelFloatAreaLastCol; ++colIndex) {
                        String valueStr;
                        int maCol = colIndex - colOffset;
                        String floatDimNum = floatColDimMap.get(colIndex - colOffset - col_start);
                        String cellValue = this.getCellValue(rowIndex, colIndex);
                        if (cellValue == null || StringUtils.isBlank((CharSequence)cellValue.toString()) || specialCharacters.contains(valueStr = cellValue.toString().trim())) continue;
                        Long dimViewId = IDUtils.toLong((Object)DimensionViewServiceHelper.getViewId(dimensionViews, (String)floatDimNum, (String)areaIndex));
                        String cacheKey = floatDimNum + '.' + dimViewId;
                        Map memNameCountMap = dimMemNameCountMap.computeIfAbsent(cacheKey, k -> {
                            Member rootMember = this.importBaseManager.getModelCacheHelper().getRootMember(floatDimNum, dimViewId);
                            String rootNumber = rootMember != null ? rootMember.getNumber() : floatDimNum;
                            List viewMembers = EpmThreadLocalUtils.getMemberRange((long)this.importBaseManager.getModelId(), (String)floatDimNum, (long)dimViewId, (String)rootNumber, (int)RangeEnum.ALL.getIndex());
                            return viewMembers.stream().filter(m -> Objects.nonNull(m) && StringUtils.isNotBlank((CharSequence)m.getName())).collect(Collectors.toMap(Member::getName, xva$0 -> Lists.newArrayList((Object[])new Member[]{xva$0}), (o1, o2) -> {
                                o1.addAll(o2);
                                return o1;
                            }));
                        });
                        Member member = null;
                        boolean find = false;
                        if (valueStr.contains("@")) {
                            String[] split = valueStr.split("@");
                            String memberNum = split[0];
                            member = this.importBaseManager.getModelCacheHelper().getMember(floatDimNum, dimViewId, memberNum);
                            if (member != null) {
                                find = true;
                            }
                            if (!find) {
                                String errorInfo = ResManager.loadResFormat((String)"%1\u5355\u5143\u683c\u586b\u5165\u7684\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u662f\u5426\u5728\u89c6\u56fe\u6210\u5458\u8303\u56f4\u5185\u3002", (String)"BgmReportImportDataPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)(colIndex + 1), (int)rowIndex)});
                                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName, rowIndex);
                                notUpdateValueRowIndexSet.add(rowIndex);
                            }
                        } else {
                            String errorInfo;
                            List matchMems = (List)memNameCountMap.get(valueStr);
                            if (CollectionUtils.isEmpty((Collection)matchMems)) {
                                errorInfo = ResManager.loadResFormat((String)"%1\u5355\u5143\u683c\u586b\u5165\u7684\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540d\u79f0\u662f\u5426\u5728\u89c6\u56fe\u6210\u5458\u8303\u56f4\u5185\u3002", (String)"ImportSheetManager_2", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)(colIndex + 1), (int)rowIndex)});
                                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName, rowIndex);
                                notUpdateValueRowIndexSet.add(rowIndex);
                            } else if (matchMems.size() > 1) {
                                errorInfo = ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u586b\u5165\u7684\u6210\u5458\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u540c\u540d\u6210\u5458\uff0c\u8bf7\u4ee5\u201c\u7f16\u7801@\u540d\u79f0\u201d\u91cd\u65b0\u586b\u62a5\uff0c\u6216\u4e8e\u7ef4\u5ea6\u7ba1\u7406\u4e2d\u4fee\u6539\u7ef4\u5ea6\u6210\u5458\u540d\u79f0\u4f7f\u540d\u79f0\u552f\u4e00\u3002", (String)"BgmReportImportDataPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)(colIndex + 1), (int)rowIndex)});
                                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName, rowIndex);
                                notUpdateValueRowIndexSet.add(rowIndex);
                            } else {
                                member = (Member)matchMems.get(0);
                            }
                        }
                        Map rowMemberListMap = floatMemberIndexMapMap.computeIfAbsent(firstPoint.y, t -> new LinkedHashMap(16));
                        List members = rowMemberListMap.computeIfAbsent(maCol, t -> new ArrayList(16));
                        List rowMemberNumList = memberNumberRowMap.computeIfAbsent(rowIndex, t -> new ArrayList(16));
                        if (member != null) {
                            members.add(member);
                            rowMemberNumList.add(member.getNumber());
                            StringBuilder sb = rowDimMemStrMap.computeIfAbsent(rowIndex, k -> new StringBuilder());
                            sb.append(member.getNumber()).append("@");
                            continue;
                        }
                        members.add(null);
                        rowMemberNumList.add("");
                    }
                }
            }
            this.checkRepeatFloatRow(notUpdateValueRowIndexSet, rowDimMemStrMap);
            for (Map.Entry entry : memberNumberRowMap.entrySet()) {
                Integer key = (Integer)entry.getKey();
                List value = (List)entry.getValue();
                List integers = memberExcelRowMap.computeIfAbsent(String.join((CharSequence)",", value), t -> new ArrayList(16));
                integers.add(key);
            }
            int preInsertFloatRow = 0;
            int size = areaManager.getData().getDataSheet().getTable().size();
            for (Map.Entry entry : floatMemberIndexMapMap.entrySet()) {
                int n = (Integer)entry.getKey();
                Map value = (Map)entry.getValue();
                int beforeInsertTableSize = areaManager.getData().getDataSheet().getTable().size();
                boolean templateLockFlag = true;
                for (Map.Entry integerListEntry : value.entrySet()) {
                    int maCol = (Integer)integerListEntry.getKey();
                    List insertMembers = (List)integerListEntry.getValue();
                    int realBeginRow = n + preInsertFloatRow + this.preAreaInsertFloatRow;
                    ECell eCell = areaManager.getData().getDataSheet().getECellNotAdd(realBeginRow - row_start, maCol - col_start);
                    if (eCell != null && "true".equals(eCell.getUserObject("fixMember"))) continue;
                    autoFloatHelper.setValueIntoSpreadManager(insertMembers, areaManager, realBeginRow, maCol, false, false, false, null, null);
                    if (!templateLockFlag) continue;
                    int dataColSize = areaManager.getColpartitionDimMems().size();
                    for (int i = 0; i < dataColSize; ++i) {
                        int dataFirstRow = realBeginRow - row_start;
                        int dataCol = maCol - col_start + valueAreaStart.getData_col_start() - col_start + i;
                        ECell dataCell = areaManager.getData().getDataSheet().getECellNotAdd(dataFirstRow, dataCol);
                        if (dataCell == null || !Boolean.TRUE.equals(dataCell.getUserObject("l"))) continue;
                        int floatRowSize = insertMembers.size();
                        for (int k2 = 0; k2 < floatRowSize; ++k2) {
                            this.templateLockCellSet.add(dataFirstRow + k2 + "@" + dataCol);
                        }
                    }
                    templateLockFlag = false;
                }
                int afterInsertTableSize = areaManager.getData().getDataSheet().getTable().size();
                preInsertFloatRow += afterInsertTableSize - beforeInsertTableSize;
            }
            if (!"row".equals(areaOverlap)) {
                this.preAreaInsertFloatRow += areaManager.getData().getDataSheet().getTable().size() - size;
            }
            excelMaRowMap = this.buildFloatAreaManagerAndExcelRowMap(areaManager, memberExcelRowMap, data_row_start, row_start, areaOverlap, areaRangePos);
        }
        return excelMaRowMap;
    }

    private void checkRepeatFloatRow(Set<Integer> notUpdateValueRowIndexSet, Map<Integer, StringBuilder> rowDimMemStrMap) {
        HashMap<String, Integer> rowDimMemMap = new HashMap<String, Integer>(rowDimMemStrMap.size());
        for (Map.Entry<Integer, StringBuilder> entry : rowDimMemStrMap.entrySet()) {
            Integer excelRow = entry.getKey();
            if (notUpdateValueRowIndexSet.contains(excelRow)) continue;
            String memStr = entry.getValue().toString();
            Integer existRow = (Integer)rowDimMemMap.get(memStr);
            if (existRow == null) {
                rowDimMemMap.put(memStr, excelRow);
                continue;
            }
            if (existRow.equals(excelRow)) continue;
            this.importBaseManager.getImportErrorManager().addCellInfo(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u201c%1\u201d\u884c\u91cd\u590d\u3002", (String)"BgmReportImportDataPlugin_68", (String)"epm-eb-formplugin", (Object[])new Object[]{existRow + 1}), this.sheetName, excelRow);
        }
    }

    private Map<Integer, Integer> buildFloatAreaManagerAndExcelRowMap(MultiAreaManager areaManager, Map<String, List<Integer>> memberExcelRowMap, int data_row_start, int row_start, String areaOverlap, String areaRangePos) {
        LinkedHashMap<Integer, Integer> excelMaRowMap = new LinkedHashMap<Integer, Integer>(16);
        int maDataRow = data_row_start - 1;
        if (areaManager.getFloatonWhere() == 0) {
            maDataRow = row_start - 1;
        }
        for (List eCells : areaManager.getData().getDataSheet().getTable()) {
            List<ImportCell> rowData;
            Integer i;
            List<Integer> integers;
            ++maDataRow;
            if (CollectionUtils.isEmpty((Collection)eCells)) continue;
            ArrayList<String> rowMemberNumberList = new ArrayList<String>(16);
            for (ECell eCell : eCells) {
                Object number;
                if (eCell == null || (number = eCell.getUserObject("number")) == null || StringUtils.isBlank((CharSequence)number.toString())) continue;
                rowMemberNumberList.add(number.toString());
            }
            if (CollectionUtils.isEmpty(rowMemberNumberList) || CollectionUtils.isEmpty(integers = memberExcelRowMap.get(String.join((CharSequence)",", rowMemberNumberList)))) continue;
            if (integers.size() != 1) {
                Collections.sort(integers);
                Collections.reverse(integers);
            }
            if ((i = integers.get(0)) == null || CollectionUtils.isEmpty(rowData = this.tableData.get(i))) continue;
            boolean nextArea = this.isNextArea(areaOverlap, areaManager, i, areaRangePos);
            if (nextArea) break;
            excelMaRowMap.put(i, maDataRow);
        }
        return excelMaRowMap;
    }

    private void updateFixValue(MultiAreaManager areaManager, Map<Integer, Integer> excelMaRowMap, int rowOffset, int yOffset, int colOffset, String areaOverlap, String areaRangePos, Set<Integer> notUpdateValueRowIndexSet, SpreadJsAction spreadJsAction, Spread spread) {
        if (this.importBaseManager.getImportErrorManager().hasSheetError(this.importBaseManager.getCurrentWorkBookIndex(), this.sheetName)) {
            return;
        }
        RangeModel areaRange = areaManager.getAreaRange();
        MultiAreaManager.ValueArea valueAreaStart = areaManager.getValueAreaStart();
        int data_col_start = valueAreaStart.getData_col_start();
        int data_row_start = valueAreaStart.getData_row_start();
        int row_start = valueAreaStart.getRow_start();
        int col_start = valueAreaStart.getCol_start();
        int excelDataColStartIndex = data_col_start + colOffset;
        int excelDataColEndIndex = areaRange.getX_end() + colOffset;
        int excelDataRowStartIndex = data_row_start + yOffset + rowOffset;
        int excelDataRowEndIndex = this.tableData.size();
        List colpartitionDims = areaManager.getColpartitionDims();
        List rowpartitionDims = areaManager.getRowpartitionDims();
        int colDimSize = colpartitionDims.size();
        int rowDimSize = rowpartitionDims.size();
        ArrayList<Map<String, Object>> valueMapList = new ArrayList<Map<String, Object>>(16);
        for (int i = excelDataRowStartIndex; i < excelDataRowEndIndex; ++i) {
            Integer floatMaRow;
            int maDataRow = i - yOffset - rowOffset;
            boolean nextArea = this.isNextArea(areaOverlap, areaManager, i, areaRangePos);
            if (nextArea) break;
            if (excelMaRowMap.size() > 0 && (floatMaRow = excelMaRowMap.get(i)) != null) {
                maDataRow = floatMaRow;
            }
            if (CollectionUtils.isNotEmpty(notUpdateValueRowIndexSet) && notUpdateValueRowIndexSet.contains(i)) continue;
            for (int j = excelDataColStartIndex; j <= excelDataColEndIndex; ++j) {
                int maDataCol = j - colOffset;
                String cellValue = this.getCellValue(i, j);
                if (cellValue == null || StringUtils.isBlank((CharSequence)cellValue.toString())) {
                    if (this.importBaseManager.getImportDataTypeEnum() != ImportDataTypeEnum.empty_cover_import) continue;
                    cellValue = null;
                }
                if (cellValue != null && specialCharacters.contains(cellValue.toString().trim())) continue;
                Map rowpartitionDimMemsByRow = areaManager.getRowpartitionDimMemsByRow(maDataRow - data_row_start);
                if (areaManager.getFloatonWhere() == 1) {
                    rowpartitionDimMemsByRow = areaManager.getRowpartitionDimMemsByRow(maDataRow - row_start);
                }
                Map colpartitionDimMemsByCol = areaManager.getColpartitionDimMemsByCol(maDataCol - data_col_start);
                if (areaManager.getFloatonWhere() == 0) {
                    colpartitionDimMemsByCol = areaManager.getColpartitionDimMemsByCol(maDataCol - col_start);
                }
                if (rowpartitionDimMemsByRow == null || colpartitionDimMemsByCol == null || rowpartitionDimMemsByRow.size() == 0 || colpartitionDimMemsByCol.size() == 0 || colDimSize != colpartitionDimMemsByCol.size() || rowDimSize != rowpartitionDimMemsByRow.size()) continue;
                boolean b = false;
                for (Map.Entry entry : rowpartitionDimMemsByRow.entrySet()) {
                    CellDimMember value = (CellDimMember)entry.getValue();
                    if (value == null) {
                        b = true;
                        break;
                    }
                    if (!StringUtils.isBlank((CharSequence)value.getDimMemberNumber())) continue;
                    b = true;
                    break;
                }
                if (b) continue;
                LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(3);
                valueMap.put("r", maDataRow);
                valueMap.put("c", maDataCol);
                if (cellValue == null) {
                    areaManager.getToDeleteData().add(maDataRow - row_start + this.currentEbSpreadManager.getDeleteSepar() + (maDataCol - col_start));
                }
                valueMap.put("v", cellValue == null ? null : StringUtils.trim((String)cellValue.toString()));
                valueMapList.add(valueMap);
            }
        }
        if (valueMapList.size() > 0) {
            SpreadEvent spreadEvent = this.buildSpreadEvent(spread, valueMapList);
            try {
                spreadJsAction.updateCellValue(spreadEvent);
            }
            catch (Exception e) {
                log.error("BgmReportImportDataTask:valueMapList:");
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e0d\u7b26\u5408\u6d6e\u52a8\u6a21\u677f\u5bfc\u5165\u7684\u89c4\u5219\uff0c\u8bf7\u67e5\u770b\u6ce8\u610f\u4e8b\u9879\u540e\u8fdb\u884c\u4fee\u6539\u3002", (String)"BgmReportImportDataTask_01", (String)"epm-eb-formplugin", (Object[])new Object[]{this.currentTemplateModel.getTemplateBaseInfo().getName()}));
            }
        }
    }

    private void updateFixSpreadManager() {
        LinkedHashMap<Integer, List<ReportImportDataFloatArea>> floatAreaMap;
        HashMap<Integer, String> areaPosMap;
        ExportTemplateHelper exportTemplateHelper;
        ISpreadContainer spreadContainer = this.abstractReportPlugin.getspreadContainer();
        Long datasetID = this.currentTemplateModel.getTemplateBaseInfo().getDatasetID();
        Map dimensionViews = this.currentEbSpreadManager.getDimemsionViews();
        Member pageViewMetricMember = this.getPageViewMetricMember(dimensionViews);
        List multiAreaManager = this.currentEbSpreadManager.getMultiAreaManager();
        boolean isOnlyOne = this.checkLeafFloatAreaRowIsOnlyOne(multiAreaManager, exportTemplateHelper = new ExportTemplateHelper(), areaPosMap = new HashMap<Integer, String>(16), floatAreaMap = new LinkedHashMap<Integer, List<ReportImportDataFloatArea>>(16));
        if (isOnlyOne) {
            return;
        }
        FixSpreadJsAction spreadJsAction = new FixSpreadJsAction((AbstractFormPlugin)this.abstractReportPlugin, this.getSpreadKey());
        Spread spread = new Spread();
        AutoFloatHelper autoFloatHelper = new AutoFloatHelper(this.importBaseManager.getFormView(), this.currentEbSpreadManager, spreadContainer, this.currentTemplateModel, true, false);
        String areaOverlap = FixTemplateProcessHelper.checkRowColOverlapOnAreas(this.currentTemplateModel.getAreaRanges());
        int rowOffset = exportTemplateHelper.getTemplateRowOffset(this.currentTemplateModel);
        int colOffset = 1;
        int importProgress = this.importBaseManager.getImportProgress();
        int index = 0;
        for (MultiAreaManager areaManager : multiAreaManager) {
            Member areaHiddenMetricMember;
            if (this.importBaseManager.getImportErrorManager().hasSheetError(this.importBaseManager.getCurrentWorkBookIndex(), this.sheetName)) break;
            Member metricMember = pageViewMetricMember;
            if (metricMember == null && (areaHiddenMetricMember = this.getAreaHiddenMetricMember(areaManager, dimensionViews)) != null) {
                metricMember = areaHiddenMetricMember;
            }
            String areaRangePos = (String)areaPosMap.get(index);
            IMultiAreaSetting setting = (IMultiAreaSetting)this.currentTemplateModel.getAreaRanges().get(index);
            boolean checkAreaHiddenDimPerm = this.checkAreaHiddenDimPerm(setting, datasetID, dimensionViews, areaRangePos);
            if (!checkAreaHiddenDimPerm) {
                return;
            }
            int defaultAreaRowStartIndex = areaManager.getAreaRange().getY_start() + rowOffset;
            int floatAreaRowStartInSheet = this.getFloatAreaRowStartInSheet(this.currentEbSpreadManager, areaRangePos);
            if (floatAreaRowStartInSheet == -1) {
                floatAreaRowStartInSheet = defaultAreaRowStartIndex;
            } else if (floatAreaRowStartInSheet == -2) {
                String errorInfo = ResManager.loadResFormat((String)"\u6ca1\u6709\u5339\u914d\u5230\u6570\u636e\u533a\u57df\u201c%1\u201d\u3002", (String)"BgmReportImportDataPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{areaRangePos});
                this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
                return;
            }
            int yOffset = floatAreaRowStartInSheet - defaultAreaRowStartIndex;
            HashSet<Integer> notUpdateValueRowIndexSet = new HashSet<Integer>(16);
            this.importBaseManager.getBgmReportImportDataTask().updatePercent(importProgress, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"BgmReportImportDataTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
            Map<Integer, Integer> excelMaRowMap = this.updateFloatAreaMember(areaManager, (List)floatAreaMap.get(index), rowOffset, yOffset, colOffset, areaOverlap, areaRangePos, autoFloatHelper, dimensionViews, notUpdateValueRowIndexSet);
            this.importBaseManager.getBgmReportImportDataTask().updatePercent(importProgress, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"BgmReportImportDataTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
            this.updateFixValue(areaManager, excelMaRowMap, rowOffset, yOffset, colOffset, areaOverlap, areaRangePos, notUpdateValueRowIndexSet, (SpreadJsAction)spreadJsAction, spread);
            this.importBaseManager.getBgmReportImportDataTask().updatePercent(importProgress, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"BgmReportImportDataTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
            if (this.currentEbSpreadManager.isHasFloat()) {
                this.initLockCells();
            }
            this.checkMultiAreaManagerTableData(areaManager, areaRangePos, metricMember);
            this.importBaseManager.getBgmReportImportDataTask().updatePercent(importProgress, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"BgmReportImportDataTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
            ++index;
        }
    }

    private int getFloatAreaRowStartInSheet(IEbSpreadManager ebSpreadManager, String areaPosition) {
        if (!ebSpreadManager.isHasFloat() || ebSpreadManager instanceof EbSpreadManager) {
            return -1;
        }
        for (int i = 0; i < this.tableData.size(); ++i) {
            String[] split;
            String value;
            if (i == 0 || StringUtils.isEmpty((CharSequence)(value = this.getCellValue(i, 0)))) continue;
            for (String newPos : split = value.split(";")) {
                if (!StringUtils.equals((CharSequence)newPos, (CharSequence)areaPosition)) continue;
                return i;
            }
        }
        return -2;
    }

    private void checkMultiAreaManagerTableData(MultiAreaManager areaManager, String areaRangePos, Member metricMember) {
        if (this.importBaseManager.getImportErrorManager().hasSheetError(this.importBaseManager.getCurrentWorkBookIndex(), this.sheetName)) {
            return;
        }
        Map areaPageViewDims = areaManager.getAreaPageViewDims();
        boolean areaPageDimMemIsNoLeaf = false;
        if (areaPageViewDims != null) {
            for (Map.Entry entry : areaPageViewDims.entrySet()) {
                PageViewDimMember value = (PageViewDimMember)entry.getValue();
                if (value == null || value.isIsleaf()) continue;
                areaPageDimMemIsNoLeaf = true;
            }
        }
        ExportTemplateHelper exportTemplateHelper = new ExportTemplateHelper();
        int rowOffset = exportTemplateHelper.getTemplateRowOffset(this.currentTemplateModel);
        int colOffset = 1;
        String areaIndex = areaManager.getAreaIndex();
        MultiAreaManager.ValueArea valueAreaStart = areaManager.getValueAreaStart();
        int data_col_start = valueAreaStart.getData_col_start();
        int data_row_start = valueAreaStart.getData_row_start();
        int row_start = valueAreaStart.getRow_start();
        int col_start = valueAreaStart.getCol_start();
        int defaultAreaRowStartIndex = areaManager.getAreaRange().getY_start() + rowOffset;
        int floatAreaRowStartInSheet = this.getFloatAreaRowStartInSheet(this.currentEbSpreadManager, areaRangePos);
        if (floatAreaRowStartInSheet == -1) {
            floatAreaRowStartInSheet = defaultAreaRowStartIndex;
        } else if (floatAreaRowStartInSheet == -2) {
            String errorInfo = ResManager.loadResFormat((String)"\u6ca1\u6709\u5339\u914d\u5230\u6570\u636e\u533a\u57df\u201c%1\u201d\u3002", (String)"BgmReportImportDataPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{areaRangePos});
            this.importBaseManager.getImportErrorManager().addSheetError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName);
            return;
        }
        int yOffset = floatAreaRowStartInSheet - defaultAreaRowStartIndex;
        POIFixReportProcess poiFixReportProcess = (POIFixReportProcess)this.abstractReportPlugin;
        Long datasetID = this.currentTemplateModel.getTemplateBaseInfo().getDatasetID();
        Map dimemsionViews = this.currentEbSpreadManager.getDimemsionViews();
        HashMap<Integer, String> currentColDimMap = new HashMap<Integer, String>(16);
        HashMap<Integer, List<String>> backFloatF7ScopesMap = new HashMap<Integer, List<String>>(16);
        List table = areaManager.getData().getDataSheet().getTable();
        HashMap<String, Long> rowColDimensionViewMap = new HashMap<String, Long>(16);
        Map relationMap = poiFixReportProcess.getDimRelationMap();
        HashMap<String, Map<String, Member>> tmpDimMemCache = new HashMap<String, Map<String, Member>>(20);
        for (List eCellList : table) {
            if (CollectionUtils.isEmpty((Collection)eCellList)) continue;
            boolean isClearRow = false;
            int excelRow = 0;
            for (ECell eCell : eCellList) {
                if (eCell == null) continue;
                int row = eCell.getRow();
                int col = eCell.getCol();
                int rowIndex = eCell.getRow() + data_row_start;
                int colIndex = eCell.getCol() + col_start;
                this.setSpreadSelector(eCell, rowIndex, colIndex, backFloatF7ScopesMap, currentColDimMap, poiFixReportProcess);
                if (isClearRow) break;
                Object excelValue = eCell.getValue();
                if (this.importBaseManager.getImportDataTypeEnum() != ImportDataTypeEnum.empty_cover_import && (excelValue == null || StringUtils.isBlank((CharSequence)excelValue.toString()))) continue;
                int excelCol = col_start + col + colOffset + 1;
                excelRow = row_start + row + rowOffset + yOffset;
                AtomicBoolean isClearRowFlag = new AtomicBoolean(false);
                if (eCell.isFloatCell()) {
                    AtomicBoolean memberIsNoLeaf = new AtomicBoolean(false);
                    this.checkFloatCell(eCell, isClearRowFlag, memberIsNoLeaf, currentColDimMap, col, excelCol, excelRow, areaIndex, dimemsionViews, tmpDimMemCache, backFloatF7ScopesMap, relationMap, poiFixReportProcess);
                    isClearRow = isClearRowFlag.get();
                    continue;
                }
                int realCol = col + data_col_start;
                int realRow = row + data_row_start;
                if (areaManager.getFloatonWhere() == 0) {
                    realCol = col + col_start;
                }
                if (areaManager.getFloatonWhere() == 1) {
                    realRow = row + row_start;
                }
                this.checkDataCell(datasetID, eCell, isClearRowFlag, metricMember, row, col, realRow, realCol, excelCol, excelRow, excelValue, areaManager, rowColDimensionViewMap, tmpDimMemCache, areaPageDimMemIsNoLeaf);
                isClearRow = isClearRowFlag.get();
            }
            if (!isClearRow) continue;
            if (this.importBaseManager.getImportDataTypeEnum() == ImportDataTypeEnum.empty_cover_import) {
                for (ECell eCell : eCellList) {
                    if (eCell == null) continue;
                    areaManager.getToDeleteData().removeIf(t -> t.equals(eCell.getRow() + this.currentEbSpreadManager.getDeleteSepar() + eCell.getCol()));
                }
            }
            eCellList.add(new ECell());
            Iterator iterator = eCellList.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() == null) continue;
                iterator.remove();
            }
        }
    }

    private void checkFloatCell(ECell eCell, AtomicBoolean clearRowFlag, AtomicBoolean memberIsNoLeaf, Map<Integer, String> currentColDimMap, int col, int excelCol, int excelRow, String areaIndex, Map<String, Long> dimensionViews, Map<String, Map<String, Member>> tmpDimMemCache, Map<Integer, List<String>> backFloatF7ScopesMap, Map<String, Set<String>> relationMap, POIFixReportProcess poiFixReportProcess) {
        Object number = eCell.getUserObject("number");
        if (number == null || StringUtils.isBlank((CharSequence)number.toString())) {
            clearRowFlag.set(true);
            return;
        }
        String currentColDim = currentColDimMap.get(col);
        Long viewId = SysDimensionEnum.Entity.getNumber().equals(currentColDim) ? this.importBaseManager.getCurrentEntityViewId() : DimensionViewServiceHelper.getViewId(dimensionViews, (String)currentColDim, (String)areaIndex);
        Map tmpMemCache = tmpDimMemCache.computeIfAbsent(currentColDim, k -> new HashMap(1000));
        Member member = tmpMemCache.computeIfAbsent(number.toString(), k -> this.importBaseManager.getModelCacheHelper().getMember(currentColDim, viewId, number.toString()));
        if (member == null) {
            clearRowFlag.set(true);
            eCell.setValue(null);
            this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u6d6e\u52a8\u6210\u5458\u5728\u533a\u57df\u89c6\u56fe\u4e2d\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)backFloatF7ScopesMap.get(col))) {
            Set<String> relationMems;
            if (!backFloatF7ScopesMap.get(col).contains(member.getNumber())) {
                clearRowFlag.set(true);
                eCell.setValue(null);
                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u6d6e\u52a8\u6210\u5458\u4e0d\u5728\u6d6e\u52a8\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
                return;
            }
            if (relationMap != null && relationMap.containsKey(currentColDim) && ((relationMems = poiFixReportProcess.getRowDimRelationMemNum(currentColDim)) == null || !relationMems.contains(member.getNumber()))) {
                clearRowFlag.set(true);
                eCell.setValue(null);
                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u6d6e\u52a8\u6210\u5458\u4e0d\u5728\u7ef4\u5ea6\u5173\u7cfb\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_64", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
                return;
            }
        } else {
            clearRowFlag.set(true);
            eCell.setValue(null);
            this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u6d6e\u52a8\u6210\u5458\u4e0d\u5728\u6d6e\u52a8\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
            return;
        }
        Set permMembIds = DimMembPermHelper.getPermMembIds((String)member.getDimension().getNumber(), (Long)this.importBaseManager.getModelCacheHelper().getModelobj().getId(), (Long)this.currentEbSpreadManager.getBusModelid(), (Long)viewId, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
        if (permMembIds != null) {
            if (CollectionUtils.isEmpty((Collection)permMembIds)) {
                clearRowFlag.set(true);
                eCell.setValue(null);
                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u6d6e\u52a8\u6210\u5458\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
            } else if (!permMembIds.contains(member.getId())) {
                clearRowFlag.set(true);
                eCell.setValue(null);
                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u6d6e\u52a8\u6210\u5458\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
            }
        }
        if (!member.isLeaf()) {
            memberIsNoLeaf.set(true);
        }
    }

    private void checkDataCell(long datasetId, ECell eCell, AtomicBoolean isClearRowFlag, Member metricMember, int row, int col, int realRow, int realCol, int excelCol, int excelRow, Object excelValue, MultiAreaManager areaManager, Map<String, Long> rowColDimensionViewMap, Map<String, Map<String, Member>> tmpDimMemCache, boolean areaPageDimMemIsNoLeaf) {
        String areaIndex = areaManager.getAreaIndex();
        Map rowPartitionDimMems = areaManager.getRowpartitionDimMemsByRow(row);
        Map colPartitionDimMems = areaManager.getColpartitionDimMemsByCol(col);
        if (rowPartitionDimMems == null || colPartitionDimMems == null || rowPartitionDimMems.size() == 0 || colPartitionDimMems.size() == 0) {
            return;
        }
        HashMap<String, CellDimMember> rowColMems = new HashMap<String, CellDimMember>(rowPartitionDimMems.size() + colPartitionDimMems.size());
        rowColMems.putAll(rowPartitionDimMems);
        rowColMems.putAll(colPartitionDimMems);
        HashSet<String> noPermissionSet = new HashSet<String>(16);
        HashSet<String> noLeafSet = new HashSet<String>(16);
        Set keySet = rowColMems.keySet();
        for (String dimNum : keySet) {
            if (rowColDimensionViewMap.containsKey(dimNum)) continue;
            Long viewId = DimensionViewServiceHelper.getViewId(rowColDimensionViewMap, (Long)datasetId, (String)dimNum, (String)areaIndex);
            rowColDimensionViewMap.put(dimNum, IDUtils.isEmptyLong((Long)viewId) != false ? Long.valueOf(0L) : viewId);
        }
        Member findedMetricMem = this.checkRowColMember(datasetId, isClearRowFlag, rowColMems, noPermissionSet, noLeafSet, rowColDimensionViewMap, tmpDimMemCache);
        if (findedMetricMem != null) {
            metricMember = findedMetricMem;
        }
        if (CollectionUtils.isNotEmpty(noPermissionSet)) {
            eCell.setValue(null);
            if (this.importBaseManager.getImportDataTypeEnum() == ImportDataTypeEnum.empty_cover_import) {
                areaManager.getToDeleteData().removeIf(t -> t.equals(row + this.currentEbSpreadManager.getDeleteSepar() + col));
            }
            this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u5b58\u5728\u65e0\u7f16\u8f91\u6743\u9650\u7684\u6210\u5458\u201c%2\u201d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow), String.join((CharSequence)";", noPermissionSet)}), this.sheetName, excelRow);
            return;
        }
        if (CollectionUtils.isNotEmpty(noLeafSet) || this.pageAndViewMemIsNoleaf || areaPageDimMemIsNoLeaf) {
            if (this.checkCellIsNoLeafLock(realCol, realRow)) {
                eCell.setValue(null);
                if (this.importBaseManager.getImportDataTypeEnum() == ImportDataTypeEnum.empty_cover_import) {
                    areaManager.getToDeleteData().removeIf(t -> t.equals(row + this.currentEbSpreadManager.getDeleteSepar() + col));
                }
                return;
            }
            if (this.checkCellIsLock(realCol, realRow)) {
                eCell.setValue(null);
                if (this.importBaseManager.getImportDataTypeEnum() == ImportDataTypeEnum.empty_cover_import) {
                    areaManager.getToDeleteData().removeIf(t -> t.equals(row + this.currentEbSpreadManager.getDeleteSepar() + col));
                }
                this.importBaseManager.getImportErrorManager().addCellInfo(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
                return;
            }
        } else if (this.checkCellIsLock(realCol, realRow)) {
            eCell.setValue(null);
            if (this.importBaseManager.getImportDataTypeEnum() == ImportDataTypeEnum.empty_cover_import) {
                areaManager.getToDeleteData().removeIf(t -> t.equals(row + this.currentEbSpreadManager.getDeleteSepar() + col));
            }
            this.importBaseManager.getImportErrorManager().addCellInfo(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
            return;
        }
        Object lockFlag = eCell.getUserObject("l");
        if (this.templateLockCellSet.contains(eCell.getRow() + "@" + eCell.getCol()) || lockFlag instanceof Boolean && ((Boolean)lockFlag).booleanValue()) {
            eCell.setValue(null);
            this.importBaseManager.getImportErrorManager().addCellInfo(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u6a21\u677f\u8bbe\u7f6e\u4e3a\u9501\u5b9a\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)}), this.sheetName, excelRow);
            return;
        }
        if (metricMember != null) {
            Map metricDatatypeMap = this.currentEbSpreadManager.getMetricDatatypeMap();
            Integer metricDataType = (Integer)metricDatatypeMap.get(metricMember.getNumber());
            boolean b = this.checkMetricDataType(this.currentTemplateModel.getTemplateBaseInfo().getDataunit(), this.sheetName, metricDataType + "", metricMember.getNumber(), excelValue, excelCol, excelRow);
            if (!b) {
                eCell.setValue(null);
            }
        }
    }

    private Member checkRowColMember(long datasetId, AtomicBoolean isClearRow, Map<String, CellDimMember> rowColMems, Set<String> noPermissionSet, Set<String> noLeafSet, Map<String, Long> dimensionViewMap, Map<String, Map<String, Member>> tmpDimMemCache) {
        Member metricMember = null;
        for (Map.Entry<String, CellDimMember> entry : rowColMems.entrySet()) {
            String dimNum = entry.getKey();
            CellDimMember value = entry.getValue();
            if (value == null) {
                isClearRow.set(true);
                break;
            }
            String dimMemberNumber = value.getDimMemberNumber();
            if (StringUtils.isBlank((CharSequence)dimMemberNumber) || value.isProperty()) continue;
            Long viewId = SysDimensionEnum.Entity.getNumber().equalsIgnoreCase(dimNum) ? this.importBaseManager.getCurrentEntityViewId() : dimensionViewMap.get(dimNum);
            Map tmpMemCache = tmpDimMemCache.computeIfAbsent(dimNum, k -> new HashMap(1000));
            Member member = tmpMemCache.computeIfAbsent(dimMemberNumber, k -> this.importBaseManager.getModelCacheHelper().getMember(dimNum, viewId, dimMemberNumber));
            if (member == null) continue;
            if (!this.checkDimPermission(datasetId, dimNum, dimMemberNumber, viewId)) {
                noPermissionSet.add(member.getName());
                continue;
            }
            if (!member.isLeaf()) {
                noLeafSet.add(member.getName());
                continue;
            }
            boolean metric = value.isMetric();
            if (!metric) continue;
            metricMember = member;
        }
        return metricMember;
    }

    private void setSpreadSelector(ECell eCell, int rowIndex, int colIndex, Map<Integer, List<String>> backFloatF7ScopesMap, Map<Integer, String> currentColDimMap, POIFixReportProcess poiFixReportProcess) {
        Object scope1 = eCell.getUserObject("scope");
        if (scope1 instanceof DefaultRowColDimensionEntry) {
            DefaultRowColDimensionEntry rowColDimensionEntry1 = (DefaultRowColDimensionEntry)scope1;
            IDimension dimension = rowColDimensionEntry1.getDimension();
            currentColDimMap.put(eCell.getCol(), dimension.getNumber());
            SpreadSelector spreadSelector = new SpreadSelector(rowIndex, colIndex, rowIndex, colIndex);
            poiFixReportProcess.setSpreadSelector(spreadSelector);
            poiFixReportProcess.spreadF7Click(rowIndex, colIndex);
            POISpreadContainer spreadContainer1 = (POISpreadContainer)poiFixReportProcess.getspreadContainer();
            LinkedHashMap operateMaps = spreadContainer1.getOperateMaps();
            if (operateMaps != null && operateMaps.size() > 0) {
                backFloatF7ScopesMap.put(eCell.getCol(), (List)operateMaps.get("backFloatF7Scopes"));
            } else {
                backFloatF7ScopesMap.put(eCell.getCol(), new ArrayList(16));
            }
        } else {
            SpreadSelector spreadSelector = new SpreadSelector(rowIndex, colIndex, rowIndex, colIndex);
            poiFixReportProcess.setSpreadSelector(spreadSelector);
        }
    }

    private void updateDynamicSpreadManager() {
        SpreadJsAction spreadJsAction = new SpreadJsAction((AbstractFormPlugin)this.abstractReportPlugin, this.getSpreadKey());
        Spread spread = new Spread();
        int rowOffset = new ExportTemplateHelper().getTemplateRowOffset(this.currentTemplateModel);
        int colOffset = 1;
        EbSpreadManager ebSpreadManager = (EbSpreadManager)this.currentEbSpreadManager;
        IEBook ebook = ebSpreadManager.getEbook();
        ISheet sheet1 = ebook.getSheet(0);
        List table = sheet1.getTable();
        Map dimemsionViews = this.currentEbSpreadManager.getDimemsionViews();
        List rowpartitionDims = ebSpreadManager.getRowpartitionDims();
        List colpartitionDims = ebSpreadManager.getColpartitionDims();
        IPartitionSetting partitionSetting = this.currentTemplateModel.getPartitionSetting();
        PartitionInfo partitionInfo = partitionSetting.getPartitionInfo();
        String startposition = partitionInfo.getStartposition();
        Long datasetID = this.currentTemplateModel.getTemplateBaseInfo().getDatasetID();
        Member metricMember = null;
        Map pageViewDims = this.currentEbSpreadManager.getPageViewDims();
        for (Map.Entry entry : pageViewDims.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringUtils.equals((CharSequence)key, (CharSequence)SysDimensionEnum.Metric.getNumber())) continue;
            PageViewDimMember value = (PageViewDimMember)entry.getValue();
            String number = value.getNumber();
            Long entityViewId = (Long)dimemsionViews.get(key);
            metricMember = this.importBaseManager.getModelCacheHelper().getMember(key, entityViewId, number);
            break;
        }
        Point point = ExcelUtils.pos2Point((String)startposition);
        int rowDimSize = rowpartitionDims.size();
        int colDimSize = colpartitionDims.size();
        int valueRowStart = point.y + colDimSize;
        int valueColStart = point.x + rowDimSize;
        ArrayList<Map<String, Object>> valueMapList = new ArrayList<Map<String, Object>>(16);
        for (int row = 0; row < table.size(); ++row) {
            List eCellList = (List)table.get(row);
            if (CollectionUtils.isEmpty((Collection)eCellList) || row < valueRowStart) continue;
            int excelRowIndex = row + rowOffset;
            for (int col = 0; col < eCellList.size(); ++col) {
                String errorInfo;
                ECell eCell = (ECell)eCellList.get(col);
                if (col < valueColStart) continue;
                int excelColIndex = col + colOffset;
                String cellValue = this.getCellValue(excelRowIndex, excelColIndex);
                if (cellValue == null || StringUtils.isEmpty((CharSequence)cellValue.toString())) {
                    if (this.importBaseManager.getImportDataTypeEnum() != ImportDataTypeEnum.empty_cover_import) continue;
                    cellValue = null;
                }
                if (this.importBaseManager.getImportDataTypeEnum() != ImportDataTypeEnum.empty_cover_import && cellValue != null && specialCharacters.contains(cellValue.toString().trim())) continue;
                int excelCol = col + colOffset + 1;
                int excelRow = row + rowOffset;
                Map rowpartitionDimMemsByRow = ebSpreadManager.getRowpartitionDimMemsByRow(Integer.valueOf(row));
                Map colpartitionDimMemsByCol = ebSpreadManager.getColpartitionDimMemsByCol(Integer.valueOf(col));
                if (rowpartitionDimMemsByRow == null || colpartitionDimMemsByCol == null || rowpartitionDimMemsByRow.size() == 0 || colpartitionDimMemsByCol.size() == 0) continue;
                colpartitionDimMemsByCol.putAll(rowpartitionDimMemsByRow);
                HashSet<String> noPermissionSet = new HashSet<String>(16);
                HashSet<String> noLeafSet = new HashSet<String>(16);
                for (Map.Entry entry : colpartitionDimMemsByCol.entrySet()) {
                    String dimNum = (String)entry.getKey();
                    CellDimMember value = (CellDimMember)entry.getValue();
                    String dimMemberNumber = value.getDimMemberNumber();
                    if (StringUtils.isBlank((CharSequence)dimMemberNumber) || value.isProperty()) continue;
                    Long viewId = DimensionViewServiceHelper.getViewId((Map)dimemsionViews, (String)dimNum, (String)value.getPartition());
                    Member member = this.importBaseManager.getModelCacheHelper().getMember(dimNum, viewId, dimMemberNumber);
                    if (member == null) continue;
                    if (!this.checkDimPermission(datasetID, dimNum, dimMemberNumber, viewId)) {
                        noPermissionSet.add(member.getName());
                        continue;
                    }
                    if (!member.isLeaf()) {
                        noLeafSet.add(member.getName());
                        continue;
                    }
                    boolean metric = value.isMetric();
                    if (!metric) continue;
                    metricMember = member;
                }
                if (CollectionUtils.isNotEmpty(noLeafSet) || this.pageAndViewMemIsNoleaf) {
                    if (eCell != null) {
                        if (this.checkCellIsNoLeafLock(col, row)) {
                            eCell.setValue(null);
                            continue;
                        }
                        if (this.checkCellIsLock(col, row)) {
                            eCell.setValue(null);
                            errorInfo = ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)});
                            this.importBaseManager.getImportErrorManager().addCellInfo(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName, excelRow);
                            continue;
                        }
                    }
                } else if (this.checkCellIsLock(col, row)) {
                    if (eCell != null) {
                        eCell.setValue(null);
                    }
                    errorInfo = ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow)});
                    this.importBaseManager.getImportErrorManager().addCellInfo(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName, excelRow);
                    continue;
                }
                if (CollectionUtils.isNotEmpty(noPermissionSet)) {
                    if (eCell != null) {
                        eCell.setValue(null);
                    }
                    errorInfo = ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u5b58\u5728\u65e0\u7f16\u8f91\u6743\u9650\u7684\u6210\u5458\u201c%2\u201d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)excelCol, (int)excelRow), String.join((CharSequence)";", noPermissionSet)});
                    this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), errorInfo, this.sheetName, excelRow);
                    continue;
                }
                if (metricMember != null) {
                    Map metricDatatypeMap = this.currentEbSpreadManager.getMetricDatatypeMap();
                    Integer metricDataType = (Integer)metricDatatypeMap.get(metricMember.getNumber());
                    boolean b = this.checkMetricDataType(this.currentTemplateModel.getTemplateBaseInfo().getDataunit(), this.sheetName, metricDataType + "", metricMember.getNumber(), cellValue, excelCol, excelRow);
                    if (!b) {
                        if (eCell == null) continue;
                        eCell.setValue(null);
                        continue;
                    }
                }
                LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(3);
                valueMap.put("r", row);
                valueMap.put("c", col);
                if (cellValue == null) {
                    this.currentEbSpreadManager.getToDeleteData().add(row + this.currentEbSpreadManager.getDeleteSepar() + col);
                }
                valueMap.put("v", cellValue);
                valueMapList.add(valueMap);
            }
        }
        if (valueMapList.size() > 0) {
            SpreadEvent spreadEvent = this.buildSpreadEvent(spread, valueMapList);
            spreadJsAction.updateCellValue(spreadEvent);
        }
    }

    private boolean isNextArea(String areaOverlap, MultiAreaManager areaManager, int rowIndex, String currentAreaPos) {
        String cellValue;
        if (!"row".equals(areaOverlap) && areaManager.getFloatonWhere() != -1 && (cellValue = this.getCellValue(rowIndex, 0)) != null && StringUtils.isNotBlank((CharSequence)cellValue.toString())) {
            String s = cellValue.toString();
            String[] split = s.split(";");
            boolean flag = false;
            for (String s1 : split) {
                String[] split1 = s1.split(":");
                if (currentAreaPos.equals(s1) || split1.length != 2) continue;
                flag = true;
                break;
            }
            return flag;
        }
        return false;
    }

    private boolean checkCellIsLock(int col, int row) {
        if (MapUtils.isNotEmpty(this.lockCellsMap)) {
            for (Map.Entry<ISpreadLockControl, Map<Integer, Set<Integer>>> entry : this.lockCellsMap.entrySet()) {
                Map<Integer, Set<Integer>> lockCells;
                ISpreadLockControl key = entry.getKey();
                if (key instanceof RealFixNoLeafCellLockController || key instanceof RealNoLeafCellLockController || (lockCells = entry.getValue()) == null || lockCells.size() <= 0) continue;
                Set<Integer> cols = lockCells.get(row);
                return cols != null && cols.contains(col);
            }
        }
        return false;
    }

    private boolean checkCellIsNoLeafLock(int col, int row) {
        if (MapUtils.isNotEmpty(this.lockCellsMap)) {
            for (Map.Entry<ISpreadLockControl, Map<Integer, Set<Integer>>> entry : this.lockCellsMap.entrySet()) {
                ISpreadLockControl key = entry.getKey();
                if (!(key instanceof RealFixNoLeafCellLockController) && !(key instanceof RealNoLeafCellLockController)) continue;
                Map<Integer, Set<Integer>> lockCells = entry.getValue();
                if (lockCells == null || lockCells.size() <= 0) break;
                Set<Integer> cols = lockCells.get(row);
                return cols != null && cols.contains(col);
            }
        }
        return false;
    }

    protected boolean checkMetricDataType(String dataUnit, String sheetName, String metricDataType, String metricMember, Object value, int excelCol, int excelRow) {
        if (value == null) {
            return true;
        }
        if (metricDataType != null) {
            if (MetricDataTypeEnum.RATE.getIndex().equals(metricDataType) || MetricDataTypeEnum.CURRENCY.getIndex().equals(metricDataType) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(metricDataType)) {
                return this.checkDataIsDouble(dataUnit, sheetName, value, excelCol, excelRow);
            }
            if (MetricDataTypeEnum.DATE.getIndex().equals(metricDataType)) {
                return this.checkDataIsDate(sheetName, value, excelCol, excelRow);
            }
            if (MetricDataTypeEnum.ENUM.getIndex().equals(metricDataType)) {
                return this.checkEnumValueIsValid(sheetName, metricMember, String.valueOf(value), excelCol, excelRow);
            }
            if (MetricDataTypeEnum.TEXT.getIndex().equals(metricDataType)) {
                return this.checkTextMetric(sheetName, value, excelCol, excelRow);
            }
            return true;
        }
        return false;
    }

    private boolean checkTextMetric(String sheetName, Object value, int x, int y) {
        if (value != null && StringUtils.isNotEmpty((CharSequence)value.toString()) && value.toString().length() > 600) {
            this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u5355\u5143\u683c\u201c%1\u201d\u586b\u5165\u7684\u6587\u672c\u8d85\u8fc7600\u4e2a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u4e0d\u8d85\u8fc7600\u4e2a\u5b57\u7b26\u7684\u6587\u672c\u3002", (String)"BgmReportImportDataPlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)x, (int)y)}), sheetName, y);
            return false;
        }
        return true;
    }

    protected boolean checkDataIsDouble(String dataUnit, String sheetName, Object valueObj, int x, int y) {
        if (valueObj == null || StringUtils.isBlank((CharSequence)valueObj.toString())) {
            return false;
        }
        try {
            BigDecimal tmpValue;
            Pattern compile = Pattern.compile("^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$");
            BigDecimal value = new BigDecimal(valueObj.toString());
            boolean isDouble = compile.matcher(value.toPlainString()).find();
            if (!isDouble && !(isDouble = compile.matcher(value + ".0").find())) {
                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u5355\u5143\u683c\u201c%1\u201d\u53ea\u80fd\u586b\u5165\u6570\u5b57\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u3002", (String)"BgmReportImportDataPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)x, (int)y)}), sheetName, y);
                return false;
            }
            BigDecimal unit = null;
            if (kd.bos.util.StringUtils.isNotEmpty((String)dataUnit) && !"0".equals(dataUnit)) {
                unit = BigDecimal.TEN.pow(Integer.parseInt(dataUnit));
            }
            if ((tmpValue = unit == null ? value : value.multiply(unit)).compareTo(BgConstant.MAX_VALUE) > 0 || tmpValue.compareTo(BgConstant.MIN_VALUE) < 0) {
                this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u586b\u5199\u7684\u6570\u503c\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u5c0f\u4e8e18\u7684\u6570\u503c\u3002", (String)"BgmReportImportDataPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)x, (int)y)}), sheetName, y);
                return false;
            }
        }
        catch (Exception ex) {
            this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u53ea\u80fd\u586b\u5199\u6570\u5b57\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"BgmReportImportDataPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)x, (int)y)}), sheetName, y);
            return false;
        }
        return true;
    }

    protected boolean checkDataIsDate(String sheetName, Object value, int x, int y) {
        String values = String.valueOf(value);
        if (values.startsWith("/OADate")) {
            return true;
        }
        if (DateCheckUtil.isLegalDate((int)value.toString().length(), (String)value.toString(), (String)"yyyy/MM/dd") || DateCheckUtil.isLegalDate((int)value.toString().length(), (String)value.toString(), (String)"yyyy-MM-dd") || DateCheckUtil.isLegalDate((int)value.toString().length(), (String)value.toString(), (String)"YYYY/M/d") || DateCheckUtil.isLegalDate((int)value.toString().length(), (String)value.toString(), (String)"YYYY/M/dd") || DateCheckUtil.isLegalDate((int)value.toString().length(), (String)value.toString(), (String)"YYYY/MM/d") || DateCheckUtil.isLegalDate((int)value.toString().length(), (String)value.toString(), (String)"YYYY-M-d") || DateCheckUtil.isLegalDate((int)value.toString().length(), (String)value.toString(), (String)"YYYY-MM-d") || DateCheckUtil.isLegalDate((int)value.toString().length(), (String)value.toString(), (String)"YYYY-M-dd")) {
            return true;
        }
        this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u201c%1\u201d\u5355\u5143\u683c\u53ea\u80fd\u586b\u5199\u65e5\u671f\u7c7b\u578b\uff0c\u59822019/09/10\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"BgmReportImportDataPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)x, (int)y)}), sheetName, y);
        return false;
    }

    protected boolean checkEnumValueIsValid(String sheetName, String metricMember, String enumValue, int x, int y) {
        Map<String, Set<String>> map = this.getValidEnumValuesMap();
        Set<String> valueSet = map.get(metricMember);
        if (valueSet != null && valueSet.contains(enumValue)) {
            return true;
        }
        this.importBaseManager.getImportErrorManager().addCellError(this.importBaseManager.getCurrentWorkBookIndex(), ResManager.loadResFormat((String)"\u5355\u5143\u683c\u201c%1\u201d\u53ea\u80fd\u8f93\u5165\u679a\u4e3e\u503c\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u3002", (String)"BgmReportImportDataPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{ExcelUtils.xy2Pos((int)x, (int)y)}), sheetName, y);
        return false;
    }

    protected Map<String, Set<String>> getValidEnumValuesMap() {
        if (this.validEnumValuesMap == null) {
            this.validEnumValuesMap = new HashMap<String, Set<String>>(16);
            QFilter q1 = new QFilter("model", "=", (Object)this.importBaseManager.getModelId());
            QFilter q2 = new QFilter("datatype", "=", (Object)MetricDataTypeEnum.ENUM.getIndex());
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"epm_metricmembertree", (String)"number,enumentryentity.enumname", (QFilter[])new QFilter[]{q1, q2});
            if (docs != null) {
                String memNumber = null;
                String enumName = null;
                for (DynamicObject dynamicObject : docs) {
                    memNumber = dynamicObject.getString("number");
                    enumName = dynamicObject.getString("enumentryentity.enumname");
                    Set enumNames = this.validEnumValuesMap.computeIfAbsent(memNumber, k -> new HashSet(16));
                    enumNames.add(enumName);
                }
            }
        }
        return this.validEnumValuesMap;
    }

    private SpreadEvent buildSpreadEvent(Spread spread, List<Map<String, Object>> valueMapList) {
        SpreadPostDataInfo spreadPostDataInfo = new SpreadPostDataInfo();
        LinkedHashMap<String, List<Map<String, Object>>> valueMapLinkedList = new LinkedHashMap<String, List<Map<String, Object>>>();
        valueMapLinkedList.put("values", valueMapList);
        spreadPostDataInfo.setValues(valueMapLinkedList);
        LinkedHashMap<String, String> invokeMap = new LinkedHashMap<String, String>();
        invokeMap.put("ebInvokeAction", "importData");
        spreadPostDataInfo.setInvokeParams(invokeMap);
        return new SpreadEvent((Object)spread, spreadPostDataInfo);
    }

    private void doImport() {
        Member member;
        String entityNumberStrInPageDim = this.pageDimMemberMap.get(SysDimensionEnum.Entity.getNumber());
        Date modifyDate = null;
        if (StringUtils.isNotBlank((CharSequence)entityNumberStrInPageDim) && (member = this.importBaseManager.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), this.importBaseManager.getCurrentEntityViewId(), entityNumberStrInPageDim)) != null && !IDUtils.equals((Object)member.getId(), (Object)this.importBaseManager.getCurrentEntityId())) {
            modifyDate = TimeServiceHelper.now();
            this.updateReportProcessStatus(this.importBaseManager.getModelId(), member.getId(), this.currentTemplateModel.getTemplateBaseInfo().getId(), this.importBaseManager.getCurrentPeriodId(), this.importBaseManager.getCurrentDataTypeId(), this.importBaseManager.getCurrentVersionId(), this.importBaseManager.getCurrentEntityViewId(), BgTaskStateEnum.TEMPSAVE, modifyDate);
        }
        this.updateReportProcessStatus(this.importBaseManager.getModelId(), this.importBaseManager.getCurrentEntityId(), this.currentTemplateModel.getTemplateBaseInfo().getId(), this.importBaseManager.getCurrentPeriodId(), this.importBaseManager.getCurrentDataTypeId(), this.importBaseManager.getCurrentVersionId(), this.importBaseManager.getCurrentEntityViewId(), BgTaskStateEnum.TEMPSAVE, modifyDate);
        if (this.currentTemplateModel instanceof FixTemplateModel) {
            this.updateFixSpreadManager();
        } else {
            this.updateDynamicSpreadManager();
        }
        this.saveReportData(this.abstractReportPlugin);
    }

    private void saveReportData(AbstractReportPlugin abstractReportPlugin) {
        this.importBaseManager.getFormView().getPageCache().put("isFromItemClickSave", "false");
        long l = System.currentTimeMillis();
        abstractReportPlugin.beginSaveReportData();
        log.info("saveReportData \u4fdd\u5b58\u6570\u636e\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - l));
    }

    private void updateReportProcessStatus(Long modelId, Long entityId, Long templateId, Long periodId, Long dataTypeId, Long versionId, Long entityViewId, BgTaskStateEnum bgTaskStateEnum, Date modifyDate) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("entity", "=", (Object)entityId);
        qFilter.and("template", "=", (Object)templateId);
        qFilter.and("period", "=", (Object)periodId);
        qFilter.and("datatype", "=", (Object)dataTypeId);
        qFilter.and("version", "=", (Object)versionId);
        try {
            DynamicObject reportProcess = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"id", (QFilter[])qFilter.toArray());
            if (reportProcess != null) {
                HashSet<Long> templateIdSet = new HashSet<Long>();
                templateIdSet.add(templateId);
                UpdateRptProcessStatusRequest updateRptProcessStatusRequest = new UpdateRptProcessStatusRequest(modelId, entityViewId, templateIdSet, entityId, periodId, dataTypeId, versionId, Long.valueOf(0L), bgTaskStateEnum);
                updateRptProcessStatusRequest.setModifyDate(modifyDate);
                ReportProcessAggService.getInstance().updateReportProcessStatus(updateRptProcessStatusRequest);
            }
        }
        catch (Exception e) {
            log.error("importData updateReportProcessStatus error");
            log.error((Throwable)e);
        }
    }

    private void afterImport() {
        this.importBaseManager.getImportErrorManager().writeTableData2ErrorWorkBook(this.importBaseManager.getCurrentWorkBookIndex(), this.fileName, this.sheetName, this.tableData);
        log.info("finishImportData sheet:{} cost:{}s", (Object)this.sheetName, (Object)this.stopwatch.elapsed(TimeUnit.SECONDS));
    }

    public void execute() {
        boolean passCheck = this.beforeImport();
        if (passCheck) {
            this.doImport();
        }
        this.afterImport();
    }
}

