/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.helper;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.formplugin.report.excel.entity.ImportCell;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ExcelXlsxReader
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(ExcelXlsxReader.class);
    private int maxReadCellCount = 1000000;
    private SharedStrings sst;
    private String lastIndex;
    private List<ImportCell> cellList = new ArrayList<ImportCell>();
    private final List<List<ImportCell>> currentSheetTableData = new ArrayList<List<ImportCell>>(16);
    private int totalCellSize = 0;
    private boolean isEmptyRow = false;
    private int curRow = 0;
    private int preRow = 0;
    private int curCol = 0;
    private boolean isTElement;
    private CellDataType nextDataType = CellDataType.SSTINDEX;
    private final DataFormatter formatter = new DataFormatter();
    private short formatIndex;
    private String formatString;
    private String preRef = null;
    private String ref = null;
    private StylesTable stylesTable;
    private boolean isEmptyCell;
    private int cellListSize = 0;
    public static final Set<Short> specialDateFormatIndex = Sets.newHashSet((Object[])new Short[]{(short)14, (short)31, (short)57});

    public void setMaxReadCellCount(int maxReadCellCount) {
        this.maxReadCellCount = maxReadCellCount;
    }

    public void setTotalCellSize(int totalCellSize) {
        this.totalCellSize = totalCellSize;
    }

    public int getTotalCellSize() {
        return this.totalCellSize;
    }

    public void setSst(SharedStrings sst) {
        this.sst = sst;
    }

    public void setTElement(boolean TElement) {
        this.isTElement = TElement;
    }

    public List<List<ImportCell>> getCurrentSheetTableData() {
        return this.currentSheetTableData;
    }

    public void setCurRow(int curRow) {
        this.curRow = curRow;
    }

    public void setCurCol(int curCol) {
        this.curCol = curCol;
    }

    public void setStylesTable(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        if ("row".equals(name)) {
            String rowIndex = attributes.getValue("r");
            int currentRowIndex = Integer.parseInt(rowIndex);
            if (currentRowIndex - this.preRow > 1) {
                int emptySize = currentRowIndex - this.preRow;
                for (int i = 0; i < emptySize - 1; ++i) {
                    this.currentSheetTableData.add(new ArrayList(16));
                    ++this.curRow;
                }
            }
            this.preRow = currentRowIndex;
        } else if ("c".equals(name)) {
            String cellPos = attributes.getValue("r");
            if (this.preRef == null) {
                this.preRef = cellPos;
            } else if (!this.isEmptyCell) {
                this.preRef = this.ref;
            }
            this.ref = attributes.getValue("r");
            this.setNextDataType(attributes);
        } else {
            this.isTElement = "t".equals(name);
        }
        this.lastIndex = "";
        this.isEmptyCell = true;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.lastIndex = this.lastIndex + new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        String value;
        int i;
        if (this.isTElement) {
            int len;
            this.isEmptyCell = false;
            if (!"A".equals(this.ref.replaceAll("\\d+", "")) && this.curCol == 0) {
                this.preRef = "A";
                this.cellList.add(this.curCol, new ImportCell(this.formatIndex, this.formatString, ""));
                ++this.curCol;
            }
            if (!this.ref.equals(this.preRef) && (len = this.countNullCell(this.ref, this.preRef)) >= 1) {
                for (i = 0; i < len; ++i) {
                    this.cellList.add(this.curCol, new ImportCell(this.formatIndex, this.formatString, ""));
                    ++this.curCol;
                }
            }
            value = this.getDataValue(this.lastIndex.trim());
            this.cellList.add(this.curCol, new ImportCell(this.nextDataType, this.formatIndex, this.formatString, this.lastIndex.trim(), value));
            ++this.curCol;
            this.isTElement = false;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.isEmptyRow = true;
            }
        }
        if ("v".equals(name)) {
            int len;
            this.isEmptyCell = false;
            if (!"A".equals(this.ref.replaceAll("\\d+", "")) && this.curCol == 0) {
                this.preRef = "A";
                this.cellList.add(this.curCol, new ImportCell(this.formatIndex, this.formatString, ""));
                ++this.curCol;
            }
            if (!this.ref.equals(this.preRef) && (len = this.countNullCell(this.ref, this.preRef)) >= 1) {
                for (i = 0; i < len; ++i) {
                    this.cellList.add(this.curCol, new ImportCell(this.formatIndex, this.formatString, ""));
                    ++this.curCol;
                }
            }
            value = this.getDataValue(this.lastIndex.trim());
            this.cellList.add(this.curCol, new ImportCell(this.nextDataType, this.formatIndex, this.formatString, this.lastIndex.trim(), value));
            ++this.curCol;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.isEmptyRow = true;
            }
        }
        if ("row".equals(name)) {
            if (this.isEmptyRow && this.curRow == 0) {
                this.cellListSize = this.cellList.size();
            }
            if (this.curRow != 0) {
                int diffCellNum = this.cellListSize - this.cellList.size();
                for (i = 0; i < diffCellNum; ++i) {
                    this.cellList.add(this.curCol, new ImportCell(this.formatIndex, this.formatString, ""));
                    ++this.curCol;
                }
            }
            if (this.isEmptyRow && this.curRow != 0) {
                this.totalCellSize += this.cellList.size();
                if (this.totalCellSize > this.maxReadCellCount) {
                    this.currentSheetTableData.clear();
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524dSheet\u5355\u5143\u683c\u6570\u91cf\u8d85\u8fc7\u4e86%1\u4e2a\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ImportExcelManager_02", (String)"epm-eb-formplugin", (Object[])new Object[]{this.maxReadCellCount}));
                }
            }
            this.currentSheetTableData.add(this.cellList);
            this.cellList = new ArrayList<ImportCell>(16);
            ++this.curRow;
            this.curCol = 0;
            this.preRef = null;
            this.ref = null;
            this.isEmptyRow = false;
            this.isEmptyCell = false;
        }
    }

    public void setNextDataType(Attributes attributes) {
        this.nextDataType = CellDataType.NUMBER;
        this.formatIndex = (short)-1;
        this.formatString = null;
        String cellType = attributes.getValue("t");
        String cellStyleStr = attributes.getValue("s");
        String columnData = attributes.getValue("r");
        if ("b".equals(cellType)) {
            this.nextDataType = CellDataType.BOOL;
        } else if ("e".equals(cellType)) {
            this.nextDataType = CellDataType.ERROR;
        } else if ("inlineStr".equals(cellType)) {
            this.nextDataType = CellDataType.INLINESTR;
        } else if ("s".equals(cellType)) {
            this.nextDataType = CellDataType.SSTINDEX;
        } else if ("str".equals(cellType)) {
            this.nextDataType = CellDataType.FORMULA;
        }
        if (cellStyleStr != null) {
            int styleIndex = Integer.parseInt(cellStyleStr);
            XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
            this.formatIndex = style.getDataFormat();
            this.formatString = style.getDataFormatString();
            if (this.formatString == null) {
                this.nextDataType = CellDataType.NULL;
                this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
            }
            if (this.formatString != null && this.formatString.contains("m/d/yy")) {
                this.nextDataType = CellDataType.DATE;
                this.formatString = "yyyy-MM-dd";
            }
        }
    }

    public String getDataValue(String value) {
        String thisStr = "";
        switch (this.nextDataType) {
            case BOOL: {
                char first = value.charAt(0);
                thisStr = first == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: {
                thisStr = "\"ERROR:" + value + '\"';
                break;
            }
            case FORMULA: {
                thisStr = value;
                break;
            }
            case INLINESTR: {
                XSSFRichTextString rtsi = new XSSFRichTextString(value);
                thisStr = rtsi.toString();
                break;
            }
            case SSTINDEX: {
                try {
                    int idx = Integer.parseInt(value);
                    XSSFRichTextString rtss = new XSSFRichTextString(this.sst.getItemAt(idx).toString());
                    thisStr = rtss.toString();
                }
                catch (NumberFormatException ex) {
                    thisStr = value;
                }
                break;
            }
            case NUMBER: {
                if (DateUtil.isADateFormat((int)this.formatIndex, (String)this.formatString) || specialDateFormatIndex.contains(this.formatIndex)) {
                    Date javaDate = DateUtil.getJavaDate((double)Double.parseDouble(value));
                    return ConvertUtils.convertToOADate((Date)javaDate);
                }
                thisStr = value;
                try {
                    NumberFormat instance = NumberFormat.getInstance();
                    instance.setMaximumFractionDigits(15);
                    instance.setGroupingUsed(false);
                    String result = instance.format(BigDecimal.valueOf(Double.parseDouble(thisStr)));
                    thisStr = result.contains(",") && !result.contains(".") ? result.replace(",", "") + ".0" : (result.contains(".") ? result.replace(",", "") : result);
                }
                catch (NumberFormatException e) {
                    log.error(this.getClass().getName() + ":" + value);
                    log.error((Throwable)e);
                }
                thisStr = thisStr.replace("_", "").trim();
                break;
            }
            case DATE: {
                thisStr = this.formatter.formatRawCellContents(Double.parseDouble(value), (int)this.formatIndex, this.formatString);
                thisStr = thisStr.replace("T", " ");
                thisStr = thisStr.replace("00:00:00", "");
                break;
            }
            default: {
                thisStr = " ";
            }
        }
        return thisStr.trim();
    }

    public int countNullCell(String ref, String preRef) {
        String xfd = ref.replaceAll("\\d+", "");
        String xfd_1 = preRef.replaceAll("\\d+", "");
        xfd = this.fillChar(xfd, 3, '@', true);
        xfd_1 = this.fillChar(xfd_1, 3, '@', true);
        char[] letter = xfd.toCharArray();
        char[] letter_1 = xfd_1.toCharArray();
        int res = (letter[0] - letter_1[0]) * 26 * 26 + (letter[1] - letter_1[1]) * 26 + (letter[2] - letter_1[2]);
        return res - 1;
    }

    public String fillChar(String str, int len, char let, boolean isPre) {
        int len_1 = str.length();
        if (len_1 < len) {
            if (isPre) {
                StringBuilder strBuilder = new StringBuilder(str);
                for (int i = 0; i < len - len_1; ++i) {
                    strBuilder.insert(0, let);
                }
                str = strBuilder.toString();
            } else {
                StringBuilder strBuilder = new StringBuilder(str);
                for (int i = 0; i < len - len_1; ++i) {
                    strBuilder.append(let);
                }
                str = strBuilder.toString();
            }
        }
        return str;
    }

    public static enum CellDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER,
        DATE,
        NULL;

    }
}

