/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.enums.DataTypeEnum;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.report.excel.POIDynamicReportProcess;
import kd.epm.eb.formplugin.report.excel.POIFixReportProcess;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportHelper;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.control.POISpreadContainer;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.report.excel.helper.POIHelper;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.ReportHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Shape;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportTemplateHelper {
    private static final Log log = LogFactory.getLog(ExportTemplateHelper.class);
    private POISpreadContainer poiSpreadContainer = null;
    private Workbook otherSheetWorkBook = null;
    private Integer beginDataValidCol = 0;
    private int dataValidColIndex = 0;
    private final Map<String, Integer> dataValidSheetIndexMap = new HashMap<String, Integer>(16);
    public static final String dataValidSourceSheetName = ExportTemplateHelper.getDataValidSourceSheetName();
    public static final String floatTemplateImportDescSheetName = ExportTemplateHelper.getFloatTemplateImportDescSheetName();
    public static final String hiddenDataValidDataSourceSheetName = ExportTemplateHelper.getHiddenDataValidDataSourceSheetName();
    public static final String floatTemplateImportDesc = ExportTemplateHelper.getFloatTemplateImportDesc();
    public static final String TEMPLATE_MOVE_ROW_COUNT = "TEMPLATE_MOVE_ROW_COUNT";
    public static final String TEMPLATE_MOVE_COL_COUNT = "TEMPLATE_MOVE_COL_COUNT";
    public static final int templateColOffset = 1;
    public static final int templatePageStartRow = 1;

    public ExportTemplateHelper(POISpreadContainer poiSpreadContainer) {
        this.poiSpreadContainer = poiSpreadContainer;
    }

    public ExportTemplateHelper() {
    }

    public Workbook getOtherSheetWorkBook() {
        if (this.otherSheetWorkBook == null) {
            this.otherSheetWorkBook = new XSSFWorkbook();
        }
        return this.otherSheetWorkBook;
    }

    public void setOtherSheetWorkBook(Workbook otherSheetWorkBook) {
        this.otherSheetWorkBook = otherSheetWorkBook;
    }

    private Sheet getOtherWorkBookSheet(String sheetName) {
        Workbook otherSheetWorkBook1 = this.getOtherSheetWorkBook();
        return otherSheetWorkBook1.getSheet(sheetName);
    }

    private static String getDataValidSourceSheetName() {
        String sheetName = new MultiLangEnumBridge("\u6d6e\u52a8\u6210\u5458\u8303\u56f4", "ExportTemplateHelper_002", "epm-eb-formplugin").loadKDString();
        if (sheetName.length() > 31) {
            sheetName = sheetName.substring(0, 31);
        }
        return sheetName;
    }

    private static String getFloatTemplateImportDescSheetName() {
        String sheetName = new MultiLangEnumBridge("\u6d6e\u52a8\u6a21\u677f\u5bfc\u5165\u6ce8\u610f\u4e8b\u9879", "ExportTemplateHelper_003", "epm-eb-formplugin").loadKDString();
        if (sheetName.length() > 31) {
            sheetName = sheetName.substring(0, 31);
        }
        return sheetName;
    }

    private static String getHiddenDataValidDataSourceSheetName() {
        String sheetName = new MultiLangEnumBridge("\u6570\u636e\u6709\u6548\u6027\u6570\u636e\u6e90", "ExportTemplateHelper_005", "epm-eb-formplugin").loadKDString();
        if (sheetName.length() > 31) {
            sheetName = sheetName.substring(0, 31);
        }
        return sheetName;
    }

    private static String getFloatTemplateImportDesc() {
        return new MultiLangEnumBridge("1\u3001\u63d2\u5165\u884c\u65f6\uff0c\u8bf7\u4e0d\u8981\u5728\u6d6e\u52a8\u533a\u57df\u7684\u7b2c\u4e00\u884c\u4e4b\u4e0a\u53bb\u63d2\u884c\n2\u3001\u63d2\u5165\u884c\u65f6\uff0c\u8bf7\u5728\u6d6e\u52a8\u533a\u57df\u7684\u4e2d\u95f4\u4f4d\u7f6e\u63d2\u884c\n3\u3001\u7c98\u8d34\u7ef4\u5ea6\u6210\u5458\u65f6\uff0c\u8bf7\u5148\u63d2\u5165\u8db3\u591f\u7684\u884c\uff0c\u7136\u540e\u518d\u7c98\u8d34\n4\u3001\u6d6e\u52a8\u533a\u57df\u63d2\u884c\u65f6\uff0c\u6574\u884c\u63d2\u5165\uff0c\u4e0d\u5141\u8bb8\u533a\u57df\u63d2\u884c\n5\u3001\u6d6e\u52a8\u533a\u57df\u884c\u4e0e\u884c\u4e4b\u95f4\u4e0d\u8981\u5b58\u5728\u7a7a\u884c\n6\u3001\u5f53\u9884\u7b97\u6a21\u677f\u5b58\u5728\u5de6\u53f3\u4e24\u4e2a\u4ee5\u4e0a\u6570\u636e\u533a\u57df\u65f6\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\n7\u3001\u4e0d\u5141\u8bb8\u63d2\u5217\u5bfc\u5165", "ExportTemplateHelper_004", "epm-eb-formplugin").loadKDString();
    }

    public int getTemplateRowOffset(ITemplateModel templateModel) {
        int moveCount = 0;
        ++moveCount;
        boolean nopagemumber = ParamQueryServiceHelper.getBoolean((long)templateModel.getTemplateBaseInfo().getModelID(), (ParamEnum)ParamEnum.BG018);
        List pagemembentry = templateModel.getPagemembentry();
        int notNeedExportPageNumberCount = 0;
        for (IPageDimensionEntry entry : pagemembentry) {
            if (!nopagemumber) continue;
            String number = entry.getDimension().getNumber();
            if (!StringUtils.equalsAny((CharSequence)number, (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber()})) continue;
            ++notNeedExportPageNumberCount;
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)pagemembentry)) {
            moveCount += pagemembentry.size();
        }
        return moveCount - notNeedExportPageNumberCount;
    }

    private int setExcelHeadCells(AbstractReportPlugin abstractReportPlugin, Sheet sheetAt, ITemplateModel templateModel, Long entityViewId, Map<String, String> defaultDimMemberMap, IModelCacheHelper modelCacheHelper, int moveCount, boolean isIncludeFilter) {
        if (abstractReportPlugin instanceof POIDynamicReportProcess) {
            moveCount = this.setTemplateInfo(sheetAt, templateModel, isIncludeFilter);
        }
        CellStyle pageDimCellStyle = this.createPageDimCellStyle(sheetAt);
        CellStyle pageDimMemberCellStyle = this.createPageDimMemberCellStyle(sheetAt);
        List pagemembentry = templateModel.getPagemembentry();
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)pagemembentry)) {
            return moveCount;
        }
        boolean nopagemumber = ParamQueryServiceHelper.getBoolean((long)templateModel.getTemplateBaseInfo().getModelID(), (ParamEnum)ParamEnum.BG018);
        Map dimensionView = templateModel.getDimemsionViews();
        dimensionView.put(SysDimensionEnum.Entity.getNumber(), entityViewId);
        int index = 1;
        Map map = ReportExportHelper.getInstance().sortPageDimMap(defaultDimMemberMap, pagemembentry);
        for (Map.Entry entry : map.entrySet()) {
            String dimensionNumber = (String)entry.getKey();
            if (nopagemumber && StringUtils.equalsAny((CharSequence)dimensionNumber, (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber()})) continue;
            String defaultMemberNum = (String)entry.getValue();
            Dimension dimension = modelCacheHelper.getDimension(dimensionNumber);
            String dimName = dimension.getName();
            Member member = modelCacheHelper.getMember(dimensionNumber, (Long)dimensionView.get(dimensionNumber), defaultMemberNum);
            if (member == null) continue;
            Row pageDimRow = this.getOrCreateRow(sheetAt, index++);
            Cell dimNameCell = this.getOrCreateCell(pageDimRow, 1);
            Cell dimMemberNumberCell = this.getOrCreateCell(pageDimRow, 2);
            Cell dimMemberNameCell = this.getOrCreateCell(pageDimRow, 3);
            dimNameCell.setCellValue(dimName);
            dimNameCell.setCellStyle(pageDimCellStyle);
            dimMemberNumberCell.setCellValue(member.getNumber());
            dimMemberNameCell.setCellValue(member.getName());
            dimMemberNumberCell.setCellStyle(pageDimMemberCellStyle);
            dimMemberNameCell.setCellStyle(pageDimMemberCellStyle);
        }
        return moveCount;
    }

    public int setTemplateInfo(Sheet sheetAt, ITemplateModel templateModel, boolean isIncludeFilter) {
        int moveCount = this.getTemplateRowOffset(templateModel);
        this.moveDownRow(sheetAt, 0, sheetAt.getLastRowNum(), moveCount);
        this.moveRightCol(sheetAt, 0, POIHelper.getLastFilledColumn((Sheet)sheetAt), 1);
        Row row = this.getOrCreateRow(sheetAt, 0);
        Workbook workbook = sheetAt.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_BLUE.index);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFont(font);
        try {
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        Cell kingDeeCell = this.getOrCreateCell(row, 0);
        boolean nopagemumber = ParamQueryServiceHelper.getBoolean((long)templateModel.getTemplateBaseInfo().getModelID(), (ParamEnum)ParamEnum.BG018);
        if (nopagemumber) {
            kingDeeCell.setCellValue("Kingdee_1");
        } else {
            kingDeeCell.setCellValue("Kingdee");
        }
        kingDeeCell.setCellStyle(cellStyle);
        CellStyle pageDimMemberCellStyle = this.createPageDimMemberCellStyle(sheetAt);
        Cell templateNumberCell = this.getOrCreateCell(row, 1);
        templateNumberCell.setCellValue(templateModel.getTemplateBaseInfo().getNumber());
        templateNumberCell.setCellStyle(pageDimMemberCellStyle);
        Cell templateNameCell = this.getOrCreateCell(row, 2);
        templateNameCell.setCellValue(templateModel.getTemplateBaseInfo().getName());
        templateNameCell.setCellStyle(pageDimMemberCellStyle);
        Cell dataunitCell = this.getOrCreateCell(row, 3);
        dataunitCell.setCellValue(templateModel.getTemplateBaseInfo().getDataunit());
        dataunitCell.setCellStyle(pageDimMemberCellStyle);
        Cell dataunitNameCell = this.getOrCreateCell(row, 4);
        dataunitNameCell.setCellValue(ReportHelper.getDataUnitName((int)Integer.parseInt(templateModel.getTemplateBaseInfo().getDataunit())));
        dataunitNameCell.setCellStyle(pageDimMemberCellStyle);
        Cell filterFlagCell = this.getOrCreateCell(row, 5);
        filterFlagCell.setCellValue(isIncludeFilter ? "true" : "false");
        filterFlagCell.setCellStyle(pageDimMemberCellStyle);
        return moveCount;
    }

    public void handleExportTemplateWorkbook(Sheet sheetAt, ITemplateModel templateModel, IEbSpreadManager noRefreshDataSpreadManager, AbstractReportPlugin abstractReportPlugin, AbstractReportPlugin noRefreshDataAbstractReportPlugin, IModelCacheHelper modelCacheHelper, ReportExportDataRequest request, int moveCount, boolean isIncludeFilter) {
        Map<String, String[]> enumMetricDataValid = this.setEnumMetricDataValid(abstractReportPlugin, sheetAt, moveCount);
        int rowOffset = this.setExcelHeadCells(abstractReportPlugin, sheetAt, templateModel, request.getEntityViewId(), request.getDefaultDimMemberMap(), modelCacheHelper, moveCount, isIncludeFilter);
        if (templateModel instanceof FixTemplateModel) {
            this.setFloatTemplateAreaFlag(abstractReportPlugin, noRefreshDataSpreadManager, sheetAt, rowOffset);
            this.setFloatAreaDataValidItems(noRefreshDataAbstractReportPlugin == null ? abstractReportPlugin : noRefreshDataAbstractReportPlugin, enumMetricDataValid);
            this.setFloatImportDescSheet();
        }
        sheetAt.groupRow(0, rowOffset - 1);
        sheetAt.setRowGroupCollapsed(0, true);
        sheetAt.groupColumn(0, 0);
        sheetAt.setColumnGroupCollapsed(0, true);
    }

    private Map<String, String[]> setEnumMetricDataValid(AbstractReportPlugin abstractReportPlugin, Sheet sheet, int moveCount) {
        HashMap<String, String[]> metricValueMap = new HashMap<String, String[]>(16);
        AtomicInteger dataSourceColIndex = new AtomicInteger(0);
        HashMap<Integer, Integer> dataSourceColIndexMap = new HashMap<Integer, Integer>(16);
        this.addValidationData(abstractReportPlugin, sheet, true, metricValueMap, dataSourceColIndex, dataSourceColIndexMap, moveCount);
        this.addValidationData(abstractReportPlugin, sheet, false, metricValueMap, dataSourceColIndex, dataSourceColIndexMap, moveCount);
        return metricValueMap;
    }

    private void addValidationData(AbstractReportPlugin abstractReportPlugin, Sheet sheet, boolean isRow, Map<String, String[]> metricValueMap, AtomicInteger dataSourceColIndex, Map<Integer, Integer> dataSourceColIndexMap, int moveCount) {
        boolean isFixReport = true;
        POISpreadContainer spreadContainer = null;
        POIFixReportProcess poiFixReportProcess = null;
        POIDynamicReportProcess poiDynamicReportProcess = null;
        if (abstractReportPlugin instanceof POIFixReportProcess) {
            poiFixReportProcess = (POIFixReportProcess)abstractReportPlugin;
            spreadContainer = (POISpreadContainer)poiFixReportProcess.getspreadContainer();
        } else if (abstractReportPlugin instanceof POIDynamicReportProcess) {
            isFixReport = false;
            poiDynamicReportProcess = (POIDynamicReportProcess)abstractReportPlugin;
            spreadContainer = (POISpreadContainer)poiDynamicReportProcess.getspreadContainer();
        }
        if (spreadContainer == null) {
            return;
        }
        Map enumMap = isRow ? spreadContainer.getEnumRowMap() : spreadContainer.getEnumColMap();
        if (MapUtils.isEmpty((Map)enumMap)) {
            return;
        }
        String templateNumber = abstractReportPlugin.getTemplateModel().getTemplateBaseInfo().getNumber();
        List regionList = CollectionUtils.mergeContinuousRegions((Map)enumMap, (boolean)isRow, (boolean)false);
        log.info("mergeContinuousRegions row:{} regionSize:{}", (Object)isRow, (Object)regionList.size());
        for (int[] region : regionList) {
            List currentCellEnumItems;
            Member currentMetricMember;
            log.info("mergeContinuousRegions row:{} region:{}", (Object)isRow, (Object)Arrays.toString(region));
            int firstRow = region[0];
            int lastRow = region[1];
            int firstCol = region[2];
            int lastCol = region[3];
            LookUpDataArgs lookUpDataArgs = new LookUpDataArgs();
            if (isFixReport) {
                lookUpDataArgs.setC(firstCol - 1);
                lookUpDataArgs.setR(firstRow - moveCount);
            } else {
                lookUpDataArgs.setC(firstCol);
                lookUpDataArgs.setR(firstRow);
            }
            lookUpDataArgs.setValue("");
            if (poiFixReportProcess != null) {
                poiFixReportProcess.spreadF7LookUpData(lookUpDataArgs);
                currentMetricMember = poiFixReportProcess.getCurrentCellMetricMember();
            } else {
                poiDynamicReportProcess.spreadF7LookUpData(lookUpDataArgs);
                currentMetricMember = poiDynamicReportProcess.getCurrentCellMetricMember();
            }
            if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)(currentCellEnumItems = spreadContainer.getCurrentCellEnumItems()))) continue;
            Sheet dataSourceSheet = this.addHiddenDataValidDataSourceSheet(templateNumber);
            ArrayList<String> textList = new ArrayList<String>(16);
            for (Object currentCellEnumItem : currentCellEnumItems) {
                List items = (List)currentCellEnumItem;
                textList.add((String)items.get(2));
            }
            if (!dataSourceColIndexMap.containsKey(textList.hashCode())) {
                dataSourceColIndexMap.put(textList.hashCode(), dataSourceColIndex.getAndIncrement());
            }
            Integer colIndex = dataSourceColIndexMap.get(textList.hashCode());
            this.addDataSourceList(dataSourceSheet, colIndex, textList);
            String[] strings = textList.toArray(new String[0]);
            if (currentMetricMember != null) {
                metricValueMap.put(currentMetricMember.getName(), strings);
            }
            String startCellPos = ExcelUtils.int2pos((int)colIndex);
            String strFormula = dataSourceSheet.getSheetName() + "!$" + startCellPos + "$1:$" + startCellPos + "$" + textList.size();
            XSSFDataValidationConstraint explicitListConstraint = new XSSFDataValidationConstraint(3, strFormula);
            CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
            DataValidation validation = sheet.getDataValidationHelper().createValidation((DataValidationConstraint)explicitListConstraint, cellRangeAddressList);
            sheet.addValidationData(validation);
        }
    }

    private void addDataSourceList(Sheet dataSourceSheet, int colIndex, List<String> items) {
        int rowIndex = 0;
        for (String item : items) {
            Cell cell;
            Row row = dataSourceSheet.getRow(rowIndex);
            if (row == null) {
                row = dataSourceSheet.createRow(rowIndex);
            }
            if ((cell = row.getCell(colIndex)) == null) {
                cell = row.createCell(colIndex);
            }
            cell.setCellValue(item);
            ++rowIndex;
        }
    }

    private void setFloatImportDescSheet() {
        Sheet sheet;
        if (this.getOtherWorkBookSheet(dataValidSourceSheetName) != null && (sheet = this.getOtherWorkBookSheet(floatTemplateImportDescSheetName)) == null) {
            Workbook workbook = this.getOtherSheetWorkBook();
            sheet = workbook.createSheet(floatTemplateImportDescSheetName);
            Row row = sheet.createRow(0);
            Cell cell = row.createCell(0);
            cell.setCellValue(floatTemplateImportDesc);
            sheet.setColumnWidth(0, 1000);
            row.setHeight((short)1500);
            CellRangeAddress cellAddresses = new CellRangeAddress(0, 3, 0, 10);
            sheet.addMergedRegion(cellAddresses);
            CellStyle cellStyle1 = cell.getCellStyle();
            if (cellStyle1 != null) {
                CellStyle cellStyle = workbook.createCellStyle();
                cellStyle.cloneStyleFrom(cellStyle1);
                Font font = workbook.createFont();
                font.setColor(IndexedColors.RED.index);
                cellStyle.setWrapText(true);
                cellStyle.setFont(font);
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                cell.setCellStyle(cellStyle);
            } else {
                CellStyle cellStyle = workbook.createCellStyle();
                Font font = workbook.createFont();
                font.setColor(IndexedColors.RED.index);
                cellStyle.setWrapText(true);
                cellStyle.setFont(font);
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                cell.setCellStyle(cellStyle);
            }
        }
    }

    private void setFloatAreaDataValidItems(AbstractReportPlugin abstractReportPlugin, Map<String, String[]> enumMetricDataValid) {
        Row dimNameRow;
        Row templateNameRow;
        if (!(abstractReportPlugin instanceof POIFixReportProcess)) {
            return;
        }
        Sheet dataValidSourceSheet = this.getOtherWorkBookSheet(dataValidSourceSheetName);
        IEbSpreadManager spreadManager = abstractReportPlugin.getSpreadManager();
        ITemplateModel templateModel = abstractReportPlugin.getTemplateModel();
        POIFixReportProcess poiFixReportProcess = (POIFixReportProcess)abstractReportPlugin;
        boolean hasFloat = spreadManager.isHasFloat();
        if (!hasFloat) {
            return;
        }
        Workbook workbook = this.getOtherSheetWorkBook();
        if (dataValidSourceSheet == null) {
            dataValidSourceSheet = workbook.createSheet(dataValidSourceSheetName);
            templateNameRow = dataValidSourceSheet.createRow(0);
            dimNameRow = dataValidSourceSheet.createRow(1);
        } else {
            templateNameRow = dataValidSourceSheet.getRow(0);
            dimNameRow = dataValidSourceSheet.getRow(1);
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
        List multiAreaManagerList = spreadManager.getMultiAreaManager();
        CellStyle cellStyleCommon = workbook.createCellStyle();
        Font font1 = workbook.createFont();
        font1.setBold(true);
        cellStyleCommon.setFont(font1);
        cellStyleCommon.setAlignment(HorizontalAlignment.CENTER);
        int dimColSize = 0;
        ArrayList<String> enumFloatMemberNumbers = null;
        for (MultiAreaManager multiAreaManager : multiAreaManagerList) {
            MultiAreaManager.ValueArea valueAreaStart = multiAreaManager.getValueAreaStart();
            String areaIndex = multiAreaManager.getAreaIndex();
            int data_row_start = valueAreaStart.getData_row_start();
            int col_start = valueAreaStart.getCol_start();
            Map<String, List<ECell>> floatAreaCellsList = this.getFloatAreaCellsList(multiAreaManager);
            Map<String, List<ECell>> floatAreaScopeMap = this.getFloatAreaScopeMap(floatAreaCellsList);
            for (Map.Entry<String, List<ECell>> floatAreaEntry : floatAreaScopeMap.entrySet()) {
                ECell eCell;
                Object scope;
                List<ECell> cells = floatAreaEntry.getValue();
                Iterator<ECell> iterator = cells.iterator();
                while (iterator.hasNext() && (scope = (eCell = iterator.next()).getUserObject("scope")) instanceof DefaultRowColDimensionEntry) {
                    DefaultRowColDimensionEntry rowColDimensionEntry = (DefaultRowColDimensionEntry)scope;
                    IDimension dimension = rowColDimensionEntry.getDimension();
                    String dimensionNumber = dimension.getNumber();
                    Long viewId = DimensionViewServiceHelper.getViewId((Map)spreadManager.getDimemsionViews(), (String)dimensionNumber, (String)areaIndex);
                    Cell cell = dimNameRow.createCell(this.dataValidColIndex);
                    Dimension floatDimension = modelCacheHelper.getDimension(dimension.getNumber());
                    if (floatDimension == null) continue;
                    String colName = ResManager.loadResFormat((String)"%1\uff08\u540d\u79f0\uff09", (String)"ExportTemplateHelper_006", (String)"epm-eb-formplugin", (Object[])new Object[]{floatDimension.getName()});
                    cell.setCellValue(colName);
                    cell.setCellStyle(cellStyleCommon);
                    String colNameAndNum = ResManager.loadResFormat((String)"%1\uff08\u7f16\u7801@\u540d\u79f0\uff09", (String)"ExportTemplateHelper_007", (String)"epm-eb-formplugin", (Object[])new Object[]{floatDimension.getName()});
                    Cell cellNumber = dimNameRow.createCell(this.dataValidColIndex + 1);
                    cellNumber.setCellValue(colNameAndNum);
                    cellNumber.setCellStyle(cellStyleCommon);
                    dimColSize += 2;
                    Set permMembIds = DimMembPermHelper.getPermMembIds((String)dimensionNumber, (Long)modelCacheHelper.getModelobj().getId(), (Long)spreadManager.getBusModelid(), (Long)viewId, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)permMembIds) && permMembIds != null) {
                        this.dataValidColIndex += 2;
                        continue;
                    }
                    int rowIndex = eCell.getRow() + data_row_start;
                    int colIndex = eCell.getCol() + col_start;
                    SpreadSelector spreadSelector = new SpreadSelector(rowIndex, colIndex, rowIndex, colIndex);
                    poiFixReportProcess.setSpreadSelector(spreadSelector);
                    poiFixReportProcess.spreadF7Click(rowIndex, colIndex);
                    POISpreadContainer spreadContainer = (POISpreadContainer)poiFixReportProcess.getspreadContainer();
                    LinkedHashMap operateMaps = spreadContainer.getOperateMaps();
                    if (operateMaps == null || operateMaps.size() == 0) {
                        this.dataValidColIndex += 2;
                        continue;
                    }
                    List backFloatF7Scopes = (List)operateMaps.get("backFloatF7Scopes");
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)backFloatF7Scopes)) {
                        this.dataValidColIndex += 2;
                        continue;
                    }
                    LinkedHashMap<Long, Member> memberMap = new LinkedHashMap<Long, Member>(16);
                    List floatMembers = modelCacheHelper.getMembers(dimensionNumber, viewId, (Collection)backFloatF7Scopes);
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)floatMembers)) {
                        for (Member floatMember : floatMembers) {
                            memberMap.put(floatMember.getId(), floatMember);
                        }
                    }
                    int i = 2;
                    List sortedMems = memberMap.values().stream().sorted((o1, o2) -> {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return o1.getNumber().compareTo(o2.getNumber());
                    }).collect(Collectors.toList());
                    if (SysDimensionEnum.Metric.getNumber().equals(floatDimension.getNumber())) {
                        enumFloatMemberNumbers = new ArrayList<String>(16);
                    }
                    for (Member member : sortedMems) {
                        String name = member.getName();
                        String nameAndNum = member.getNumber() + "@" + member.getName();
                        Row row = this.getOrCreateRow(dataValidSourceSheet, i++);
                        Cell nameCell = this.getOrCreateCell(row, this.dataValidColIndex);
                        nameCell.setCellValue(name);
                        Cell numberCell = this.getOrCreateCell(row, this.dataValidColIndex + 1);
                        numberCell.setCellValue(nameAndNum);
                        if (enumMetricDataValid != null && enumMetricDataValid.size() != 0 || enumFloatMemberNumbers == null || !DataTypeEnum.ENUMTP.getOIndex().equals(member.getDatatype())) continue;
                        enumFloatMemberNumbers.add(member.getNumber());
                    }
                    dataValidSourceSheet.setColumnWidth(this.dataValidColIndex, 12984);
                    dataValidSourceSheet.setColumnWidth(this.dataValidColIndex + 1, 12984);
                    this.dataValidColIndex += 2;
                }
            }
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(enumFloatMemberNumbers)) {
            if (enumMetricDataValid == null) {
                enumMetricDataValid = new HashMap<String, String[]>(16);
            }
            QFilter qFilter = new QFilter("model", "=", (Object)modelCacheHelper.getModelobj().getId());
            qFilter.and("number", "in", enumFloatMemberNumbers);
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"epm_metricmembertree", (String)"name, enumentryentity.enumname", (QFilter[])new QFilter[]{qFilter});
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
                ArrayList<String> enumValueNames = new ArrayList<String>(16);
                String name = null;
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    name = dynamicObject.getString("name");
                    enumValueNames.add(dynamicObject.getString("enumentryentity.enumname"));
                }
                if (name != null) {
                    enumMetricDataValid.put(name, enumValueNames.toArray(new String[0]));
                }
            }
        }
        if (enumMetricDataValid != null) {
            for (Map.Entry entry : enumMetricDataValid.entrySet()) {
                String metricMemberName = (String)entry.getKey();
                String[] valueList = (String[])entry.getValue();
                if (valueList == null || valueList.length == 0) continue;
                if (dimNameRow != null) {
                    Cell cell = dimNameRow.createCell(this.dataValidColIndex);
                    cell.setCellValue(metricMemberName);
                    cell.setCellStyle(cellStyleCommon);
                    ++dimColSize;
                }
                int index = 2;
                for (String textValue : valueList) {
                    Row row = this.getOrCreateRow(dataValidSourceSheet, index++);
                    Cell excelCell = this.getOrCreateCell(row, this.dataValidColIndex);
                    excelCell.setCellValue(textValue);
                }
                dataValidSourceSheet.setColumnWidth(this.dataValidColIndex, 12984);
                ++this.dataValidColIndex;
            }
        }
        if (templateNameRow != null) {
            Cell cell = templateNameRow.getCell(this.beginDataValidCol.intValue());
            if (cell == null) {
                cell = templateNameRow.createCell(this.beginDataValidCol.intValue());
            }
            cell.setCellValue(templateModel.getTemplateBaseInfo().getName());
            cell.setCellStyle(cellStyleCommon);
        }
        if (this.beginDataValidCol < this.beginDataValidCol + dimColSize - 1) {
            CellRangeAddress cellAddresses = new CellRangeAddress(0, 0, this.beginDataValidCol.intValue(), this.beginDataValidCol + dimColSize - 1);
            dataValidSourceSheet.addMergedRegion(cellAddresses);
        }
        this.beginDataValidCol = this.beginDataValidCol + dimColSize;
    }

    public Map<String, List<ECell>> getFloatAreaScopeMap(Map<String, List<ECell>> floatAreaCellsList) {
        LinkedHashMap<String, List<ECell>> result = new LinkedHashMap<String, List<ECell>>(16);
        for (Map.Entry<String, List<ECell>> entry : floatAreaCellsList.entrySet()) {
            List<ECell> cells = entry.getValue();
            int firstRow = -1;
            int firstCol = -1;
            int lastRow = -1;
            int lastCol = -1;
            for (ECell cell : cells) {
                int row = cell.getRow();
                int col = cell.getCol();
                if (firstRow == -1) {
                    firstRow = row;
                }
                if (firstCol == -1) {
                    firstCol = col;
                }
                if (firstRow > row) {
                    firstRow = row;
                }
                if (firstCol > col) {
                    firstCol = col;
                }
                if (lastCol < col) {
                    lastCol = col;
                }
                if (lastRow >= row) continue;
                lastRow = row;
            }
            String str = firstRow + ":" + firstCol + ":" + lastRow + ":" + lastCol;
            result.put(str, cells);
        }
        return result;
    }

    public Map<Integer, String> getFloatColDimMap(MultiAreaManager multiAreaManager) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(16);
        Map<String, List<ECell>> floatAreaCellsList = this.getFloatAreaCellsList(multiAreaManager);
        for (Map.Entry<String, List<ECell>> entry : floatAreaCellsList.entrySet()) {
            List<ECell> cells = entry.getValue();
            for (ECell cell : cells) {
                if (cell == null) continue;
                Object scope = cell.getUserObject("scope");
                Object dimnumber = cell.getUserObject("dimnumber");
                if (scope instanceof DefaultRowColDimensionEntry) {
                    DefaultRowColDimensionEntry rowColDimensionEntry = (DefaultRowColDimensionEntry)scope;
                    result.put(cell.getCol(), rowColDimensionEntry.getDimension().getNumber());
                    continue;
                }
                if (dimnumber == null) continue;
                result.put(cell.getCol(), dimnumber.toString());
            }
        }
        return result;
    }

    public Map<String, List<ECell>> getFloatAreaCellsList(MultiAreaManager multiAreaManager) {
        ISheet dataSheet = multiAreaManager.getData().getDataSheet();
        List table = dataSheet.getTable();
        LinkedHashMap<String, List<ECell>> result = new LinkedHashMap<String, List<ECell>>(16);
        LinkedHashMap<Integer, List> tableColListMap = new LinkedHashMap<Integer, List>(16);
        int rowIndex = -1;
        for (List cells : table) {
            ++rowIndex;
            if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)cells)) continue;
            int colIndex = -1;
            for (ECell cell : cells) {
                Object isproperty;
                ++colIndex;
                if (cell == null || (isproperty = cell.getUserObject("isproperty")) != null && "1".equals(isproperty.toString())) continue;
                List eCellList = tableColListMap.computeIfAbsent(colIndex, t -> new ArrayList(16));
                cell.setRow(rowIndex);
                cell.setCol(colIndex);
                eCellList.add(cell);
            }
        }
        List<ECell> eCellList = new ArrayList<ECell>(16);
        for (Map.Entry entry : tableColListMap.entrySet()) {
            List value = (List)entry.getValue();
            boolean firstFixMember = false;
            for (ECell cell : value) {
                Object scope = cell.getUserObject("scope");
                if (scope != null) {
                    eCellList = result.computeIfAbsent(cell.getRow() + ":" + cell.getCol(), t -> new ArrayList(16));
                    eCellList.add(cell);
                    continue;
                }
                if (cell.isFloatCell() && org.apache.commons.collections4.CollectionUtils.isNotEmpty(eCellList)) {
                    eCellList.add(cell);
                    continue;
                }
                Object fixMember = cell.getUserObject("fixMember");
                if (fixMember != null && Boolean.parseBoolean(fixMember.toString())) {
                    if (!firstFixMember) {
                        eCellList = result.computeIfAbsent(cell.getRow() + ":" + cell.getCol(), t -> new ArrayList(16));
                        eCellList.add(cell);
                        firstFixMember = true;
                        continue;
                    }
                    eCellList.add(cell);
                    continue;
                }
                firstFixMember = false;
            }
        }
        return result;
    }

    public boolean templateIsNeedSetFloatAreaFlag(IEbSpreadManager spreadManager) {
        List multiAreaManager = spreadManager.getMultiAreaManager();
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)multiAreaManager)) {
            return false;
        }
        return spreadManager.isHasFloat();
    }

    private void setFloatTemplateAreaFlag(AbstractReportPlugin abstractReportPlugin, IEbSpreadManager noRefreshDataSpreadManager, Sheet sheetAt, int rowMoveCount) {
        IEbSpreadManager spreadManager = abstractReportPlugin.getSpreadManager();
        boolean flag = this.templateIsNeedSetFloatAreaFlag(spreadManager);
        if (!flag) {
            return;
        }
        List multiAreaManager = spreadManager.getMultiAreaManager();
        List noRefreshDataSpreadManagerMultiAreaManager = noRefreshDataSpreadManager.getMultiAreaManager();
        Workbook workbook = sheetAt.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setColor(IndexedColors.GREY_50_PERCENT.index);
        cellStyle.setFont(font);
        for (int i = 0; i < noRefreshDataSpreadManagerMultiAreaManager.size(); ++i) {
            MultiAreaManager noRefreshAreaManager = (MultiAreaManager)noRefreshDataSpreadManagerMultiAreaManager.get(i);
            MultiAreaManager refreshDataAreaManager = (MultiAreaManager)multiAreaManager.get(i);
            RangeModel areaRange1 = refreshDataAreaManager.getAreaRange();
            RangeModel areaRange = noRefreshAreaManager.getAreaRange();
            int y_start = areaRange1.getY_start();
            Row row = this.getOrCreateRow(sheetAt, y_start + rowMoveCount);
            Cell cell = this.getOrCreateCell(row, 0);
            String value = cell.getStringCellValue();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                HashSet<String> temp = new HashSet<String>(16);
                temp.add(value);
                temp.add(areaRange.toString());
                cell.setCellValue(String.join((CharSequence)";", temp));
            } else {
                cell.setCellValue(areaRange.toString());
            }
            cell.setCellStyle(cellStyle);
            if (noRefreshAreaManager.getFloatonWhere() == -1) continue;
            Map<String, List<ECell>> floatAreaMapCells = this.getFloatAreaCellsList(refreshDataAreaManager);
            Map<String, List<ECell>> noRefreshDataFloatAreaMapCells = this.getFloatAreaCellsList(noRefreshAreaManager);
            int a = 0;
            for (Map.Entry<String, List<ECell>> entry : floatAreaMapCells.entrySet()) {
                ArrayList<String> temp;
                List<ECell> eCellList = entry.getValue();
                List<ECell> noRefreshDataCellList = null;
                int b = 0;
                for (Map.Entry<String, List<ECell>> stringListEntry : noRefreshDataFloatAreaMapCells.entrySet()) {
                    if (a == b) {
                        noRefreshDataCellList = stringListEntry.getValue();
                        break;
                    }
                    ++b;
                }
                if (org.apache.commons.collections4.CollectionUtils.isEmpty(noRefreshDataCellList)) continue;
                Integer floatAreaFirstPosRow = this.getFloatAreaFirstPosRow(eCellList, refreshDataAreaManager.getValueAreaStart());
                String floatAreaFirstPos = this.getFloatAreaFirstPos(noRefreshDataCellList, noRefreshAreaManager.getValueAreaStart());
                Integer floatAreaLastPosRow = this.getFloatAreaLastPosRow(eCellList, refreshDataAreaManager.getValueAreaStart());
                String floatAreaLastPos = this.getFloatAreaLastPos(noRefreshDataCellList, noRefreshAreaManager.getValueAreaStart());
                ECell eCell = eCellList.get(0);
                Object rangeType = eCell.getUserObject("rangeType", (Object)0);
                if (rangeType != null && StringUtils.equals((CharSequence)rangeType.toString(), (CharSequence)"0") && StringUtils.equals((CharSequence)floatAreaFirstPos, (CharSequence)floatAreaLastPos)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6d6e\u52a8\u6a21\u677f\u201c%1\u201d\u7684\u6bcf\u4e2a\u660e\u7ec6\u6d6e\u52a8\u533a\u57df\u8303\u56f4\u81f3\u5c11\u6709\u4e24\u884c\u624d\u5141\u8bb8\u5bfc\u51fa\uff0c\u8bf7\u4fee\u6539\u6a21\u677f\u540e\u5bfc\u51fa\u3002", (String)"ExportTemplateHelper_001", (String)"epm-eb-formplugin", (Object[])new Object[]{sheetAt.getSheetName()}));
                }
                row = this.getOrCreateRow(sheetAt, floatAreaFirstPosRow + rowMoveCount + refreshDataAreaManager.getValueAreaStart().getRow_start());
                cell = this.getOrCreateCell(row, 0);
                value = cell.getStringCellValue();
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    temp = new ArrayList<String>(16);
                    temp.add(value);
                    temp.add(floatAreaFirstPos);
                    cell.setCellValue(String.join((CharSequence)";", temp));
                } else {
                    cell.setCellValue(floatAreaFirstPos);
                }
                cell.setCellStyle(cellStyle);
                row = this.getOrCreateRow(sheetAt, floatAreaLastPosRow + rowMoveCount + refreshDataAreaManager.getValueAreaStart().getRow_start());
                cell = this.getOrCreateCell(row, 0);
                value = cell.getStringCellValue();
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    temp = new ArrayList(16);
                    temp.add(value);
                    temp.add(floatAreaLastPos);
                    cell.setCellValue(String.join((CharSequence)";", temp));
                } else {
                    cell.setCellValue(floatAreaLastPos);
                }
                cell.setCellStyle(cellStyle);
                ++a;
            }
        }
    }

    public Integer getFloatAreaFirstPosRow(List<ECell> eCellList, MultiAreaManager.ValueArea valueArea) {
        ECell firstFloatRow = eCellList.get(0);
        return firstFloatRow.getRow();
    }

    public Integer getFloatAreaLastPosRow(List<ECell> eCellList, MultiAreaManager.ValueArea valueArea) {
        ECell lastFloatRow = eCellList.get(eCellList.size() - 1);
        return lastFloatRow.getRow();
    }

    public String getFloatAreaFirstPos(List<ECell> eCellList, MultiAreaManager.ValueArea valueArea) {
        ECell firstFloatRow = eCellList.get(0);
        int x = firstFloatRow.getCol() + valueArea.getCol_start();
        int y = firstFloatRow.getRow() + valueArea.getRow_start();
        if (x < 0 || y < 0) {
            log.info("x = " + x + ";y = " + y);
            return "";
        }
        return ExcelUtils.xy2Pos((int)x, (int)y);
    }

    public String getFloatAreaLastPos(List<ECell> eCellList, MultiAreaManager.ValueArea valueArea) {
        ECell lastFloatRow = eCellList.get(eCellList.size() - 1);
        int x = lastFloatRow.getCol() + valueArea.getCol_start();
        int y = lastFloatRow.getRow() + valueArea.getRow_start();
        if (x < 0 || y < 0) {
            log.info("x = " + x + ";y = " + y);
            return "";
        }
        return ExcelUtils.xy2Pos((int)x, (int)y);
    }

    public Map<String, String> getFloatAreaPos(Map<String, List<ECell>> floatAreaCellsList, MultiAreaManager.ValueArea valueArea) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        for (Map.Entry<String, List<ECell>> entry : floatAreaCellsList.entrySet()) {
            List<ECell> eCellList = entry.getValue();
            result.put(this.getFloatAreaFirstPos(eCellList, valueArea), this.getFloatAreaLastPos(eCellList, valueArea));
        }
        return result;
    }

    private CellStyle createPageDimMemberCellStyle(Sheet sheetAt) {
        Workbook workbook = sheetAt.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setColor(IndexedColors.GREY_50_PERCENT.index);
        cellStyle.setFont(font);
        return cellStyle;
    }

    private CellStyle createPageDimCellStyle(Sheet sheetAt) {
        Workbook workbook = sheetAt.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFont(font);
        try {
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return cellStyle;
    }

    private Row getOrCreateRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        row.setHeight((short)300);
        return row;
    }

    private Cell getOrCreateCell(Row row, int col) {
        Cell cell = row.getCell(col);
        if (cell == null) {
            cell = row.createCell(col);
        }
        CellStyle cellStyle = cell.getCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        return cell;
    }

    public void moveRightCol(Sheet sheet, int startCol, int endCol, int moveCount) {
        List dataValidations;
        Drawing pictureDrawing;
        int lastFilledColumn;
        List mergedRegions = sheet.getMergedRegions();
        ArrayList<CellRangeAddress> newMergedRegions = new ArrayList<CellRangeAddress>(16);
        HashSet<Integer> deleteIndex = new HashSet<Integer>(16);
        for (int i = 0; i < mergedRegions.size(); ++i) {
            deleteIndex.add(i);
            CellRangeAddress cellAddresses = (CellRangeAddress)mergedRegions.get(i);
            if (cellAddresses.getFirstColumn() == cellAddresses.getLastColumn() && cellAddresses.getFirstRow() == cellAddresses.getLastRow()) continue;
            cellAddresses.setFirstColumn(cellAddresses.getFirstColumn() + moveCount);
            cellAddresses.setLastColumn(cellAddresses.getLastColumn() + moveCount);
            newMergedRegions.add(cellAddresses);
        }
        sheet.removeMergedRegions(deleteIndex);
        sheet.shiftColumns(startCol, endCol, moveCount);
        for (CellRangeAddress mergedRegion : newMergedRegions) {
            sheet.addMergedRegion(mergedRegion);
        }
        for (int i = lastFilledColumn = POIHelper.getLastFilledColumn((Sheet)sheet); i > 0; --i) {
            if (sheet.isColumnHidden(i - 1)) {
                sheet.setColumnHidden(i - 1, false);
                sheet.setColumnHidden(i - 1 + moveCount, true);
                continue;
            }
            sheet.setColumnWidth(i, sheet.getColumnWidth(i - 1));
        }
        sheet.setColumnWidth(0, 25784);
        PaneInformation paneInformation = sheet.getPaneInformation();
        if (paneInformation != null) {
            short horizontalSplitPosition = paneInformation.getHorizontalSplitPosition();
            short verticalSplitPosition = paneInformation.getVerticalSplitPosition();
            boolean freezePane = paneInformation.isFreezePane();
            if (freezePane) {
                sheet.createFreezePane(verticalSplitPosition + moveCount, (int)horizontalSplitPosition, paneInformation.getVerticalSplitLeftColumn() + moveCount, (int)paneInformation.getHorizontalSplitTopRow());
            }
        }
        if ((pictureDrawing = sheet.getDrawingPatriarch()) != null) {
            for (Shape shape : pictureDrawing) {
                if (!(shape instanceof XSSFPicture)) continue;
                XSSFPicture xssfPicture = (XSSFPicture)shape;
                XSSFClientAnchor clientAnchor = xssfPicture.getClientAnchor();
                clientAnchor.setCol1(clientAnchor.getCol1() + moveCount);
                clientAnchor.setCol2(clientAnchor.getCol2() + moveCount);
            }
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)(dataValidations = sheet.getDataValidations()))) {
            ((XSSFSheet)sheet).getCTWorksheet().unsetDataValidations();
            for (DataValidation dataValidation : dataValidations) {
                CellRangeAddress[] cellRangeAddresses;
                CellRangeAddressList regions = dataValidation.getRegions();
                if (regions != null && (cellRangeAddresses = regions.getCellRangeAddresses()) != null) {
                    for (CellRangeAddress cellRangeAddress : cellRangeAddresses) {
                        cellRangeAddress.setFirstColumn(cellRangeAddress.getFirstColumn() + moveCount);
                        cellRangeAddress.setLastColumn(cellRangeAddress.getLastColumn() + moveCount);
                    }
                }
                DataValidation validation = sheet.getDataValidationHelper().createValidation(dataValidation.getValidationConstraint(), regions);
                sheet.addValidationData(validation);
            }
        }
    }

    public void moveDownRow(Sheet sheet, int startRow, int endRow, int moveCount) {
        List mergedRegions = sheet.getMergedRegions();
        ArrayList<CellRangeAddress> newMergedRegions = new ArrayList<CellRangeAddress>(16);
        HashSet<Integer> deleteIndex = new HashSet<Integer>(16);
        for (int i = 0; i < mergedRegions.size(); ++i) {
            deleteIndex.add(i);
            CellRangeAddress cellAddresses = (CellRangeAddress)mergedRegions.get(i);
            if (cellAddresses.getFirstColumn() == cellAddresses.getLastColumn() && cellAddresses.getFirstRow() == cellAddresses.getLastRow()) continue;
            cellAddresses.setFirstRow(cellAddresses.getFirstRow() + moveCount);
            cellAddresses.setLastRow(cellAddresses.getLastRow() + moveCount);
            newMergedRegions.add(cellAddresses);
        }
        sheet.removeMergedRegions(deleteIndex);
        POIHelper.shiftRows((Integer)startRow, (Integer)endRow, (Integer)moveCount, (Sheet)sheet, (POISpreadContainer)this.poiSpreadContainer, (Boolean)Boolean.FALSE);
        for (CellRangeAddress mergedRegion : newMergedRegions) {
            sheet.addMergedRegion(mergedRegion);
        }
        try {
            PaneInformation paneInformation = sheet.getPaneInformation();
            if (paneInformation != null) {
                short horizontalSplitPosition = paneInformation.getHorizontalSplitPosition();
                short verticalSplitPosition = paneInformation.getVerticalSplitPosition();
                boolean freezePane = paneInformation.isFreezePane();
                if (freezePane) {
                    sheet.createFreezePane((int)verticalSplitPosition, horizontalSplitPosition + moveCount, (int)paneInformation.getVerticalSplitLeftColumn(), paneInformation.getHorizontalSplitTopRow() + moveCount);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("move paneInformation has exception.");
        }
        try {
            Drawing pictureDrawing = sheet.getDrawingPatriarch();
            if (pictureDrawing != null) {
                for (Shape shape : pictureDrawing) {
                    if (!(shape instanceof XSSFPicture)) continue;
                    XSSFPicture xssfPicture = (XSSFPicture)shape;
                    XSSFClientAnchor clientAnchor = xssfPicture.getClientAnchor();
                    clientAnchor.setRow1(clientAnchor.getRow1() + moveCount);
                    clientAnchor.setRow2(clientAnchor.getRow2() + moveCount);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("move pictureDrawing has exception.");
        }
        try {
            List dataValidations = sheet.getDataValidations();
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)dataValidations)) {
                ((XSSFSheet)sheet).getCTWorksheet().unsetDataValidations();
                for (DataValidation dataValidation : dataValidations) {
                    CellRangeAddress[] cellRangeAddresses;
                    CellRangeAddressList regions = dataValidation.getRegions();
                    if (regions != null && (cellRangeAddresses = regions.getCellRangeAddresses()) != null) {
                        for (CellRangeAddress cellRangeAddress : cellRangeAddresses) {
                            cellRangeAddress.setFirstRow(cellRangeAddress.getFirstRow() + moveCount);
                            cellRangeAddress.setLastRow(cellRangeAddress.getLastRow() + moveCount);
                        }
                    }
                    DataValidation validation = sheet.getDataValidationHelper().createValidation(dataValidation.getValidationConstraint(), regions);
                    sheet.addValidationData(validation);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("move dataValidations has exception.");
        }
    }

    private Sheet addHiddenDataValidDataSourceSheet(String sheetNumber) {
        Workbook workbook = this.getOtherSheetWorkBook();
        int index = 0;
        if (this.dataValidSheetIndexMap.get(sheetNumber) == null) {
            index = this.dataValidSheetIndexMap.size();
            this.dataValidSheetIndexMap.put(sheetNumber, this.dataValidSheetIndexMap.size());
        } else {
            index = this.dataValidSheetIndexMap.get(sheetNumber);
        }
        Sheet sheet = this.getOtherWorkBookSheet(hiddenDataValidDataSourceSheetName + "_" + index);
        if (sheet == null) {
            sheet = workbook.createSheet(hiddenDataValidDataSourceSheetName + "_" + index);
            workbook.setSheetHidden(workbook.getSheetIndex(sheet), true);
        }
        return sheet;
    }

    public Map<Integer, String> getFloatAreaRow(List<MultiAreaManager> areaManagers) {
        AtomicInteger floatAreaIndexObj = new AtomicInteger(0);
        HashMap<Integer, String> floatRowRange = new HashMap<Integer, String>(16);
        HashSet floatRowRangeSet = new HashSet(16);
        ExportTemplateHelper exportTemplateHelper = new ExportTemplateHelper();
        for (MultiAreaManager areaManager : areaManagers) {
            String areaRange;
            Map<String, List<ECell>> floatAreaCellsList = exportTemplateHelper.getFloatAreaCellsList(areaManager);
            if (MapUtils.isEmpty(floatAreaCellsList) || StringUtils.isBlank((CharSequence)(areaRange = areaManager.getAreaRange().toString()))) continue;
            MultiAreaManager.ValueArea valueArea = areaManager.getValueAreaStart();
            floatAreaCellsList.forEach((k, v) -> {
                int floatAreaIndex = floatAreaIndexObj.getAndIncrement();
                int dataSize = (int)v.stream().filter(eCell -> Objects.nonNull(eCell.getValue())).count();
                if (dataSize == 0) {
                    return;
                }
                ECell firstFloatRow = (ECell)v.get(0);
                int floatRowStart = firstFloatRow.getRow() + valueArea.getRow_start() + 1;
                ECell lastFloatRow = (ECell)v.get(v.size() - 1);
                int floatRowEnd = lastFloatRow.getRow() + valueArea.getRow_start() + 1;
                String floatRange = floatRowStart + "~" + floatRowEnd;
                if (floatRowRangeSet.add(floatRange)) {
                    floatRowRange.put(floatAreaIndex, floatRange);
                } else {
                    floatAreaIndexObj.decrementAndGet();
                }
            });
        }
        return floatRowRange;
    }
}

