/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.POIExportCallerEnum;
import kd.epm.eb.common.enums.status.ExportFileStatusEnum;
import kd.epm.eb.common.report.excel.ExportExceptionHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.formplugin.report.excel.controller.ReportExportDataController;
import kd.epm.eb.formplugin.report.excel.entity.ExportLogMessage;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportJobCacheHelper;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportTaskRequest;

public class ExportLogService {
    private static final Log log = LogFactory.getLog(ExportLogService.class);
    public static final long fileDeleteTimeout = 43200000L;
    public static final int fileDeleteTimeoutSecond = 43200;
    private static final long lockTryTime = 5000L;
    private static final ExportLogService exportLogService = new ExportLogService();
    public static final Set<String> canCancelStatus = Sets.newHashSet((Object[])new String[]{ExportFileStatusEnum.EXPORT_ING.getIndex(), ExportFileStatusEnum.QUEUE.getIndex()});

    public static ExportLogService getInstance() {
        return exportLogService;
    }

    private ExportLogService() {
    }

    public Set<Long> getCanCancelExportLogIds(Set<Long> exportLogIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_exportfilelist", (String)"id, status", (QFilter[])new QFilter[]{new QFilter("id", "in", exportLogIds)});
        for (DynamicObject dynamicObject : query) {
            String status = dynamicObject.getString("status");
            if (!canCancelStatus.contains(status)) continue;
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    public Map<Long, Integer> cancelExportLogsStatus(Set<Long> exportLogIds) {
        HashMap<Long, Integer> canceledQueueIdCountMap = new HashMap<Long, Integer>(16);
        if (CollectionUtils.isEmpty(exportLogIds)) {
            return canceledQueueIdCountMap;
        }
        QFilter qFilter = new QFilter("id", "in", exportLogIds);
        qFilter.and("status", "in", canCancelStatus);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_exportfilelist", (String)"id, status,queueid", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u6b63\u5728\u5bfc\u51fa\u201d\u6216\u201c\u6392\u961f\u4e2d\u201d\u7684\u5bfc\u51fa\u8bb0\u5f55\u3002", (String)"ExportFileListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String updateSql = "update t_eb_exportfilelist set fstatus = ?, forder = 0, fmodifydate = ?, fmodifier = ?  where fid = ? and fstatus in ('0', '6') ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject dynamicObject : query) {
            Object[] paramArray = new Object[4];
            long id = dynamicObject.getLong("id");
            paramArray[3] = id;
            String status = dynamicObject.getString("status");
            if (ExportFileStatusEnum.QUEUE.getIndex().equalsIgnoreCase(status)) {
                paramArray[0] = ExportFileStatusEnum.EXPORT_CANCEL_END.getIndex();
                Long queueid = dynamicObject.getLong("queueid");
                Integer count = (Integer)canceledQueueIdCountMap.get(queueid);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                canceledQueueIdCountMap.put(queueid, count);
            } else if (ExportFileStatusEnum.EXPORT_ING.getIndex().equalsIgnoreCase(status)) {
                paramArray[0] = ExportFileStatusEnum.EXPORT_CANCEL_ING.getIndex();
            }
            paramArray[1] = now;
            paramArray[2] = userId;
            paramsList.add(paramArray);
        }
        if (CollectionUtils.isNotEmpty(paramsList)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, paramsList);
        }
        return canceledQueueIdCountMap;
    }

    private void cancelExportLogsOrder(Map<Long, Integer> canceledQueueIdCountMap) {
        block21: {
            try (DLock lock = DLock.create((String)("eb/exportLogServiceUpdateQueue/" + ReportExportDataController.currentQueueId));){
                if (lock.tryLock(5000L)) {
                    if (canceledQueueIdCountMap == null || canceledQueueIdCountMap.size() == 0) {
                        return;
                    }
                    ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                    for (Map.Entry<Long, Integer> entry : canceledQueueIdCountMap.entrySet()) {
                        Long queueId = entry.getKey();
                        Integer count = entry.getValue();
                        HashSet<Integer> hasNewOrders = new HashSet<Integer>(16);
                        QFilter qFilter = new QFilter("queueid", "=", (Object)queueId);
                        qFilter.and("status", "!=", (Object)ExportFileStatusEnum.EXPORT_CANCEL_ING.getIndex());
                        DynamicObjectCollection exportLogs = QueryServiceHelper.query((String)"eb_exportfilelist", (String)"order, id, message, model, creater", (QFilter[])new QFilter[]{qFilter}, (String)"order");
                        if (!CollectionUtils.isNotEmpty((Collection)exportLogs)) continue;
                        Date now = TimeServiceHelper.now();
                        long userId = UserUtils.getUserId();
                        for (DynamicObject exportLog : exportLogs) {
                            int newOrder;
                            int order = exportLog.getInt("order");
                            long id = exportLog.getLong("id");
                            Object[] param = new Object[4];
                            int n = newOrder = order - count <= 0 ? 1 : order - count;
                            if (hasNewOrders.contains(newOrder)) {
                                ++newOrder;
                            }
                            hasNewOrders.add(newOrder);
                            param[0] = newOrder;
                            param[1] = now;
                            param[2] = userId;
                            param[3] = id;
                            params.add(param);
                            String message = exportLog.getString("message");
                            long model = exportLog.getLong("model");
                            long creater = exportLog.getLong("creater");
                            this.clearExportLogCache(message, model, id, creater);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(params)) {
                        String updateSql = "update t_eb_exportfilelist set forder = ?, fmodifydate = ?, fmodifier = ?  where fid = ? and fstatus = '6' ";
                        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
                    }
                    break block21;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExportLogService_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void cancelExportLogs(Set<Long> exportLogIds) {
        Map<Long, Integer> canceledQueueIdCountMap = this.cancelExportLogsStatus(exportLogIds);
        this.cancelExportLogsOrder(canceledQueueIdCountMap);
        ExportExceptionHelper.getInstance().cacheCancelExportLogIds(exportLogIds);
    }

    public void clearExportLogCache(String message, Long model, Long id, Long createrId) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)message)) {
            List exportDataRequests = SerializationUtils.fromJsonStringToList((String)message, ReportExportDataRequest.class);
            ReportExportTaskRequest reportExportTaskRequest = new ReportExportTaskRequest(model, id, exportDataRequests);
            ReportExportJobCacheHelper.remove((String)ReportExportJobCacheHelper.getReportExportJobInfoCacheKey((Long)reportExportTaskRequest.getModelId(), (Long)createrId), (ReportExportTaskRequest)reportExportTaskRequest);
        }
    }

    public void updateExportLogOrderInQueue() {
        block15: {
            try (DLock lock = DLock.create((String)("eb/exportLogServiceUpdateQueue/" + ReportExportDataController.currentQueueId));){
                if (lock.tryLock(5000L)) {
                    int index = 1;
                    String sql = "update t_eb_exportfilelist set forder = ?, fmodifydate = ?, fmodifier = ?  where fid = ?";
                    ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                    QFilter qFilter = new QFilter("status", "=", (Object)ExportFileStatusEnum.QUEUE.getIndex());
                    qFilter.and("queueid", "=", (Object)ReportExportDataController.currentQueueId);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_exportfilelist", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"order");
                    Date now = TimeServiceHelper.now();
                    long userId = UserUtils.getUserId();
                    for (DynamicObject dynamicObject : query) {
                        Object[] param = new Object[]{index, now, userId, dynamicObject.getLong("id")};
                        params.add(param);
                        ++index;
                    }
                    if (CollectionUtils.isNotEmpty(params)) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
                    }
                    break block15;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExportLogService_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void updateExportLogOrder(Long exportLogId, int order) {
        if (IDUtils.isNotEmptyLong((Long)exportLogId).booleanValue()) {
            String sql = "update t_eb_exportfilelist set forder = ?, fmodifydate = ?, fmodifier = ? where fid = ?";
            Object[] param = new Object[]{order, TimeServiceHelper.now(), UserUtils.getUserId(), exportLogId};
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])param);
        }
    }

    public void updateBatchExportLog(Set<Long> ids, String errorMessage, String status) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        String updateSql = "update t_eb_exportfilelist set ferrormsg = ?, fstatus = ?, fmodifydate = ?, fmodifier = ? where ";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(updateSql, new Object[]{errorMessage, status, TimeServiceHelper.now(), UserUtils.getUserId()});
        sqlBuilder.appendIn(" fid ", ids.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public void updateExportFileStatus(String exportFileId, String url, String status, String errorMessage) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exportFileId)) {
            boolean exists = QueryServiceHelper.exists((String)"eb_exportfilelist", (Object)exportFileId);
            if (!exists) {
                log.info("exportFileId:", (Object)exportFileId);
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist");
            if (dynamicObject != null) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)url)) {
                    dynamicObject.set("url", (Object)url);
                }
                if (!ExportFileStatusEnum.EXPORT_CANCEL_ING.getIndex().equalsIgnoreCase(dynamicObject.getString("status")) || !ExportFileStatusEnum.EXPORT_END.getIndex().equals(status)) {
                    if (ExportFileStatusEnum.EXPORT_END.getIndex().equals(status)) {
                        dynamicObject.set("progress", (Object)"100%");
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)status)) {
                        dynamicObject.set("status", (Object)status);
                    }
                }
                if (ExportFileStatusEnum.EXPORT_END.getIndex().equals(status) || ExportFileStatusEnum.PART_END.getIndex().equals(status) || ExportFileStatusEnum.EXPORT_FAIL.getIndex().equals(status) || ExportFileStatusEnum.EXPORT_CANCEL_END.getIndex().equals(status)) {
                    dynamicObject.set("finishtime", (Object)TimeServiceHelper.formatUserNow());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                    String errormsg = dynamicObject.getString("errormsg");
                    String message = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)errormsg) ? errorMessage : errorMessage + ";" + errormsg;
                    dynamicObject.set("errormsg", (Object)(message.length() > 2000 ? message.substring(0, 2000) : message));
                }
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        }
    }

    public void updateExportFileProgress(String exportFileId, String progress) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exportFileId)) {
            boolean exists = QueryServiceHelper.exists((String)"eb_exportfilelist", (Object)exportFileId);
            if (!exists) {
                log.info("exportFileId:", (Object)exportFileId);
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist");
            if (dynamicObject != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)progress)) {
                dynamicObject.set("progress", (Object)progress);
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        }
    }

    public ReportExportTaskRequest createReportExportTaskRequest(List<ReportExportDataRequest> exportDataRequests, long timeout, POIExportCallerEnum caller) {
        if (CollectionUtils.isEmpty(exportDataRequests) || IDUtils.isEmptyLong((Long)ReportExportDataController.currentQueueId).booleanValue()) {
            return null;
        }
        Long exportFileInfo = POIExportCallerEnum.REPORT == caller ? this.createExportLog(exportDataRequests, ReportExportDataController.currentQueueId, timeout) : Long.valueOf(GlobalIdUtil.genGlobalLongId());
        return new ReportExportTaskRequest(exportDataRequests.get(0).getModelId(), exportFileInfo, exportDataRequests);
    }

    public ReportExportTaskRequest createReportExportTaskRequest(List<ReportExportDataRequest> exportDataRequests, long timeout) {
        return this.createReportExportTaskRequest(exportDataRequests, timeout, POIExportCallerEnum.REPORT);
    }

    public Long createExportLog(List<ReportExportDataRequest> exportDataRequests, Long currentQueueId, long timeout) {
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)("eb/exportLogServiceUpdateQueue/" + currentQueueId));){
            if (lock.tryLock(5000L)) {
                ReportExportDataRequest reportExportDataRequest;
                QFilter qFilter = new QFilter("status", "=", (Object)ExportFileStatusEnum.QUEUE.getIndex());
                qFilter.and("queueid", "=", (Object)currentQueueId);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_exportfilelist", (String)"order", (QFilter[])qFilter.toArray(), (String)"order desc");
                Integer order = null;
                if (CollectionUtils.isNotEmpty((Collection)query)) {
                    order = ((DynamicObject)query.get(0)).getInt("order") + 1;
                }
                if ("eb_mobreportdetail".equals((reportExportDataRequest = exportDataRequests.get(0)).getFormId())) {
                    Long l = 0L;
                    return l;
                }
                ExportLogMessage exportLogMessage = new ExportLogMessage();
                exportLogMessage.setModelId(reportExportDataRequest.getModelId());
                exportLogMessage.setFilename(reportExportDataRequest.getFileName());
                exportLogMessage.setExportLogTypeEnum(reportExportDataRequest.getExportTypeEnum() == ReportExportTypeEnum.EXPORT_DATA || reportExportDataRequest.getExportTypeEnum() == ReportExportTypeEnum.EXPORT_BY_ORG ? ExportLogMessage.ExportLogTypeEnum.report_export : ExportLogMessage.ExportLogTypeEnum.template_export);
                exportLogMessage.setQueueId(currentQueueId);
                exportLogMessage.setExportDataRequests(exportDataRequests);
                exportLogMessage.setTimeout(timeout);
                if (order != null) {
                    exportLogMessage.setOrder(order);
                }
                Long l = exportLogMessage.create();
                return l;
            }
            try {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExportLogService_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public DynamicObjectCollection queryCurrentUserExportLogList(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(modelId);
        if (!modelManage) {
            qFilter.and(new QFilter("creater", "=", (Object)UserUtils.getUserId()));
        }
        return QueryServiceHelper.query((String)"eb_exportfilelist", (String)"id, url, createdate, modifydate, status, timeout", (QFilter[])new QFilter[]{qFilter});
    }

    public void refreshExportLogList(Long modelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        DynamicObjectCollection query = this.queryCurrentUserExportLogList(modelId);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        Date now = TimeServiceHelper.now();
        ArrayList<Long> notExistsData = new ArrayList<Long>(query.size());
        HashSet<Long> timoutExportIds = new HashSet<Long>(16);
        for (DynamicObject dy : query) {
            String url = dy.getString("url");
            Date createdate = dy.getDate("createdate");
            Date modifydate = dy.getDate("modifydate");
            long id = dy.getLong("id");
            String status = dy.getString("status");
            long timeout = dy.getLong("timeout");
            if (IDUtils.isEmptyLong((Long)timeout).booleanValue()) {
                timeout = 1800000L;
            }
            if (StringUtils.isNotEmpty((String)url) && !tempFileCache.exists(url)) {
                notExistsData.add(dy.getLong("id"));
                continue;
            }
            if (createdate == null) continue;
            long offsetTime = now.getTime() - createdate.getTime();
            if (offsetTime > 43200000L) {
                notExistsData.add(id);
                continue;
            }
            if (!ExportFileStatusEnum.EXPORT_ING.getIndex().equals(status) && !ExportFileStatusEnum.EXPORT_CANCEL_ING.getIndex().equals(status) || (offsetTime = now.getTime() - modifydate.getTime()) <= timeout) continue;
            timoutExportIds.add(id);
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(notExistsData)) {
            DeleteServiceHelper.delete((String)"eb_exportfilelist", (QFilter[])new QFilter[]{new QFilter("id", "in", notExistsData)});
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(timoutExportIds)) {
            log.info("--export refreshExportLogList update failed");
            ExportLogService.getInstance().updateBatchExportLog(timoutExportIds, ResManager.loadKDString((String)"\u670d\u52a1\u5668\u957f\u65f6\u95f4\u65e0\u54cd\u5e94\uff0c\u6b64\u5bfc\u51fa\u4efb\u52a1\u5df2\u7ec8\u6b62\u3002", (String)"ExportLogService_001", (String)"epm-eb-formplugin", (Object[])new Object[0]), ExportFileStatusEnum.EXPORT_FAIL.getIndex());
        }
    }
}

