/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rollingbudget.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.elasticsearch.OlapDataAuditService;
import kd.epm.eb.common.enums.CopyDataEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.RollBudgetServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.formplugin.rollingbudget.EbRollInitV2Plugin;
import kd.epm.eb.formplugin.rollingbudget.RollInitObject;
import kd.epm.eb.formplugin.rollingbudget.dto.RollBudgetRequest;
import kd.epm.eb.formplugin.versioncopy.VersionCopyApiUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.jetbrains.annotations.NotNull;

public class RollBudgetService {
    private static Log log = LogFactory.getLog(RollBudgetService.class);
    private RollBudgetRequest rollBudgetRequest;
    private static final int ACCOUNT_MEMBERNUM = 50;
    private static final String CONFIG_SUCCESS = "1";
    private static final String CONFIG_FAIL = "2";

    public RollBudgetService(RollBudgetRequest rollBudgetRequest) {
        this.rollBudgetRequest = rollBudgetRequest;
    }

    public boolean rollBudget() {
        DynamicObject[] schemeArry;
        QFilter qFilter = new QFilter("model", "=", (Object)this.rollBudgetRequest.getModelId()).and("number", "in", (Object)this.rollBudgetRequest.getSchemeNumbers());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_rollconfig", (String)"id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return true;
        }
        List<Long> schemeIds = dynamicObjects.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        for (DynamicObject schemeDoc : schemeArry = (DynamicObject[])BusinessDataServiceHelper.load((Object[])schemeIds.toArray(new Long[schemeIds.size()]), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"eb_rollconfig").getDataEntityType())) {
            RollInitObject rollInitObject = this.createRollInitObject(schemeDoc);
            this.beginExecute(rollInitObject, this.rollBudgetRequest.getHasData(), schemeDoc);
            this.addDimMemberQuotes(schemeDoc.getString("id"), (Member)rollInitObject.getTarDataType().getMembers().get(0));
        }
        return true;
    }

    private void addDimMemberQuotes(String rollConfigId, Member tarDataType) {
        Dimension dimension;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.rollBudgetRequest.getModelId());
        Long modelId = modelCacheHelper.getModelobj().getId();
        if (StringUtils.isEmpty((String)rollConfigId)) {
            return;
        }
        Long quoteId = Long.valueOf(rollConfigId);
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        if (tarDataType != null) {
            dimension = modelCacheHelper.getDimension(SysDimensionEnum.DataType.getNumber());
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), tarDataType.getId(), MemberQuoteResourceEnum.RollInit, quoteId));
        }
        Set auditTrailSet = null;
        dimension = modelCacheHelper.getDimension(SysDimensionEnum.AuditTrail.getNumber());
        if (CollectionUtils.isEmpty((Collection)this.rollBudgetRequest.getSrcAuditTrailNumbers()) && CollectionUtils.isEmpty((Collection)this.rollBudgetRequest.getTarAuditTrailNumbers())) {
            List members = modelCacheHelper.getMembers(Long.valueOf(0L), SysDimensionEnum.AuditTrail.getNumber());
            if (CollectionUtils.isEmpty((Collection)members)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u5ea6\u7ec4\u5408\u672a\u9009\u62e9\u5b8c\u6574\u3002", (String)"EbRollInitV2Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            auditTrailSet = members.stream().filter(x -> x.getLevel() > 1 && x.isEnable() && !x.isDisable()).map(x -> x.getId()).collect(Collectors.toSet());
        } else {
            List srcMembers = modelCacheHelper.getMembers(SysDimensionEnum.AuditTrail.getNumber(), Long.valueOf(0L), (Collection)this.rollBudgetRequest.getSrcAuditTrailNumbers());
            List tarMembers = modelCacheHelper.getMembers(SysDimensionEnum.AuditTrail.getNumber(), Long.valueOf(0L), (Collection)this.rollBudgetRequest.getTarAuditTrailNumbers());
            if (!CollectionUtils.isEmpty((Collection)srcMembers) && !CollectionUtils.isEmpty((Collection)tarMembers)) {
                auditTrailSet = srcMembers.stream().map(x -> x.getId()).collect(Collectors.toSet());
                auditTrailSet.addAll(tarMembers.stream().map(x -> x.getId()).collect(Collectors.toSet()));
            }
        }
        if (CollectionUtils.isNotEmpty(auditTrailSet)) {
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), auditTrailSet, MemberQuoteResourceEnum.RollInit, quoteId));
        }
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    private RollInitObject createRollInitObject(DynamicObject schemeDoc) {
        QFilter qf1;
        DynamicObject srcDataTypeObj = schemeDoc.getDynamicObject("datatype");
        DynamicObject tarDataTypeObj = RollBudgetServiceHelper.getInstance().getDataType(this.rollBudgetRequest.getModelId(), schemeDoc.getDynamicObject("startdate").getString("number"));
        DynamicObject srcVersionObj = schemeDoc.getDynamicObject("version");
        DynamicObject tarVersionObj = schemeDoc.getDynamicObject("rollversion");
        DynamicObject beginPeriod = schemeDoc.getDynamicObject("startdate");
        DynamicObject actualVersionObj = schemeDoc.getDynamicObject("actversion");
        String basisType = schemeDoc.getString("basistype");
        QFilter qf = new QFilter("model", "=", (Object)this.rollBudgetRequest.getModelId());
        DynamicObject actualDatatypeObj = QueryServiceHelper.queryOne((String)"epm_datatypemembertree", (String)"id,number", (QFilter[])new QFilter[]{qf, qf1 = new QFilter("number", "=", (Object)"Actual")});
        if (actualDatatypeObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201cActual\u201d\u7684\u6570\u636e\u7c7b\u578b\u6210\u5458\u3002", (String)"EbRollInitV2Plugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        kd.epm.eb.common.model.Dimension srcDataType = new kd.epm.eb.common.model.Dimension();
        srcDataType.setNumber(SysDimensionEnum.DataType.getNumber());
        srcDataType.getMembers().add(new Member(Long.valueOf(srcDataTypeObj.getLong("id")), null, srcDataTypeObj.getString("number")));
        kd.epm.eb.common.model.Dimension tarDataType = new kd.epm.eb.common.model.Dimension();
        tarDataType.setNumber(SysDimensionEnum.DataType.getNumber());
        tarDataType.getMembers().add(new Member(Long.valueOf(tarDataTypeObj.getLong("id")), null, tarDataTypeObj.getString("number")));
        kd.epm.eb.common.model.Dimension srcVersion = new kd.epm.eb.common.model.Dimension();
        srcVersion.setNumber(SysDimensionEnum.Version.getNumber());
        srcVersion.getMembers().add(new Member(Long.valueOf(srcVersionObj.getLong("id")), null, srcVersionObj.getString("number")));
        kd.epm.eb.common.model.Dimension tarVersion = new kd.epm.eb.common.model.Dimension();
        tarVersion.setNumber(SysDimensionEnum.Version.getNumber());
        tarVersion.getMembers().add(new Member(Long.valueOf(tarVersionObj.getLong("id")), null, tarVersionObj.getString("number")));
        kd.epm.eb.common.model.Dimension srcAT = new kd.epm.eb.common.model.Dimension();
        srcAT.setNumber(SysDimensionEnum.AuditTrail.getNumber());
        kd.epm.eb.common.model.Dimension tarAT = new kd.epm.eb.common.model.Dimension();
        tarAT.setNumber(SysDimensionEnum.AuditTrail.getNumber());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.rollBudgetRequest.getModelId());
        if (CollectionUtils.isEmpty((Collection)this.rollBudgetRequest.getSrcAuditTrailNumbers()) && CollectionUtils.isEmpty((Collection)this.rollBudgetRequest.getTarAuditTrailNumbers())) {
            List members = modelCacheHelper.getMembers(Long.valueOf(0L), SysDimensionEnum.AuditTrail.getNumber());
            if (CollectionUtils.isEmpty((Collection)members)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u5ea6\u7ec4\u5408\u672a\u9009\u62e9\u5b8c\u6574\u3002", (String)"EbRollInitV2Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Set srcMembers = members.stream().filter(x -> x.getLevel() > 1 && x.isEnable() && !x.isDisable()).map(x -> new Member(x.getId(), null, x.getNumber())).collect(Collectors.toSet());
            srcAT.getMembers().addAll(srcMembers);
            tarAT.getMembers().addAll(srcMembers);
        } else {
            List srcMembers = modelCacheHelper.getMembers(SysDimensionEnum.AuditTrail.getNumber(), Long.valueOf(0L), (Collection)this.rollBudgetRequest.getSrcAuditTrailNumbers());
            List tarMembers = modelCacheHelper.getMembers(SysDimensionEnum.AuditTrail.getNumber(), Long.valueOf(0L), (Collection)this.rollBudgetRequest.getTarAuditTrailNumbers());
            if (!CollectionUtils.isEmpty((Collection)srcMembers) && !CollectionUtils.isEmpty((Collection)tarMembers)) {
                Set srcMembersFinal = srcMembers.stream().filter(x -> x.getLevel() > 1 && x.isEnable() && !x.isDisable()).map(x -> new Member(x.getId(), null, x.getNumber())).collect(Collectors.toSet());
                Set tatMembersFinal = tarMembers.stream().filter(x -> x.getLevel() > 1 && x.isLeaf() && x.isEnable() && !x.isDisable()).map(x -> new Member(x.getId(), null, x.getNumber())).collect(Collectors.toSet());
                srcAT.getMembers().addAll(srcMembersFinal);
                tarAT.getMembers().addAll(tatMembersFinal);
            }
        }
        Map<String, List<Member>> periodMap = this.getPeriodMap(beginPeriod, this.rollBudgetRequest.getInitType());
        List<Member> nextPeriods = periodMap.get("next");
        kd.epm.eb.common.model.Dimension srcPeriod = new kd.epm.eb.common.model.Dimension();
        srcPeriod.setNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        srcPeriod.getMembers().addAll(nextPeriods);
        kd.epm.eb.common.model.Dimension tarPeriod = new kd.epm.eb.common.model.Dimension();
        tarPeriod.setNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        tarPeriod.getMembers().addAll(nextPeriods);
        RollInitObject rollInitObject = new RollInitObject(srcDataType, tarDataType, srcVersion, tarVersion, srcAT, tarAT, srcPeriod, tarPeriod);
        kd.epm.eb.common.model.Dimension acSrcDT = new kd.epm.eb.common.model.Dimension();
        acSrcDT.setNumber(SysDimensionEnum.DataType.getNumber());
        acSrcDT.getMembers().add(new Member(Long.valueOf(actualDatatypeObj.getLong("id")), null, actualDatatypeObj.getString("number")));
        kd.epm.eb.common.model.Dimension acSrcVersion = new kd.epm.eb.common.model.Dimension();
        acSrcVersion.setNumber(SysDimensionEnum.Version.getNumber());
        acSrcVersion.getMembers().add(new Member(Long.valueOf(actualVersionObj.getLong("id")), null, actualVersionObj.getString("number")));
        List<Member> prePeriods = periodMap.get("pre");
        kd.epm.eb.common.model.Dimension srcPrePeriod = new kd.epm.eb.common.model.Dimension();
        srcPrePeriod.setNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        srcPrePeriod.getMembers().addAll(prePeriods);
        kd.epm.eb.common.model.Dimension tarPrePeriod = new kd.epm.eb.common.model.Dimension();
        tarPrePeriod.setNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        tarPrePeriod.getMembers().addAll(prePeriods);
        rollInitObject.setActualSrcDataType(acSrcDT);
        rollInitObject.setActualSrcVersion(acSrcVersion);
        rollInitObject.setActualSrcPeriod(srcPrePeriod);
        rollInitObject.setActualTarPeriod(tarPrePeriod);
        rollInitObject.setRollType(basisType);
        rollInitObject.setIntiType(this.rollBudgetRequest.getInitType());
        return rollInitObject;
    }

    private Map<String, List<Member>> getPeriodMap(@NotNull DynamicObject beginPeriod, String initType) {
        LinkedHashMap<String, List<Member>> map = new LinkedHashMap<String, List<Member>>(16);
        long modelId = this.rollBudgetRequest.getModelId();
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)beginPeriod.getPkValue(), (String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (String)"id, number, longnumber, level");
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u5f00\u59cb\u6eda\u52a8\u7684\u8d77\u59cb\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"EbRollInitV2Plugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String[] currPeriodNum = period.getString("number").split("\\.");
        if (currPeriodNum == null || currPeriodNum.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u5f00\u59cb\u6eda\u52a8\u7684\u8d77\u59cb\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"EbRollInitV2Plugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("level", "=", (Object)beginPeriod.getInt("level")));
        builder.add(new QFilter("number", "like", (Object)(currPeriodNum[0] + '%')));
        builder.add(new QFilter("longnumber", "<", (Object)period.getString("longnumber")));
        ArrayList<Member> prePeriods = new ArrayList<Member>(60);
        DynamicObjectCollection pre = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id,number", (QFilter[])builder.toArrays(), (String)"longnumber desc", (int)60);
        if (pre != null) {
            for (DynamicObject dynamicObject : pre) {
                Member member = new Member(Long.valueOf(dynamicObject.getLong("id")), null, dynamicObject.getString("number"));
                prePeriods.add(member);
            }
        }
        map.put("pre", prePeriods);
        builder.clear();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("level", "=", (Object)beginPeriod.getInt("level")));
        builder.add(new QFilter("longnumber", ">=", (Object)period.getString("longnumber")));
        DynamicObjectCollection next = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id,number", (QFilter[])builder.toArrays(), (String)"longnumber", (int)(60 - prePeriods.size()));
        if (next == null || next.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u5b58\u5728", (String)"EbRollInitV2Plugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Member> nextPeriods = new ArrayList<Member>(16);
        for (DynamicObject dynamicObject : next) {
            Member member = new Member(Long.valueOf(dynamicObject.getLong("id")), null, dynamicObject.getString("number"));
            nextPeriods.add(member);
        }
        if (CONFIG_FAIL.equals(initType)) {
            map.put("next", new ArrayList(16));
        } else {
            map.put("next", nextPeriods);
        }
        return map;
    }

    private void beginExecute(RollInitObject rollInitObject, boolean hasData, DynamicObject schemeDoc) {
        String loginIP = RequestContext.getOrCreate().getLoginIP();
        EBThreadPoolExecutor es = new EBThreadPoolExecutor(2, Runtime.getRuntime().availableProcessors() + 1, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue());
        es.execute(() -> {
            try {
                RequestContext.getOrCreate().setLoginIP(loginIP);
                OlapTraceServiceHelper.setTraceOpInfo((String)schemeDoc.getString("number"));
                OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.RollBudget));
                this.execute(rollInitObject, hasData, schemeDoc);
            }
            catch (Exception e) {
                this.saveExecuteLog(rollInitObject, ThrowableHelper.getMessage((Exception)e), CopyDataEnum.FAILED.getIndex(), schemeDoc.getString("id"));
                this.updateInitStatus(CONFIG_FAIL, schemeDoc.getString("id"));
                log.error("--execute-fail--" + e.getMessage(), (Throwable)e);
            }
        });
        es.shutdown();
    }

    private void execute(@NotNull RollInitObject rollInitObject, boolean hasData, DynamicObject schemeDoc) {
        kd.epm.eb.common.model.Dimension actualTarPeriod;
        List members2;
        Long[] datasetIds;
        long modelId = this.rollBudgetRequest.getModelId();
        String rollBudgetId = schemeDoc.getString("id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Map<Long, List<String>> datasetAndTempMap = null;
        if (CONFIG_SUCCESS.equals(rollInitObject.getRollType())) {
            datasetIds = DatasetServiceHelper.queryDatasetIds((Long)modelId);
        } else {
            datasetAndTempMap = this.getDatasetAndTempMap(schemeDoc);
            datasetIds = datasetAndTempMap.keySet().toArray(new Long[datasetAndTempMap.size()]);
        }
        datasetIds = this.filterDatasetIds(modelId, datasetIds);
        if (datasetIds == null || datasetIds.length == 0) {
            return;
        }
        rollInitObject.setLogRecordId(Long.valueOf(0L));
        Long recordId = this.saveExecuteLog(rollInitObject, "0%", CopyDataEnum.EXECUTING.getIndex(), rollBudgetId);
        if (recordId == -1L) {
            return;
        }
        Map<Long, Long> dateSetIdWithBusinessModelId = this.getDateSetIdWithBusinessModelId(datasetIds, modelId);
        kd.epm.eb.common.model.Dimension tarPeriod = rollInitObject.getTarPeriod();
        HashSet preid = new HashSet(16);
        List members1 = tarPeriod.getMembers();
        if (CollectionUtils.isNotEmpty((Collection)members1)) {
            preid.addAll(members1.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(members2 = (actualTarPeriod = rollInitObject.getActualTarPeriod()).getMembers()))) {
            preid.addAll(members2.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
        }
        if (dateSetIdWithBusinessModelId != null && !dateSetIdWithBusinessModelId.isEmpty()) {
            for (Map.Entry<Long, Long> longLongEntry : dateSetIdWithBusinessModelId.entrySet()) {
                Long datasetId = longLongEntry.getKey();
                Map<String, List<String>> dimAndMem = this.getDimAndMem(modelCache, datasetId, modelCache.getViewGroupViewsByDataSet(datasetId), rollInitObject, false, false);
                IBgmdDataLockCache checker = BgmdDataLockService.getInstance().getDataLockCache(Long.valueOf(modelId), longLongEntry.getValue());
                HashMap<String, Set<Object>> checkMap = new HashMap<String, Set<Object>>(5);
                for (String s : VersionCopyApiUtils.CHECK_LOCK_DIM) {
                    List<String> members = dimAndMem.get(s);
                    if (CollectionUtils.isNotEmpty(members)) {
                        checkMap.put(s, Sets.newHashSet(members));
                        continue;
                    }
                    if (SysDimensionEnum.AuditTrail.getNumber().equals(s)) {
                        List member = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), Long.valueOf(0L), SysDimensionEnum.AuditTrail.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
                        if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)member)) continue;
                        checkMap.put(s, member.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                        continue;
                    }
                    if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(s)) continue;
                    checkMap.put(s, preid);
                }
                if (checker == null || !checker.isDataLockScope(checkMap)) continue;
                log.error("---memberislock--");
                String msg = ResManager.loadKDString((String)"\u65b9\u6848\u8303\u56f4\u5185\u6570\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6eda\u52a8\u521d\u59cb\u5316\u3002", (String)"RollBudgetService_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.saveExecuteLog(rollInitObject, msg, CopyDataEnum.FAILED.getIndex(), rollBudgetId);
                this.updateInitStatus(CONFIG_FAIL, rollBudgetId);
                return;
            }
        }
        if (hasData) {
            try {
                boolean isCancel;
                boolean bl = isCancel = !this.cleanOlapData(rollInitObject, modelCache, datasetIds, datasetAndTempMap, rollInitObject.getRollType());
                if (isCancel) {
                    return;
                }
            }
            catch (Exception e) {
                log.error("---cleanOlapDatafail--" + e.getMessage(), (Throwable)e);
                String msg = ResManager.loadResFormat((String)"\u6570\u636e\u6e05\u9664\u5931\u8d25%1", (String)"EbRollInitV2Plugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{ThrowableHelper.getMessage((Exception)e)});
                this.saveExecuteLog(rollInitObject, msg, CopyDataEnum.FAILED.getIndex(), rollBudgetId);
                this.updateInitStatus(CONFIG_FAIL, rollBudgetId);
                return;
            }
        }
        double plan = 0.0;
        double datasetRate = 100.0 / (double)datasetIds.length;
        double dataRate = datasetRate / 2.0;
        HashMap<String, List<Long>> viewIds = new HashMap(16);
        int in = datasetIds.length;
        for (int datasetIndex = 0; datasetIndex < in; ++datasetIndex) {
            ArrayList memberMaps;
            Map<Object, Object> memberMapActual;
            Object memberMap;
            Long datasetId = datasetIds[datasetIndex];
            Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
            log.info("begin-cal-dataset. id=" + dataset.getId() + ", number = " + dataset.getNumber());
            viewIds = modelCache.getViewGroupViewsByDataSet(datasetId);
            LogStats stats = new LogStats("budget-roll-log:");
            stats.addInfo("begin-roll-dataset; number=" + dataset.getNumber());
            if (CONFIG_SUCCESS.equals(rollInitObject.getRollType())) {
                memberMap = this.getDimAndMem(modelCache, datasetId, viewIds, rollInitObject, true, false);
                memberMapActual = this.getDimAndMem(modelCache, datasetId, viewIds, rollInitObject, true, true);
                memberMaps = Lists.newArrayList((Object[])new Map[]{memberMapActual, memberMap});
            } else {
                if (datasetAndTempMap == null || !datasetAndTempMap.containsKey(datasetId)) {
                    stats.addInfo("roll-data-skip(datasetAndTempMap is null.) dataset=" + dataset.getNumber());
                    plan = (double)(datasetIndex + 1) * datasetRate;
                    this.updateProgress(rollInitObject.getProgressKey(Long.valueOf(modelId)), String.valueOf(plan));
                    continue;
                }
                memberMap = new LinkedHashMap<String, List<String>>(16);
                memberMapActual = new LinkedHashMap(16);
                memberMaps = Lists.newArrayList((Object[])new Map[]{memberMapActual, memberMap});
            }
            for (Map memberMap2 : memberMaps) {
                List accounts;
                if (memberMap2.size() == 0) {
                    stats.addInfo("roll-data-skip(map-is-null.) dataset=" + dataset.getNumber());
                    this.updateProgress(rollInitObject.getProgressKey(Long.valueOf(modelId)), String.valueOf(plan += dataRate));
                    continue;
                }
                if (((List)memberMap2.get(SysDimensionEnum.BudgetPeriod.getNumber())).size() == 0) {
                    stats.addInfo("roll-data-skip(period-member-is-null.) dataset=" + dataset.getNumber());
                    this.updateProgress(rollInitObject.getProgressKey(Long.valueOf(modelId)), String.valueOf(plan += dataRate));
                    continue;
                }
                if (((List)memberMap2.get(SysDimensionEnum.Version.getNumber())).size() == 0) {
                    stats.addInfo("roll-data-skip(version-member-is-null.) dataset=" + dataset.getNumber());
                    this.updateProgress(rollInitObject.getProgressKey(Long.valueOf(modelId)), String.valueOf(plan += dataRate));
                    continue;
                }
                if (CONFIG_SUCCESS.equals(rollInitObject.getRollType())) {
                    memberMap2.put(SysDimensionEnum.Account.getNumber(), DimensionServiceHelper.getAccountByDataset((Long)modelId, (Long)datasetId));
                }
                if ((accounts = (List)memberMap2.get(SysDimensionEnum.Account.getNumber())).size() == 0) {
                    stats.addInfo("roll-data-skip(account-member-is-null.) dataset=" + dataset.getNumber());
                    this.updateProgress(rollInitObject.getProgressKey(Long.valueOf(modelId)), String.valueOf(plan += dataRate));
                    continue;
                }
                List orgUnits = (List)memberMap2.get(SysDimensionEnum.Entity.getNumber());
                double orgRate = dataRate / (double)orgUnits.size();
                List accountPages = this.splitList(accounts, 50);
                double accountRate = orgRate / (double)accountPages.size();
                double tempProcess = 0.0;
                for (String entityNumber : orgUnits) {
                    for (List<String> list : accountPages) {
                        this.rollComputingData(rollInitObject, modelCache.getModelobj(), dataset, entityNumber, list, memberMap2);
                        if (tempProcess == 0.0) {
                            tempProcess = plan;
                        }
                        if (!((plan += accountRate) - tempProcess > 1.0)) continue;
                        tempProcess = plan;
                        this.updateProgress(rollInitObject.getProgressKey(Long.valueOf(modelId)), String.valueOf(plan));
                        Long cancelFlag = this.saveExecuteLog(rollInitObject, ConvertUtils.formatDouble((double)plan, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), rollBudgetId);
                        if (cancelFlag != -1L) continue;
                        stats.addInfo("user-op-cancel.");
                        return;
                    }
                }
            }
            plan = (double)(datasetIndex + 1) * datasetRate;
            this.updateProgress(rollInitObject.getProgressKey(Long.valueOf(modelId)), String.valueOf(plan));
            Long cancelFlag = this.saveExecuteLog(rollInitObject, ConvertUtils.formatDouble((double)plan, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), rollBudgetId);
            if (cancelFlag == -1L) {
                stats.addInfo("user-op-cancel.");
                return;
            }
            log.info(stats.toString());
        }
        this.updateProgress(rollInitObject.getProgressKey(Long.valueOf(modelId)), "100.0");
        this.saveExecuteLog(rollInitObject, ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f", (String)"EbRollInitV2Plugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), CopyDataEnum.SUCCESS.getIndex(), rollBudgetId);
        this.updateInitStatus(CONFIG_SUCCESS, rollBudgetId);
        log.info("\u6eda\u52a8\u590d\u5236\u6210\u529f");
    }

    private void rollComputingData(@NotNull RollInitObject rollInitObject, @NotNull Model model, @NotNull Dataset dataset, @NotNull String entityNumber, @NotNull List<String> accounts, @NotNull Map<String, List<String>> memberMap) {
        String srcAudit = null;
        String tarAudit = null;
        Set<String> srcAuditTrials = null;
        Set tarAuditTrials = null;
        boolean hasAuditTrialFilter = false;
        if (rollInitObject.getSrcTrial().getMembers().size() == 1 && rollInitObject.getTarTrial().getMembers().size() == 1) {
            srcAudit = ((Member)rollInitObject.getSrcTrial().getMembers().get(0)).getNumber();
            tarAudit = ((Member)rollInitObject.getTarTrial().getMembers().get(0)).getNumber();
        } else {
            srcAuditTrials = rollInitObject.getSrcTrial().getMembers().stream().map(Member::getNumber).collect(Collectors.toSet());
            if (srcAuditTrials.containsAll(tarAuditTrials = rollInitObject.getTarTrial().getMembers().stream().map(Member::getNumber).collect(Collectors.toSet())) && tarAuditTrials.containsAll(srcAuditTrials)) {
                hasAuditTrialFilter = true;
            }
        }
        String srcVersion = memberMap.get(SysDimensionEnum.Version.getNumber()).get(0);
        String tarVersion = ((Member)rollInitObject.getTarVersion().getMembers().get(0)).getNumber();
        boolean hasVersion = srcVersion.equals(tarVersion);
        ArrayList<String> srcMember = new ArrayList<String>();
        srcMember.add(rollInitObject.getSrcDataType().getNumber() + '@' + memberMap.get(SysDimensionEnum.DataType.getNumber()).get(0));
        if (srcAudit != null && tarAudit != null) {
            srcMember.add(rollInitObject.getSrcTrial().getNumber() + '@' + ((Member)rollInitObject.getSrcTrial().getMembers().get(0)).getNumber());
        }
        if (!hasVersion) {
            srcMember.add(rollInitObject.getSrcVersion().getNumber() + '@' + srcVersion);
        }
        ArrayList<String> tarMember = new ArrayList<String>();
        tarMember.add(rollInitObject.getTarDataType().getNumber() + '@' + ((Member)rollInitObject.getTarDataType().getMembers().get(0)).getNumber());
        if (srcAudit != null && tarAudit != null) {
            tarMember.add(rollInitObject.getTarTrial().getNumber() + '@' + ((Member)rollInitObject.getTarTrial().getMembers().get(0)).getNumber());
        }
        if (!hasVersion) {
            tarMember.add(rollInitObject.getTarVersion().getNumber() + '@' + ((Member)rollInitObject.getTarVersion().getMembers().get(0)).getNumber());
        }
        if (!srcMember.isEmpty() && !tarMember.isEmpty()) {
            ComputingCommandInfo computing = new ComputingCommandInfo();
            computing.addFilter(SysDimensionEnum.Entity.getNumber(), new String[]{entityNumber});
            computing.addFilter(SysDimensionEnum.Account.getNumber(), accounts.toArray(new String[accounts.size()]));
            if (hasVersion) {
                computing.addFilter(SysDimensionEnum.Version.getNumber(), new String[]{srcVersion});
            }
            if (hasAuditTrialFilter && srcAuditTrials != null && srcAuditTrials.size() > 0) {
                computing.addFilter(SysDimensionEnum.AuditTrail.getNumber(), srcAuditTrials.toArray(new String[0]));
            }
            computing.addFilter(SysDimensionEnum.BudgetPeriod.getNumber(), memberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()).toArray(new String[0]));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)model.getId());
            List longs = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), SysDimensionEnum.ChangeType.getNumber());
            if (CollectionUtils.isNotEmpty((Collection)longs)) {
                ArrayList numbers = new ArrayList(16);
                for (Long aLong : longs) {
                    List allMmembers = modelCache.getMembers(aLong, SysDimensionEnum.ChangeType.getNumber());
                    List ebChanges = allMmembers.stream().filter(x -> !x.getNumber().equals("EBChanges") && !x.getLongNumber().startsWith("ChangeType!EBChanges!")).collect(Collectors.toList());
                    numbers.addAll(ebChanges.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
                }
                computing.addFilter(SysDimensionEnum.ChangeType.getNumber(), numbers.toArray(new String[0]));
            }
            FelLambdaExpressionItem expr = new FelLambdaExpressionItem();
            expr.setExpressLeft(StringUtils.join(tarMember, (char)','));
            expr.setExpression("value('" + StringUtils.join(srcMember, (char)',') + "')");
            computing.getExpressionItems().add(expr);
            computing.setMainMeaName(FacTabFieldDefEnum.FIELD_MONEY.getField());
            computing.setMainDimName(SysDimensionEnum.DataType.getNumber());
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)computing, null);
            OlapDataAuditService.getInstance().enhanceCommandWithAudit(model.getNumber(), ShrekOlapUtils.getCubeNumber((Dataset)dataset), (CommandInfo)computing);
            log.info("roll-computing-data:" + computing.toString());
            OlapCommand command = new OlapCommand(ShrekOlapServiceHelper.getConnection((Model)model, (Dataset)dataset), (CommandInfo)computing);
            command.executeCompute();
        } else {
            log.warn("roll-computing-warring:" + JSONUtils.toString((Object)rollInitObject));
        }
    }

    private <T> List<List<T>> splitList(List<T> list, int L) {
        LinkedList<List<T>> parts = new LinkedList<List<T>>();
        int N = list.size();
        for (int i = 0; i < N; i += L) {
            parts.add(new ArrayList<T>(list.subList(i, Math.min(N, i + L))));
        }
        return parts;
    }

    private void updateProgress(@NotNull String progressKey, @NotNull String progress) {
        CacheServiceHelper.put((String)progressKey, (Object)progress);
    }

    private void updateInitStatus(String initStatus, String rollBudgetId) {
        StringBuilder sql_update = new StringBuilder();
        sql_update.append("update t_eb_rollconfig set finitstatus = '").append(initStatus).append("' where fid = '").append(rollBudgetId).append("'");
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql_update.toString());
    }

    private boolean cleanOlapData(@NotNull RollInitObject rollInitObject, @NotNull IModelCacheHelper modelCache, @NotNull Long[] datasetIds, Map<Long, List<String>> datasetAndTempMap, @NotNull String basisType) {
        Model model = modelCache.getModelobj();
        Map<Object, Object> memberMap = null;
        List<Dimension> pageDimension = this.getDimByArray(modelCache);
        HashMap<String, List<Long>> viewIds = new HashMap(16);
        for (Long datasetId : datasetIds) {
            Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
            viewIds = modelCache.getViewGroupViewsByDataSet(datasetId);
            memberMap = CONFIG_SUCCESS.equals(basisType) ? this.getDimAndMem(modelCache, datasetId, viewIds, rollInitObject, false, false) : new LinkedHashMap(16);
            List prePeriods = rollInitObject.getActualSrcPeriod().getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
            ((List)memberMap.get(SysDimensionEnum.BudgetPeriod.getNumber())).addAll(prePeriods);
            if (memberMap.isEmpty()) continue;
            ComputingCommandInfo computing = new ComputingCommandInfo();
            for (Dimension dimension : pageDimension) {
                if (SysDimensionEnum.DataType.getNumber().equals(dimension.getNumber())) continue;
                List members = modelCache.getMembersByViews(dimension, (Collection)viewIds.get(dimension.getNumber()), (Collection)memberMap.get(dimension.getNumber()));
                if (SysDimensionEnum.Version.getNumber().equals(dimension.getNumber())) {
                    String tarVersionNumber = ((Member)rollInitObject.getTarVersion().getMembers().get(0)).getNumber();
                    members.removeIf(e -> !e.getNumber().equals(tarVersionNumber));
                }
                computing.addFilter(dimension.getNumber(), members.stream().map(BaseCache::getNumber).collect(Collectors.toList()).toArray(new String[0]));
            }
            List longs = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), SysDimensionEnum.ChangeType.getNumber());
            if (CollectionUtils.isNotEmpty((Collection)longs)) {
                ArrayList numbers = new ArrayList(16);
                for (Long aLong : longs) {
                    List allMmembers = modelCache.getMembers(aLong, SysDimensionEnum.ChangeType.getNumber());
                    List ebChanges = allMmembers.stream().filter(x -> !x.getNumber().equals("EBChanges") && !x.getLongNumber().startsWith("ChangeType!EBChanges!")).collect(Collectors.toList());
                    numbers.addAll(ebChanges.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
                }
                computing.addFilter(SysDimensionEnum.ChangeType.getNumber(), numbers.toArray(new String[0]));
            }
            FelLambdaExpressionItem expr = new FelLambdaExpressionItem();
            expr.setExpressLeft(SysDimensionEnum.DataType.getNumber() + '@' + ((Member)rollInitObject.getTarDataType().getMembers().get(0)).getNumber());
            expr.setExpression("null");
            computing.getExpressionItems().add(expr);
            computing.setMainMeaName(FacTabFieldDefEnum.FIELD_MONEY.getField());
            computing.setMainDimName(SysDimensionEnum.DataType.getNumber());
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)computing, null);
            log.info("roll-clear-data:" + computing.toString());
            OlapCommand command = new OlapCommand(ShrekOlapServiceHelper.getConnection((Model)model, (Dataset)dataset), (CommandInfo)computing);
            command.executeCompute();
        }
        return true;
    }

    private Map<String, List<String>> getDimAndMem(@NotNull IModelCacheHelper modelCache, @NotNull Long datasetId, Map<String, List<Long>> viewIds, @NotNull RollInitObject rollInitObject, boolean isSrc, boolean isActual) {
        List dimensionList = modelCache.getDimensionList(datasetId);
        LinkedHashMap<String, List<String>> dimMap = new LinkedHashMap<String, List<String>>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            List tmpMembers;
            String dimNumber = dimension.getNumber();
            if (SysDimensionEnum.DataType.getNumber().equals(dimNumber)) {
                if (isSrc) {
                    kd.epm.eb.common.model.Dimension srcDataType = null;
                    srcDataType = isActual ? rollInitObject.getActualSrcDataType() : rollInitObject.getSrcDataType();
                    tmpMembers = srcDataType.getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                } else {
                    kd.epm.eb.common.model.Dimension tarDataType = rollInitObject.getTarDataType();
                    tmpMembers = tarDataType.getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                }
                List members = dimMap.computeIfAbsent(dimNumber, f -> Lists.newLinkedList());
                members.addAll(tmpMembers);
                continue;
            }
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                kd.epm.eb.common.model.Dimension srcPeriod = isActual ? rollInitObject.getActualSrcPeriod() : rollInitObject.getSrcPeriod();
                List list = srcPeriod.getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                dimMap.put(dimNumber, list);
                continue;
            }
            if (SysDimensionEnum.Version.getNumber().equals(dimNumber)) {
                if (isSrc) {
                    kd.epm.eb.common.model.Dimension srcVersion = null;
                    srcVersion = isActual ? rollInitObject.getActualSrcVersion() : rollInitObject.getSrcVersion();
                    tmpMembers = srcVersion.getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                } else {
                    tmpMembers = rollInitObject.getTarVersion().getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                }
                dimMap.put(dimNumber, tmpMembers);
                continue;
            }
            if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                tmpMembers = isSrc ? rollInitObject.getSrcTrial().getMembers().stream().map(Member::getNumber).collect(Collectors.toList()) : rollInitObject.getTarTrial().getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                dimMap.put(dimNumber, tmpMembers);
                continue;
            }
            if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
                List<Long> longs = viewIds.get(SysDimensionEnum.ChangeType.getNumber());
                if (!CollectionUtils.isNotEmpty(longs)) continue;
                ArrayList numbers = new ArrayList(16);
                for (Long aLong : longs) {
                    List allMmembers = modelCache.getMembers(aLong, SysDimensionEnum.ChangeType.getNumber());
                    List ebChanges = allMmembers.stream().filter(x -> !x.getNumber().equals("EBChanges") && !x.getLongNumber().startsWith("ChangeType!EBChanges!")).collect(Collectors.toList());
                    numbers.addAll(ebChanges.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
                }
                dimMap.put(dimNumber, numbers);
                continue;
            }
            dimMap.put(dimNumber, this.queryMember(modelCache, dimension, viewIds));
        }
        return dimMap;
    }

    private List<String> queryMember(@NotNull IModelCacheHelper modelCacheHelper, @NotNull Dimension dimension, Map<String, List<Long>> viewIds) {
        List members = new ArrayList(16);
        if (viewIds.containsKey(dimension.getNumber())) {
            List<Long> longs = viewIds.get(dimension.getNumber());
            for (Long aLong : longs) {
                members.addAll(modelCacheHelper.getMembers(aLong, dimension.getNumber()));
            }
        } else {
            members = dimension.getLeafMembers();
        }
        return members.stream().map(BaseCache::getNumber).collect(Collectors.toList());
    }

    private List<Dimension> getDimByArray(@NotNull IModelCacheHelper modelCache) {
        ArrayList<Dimension> list = new ArrayList<Dimension>(EbRollInitV2Plugin.DIMARRAY.length);
        for (String s : EbRollInitV2Plugin.DIMARRAY) {
            Dimension dim = modelCache.getDimension(s);
            list.add(dim);
        }
        return list;
    }

    private Long saveExecuteLog(@NotNull RollInitObject rollInitObject, String msg, String status, String configId) {
        DynamicObject record = null;
        if (IDUtils.isNotNull((Long)rollInitObject.getLogRecordId())) {
            record = BusinessDataServiceHelper.loadSingleFromCache((Object)rollInitObject.getLogRecordId(), (String)"eb_rollinitrecord");
            boolean isCancel = record.getBoolean("iscancel");
            if (isCancel) {
                return -1L;
            }
        } else {
            record = BusinessDataServiceHelper.newDynamicObject((String)"eb_rollinitrecord");
            record.set("executor", (Object)UserUtils.getUserId());
            record.set("executedate", (Object)TimeServiceHelper.now());
            record.set("model", (Object)this.rollBudgetRequest.getModelId());
            record.set("inittype", (Object)rollInitObject.getIntiType());
            DynamicObjectCollection entry_trial = record.getDynamicObjectCollection("entry_trial");
            entry_trial.clear();
            this.fillTrialEntity(entry_trial);
            record.set("rollconfig", (Object)configId);
        }
        record.set("executestate", (Object)status);
        record.set("msg", (Object)msg);
        record.set("lastmodifytime", (Object)TimeServiceHelper.now());
        DynamicObject[] data = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        if (data != null && data.length > 0 && IDUtils.isNull((Long)rollInitObject.getLogRecordId())) {
            rollInitObject.setLogRecordId(Long.valueOf(data[0].getLong("id")));
        }
        return rollInitObject.getLogRecordId();
    }

    private void fillTrialEntity(DynamicObjectCollection ent_trial) {
        DynamicObject row;
        List trgauditList;
        List srcauditList;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.rollBudgetRequest.getModelId());
        if (CollectionUtils.isEmpty((Collection)this.rollBudgetRequest.getSrcAuditTrailNumbers()) && CollectionUtils.isEmpty((Collection)this.rollBudgetRequest.getTarAuditTrailNumbers())) {
            List members = modelCacheHelper.getMembers(Long.valueOf(0L), SysDimensionEnum.AuditTrail.getNumber());
            if (CollectionUtils.isEmpty((Collection)members)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u5ea6\u7ec4\u5408\u672a\u9009\u62e9\u5b8c\u6574\u3002", (String)"EbRollInitV2Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Set srcMembers = members.stream().filter(x -> x.getLevel() > 1 && x.isEnable() && !x.isDisable()).map(x -> new Member(x.getId(), null, x.getNumber())).collect(Collectors.toSet());
            srcauditList = srcMembers.stream().map(x -> x.getId().toString()).collect(Collectors.toList());
            trgauditList = srcMembers.stream().map(x -> x.getId().toString()).collect(Collectors.toList());
        } else {
            List srcMembers = modelCacheHelper.getMembers(SysDimensionEnum.AuditTrail.getNumber(), Long.valueOf(0L), (Collection)this.rollBudgetRequest.getSrcAuditTrailNumbers());
            List tarMembers = modelCacheHelper.getMembers(SysDimensionEnum.AuditTrail.getNumber(), Long.valueOf(0L), (Collection)this.rollBudgetRequest.getTarAuditTrailNumbers());
            if (CollectionUtils.isEmpty((Collection)srcMembers) || CollectionUtils.isEmpty((Collection)tarMembers)) {
                return;
            }
            srcauditList = srcMembers.stream().filter(x -> x.getLevel() > 1 && x.isEnable() && !x.isDisable()).map(x -> x.getId().toString()).collect(Collectors.toList());
            trgauditList = tarMembers.stream().filter(x -> x.getLevel() > 1 && x.isLeaf() && x.isEnable() && !x.isDisable()).map(x -> x.getId().toString()).collect(Collectors.toList());
        }
        if (srcauditList == null || srcauditList.size() == 0 || trgauditList == null || trgauditList.size() == 0) {
            return;
        }
        for (String str1 : srcauditList) {
            row = new DynamicObject(ent_trial.getDynamicObjectType());
            row.set("trial", (Object)str1);
            row.set("source", (Object)"0");
            ent_trial.add((Object)row);
        }
        for (String str2 : trgauditList) {
            row = new DynamicObject(ent_trial.getDynamicObjectType());
            row.set("trial", (Object)str2);
            row.set("source", (Object)CONFIG_SUCCESS);
            ent_trial.add((Object)row);
        }
    }

    private Long[] filterDatasetIds(Long modelId, Long[] datasetIds) {
        if (modelId == null || datasetIds == null) {
            return new Long[0];
        }
        LinkedHashSet filters = Sets.newLinkedHashSet();
        LinkedHashSet tmpSet = Sets.newLinkedHashSet();
        String sql = "select t.fid from t_eb_dataset t  left join t_eb_businessmodel bm on t.fbizmodelid = bm.fid  left join t_eb_scenarioentry se on bm.fid = se.fid  left join t_eb_applicationscenario ascen on se.fappscenarioid = ascen.fid  where t.fmodel = ? and ascen.fmodelid = ? and ascen.fnumber = '002' ";
        try (DataSet ds = DB.queryDataSet((String)"filterDatasetId", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelId, modelId});){
            if (ds != null) {
                for (Row row : ds) {
                    tmpSet.add(row.getLong("fid"));
                }
            }
        }
        for (Long datasetId : datasetIds) {
            if (!tmpSet.contains(datasetId)) continue;
            filters.add(datasetId);
        }
        return filters.toArray(new Long[filters.size()]);
    }

    private Map<Long, Long> getDateSetIdWithBusinessModelId(Long[] datasetIds, Long modelId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t.fid,t.fbizmodelid from t_eb_dataset t \n left join t_eb_businessmodel bm on t.fbizmodelid = bm.fid where bm.fmodelid  = ?", new Object[]{modelId});
        sqlBuilder.appendIn(" and  t.fid   ", (Object[])datasetIds);
        HashMap<Long, Long> result = new HashMap<Long, Long>(datasetIds.length);
        try (DataSet ds = DB.queryDataSet((String)"getDateSetIdWithBusinessModelId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    result.put(row.getLong("fid"), row.getLong("fbizmodelid"));
                }
            }
        }
        return result;
    }

    private Map<Long, List<String>> getDatasetAndTempMap(DynamicObject schemeDoc) {
        DynamicObjectCollection rolltemplate = schemeDoc.getDynamicObjectCollection("rolltemplate");
        ArrayList<Long> templateIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : rolltemplate) {
            long templateid = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            templateIds.add(templateid);
        }
        if (templateIds == null || templateIds.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", templateIds)};
        LinkedHashMap<Long, List<String>> map = new LinkedHashMap<Long, List<String>>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query-dataset-template", (String)"eb_templateentity", (String)"id,dataset,data", (QFilter[])filters, null);){
            if (ds != null) {
                for (Row row : ds) {
                    Long datasetId = row.getLong("dataset");
                    String data = row.getString("data");
                    List datas = map.computeIfAbsent(datasetId, f -> Lists.newLinkedList());
                    datas.add(data);
                }
            }
        }
        return map;
    }
}

