/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.pageinteraction.DynamicPage;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class RuleCaseExecRangeSelPlugin
extends AbstractFormPlugin
implements DynamicPage,
BeforeF7SelectListener {
    private static final String ALL = "allDims";
    private static final String CONTENT_PANEL = "contentpanel";
    private static final String CONTENT_FIELDS = "contentFields";
    private EntityMetadata entityMeta = null;
    public static final long MAX_RANGE_SIZE = 100000000L;
    private static final Log log = LogFactory.getLog(RuleCaseExecRangeSelPlugin.class);

    public void initialize() {
        try {
            super.initialize();
            if (this.getPage(this.getView()) != null) {
                this.getPage(this.getView()).bindCtrlMapping(this.getView());
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#initialize", (Throwable)e);
        }
    }

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            this.addClickListeners(new String[]{"btnok", "btnsaverange"});
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#registerListener", (Throwable)ex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            super.afterCreateNewData(e);
            this.loadAllDim();
            this.initContentPanel();
            this.bindCtrlMapping();
            List<Long> ruleCaseIds = this.getRuleCaseIds();
            DynamicObject[] ruleCaseSelRanges = BusinessDataServiceHelper.load((String)"eb_rulecaseexecrange", (String)"execrange,ruleexeccaseids", (QFilter[])new QFilter("ruleexeccaseids.fbasedataid_id", "in", ruleCaseIds).toArray());
            if (ruleCaseSelRanges != null && ruleCaseSelRanges.length > 0) {
                HashMap<Long, String> ruleCaseIdExecRangeMap = new HashMap<Long, String>(ruleCaseIds.size());
                for (DynamicObject ruleCaseSelRange : ruleCaseSelRanges) {
                    String execRange = ruleCaseSelRange.getString("execrange");
                    DynamicObjectCollection dynamicObjectCollection = ruleCaseSelRange.getDynamicObjectCollection("ruleexeccaseids");
                    for (DynamicObject ruleExecCaseId : dynamicObjectCollection) {
                        ruleCaseIdExecRangeMap.put(ruleExecCaseId.getLong("fbasedataid_id"), execRange);
                    }
                }
                String execRange = "";
                for (Long ruleCaseId : ruleCaseIds) {
                    String _execRange = (String)ruleCaseIdExecRangeMap.get(ruleCaseId);
                    if (!StringUtils.isNotEmpty((String)_execRange)) continue;
                    execRange = _execRange;
                    break;
                }
                if (StringUtils.isNotEmpty((String)execRange)) {
                    Map memberListMap = (Map)JsonUtils.readValue((String)execRange, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){});
                    List<Map<String, String>> list = this.getAllDims();
                    HashMap dimSignMap = new HashMap(list.size());
                    for (Map map : list) {
                        dimSignMap.put(map.get("number"), map.get("sign"));
                    }
                    IPageCache pageCache = this.getPageCache();
                    IDataModel iDataModel = this.getModel();
                    dimSignMap.forEach((k, v) -> {
                        List memberConditions = (List)memberListMap.get(k);
                        if (CollectionUtils.isNotEmpty((Collection)memberConditions)) {
                            StringBuilder sb = new StringBuilder();
                            for (MemberCondition memberCondition : memberConditions) {
                                sb.append(memberCondition).append(",");
                            }
                            sb.setLength(sb.length() - 1);
                            dataModel.setValue(v, (Object)sb.toString());
                            pageCache.put(v, JsonUtils.getJsonString((Object)memberConditions));
                        }
                    });
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#afterCreateNewData", (Throwable)ex);
        }
    }

    private void loadAllDim() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dims = modelCacheHelper.getDimensionListByBusModel(this.getBizModelId());
        Map<String, Dimension> dimensionMap = dims.stream().collect(Collectors.toMap(BaseCache::getNumber, v -> v, (v1, v2) -> v1));
        HashSet notSelDimSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Metric.getNumber()});
        ArrayList firstSelDims = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Currency.getNumber()});
        ArrayList list = new ArrayList(dims.size());
        for (String selDim : firstSelDims) {
            Dimension d = dimensionMap.get(selDim);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", String.valueOf(d.getId()));
            map.put("name", d.getName());
            map.put("number", d.getNumber());
            map.put("entity", d.getMemberModel());
            map.put("shortnumber", d.getShortNumber());
            map.put("seq", String.valueOf(d.getSeq()));
            map.put("sign", d.getMemberModel() + d.getSeq());
            list.add(map);
        }
        for (Dimension d : dims) {
            if (notSelDimSet.contains(d.getNumber()) || firstSelDims.contains(d.getNumber())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", String.valueOf(d.getId()));
            map.put("name", d.getName());
            map.put("number", d.getNumber());
            map.put("entity", d.getMemberModel());
            map.put("shortnumber", d.getShortNumber());
            map.put("seq", String.valueOf(d.getSeq()));
            map.put("sign", d.getMemberModel() + d.getSeq());
            list.add(map);
        }
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(list));
    }

    private void initContentPanel() {
        FlexPanelAp contentPanel = new FlexPanelAp();
        contentPanel.setKey(CONTENT_PANEL);
        List<Map<String, String>> list = this.getAllDims();
        this.addF7Items(contentPanel, list, false, false);
        this.updateControlMetadata(CONTENT_PANEL, contentPanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : contentPanel.getItems()) {
            if (!this.checkControlKey(ap.getKey())) continue;
            sb.append(ap.getKey()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put(CONTENT_FIELDS, sb.toString());
    }

    protected List<Map<String, String>> getAllDims() {
        if (this.getPageCache().get(ALL) == null) {
            this.loadAllDim();
        }
        return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL), List.class);
    }

    protected void addF7Items(FlexPanelAp pageviewpanel, List<Map<String, String>> list, boolean single, boolean lock) {
        HashSet mustInputSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Currency.getNumber()});
        for (Map<String, String> e : list) {
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setName(new LocaleString(e.get("name")));
            f7Field.setWidth(new LocaleString("200px"));
            f7Field.setKey(e.get("sign"));
            f7Field.setQuickAddNew(false);
            f7Field.setFireUpdEvt(true);
            f7Field.setShowTitle(false);
            TextField basedata = new TextField();
            if (mustInputSet.contains(e.get("number"))) {
                basedata.setMustInput(true);
            }
            if (!lock) {
                basedata.setEditStyle(1);
                f7Field.setShowTitle(true);
            }
            f7Field.setField((Field)basedata);
            f7Field.setFieldTextAlign("center");
            f7Field.setHeight(new LocaleString("40px"));
            Style style = new Style();
            Margin margin = new Margin();
            Padding padding = new Padding();
            padding.setRight("1px");
            padding.setLeft("30px");
            margin.setLeft("10px");
            margin.setRight("10px");
            margin.setTop("1px");
            margin.setBottom("10px");
            style.setMargin(margin);
            style.setPadding(padding);
            f7Field.setStyle(style);
            if (single && lock) {
                f7Field.setLabelDirection("h");
            }
            f7Field.setFireUpdEvt(true);
            pageviewpanel.getItems().add(f7Field);
        }
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            String key = ((Control)evt.getSource()).getKey();
            if (this.checkControlKey(key)) {
                String number = "";
                List<Map<String, String>> list = this.getAllDims();
                for (Map<String, String> map : list) {
                    if (!key.equals(map.get("sign"))) continue;
                    number = map.get("number");
                    break;
                }
                List con_list = null;
                String memberConStr = this.getPageCache().get(key);
                Long viewId = 0L;
                if (StringUtils.isNotEmpty((String)memberConStr)) {
                    con_list = (List)JsonUtils.readValue((String)memberConStr, (TypeReference)new TypeReference<List<MemberCondition>>(){});
                    viewId = IDUtils.toLong((Object)((MemberCondition)con_list.get(0)).getViewId());
                }
                Long modelId = this.getModelId();
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
                qFilters.add(new QFilter("model", "=", (Object)modelId));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                RangeF7Param param = new RangeF7Param();
                param.setBizModelId(this.getBizModelId());
                param.setCon_list(con_list);
                param.setCloseCallBack(closeCallBack);
                param.setqFilters(qFilters);
                param.setSign(key);
                param.setEnableView(true);
                param.setOpenProperty(true);
                param.setMultiVariable(true);
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(number)) {
                    param.setIsNeedVar("isNeedVar");
                    param.setCanSelectBudgetPeriodRoot(false);
                }
                CustomF7utils.openCustomF7Range((Long)modelId, (String)number, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
            } else if (key.equals("btnok")) {
                List<Long> ruleCaseIds = this.getRuleCaseIds();
                this.saveExecRange(ruleCaseIds);
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(ruleCaseIds));
                this.getView().close();
            } else if (key.equals("btnsaverange")) {
                List<Long> ruleCaseIds = this.getRuleCaseIds();
                this.saveExecRange(ruleCaseIds);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6267\u884c\u8303\u56f4\u6210\u529f\u3002", (String)"RuleCase_82", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#click", (Throwable)e);
        }
    }

    private void saveExecRange(List<Long> ruleCaseIds) {
        List<Map<String, String>> list = this.getAllDims();
        HashMap<String, String> dimSignMap = new HashMap<String, String>(list.size());
        for (Map<String, String> map : list) {
            dimSignMap.put(map.get("number"), map.get("sign"));
        }
        HashMap memberListMap = new HashMap(list.size());
        IPageCache pageCache = this.getPageCache();
        dimSignMap.forEach((k, v) -> {
            String memStr = pageCache.get(v);
            if (StringUtils.isNotEmpty((String)memStr)) {
                memberListMap.put(k, JsonUtils.readValue((String)memStr, (TypeReference)new TypeReference<List<MemberCondition>>(){}));
            }
        });
        String selRange = JsonUtils.getJsonString(memberListMap);
        DynamicObject[] ruleCaseSelRanges = BusinessDataServiceHelper.load((String)"eb_rulecaseexecrange", (String)"ruleexeccaseids", (QFilter[])new QFilter("ruleexeccaseids.fbasedataid_id", "in", ruleCaseIds).toArray());
        if (ruleCaseSelRanges != null && ruleCaseSelRanges.length > 0) {
            boolean ruleCaseIsEmpty = false;
            for (DynamicObject ruleCaseSelRange : ruleCaseSelRanges) {
                DynamicObjectCollection ruleExecCaseIds = ruleCaseSelRange.getDynamicObjectCollection("ruleexeccaseids");
                ruleExecCaseIds.removeIf(e -> ruleCaseIds.contains(e.getLong("fbasedataid_id")));
                if (!CollectionUtils.isEmpty((Collection)ruleExecCaseIds)) continue;
                ruleCaseIsEmpty = true;
            }
            if (ruleCaseIsEmpty) {
                QFilter[] filters = new QFilter("ruleexeccaseids.fbasedataid_id", "in", ruleCaseIds).toArray();
                DeleteServiceHelper.delete((String)"eb_rulecaseexecrange", (QFilter[])filters);
            } else {
                SaveServiceHelper.save((DynamicObject[])ruleCaseSelRanges);
            }
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_rulecaseexecrange");
        dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dynamicObject.set("name", (Object)"default");
        dynamicObject.set("number", (Object)"default");
        dynamicObject.set("model", (Object)this.getModelId());
        dynamicObject.set("bizmodelid", (Object)this.getBizModelId());
        DynamicObjectCollection ruleExecCaseIds = dynamicObject.getDynamicObjectCollection("ruleexeccaseids");
        for (Long ruleCaseId : ruleCaseIds) {
            DynamicObject ruleCase = new DynamicObject(ruleExecCaseIds.getDynamicObjectType());
            ruleCase.set("fbasedataId", (Object)ruleCaseId);
            ruleExecCaseIds.add((Object)ruleCase);
        }
        dynamicObject.set("ruleexeccaseids", (Object)ruleExecCaseIds);
        dynamicObject.set("execrange", (Object)selRange);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void bindCtrlMapping() {
        String[] fields;
        String f7MapFields = this.getPageCache().get(CONTENT_FIELDS);
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        if (this.entityMeta == null) {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            this.entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        }
        for (String field : fields = f7MapFields.split(";")) {
            if (props.containsKey((Object)field)) continue;
            this.addTextFieldToMainEntity((Container)this.getControl(CONTENT_PANEL), mainEntityType, this.entityMeta, field, this.getModel(), this.getView());
        }
    }

    private void addTextFieldToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey, IDataModel model, IFormView view) {
        TextProp fieldprop = new TextProp();
        fieldprop.setName(fieldKey);
        targetEntity.addProperty((DynamicProperty)fieldprop);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldprop);
        }
        FieldAp field = new FieldAp();
        field.setName(new LocaleString(fieldKey));
        field.setKey(fieldKey);
        field.setFireUpdEvt(true);
        TextField textFiled = new TextField();
        textFiled.setKey(fieldKey);
        textFiled.setEntityMetadata(entityMeta);
        entityMeta.getItems().add(textFiled);
        field.setField((Field)textFiled);
        FieldEdit control = field.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    private void updateControlMetadata(String key, Map<String, Object> ctl) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        if (ctl.get("items") == null) {
            ctl.put("items", new Object[0]);
        }
        paras.add(ctl);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("updateControlMetadata", paras);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            super.propertyChanged(e);
            String ctrlKey = e.getProperty().getName();
            ChangeData changeData = e.getChangeSet()[0];
            if (this.checkControlKey(ctrlKey) && changeData.getOldValue() instanceof String && StringUtils.isNotEmpty((String)((String)changeData.getOldValue())) && changeData.getNewValue() instanceof String && StringUtils.isEmpty((String)((String)changeData.getNewValue()))) {
                this.getPageCache().put(ctrlKey, null);
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#propertyChanged", (Throwable)ex);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        try {
            super.onGetControl(e);
            String ctrlKey = e.getKey();
            if (this.checkControlKey(ctrlKey)) {
                TextEdit edit = new TextEdit();
                edit.setKey(ctrlKey);
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#onGetControl", (Throwable)ex);
        }
    }

    protected boolean checkControlKey(String controlKey) {
        if (controlKey == null) {
            return false;
        }
        return controlKey.startsWith("epm_") || controlKey.startsWith("eb_");
    }

    public Long getModelId() {
        Long modelId = 0L;
        try {
            modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#getModelId", (Throwable)e);
        }
        return modelId;
    }

    public Long getBizModelId() {
        Long bizModelId = 0L;
        try {
            bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModel");
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#getBizModelId", (Throwable)e);
        }
        return bizModelId;
    }

    public List<Long> getRuleCaseIds() {
        List<Long> ruleCaseIds = new ArrayList<Long>(16);
        try {
            String ruleCaseIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("ruleCaseIds");
            ruleCaseIds = (List)SerializationUtils.deSerializeFromBase64((String)ruleCaseIdsStr);
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#getRuleCaseIds", (Throwable)e);
        }
        return ruleCaseIds;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#getEntityType", (Throwable)ex);
        }
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        String f7MapFields = this.getPageCache().get(CONTENT_FIELDS);
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        for (String fieldKey : fields) {
            this.registerSimplePropWithId((EntityType)mainEntityType, fieldKey);
        }
    }

    private void registerSimplePropWithId(EntityType entityType, String fieldKey) {
        TextProp textProp = new TextProp();
        textProp.setName(fieldKey);
        entityType.addProperty((DynamicProperty)textProp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        try {
            super.closedCallBack(closedCallBackEvent);
            String actionId = closedCallBackEvent.getActionId();
            if (this.checkControlKey(actionId)) {
                DynamicObjectCollection dyObjs;
                if (closedCallBackEvent.getReturnData() == null) {
                    return;
                }
                if (closedCallBackEvent.getReturnData() instanceof DynamicObjectCollection && (dyObjs = (DynamicObjectCollection)closedCallBackEvent.getReturnData()) != null) {
                    ArrayList<MemberCondition> memberList = new ArrayList<MemberCondition>(dyObjs.size());
                    StringBuilder sb = new StringBuilder();
                    IModelCacheHelper modelCache = this.getIModelCacheHelper();
                    MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
                    for (DynamicObject dyObj : dyObjs) {
                        String name = dyObj.getString("name");
                        String number = dyObj.getString("number");
                        String range = dyObj.getString("scope");
                        Long viewId = dyObj.getLong("viewid");
                        MemberCondition memberCondition = new MemberCondition(number, name, "", range);
                        memberCondition.setViewId(IDUtils.toString((Object)viewId));
                        memberCondition.setId(IDUtils.toString((Object)dyObj.getString("id")));
                        String typeString = dyObj.getString("type");
                        if (RangeF7PropertyCataEnum.Property.getIndex().equals(typeString)) {
                            memberCondition.setProp(true);
                            CustomPropertyValue customPropertyValue = memberPropCache.getPropertyValue(Long.valueOf(dyObj.getLong("mid")));
                            memberCondition.setLongnumber(customPropertyValue.getProp().getNumber() + "!" + customPropertyValue.getNumber());
                        }
                        memberList.add(memberCondition);
                        sb.append(memberCondition).append(",");
                    }
                    sb.setLength(sb.length() - 1);
                    String memberShow = sb.toString();
                    this.getModel().setValue(actionId, (Object)memberShow);
                    this.getPageCache().put(actionId, JsonUtils.getJsonString(memberList));
                    this.getView().updateView(actionId);
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleCaseExecRangeSelPlugin#closedCallBack", (Throwable)e);
        }
    }
}

