/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.f7.FormulaCondition;
import kd.epm.eb.common.orm.EbBizruleset;
import kd.epm.eb.common.orm.EbBizrulesetStatusEnum;
import kd.epm.eb.common.pojo.EdgePojo;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.OpenRulePojo;
import kd.epm.eb.common.rule.edit.RuleManageRowPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphDataPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphModelPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphNodePojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphDataTrackingItemPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphDataTrackingTypeEnum;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GenCopyUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.MapPlusUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.ruleexec.RuleExecCaseEditPlugin;
import kd.epm.eb.formplugin.ruleexec.RuleExecContext;
import kd.epm.eb.formplugin.ruleexec.RuleExecGenCaseController;
import kd.epm.eb.formplugin.ruleexec.RuleExecGraphUtils;
import kd.epm.eb.formplugin.ruleexec.entity.RuleExecGenCaseRequest;
import kd.epm.eb.formplugin.ruleexec.enums.CaseUpdateStatusEnum;
import kd.epm.eb.formplugin.ruleexec.enums.ExecCaseWizardStepEnum;
import kd.epm.eb.formplugin.ruleexec.enums.RuleExecCaseTypeEnum;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;
import kd.epm.eb.formplugin.rulemanage.RelationGraphUtils;
import kd.epm.eb.formplugin.rulemanage.RuleManageQueryOp;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecuteVo;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.util.ExecuteRuleUtils;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.execute.dao.RuleManageJsonUtil;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class RuleExecCaseEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String CURR_CARD = "currCard";
    private static final String RANGEENTITY = "rangeentity";
    private static final String SELECTRULEENTITY = "selectruleentity";
    private static final String RULERANGEENTITY = "rulerangeentity";
    private static final String SELECT_TEMPLATE = "select_template";
    private static final String RELATION_SORT = "relation_sort";
    private static final String ALLOW_DISABLE = "allowdisable";
    private boolean putBack = false;

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            this.addItemClickListeners(new String[]{"toolbarap1", "toolbarap2", "toolbarap3"});
            this.addClickListeners(new String[]{"members", "rulemembers", "updaterule"});
            BasedataEdit bizrules = (BasedataEdit)this.getControl("rulename");
            bizrules.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            EntryGrid eg = (EntryGrid)this.getControl(SELECTRULEENTITY);
            eg.addRowClickListener((RowClickEventListener)this);
            eg.addHyperClickListener((HyperLinkClickListener)this);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#registerListener", (Throwable)ex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        try {
            String key = beforeF7SelectEvent.getProperty().getName();
            if ("rulename".equals(key)) {
                this.beforeF7BizRule(beforeF7SelectEvent);
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#beforeF7Select", (Throwable)e);
        }
    }

    public void beforeF7BizRule(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>(16);
        }
        filters.add(new QFilter("bizctrlrange", "=", (Object)this.getBizModelId()));
        filters.add(new QFilter("model", "=", (Object)this.getModelId()));
        Boolean allowDisable = (Boolean)this.getModel().getValue(ALLOW_DISABLE);
        if (!allowDisable.booleanValue()) {
            filters.add(new QFilter("status", "=", (Object)true));
        }
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    public void entryRowClick(RowClickEvent evt) {
        try {
            ExecCaseWizardStepEnum currStep = this.getCurrStep();
            if (currStep == ExecCaseWizardStepEnum.Rule) {
                this.proChangeRuleNamesToRuleRangeEntity();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#entryRowClick", (Throwable)e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            String type = (String)this.getModel().getValue("type");
            RuleExecCaseTypeEnum typeEnum = RuleExecCaseTypeEnum.getByType((String)type);
            List stepEnumList = ExecCaseWizardStepEnum.getWizardStepList((RuleExecCaseTypeEnum)typeEnum);
            ExecCaseWizardStepEnum currStep = (ExecCaseWizardStepEnum)stepEnumList.get(0);
            this.getModel().setValue("model", this.getCustomFormParam("modelId"));
            this.getModel().setValue("bizmodel", this.getCustomFormParam("bizmodelid"));
            this.getModel().setValue("currStep", (Object)currStep.getNumber());
            this.setAllowDisAbleVisible(typeEnum);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#afterCreateNewData", (Throwable)ex);
        }
    }

    private void setAllowDisAbleVisible(RuleExecCaseTypeEnum typeEnum) {
        if (typeEnum == RuleExecCaseTypeEnum.RULE) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ALLOW_DISABLE});
        } else if (typeEnum == RuleExecCaseTypeEnum.RANGE) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ALLOW_DISABLE});
        }
    }

    private ExecCaseWizardStepEnum setWizard(ExecCaseWizardStepEnum currStep) {
        String type = (String)this.getModel().getValue("type");
        RuleExecCaseTypeEnum typeEnum = RuleExecCaseTypeEnum.getByType((String)type);
        List stepEnumList = ExecCaseWizardStepEnum.getWizardStepList((RuleExecCaseTypeEnum)typeEnum);
        if (currStep == null) {
            currStep = (ExecCaseWizardStepEnum)stepEnumList.get(0);
        }
        Wizard wizard = (Wizard)this.getControl("wizardap");
        List stepsOptions = wizard.getStepsOptions();
        this.createStepOption(stepsOptions, stepEnumList);
        wizard.setWizardStepsOptions(stepsOptions);
        this.setCurrWizardStep(currStep.getSeq());
        this.setAllowDisAbleVisible(typeEnum);
        return currStep;
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.ADDNEW.equals((Object)status)) {
                this.setWizard(this.getCurrStep());
                this.setBizModelLabelName();
                this.setPageVisible();
                this.setToolbarVisible();
                this.rebuildRangeEntityMembersAndSize();
                this.rebuildSelectRuleEntity();
                if (IDUtils.isEmptyLong((Long)((Long)this.getModel().getValue("id"))).booleanValue() && StringUtils.isNotEmpty((String)((String)this.getModel().getValue("number")))) {
                    this.setDefaultNameAndNumber();
                }
            }
            this.getModel().setDataChanged(false);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#afterBindData", (Throwable)ex);
        }
    }

    private void setDefaultNameAndNumber() {
        HashSet<String> numberSet = new HashSet<String>(16);
        HashSet<String> nameSet = new HashSet<String>(16);
        QFilter modelQfilter = new QFilter("model", "=", (Object)this.getModelId());
        DataSet allData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"eb_ruleexeccase", (String)"name, number", (QFilter[])new QFilter[]{modelQfilter}, null);
        Object object = null;
        try {
            while (allData.hasNext()) {
                Row row = allData.next();
                numberSet.add(row.getString("number"));
                nameSet.add(row.getString("name"));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (allData != null) {
                if (object != null) {
                    try {
                        allData.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    allData.close();
                }
            }
        }
        OrmLocaleValue oldName = (OrmLocaleValue)this.getModel().getValue("name");
        for (Map.Entry entry : oldName.entrySet()) {
            oldName.put((String)entry.getKey(), GenCopyUtils.generateCopy((String)((String)entry.getValue()), nameSet, (int)50));
        }
        this.getModel().setValue("name", (Object)oldName);
        String oldNumber = (String)this.getModel().getValue("number");
        this.getModel().setValue("number", (Object)GenCopyUtils.generateCopy((String)oldNumber, numberSet, (int)50));
    }

    private void setBizModelLabelName() {
        DynamicObject doj = (DynamicObject)this.getModel().getValue("bizmodel");
        if (doj != null) {
            String bizModelName = doj.getString("name");
            Label label1 = (Label)this.getControl("label1");
            label1.setText(ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\uff1a%1", (String)"RuleCase_8", (String)"epm-eb-formplugin", (Object[])new Object[]{bizModelName}));
            Label label3 = (Label)this.getControl("label3");
            label3.setText(ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\uff1a%1", (String)"RuleCase_8", (String)"epm-eb-formplugin", (Object[])new Object[]{bizModelName}));
        }
    }

    private void setToolbarVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_up", "btn_down", "btn_save", "btn_saveaddnew", "updaterulepanel"});
        ExecCaseWizardStepEnum currStep = this.getCurrStep();
        if (currStep == ExecCaseWizardStepEnum.Establish) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_down"});
        } else if (currStep == ExecCaseWizardStepEnum.Rule) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_up", "btn_save", "btn_saveaddnew"});
        } else if (currStep == ExecCaseWizardStepEnum.Range) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_up", "btn_down", "btn_save"});
        } else if (currStep == ExecCaseWizardStepEnum.Generate) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_up", "btn_save", "btn_saveaddnew", "updaterulepanel"});
        }
    }

    private void setPageVisible() {
        for (ExecCaseWizardStepEnum value : ExecCaseWizardStepEnum.values()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{value.getPanelName()});
        }
        ExecCaseWizardStepEnum currStep = this.getCurrStep();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{currStep.getPanelName()});
        this.changePanel3(currStep);
    }

    private void changePanel3(ExecCaseWizardStepEnum currStep) {
        if (currStep == ExecCaseWizardStepEnum.Rule) {
            Label label = (Label)this.getControl("label2");
            label.setText(ResManager.loadKDString((String)"\u5df2\u9009\u89c4\u5219", (String)"RuleCase_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Label label4 = (Label)this.getControl("label4");
            label4.setText(ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c\u8303\u56f4", (String)"RuleCase_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"label5"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"buttonpanel2"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"select_rule", "delrow", "moveup", "movedown", SELECT_TEMPLATE, RELATION_SORT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"topologygraph", "updaterule", "updatedetail"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{RULERANGEENTITY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ruleop"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"rulestatus"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{SELECTRULEENTITY});
            SplitContainer splitContainer = (SplitContainer)this.getControl("childpanel3");
            splitContainer.hidePanel(SplitDirection.right, false);
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("selchexkbox", true);
            this.getView().updateControlMetadata(SELECTRULEENTITY, map);
        } else if (currStep == ExecCaseWizardStepEnum.Generate) {
            Label label = (Label)this.getControl("label2");
            label.setText(ResManager.loadKDString((String)"\u5173\u8054\u4e1a\u52a1\u89c4\u5219", (String)"RuleCase_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Label label4 = (Label)this.getControl("label4");
            label4.setText(ResManager.loadKDString((String)"\u8ba1\u7b97\u8868\u8fbe\u5f0f", (String)"RuleCase_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"label5"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonpanel2"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"select_rule", "delrow", "moveup", "movedown", SELECT_TEMPLATE, RELATION_SORT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"topologygraph", "updaterule", "updatedetail"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RULERANGEENTITY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleop"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rulestatus"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SELECTRULEENTITY});
            SplitContainer splitContainer = (SplitContainer)this.getControl("childpanel3");
            splitContainer.hidePanel(SplitDirection.right, true);
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("selchexkbox", false);
            this.getView().updateControlMetadata(SELECTRULEENTITY, map);
        }
    }

    public void click(EventObject evt) {
        try {
            String clickKey;
            switch (clickKey = ((Control)evt.getSource()).getKey()) {
                case "members": {
                    this.clickMembers();
                    break;
                }
                case "rulemembers": {
                    this.clickRuleMembers();
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#click", (Throwable)e);
        }
    }

    private void updateRule() {
        String updatestatus = (String)this.getModel().getValue("updatestatus");
        if (CaseUpdateStatusEnum.UPDATE_ING.getCode().equals(updatestatus) || CaseUpdateStatusEnum.UPDATE_END.getCode().equals(updatestatus)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u66f4\u65b0\u72b6\u6001\u4e3a%1\uff0c\u65e0\u9700\u518d\u6b21\u66f4\u65b0\u3002", (String)"RuleCase_13", (String)"epm-eb-formplugin", (Object[])new Object[]{CaseUpdateStatusEnum.getStatusByCode((String)updatestatus).getName()}));
            return;
        }
        this.dispatherUpdateRule();
    }

    private void clickMembers() {
        Map views;
        EntryGrid entry = (EntryGrid)this.getControl(RANGEENTITY);
        DynamicObject entryData = this.getModel().getEntryRowEntity(RANGEENTITY, entry.getEntryState().getFocusRow());
        if (entryData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"BgExecuteRulePlugin2_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimNumber = entryData.getString("dimnumber");
        List con_list = null;
        String memberjson = entryData.getString("memberjson");
        if (StringUtils.isNotEmpty((String)memberjson)) {
            con_list = (List)JsonUtils.readValue((String)memberjson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        Long viewId = 0L;
        DynamicObject view = entryData.getDynamicObject("view");
        viewId = view == null ? ((views = this.getIModelCacheHelper().getViewsByBusModel(this.getBizModelId())).get(dimNumber) == null ? Long.valueOf(0L) : (Long)views.get(dimNumber)) : Long.valueOf(view.getLong("id"));
        RangeF7Param rangeF7Param = new RangeF7Param();
        rangeF7Param.setBizModelId(this.getBizModelId());
        rangeF7Param.setCon_list(con_list);
        rangeF7Param.setRangeType(F7RangeTypeEnum.MINI);
        if (!View.NoViewDimNums.contains(dimNumber)) {
            rangeF7Param.setEnableView(true);
        }
        rangeF7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "clickMembers"));
        rangeF7Param.setOpenProperty(true);
        rangeF7Param.setMultiVariable(true);
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimNumber, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)rangeF7Param);
    }

    public void clickRuleMembers() {
        EntryGrid entry = (EntryGrid)this.getControl(RULERANGEENTITY);
        DynamicObject entryData = this.getModel().getEntryRowEntity(RULERANGEENTITY, entry.getEntryState().getFocusRow());
        if (entryData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"BgExecuteRulePlugin2_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimNumber = entryData.getString("ruledimnumber");
        ExecuteVo currRule = this.getCurrRule();
        List con_list = currRule == null ? null : (List)currRule.getMemberListMap().get(dimNumber);
        Map viewMap = this.getIModelCacheHelper().getViewsByBusModel(this.getBizModelId());
        if (currRule != null && currRule.getRuleDto() != null) {
            viewMap = currRule.getRuleDto().getViewMap();
        }
        Long viewId = viewMap.get(dimNumber) == null ? Long.valueOf(0L) : (Long)viewMap.get(dimNumber);
        RangeF7Param rangeF7Param = new RangeF7Param();
        rangeF7Param.setBizModelId(this.getBizModelId());
        rangeF7Param.setCon_list(con_list);
        rangeF7Param.setRangeType(F7RangeTypeEnum.MINI);
        if (!View.NoViewDimNums.contains(dimNumber)) {
            rangeF7Param.setEnableView(true);
        }
        rangeF7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "clickRuleMembers"));
        rangeF7Param.setOpenProperty(true);
        rangeF7Param.setMultiVariable(true);
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
            rangeF7Param.setIsNeedVar("isNeedVar");
        }
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimNumber, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)rangeF7Param);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            String propKey;
            switch (propKey = e.getProperty().getName()) {
                case "type": {
                    String radioValue = (String)this.getModel().getValue("type");
                    RuleExecCaseTypeEnum typeEnum = RuleExecCaseTypeEnum.getByType((String)radioValue);
                    this.setAllowDisAbleVisible(typeEnum);
                    ExecCaseWizardStepEnum nextStep = "1".equals(radioValue) ? ExecCaseWizardStepEnum.Rule : ExecCaseWizardStepEnum.Range;
                    List nextList = ExecCaseWizardStepEnum.getNextList((ExecCaseWizardStepEnum)nextStep);
                    Wizard wizard = (Wizard)this.getControl("wizardap");
                    List stepsOptions = wizard.getStepsOptions();
                    stepsOptions.clear();
                    this.createStepOption(stepsOptions, nextList);
                    wizard.setWizardStepsOptions(stepsOptions);
                    break;
                }
                case "number": {
                    this.propChangeNumber(e);
                    break;
                }
                case "members": {
                    this.proChangeMembers(e);
                    break;
                }
                case "rulemembers": {
                    this.proChangeRuleMembers(e);
                    break;
                }
                case "rulename": {
                    this.proChangeRuleNames(e);
                    break;
                }
                case "dataset": {
                    this.reBuildRangeEntity(this.getDataSetId());
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#propertyChanged", (Throwable)ex);
        }
    }

    private void propChangeNumber(PropertyChangedArgs e) {
        Object id = this.getModel().getValue("id");
        if (id == null || IDUtils.isEmptyLong((Long)((Long)id)).booleanValue()) {
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u66f4\u6539\uff0c\u8bf7\u624b\u52a8\u4fee\u6539\u8be5\u65b9\u6848\u5bf9\u5e94\u7684\u5b9a\u65f6\u4efb\u52a1\u3002", (String)"RuleCase_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void proChangeRuleNames(PropertyChangedArgs e) {
        if (this.putBack) {
            return;
        }
        ChangeData[] datas = e.getChangeSet();
        if (datas != null && datas.length > 0) {
            ChangeData data = datas[0];
            Object newValue = data.getNewValue();
            int rowIndex = data.getRowIndex();
            Object oldValue = data.getOldValue();
            if (newValue == null || "".equals(data.getNewValue())) {
                this.getModel().beginInit();
                this.putBack = true;
                this.getModel().setValue("rulename", oldValue, rowIndex);
                this.getModel().endInit();
            } else {
                DynamicObject newValue1 = (DynamicObject)newValue;
                DynamicObject dbObj = QueryServiceHelper.queryOne((String)"eb_bizruleset", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", newValue1.get("id"))});
                this.getModel().setValue("rulestatus", dbObj.get("status"), rowIndex);
                this.getModel().setValue("rulenumber", newValue1.get("number"), rowIndex);
                this.getModel().setValue("rangejson", (Object)"", rowIndex);
                this.proChangeRuleNamesToRuleRangeEntity();
            }
        }
    }

    public void proChangeRuleNamesToRuleRangeEntity() {
        ExecuteVo executeVo = this.getCurrRule();
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        this.getModel().deleteEntryData(RULERANGEENTITY);
        if (executeVo == null) {
            this.putLabelDescartes(new BigInteger("0"));
            this.getView().updateView(RULERANGEENTITY);
            return;
        }
        List dimensionList = modelCache.getDimensionList(executeVo.ruleDataSetId());
        this.getModel().batchCreateNewEntryRow(RULERANGEENTITY, dimensionList.size() - 1);
        Map<String, List> dim2ConditionMapping = executeVo.getConditionList().stream().collect(Collectors.toMap(FormulaCondition::getDimensionNumber, FormulaCondition::getMemberList));
        Map memberListMap = executeVo.getMemberListMap();
        int index = 0;
        HashMap<String, Integer> descarteMap = new HashMap<String, Integer>(16);
        RuleDto ruleDto = executeVo.getRuleDto();
        String metNumber = (String)((Set)ruleDto.getLeftMembers().get(SysDimensionEnum.Metric.getNumber())).iterator().next();
        Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metNumber);
        if (CollectionUtils.isNotEmpty((Collection)dimensionList) && ruleDto != null) {
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
            Map varValues = ReportVarUtil.getVarValuesByRule((Integer)ProcessTypeEnum.RULE.getIndex(), (Long)this.getModelId());
            for (Dimension dimension : dimensionList) {
                int range;
                if (ruleDto.getMainDimensionId().equals(dimension.getId())) continue;
                DynamicObject row = this.getModel().getEntryRowEntity(RULERANGEENTITY, index++);
                row.set("ruledimname", (Object)dimension.getName());
                row.set("ruledimnumber", (Object)dimension.getNumber());
                List memberConditions1 = (List)memberListMap.get(dimension.getNumber());
                List memberConditions2 = dim2ConditionMapping.get(dimension.getNumber());
                if (memberConditions1 != null) {
                    row.set("rulemembers", (Object)ExecuteRuleUtils.buildMemberConditionString2((List)memberConditions1));
                    range = ExecuteRuleUtils.calcConditionRange2((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Map)varValues, (Dimension)dimension, (List)memberConditions1, (Set)((Set)ruleDto.getLeftMembers().get(dimension.getNumber())), (boolean)metMember.hasAgg());
                } else if (memberConditions2 != null) {
                    row.set("rulemembers", (Object)ExecuteRuleUtils.buildMemberConditionString((List)memberConditions2));
                    range = ExecuteRuleUtils.calcConditionRange((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Map)varValues, (Dimension)dimension, (List)memberConditions2, (Set)((Set)ruleDto.getLeftMembers().get(dimension.getNumber())), (boolean)metMember.hasAgg());
                } else {
                    range = ExecuteRuleUtils.calcAllDetailMembers((Dimension)dimension, (RuleDto)ruleDto);
                }
                row.set("rulemembercount", (Object)range);
                descarteMap.put(dimension.getNumber(), range);
            }
        }
        executeVo.setDescarteMap(descarteMap);
        this.putLabelDescartes(this.calcDesCartes());
        this.getView().updateView(RULERANGEENTITY);
    }

    public void proChangeMembers(PropertyChangedArgs event) {
        ChangeData data;
        ChangeData[] datas = event.getChangeSet();
        if (datas != null && (data = datas[0]) != null && (data.getNewValue() == null || "".equals(data.getNewValue()))) {
            EntryGrid entry = (EntryGrid)this.getControl(RANGEENTITY);
            int rowIndex = entry.getEntryState().getFocusRow();
            this.getModel().setValue("membercount", (Object)0, rowIndex);
            this.getModel().setValue("memberjson", (Object)"", rowIndex);
        }
    }

    public void proChangeRuleMembers(PropertyChangedArgs event) {
        ChangeData data;
        ChangeData[] datas = event.getChangeSet();
        if (datas != null && (data = datas[0]) != null && (data.getNewValue() == null || "".equals(data.getNewValue()))) {
            EntryGrid entry = (EntryGrid)this.getControl(RULERANGEENTITY);
            int rowIndex = entry.getEntryState().getFocusRow();
            this.getModel().setValue("rulemembercount", (Object)0, rowIndex);
            ExecuteVo executeVo = this.getCurrRule();
            if (executeVo != null) {
                String dimNumber = (String)this.getModel().getValue("ruledimnumber", rowIndex);
                IModelCacheHelper modelCache = this.getIModelCacheHelper();
                Dimension dimension = modelCache.getDimension(dimNumber);
                Integer range = ExecuteRuleUtils.calcAllDetailMembers((Dimension)dimension, (RuleDto)executeVo.getRuleDto());
                this.getModel().setValue("rulemembercount", (Object)range, rowIndex);
                this.putLabelDescartes(this.calcDesCartes());
                String rangeJson = (String)this.getModel().getValue("rangejson", executeVo.getRowIndex());
                if (StringUtils.isNotEmpty((String)rangeJson)) {
                    Map memberListMap = (Map)JsonUtils.readValue((String)rangeJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    memberListMap.remove(dimNumber);
                    this.getModel().setValue("rangejson", (Object)JsonUtils.getJsonString((Object)memberListMap), executeVo.getRowIndex());
                }
            }
        }
    }

    private void createStepOption(List<StepsOption> stepsOptions, List<ExecCaseWizardStepEnum> stepEnumList) {
        String process = "process";
        for (int i = 0; i < stepEnumList.size(); ++i) {
            ExecCaseWizardStepEnum stepEnum = stepEnumList.get(i);
            StepsOption stepsOption0 = this.getStepsOption(stepEnum, process);
            stepsOptions.add(stepsOption0);
        }
    }

    private void setCurrWizardStep(int index) {
        Wizard wizard = (Wizard)this.getControl("wizardap");
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
        currentStepMap.put("currentStep", index);
        currentStepMap.put("currentStatus", "process");
        wizard.setWizardCurrentStep(currentStepMap);
    }

    private StepsOption getStepsOption(ExecCaseWizardStepEnum _enum, String status) {
        StepsOption stepsOption0 = new StepsOption();
        stepsOption0.setTitle(new LocaleString(_enum.getName()));
        stepsOption0.setDescription(new LocaleString(""));
        stepsOption0.setStatus(status);
        return stepsOption0;
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            String itemKey;
            super.itemClick(evt);
            switch (itemKey = evt.getItemKey()) {
                case "btn_down": {
                    this.btnDown();
                    break;
                }
                case "btn_up": {
                    this.btnUp();
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"type"});
                    break;
                }
                case "updaterule": {
                    this.updateRule();
                    break;
                }
                case "select_rule": {
                    LambdaUtils.run(() -> {
                        ListShowParameter showParameter = new ListShowParameter();
                        showParameter.setFormId("bos_listf7");
                        showParameter.setBillFormId("eb_bizruleset");
                        showParameter.setLookUp(true);
                        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_rule"));
                        StyleCss styleCss = new StyleCss();
                        styleCss.setWidth("950");
                        styleCss.setHeight("600");
                        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
                        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
                        qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
                        qFilterList.add(new QFilter("bizctrlrange", "=", (Object)this.getBizModelId()));
                        Boolean allowDisable = (Boolean)this.getModel().getValue(ALLOW_DISABLE);
                        if (!allowDisable.booleanValue()) {
                            qFilterList.add(new QFilter("status", "=", (Object)true));
                        }
                        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "createdate desc"));
                        showParameter.setShowTitle(false);
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c4\u5219", (String)"ExecuteRuleCasePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.getView().showForm((FormShowParameter)showParameter);
                    });
                    break;
                }
                case "topologygraph": {
                    LambdaUtils.run(() -> {
                        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(SELECTRULEENTITY);
                        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
                            return;
                        }
                        Set graphRuleIdLongSet = dynamicObjectCollection.stream().map(item -> item.getLong("rulename_id")).collect(Collectors.toSet());
                        MutableGraph graph = RuleGraphService.getInstance().getDagGraphByBizmodel(this.getBizModelId().longValue());
                        graph = Graphs.copyOf((Graph)graph);
                        for (GraphNode graphNode : new HashSet(graph.nodes())) {
                            if (graphRuleIdLongSet.contains(graphNode.getNodeId())) continue;
                            graph.removeNode((Object)graphNode);
                        }
                        List edgePojoList = graph.edges().stream().map(item -> new EdgePojo().setFromString(ObjUtils.getString((Object)((GraphNode)item.source()).getNodeId())).setToString(ObjUtils.getString((Object)((GraphNode)item.target()).getNodeId()))).collect(Collectors.toList());
                        RuleExecContext ruleExecContext = new RuleExecContext();
                        ruleExecContext.setModelIdLong(this.getModelId());
                        ruleExecContext.setBusinessModelIdLong(this.getBizModelId());
                        ruleExecContext.setGraphRuleIdLongSet(graphRuleIdLongSet);
                        ruleExecContext.setGraphEdgePojoList(edgePojoList);
                        List ruleManageRowPojoList = RuleManageQueryOp.getRuleManageRowPojoList((Collection)ruleExecContext.getGraphRuleIdLongSet());
                        Map<String, RuleManageRowPojo> ruleManageRowPojoMap = ruleManageRowPojoList.stream().collect(Collectors.toMap(item -> item.getIdString(), item -> item));
                        RelationGraphDataPojo relationGraphDataPojo = RuleExecGraphUtils.getRelationGraphDataPojo((Set)ruleExecContext.getGraphRuleIdLongSet(), (List)ruleExecContext.getGraphEdgePojoList());
                        List relationGraphDataTrackingItemPojoList = RuleExecGraphUtils.getRelationGraphDataTrackingItemPojoList(ruleManageRowPojoMap, (RelationGraphDataPojo)relationGraphDataPojo);
                        ruleExecContext.setRelationGraphDataTrackingItemPojoList(relationGraphDataTrackingItemPojoList);
                        RelationGraphModelPojo relationGraphModelPojo = new RelationGraphModelPojo().setRelationGraphDataPojo(relationGraphDataPojo);
                        relationGraphModelPojo.setClickToExpandBoolean(Boolean.valueOf(false));
                        relationGraphModelPojo.setDisableContextmenuBoolean(Boolean.valueOf(true));
                        relationGraphModelPojo.setEnableCloseNodeBoolean(Boolean.valueOf(false));
                        relationGraphModelPojo.setCustomParamMap(MapPlusUtils.getStringMap((String[])new String[]{RuleExecContext.class.getName(), JsonUtils.getJsonString((Object)ruleExecContext)}));
                        relationGraphModelPojo.setFocusNodeIdString(ObjUtils.getString((Object)this.getFocusRuleIdLong(dynamicObjectCollection)));
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)relationGraphModelPojo.getFocusNodeIdString()) && graphRuleIdLongSet.size() > 10) {
                            relationGraphModelPojo.setFocusNodeIdString(ObjUtils.getString((Object)((DynamicObject)dynamicObjectCollection.get(0)).getLong("rulename_id")));
                        }
                        RelationGraphUtils.checkAndReorganize((RelationGraphModelPojo)relationGraphModelPojo);
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)relationGraphModelPojo.getFocusNodeIdString())) {
                            RelationGraphNodePojo relationGraphNodePojo = relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().stream().filter(item -> !"DEFAULT_ROOT_NODE_ID_STRING".equals(item.getIdString())).min(Comparator.comparingInt(item -> item.getXaxisInteger() + item.getYaxisInteger())).get();
                            relationGraphModelPojo.setFocusNodeIdString(relationGraphNodePojo.getIdString());
                        }
                        RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)LambdaUtils.getTarget((List)ruleManageRowPojoList, item -> item.getIdString().equals(relationGraphModelPojo.getFocusNodeIdString()));
                        String keyString = ((FormulaPojo)ruleManageRowPojo.getFormulaPojoList().get(0)).getKeyString();
                        RelationGraphDataTrackingItemPojo relationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)relationGraphDataTrackingItemPojoList, item -> {
                            if (!RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString())) {
                                return false;
                            }
                            if (!ruleManageRowPojo.getIdString().equals(item.getCurrentNodeIdString())) {
                                return false;
                            }
                            return item.getKeyString().equals(keyString);
                        });
                        RelationGraphUtils.updateRelationGraphModelPojoInfoHtmlString((RelationGraphModelPojo)relationGraphModelPojo, (String)relationGraphDataTrackingItemPojo.getInfoHtmlString());
                        relationGraphModelPojo.setFocusNodeIdString(relationGraphDataTrackingItemPojo.getCurrentNodeIdString());
                        relationGraphModelPojo.setFocusCellIdString(relationGraphDataTrackingItemPojo.getCurrentCellIdString());
                        RuleExecGraphUtils.openRelationGraph((IFormView)this.getView(), (RelationGraphModelPojo)relationGraphModelPojo, (Boolean)true);
                    });
                    break;
                }
                case "reset": {
                    EntryGrid entry = (EntryGrid)this.getControl(SELECTRULEENTITY);
                    int rowIndex = entry.getEntryState().getFocusRow();
                    if (rowIndex < 0) {
                        return;
                    }
                    this.getModel().setValue("rangejson", (Object)"", rowIndex);
                    this.proChangeRuleNamesToRuleRangeEntity();
                    break;
                }
                case "collect": {
                    this.collect();
                    break;
                }
                case "import": {
                    this.btnImport();
                    break;
                }
                case "select_template": {
                    this.selectTemplate();
                    break;
                }
                case "relation_sort": {
                    this.relationSort();
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#itemClick", (Throwable)e);
        }
    }

    private void relationSort() {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection dynamicObjectCollection = dataModel.getEntryEntity(SELECTRULEENTITY);
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c4\u5219", (String)"ExecuteRuleCasePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Set existRuleSet = dynamicObjectCollection.stream().map(e -> e.getLong("rulename_id")).collect(Collectors.toSet());
        List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fnumber", "fstatus"}).whereIn("fid", existRuleSet).toRowList();
        if (CollectionUtils.isEmpty((Collection)ebBizrulesetList) || ebBizrulesetList.stream().noneMatch(e -> e.getStatusString().equals("1"))) {
            return;
        }
        Set unReleaseRuleSet = ebBizrulesetList.stream().filter(e -> e.getStatusString().equals("0")).map(EbBizruleset::getIdLong).collect(Collectors.toSet());
        List<Long> allUnReleaseRules = dynamicObjectCollection.stream().map(e -> e.getLong("rulename_id")).filter(unReleaseRuleSet::contains).collect(Collectors.toList());
        Set<Long> findRelationRuleSet = ebBizrulesetList.stream().filter(e -> e.getStatusString().equals("1")).map(EbBizruleset::getIdLong).collect(Collectors.toSet());
        Map<Long, List<Long>> grpExistReleaseRuleIdMap = dynamicObjectCollection.stream().map(e -> e.getLong("rulename_id")).filter(findRelationRuleSet::contains).collect(Collectors.groupingBy(k -> k));
        this.handleRelationSortedNodeIds(Collections.emptySet(), dataModel, findRelationRuleSet, allUnReleaseRules, grpExistReleaseRuleIdMap);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6309\u4f9d\u8d56\u6392\u5e8f\u6210\u529f", (String)"RuleCase_73", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void selectTemplate() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId("eb_templateentity");
        showParameter.setLookUp(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_TEMPLATE));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("950");
        styleCss.setHeight("600");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        Long modelId = this.getModelId();
        qFilterList.add(new QFilter("model", "=", (Object)modelId));
        qFilterList.add(new QFilter("dataset", "in", (Object)DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(this.getBizModelId())));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "createtime desc"));
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f", (String)"ExecuteRuleCasePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public Long getFocusRuleIdLong(DynamicObjectCollection dynamicObjectCollection) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(SELECTRULEENTITY);
        int[] selectRowIndexIntArray = entryGrid.getSelectRows();
        if (ArrayUtils.isEmpty((int[])selectRowIndexIntArray)) {
            return null;
        }
        return ((DynamicObject)dynamicObjectCollection.get(selectRowIndexIntArray[0])).getLong("rulename_id");
    }

    private void collect() {
        ExecuteVo currRule = this.getCurrRule();
        if (currRule == null) {
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("eb_executecaserange");
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("businessmodel", (Object)this.getBizModelId());
        LinkedList<FormulaCondition> newConditionList = new LinkedList<FormulaCondition>();
        Map memberListMap = currRule.getMemberListMap();
        memberListMap.forEach((k, v) -> {
            FormulaCondition formulaCondition = new FormulaCondition();
            formulaCondition.setDimensionNumber(k);
            formulaCondition.setMemberList(ExecuteRuleUtils.rebuildConditonList2((List)v, (String)k));
            newConditionList.add(formulaCondition);
        });
        List conditionList = currRule.getConditionList();
        for (FormulaCondition formulaCondition : conditionList) {
            if (memberListMap.containsKey(formulaCondition.getDimensionNumber())) continue;
            newConditionList.add(formulaCondition);
        }
        param.setCustomParam("scope", (Object)RuleManageJsonUtil.writeValueAsString(newConditionList));
        this.getView().showForm(param);
    }

    private void btnImport() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("eb_executecaserangeselect");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("businessmodel", (Object)this.getBizModelId());
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnImport"));
        this.getView().showForm(param);
    }

    private void btnUp() {
        ExecCaseWizardStepEnum currStep = this.getCurrStep();
        ExecCaseWizardStepEnum beforeStep = ExecCaseWizardStepEnum.getBeforeStep((ExecCaseWizardStepEnum)currStep);
        if (beforeStep == null) {
            return;
        }
        this.getModel().setValue("currStep", (Object)beforeStep.getNumber());
        this.setCurrWizardStep(beforeStep.getSeq());
        this.setPageVisible();
        this.setToolbarVisible();
        this.getModel().deleteEntryData(RULERANGEENTITY);
    }

    private void btnDown() {
        ExecCaseWizardStepEnum nextStep;
        ExecCaseWizardStepEnum currStep = this.getCurrStep();
        if (!this.checkCardPage(currStep)) {
            return;
        }
        if (ExecCaseWizardStepEnum.Establish == currStep) {
            String type = (String)this.getModel().getValue("type");
            nextStep = "1".equals(type) ? ExecCaseWizardStepEnum.Rule : ExecCaseWizardStepEnum.Range;
        } else if (ExecCaseWizardStepEnum.Range == currStep) {
            nextStep = ExecCaseWizardStepEnum.Generate;
        } else {
            return;
        }
        this.getModel().setValue("currStep", (Object)nextStep.getNumber());
        this.setCurrWizardStep(nextStep.getSeq());
        this.setPageVisible();
        this.setToolbarVisible();
        if (nextStep == ExecCaseWizardStepEnum.Range) {
            Long dataSetId = this.getDataSetId();
            if (IDUtils.isEmptyLong((Long)dataSetId).booleanValue()) {
                if (this.getModel().getEntryRowCount(RANGEENTITY) == 0) {
                    this.getModel().beginInit();
                    this.getModel().batchCreateNewEntryRow(RANGEENTITY, 1);
                    DynamicObject rangeentity = this.getModel().getEntryRowEntity(RANGEENTITY, 0);
                    rangeentity.set("dimname", (Object)ResManager.loadResFormat((String)"%1\uff08\u5fc5\u586b\uff09", (String)"RuleCase_15", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Account.getChineseName()}));
                    rangeentity.set("dimnumber", (Object)SysDimensionEnum.Account.getNumber());
                    rangeentity.set("view", null);
                    this.getModel().endInit();
                }
            } else {
                this.reBuildRangeEntityIfChange(dataSetId);
                this.rebuildRangeEntityMembersAndSize();
            }
            this.getView().updateView(RANGEENTITY);
        } else if (nextStep == ExecCaseWizardStepEnum.Generate) {
            this.getModel().setValue("updatestatus", (Object)CaseUpdateStatusEnum.UPDATE_ING.getCode());
            this.getModel().deleteEntryData(SELECTRULEENTITY);
            this.getView().getControl("toolbarap1");
            Toolbar bar = (Toolbar)this.getView().getControl("toolbarap1");
            bar.addItemClickListener((ItemClickListener)this);
            this.addItemClickListeners(new String[]{"toolbarap1"});
            bar.itemClick("btn_save", "save");
            this.dispatherUpdateRule();
        }
    }

    private void dispatherUpdateRule() {
        Object id = this.getModel().getValue("id");
        if (id == null || IDUtils.isEmptyLong((Long)((Long)id)).booleanValue()) {
            this.getModel().setValue("updatestatus", (Object)CaseUpdateStatusEnum.STAGING.getCode());
            return;
        }
        RuleExecGenCaseRequest request = new RuleExecGenCaseRequest(this.getModelId(), this.getBizModelId(), this.getDataSetId());
        HashMap<String, Object> ranges = new HashMap<String, Object>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RANGEENTITY);
        for (DynamicObject doj : entryEntity) {
            String memberjson = doj.getString("memberjson");
            if (!StringUtils.isNotEmpty((String)memberjson)) continue;
            ranges.put(doj.getString("dimnumber"), JsonUtils.readValue((String)memberjson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }
        request.setRanges(ranges);
        request.setCaseId((Long)id);
        RuleExecGenCaseController.getInstance().dispatchTask(request, this.getView(), (AbstractFormPlugin)this);
    }

    private void reBuildRangeEntityIfChange(Long dataSetId) {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        List dimensionList = modelCache.getDimensionList(dataSetId);
        DynamicObjectCollection rangeEntity = this.getModel().getEntryEntity(RANGEENTITY);
        if (dimensionList.size() != rangeEntity.size()) {
            this.reBuildRangeEntity(dataSetId);
        }
    }

    private void reBuildRangeEntity(Long dataSetId) {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        List dimensionList = modelCache.getDimensionList(dataSetId);
        DynamicObjectCollection rangeEntity = this.getModel().getEntryEntity(RANGEENTITY);
        Map<String, DynamicObject> entityMap = rangeEntity.stream().collect(Collectors.toMap(k -> k.getString("dimnumber"), v -> v));
        this.getModel().deleteEntryData(RANGEENTITY);
        this.getModel().batchCreateNewEntryRow(RANGEENTITY, dimensionList.size());
        dimensionList = dimensionList.stream().sorted(Comparator.comparing(s -> !s.getNumber().equals("Account"))).collect(Collectors.toList());
        4 map = new /* Unavailable Anonymous Inner Class!! */;
        for (int i = 0; i < dimensionList.size(); ++i) {
            Dimension dimension = (Dimension)dimensionList.get(i);
            DynamicObject doj = entityMap.get(dimension.getNumber());
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(RANGEENTITY, i);
            if (map.containsKey(dimension.getNumber())) {
                entryRowEntity.set("dimname", (Object)ResManager.loadResFormat((String)"%1\uff08\u5fc5\u586b\uff09", (String)"RuleCase_15", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
            } else {
                entryRowEntity.set("dimname", (Object)dimension.getName());
            }
            entryRowEntity.set("dimnumber", (Object)dimension.getNumber());
            if (doj == null) continue;
            entryRowEntity.set("members", (Object)doj.getString("members"));
            entryRowEntity.set("membercount", (Object)doj.getString("membercount"));
            entryRowEntity.set("memberjson", (Object)doj.getString("memberjson"));
            entryRowEntity.set("view", (Object)doj.getDynamicObject("view"));
        }
    }

    private void rebuildRangeEntityMembersAndSize() {
        DynamicObjectCollection rangeEntity = this.getModel().getEntryEntity(RANGEENTITY);
        if (rangeEntity.isEmpty()) {
            return;
        }
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
        Map varValues = ReportVarUtil.getVarValuesByRule((Integer)ProcessTypeEnum.RULE.getIndex(), (Long)this.getModelId());
        boolean hasAgg = rangeEntity.stream().anyMatch(e -> {
            String memberjson = e.getString("memberjson");
            if (StringUtils.isNotEmpty((String)memberjson)) {
                String dimNumber = e.getString("dimnumber");
                if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                    List memberList = (List)JsonUtils.readValue((String)memberjson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    return memberList.stream().allMatch(mem -> modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, mem.getNumber()).hasAgg());
                }
            }
            return false;
        });
        for (DynamicObject doj : rangeEntity) {
            String memberjson = doj.getString("memberjson");
            if (!StringUtils.isNotEmpty((String)memberjson)) continue;
            String dimNumber = doj.getString("dimnumber");
            Dimension dimension = modelCache.getDimension(dimNumber);
            List memberList = (List)JsonUtils.readValue((String)memberjson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.setRangeMemberCount(modelCache, memberPropCache, varValues, doj, dimension, memberList, hasAgg);
        }
        this.getView().updateView(RANGEENTITY);
    }

    private void setRangeMemberCount(IModelCacheHelper modelCache, MemberPropCache memberPropCache, Map<String, Map<String, Set<String>>> varValues, DynamicObject doj, Dimension dimension, List<MemberCondition> memberList, boolean hasAgg) {
        String members = ExecuteRuleUtils.buildMemberConditionString2(memberList);
        doj.set("members", (Object)members);
        ArrayList<MemberCondition> memberList2 = new ArrayList<MemberCondition>(16);
        for (MemberCondition memberCondition : memberList) {
            MemberCondition memberCondition2 = new MemberCondition(memberCondition.getNumber(), memberCondition.getName(), memberCondition.getRelation(), memberCondition.getRange());
            memberCondition2.setProp(memberCondition.isProp());
            memberCondition2.setLongnumber(memberCondition.getLongnumber());
            memberCondition2.setViewId(memberCondition.getViewId());
            memberCondition2.setRange(Convert.toStr((Object)RangeEnum.ALL_DETAIL_INCLUDE.getIndex()));
            memberList2.add(memberCondition2);
        }
        int size = ExecuteRuleUtils.calcConditionRange2((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, varValues, (Dimension)dimension, memberList2, null, (boolean)hasAgg);
        doj.set("membercount", (Object)size);
    }

    private void rebuildSelectRuleEntity() {
        DynamicObjectCollection selectRuleEntity = this.getModel().getEntryEntity(SELECTRULEENTITY);
        if (selectRuleEntity.isEmpty()) {
            return;
        }
        Iterator iterator = selectRuleEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject doj = (DynamicObject)iterator.next();
            DynamicObject rule = doj.getDynamicObject("rulename");
            if (rule != null) {
                DynamicObject dbObj = this.queryData(rule);
                doj.set("rulenumber", (Object)dbObj.getString("number"));
                doj.set("rulestatus", (Object)dbObj.getBoolean("status"));
                doj.set("ruleop", (Object)ResManager.loadKDString((String)"\u8ba1\u7b97\u8868\u8fbe\u5f0f", (String)"RuleCase_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            iterator.remove();
        }
        this.getView().updateView(SELECTRULEENTITY);
    }

    private DynamicObject queryData(DynamicObject rule) {
        return QueryServiceHelper.queryOne((String)"eb_bizruleset", (String)"number,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rule.getLong("id"))});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        try {
            super.beforeClosed(e);
            this.getModel().deleteEntryData(RULERANGEENTITY);
            RuleExecCaseEditPlugin.setBizChanged(this.getModel().getDataEntity(), Lists.newArrayList((Object[])new String[]{"currstep", "updatedetail"}));
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#beforeClosed", (Throwable)ex);
        }
    }

    public static void setBizChanged(DynamicObject dataEntity, List<String> propKeys) {
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String propKey : propKeys) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
            if (property == null) continue;
            dataEntityState.setBizChanged(property.getOrdinal(), false);
            if (!(property instanceof BasedataProp)) continue;
            property = (IDataEntityProperty)properties.get((Object)(propKey + "_id"));
            Optional.ofNullable(property).ifPresent(p -> dataEntityState.setBizChanged(p.getOrdinal(), false));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        try {
            super.closedCallBack(closedCallBackEvent);
            String actionId = closedCallBackEvent.getActionId();
            if ("clickMembers".equals(actionId)) {
                this.clickMembersBack(closedCallBackEvent.getReturnData());
            } else if ("clickRuleMembers".equals(actionId)) {
                this.clickRuleMembersBack(closedCallBackEvent.getReturnData());
            } else if ("btnImport".equals(actionId)) {
                this.btnImportBack(closedCallBackEvent.getReturnData());
            } else if ("genCase".equals(actionId)) {
                this.getModel().setValue("updatestatus", (Object)CaseUpdateStatusEnum.UPDATE_END.getCode());
                this.genCaseBack(closedCallBackEvent.getReturnData());
            } else if ("select_rule".equals(actionId) && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                LambdaUtils.run(() -> {
                    ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                    Set selectedRuleIdLongSet = returnData.stream().map(e -> IDUtils.toLong((Object)e.getPrimaryKeyValue())).collect(Collectors.toCollection(Sets::newLinkedHashSet));
                    this.handleRelationSortedNodeIds(selectedRuleIdLongSet);
                });
            } else if (SELECT_TEMPLATE.equals(actionId) && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                List selectedTemplateIdLongList = returnData.stream().map(e -> IDUtils.toLong((Object)e.getPrimaryKeyValue())).collect(Collectors.toList());
                Set selectedRuleIdLongSet = RuleService.getInstance().getDirectRuleByTempIdList(selectedTemplateIdLongList);
                if (CollectionUtils.isEmpty((Collection)selectedRuleIdLongSet)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u6a21\u677f\u672a\u5173\u8054\u4efb\u4f55\u89c4\u5219", (String)"RuleCase_75", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.handleRelationSortedNodeIds(selectedRuleIdLongSet);
            }
        }
        catch (Exception e2) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#closedCallBack", (Throwable)e2);
        }
    }

    private void handleRelationSortedNodeIds(Set<Long> selectedRuleIdLongSet) {
        if (CollectionUtils.isEmpty(selectedRuleIdLongSet)) {
            return;
        }
        List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fnumber", "fstatus"}).whereIn("fid", selectedRuleIdLongSet).toRowList();
        if (CollectionUtils.isEmpty((Collection)ebBizrulesetList)) {
            return;
        }
        Set<Long> releaseRuleSet = ebBizrulesetList.stream().filter(e -> e.getStatusString().equals("1")).map(EbBizruleset::getIdLong).collect(Collectors.toSet());
        Set unReleaseRuleSet = ebBizrulesetList.stream().filter(e -> e.getStatusString().equals("0")).map(EbBizruleset::getIdLong).collect(Collectors.toSet());
        List selUnReleaseRules = selectedRuleIdLongSet.stream().filter(unReleaseRuleSet::contains).collect(Collectors.toList());
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection dynamicObjectCollection = dataModel.getEntryEntity(SELECTRULEENTITY);
        HashSet<Long> findRelationRuleSet = new HashSet<Long>(16);
        ArrayList<Long> allUnReleaseRules = new ArrayList<Long>(16);
        Map<Long, List<Long>> grpExistReleaseRuleIdMap = new HashMap<Long, List<Long>>(16);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            Set existRuleSet = dynamicObjectCollection.stream().map(e -> e.getLong("rulename_id")).collect(Collectors.toSet());
            List _ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fnumber", "fstatus"}).whereIn("fid", existRuleSet).toRowList();
            if (CollectionUtils.isNotEmpty((Collection)_ebBizrulesetList)) {
                Set _releaseRuleSet = _ebBizrulesetList.stream().filter(e -> e.getStatusString().equals("1")).map(EbBizruleset::getIdLong).collect(Collectors.toSet());
                Set _unReleaseRuleSet = _ebBizrulesetList.stream().filter(e -> e.getStatusString().equals("0")).map(EbBizruleset::getIdLong).collect(Collectors.toSet());
                allUnReleaseRules.addAll(dynamicObjectCollection.stream().map(e -> e.getLong("rulename_id")).filter(_unReleaseRuleSet::contains).collect(Collectors.toList()));
                findRelationRuleSet.addAll(dynamicObjectCollection.stream().map(e -> e.getLong("rulename_id")).filter(_releaseRuleSet::contains).collect(Collectors.toSet()));
                grpExistReleaseRuleIdMap = dynamicObjectCollection.stream().map(e -> e.getLong("rulename_id")).filter(_releaseRuleSet::contains).collect(Collectors.groupingBy(k -> k));
            }
        }
        allUnReleaseRules.addAll(selUnReleaseRules);
        findRelationRuleSet.addAll(releaseRuleSet);
        this.handleRelationSortedNodeIds(releaseRuleSet, dataModel, findRelationRuleSet, allUnReleaseRules, grpExistReleaseRuleIdMap);
    }

    private void handleRelationSortedNodeIds(Set<Long> releaseRuleSet, IDataModel dataModel, Set<Long> findRelationRuleSet, List<Long> allUnReleaseRules, Map<Long, List<Long>> grpExistReleaseRuleIdMap) {
        ArrayList<Long> allRules = new ArrayList<Long>(16);
        allRules.addAll(allUnReleaseRules);
        if (CollectionUtils.isNotEmpty(findRelationRuleSet)) {
            List allEnableRuleDto = RuleCacheService.getInstance().listRuleFromLocalCache(this.getBizModelId()).getRuleDtoList();
            MutableGraph graph = RuleGraphService.getInstance().getDagGraphByBizmodel(allEnableRuleDto);
            List relationSortedNodeIds = RuleCaseService.getInstance().getRelationSortedNodeIds(findRelationRuleSet, findRelationRuleSet, graph);
            ArrayList<Long> allReleaseRelationRules = new ArrayList<Long>(16);
            for (Long relationSortedNodeId : relationSortedNodeIds) {
                boolean existSelRule;
                boolean existCase = grpExistReleaseRuleIdMap.containsKey(relationSortedNodeId);
                if (existCase) {
                    allReleaseRelationRules.addAll((Collection)grpExistReleaseRuleIdMap.get(relationSortedNodeId));
                }
                if (existSelRule = releaseRuleSet.contains(relationSortedNodeId)) {
                    allReleaseRelationRules.add(relationSortedNodeId);
                }
                if (existCase || existSelRule) continue;
                allReleaseRelationRules.add(relationSortedNodeId);
            }
            allRules.addAll(allReleaseRelationRules);
        }
        List allEbBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fnumber", "fstatus"}).whereIn("fid", new HashSet(allRules)).toRowList();
        Map<Long, EbBizruleset> ruleMap = allEbBizrulesetList.stream().collect(Collectors.toMap(EbBizruleset::getIdLong, v -> v, (v1, v2) -> v1));
        dataModel.deleteEntryData(SELECTRULEENTITY);
        dataModel.beginInit();
        int[] indexIntArray = dataModel.batchCreateNewEntryRow(SELECTRULEENTITY, allRules.size());
        int sizeInt = allRules.size();
        for (int i = 0; i < sizeInt; ++i) {
            Long ruleId = (Long)allRules.get(i);
            EbBizruleset ebBizruleset = ruleMap.get(ruleId);
            int indexInt = indexIntArray[i];
            dataModel.setValue("rulename", (Object)ebBizruleset.getIdLong(), indexInt);
            dataModel.setValue("rulenumber", (Object)ebBizruleset.getNumberString(), indexInt);
            dataModel.setValue("rulestatus", (Object)EbBizrulesetStatusEnum.ENABLE.getDbStatusString().equals(ebBizruleset.getStatusString()), indexInt);
        }
        dataModel.endInit();
        this.getView().updateView(SELECTRULEENTITY);
    }

    private void genCaseBack(Object returnData) {
        if (returnData == null) {
            this.getModel().setDataChanged(false);
            this.getView().close();
            return;
        }
        Map returnMap = (Map)returnData;
        Map taskInfo = (Map)SerializationUtils.fromJsonString((String)((String)returnMap.get("taskinfo")), HashMap.class);
        if (taskInfo == null) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)((String)taskInfo.get("data")), HashMap.class);
        if (data == null) {
            return;
        }
        String status = (String)data.get("status");
        String result = (String)data.get("result");
        if (!"true".equals(status)) {
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u89c4\u5219\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u8be2\u540e\u53f0\u65e5\u5fd7\uff1a%1\u3002", (String)"RuleCase_16", (String)"epm-eb-formplugin", (Object[])new Object[]{result}));
        }
        this.getView().getControl("toolbarap1");
        Toolbar bar = (Toolbar)this.getView().getControl("toolbarap1");
        bar.addItemClickListener((ItemClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap1"});
        bar.itemClick("refresh", "refresh");
        this.getModel().setDataChanged(false);
    }

    private void btnImportBack(Object returnData) {
        if (!(returnData instanceof Long) || !QueryServiceHelper.exists((String)"eb_executecaserange", (Object)returnData)) {
            return;
        }
        DynamicObject executeCaseDoj = BusinessDataServiceHelper.loadSingle((Object)returnData, (String)"eb_executecaserange", (String)"scope");
        String scope = executeCaseDoj.getString("scope");
        List conditions = RuleManageJsonUtil.getConditions2((String)scope);
        ExecuteVo executeVo = this.getCurrRule();
        if (executeVo == null) {
            return;
        }
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        Map dimensionMap = modelCache.getDimensionMap(executeVo.ruleDataSetId());
        Long mainDimensionId = executeVo.getRuleDto().getMainDimensionId();
        Dimension mainDimension = modelCache.getDimension(mainDimensionId);
        Map memberListMap = executeVo.getMemberListMap();
        Map leftMembers = executeVo.getRuleDto().getLeftMembers();
        for (FormulaCondition condition : conditions) {
            String dimensionNumber = condition.getDimensionNumber();
            if (!dimensionMap.containsKey(dimensionNumber) || memberListMap.containsKey(dimensionNumber) || mainDimension.getNumber().equals(dimensionNumber) || leftMembers.containsKey(dimensionNumber)) continue;
            memberListMap.put(dimensionNumber, ExecuteRuleUtils.rebuildConditonList((List)condition.getMemberList(), (String)dimensionNumber));
        }
        this.getModel().setValue("rangejson", (Object)JsonUtils.getJsonString((Object)memberListMap), executeVo.getRowIndex());
        this.proChangeRuleNamesToRuleRangeEntity();
    }

    public void clickMembersBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection dyObjs = (DynamicObjectCollection)returnData;
        if (dyObjs.isEmpty()) {
            return;
        }
        EntryGrid entry = (EntryGrid)this.getControl(RANGEENTITY);
        int rowIndex = entry.getEntryState().getFocusRow();
        String dimNumber = (String)this.getModel().getValue("dimnumber", rowIndex);
        Long datasetId = null;
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            Set dataSetIdLongSet = dyObjs.stream().map(doj -> modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, doj.getString("number")).getDatasetId()).collect(Collectors.toSet());
            if (dataSetIdLongSet.size() == 1) {
                datasetId = (Long)dataSetIdLongSet.iterator().next();
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u8303\u56f4\u4e2d\u201c\u79d1\u76ee\u201d\u7684\u6240\u6709\u6210\u5458\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u4e2a\u6570\u636e\u96c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleCase_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        ArrayList<MemberCondition> memberList = new ArrayList<MemberCondition>(dyObjs.size());
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
        Map varValues = ReportVarUtil.getVarValuesByRule((Integer)ProcessTypeEnum.RULE.getIndex(), (Long)this.getModelId());
        for (DynamicObject dyObj : dyObjs) {
            String name = dyObj.getString("name");
            String number = dyObj.getString("number");
            String range = dyObj.getString("scope");
            Long viewId = dyObj.getLong("viewid");
            MemberCondition memberCondition = new MemberCondition(number, name, "", range);
            memberCondition.setViewId(IDUtils.toString((Object)viewId));
            String typeString = dyObj.getString("type");
            if (RangeF7PropertyCataEnum.Property.getIndex().equals(typeString)) {
                memberCondition.setProp(true);
                CustomPropertyValue customPropertyValue = memberPropCache.getPropertyValue(Long.valueOf(dyObj.getLong("mid")));
                memberCondition.setLongnumber(customPropertyValue.getProp().getNumber() + "!" + customPropertyValue.getNumber());
            }
            memberList.add(memberCondition);
        }
        Dimension dimension = modelCache.getDimension(dimNumber);
        this.getModel().setValue("memberjson", (Object)JsonUtils.getJsonString(memberList), rowIndex);
        this.getModel().setValue("view", (Object)((DynamicObject)dyObjs.get(0)).getLong("viewid"), rowIndex);
        DynamicObjectCollection rangeEntity = this.getModel().getEntryEntity(RANGEENTITY);
        DynamicObject doj2 = (DynamicObject)rangeEntity.get(rowIndex);
        boolean hasAgg = rangeEntity.stream().anyMatch(e -> {
            String memberjson = e.getString("memberjson");
            if (StringUtils.isNotEmpty((String)memberjson)) {
                String dim = e.getString("dimnumber");
                if (SysDimensionEnum.Metric.getNumber().equals(dim)) {
                    List members = (List)JsonUtils.readValue((String)memberjson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    return members.stream().allMatch(mem -> modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, mem.getNumber()).hasAgg());
                }
            }
            return false;
        });
        this.setRangeMemberCount(modelCache, memberPropCache, varValues, doj2, dimension, memberList, hasAgg);
        if (datasetId != null) {
            this.getModel().setValue("dataset", (Object)datasetId);
        }
        this.getView().updateView(RANGEENTITY);
    }

    public void clickRuleMembersBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection dyObjs = (DynamicObjectCollection)returnData;
        if (dyObjs.isEmpty()) {
            return;
        }
        EntryGrid entry = (EntryGrid)this.getControl(RULERANGEENTITY);
        int rowIndex = entry.getEntryState().getFocusRow();
        String dimNumber = (String)this.getModel().getValue("ruledimnumber", rowIndex);
        ArrayList<MemberCondition> memberList = new ArrayList<MemberCondition>(dyObjs.size());
        StringBuilder sb = new StringBuilder();
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
        Map varValues = ReportVarUtil.getVarValuesByRule((Integer)ProcessTypeEnum.RULE.getIndex(), (Long)this.getModelId());
        for (DynamicObject dyObj : dyObjs) {
            String name = dyObj.getString("name");
            String number = dyObj.getString("number");
            String range = dyObj.getString("scope");
            Long viewId = dyObj.getLong("viewid");
            Long id = dyObj.getLong("id");
            MemberCondition memberCondition = new MemberCondition(number, name, "", range);
            memberCondition.setViewId(IDUtils.toString((Object)viewId));
            memberCondition.setId(IDUtils.toString((Object)id));
            String typeString = dyObj.getString("type");
            if (RangeF7PropertyCataEnum.Property.getIndex().equals(typeString)) {
                memberCondition.setProp(true);
                CustomPropertyValue customPropertyValue = memberPropCache.getPropertyValue(Long.valueOf(dyObj.getLong("mid")));
                memberCondition.setLongnumber(customPropertyValue.getProp().getNumber() + "!" + customPropertyValue.getNumber());
            }
            memberList.add(memberCondition);
            sb.append(memberCondition).append(",");
        }
        sb.setLength(sb.length() - 1);
        String memberShow = sb.toString();
        this.getModel().setValue("rulemembers", (Object)memberShow, rowIndex);
        Dimension dimension = modelCache.getDimension(dimNumber);
        ExecuteVo executeVo = this.getCurrRule();
        if (executeVo != null) {
            RuleDto ruleDto = executeVo.getRuleDto();
            String metNumber = (String)((Set)ruleDto.getLeftMembers().get(SysDimensionEnum.Metric.getNumber())).iterator().next();
            Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metNumber);
            int size = ExecuteRuleUtils.calcConditionRange2((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Map)varValues, (Dimension)dimension, memberList, (Set)((Set)ruleDto.getLeftMembers().get(dimension.getNumber())), (boolean)metMember.hasAgg());
            this.getModel().setValue("rulemembercount", (Object)size, rowIndex);
            Map memberListMap = executeVo.getMemberListMap();
            memberListMap.put(dimNumber, memberList);
            this.getModel().setValue("rangejson", (Object)JsonUtils.getJsonString((Object)memberListMap), executeVo.getRowIndex());
        }
        this.putLabelDescartes(this.calcDesCartes());
    }

    private ExecuteVo getCurrRule() {
        EntryGrid entry = (EntryGrid)this.getControl(SELECTRULEENTITY);
        int rowIndex = entry.getEntryState().getFocusRow();
        if (rowIndex == -1) {
            return null;
        }
        DynamicObject ruleDoj = (DynamicObject)this.getModel().getValue("rulename", rowIndex);
        if (ruleDoj == null) {
            return null;
        }
        List executeVoList = RuleCaseService.getInstance().queryExecuteVos((List)Lists.newArrayList((Object[])new Long[]{ruleDoj.getLong("id")}));
        if (executeVoList.size() == 1) {
            ExecuteVo executeVo = (ExecuteVo)executeVoList.get(0);
            executeVo.setRowIndex(rowIndex);
            String rangeJson = (String)this.getModel().getValue("rangejson", rowIndex);
            if (StringUtils.isNotEmpty((String)rangeJson)) {
                Map memberListMap = (Map)JsonUtils.readValue((String)rangeJson, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){});
                executeVo.setMemberListMap(memberListMap);
            }
            executeVo.setRowIndex(rowIndex);
            return executeVo;
        }
        return null;
    }

    private void putLabelDescartes(BigInteger descartes) {
        DecimalFormat decimalFormat = new DecimalFormat("#,####");
        BigInteger max = new BigInteger("100000000000000000000");
        String format = descartes.compareTo(max) > 0 ? ResManager.loadResFormat((String)"\u8d85\u8fc710\u768420\u6b21\u65b9", (String)"RuleCase_18_1", (String)"epm-eb-formplugin", (Object[])new Object[0]) : decimalFormat.format(descartes);
        Label label3 = (Label)this.getControl("label5");
        label3.setText(ResManager.loadResFormat((String)"\u7b1b\u5361\u5c14\u79ef\uff1a %1", (String)"RuleCase_18", (String)"epm-eb-formplugin", (Object[])new Object[]{format}));
    }

    private BigInteger calcDesCartes() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RULERANGEENTITY);
        BigInteger descartes = new BigInteger("1");
        if (entryEntity.isEmpty()) {
            return new BigInteger("0");
        }
        for (DynamicObject doj : entryEntity) {
            int rulemembercount = doj.getInt("rulemembercount");
            descartes = descartes.multiply(new BigInteger(String.valueOf(rulemembercount)));
        }
        return descartes;
    }

    private boolean checkCardPage(ExecCaseWizardStepEnum stepEnum) {
        if (ExecCaseWizardStepEnum.Establish != stepEnum && ExecCaseWizardStepEnum.Rule != stepEnum) {
            if (ExecCaseWizardStepEnum.Range == stepEnum) {
                DynamicObjectCollection rangeEntity = this.getModel().getEntryEntity(RANGEENTITY);
                Map<String, DynamicObject> entityMap = rangeEntity.stream().collect(Collectors.toMap(k -> k.getString("dimnumber"), v -> v));
                HashMap<String, String> map = new HashMap<String, String>(){
                    {
                        this.put(SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Account.getChineseName());
                        this.put(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Entity.getChineseName());
                        this.put(SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.BudgetPeriod.getChineseName());
                        this.put(SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Version.getChineseName());
                        this.put(SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.AuditTrail.getChineseName());
                        this.put(SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.ChangeType.getChineseName());
                        this.put(SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.DataType.getChineseName());
                        this.put(SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.Metric.getChineseName());
                    }
                };
                String collectStr = map.entrySet().stream().filter(entry -> {
                    DynamicObject doj = (DynamicObject)entityMap.get(entry.getKey());
                    return doj == null || doj.getInt("membercount") == 0 || StringUtils.isEmpty((String)doj.getString("memberjson"));
                }).map(entry -> (String)entry.getValue()).collect(Collectors.joining("\uff0c"));
                if (collectStr.length() != 0) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9%1\u6210\u5458\u3002", (String)"RuleCase_19", (String)"epm-eb-formplugin", (Object[])new Object[]{collectStr}));
                    return false;
                }
            } else if (ExecCaseWizardStepEnum.Generate == stepEnum) {
                // empty if block
            }
        }
        return true;
    }

    private ExecCaseWizardStepEnum getCurrStep() {
        String stepNumber = (String)this.getModel().getValue("currStep");
        return ExecCaseWizardStepEnum.getEnumByNumber((String)stepNumber);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            super.beforeDoOperation(args);
            Object source = args.getSource();
            if (source instanceof Save) {
                ExecCaseWizardStepEnum currStep = this.getCurrStep();
                if (!this.checkCardPage(currStep)) {
                    args.setCancel(true);
                    return;
                }
                if (currStep == ExecCaseWizardStepEnum.Range) {
                    this.getModel().setValue("updatestatus", (Object)CaseUpdateStatusEnum.STAGING.getCode());
                } else if (currStep == ExecCaseWizardStepEnum.Rule) {
                    this.getModel().setValue("updatestatus", (Object)CaseUpdateStatusEnum.NONE.getCode());
                }
                Object id = this.getModel().getValue("id");
                QFBuilder qfBuilder = new QFBuilder();
                if (id != null && (Long)id != 0L) {
                    qfBuilder.add("id", "!=", id);
                }
                qfBuilder.add("model", "=", (Object)this.getModelId());
                qfBuilder.add("number", "=", this.getModel().getValue("number"));
                if (QueryServiceHelper.exists((String)"eb_ruleexeccase", (QFilter[])qfBuilder.toArray())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RuleCase_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String type = (String)this.getModel().getValue("type");
                if (RuleExecCaseTypeEnum.RANGE.getCode().equals(type)) {
                    this.getModel().setValue(ALLOW_DISABLE, (Object)false);
                } else {
                    DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(SELECTRULEENTITY);
                    if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
                        Set existRuleSet = dynamicObjectCollection.stream().map(e -> e.getLong("rulename_id")).collect(Collectors.toSet());
                        List ebBizRuleSetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fnumber", "fstatus"}).whereIn("fid", existRuleSet).toRowList();
                        Map<Long, EbBizruleset> ebBizRuleSetMap = ebBizRuleSetList.stream().collect(Collectors.toMap(EbBizruleset::getIdLong, v -> v, (v1, v2) -> v1));
                        for (DynamicObject dynamicObject : dynamicObjectCollection) {
                            String ruleStatus;
                            long ruleId = dynamicObject.getLong("rulename_id");
                            String string = ruleStatus = dynamicObject.getBoolean("rulestatus") ? "1" : "0";
                            if (!ebBizRuleSetMap.containsKey(ruleId) || ebBizRuleSetMap.get(ruleId).getStatusString().equals(ruleStatus)) continue;
                            dynamicObject.set("rulestatus", (Object)ebBizRuleSetMap.get(ruleId).getStatusString().equals("1"));
                        }
                        this.getView().updateView(SELECTRULEENTITY);
                        Boolean allowDisable = (Boolean)this.getModel().getValue(ALLOW_DISABLE);
                        if (!allowDisable.booleanValue() && ebBizRuleSetList.stream().anyMatch(e -> e.getStatusString().equals("0"))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5141\u8bb8\u672a\u53d1\u5e03\u89c4\u5219\u6267\u884c\u5f00\u5173\u201d\u5173\u95ed\u65f6\u6709\u672a\u53d1\u5e03\u7684\u89c4\u5219\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleCase_76", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#beforeDoOperation", (Throwable)e2);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        block15: {
            try {
                super.afterDoOperation(args);
                Object source = args.getSource();
                if (source instanceof Save) {
                    ExecCaseWizardStepEnum currStep;
                    Object id = this.getModel().getValue("id");
                    if (id == null || (Long)id == 0L) {
                        return;
                    }
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.RuleCase.getType(), Lists.newArrayList((Object[])new Object[]{id})});
                    Long modelId = this.getModelId();
                    ArrayList<MemberQuoteDao> memberQuoteDaoList = new ArrayList<MemberQuoteDao>(16);
                    if (this.getModel().getValue("type").equals("2")) {
                        DynamicObjectCollection rangeEntity = this.getModel().getEntryEntity(RANGEENTITY);
                        if (rangeEntity.isEmpty()) {
                            return;
                        }
                        IModelCacheHelper modelCache = this.getIModelCacheHelper();
                        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
                        for (DynamicObject doj : rangeEntity) {
                            String memberjson = doj.getString("memberjson");
                            if (!StringUtils.isNotEmpty((String)memberjson)) continue;
                            String dimNumber = doj.getString("dimnumber");
                            Dimension dimension = modelCache.getDimension(dimNumber);
                            List memberList = (List)JsonUtils.readValue((String)memberjson, (TypeReference)new TypeReference<List<MemberCondition>>(){});
                            for (MemberCondition memberCondition : memberList) {
                                if (memberCondition.isProp()) {
                                    CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNumber, memberCondition.getLongnumber());
                                    if (propertyValue == null) continue;
                                    memberQuoteDaoList.add(new MemberQuoteDao(modelId, this.getBizModelId(), dimension.getId(), propertyValue.getId(), MemberTypeEnum.ATTRIBUTEVALUE, MemberQuoteResourceEnum.RuleCase, (Long)id));
                                    continue;
                                }
                                if (memberCondition.isVariable()) continue;
                                Long viewId = IDUtils.toLong((Object)memberCondition.getViewId());
                                Member member = modelCache.getMember(dimension.getNumber(), viewId, memberCondition.getNumber());
                                if (member == null) continue;
                                MemberQuoteDao memberQuoteDao = new MemberQuoteDao(modelId, this.getBizModelId(), dimension.getId(), member.getId(), MemberQuoteResourceEnum.RuleCase, (Long)id);
                                RuleFunctionUtils.putMemberQuoteViewMap((Long)member.getId(), (Long)viewId, (MemberQuoteDao)memberQuoteDao);
                                memberQuoteDaoList.add(memberQuoteDao);
                            }
                        }
                    } else {
                        DynamicObjectCollection ruleEntity = this.getModel().getEntryEntity(SELECTRULEENTITY);
                        if (ruleEntity.isEmpty()) {
                            return;
                        }
                        for (DynamicObject doj : ruleEntity) {
                            long ruleId = doj.getLong("rulename.id");
                            if (ruleId == 0L) continue;
                            memberQuoteDaoList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(ruleId), MemberTypeEnum.RULE, MemberQuoteResourceEnum.RuleCase, (Long)id));
                        }
                    }
                    if (!memberQuoteDaoList.isEmpty()) {
                        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{memberQuoteDaoList});
                    }
                    if ((currStep = this.getCurrStep()) == ExecCaseWizardStepEnum.Rule) {
                        this.proChangeRuleNamesToRuleRangeEntity();
                    }
                    this.getModel().setDataChanged(false);
                    break block15;
                }
                if (source instanceof DeleteEntry) {
                    this.getModel().deleteEntryData(RULERANGEENTITY);
                }
            }
            catch (Exception e) {
                CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#afterDoOperation", (Throwable)e);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        try {
            super.hyperLinkClick(hyperLinkClickEvent);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(SELECTRULEENTITY, hyperLinkClickEvent.getRowIndex());
            if (dynamicObject == null) {
                return;
            }
            long ruleIdLong = dynamicObject.getLong("rulename_id");
            if (IDUtils.isEmptyLong((Long)ruleIdLong).booleanValue()) {
                return;
            }
            OpenRulePojo openRulePojo = new OpenRulePojo().setReadonlyBoolean(Boolean.valueOf(true));
            openRulePojo.singleRuleIdLong(Long.valueOf(ruleIdLong));
            RuleUtils.openRule(this.getView(), openRulePojo);
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleExecCaseEditPlugin#hyperLinkClick", (Throwable)e);
        }
    }

    public Long getModelId() {
        return (Long)this.getValue("model", "id");
    }

    public Long getBizModelId() {
        return (Long)this.getValue("bizmodel", "id");
    }

    public Long getDataSetId() {
        return (Long)this.getValue("dataset", "id");
    }
}

