/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.command;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.bgmddatalock.v2.IDataLockChecker;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.status.DetailRuleExecStatusEnum;
import kd.epm.eb.common.enums.status.ReportRuleExecStatusEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.report.ruleexec.RuleCaseExecExceptionHelper;
import kd.epm.eb.common.report.ruleexec.exception.RuleCaseExecCancelException;
import kd.epm.eb.common.report.ruleexec.exception.RuleCaseUpdateStatusException;
import kd.epm.eb.common.report.ruleexec.exception.RuleRangeNoLeafException;
import kd.epm.eb.common.report.ruleexec.exception.TooMuchNumberException;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.ruleexec.command.ReportRuleExecCommand;
import kd.epm.eb.formplugin.ruleexec.entity.RuleCase;
import kd.epm.eb.formplugin.ruleexec.entity.RuleExecContext;
import kd.epm.eb.formplugin.ruleexec.entity.RuleRow;
import kd.epm.eb.formplugin.ruleexec.enums.CaseUpdateStatusEnum;
import kd.epm.eb.formplugin.ruleexec.enums.RuleExecCaseTypeEnum;
import kd.epm.eb.formplugin.ruleexec.service.RuleExecLogService;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecuteRuleConfig;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleCacheContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.NumberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.WordExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;
import kd.epm.eb.olap.impl.utils.rule.RuleOptimizeUtil;
import kd.epm.eb.olap.service.CheckRuleSimpleUtils;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.biztemplate.CalcBizTemplate;
import kd.epm.eb.olap.service.enums.CheckResult;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.utils.PageUtil;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Triple;

public class RuleExecCommand
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ReportRuleExecCommand.class);
    protected RuleCase ruleCase;
    protected Long taskLogId;
    protected Long continueLogId;
    protected Boolean releaseRulePushExecution = false;
    private StringBuilder detailLog = new StringBuilder();
    private Set<String> allRefOffsetRule = new HashSet<String>(16);
    private int judgeTime = 0;
    private static final long CHECKRANGE = 1000000L;

    public void setRuleCase(RuleCase ruleCase) {
        this.ruleCase = ruleCase;
    }

    public void setTaskLogId(Long taskLogId) {
        this.taskLogId = taskLogId;
    }

    public void setContinueLogId(Long continueLogId) {
        this.continueLogId = continueLogId;
    }

    public Boolean getReleaseRulePushExecution() {
        return this.releaseRulePushExecution;
    }

    public void setReleaseRulePushExecution(Boolean releaseRulePushExecution) {
        this.releaseRulePushExecution = releaseRulePushExecution;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
    }

    public void doExecute() {
        this.doExecute(this.continueLogId);
    }

    public void doExecute(Long caseLogId) {
        if (this.ruleCase == null || this.taskLogId == null) {
            return;
        }
        try {
            RuleCaseExecExceptionHelper.getInstance().judgeTaskCancel(this.taskLogId);
            log.info("--execute updateExecuteFileStatus");
            this.updateExecLogStatus(this.taskLogId, null, ReportRuleExecStatusEnum.EXEC_ING.getCode());
            log.info("--execute judgeCaseUpdate");
            if (this.ruleCase.getStatus() != CaseUpdateStatusEnum.NONE && this.ruleCase.getStatus() != CaseUpdateStatusEnum.UPDATE_END) {
                throw new RuleCaseUpdateStatusException(this.ruleCase.getStatus().getName());
            }
            log.info("--execute execCase");
            this.execCase(caseLogId);
            log.info("--execute execCase end");
            EpmThreadPools.CommPools.execute(() -> this.updateExecLogStatus(this.taskLogId, ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"RuleCase_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), ReportRuleExecStatusEnum.EXEC_END.getCode()));
            RuleCaseExecExceptionHelper.getInstance().judgeTaskCancel(this.taskLogId);
        }
        catch (RuleCaseExecCancelException executeCancelException) {
            log.info("--execute executeCancelException");
            log.error((Throwable)executeCancelException);
            this.updateExecLogStatus(this.taskLogId, null, ReportRuleExecStatusEnum.EXEC_CANCEL_END.getCode());
        }
        catch (RuleCaseUpdateStatusException ruleCaseUpdateStatusException) {
            log.info("--execute cancel ruleCase's status is " + this.ruleCase.getStatus().getName());
            log.error((Throwable)ruleCaseUpdateStatusException);
            this.updateExecLogStatus(this.taskLogId, ResManager.loadResFormat((String)"\u89c4\u5219\u65b9\u6848\u72b6\u6001\u4e3a%1\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002", (String)"RuleCase_28", (String)"epm-eb-formplugin", (Object[])new Object[]{this.ruleCase.getStatus().getName()}), ReportRuleExecStatusEnum.EXEC_FAIL.getCode());
        }
        catch (Exception e) {
            log.info("--execute error");
            log.error((Throwable)e);
            this.updateExecLogStatus(this.taskLogId, StringUtils.substring((String)ExceptionUtils.getStackTrace((Throwable)e), (int)0, (int)2000), ReportRuleExecStatusEnum.EXEC_FAIL.getCode());
        }
    }

    public void setAllRefOffsetRule(Set<String> allRefOffsetRule) {
        this.allRefOffsetRule = allRefOffsetRule;
    }

    private void execCase(Long caseLogId) {
        List<RuleRow> rowList = this.ruleCase.getRowList();
        if (RuleExecCaseTypeEnum.RULE.getCode().equals(this.ruleCase.getType()) && !this.ruleCase.getAllowDisable().booleanValue() && rowList.stream().anyMatch(e -> e.getRuleDto().getStatus() == false)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u53d1\u5e03\u7684\u4e1a\u52a1\u89c4\u5219", (String)"RuleCase_74", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        RuleCacheContext context = RuleCacheService.getInstance().listRuleFromLocalCache(this.ruleCase.getBizModelId());
        Map offSuccessorMap = context.getOffSuccessorMap();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.ruleCase.getModelId());
        Map viewMap = modelCache.getViewsByBusModel(this.ruleCase.getBizModelId());
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.ruleCase.getModelId());
        Map varValues = ReportVarUtil.getVarValuesByRule((Integer)ProcessTypeEnum.RULE.getIndex(), (Long)this.ruleCase.getModelId());
        IDataLockChecker checker = DataLockService.getInstance().getCheckerByBizModel(this.ruleCase.getModelId(), this.ruleCase.getBizModelId());
        ExecuteRuleConfig execConfig = this.getConfig(this.ruleCase.getModelId());
        Set<Object> logExecutedRules = Sets.newHashSet();
        if (caseLogId != null) {
            QFilter filter = new QFilter("mainlog", "=", (Object)caseLogId);
            DynamicObjectCollection logDets = QueryServiceHelper.query((String)"eb_rulecaselogdetaill", (String)"bizrule", (QFilter[])filter.toArray());
            logExecutedRules = logDets.stream().map(e -> e.getString("bizrule")).collect(Collectors.toSet());
        }
        RuleExecContext ruleExecContext = new RuleExecContext(modelCache, viewMap, memberPropCache, varValues, checker, execConfig, offSuccessorMap);
        ruleExecContext.setSelExecRange(this.ruleCase.getSelExecRange());
        ruleExecContext.setSelLeafExecRange(this.ruleCase.getSelLeafExecRange());
        int index = 1;
        for (RuleRow ruleRow : rowList) {
            if (logExecutedRules.contains(ruleRow.getRuleDto().getNumber())) {
                log.info("--\u8df3\u8fc7\u89c4\u5219\uff1a" + ruleRow.getRuleDto().getNumber());
                Long detailLogId = RuleExecLogService.getInstance().createDetailLog(this.taskLogId, ruleRow, index, this.detailLog.toString());
                RuleExecLogService.getInstance().updateDetailLogStatus(detailLogId, DetailRuleExecStatusEnum.EXEC_END, this.detailLog.toString());
                ++index;
                continue;
            }
            this.executeOneRule(ruleRow, index, ruleExecContext);
            ++index;
        }
        if (!this.allRefOffsetRule.isEmpty()) {
            log.info("--execute offsetRule");
            List ruleDtoList = context.getRuleDtoList();
            Map<Long, RuleDto> ruleDtoMap = ruleDtoList.stream().collect(Collectors.toMap(RuleDto::getId, v -> v));
            MutableGraph totalGraph = RuleGraphService.getInstance().getDagGraphByBizmodel(this.ruleCase.getBizModelId().longValue());
            HashSet<GraphNode> nodeSet = new HashSet<GraphNode>(16);
            for (String ruleId : this.allRefOffsetRule) {
                nodeSet.add(new GraphNode(Long.valueOf(Long.parseLong(ruleId)), ""));
            }
            MutableGraph childGraph = Graphs.inducedSubgraph((Graph)totalGraph, nodeSet);
            while (!childGraph.nodes().isEmpty()) {
                Set zeroNodes = RuleGraphService.getInstance().getZeroNodes((Graph)childGraph);
                for (GraphNode zeroNode : zeroNodes) {
                    RuleDto ruleDto = ruleDtoMap.get(zeroNode.getNodeId());
                    ruleExecContext.getExecConfig().setCollectResult(true);
                    ruleExecContext.setPushRuleExecution(true);
                    this.executeOneRule(new RuleRow(ruleDto), index, ruleExecContext);
                    ++index;
                    childGraph.removeNode((Object)zeroNode);
                }
            }
        }
    }

    private void executeOneRule(RuleRow ruleRow, int index, RuleExecContext ruleExecContext) {
        this.detailLog.setLength(0);
        this.detailLog.append(ResManager.loadResFormat((String)"\u5f53\u524d\u6267\u884c\u89c4\u5219\u201c%1\u201d,\u91c7\u96c6\u53d8\u52a8\u6570\u636e\u53c2\u6570\u201c%2\u201d\u3002", (String)"RuleCase_65", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleRow.getRuleDto().getNumber(), ruleExecContext.getExecConfig().isCollectResult()}));
        Long detailLogId = RuleExecLogService.getInstance().createDetailLog(this.taskLogId, ruleRow, index, this.detailLog.toString());
        RuleDto ruleDto = ruleRow.getRuleDto();
        try {
            if (ruleDto.isLeftMainMemContainCtControl()) {
                throw new RuleRangeNoLeafException(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u7684\u4e3b\u7ef4\u5ea6\u6210\u5458\u662f\u53d8\u52a8\u7c7b\u578b\u7684\u5360\u7528\u3001\u6267\u884c\u6210\u5458\uff0c\u8df3\u8fc7\u5f53\u524d\u89c4\u5219\u3002", (String)"RuleCase_71", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber()}));
            }
            Set<String> offRefRule = ruleExecContext.getOffSuccessorMap().get(ruleDto.getId() + "");
            if (offRefRule != null && !offRefRule.isEmpty() && ruleDto.getStatus().booleanValue()) {
                this.allRefOffsetRule.addAll(offRefRule);
            }
            Long dataSetId = ruleDto.getDataSetId();
            Map<String, Set<String>> fillExecRange = ruleRow.getFillExecRange();
            if (fillExecRange == null) {
                fillExecRange = this.analyzeExecRange(ruleRow, ruleExecContext.getModelCache(), ruleExecContext.getViewMap(), ruleExecContext.getMemberPropCache(), ruleExecContext.getVarValues());
            }
            Map<String, Set<String>> realExecRange = this.analyzeRealExecRange(ruleDto, fillExecRange, ruleExecContext.getViewMap(), ruleExecContext.getModelCache());
            realExecRange = this.filterSelRangeAndRealExecRange(ruleDto, realExecRange, ruleExecContext.getModelCache(), ruleExecContext.getSelExecRange(), ruleExecContext.getSelLeafExecRange());
            realExecRange = this.filterScope(ruleDto, realExecRange, dataSetId, ruleExecContext.getModelCache());
            this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u7684\u6267\u884c\u8303\u56f4\uff1a%2\u3002", (String)"RuleCase_29", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber(), realExecRange}));
            RuleExecLogService.getInstance().updateDetailLogStatus(detailLogId, realExecRange);
            Parse2RPN parse2RPN = new Parse2RPN(ruleDto.getFormulaString());
            parse2RPN.parse();
            BinaryExpr binaryExpr = (BinaryExpr)parse2RPN.getExpr();
            if (this.analyzeRightIsNull(binaryExpr.getRight())) {
                this.appendDetailLog(ResManager.loadResFormat((String)"\u53f3\u7b49\u5f0f\u4e3anull\u62160\uff0c\u5220\u9664\u6570\u636e\u3002", (String)"RuleCase_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                Iterator<Map<String, Set<String>>> pagesIte = this.getPages(ruleExecContext, ruleDto, dataSetId, realExecRange, binaryExpr, true, false);
                int pageCnt = 0;
                while (pagesIte.hasNext()) {
                    ++pageCnt;
                    Map<String, Set<String>> page = pagesIte.next();
                    this.doClearData(ruleExecContext.getModelCache(), page, ruleDto);
                }
                this.appendDetailLog(ResManager.loadResFormat((String)"\u5206\u9875\u6570\uff1a%1\u3002", (String)"RuleCase_35", (String)"epm-eb-formplugin", (Object[])new Object[]{pageCnt}));
                log.info("\u591a\u7ef4\u8ba1\u7b97\u5206\u9875\u6570\uff1a" + pageCnt);
            } else {
                boolean hasNumber;
                int rightCheckCart = ruleExecContext.getExecConfig().getRightCheckCart();
                boolean rightCheckFlag = true;
                if (rightCheckCart == 0) {
                    rightCheckFlag = false;
                }
                if ((hasNumber = this.analyzeRightHasNumber(binaryExpr)) && rightCheckFlag && this.calcDescartes(realExecRange).compareTo(new BigInteger(String.valueOf(rightCheckCart))) > 0) {
                    throw new TooMuchNumberException(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u53f3\u5f0f\u542b\u6709\u5b9e\u6570\uff0c\u6267\u884c\u8303\u56f4\u7b1b\u5361\u5c14\u79ef%2\uff0c\u8d85\u8fc7\u5141\u8bb8\u5927\u5c0f%3\uff0c\u6267\u884c\u8be5\u89c4\u5219\u4f1a\u5bf9\u6570\u636e\u5e93\u4e0e\u7cfb\u7edf\u540e\u7eed\u8fd0\u7ef4\u9020\u6210\u5f88\u5927\u5f71\u54cd\uff0c\u8bf7\u4f18\u5316\u3002", (String)"RuleCase_30", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber(), this.calcDescartes(realExecRange), rightCheckCart}));
                }
                CheckResult checkRes = CheckRuleSimpleUtils.check((IModelCacheHelper)ruleExecContext.getModelCache(), (RuleDto)ruleDto);
                BigInteger descartes = this.calcDescartes(realExecRange);
                if (CheckResult.OlapCalc == checkRes) {
                    this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\u4e3a\u7b80\u5355\u89c4\u5219\uff0c\u4f20\u7ed9\u591a\u7ef4\u5e93\u8ba1\u7b97", (String)"RuleCase_66", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    List<Map<String, Set<String>>> optList = new ArrayList<Map<String, Set<String>>>(10);
                    if (descartes.compareTo(new BigInteger(String.valueOf(1000000L))) > 0) {
                        if (ruleExecContext.getExecConfig().isTemplateScopeOpen()) {
                            Map templateMap = RuleRelationService.getInstance().listTemplateIdByRule(this.ruleCase.getModelId().longValue(), Collections.singleton(ruleDto.getId()));
                            optList = RuleOptimizeUtil.getTemplateOptMap((Map)templateMap, (RuleDto)ruleDto, realExecRange, ruleExecContext.getTemplateModelMap(), (IModelCacheHelper)ruleExecContext.getModelCache());
                            if (optList.isEmpty()) {
                                optList.add(realExecRange);
                                this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\u6ca1\u5173\u8054\u5230\u6a21\u7248,\u8ba1\u7b97\u539f\u8303\u56f4", (String)"RuleCase_85", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                        } else {
                            optList.add(realExecRange);
                        }
                    } else {
                        optList.add(realExecRange);
                    }
                    for (Map map : optList) {
                        Iterator<Map<String, Set<String>>> pagesIte = this.getPages(ruleExecContext, ruleDto, dataSetId, map, binaryExpr, false, hasNumber);
                        while (pagesIte.hasNext()) {
                            Map<String, Set<String>> sub = pagesIte.next();
                            AlgoCalcRequest request = new AlgoCalcRequest(this.ruleCase.getModelId(), dataSetId, sub, Collections.singletonList(ruleDto));
                            CalcBizTemplate calcBizTemplate = CalcBizTemplate.newInstance();
                            calcBizTemplate.setReturnChangeData(ruleExecContext.getExecConfig().isCollectResult());
                            if (this.releaseRulePushExecution.booleanValue()) {
                                calcBizTemplate.setReturnChangeData(true);
                            }
                            List changeCells = calcBizTemplate.doService(request);
                            this.handlerPushToRuleExecution(dataSetId, changeCells, ruleExecContext, ruleDto.getStatus());
                            this.appendChangeCellToDetailLog(ruleExecContext.getExecConfig(), 0, changeCells);
                            this.judgeTaskCancel();
                        }
                    }
                } else if (CheckResult.AlgoCalc == checkRes) {
                    this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\u4e3a\u590d\u6742\u89c4\u5219\u6216\u90e8\u5206\u6570\u636e\u88ab\u9501\u5b9a\uff0c\u4f20\u7ed9algo\u5f15\u64ce\u8ba1\u7b97\uff0c\u7b1b\u5361\u5c14\u79ef%1\u3002", (String)"RuleCase_32", (String)"epm-eb-formplugin", (Object[])new Object[]{descartes.toString()}));
                    List<Object> olapRelationList = new ArrayList<Triple<Map<String, Set<String>>, List<String>, List<String[]>>>(1);
                    if (descartes.compareTo(new BigInteger(String.valueOf(1000000L))) > 0 && !hasNumber) {
                        this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\u8ba1\u7b97\u7b1b\u5361\u5c14\u79ef\u5927\u4e8e\u53c2\u6570%1\uff0c\u5f00\u59cb\u8fdb\u884c\u4f18\u5316\u3002", (String)"RuleCase_33", (String)"epm-eb-formplugin", (Object[])new Object[]{1000000L}));
                        if (ruleExecContext.getExecConfig().isTemplateScopeOpen()) {
                            Map templateMap = RuleRelationService.getInstance().listTemplateIdByRule(this.ruleCase.getModelId().longValue(), Collections.singleton(ruleDto.getId()));
                            olapRelationList = RuleOptimizeUtil.getTemplateRowRelation((Map)templateMap, (RuleDto)ruleDto, realExecRange, null, ruleExecContext.getTemplateModelMap(), (IModelCacheHelper)ruleExecContext.getModelCache());
                            this.appendDetailLog(ResManager.loadResFormat((String)"\u4f18\u5316\u540e\u6267\u884c\u96c6\u5408\u5982\u4e0b\uff1a%1\u3002", (String)"RuleCase_34", (String)"epm-eb-formplugin", (Object[])new Object[]{JSON.toJSONString(olapRelationList.stream().map(Triple::getLeft).collect(Collectors.toList()))}));
                        } else {
                            Triple olapRelation = PageUtil.getOlapRelationPage(realExecRange, (RuleDto)ruleDto, (IModelCacheHelper)ruleExecContext.getModelCache(), (int)ruleExecContext.getExecConfig().getMaxExecuteTime());
                            olapRelationList.add((Triple<Map<String, Set<String>>, List<String>, List<String[]>>)olapRelation);
                            this.appendDetailLog(ResManager.loadResFormat((String)"\u4f18\u5316\u540e\u6267\u884c\u96c6\u5408\u5982\u4e0b\uff1a%1\u3002", (String)"RuleCase_34", (String)"epm-eb-formplugin", (Object[])new Object[]{olapRelation.getLeft()}));
                        }
                    } else {
                        olapRelationList.add(Triple.of(realExecRange, null, null));
                    }
                    this.pageExec(ruleExecContext, ruleDto, dataSetId, olapRelationList);
                }
            }
            this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u6267\u884c\u5b8c\u6210\u3002", (String)"RuleCase_36", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber()}));
            RuleExecLogService.getInstance().updateDetailLogStatus(detailLogId, DetailRuleExecStatusEnum.EXEC_END, this.detailLog.toString());
        }
        catch (RuleRangeNoLeafException e) {
            this.appendDetailLog(e.getMessage());
            RuleExecLogService.getInstance().updateDetailLogStatus(detailLogId, DetailRuleExecStatusEnum.EXEC_END, this.detailLog.toString());
        }
        catch (TooMuchNumberException e) {
            this.appendDetailLog(e.getMessage());
            RuleExecLogService.getInstance().updateDetailLogStatus(detailLogId, DetailRuleExecStatusEnum.EXEC_FAIL, this.detailLog.toString());
            throw e;
        }
        catch (Exception e) {
            this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u6267\u884c\u51fa\u9519\uff0c%2\u3002", (String)"RuleCase_37", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber(), ThrowableHelper.getMessage((Exception)e)}));
            RuleExecLogService.getInstance().updateDetailLogStatus(detailLogId, DetailRuleExecStatusEnum.EXEC_FAIL, this.detailLog.toString());
            throw e;
        }
        finally {
            String process = this.getRatio(Math.min(index, this.ruleCase.getRowList().size() + this.allRefOffsetRule.size()), this.ruleCase.getRowList().size() + this.allRefOffsetRule.size());
            EpmThreadPools.CommPools.execute(() -> RuleExecLogService.getInstance().updateExecLogProgress(this.taskLogId, process));
        }
        RuleCaseExecExceptionHelper.getInstance().judgeTaskCancel(this.taskLogId);
    }

    public Map<String, Set<String>> filterSelRangeAndRealExecRange(RuleDto ruleDto, Map<String, Set<String>> realExecRange, IModelCacheHelper modelCache, Map<String, Set<String>> selExecRange, Map<String, Set<String>> selLeafExecRange) {
        HashMap<String, Set<String>> resultExecRange = new HashMap<String, Set<String>>(16);
        if (selExecRange == null) {
            return realExecRange;
        }
        String metNumber = (String)((Set)ruleDto.getLeftMembers().get(SysDimensionEnum.Metric.getNumber())).iterator().next();
        Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metNumber);
        Map<String, Set<String>> actSelExecRange = selExecRange;
        if (metMember.hasAgg()) {
            actSelExecRange = selLeafExecRange;
        }
        Map<String, Set<String>> finalSelExecRange = actSelExecRange;
        realExecRange.forEach((dimNum, members) -> {
            Set selMembers = (Set)finalSelExecRange.get(dimNum);
            if (CollectionUtils.isEmpty((Collection)selMembers)) {
                resultExecRange.put((String)dimNum, (Set<String>)members);
            } else {
                Sets.SetView intersection = Sets.intersection((Set)members, (Set)selMembers);
                if (CollectionUtils.isEmpty((Collection)intersection)) {
                    throw new RuleRangeNoLeafException(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u7684\u6267\u884c\u8303\u56f4\u4e2d\u7ef4\u5ea6%2\u7684\u8303\u56f4\u65e0\u4ea4\u96c6\u6210\u5458\uff0c\u8df3\u8fc7\u5f53\u524d\u89c4\u5219\u3002", (String)"RuleCase_41", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber(), dimNum}));
                }
                resultExecRange.put((String)dimNum, new HashSet(intersection));
            }
        });
        return resultExecRange;
    }

    private Iterator<Map<String, Set<String>>> getPages(RuleExecContext ruleExecContext, RuleDto ruleDto, Long dataSetId, Map<String, Set<String>> realExecRange, BinaryExpr binaryExpr, boolean skipCheckRight, boolean hasNumber) {
        Map optRange = realExecRange;
        BigInteger descartes = this.calcDescartes(realExecRange);
        this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\u4e3a\u591a\u7ef4\u5206\u9875\u8ba1\u7b97\uff0c\u7b1b\u5361\u5c14\u79ef\u201c%1\u201d\u3002", (String)"RuleCase_69", (String)"epm-eb-formplugin", (Object[])new Object[]{descartes.toString()}));
        int shrekPageType = ruleExecContext.getExecConfig().getShrekPageType();
        if (descartes.compareTo(new BigInteger(String.valueOf(1000000L))) > 0 && !hasNumber && shrekPageType == 2) {
            this.appendDetailLog(ResManager.loadResFormat((String)"\u89c4\u5219\u8ba1\u7b97\u7b1b\u5361\u5c14\u79ef\u5927\u4e8e\u53c2\u6570%1\uff0c\u5f00\u59cb\u8fdb\u884c\u4f18\u5316\u3002", (String)"RuleCase_33", (String)"epm-eb-formplugin", (Object[])new Object[]{1000000L}));
            optRange = RuleOptimizeUtil.optimizeByEntity((IModelCacheHelper)ruleExecContext.getModelCache(), (Long)dataSetId, realExecRange, (RuleDto)ruleDto, (int)ruleExecContext.getExecConfig().getMaxExecuteTime(), null);
            if (MapUtils.isEmpty((Map)optRange) || realExecRange.size() != optRange.size()) {
                log.info("\u7b1b\u5361\u5c14\u79ef\u4f18\u5316\u540e\u4e3a\u7a7a\uff1a" + JSON.toJSONString((Object)optRange));
                return Collections.emptyIterator();
            }
        }
        Iterator<Object> ite = Collections.emptyIterator();
        if (shrekPageType == 0) {
            ite = Collections.singleton(optRange).iterator();
        } else if (shrekPageType == 1) {
            int customShrekPage = ruleExecContext.getExecConfig().getCustomShrekPage();
            List orgPages = PageUtil.getPageByOrg(optRange, (int)customShrekPage);
            ite = orgPages.iterator();
        } else if (shrekPageType == 2) {
            try {
                ite = PageUtil.getPageMapExcludeBpIterator(optRange, (int)ruleExecContext.getExecConfig().getCustomShrekCartPage());
            }
            catch (Exception e) {
                log.warn("\u6309\u7b1b\u5361\u5c14\u79ef\u5206\u9875\u5f02\u5e38", (Throwable)e);
                int customShrekPage = ruleExecContext.getExecConfig().getCustomShrekPage();
                this.appendDetailLog(ResManager.loadResFormat((String)"\u6309\u7b1b\u5361\u5c14\u79ef\u5206\u9875\u5f02\u5e38\uff1a%1\uff0c\u6b64\u89c4\u5219\u6539\u4e3a\u6309\u7ec4\u7ec7\u5206\u9875\u6267\u884c\uff0c\u5206\u9875\u6570:[%2]", (String)"RuleCase_79", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage(), customShrekPage}));
                List orgPages = PageUtil.getPageByOrg((Map)optRange, (int)customShrekPage);
                ite = orgPages.iterator();
            }
        }
        return ite;
    }

    private void pageExec(RuleExecContext ruleExecContext, RuleDto ruleDto, Long dataSetId, List<Triple<Map<String, Set<String>>, List<String>, List<String[]>>> olapRelationList) {
        int i = 1;
        for (Triple<Map<String, Set<String>>, List<String>, List<String[]>> olapRel : olapRelationList) {
            Map itemMap = (Map)olapRel.getLeft();
            BigInteger calcCnt = BigInteger.ONE;
            if (CollectionUtils.isEmpty((Collection)((Collection)olapRel.getMiddle()))) {
                calcCnt = kd.epm.eb.common.utils.MapUtils.calcDescartes((Map)itemMap);
            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)olapRel.getRight()))) {
                HashMap excludeRelDimMap = new HashMap(itemMap);
                ((List)olapRel.getMiddle()).forEach(excludeRelDimMap::remove);
                BigInteger mapSum = kd.epm.eb.common.utils.MapUtils.calcDescartes(excludeRelDimMap);
                calcCnt = mapSum.multiply(BigInteger.valueOf(((List)olapRel.getRight()).size()));
            }
            if (BigInteger.valueOf(ruleExecContext.getExecConfig().getMemberCalcLimit()).compareTo(calcCnt) < 0) {
                log.info("\u8ba1\u7b97\u8303\u56f4\u8d85\u8fc7\u7cfb\u7edf\u9650\u5236" + ruleExecContext.getExecConfig().getMemberCalcLimit());
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u8303\u56f4\u8d85\u8fc7\u7cfb\u7edf\u9650\u5236", (String)"RuleExecutionService_13", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            AlgoCalcRequest request = new AlgoCalcRequest(this.ruleCase.getModelId(), dataSetId, itemMap, Collections.singletonList(ruleDto));
            request.setRowMemberRelDims((List)olapRel.getMiddle());
            request.setRowMemberRelList((List)olapRel.getRight());
            List currChangeCell = OlapCommService.getInstance().calcAndSave(request);
            this.handlerPushToRuleExecution(dataSetId, currChangeCell, ruleExecContext, ruleDto.getStatus());
            this.appendChangeCellToDetailLog(ruleExecContext.getExecConfig(), i++, currChangeCell);
            this.judgeTaskCancel();
        }
    }

    private void handlerPushToRuleExecution(Long dataSetId, List<BGCell> changeCells, RuleExecContext ruleExecContext, Boolean ruleStatus) {
        boolean serviceRulePush;
        boolean bl = serviceRulePush = this.releaseRulePushExecution != false && ruleStatus != false;
        if (CollectionUtils.isNotEmpty(changeCells) && (ruleExecContext.isPushRuleExecution() || ruleExecContext.getExecConfig().getCaseToExecution() || serviceRulePush)) {
            this.appendDetailLog(ResManager.loadResFormat((String)"\u63a8\u53d8\u52a8\u5355\u5143\u683c\u5230\u4f9d\u8d56\u8ba1\u7b97", (String)"RuleCase_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            RuleExecutionService.getInstance().executeRuleChain(null, dataSetId, this.ruleCase.getModelId(), changeCells, RuleExecuteTypeEnum.REPEAT_CALC.getType());
        }
    }

    private void appendChangeCellToDetailLog(ExecuteRuleConfig config, int page, List<BGCell> changeCells) {
        if (!config.isCollectResult()) {
            return;
        }
        if (page < 1) {
            this.appendDetailLog(ResManager.loadResFormat((String)"\u4fee\u6539\u884c\u6570[%1],\u7ed3\u679c\u91c7\u6837:", (String)"RuleCase_39", (String)"epm-eb-formplugin", (Object[])new Object[]{changeCells.size()}));
            this.logChangeCell(changeCells);
        } else {
            if (changeCells.size() == 0) {
                return;
            }
            this.appendDetailLog(ResManager.loadResFormat((String)"\u7b2c%1\u9875\uff0c\u4fee\u6539\u884c\u6570%2\uff0c\u7ed3\u679c\u91c7\u6837%3\u3002", (String)"RuleCase_40", (String)"epm-eb-formplugin", (Object[])new Object[]{page, changeCells.size()}));
            this.logChangeCell(changeCells);
        }
    }

    private String logChangeCell(List<BGCell> changeCells) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(changeCells.size(), 5); ++i) {
            this.appendDetailLog(JSON.toJSONString((Object)changeCells.get(i)));
        }
        return sb.toString();
    }

    public Map<String, Set<String>> filterScope(RuleDto ruleDto, Map<String, Set<String>> ruleScope, Long dataSetId, IModelCacheHelper modelCache) {
        HashMap<String, Set<String>> leafScope = new HashMap<String, Set<String>>(16);
        String metNumber = ruleScope.get(SysDimensionEnum.Metric.getNumber()).iterator().next();
        Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metNumber);
        if (!metMember.hasAgg()) {
            ruleScope.forEach((k, v) -> {
                Set cfr_ignored_0 = leafScope.put((String)k, new HashSet(v));
            });
            return leafScope;
        }
        Map viewMap = ruleDto.getViewMap();
        Long bizCtrlRangeId = ruleDto.getBizCtrlRangeId();
        for (Map.Entry<String, Set<String>> entry : ruleScope.entrySet()) {
            String dimNumber = entry.getKey();
            Set<String> members = entry.getValue();
            HashSet<String> leafMembers = new HashSet<String>(members.size());
            for (String memberNumber : members) {
                Member member = modelCache.getMemberByAnyView(bizCtrlRangeId, dimNumber, memberNumber);
                if (!member.isLeaf()) continue;
                leafMembers.add(memberNumber);
            }
            RuleFunctionUtils.removeCtControlMem((String)dimNumber, leafMembers);
            if (leafMembers.isEmpty()) {
                throw new RuleRangeNoLeafException(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u7684\u6267\u884c\u8303\u56f4\u4e2d\u7ef4\u5ea6%2\u7684\u8303\u56f4\u65e0\u4ea4\u96c6\u6210\u5458\uff0c\u8df3\u8fc7\u5f53\u524d\u89c4\u5219\u3002", (String)"RuleCase_41", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber(), dimNumber}));
            }
            leafScope.put(dimNumber, leafMembers);
        }
        return leafScope;
    }

    public String getRatio(Integer number1, Integer number2) {
        DecimalFormat df = new DecimalFormat("0");
        if (number2 != 0) {
            return df.format((double)number1.intValue() / (double)number2.intValue() * 100.0) + "%";
        }
        return "0%";
    }

    private void judgeTaskCancel() {
        ++this.judgeTime;
        if (this.judgeTime % 2 == 0) {
            RuleCaseExecExceptionHelper.getInstance().judgeTaskCancel(this.taskLogId);
        }
    }

    private BigInteger calcDescartes(Map<String, Set<String>> queryMemberMap) {
        return kd.epm.eb.common.utils.MapUtils.calcDescartes(queryMemberMap);
    }

    private void doClearData(IModelCacheHelper modelCache, Map<String, Set<String>> realExecRange, RuleDto ruleDto) {
        Model model = modelCache.getModelobj();
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(ruleDto.getDataSetId());
        if (ruleDto.getLeafFeature() == LeafFeature.NOTLEAF) {
            Map viewMap = ruleDto.getViewMap();
            for (Map.Entry<String, Set<String>> entry : realExecRange.entrySet()) {
                String dimNumber = entry.getKey();
                Set<String> memSet = entry.getValue();
                Set notLeafSet = memSet.stream().map(e -> modelCache.getMember(dimNumber, (Long)viewMap.get(dimNumber), e)).filter(e -> !e.isLeaf()).map(BaseCache::getNumber).collect(Collectors.toSet());
                if (notLeafSet.isEmpty()) continue;
                HashMap<String, Set<String>> deleteMap = new HashMap<String, Set<String>>(realExecRange);
                deleteMap.put(dimNumber, notLeafSet);
                BgmdShrekDao.getInstance().delete(model, ShrekOlapUtils.getCubeNumber((Dataset)dataSet), deleteMap);
            }
        } else {
            BgmdShrekDao.getInstance().delete(model, ShrekOlapUtils.getCubeNumber((Dataset)dataSet), realExecRange);
        }
    }

    private ExecuteRuleConfig getConfig(long modelId) {
        ExecuteRuleConfig executeRuleConfig = new ExecuteRuleConfig();
        executeRuleConfig.setCaseToExecution(ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG025));
        executeRuleConfig.setMaxExecuteTime(ParamQueryServiceHelper.getInt((long)modelId, (ParamEnum)ParamEnum.BG026));
        executeRuleConfig.setCollectResult(ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG027));
        executeRuleConfig.setCustomShrekPage(ParamQueryServiceHelper.getChildInt((long)modelId, (ParamEnum)ParamEnum.BG039, (String)"custom_shrek_page"));
        executeRuleConfig.setPageSize(ParamQueryServiceHelper.getInt((long)modelId, (ParamEnum)ParamEnum.BG040));
        executeRuleConfig.setRightCheckCart(ParamQueryServiceHelper.getInt((long)modelId, (ParamEnum)ParamEnum.BG044));
        executeRuleConfig.setShrekPageType(ParamQueryServiceHelper.getChildInt((long)modelId, (ParamEnum)ParamEnum.BG039, (String)"shrek_page_type"));
        executeRuleConfig.setCustomShrekCartPage(ParamQueryServiceHelper.getChildInt((long)modelId, (ParamEnum)ParamEnum.BG039, (String)"custom_shrek_cart_page"));
        executeRuleConfig.setTemplateScopeOpen(ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG072));
        executeRuleConfig.setMemberCalcLimit(ParamQueryServiceHelper.getInt((long)modelId, (ParamEnum)ParamEnum.BG075));
        return executeRuleConfig;
    }

    private void appendDetailLog(String log) {
        if (this.detailLog.length() != 0) {
            this.detailLog.append("\r\n");
        }
        this.detailLog.append(log);
    }

    private boolean analyzeRightIsNull(IExpress right) {
        return right instanceof WordExpr && "null".equalsIgnoreCase(((WordExpr)right).toMdx()) || right instanceof NumberExpr && "0".equalsIgnoreCase(((NumberExpr)right).toMdx());
    }

    private boolean analyzeRightHasNumber(BinaryExpr binaryExpr) {
        return binaryExpr.getRight().checkRightHasNumber();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Set<String>> analyzeRealExecRange(RuleDto ruleDto, Map<String, Set<String>> fillExecRange, Map<String, Long> viewMap, IModelCacheHelper modelCache) {
        HashMap<String, Set<String>> realExecRange = new HashMap<String, Set<String>>(16);
        String[] dimensionNums = modelCache.getDimensionNums(ruleDto.getDataSetId());
        Map leftMembers = ruleDto.getLeftMembers();
        String metricNumber = (String)((Set)leftMembers.get(SysDimensionEnum.Metric.getNumber())).iterator().next();
        for (String dimensionNum : dimensionNums) {
            HashSet<Object> dimRef = new HashSet<Object>();
            realExecRange.put(dimensionNum, dimRef);
            Set ruleMembers = (Set)leftMembers.get(dimensionNum);
            Set<String> selectMembers = fillExecRange.get(dimensionNum);
            if (ruleMembers == null && selectMembers == null) {
                if (!View.NoViewDimNums.contains(dimensionNum)) throw new RuleRangeNoLeafException(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u7684%2\u7ef4\u5ea6\u9002\u7528\u8303\u56f4\u65e0\u6210\u5458\uff0c\u8bf7\u6307\u5b9a\u7ef4\u5ea6\u6210\u5458\u518d\u6267\u884c\u89c4\u5219\uff0c\u5f53\u524d\u8df3\u8fc7\u8be5\u89c4\u5219\u3002", (String)"RuleCase_70", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber(), dimensionNum}));
                List member = modelCache.getMember(dimensionNum, null, dimensionNum, RangeEnum.ALL.getIndex());
                Set memberRef = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber).hasAgg() ? member.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet()) : member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                dimRef.addAll(memberRef);
            } else if (selectMembers == null) {
                dimRef.addAll(ruleMembers);
            } else if (ruleMembers == null) {
                dimRef.addAll(selectMembers);
            } else {
                dimRef.addAll(ruleMembers);
                dimRef.retainAll(selectMembers);
            }
            if (!dimRef.isEmpty()) continue;
            throw new RuleRangeNoLeafException(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\u7684\u6267\u884c\u8303\u56f4\u4e2d\u7ef4\u5ea6%2\u7684\u8303\u56f4\u65e0\u4ea4\u96c6\u6210\u5458\uff0c\u8df3\u8fc7\u5f53\u524d\u89c4\u5219\u3002", (String)"RuleCase_41", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleDto.getNumber(), dimensionNum}));
        }
        return realExecRange;
    }

    public Map<String, Set<String>> analyzeExecRange(RuleRow ruleRow, IModelCacheHelper modelCache, Map<String, Long> viewMap, MemberPropCache memberPropCache, Map<String, Map<String, Set<String>>> varValues) {
        HashMap<String, Set<String>> fillExecRange = new HashMap<String, Set<String>>();
        Map execRange = ruleRow.getExecRange();
        String metNumber = (String)((Set)ruleRow.getRuleDto().getLeftMembers().get(SysDimensionEnum.Metric.getNumber())).iterator().next();
        Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metNumber);
        if (execRange != null) {
            for (Map.Entry entry : execRange.entrySet()) {
                String dimensionNum = (String)entry.getKey();
                List memberList = (List)entry.getValue();
                HashSet dimRef = new HashSet();
                fillExecRange.put(dimensionNum, dimRef);
                for (MemberCondition memberCondition : memberList) {
                    Long viewId = IDUtils.toLong((Object)memberCondition.getViewId());
                    if (memberCondition.isProp()) {
                        CustomPropertyValue customPropertyValue = MemberPropCache.getCustomPropertyValue((MemberPropCache)memberPropCache, (String)dimensionNum, (String)memberCondition.getLongnumber());
                        List propMemberList = MemberPropCache.getMembersByPropValues((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Long)viewId, (CustomPropertyValue)customPropertyValue);
                        Object memberStream = propMemberList.stream();
                        if (metMember.hasAgg()) {
                            memberStream = memberStream.filter(Member::isLeaf);
                        }
                        Set memberRef = memberStream.map(BaseCache::getNumber).collect(Collectors.toSet());
                        dimRef.addAll(memberRef);
                        continue;
                    }
                    if (TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimensionNum).booleanValue()) {
                        if (varValues == null || !varValues.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u4e3a\u53d8\u91cf\u8d4b\u503c\u3002", (String)"RuleJsUtils_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        String msg = ResManager.loadKDString((String)"\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u4e3a%1$s\u7ef4\u5ea6\u7684%2$s\u53d8\u91cf\u8d4b\u503c\u3002", (String)"RuleRangeJsAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        Set memberNumbers = ReportVarUtil.getRealDimByVar((Long)this.ruleCase.getModelId(), (String)memberCondition.getNumber(), (String)SysDimensionEnum.BudgetPeriod.getNumber(), varValues, (String)msg);
                        for (String memberNumber : memberNumbers) {
                            String range = memberCondition.getRange();
                            List member = modelCache.getMember(dimensionNum, viewId, memberNumber, Integer.parseInt(range));
                            Stream<Object> memberStream = member.stream();
                            if (metMember.hasAgg()) {
                                memberStream = memberStream.filter(Member::isLeaf);
                            }
                            Set memberRef = memberStream.map(BaseCache::getNumber).collect(Collectors.toSet());
                            dimRef.addAll(memberRef);
                        }
                        continue;
                    }
                    String number = memberCondition.getNumber();
                    String range = memberCondition.getRange();
                    List member = modelCache.getMember(dimensionNum, viewId, number, Integer.parseInt(range));
                    Stream<Object> memberStream = member.stream();
                    if (metMember.hasAgg()) {
                        memberStream = memberStream.filter(Member::isLeaf);
                    }
                    Set memberRef = memberStream.map(BaseCache::getNumber).collect(Collectors.toSet());
                    dimRef.addAll(memberRef);
                }
            }
        }
        return fillExecRange;
    }

    public void updateExecLogStatus(Long taskLogId, String message, String code) {
        RuleExecLogService.getInstance().updateExecStatus(taskLogId, null, code, message);
    }
}

