/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.ruleexec.entity.RuleRow;
import kd.epm.eb.formplugin.ruleexec.enums.CaseUpdateStatusEnum;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleCacheContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class RuleCase
implements Serializable {
    private static final long serialVersionUID = -7158281633536715516L;
    private Long id;
    private Long modelId;
    private Long bizModelId;
    private Long dataSetId;
    private String caseNumber;
    private String caseName;
    private CaseUpdateStatusEnum status;
    private List<RuleRow> rowList;
    private Boolean allowDisable;
    private String type;
    private Map<String, Set<String>> selExecRange;
    private Map<String, Set<String>> selLeafExecRange;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getBizModelId() {
        return this.bizModelId;
    }

    public void setBizModelId(Long bizModelId) {
        this.bizModelId = bizModelId;
    }

    public Long getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(Long dataSetId) {
        this.dataSetId = dataSetId;
    }

    public String getCaseNumber() {
        return this.caseNumber;
    }

    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    public String getCaseName() {
        return this.caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public CaseUpdateStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(CaseUpdateStatusEnum status) {
        this.status = status;
    }

    public List<RuleRow> getRowList() {
        return this.rowList;
    }

    public void setRowList(List<RuleRow> rowList) {
        this.rowList = rowList;
    }

    public Boolean getAllowDisable() {
        return this.allowDisable;
    }

    public void setAllowDisable(Boolean allowDisable) {
        this.allowDisable = allowDisable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static RuleCase of(DynamicObject doj, boolean needExecRuleRange) {
        DynamicObject execRange;
        String execRangeStr;
        RuleCase ruleCase = new RuleCase();
        long caseId = doj.getLong("id");
        ruleCase.setId(caseId);
        ruleCase.setModelId(doj.getLong("model.id"));
        ruleCase.setBizModelId(doj.getLong("bizmodel.id"));
        ruleCase.setDataSetId(doj.getLong("dataset.id"));
        ruleCase.setCaseNumber(doj.getString("number"));
        ruleCase.setCaseName(doj.getString("name"));
        ruleCase.setStatus(CaseUpdateStatusEnum.getStatusByCode((String)doj.getString("updatestatus")));
        ruleCase.setAllowDisable(doj.getBoolean("allowdisable"));
        ruleCase.setType(doj.getString("type"));
        DynamicObject[] ruleCaseSelRanges = BusinessDataServiceHelper.load((String)"eb_rulecaseexecrange", (String)"execrange", (QFilter[])new QFilter("ruleexeccaseids.fbasedataid_id", "=", (Object)caseId).toArray());
        if (ruleCaseSelRanges != null && ruleCaseSelRanges.length > 0 && needExecRuleRange && StringUtils.isNotEmpty((String)(execRangeStr = (execRange = ruleCaseSelRanges[0]).getString("execrange")))) {
            Map memberListMap = (Map)JsonUtils.readValue((String)execRangeStr, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){});
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)ruleCase.getModelId());
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)ruleCase.getModelId());
            Map varValues = ReportVarUtil.getVarValuesByRule((Integer)ProcessTypeEnum.RULE.getIndex(), (Long)ruleCase.getModelId());
            HashMap<String, Set<String>> selExecRange = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> selLeafExecRange = new HashMap<String, Set<String>>();
            RuleCase.analyzeSelExecRange(modelCache, memberListMap, memberPropCache, varValues, selExecRange, selLeafExecRange);
            ruleCase.setSelExecRange(selExecRange);
            ruleCase.setSelLeafExecRange(selLeafExecRange);
        }
        LinkedList<RuleRow> rowList = new LinkedList<RuleRow>();
        DynamicObjectCollection dojColl = doj.getDynamicObjectCollection("selectruleentity");
        if (!dojColl.isEmpty()) {
            RuleCacheContext ruleCacheContext = RuleCacheService.getInstance().listRuleFromLocalCache(ruleCase.getBizModelId());
            List ruleDtoList = ruleCacheContext.getRuleDtoList();
            Map<Long, RuleDto> ruleDtoMap = ruleDtoList.stream().collect(Collectors.toMap(RuleDto::getId, v -> v));
            for (DynamicObject childDoj : dojColl) {
                List list;
                long ruleId = childDoj.getLong("rulename.id");
                RuleDto ruleDto = ruleDtoMap.get(ruleId);
                if (ruleDto == null && CaseUpdateStatusEnum.NONE == ruleCase.getStatus() && (list = RuleService.getInstance().listRule(ruleCase.getBizModelId(), null, Collections.singletonList(ruleId))).size() > 0) {
                    ruleDto = (RuleDto)list.get(0);
                }
                if (ruleDto == null) continue;
                RuleRow row = new RuleRow(ruleDto);
                Map memberListMap = new HashMap();
                String rangeJson = childDoj.getString("rangejson");
                if (StringUtils.isNotEmpty((String)rangeJson)) {
                    memberListMap = (Map)JsonUtils.readValue((String)rangeJson, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){});
                }
                row.setExecRange(memberListMap);
                rowList.add(row);
            }
        }
        ruleCase.setRowList(rowList);
        return ruleCase;
    }

    public Map<String, Set<String>> getSelExecRange() {
        return this.selExecRange;
    }

    public void setSelExecRange(Map<String, Set<String>> selExecRange) {
        this.selExecRange = selExecRange;
    }

    public Map<String, Set<String>> getSelLeafExecRange() {
        return this.selLeafExecRange;
    }

    public void setSelLeafExecRange(Map<String, Set<String>> selLeafExecRange) {
        this.selLeafExecRange = selLeafExecRange;
    }

    public static void analyzeSelExecRange(IModelCacheHelper modelCache, Map<String, List<MemberCondition>> selExecMemberCondition, MemberPropCache memberPropCache, Map<String, Map<String, Set<String>>> varValues, Map<String, Set<String>> selExecRange, Map<String, Set<String>> selLeafExecRange) {
        Long modelId = modelCache.getModelobj().getId();
        if (selExecMemberCondition != null) {
            for (Map.Entry<String, List<MemberCondition>> entry : selExecMemberCondition.entrySet()) {
                String dimensionNum = entry.getKey();
                List<MemberCondition> memberList = entry.getValue();
                HashSet dimRef = new HashSet();
                HashSet leafDimRef = new HashSet();
                selExecRange.put(dimensionNum, dimRef);
                selLeafExecRange.put(dimensionNum, leafDimRef);
                for (MemberCondition memberCondition : memberList) {
                    Long viewId = IDUtils.toLong((Object)memberCondition.getViewId());
                    if (memberCondition.isProp()) {
                        CustomPropertyValue customPropertyValue = MemberPropCache.getCustomPropertyValue((MemberPropCache)memberPropCache, (String)dimensionNum, (String)memberCondition.getLongnumber());
                        List propMemberList = MemberPropCache.getMembersByPropValues((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Long)viewId, (CustomPropertyValue)customPropertyValue);
                        Set memberRef = propMemberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                        Set leafMemberRef = propMemberList.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
                        dimRef.addAll(memberRef);
                        leafDimRef.addAll(leafMemberRef);
                        continue;
                    }
                    if (TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimensionNum).booleanValue()) {
                        if (varValues == null || !varValues.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u4e3a\u53d8\u91cf\u8d4b\u503c\u3002", (String)"RuleJsUtils_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        String msg = ResManager.loadKDString((String)"\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u4e3a%1$s\u7ef4\u5ea6\u7684%2$s\u53d8\u91cf\u8d4b\u503c\u3002", (String)"RuleRangeJsAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        Set memberNumbers = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memberCondition.getNumber(), (String)SysDimensionEnum.BudgetPeriod.getNumber(), varValues, (String)msg);
                        for (String memberNumber : memberNumbers) {
                            String range = memberCondition.getRange();
                            List member = modelCache.getMember(dimensionNum, viewId, memberNumber, Integer.parseInt(range));
                            Set memberRef = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                            Set leafMemberRef = member.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
                            dimRef.addAll(memberRef);
                            leafDimRef.addAll(leafMemberRef);
                        }
                        continue;
                    }
                    String number = memberCondition.getNumber();
                    String range = memberCondition.getRange();
                    List member = modelCache.getMember(dimensionNum, viewId, number, Integer.parseInt(range));
                    Set memberRef = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    Set leafMemberRef = member.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
                    dimRef.addAll(memberRef);
                    leafDimRef.addAll(leafMemberRef);
                }
            }
        }
    }
}

