/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.ruleexecute.task;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.formplugin.ruleexec.command.RuleExecCommand;
import kd.epm.eb.formplugin.ruleexec.entity.RuleCase;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;
import kd.epm.eb.formplugin.ruleexec.service.RuleExecLogService;

public class ExecuteRuleTask
extends RuleExecCommand {
    private static final Log log = LogFactory.getLog(ExecuteRuleTask.class);

    @Override
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("\u6267\u884c\u89c4\u5219\u5b9a\u65f6\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        if (map == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u4f53\u7cfb\u6216\u65b9\u6848\uff0c\u4f53\u7cfb\u7f16\u7801\u6216\u65b9\u6848\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"DataLockService_3", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        Object modelNumber = map.get("modelNumber");
        String caseNumber = (String)map.get("caseNumber");
        if (modelNumber == null || caseNumber == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u4f53\u7cfb\u6216\u65b9\u6848\uff0c\u4f53\u7cfb\u7f16\u7801\u6216\u65b9\u6848\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"DataLockService_3", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        QFilter modelQfilter = new QFilter("shownumber", "=", modelNumber);
        DynamicObject modelDoj = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number", (QFilter[])modelQfilter.toArray());
        Object[] caseNumbers = caseNumber.split(",");
        QFilter caseQfilter = new QFilter("number", "in", (Object)caseNumbers);
        caseQfilter.and("model.shownumber", "=", modelNumber);
        DynamicObjectCollection caseDys = QueryServiceHelper.query((String)"eb_ruleexeccase", (String)"number,name,id", (QFilter[])caseQfilter.toArray());
        if (modelDoj == null || caseDys == null || caseDys.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u67e5\u8be2\u4e0d\u5230\u4f53\u7cfb\u6216\u65b9\u6848\uff0c\u4f53\u7cfb\u7f16\u7801\uff1a%1\uff0c\u65b9\u6848\u7f16\u7801\uff1a%2\u3002", (String)"DataLockService_2", (String)"epm-eb-budget", (Object[])new Object[]{modelNumber, caseNumber}));
        }
        HashMap<Long, String> caseIdNumberMap = new HashMap<Long, String>(16);
        HashSet<Long> ruleCaseIds = new HashSet<Long>(16);
        for (DynamicObject caseDy : caseDys) {
            long caseId = caseDy.getLong("id");
            caseIdNumberMap.put(caseId, caseDy.getString("number"));
            ruleCaseIds.add(caseId);
        }
        long modelId = modelDoj.getLong("id");
        DynamicObject[] ruleCaseSelRanges = BusinessDataServiceHelper.load((String)"eb_rulecaseexecrange", (String)"execrange,ruleexeccaseids", (QFilter[])new QFilter("ruleexeccaseids.fbasedataid_id", "in", ruleCaseIds).toArray());
        if (ruleCaseSelRanges == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u6267\u884c\u65b9\u6848%1\u672a\u9009\u62e9\u6267\u884c\u8303\u56f4\uff0c\u8bf7\u5230\u89c4\u5219\u6267\u884c\u65b9\u6848\u9009\u4e2d\u5bf9\u5e94\u65b9\u6848\u70b9\u51fb\u6267\u884c\u9009\u62e9\u5bf9\u5e94\u8303\u56f4\u540e\u4fdd\u5b58\u6267\u884c\u8303\u56f4\u3002", (String)"RuleJsUtils_4", (String)"epm-eb-formplugin", (Object[])caseNumbers));
        }
        HashSet hasRangeRuleCaseIds = new HashSet(16);
        for (DynamicObject obj : ruleCaseSelRanges) {
            DynamicObjectCollection ruleCaseObjs = obj.getDynamicObjectCollection("ruleexeccaseids");
            Set ruleCaseIdSet = ruleCaseObjs.stream().map(ob -> ob.getLong("fbasedataid_id")).collect(Collectors.toSet());
            hasRangeRuleCaseIds.addAll(ruleCaseIdSet);
        }
        ruleCaseIds.removeAll(hasRangeRuleCaseIds);
        if (ruleCaseIds.size() > 0) {
            HashSet<String> caseNumberSet = new HashSet<String>(16);
            for (Long ruleCaseId : ruleCaseIds) {
                String _caseNumber = (String)caseIdNumberMap.get(ruleCaseId);
                caseNumberSet.add(_caseNumber);
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u6267\u884c\u65b9\u6848%1\u672a\u9009\u62e9\u6267\u884c\u8303\u56f4\uff0c\u8bf7\u5230\u89c4\u5219\u6267\u884c\u65b9\u6848\u9009\u4e2d\u5bf9\u5e94\u65b9\u6848\u70b9\u51fb\u6267\u884c\u9009\u62e9\u5bf9\u5e94\u8303\u56f4\u540e\u4fdd\u5b58\u6267\u884c\u8303\u56f4\u3002", (String)"RuleJsUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[]{caseNumberSet}));
        }
        for (DynamicObject caseDy : caseDys) {
            String casNumber = caseDy.getString("number");
            this.taskLogId = RuleExecLogService.getInstance().createCronJonLog(modelId, casNumber);
            DynamicObject doj = RuleCaseService.getInstance().updateCaseEntity(Long.valueOf(modelId), casNumber);
            this.ruleCase = RuleCase.of(doj, true);
            this.doExecute();
        }
    }
}

