/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.task.BgTaskMessageEnum;
import kd.epm.eb.formplugin.task.BgTaskMessageRemindPlugin;

public class BgTaskPersonRemindNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MESSAGE_CONTENT = "messagecontent";
    private static final String SETTING = "setting";
    private static final String BTN_OK = "btnok";
    private static final String BTN_OK_BACK = "btnokback";
    private static final String ENTRYENTITY = "entryentity";
    private static final String RECIPIENT = "recipient";
    private static final Log logger = LogFactory.getLog(BgTaskMessageRemindPlugin.class);
    private static final String DATETIMEFIELD = "datetimefield";
    private List<Map<String, String>> parentParamsValues = new ArrayList<Map<String, String>>();
    private Map<String, Map<String, Object>> showParamsValues = new LinkedHashMap<String, Map<String, Object>>();
    private Map<String, Map<String, String>> finalParamsValues = new LinkedHashMap<String, Map<String, String>>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SETTING, BTN_OK, BTN_OK_BACK, RECIPIENT, "datetiming"});
        BasedataEdit control = (BasedataEdit)this.getControl("executors");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.replaceAllMessageData();
        this.initShowParamsValues();
        this.initControl();
    }

    private void replaceAllMessageData() {
        List<String> paramsKeyList = this.getControlMessageList();
        this.getPageCache().put("parentParamsValues", this.getView().getFormShowParameter().getCustomParam("parentParamsValues").toString());
        this.parentParamsValues = (List)JSON.parseObject((String)this.getView().getFormShowParameter().getCustomParam("parentParamsValues").toString(), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        ILocaleString messageRemind = this.getMessageRemind();
        for (Map<String, String> parentParamsValue : this.parentParamsValues) {
            ILocaleString messageData = this.replaceMessageData(paramsKeyList, parentParamsValue, (ILocaleString)LocaleString.fromMap((Map)messageRemind));
            parentParamsValue.put("messagedata", SerializationUtils.serializeToBase64((Object)messageData));
        }
    }

    private void initShowParamsValues() {
        for (Map<String, String> parentParamsValue : this.parentParamsValues) {
            Map<Object, Object> showParamsValue;
            if (!this.showParamsValues.containsKey(parentParamsValue.get("id"))) {
                showParamsValue = new HashMap<String, String>();
                showParamsValue.putAll(parentParamsValue);
                ArrayList<Long> receivers = new ArrayList<Long>();
                receivers.add(Long.valueOf(parentParamsValue.get("receiver")));
                showParamsValue.put("receivers", receivers);
                this.showParamsValues.put(parentParamsValue.get("id"), showParamsValue);
                continue;
            }
            showParamsValue = this.showParamsValues.get(parentParamsValue.get("id"));
            ((ArrayList)showParamsValue.get("receivers")).add(Long.valueOf(parentParamsValue.get("receiver")));
            this.showParamsValues.put(parentParamsValue.get("id"), showParamsValue);
        }
        this.getPageCache().put("showParamsValues", SerializationUtils.serializeToBase64(this.showParamsValues));
    }

    private void initControl() {
        IDataModel model = this.getModel();
        model.beginInit();
        int i = 0;
        model.deleteEntryData(ENTRYENTITY);
        model.batchCreateNewEntryRow(ENTRYENTITY, this.showParamsValues.size());
        model.setValue(DATETIMEFIELD, (Object)new Date(TimeServiceHelper.now().getTime() + 660000L));
        for (Map<String, Object> showParamsValue : this.showParamsValues.values()) {
            ArrayList receivers = (ArrayList)showParamsValue.get("receivers");
            model.setValue("id", showParamsValue.get("id"), i);
            model.setValue("executors", (Object)receivers.toArray(), i);
            ILocaleString localeString = (ILocaleString)SerializationUtils.deSerializeFromBase64((String)((String)showParamsValue.get("messagedata")));
            model.setValue("message", (Object)localeString, i);
            model.setValue("sendid", showParamsValue.get("sendid"), i);
            ++i;
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
        this.getView().updateView(DATETIMEFIELD);
    }

    private void updateControl() {
        IDataModel model = this.getModel();
        model.beginInit();
        int i = 0;
        model.deleteEntryData(ENTRYENTITY);
        model.batchCreateNewEntryRow(ENTRYENTITY, this.showParamsValues.size());
        model.setValue(DATETIMEFIELD, (Object)new Date(TimeServiceHelper.now().getTime() + 660000L));
        Map executorMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("executors"));
        for (Map<String, Object> showParamsValue : this.showParamsValues.values()) {
            model.setValue("id", showParamsValue.get("id"), i);
            model.setValue("executors", (Object)((List)executorMap.get(showParamsValue.get("id"))).toArray(), i);
            ILocaleString localeString = (ILocaleString)SerializationUtils.deSerializeFromBase64((String)((String)showParamsValue.get("messagedata")));
            model.setValue("message", (Object)localeString, i);
            model.setValue("sendid", showParamsValue.get("sendid"), i);
            ++i;
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
        this.getView().updateView(DATETIMEFIELD);
    }

    private ILocaleString getMessageRemind() {
        LocaleString messageRemind = null;
        Long modelid = Long.valueOf(this.parentParamsValues.get(0).get("modelId"));
        QFilter qFilters = new QFilter("model", "=", (Object)modelid);
        DynamicObject d = BusinessDataServiceHelper.loadSingle((String)"eb_task_msg_reminder", (String)"id,model,messagecontent", (QFilter[])qFilters.toArray());
        if (d != null && d.getString(MESSAGE_CONTENT) != null) {
            messageRemind = d.getLocaleString(MESSAGE_CONTENT);
            if (messageRemind.get((Object)"GLang") != null && messageRemind.getLocaleValue() == null) {
                messageRemind.setLocaleValue(messageRemind.toString());
            }
        } else {
            messageRemind = BgTaskPersonRemindNewPlugin.getDefaultMessage();
        }
        return messageRemind;
    }

    public static LocaleString getDefaultMessage() {
        return ResManager.getLocaleString((String)"{model.name}\uff08{model.number}\uff09\u4e0b\u7684{org.name}\uff08{org.number}\uff09\u5b58\u5728{datatype.name}-{catalog}-{version.name}\u7684{taskname}\u4efb\u52a1\u9700\u8981\u60a8\u5c3d\u5feb\u5904\u7406\u3002", (String)"BgTaskPersonRemindNewPlugin_1", (String)"epm-eb-formplugin");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] indexrows = new int[this.showParamsValues.size()];
        for (int i1 = 0; i1 < this.showParamsValues.size(); ++i1) {
            indexrows[i1] = i1;
        }
        entryGrid.selectRows(indexrows, 0);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.sendMessage();
                break;
            }
            case "setting": {
                this.putExecutorsCache();
                this.openMessageRemindEdit();
                break;
            }
            case "btncancel": {
                this.setParentMessage();
            }
        }
    }

    private void putExecutorsCache() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        HashMap executorMap = new HashMap();
        for (DynamicObject row : entryEntity) {
            DynamicObjectCollection executors = row.getDynamicObjectCollection("executors");
            ArrayList<Long> executorList = new ArrayList<Long>();
            for (DynamicObject executor : executors) {
                executorList.add(executor.getLong("fbasedataid_id"));
            }
            executorMap.put(row.getString("id"), executorList);
        }
        this.getPageCache().put("executors", SerializationUtils.serializeToBase64(executorMap));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("taskmessageremin".equals(actionId)) {
            this.replaceAllMessageData();
            this.initShowParamsValues();
            this.updateControl();
            if ("success".equals(closedCallBackEvent.getReturnData())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BgTaskPersonRemindNewPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openMessageRemindEdit() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_task_msg_reminder_edit");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCustomParam("parentParamsValues", (Object)this.getPageCache().get("parentParamsValues"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskmessageremin"));
        this.getView().showForm(formShowParameter);
    }

    public void setParentMessage() {
        this.getView().returnDataToParent((Object)"");
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        this.showParamsValues = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("showParamsValues"));
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        DynamicObject d = this.getModel().getEntryRowEntity(ENTRYENTITY, rows[0]);
        String id = d.getString("id");
        ArrayList receivers = (ArrayList)this.showParamsValues.get(id).get("receivers");
        beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", new HashSet(receivers)));
    }

    public void sendMessage() {
        this.getParentParamsValues();
        this.getFinalParamsValues();
        if (this.isDatetiming()) {
            Date judgeTim = this.judgeTim();
            EpmThreadPools.CommPools.execute(() -> this.finalParamsValues.values().forEach(e -> this.currentWordTime(judgeTim, (Map<String, String>)e)));
        } else {
            EpmThreadPools.CommPools.execute(() -> this.finalParamsValues.values().forEach(this::sendMessage));
        }
        this.getView().returnDataToParent((Object)"taskmessageremin");
        this.getView().close();
    }

    private Map<String, Map<String, String>> getFinalParamsValues() {
        for (Map<String, String> parentParamsValue : this.parentParamsValues) {
            Map<String, String> finalParamsValue;
            if (!this.finalParamsValues.containsKey(parentParamsValue.get("receiver"))) {
                finalParamsValue = new HashMap<String, String>(parentParamsValue);
                this.finalParamsValues.put(parentParamsValue.get("receiver"), finalParamsValue);
                continue;
            }
            finalParamsValue = this.finalParamsValues.get(parentParamsValue.get("receiver"));
            String s = "";
            try {
                ILocaleString s1 = (ILocaleString)SerializationUtils.deSerializeFromBase64((String)finalParamsValue.get("messagedata"));
                ILocaleString s2 = (ILocaleString)SerializationUtils.deSerializeFromBase64((String)parentParamsValue.get("messagedata"));
                s = SerializationUtils.serializeToBase64((Object)this.mergeILocaleString(s1, s2));
            }
            catch (Exception e) {
                continue;
            }
            if (s.length() > 100000) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u4ef6\u4eba\u5b57\u6570\u4e0d\u80fd\u8d85\u8fc7100000\u3002", (String)"BgTaskPersonRemindNewPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            finalParamsValue.put("messagedata", s);
            this.finalParamsValues.put(parentParamsValue.get("receiver"), finalParamsValue);
        }
        return this.finalParamsValues;
    }

    private ILocaleString mergeILocaleString(ILocaleString s1, ILocaleString s2) {
        if (s1 == null) {
            return s2;
        }
        for (Map.Entry entry : s2.entrySet()) {
            String langKey = (String)entry.getKey();
            String s2Value = (String)entry.getValue();
            if (s2Value == null) continue;
            String s1Value = (String)s1.getOrDefault((Object)langKey, (Object)"");
            s1.put((Object)langKey, (Object)(s1Value + "\n" + s2Value));
        }
        return s1;
    }

    private List<Map<String, String>> getParentParamsValues() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Map<String, String>> newParamsValues = new ArrayList<Map<String, String>>();
        for (DynamicObject row : rows) {
            DynamicObjectCollection executors = row.getDynamicObjectCollection("executors");
            for (DynamicObject executor : executors) {
                HashMap<String, String> parentParamsValue = new HashMap<String, String>();
                parentParamsValue.put("id", row.getString("id"));
                parentParamsValue.put("receiver", executor.getString("fbasedataid_id"));
                ILocaleString message = row.getLocaleString("message");
                parentParamsValue.put("messagedata", SerializationUtils.serializeToBase64((Object)message));
                parentParamsValue.put("sendid", row.getString("sendid"));
                newParamsValues.add(parentParamsValue);
            }
        }
        this.parentParamsValues = newParamsValues;
        return newParamsValues;
    }

    private ILocaleString replaceMessageData(List<String> paramsKeyList, Map<String, String> parentParamsValue, ILocaleString messageData) {
        for (String s : paramsKeyList) {
            String t = "\\{" + s + "\\}";
            if (parentParamsValue.get(s) == null) continue;
            for (Map.Entry entry : messageData.entrySet()) {
                String replace = (String)entry.getValue();
                replace = replace.replaceAll(t, parentParamsValue.get(s));
                messageData.put(entry.getKey(), (Object)replace);
            }
        }
        return messageData;
    }

    private MessageInfo messageCenter(Map<String, String> parentParamsValue) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setUserIds(Collections.singletonList(Long.valueOf(parentParamsValue.get("receiver"))));
        messageInfo.setTitle(ResManager.loadKDString((String)"\u6d88\u606f\u63d0\u9192", (String)"BgTaskPersonRemindNewPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ILocaleString localeString = (ILocaleString)SerializationUtils.deSerializeFromBase64((String)parentParamsValue.get("messagedata"));
        messageInfo.setMessageContent(localeString);
        if (StringUtils.isNotEmpty((String)parentParamsValue.get("sendid"))) {
            messageInfo.setSenderId(Long.valueOf(parentParamsValue.get("sendid")));
        } else {
            messageInfo.setSenderId(UserUtils.getUserId());
        }
        messageInfo.setType("message");
        messageInfo.setEntityNumber("eb_task_msg_reminder");
        messageInfo.setPubaccNumber("systempubacc");
        return messageInfo;
    }

    private Date judgeTim() {
        Date date = (Date)this.getModel().getValue(DATETIMEFIELD);
        Calendar cal = Calendar.getInstance();
        cal.add(12, 10);
        Date afterTenMinutesDate = cal.getTime();
        if (date == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9a\u65f6\u65f6\u95f4\u201d\u3002", (String)"BgTaskPersonRemindNewPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (date.before(afterTenMinutesDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u6bd4\u5f53\u524d\u65f6\u95f4\u5c11\u4e8e10\u5206\u949f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BgTaskPersonRemindNewPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return date;
    }

    private void sendMessage(Map<String, String> parentParamsValue) {
        MessageInfo messageInfo = this.messageCenter(parentParamsValue);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5411\u4efb\u52a1\u6267\u884c\u4eba\u53d1\u9001\u6d88\u606f\u63d0\u9192\u3002", "BgTaskPersonRemindNewPlugin_7", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u53d1\u9001\u6d88\u606f\uff1a%1$s\u3002", "BgTaskPersonRemindNewPlugin_8", "epm-eb-formplugin");
        OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_task_msg_reminder", null, (String)"notify", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{parentParamsValue.get("messagedata")});
    }

    private boolean isDatetiming() {
        return (Boolean)this.getModel().getValue("datetiming");
    }

    private void currentWordTime(Date judgeTim, Map<String, String> parentParamsValue) {
        this.createSchedule(judgeTim, parentParamsValue);
        this.getView().close();
    }

    public void createSchedule(Date dateTime, Map<String, String> parentParamsValue) {
        try {
            String jobId = this.createJob(parentParamsValue);
            this.createPlan(jobId, dateTime);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5411\u4efb\u52a1\u6267\u884c\u4eba\u53d1\u9001\u6d88\u606f\u63d0\u9192\u3002", "BgTaskPersonRemindNewPlugin_7", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u53d1\u9001\u6d88\u606f\uff1a%1$s\u3002", "BgTaskPersonRemindNewPlugin_8", "epm-eb-formplugin");
            OperationLogUtil.log((String)ApplicationTypeEnum.BGMD.getAppnum(), (String)"eb_task_msg_reminder", null, (String)"notify", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{parentParamsValue.get("messagedata")});
            this.getView().returnDataToParent((Object)"success");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().returnDataToParent((Object)"fail");
        }
    }

    private String createJob(Map<String, String> parentParamsValue) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("executorid", SerializationUtils.serializeToBase64(new HashSet<String>(Collections.singleton(parentParamsValue.get("receiver")))));
        params.put("message", parentParamsValue.get("messagedata"));
        params.put("sendid", parentParamsValue.get("sendid"));
        params.put("title", ResManager.loadKDString((String)"\u6d88\u606f\u63d0\u9192", (String)"BgTaskPersonRemindNewPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(ResManager.loadResFormat((String)"\u4efb\u52a1\u63d0\u9192_%1", (String)"BgTaskPersonRemindNewPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName()}));
        jobInfo.setNumber(DBServiceHelper.genStringId());
        String taskClassName = "kd.epm.eb.formplugin.task.MessageCalTaskNew";
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setParams(params);
        jobInfo.setRunByOrgId(0L);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setRunConcurrently(true);
        jobInfo.setAppId("bgmd");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bgmd");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createJob", new Object[]{jobInfo});
        return String.valueOf(obj);
    }

    private void createPlan(String jobId, Date dateTime) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setNumber(DBServiceHelper.genStringId());
        planInfo.setName(ResManager.loadKDString((String)"\u4efb\u52a1\u63d0\u9192", (String)"BgTaskPersonRemindNewPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(dateTime);
        Calendar endTime = Calendar.getInstance();
        endTime.add(5, 1);
        planInfo.setStartTime(startTimeCalendar);
        planInfo.setEndTime(endTime);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bgmd");
        service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createPlan", new Object[]{planInfo});
    }

    private List<String> getControlMessageList() {
        ArrayList<String> controlMessages = new ArrayList<String>(16);
        for (BgTaskMessageEnum controlMessageEnum : BgTaskMessageEnum.values()) {
            controlMessages.add(controlMessageEnum.getNumber());
        }
        return controlMessages;
    }
}

