/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.adjust.budgetform.BudgetFormHelper;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.ApproveBillExistInfo;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ReportQueryStatusEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TaskProcessStateEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.task.BgTaskProcessServiceHelper;
import kd.epm.eb.formplugin.task.dto.TaskReportDto;
import kd.epm.eb.formplugin.task.dto.TaskTransferDto;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class BgTaskExecuteHelper {
    public static int isExistApproveBill(long reportProcessId) {
        return BgTaskExecuteHelper.getExistApproveBillInfo(reportProcessId, null).getValue();
    }

    public static ApproveBillExistInfo getExistApproveBillInfo(long reportProcessId, ApproveBillInfo approveBillInfo) {
        int status = ApproveBillQuery.getInstance().getProcessStatus(Long.valueOf(reportProcessId), approveBillInfo);
        switch (status) {
            case 3: {
                return ApproveBillExistInfo.SUBMIT;
            }
            case 5: {
                return ApproveBillExistInfo.COMPLETED;
            }
        }
        if ("C".equals(BgTaskExecuteHelper.getBillStatus(reportProcessId))) {
            return ApproveBillExistInfo.REJECT;
        }
        return ApproveBillExistInfo.EMPTY;
    }

    public static String getBillStatus(long reportProcessId) {
        return BgTaskExecuteHelper.getBillStatus(reportProcessId, 0L);
    }

    public static String getBillStatus(long reportProcessId, long billId) {
        DynamicObject approveBill;
        if (IDUtils.isNotNull((long)billId)) {
            approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"billstatus", (QFilter[])new QFilter("id", "=", (Object)billId).toArray());
        } else {
            QFilter reportProcessQFilter = new QFilter("id", "=", (Object)reportProcessId);
            DynamicObject reportProcess = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"model,version,datatype,period,entity,template", (QFilter[])reportProcessQFilter.toArray());
            if (reportProcess == null) {
                return "";
            }
            QFilter approveBillQFilter = new QFilter("entryentity.tempid", "=", (Object)reportProcess.getLong("template"));
            approveBillQFilter.and("modelid", "=", (Object)reportProcess.getLong("model"));
            approveBillQFilter.and("eborgid", "=", (Object)reportProcess.getLong("entity"));
            approveBillQFilter.and("dim_period", "=", (Object)reportProcess.getLong("period"));
            approveBillQFilter.and("dim_version", "=", (Object)reportProcess.getLong("version"));
            approveBillQFilter.and("dim_datatype", "=", (Object)reportProcess.getLong("datatype"));
            approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"billstatus", (QFilter[])approveBillQFilter.toArray());
        }
        if (approveBill == null) {
            return "";
        }
        return approveBill.getString("billstatus");
    }

    public static boolean isTaskNotEnable(Long taskId) {
        return BgTaskDeployListService.getInstance().isTaskNotEnable(taskId);
    }

    public static String isTaskNotEnable(Set<Long> subTaskIds) {
        String closeTaskNameStr = "";
        if (CollectionUtils.isEmpty(subTaskIds)) {
            return closeTaskNameStr;
        }
        HashSet<String> closeTaskNameSet = new HashSet<String>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", subTaskIds), new QFilter("isclosed", "!=", (Object)SubTaskStatusEnum.ENABLE.getValue())});
        if (query != null && query.size() > 0) {
            for (DynamicObject object : query) {
                closeTaskNameSet.add(object.getString("name"));
            }
        }
        if (closeTaskNameSet.size() > 0) {
            closeTaskNameStr = String.join((CharSequence)"\uff0c", closeTaskNameSet);
        }
        return closeTaskNameStr;
    }

    public static boolean importDataTaskIsNotEnable(Long orgId, Long templateId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid from t_eb_task a, t_eb_taskdistorg b, t_eb_taskreftemplate c where a.fid = b.ftask and a.fid = c.fid and a.fisclosed = '1' and b.forgid = ? and c.ftemplateid = ?", new Object[]{orgId, templateId});
        try (DataSet ds = DB.queryDataSet((String)"importDataTaskIsClosed", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            if (ds.hasNext()) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static void cacheUserSelectF7(IFormView formView, String key, String value) {
        if (formView == null || StringUtils.isEmpty((String)key)) {
            return;
        }
        String dimNumber = BgTaskExecuteHelper.getDimNumberFromF7Key(formView, key);
        BgTaskExecuteHelper.cacheDimF7(formView, dimNumber, value);
    }

    public static void cacheDimF7(IFormView formView, String dimNumber, String value) {
        if (formView == null || StringUtils.isEmpty((String)dimNumber)) {
            return;
        }
        IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
        pageCache.put("lastselect_" + dimNumber, value);
        pageCache.put(pageCache.get("current_report_id") + "lastselect_" + dimNumber, value);
    }

    public static String getUserSelectF7FromCache(IFormView formView, String dimNumber, boolean isFirstOpen) {
        IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
        String f7Value = null;
        if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            String reportLastSelectEntity = pageCache.get("current_report_id") + "lastselect_" + dimNumber;
            f7Value = pageCache.get(reportLastSelectEntity);
            if (StringUtils.isEmpty((String)f7Value)) {
                if (isFirstOpen && StringUtils.isNotEmpty((String)(f7Value = pageCache.get("lastselect_" + dimNumber)))) {
                    pageCache.put(reportLastSelectEntity, f7Value);
                }
                if (StringUtils.isEmpty((String)f7Value)) {
                    f7Value = pageCache.get("current_org");
                }
            }
        } else {
            f7Value = pageCache.get("lastselect_" + dimNumber);
        }
        return f7Value;
    }

    public static String getUserSelectF7FromCache(IFormView formView, String dimNumber) {
        return BgTaskExecuteHelper.getUserSelectF7FromCache(formView, dimNumber, false);
    }

    public static Map<String, Long> getUserSelectF7FromCache(IFormView formView, boolean isByReport, boolean lastSelectPageMem) {
        HashMap<String, Long> f7KeyValues = new HashMap<String, Long>(16);
        if (formView == null) {
            return f7KeyValues;
        }
        IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
        String dimNumber = null;
        String cacheKeyPrefixByReport = null;
        String cacheKeyPrefixLastSelect = null;
        if (isByReport) {
            cacheKeyPrefixByReport = pageCache.get("current_report_id") + "lastselect_";
            for (Map.Entry e : pageCache.getAll().entrySet()) {
                if (!((String)e.getKey()).startsWith(cacheKeyPrefixByReport) || e.getValue() == null) continue;
                dimNumber = ((String)e.getKey()).substring(cacheKeyPrefixByReport.length());
                f7KeyValues.put(dimNumber, Long.valueOf((String)e.getValue()));
            }
        }
        if (lastSelectPageMem) {
            cacheKeyPrefixLastSelect = "lastselect_";
            HashMap forceByReports = new HashMap(16);
            for (Map.Entry e : pageCache.getAll().entrySet()) {
                if (!((String)e.getKey()).startsWith(cacheKeyPrefixLastSelect) || e.getValue() == null || f7KeyValues.containsKey(dimNumber = ((String)e.getKey()).substring(cacheKeyPrefixLastSelect.length()))) continue;
                f7KeyValues.put(dimNumber, Long.valueOf((String)e.getValue()));
                if (!isByReport) continue;
                forceByReports.put(cacheKeyPrefixByReport + dimNumber, e.getValue());
            }
            if (!forceByReports.isEmpty()) {
                pageCache.put(forceByReports);
            }
        }
        return f7KeyValues;
    }

    public static void removeUserSelectF7FromCache(IFormView formView, List<String> reportProcessIds) {
        if (formView != null && reportProcessIds != null && !reportProcessIds.isEmpty()) {
            IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
            Map allCached = pageCache.getAll();
            LinkedList toRemoveKeys = new LinkedList();
            for (String reportProcessId : reportProcessIds) {
                String cacheKeyPrefix = reportProcessId + "lastselect_";
                for (Map.Entry e : allCached.entrySet()) {
                    if (!((String)e.getKey()).startsWith(cacheKeyPrefix) || e.getValue() == null) continue;
                    toRemoveKeys.add(e.getKey());
                }
            }
            pageCache.batchRemove(toRemoveKeys);
        }
    }

    public static Set<String> getLoadedReportIdsFromCache(IFormView formView) {
        String str;
        if (formView != null && StringUtils.isNotEmpty((String)(str = formView.getPageCache().get("loadedReportIds")))) {
            return (Set)SerializationUtils.fromJsonString((String)str, Set.class);
        }
        return new HashSet<String>(16);
    }

    public static boolean addLoadedReportIdToCache(IFormView formView, String reportId) {
        if (formView != null && StringUtils.isNotEmpty((String)reportId)) {
            Set<String> ids = BgTaskExecuteHelper.getLoadedReportIdsFromCache(formView);
            boolean isAdded = ids.add(reportId);
            formView.getPageCache().put("loadedReportIds", SerializationUtils.toJsonString(ids));
            return isAdded;
        }
        return false;
    }

    public static boolean removeLoadedReportIdFromCache(IFormView formView, Collection<String> reportIds) {
        if (formView != null && reportIds != null) {
            Set<String> ids = BgTaskExecuteHelper.getLoadedReportIdsFromCache(formView);
            boolean isRemoved = ids.removeAll(reportIds);
            formView.getPageCache().put("loadedReportIds", SerializationUtils.toJsonString(ids));
            return isRemoved;
        }
        return false;
    }

    public static String getDimNumberFromF7Key(IFormView formView, String f7Key) {
        String dimNumber = f7Key;
        if (formView != null && StringUtils.isNotEmpty((String)f7Key)) {
            String f7serial;
            IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
            if (f7Key.startsWith("ebf7_") && StringUtils.isNotEmpty((String)(f7serial = pageCache.get("f7_mapping_cache")))) {
                Map dim_f7Key = (Map)ObjectSerialUtil.deSerializedBytes((String)f7serial);
                dimNumber = (String)dim_f7Key.get(f7Key);
            }
            if (BudgetFormHelper.isBudgetForm((IFormView)formView) && "ebf7_entity".equals(f7Key)) {
                dimNumber = SysDimensionEnum.Entity.getNumber();
            }
        }
        return dimNumber;
    }

    public static boolean isBcmF7Key(String ctrlKey) {
        return ctrlKey != null && (ctrlKey.startsWith("bcm_") || ctrlKey.startsWith("eb_")) && ctrlKey.contains("membertree");
    }

    public static boolean isEbF7Key(String ctrlKey) {
        return ctrlKey != null && ctrlKey.startsWith("ebf7_");
    }

    public static boolean isF7Key(String ctrlKey) {
        return BgTaskExecuteHelper.isBcmF7Key(ctrlKey) || BgTaskExecuteHelper.isEbF7Key(ctrlKey);
    }

    public static boolean isNopermOrg(Long modelId, Long busModelId, String orgNumber, Long viewId) {
        if (modelId == null || modelId == 0L || StringUtils.isEmpty((String)orgNumber)) {
            return false;
        }
        boolean isHasRootPerm = MemberPermHelper.ifUserHasRootPermByModel((Long)UserUtils.getUserId(), (Long)modelId);
        if (isHasRootPerm) {
            return false;
        }
        IMemberPermCache memberPermCache = MemberPermCacheServiceHelper.build(null, (Long)modelId, (Long)busModelId, (String[])new String[]{SysDimensionEnum.Entity.getNumber()});
        Set noPermOrgs = memberPermCache.getNopermMems(SysDimensionEnum.Entity.getNumber(), viewId);
        return noPermOrgs != null && noPermOrgs.contains(orgNumber);
    }

    public static void spreadTreeNodes(TreeNode treenode, int level) {
        if (treenode != null) {
            treenode.setIsOpened(true);
            if (treenode.getChildren() != null && level > 0) {
                List nodes = treenode.getChildren();
                for (TreeNode t : nodes) {
                    BgTaskExecuteHelper.spreadTreeNodes(t, level - 1);
                }
            }
        }
    }

    public static void hideExamineBtn(IFormView view, long modelId) {
    }

    public static List<CellStyle> getStyleList(Map<String, Set<Integer>> colorMap) {
        if (colorMap.isEmpty()) {
            return null;
        }
        Set<Map.Entry<String, Set<Integer>>> entries = colorMap.entrySet();
        ArrayList<CellStyle> styleList = new ArrayList<CellStyle>(16);
        for (Map.Entry<String, Set<Integer>> set : entries) {
            String key = set.getKey();
            String[] color = new String[]{""};
            color[0] = BgTaskStateEnum.UNPREPARED.getNumber().equals(key) || BgTaskStateEnum.INCOMPLETE.getNumber().equals(key) ? BgConstant.COLOR[0] : (BgTaskStateEnum.COMPLETED.getNumber().equals(key) ? BgConstant.COLOR[1] : BgConstant.COLOR[2]);
            set.getValue().forEach(it -> {
                CellStyle style = new CellStyle();
                style.setFieldKey("ls_taskstate");
                style.setRow(it.intValue());
                style.setForeColor(color[0]);
                styleList.add(style);
            });
        }
        return styleList;
    }

    public static List<TaskTransferDto> getTaskTransferList(List<TaskReportDto> myTaskList, String periodName) {
        HashMap<String, Set> taskStateMap = new HashMap<String, Set>(myTaskList.size());
        for (TaskReportDto taskReportDto : myTaskList) {
            Long taskId = taskReportDto.getTaskId();
            Long orgId = taskReportDto.getOrgId();
            String taskState = taskReportDto.getTaskState();
            Set stateSet = taskStateMap.computeIfAbsent(taskId + "!!" + orgId, k -> new HashSet(16));
            stateSet.add(taskState);
        }
        HashSet<String> taskSet = new HashSet<String>(myTaskList.size());
        ArrayList<TaskTransferDto> taskTransferList = new ArrayList<TaskTransferDto>(myTaskList.size());
        for (TaskReportDto taskReportDto : myTaskList) {
            Long taskId = taskReportDto.getTaskId();
            Long orgId = taskReportDto.getOrgId();
            String orgName = taskReportDto.getOrgName();
            if (taskSet.contains(taskId + "!!" + orgId)) continue;
            taskSet.add(taskId + "!!" + orgId);
            Set stateCodes = (Set)taskStateMap.get(taskId + "!!" + orgId);
            TaskProcessStateEnum taskProcessStateEnum = BgTaskProcessServiceHelper.getTaskStateEnum((Set)stateCodes);
            TaskTransferDto taskTransferDto = new TaskTransferDto();
            taskTransferDto.setTaskId(taskId);
            taskTransferDto.setOrgId(orgId);
            taskTransferDto.setOrgName(orgName);
            taskTransferDto.setTaskStateCode(taskProcessStateEnum.getCode());
            taskTransferDto.setTaskStateName(taskProcessStateEnum.getName());
            taskTransferDto.setTaskPackageId(taskReportDto.getTaskPackageId());
            taskTransferDto.setTaskPackageName(taskReportDto.getTaskPackageName());
            taskTransferDto.setTaskName(taskReportDto.getTaskName());
            taskTransferDto.setPeriodName(periodName);
            taskTransferDto.setStartData(taskReportDto.getStartDate());
            taskTransferDto.setEndDate(taskReportDto.getEndDate());
            taskTransferList.add(taskTransferDto);
        }
        return taskTransferList;
    }

    public static Map<String, Integer> getStateCountMap(List<TaskReportDto> myTaskList, String[] labKeys) {
        HashMap<String, Integer> stateCountMap = new HashMap<String, Integer>(myTaskList.size());
        if (CollectionUtils.isEmpty(myTaskList)) {
            for (String labKey : labKeys) {
                ReportQueryStatusEnum enumByKey = ReportQueryStatusEnum.getEnumByKey((String)labKey);
                if (enumByKey == null) continue;
                stateCountMap.put(enumByKey.getNumber(), 0);
            }
        } else {
            int overdueCount = 0;
            for (TaskReportDto taskReportDto : myTaskList) {
                boolean isOverdueCountState;
                String reportStatus = taskReportDto.getTaskState();
                Integer count = (Integer)stateCountMap.get(reportStatus);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                stateCountMap.put(reportStatus, count);
                Date endDate = taskReportDto.getEndDate();
                if (endDate == null) continue;
                String endDateStr = DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                String currDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                String taskState = taskReportDto.getTaskState();
                boolean bl = isOverdueCountState = ReportQueryStatusEnum.NOTPREPARED.getNumber().equals(taskState) || ReportQueryStatusEnum.PREPARED.getNumber().equals(taskState);
                if (currDateStr.compareTo(endDateStr) <= 0 || !isOverdueCountState) continue;
                ++overdueCount;
            }
            stateCountMap.put(ReportQueryStatusEnum.ALL.getNumber(), myTaskList.size());
            stateCountMap.put(ReportQueryStatusEnum.OVERDUE.getNumber(), overdueCount);
        }
        return stateCountMap;
    }

    public static void filterMyTaskList(List<TaskReportDto> myTaskList, String labKey) {
        String taskState = ReportQueryStatusEnum.getNumberByKey((String)labKey);
        Iterator<TaskReportDto> iterator = myTaskList.iterator();
        while (iterator.hasNext()) {
            TaskReportDto taskReportDto = iterator.next();
            if (ReportQueryStatusEnum.OVERDUE.getNumber().equals(taskState)) {
                Date endDate = taskReportDto.getEndDate();
                if (endDate != null) {
                    String endDateStr = DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                    String currDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                    String taskStateCode = taskReportDto.getTaskState();
                    if (currDateStr.compareTo(endDateStr) <= 0) {
                        iterator.remove();
                        continue;
                    }
                    if (ReportQueryStatusEnum.NOTPREPARED.getNumber().equals(taskStateCode) || ReportQueryStatusEnum.PREPARED.getNumber().equals(taskStateCode)) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
                continue;
            }
            String taskStateCode = taskReportDto.getTaskState();
            if (ReportQueryStatusEnum.ALL.getNumber().equals(taskState) || taskState.equals(taskStateCode)) continue;
            iterator.remove();
        }
    }

    public static TableValueSetter getTableValueSetter(List<TaskReportDto> myTaskList, Map<String, Set<Integer>> colorMap) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        for (int i = 0; i < myTaskList.size(); ++i) {
            TaskReportDto data = myTaskList.get(i);
            setter.set("ls_catalog", (Object)data.getTaskType(), i);
            setter.set("ls_taskListName", (Object)data.getTaskPackageName(), i);
            setter.set("ls_year", (Object)data.getPeriodName(), i);
            setter.set("ls_datatype", (Object)data.getDataTypeName(), i);
            setter.set("ls_version", (Object)data.getVersionName(), i);
            setter.set("ls_taskname", (Object)data.getTaskName(), i);
            setter.set("ls_taskid", (Object)data.getTaskId(), i);
            setter.set("ls_reportname", (Object)data.getTemplateName(), i);
            setter.set("ls_templatenumber", (Object)data.getTemplateNumber(), i);
            setter.set("ls_reportid", (Object)data.getTemplateId(), i);
            setter.set("ls_reporttype", (Object)data.getTemplateType(), i);
            setter.set("ls_orgname", (Object)data.getOrgName(), i);
            setter.set("ls_orgid", (Object)data.getOrgId(), i);
            setter.set("ls_executablecount", (Object)data.getExecutableCount(), i);
            setter.set("ls_completedcount", (Object)data.getCompletedCount(), i);
            setter.set("ls_taskstate", (Object)data.getTaskState(), i);
            Long reportProcessId = data.getReportProcessId();
            if (IDUtils.isNotNull((Long)reportProcessId)) {
                setter.set("reportprocess", (Object)reportProcessId, i);
                setter.set("ls_submitdate", (Object)data.getSubmitDate(), i);
                setter.set("ls_submituser", (Object)data.getSubmitUserName(), i);
                setter.set("ls_submitentity", (Object)data.getSubmitEntityName(), i);
                setter.set("approvebill", (Object)data.getApproveBillNo(), i);
                setter.set("approvedesc", (Object)data.getApproveDesc(), i);
            }
            setter.set("ls_begindate", (Object)data.getStartDate(), i);
            setter.set("ls_enddate", (Object)data.getEndDate(), i);
            setter.set("ls_executor", (Object)data.getExecutorName(), i);
            setter.set("ls_taskprocessid", (Object)data.getTaskProcessId(), i);
            setter.set("ls_tasklistid", (Object)data.getTaskPackageId(), i);
            setter.set("ls_modifiedtime", (Object)data.getModifyDate(), i);
            String taskStateStr = data.getTaskState();
            Set colorSet = colorMap.computeIfAbsent(taskStateStr, v -> new HashSet(16));
            colorSet.add(i);
        }
        return setter;
    }
}

