/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUpgradeHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.ApplyUpgradeHelper;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimRangeService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateTableCfgService;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteCheck;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.template.ApplyTemplateHelper;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.common.applyTemplate.constants.BussPlanEntryPresetFieldsEnum;
import kd.epm.eb.common.applyTemplate.constants.DimUseTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateColCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateTableCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.dto.TableColumn;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.helper.TableHelper;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationValueColumn;
import kd.epm.eb.common.ebcommon.enums.TemplateCatalogTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.tree.ITreeNode;
import kd.epm.eb.common.tree.TreeModel;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTree;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTreeBuilder;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.spread.template.TemplateMutexServiceHelper;
import kd.epm.eb.spread.template.list.IRefreshList;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ApplyTemplateListPlugin
extends AbstractListPlugin
implements IRefreshList,
BeforeF7SelectListener {
    private static final String KEY_MAINENTRYENTITY = "mainentryentity";
    private static final String KEY_BIZMAINENTRYENTITY = "bizentryentity";
    private static final String KEY_MODEL_ID = "KEY_MODEL_ID";
    private static final String TOOLBARID = "toolbarap";
    private static final String APPLYTEMPLATELOG_ADD_CLOSEBACK = "applytemplatelog_add_closeback";
    private static final String APPLYTEMPLATELOG_DELETE_COMFIRM = "applytemplatelog_delete_comfirm";
    private static final String APPLYTEMPLATE_MOVE_CLOSEBACK = "applytemplate_move_closeback";
    private static final String APPLYTEMPLATE_ADD_CLOSEBACK = "applytemplate_add_closeback";
    private static final String TEMPLATECATALOG_TREE = "templatecatalogtree";
    private static final String FORM_APPLYTEMPLATE = "eb_applytemplate";
    private static final String FORM_APPLYTEMPLATELOG = "eb_applytemplatelog";
    private static final String APPLYTEMPLATEMOVE = "eb_applytemplatemove";
    private static final String APPLYTEMPLATE_DELETE_COMFIRM = "applytemplate_delete_comfirm";
    private static final String BILLLISTID = "billlistap";
    private static final int MAX_NUMBER_COUNT = 26;
    private static final int MAX_NAME_COUNT = 46;
    private static final Log log = LogFactory.getLog(ApplyTemplateListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARID});
        this.addClickListeners(new String[]{"btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down", "baritemup", "baritemdown", "searchbefore", "searchnext"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    TreeSearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (IFormView)ApplyTemplateListPlugin.this.getView(), (IPageCache)ApplyTemplateListPlugin.this.getPageCache(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(ApplyTemplateListPlugin.TEMPLATECATALOG_TREE));
                } else {
                    ApplyTemplateListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"ApplyTemplateListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        TreeView tview = (TreeView)this.getControl(TEMPLATECATALOG_TREE);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                ApplyTemplateListPlugin.this.refrushBillList();
            }
        });
        this.addF7SelectListener(this, new String[]{this.getModelSign()});
        BillList billList = (BillList)this.getView().getControl(BILLLISTID);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter listQfilter = this.getBillListQfilter();
        e.addCustomQFilter(listQfilter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = null;
        modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTID);
            this.getView().showTipNotification(ApplyTemplateListPlugin.getMODEL_NOTEXISTS());
            return;
        }
        this.getModel().setValue("modelbd", (Object)modelId);
        this.cacheModelId(modelId);
        this.refrushTree(null);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_movetemplate": {
                this.checkTemplateIsOpen();
                this.movetemplate();
                break;
            }
            case "btn_addtemplate": {
                this.openApplyTemplatePage();
                break;
            }
            case "btn_refrush": {
                this.refrushBillList();
                break;
            }
            case "btn_copytemplate": {
                this.copyTemplate();
                break;
            }
            case "btn_deltemplate": {
                this.checkTemplateIsOpen();
                this.deleteTemplate();
                break;
            }
            case "btn_upgrade": {
                ApplyTemplateUpgradeHelper.getInstance().backOldData(this.getModelId());
                ApplyUpgradeHelper.applyUpgrade((IFormView)this.getView(), (Long)this.getModelId());
                break;
            }
            case "btn_restore": {
                ApplyTemplateUpgradeHelper.getInstance().restoreOldData(this.getView(), this.getModelId());
            }
        }
    }

    private void deleteTemplate() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTID);
        Object[] selectids = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectids == null || selectids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6a21\u677f\u8bb0\u5f55\u3002", (String)"ApplyTemplateListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkTaskIsPublished(selectids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u7684\u6a21\u677f\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ApplyTemplateListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> templateIds = new HashSet<Long>(16);
        for (Object pk : selectids) {
            templateIds.add(ConvertUtils.toLong((Object)pk));
        }
        CheckQuote checkQuote = new CheckQuote(this.getModelId(), Long.valueOf(0L), templateIds, MemberTypeEnum.APPLYTEMPLATE);
        QuoteCheckResult quoteCheckResult = QuoteCheck.get().checkQuoteResult(checkQuote);
        if (quoteCheckResult.isHasQuote()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u4e0d\u53ef\u5220\u9664", (String)"AnalyReportVariableListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{quoteCheckResult.getMsg()}));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\uff1f", (String)"ApplyTemplateListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(APPLYTEMPLATE_DELETE_COMFIRM, (IFormPlugin)this));
    }

    private boolean checkTaskIsPublished(Object[] pks) {
        if (pks == null || pks.length == 0) {
            return false;
        }
        QFilter filter1 = new QFilter("id", "in", (Object)pks);
        QFilter filter2 = new QFilter("templatestatus", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)FORM_APPLYTEMPLATE, (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
        return query.size() > 0;
    }

    private void copyTemplate() {
        BillList list = (BillList)this.getControl(BILLLISTID);
        if (list.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"ApplyTemplateListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<String> numberset = new HashSet<String>(16);
        HashSet<String> nameset = new HashSet<String>(16);
        QFilter modelqfilter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)this.getModelIdFromCache()));
        try (DataSet alldata = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)FORM_APPLYTEMPLATE, (String)"name, number", (QFilter[])new QFilter[]{modelqfilter}, null);){
            while (alldata.hasNext()) {
                Row row = alldata.next();
                numberset.add(row.getString("number"));
                nameset.add(row.getString("name"));
            }
        }
        Map dynas = list.getModel().loadReferenceDataBatch((DynamicObjectType)list.getEntityType(), list.getSelectedRows().getPrimaryKeyValues());
        HashSet<DynamicObject> dynamicObjects = new HashSet<DynamicObject>(dynas.values());
        this.copyTemplate(dynamicObjects, nameset, numberset);
        this.writeLog("copy", new MultiLangEnumBridge("\u590d\u5236", "OffsetPaperPlugin_24", "epm-eb-formplugin"), new MultiLangEnumBridge("\u590d\u5236\u6a21\u677f\u6210\u529f", "ApplyTemplateListPlugin_28", "epm-eb-formplugin"));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"ExamineListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refrushBillList();
    }

    private void copyTemplate(Set<DynamicObject> dynamictemplate, Set<String> nameset, Set<String> numberset) {
        Object[] saveObjs;
        if (CollectionUtils.isEmpty(dynamictemplate)) {
            return;
        }
        ArrayList<String> numberlist = new ArrayList<String>(dynamictemplate.size());
        ArrayList<DynamicObject> tosaveebobjs = new ArrayList<DynamicObject>(dynamictemplate.size());
        HashMap templateCopyColumnKeyMap = new HashMap(16);
        HashMap<String, Long> copyOldIdMap = new HashMap<String, Long>(16);
        for (DynamicObject ebtemplateobj : dynamictemplate) {
            DynamicObject cloneobj = (DynamicObject)OrmUtils.clone((IDataEntityBase)ebtemplateobj, (boolean)true, (boolean)true);
            String temp_name = cloneobj.getString("name");
            String name = temp_name.length() > 46 ? temp_name.substring(0, 45) + "copy" : temp_name + "copy";
            cloneobj.set("name", (Object)this.getCopyName(name, nameset, 1));
            nameset.add(cloneobj.getString("name"));
            String temp_number = cloneobj.getString("number");
            String number = temp_number.length() > 26 ? temp_number.substring(0, 25) + "copy" : temp_number + "copy";
            cloneobj.set("number", (Object)this.getCopyNumber(number, numberset, 1));
            numberset.add(cloneobj.getString("number"));
            numberlist.add(cloneobj.getString("number"));
            String entrycfgjson_tag = ebtemplateobj.getString("entrycfgjson_tag");
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)entrycfgjson_tag, ColumnList.class);
            Collection columnsCopy = columnList.getColumns();
            HashMap<String, String> columnKeyMap = new HashMap<String, String>();
            HashMap<String, Set> bizTableColumnKeys = new HashMap<String, Set>(16);
            for (BaseColumn col : columnsCopy) {
                String oldKey;
                if (StringUtils.equals((String)col.getCategory(), (String)"h")) {
                    oldKey = col.getKey();
                    String string = "h_" + Uuid8.generateShortUuid().toLowerCase();
                    columnKeyMap.put(oldKey, string);
                    col.setKey(string);
                    continue;
                }
                if (!StringUtils.equals((String)col.getCategory(), (String)"e")) continue;
                oldKey = col.getKey();
                String string = "e_" + Uuid8.generateShortUuid().toLowerCase();
                columnKeyMap.put(oldKey, string);
                Set bizColumnKeys = bizTableColumnKeys.computeIfAbsent(col.getBizPlanTabKey(), e -> new HashSet());
                bizColumnKeys.add(string);
                col.setKey(string);
            }
            templateCopyColumnKeyMap.put(cloneobj.getString("number"), columnKeyMap);
            copyOldIdMap.put(cloneobj.getString("number"), ebtemplateobj.getLong("id"));
            for (Object baseColumn : columnsCopy) {
                MeasureColumn column1;
                if (baseColumn instanceof MeasureColumn) {
                    column1 = (MeasureColumn)baseColumn;
                    if (!column1.isIssummary()) continue;
                    column1.setHcolumnkey((String)columnKeyMap.get(column1.getHcolumnkey()));
                    continue;
                }
                if (baseColumn instanceof NumberColumn) {
                    column1 = (NumberColumn)baseColumn;
                    if (!column1.isIssummary()) continue;
                    column1.setHcolumnkey((String)columnKeyMap.get(column1.getHcolumnkey()));
                    continue;
                }
                if (baseColumn instanceof CalculateColumn) {
                    column1 = (CalculateColumn)baseColumn;
                    if (!column1.isIssummary()) continue;
                    column1.setHcolumnkey((String)columnKeyMap.get(column1.getHcolumnkey()));
                    continue;
                }
                if (!(baseColumn instanceof RelationValueColumn) || !(column1 = (RelationValueColumn)baseColumn).isIssummary()) continue;
                column1.setHcolumnkey((String)columnKeyMap.get(column1.getHcolumnkey()));
            }
            ApplyTemplateUtils.replaceKeyForformula(columnKeyMap, (Collection)columnsCopy);
            List bizTableConfigList = columnList.getBizTableConfigList();
            if (CollectionUtils.isNotEmpty((Collection)bizTableConfigList)) {
                Object baseColumn;
                baseColumn = bizTableConfigList.iterator();
                while (baseColumn.hasNext()) {
                    BizTableConfig bizTableConfig = (BizTableConfig)baseColumn.next();
                    bizTableConfig.setColumnKeys((Set)bizTableColumnKeys.get(bizTableConfig.getTabKey()));
                }
            }
            columnList.setColumns(columnsCopy);
            Map entityInfoMap = columnList.getEntityinfomap();
            entityInfoMap.put(KEY_MAINENTRYENTITY, "");
            entityInfoMap.put(KEY_BIZMAINENTRYENTITY, "");
            for (Map.Entry entry : entityInfoMap.entrySet()) {
                String fullTableName;
                List collect;
                String entity = (String)entry.getKey();
                String tableEndName = Uuid8.generateShortUuid().toLowerCase();
                if (KEY_MAINENTRYENTITY.equals(entity)) {
                    collect = columnsCopy.stream().filter(temp -> "h".equals(temp.getCategory())).collect(Collectors.toList());
                    fullTableName = ApplyTemplateHelper.createBillEntityTable(collect, (String)tableEndName, (boolean)false);
                    entry.setValue(fullTableName);
                    continue;
                }
                if (!KEY_BIZMAINENTRYENTITY.equals(entity)) continue;
                collect = columnsCopy.stream().filter(temp -> "e".equals(temp.getCategory())).collect(Collectors.toList());
                fullTableName = ApplyTemplateHelper.createBillEntityTable(collect, (String)tableEndName, (boolean)true);
                entry.setValue(fullTableName);
            }
            cloneobj.set("entrycfgjson_tag", (Object)SerializationUtils.toJsonString((Object)columnList));
            cloneobj.set("idmap", ebtemplateobj.get("idmap"));
            cloneobj.set("cachedata_tag", ebtemplateobj.get("cachedata_tag"));
            cloneobj.set("model", (Object)ebtemplateobj.getDynamicObject("model"));
            cloneobj.set("dataset", (Object)ebtemplateobj.getDynamicObject("dataset"));
            cloneobj.set("templatetype", (Object)ebtemplateobj.getDynamicObject("templatetype"));
            cloneobj.set("templatestatus", (Object)"0");
            cloneobj.set("creator_id", (Object)Long.parseLong(RequestContext.getOrCreate().getUserId()));
            cloneobj.set("modifier_id", (Object)Long.parseLong(RequestContext.getOrCreate().getUserId()));
            cloneobj.set("modifyTime", (Object)TimeServiceHelper.now());
            cloneobj.set("createTime", (Object)TimeServiceHelper.now());
            cloneobj.set("amountunit", ebtemplateobj.get("amountunit"));
            tosaveebobjs.add(cloneobj);
        }
        this.queryTemplateNumberRepeat(numberlist.toArray(new String[0]));
        for (Object saveObj : saveObjs = SaveServiceHelper.save((DynamicObject[])tosaveebobjs.toArray(new DynamicObject[0]))) {
            DynamicObject copyTemplateObj = (DynamicObject)saveObj;
            String copyNumber = copyTemplateObj.getString("number");
            long copyId = copyTemplateObj.getLong("id");
            Long sourceId = (Long)copyOldIdMap.get(copyNumber);
            List colCfgList = ApplyTemplateColCfgService.getInstance().getColCfgListByTemplateId(sourceId);
            List dimCfgList = ApplyTemplateDimCfgService.getInstance().getDimCfgListByTemplateId(sourceId.longValue());
            Map copyMap = (Map)templateCopyColumnKeyMap.get(copyNumber);
            ArrayList<ApplyTemplateColCfgEntity> copyColCfgList = new ArrayList<ApplyTemplateColCfgEntity>(16);
            for (ApplyTemplateColCfgEntity applyTemplateColCfgEntity : colCfgList) {
                applyTemplateColCfgEntity.setApplytemplateid(Long.valueOf(copyId));
                applyTemplateColCfgEntity.setApplytemplatenumber(copyNumber);
                String copyColKey = (String)copyMap.get(applyTemplateColCfgEntity.getColkey());
                applyTemplateColCfgEntity.setColkey(copyColKey);
                copyColCfgList.add(applyTemplateColCfgEntity);
            }
            ArrayList<ApplyTemplateDimCfgEntity> copyDimCfgList = new ArrayList<ApplyTemplateDimCfgEntity>(16);
            for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgList) {
                applyTemplateDimCfgEntity.setApplytemplateid(Long.valueOf(copyId));
                applyTemplateDimCfgEntity.setApplytemplatenumber(copyNumber);
                copyDimCfgList.add(applyTemplateDimCfgEntity);
            }
            List list = copyDimCfgList.stream().filter(t -> StringUtils.equals((String)t.getUsetype(), (String)DimUseTypeEnum.BUSINESS_PLAN.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)) {
                ApplyTemplateTableCfgEntity copyTableCfg = ApplyTemplateTableCfgService.getInstance().getTableCfgByTemplateId(sourceId);
                copyTableCfg.setApplytemplateid(Long.valueOf(copyId));
                copyTableCfg.setApplytemplatenumber(copyNumber);
                String columnjson = copyTableCfg.getColumnjson();
                List tableColumnsMap = (List)SerializationUtils.fromJsonString((String)columnjson, List.class);
                List tableColumns = tableColumnsMap.stream().map(t -> (TableColumn)SerializationUtils.getObjectMapper2().convertValue(t, TableColumn.class)).collect(Collectors.toList());
                String copyTableName = TableHelper.createTable(tableColumns);
                copyTableCfg.setTablename(copyTableName);
                Long tableCfgId = ApplyTemplateTableCfgService.getInstance().save(copyTableCfg);
                for (ApplyTemplateDimCfgEntity businessPlanDim : list) {
                    businessPlanDim.setTablecfgid(tableCfgId);
                }
                List dimRangeRecords = ApplyTemplateDimRangeService.getInstance().getDimRangeRecords(sourceId.longValue(), null);
                if (CollectionUtils.isNotEmpty((Collection)dimRangeRecords)) {
                    for (Map dimRangeRecord : dimRangeRecords) {
                        Object oldMainBudgetInfo = dimRangeRecord.get(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey());
                        if (oldMainBudgetInfo == null) continue;
                        String newMainBudgetInfo = (String)copyMap.get(oldMainBudgetInfo.toString());
                        dimRangeRecord.put(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey(), newMainBudgetInfo);
                    }
                    ApplyTemplateDimRangeService.getInstance().saveDimRange(dimRangeRecords, copyTableCfg);
                }
            }
            ApplyTemplateColCfgService.getInstance().save(copyColCfgList);
            ApplyTemplateDimCfgService.getInstance().save(copyDimCfgList);
        }
    }

    private void queryTemplateNumberRepeat(String[] numbers) {
        QFilter qfnumber;
        QFilter qmodel = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection numberCol = QueryServiceHelper.query((String)"eb_templateentity", (String)"number", (QFilter[])new QFilter[]{qmodel, qfnumber = new QFilter("number", "in", (Object)numbers)});
        if (numberCol != null && numberCol.size() > 0) {
            ArrayList<String> tip = new ArrayList<String>(16);
            for (DynamicObject num : numberCol) {
                tip.add(num.getString("number"));
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u6240\u9009\u6570\u636e\u590d\u5236\u65f6\u4f1a\u4ea7\u751f\u91cd\u590d\u7684\u7f16\u7801\uff1a\u201c%1\u201d\u3002", (String)"BgTemplateListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", tip)}));
        }
    }

    private String getCopyName(String name, Set<String> nameset, int i) {
        if (nameset.contains(name)) {
            if (name.length() > 46) {
                name = name.substring(0, 39);
                name = name + "copy" + i;
            } else {
                char ss = name.charAt(name.length() - 1);
                try {
                    Integer.parseInt(String.valueOf(ss));
                    name = name.substring(0, name.length() - 1) + i;
                }
                catch (NumberFormatException e) {
                    name = name + i;
                }
            }
            return this.getCopyName(name, nameset, i + 1);
        }
        return name;
    }

    private String getCopyNumber(String number, Set<String> numberset, int i) {
        if (numberset.contains(number)) {
            if (number.length() > 26) {
                number = number.substring(0, 19);
                number = number + "copy" + i;
            } else {
                char ss = number.charAt(number.length() - 1);
                try {
                    Integer.parseInt(String.valueOf(ss));
                    number = number.substring(0, number.length() - 1) + i;
                }
                catch (NumberFormatException e) {
                    number = number + i;
                }
            }
            return this.getCopyNumber(number, numberset, i + 1);
        }
        return number;
    }

    private void openApplyTemplatePage() {
        if (!this.validator()) {
            return;
        }
        String modelid = this.getModelIdFromCache();
        TreeView treeView = (TreeView)this.getControl(TEMPLATECATALOG_TREE);
        String applyTemplatelogId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)applyTemplatelogId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6a21\u677f\u5206\u7c7b\u3002", (String)"ApplyTemplateListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, APPLYTEMPLATE_ADD_CLOSEBACK);
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(FORM_APPLYTEMPLATE);
        baseShowParameter.setCloseCallBack(closeCallBack);
        baseShowParameter.setParentPageId(this.getView().getPageId());
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setCustomParam(KEY_MODEL_ID, (Object)modelid);
        baseShowParameter.setCustomParam("templatetype", (Object)applyTemplatelogId);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f", (String)"ApplyTemplateListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void click(EventObject e) {
        super.click(e);
        String nodeId = ((TreeView)this.getControl(TEMPLATECATALOG_TREE)).getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6a21\u677f\u5206\u7c7b\u3002", (String)"ApplyTemplateListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Control c = (Control)e.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btn_addnew": {
                this.newApplyTemplatelog(nodeId, true);
                break;
            }
            case "btn_modify": {
                this.newApplyTemplatelog(nodeId, false);
                break;
            }
            case "btn_delete": {
                if (this.isRootApplylog(nodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"ApplyTemplateListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6a21\u7248\u5206\u7c7b\uff1f", (String)"ApplyTemplateListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(APPLYTEMPLATELOG_DELETE_COMFIRM, (IFormPlugin)this));
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(TEMPLATECATALOG_TREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(TEMPLATECATALOG_TREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "btn_up": 
            case "btn_down": {
                this.downAndUpMember(c.getKey().toLowerCase());
                break;
            }
        }
    }

    private void downAndUpMember(String key) {
        TreeView treeView = (TreeView)this.getView().getControl(TEMPLATECATALOG_TREE);
        TreeView.TreeState treeState = treeView.getTreeState();
        String selectNodeId = treeState.getFocusNodeId();
        if (StringUtils.isEmpty((String)selectNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6a21\u677f\u5206\u7c7b\u3002", (String)"ApplyTemplateListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long currentnodeid = Long.parseLong(selectNodeId);
        TreeModel treemodel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        TemplateCataLogTree current_templateCataLogTree = (TemplateCataLogTree)treemodel.searchByNodeId(currentnodeid);
        TemplateCataLogTree parent = (TemplateCataLogTree)current_templateCataLogTree.getParent();
        boolean issuccess = false;
        if (parent == null || parent.getChildren().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"ApplyTemplateListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (parent.getChildren().size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5206\u7c7b\u7684\u7236\u8282\u70b9\u53ea\u6709\u4e00\u4e2a\u4e0b\u7ea7\u8282\u70b9\uff0c\u4e0d\u80fd\u4e0a\u79fb\u4e0b\u79fb\u3002", (String)"ApplyTemplateListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            ArrayList brothers = new ArrayList(parent.getChildren());
            ArrayList<TemplateCataLogTree> newbrothers = new ArrayList<TemplateCataLogTree>(brothers.size());
            for (TemplateCataLogTree brother : brothers) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)FORM_APPLYTEMPLATELOG, (String)"sequence", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)brother.getId())});
                int seq = (Integer)((DynamicObject)query.get(0)).get("sequence");
                brother.setSeq(seq);
                newbrothers.add(brother);
            }
            int index = newbrothers.indexOf(current_templateCataLogTree);
            if ("btn_up".equals(key) && index == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"ApplyTemplateListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if ("btn_down".equals(key) && index == newbrothers.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u4e0b\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"ApplyTemplateListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                TemplateCataLogTree toswap = null;
                toswap = "btn_up".equals(key) ? (TemplateCataLogTree)newbrothers.get(index - 1) : (TemplateCataLogTree)newbrothers.get(index + 1);
                this.swapTemplateCatalog(current_templateCataLogTree, toswap);
                issuccess = true;
            }
        }
        if (issuccess) {
            TreeNode selecttreeNode = new TreeNode(String.valueOf(current_templateCataLogTree.getParent().getId()), selectNodeId, null);
            this.refrushTree(selecttreeNode);
        }
    }

    private void swapTemplateCatalog(TemplateCataLogTree current_templateCataLogTree, TemplateCataLogTree toswap) {
        DynamicObject[] objs;
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{current_templateCataLogTree.getId(), toswap.getId()});
        for (DynamicObject obj : objs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)ORM.create().newDynamicObject(FORM_APPLYTEMPLATELOG).getDataEntityType())) {
            if (obj.getLong("id") == current_templateCataLogTree.getId().longValue()) {
                obj.set("sequence", (Object)toswap.getSeq());
                continue;
            }
            obj.set("sequence", (Object)current_templateCataLogTree.getSeq());
        }
        SaveServiceHelper.save((DynamicObject[])objs);
        this.writeLog("update", new MultiLangEnumBridge("\u4fee\u6539", "ApplyTemplateListPlugin_23", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fee\u6539\u6a21\u677f\u6210\u529f", "ApplyTemplateListPlugin_24", "epm-eb-formplugin"));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (this.getModelSign().equals(key) && this.getControl(this.getModelSign()) != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refrushBillList();
                break;
            }
            case "modelbd": {
                Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"modelbd");
                if (modelId == null || modelId == 0L) {
                    this.getModel().setValue("modelbd", (Object)this.getPageCache().get(KEY_MODEL_ID));
                    break;
                }
                if (String.valueOf(modelId).equals(this.getPageCache().get(KEY_MODEL_ID))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.cacheModelId(modelId);
                this.refreshTreeAndBillListData();
                break;
            }
        }
    }

    public void refresh() {
    }

    private void refreshTreeAndBillListData() {
        this.refrushTree(null);
        this.refrushBillList();
    }

    private TreeModel refrushTree(TreeNode selecttreeNode) {
        TreeView treeview = (TreeView)this.getControl(TEMPLATECATALOG_TREE);
        String modelID = this.getModelIdFromCache();
        TemplateCataLogTree root = ApplyTemplateListPlugin.getTemplateCataTree(Long.parseLong(modelID), ((Object)((Object)this)).getClass().getName());
        TreeModel treeModel = new TreeModel((ITreeNode)root);
        TreeNode treeNode = treeModel.buildEntryTree(treeview);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)treeNode));
        TreeSearchUtil.clearSearchPageCache((IPageCache)this.getPageCache(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam());
        treeModel.cache2page(this.getPageCache());
        if (selecttreeNode == null) {
            treeview.focusNode(new TreeNode(null, String.valueOf(root.getId()), null));
        } else {
            treeview.focusNode(selecttreeNode);
        }
        return treeModel;
    }

    private void refrushBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTID);
        billList.setClearSelection(true);
        billList.refresh();
    }

    private QFilter getBillListQfilter() {
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        String focusnodeid = ((TreeView)this.getControl(TEMPLATECATALOG_TREE)).getTreeState().getFocusNodeId();
        if (focusnodeid != null) {
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue("treecheckbox").toString());
            if (isallchild) {
                TreeModel treemodel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
                if (treemodel != null) {
                    List childrenids = treemodel.seekChildrenByGivenNodeIds(Long.valueOf(Long.parseLong(focusnodeid)), true);
                    qFilter.and("templatetype", "in", (Object)childrenids);
                }
            } else {
                qFilter.and("templatetype", "=", (Object)Long.parseLong(focusnodeid));
            }
        }
        return qFilter;
    }

    private void cacheModelId(Long modelId) {
        this.getPageCache().put(KEY_MODEL_ID, modelId.toString());
    }

    private String getModelIdFromCache() {
        return this.getPageCache().get(KEY_MODEL_ID);
    }

    public static TemplateCataLogTree getTemplateCataTree(Long modelid, String algokey) {
        String selectFields = "id,name,number,parent,longnumber";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "sequence";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)FORM_APPLYTEMPLATELOG, (String)selectFields, (QFilter[])filters, (String)orderBys);
        TemplateCataLogTree tree = TemplateCataLogTreeBuilder.getCommomTree((List)dys);
        if (tree == null) {
            tree = TemplateCataLogTreeBuilder.createRootApplyTemplateLogTree((Long)modelid, (String)FORM_APPLYTEMPLATELOG);
        }
        return tree;
    }

    private void newApplyTemplatelog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String modelid = this.getModelIdFromCache();
        params.put("model", modelid);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, APPLYTEMPLATELOG_ADD_CLOSEBACK);
        if (isAddNew) {
            long id = Long.parseLong(nodeId);
            params.put("parent", id);
            this.showApplyTemplatelogForm(FORM_APPLYTEMPLATELOG, params, closeCallBack, ShowType.Modal, 0L);
        } else if (this.isRootApplylog(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ApplyTemplateListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            long id = Long.parseLong(nodeId);
            this.showApplyTemplatelogForm(FORM_APPLYTEMPLATELOG, params, closeCallBack, ShowType.Modal, id);
        }
    }

    private void showApplyTemplatelogForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public boolean isRootApplylog(String nodeid) {
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        ITreeNode treenode = treeModel.searchByNodeId(Long.valueOf(Long.parseLong(nodeid)));
        return treenode != null && (treenode.getParent() == null || treenode.getParent().getId() == 0L);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "applytemplatelog_add_closeback": {
                Long nodeid;
                ArrayList ids;
                ArrayList arrayList = ids = closedCallBackEvent.getReturnData() == null ? null : (ArrayList)closedCallBackEvent.getReturnData();
                if (ids == null || ids.size() <= 0) break;
                TreeModel treeModel = this.refrushTree(null);
                ITreeNode currentnode = treeModel.searchByNodeId(nodeid = (Long)ids.get(0));
                String parentid = currentnode.getParent() == null ? null : currentnode.getParent().getId().toString();
                TreeView treeview = (TreeView)this.getControl(TEMPLATECATALOG_TREE);
                treeview.focusNode(new TreeNode(parentid, String.valueOf(nodeid), null));
                this.refrushBillList();
                break;
            }
            case "applytemplate_move_closeback": {
                if (closedCallBackEvent.getReturnData() == null) break;
                Long focustemplatecatalogid = Long.parseLong((String)closedCallBackEvent.getReturnData());
                TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
                if (treeModel == null) break;
                ITreeNode templatecatalog_treenode = treeModel.searchByNodeId(focustemplatecatalogid);
                Long parentid = templatecatalog_treenode.getParent() == null ? Long.valueOf(0L) : templatecatalog_treenode.getParent().getId();
                TreeNode treenode = new TreeNode(String.valueOf(parentid), String.valueOf(templatecatalog_treenode.getId()), null);
                ((TreeView)this.getControl(TEMPLATECATALOG_TREE)).focusNode(treenode);
                this.refrushBillList();
                break;
            }
            case "applytemplate_add_closeback": {
                this.refrushBillList();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals(APPLYTEMPLATELOG_DELETE_COMFIRM)) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG_TREE);
                TreeModel treemodel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
                if (treemodel == null) {
                    return;
                }
                ITreeNode currenttreenode = treemodel.searchByNodeId(Long.valueOf(Long.parseLong(tree.getTreeState().getFocusNodeId())));
                List childids = treemodel.seekChildrenByGivenNodeIds(currenttreenode.getId(), true);
                boolean can = this.checkTemplateCanBeDeleted(childids);
                if (!can) {
                    return;
                }
                String idstrings = this.toListString(childids.iterator());
                StringBuilder sql = new StringBuilder();
                sql.append("update t_eb_applytemplate set ftemplatetypeid = ").append(currenttreenode.getParent().getId()).append(" where ftemplatetypeid in ").append(idstrings);
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString());
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORM_APPLYTEMPLATELOG), (Object[])childids.toArray());
                this.refrushTree(null);
                this.refrushBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ApplyTemplateListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (callBackId.equals(APPLYTEMPLATE_DELETE_COMFIRM) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            try (TXHandle th = TX.required();){
                try {
                    BillList billList = (BillList)this.getView().getControl(BILLLISTID);
                    Object[] selectids = billList.getSelectedRows().getPrimaryKeyValues();
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORM_APPLYTEMPLATE), (Object[])selectids);
                    Set collect = Arrays.stream(selectids).map(IDUtils::toLong).collect(Collectors.toSet());
                    ApplyTemplateColCfgService.getInstance().deletes(collect);
                    ApplyTemplateDimCfgService.getInstance().deletes(collect);
                    ApplyTemplateTableCfgService.getInstance().deletes(collect);
                    ApplyTemplateTableCfgService.getInstance().dropTable(collect);
                    TemplatePermServiceHelper.deleteRefTemplatePermRecord((String)"applytemplate", collect);
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.ApplyTemplate.getType(), Arrays.asList(selectids)});
                    this.refrushBillList();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ApplyTemplateListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    th.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    private void movetemplate() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTID);
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u8bb0\u5f55\u3002", (String)"ApplyTemplateListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusnodeid = ((TreeView)this.getControl(TEMPLATECATALOG_TREE)).getTreeState().getFocusNodeId();
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        if (treeModel == null || treeModel.getRoot() == null || treeModel.getRoot().getChildren().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u79fb\u52a8\u5230\u7684\u6a21\u677f\u5206\u7c7b\uff0c\u8bf7\u5148\u65b0\u589e\u6a21\u677f\u5206\u7c7b\u3002", (String)"ApplyTemplateListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String modelkey = this.getModelIdFromCache();
        Object[] focusedids = billList.getSelectedRows().getPrimaryKeyValues();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(APPLYTEMPLATEMOVE);
        showParameter.setCustomParam(KEY_MODEL_ID, (Object)modelkey);
        showParameter.setCustomParam("cataLogType", (Object)Character.valueOf(TemplateCatalogTypeEnum.TEMPLATECATALOG.getType()));
        showParameter.setCustomParam("nodeid", (Object)focusnodeid);
        showParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
        showParameter.setCustomParam("focustemplateids", (Object)ObjectSerialUtil.toByteSerialized((Object)focusedids));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, APPLYTEMPLATE_MOVE_CLOSEBACK);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void checkTemplateIsOpen() {
        BillList billList = (BillList)this.getControl(BILLLISTID);
        Object[] templateids = billList.getSelectedRows().getPrimaryKeyValues();
        this.checkTemplateIsOpenByTemplateIds(templateids);
    }

    private void checkTemplateIsOpenByTemplateIds(Object[] templateids) {
        Long modelid = this.getModelId();
        for (Object templateId : templateids) {
            if (templateId == null) continue;
            TemplateMutexServiceHelper.checkApplytemplateIsLock((Long)Long.valueOf(templateId + ""), (Long)modelid);
        }
    }

    private boolean checkTemplateCanBeDeleted(List<Long> childids) {
        boolean can = true;
        if (childids.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5b50\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"ApplyTemplateListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            can = false;
        } else {
            QFilter qFilter = new QFilter("templatetype", "in", childids);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)FORM_APPLYTEMPLATE, (String)"model, number", (QFilter[])new QFilter[]{qFilter}, null);
            if (dataSet != null && dataSet.hasNext()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ea7\u8282\u70b9\u4e0b\u5b58\u5728\u7533\u62a5\u6a21\u677f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ApplyTemplateListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                can = false;
            }
        }
        return can;
    }

    private String getModelSign() {
        return "modelbd";
    }

    public String toListString(Iterator<Long> iterator) {
        if (!iterator.hasNext()) {
            return "()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        while (true) {
            Long e = iterator.next();
            sb.append(e);
            if (!iterator.hasNext()) {
                return sb.append(')').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private boolean validator() {
        String modulid = this.getPageCache().get(KEY_MODEL_ID);
        if (StringUtils.isEmpty((String)modulid)) {
            this.getView().showTipNotification(ApplyTemplateListPlugin.getMODEL_NOTEXISTS());
            return false;
        }
        return true;
    }

    private static String getMODEL_NOTEXISTS() {
        return ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"ApplyTemplateListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    public Long getModelId() {
        return (Long)this.getValue("modelbd", "id");
    }
}

