/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimAreaCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimCfgService;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeAssignService;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.TempDimConfigType;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.DimFlexInfo;
import kd.epm.eb.common.applybill.ApplyTempStatusEnum;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.ApplyTemplateConstant;
import kd.epm.eb.common.enums.ApplyDimAreaPanelEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ApplyTemplateMasterEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
MainPage,
ApplyTemplateConstant {
    private static final String KEY_MODEL_ID = "KEY_MODEL_ID";
    private static final ApplyTemplateDimAreaCfgService dimAreaCfgService = ApplyTemplateDimAreaCfgService.getInstance();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long dateSetId = this.getDateSetId();
        if (IDUtils.isNotEmptyLong((Long)dateSetId).booleanValue()) {
            this.openDimAreaSettingForm(dateSetId);
            this.cacheOldColumnKeys(false);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        model.setValue("model", map.get(KEY_MODEL_ID));
        model.setValue("templatetype", map.get("templatetype"));
        model.setValue("status", (Object)"A");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        this.checkTemplateDeleted();
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if ("save".equals(key)) {
            Object name = this.getModel().getValue("name");
            if (name instanceof OrmLocaleValue) {
                OrmLocaleValue nameOrm = (OrmLocaleValue)name;
                String nameStr = nameOrm.get((Object)"zh_CN");
                this.checkIllegalCharacter(nameStr, true);
            }
            this.beforeDoSave(e);
        } else if ("bar_publish".equals(key)) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u90e8\u5206\u4fee\u6539\u7684\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"ApplyTemplateMasterEditPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                this.updateBizStatus("1");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"ApplyTemplateMasterEditPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void updateBizStatus(String status) {
        Long templateId = this.getModel().getDataEntity().getLong("id");
        if (IDUtils.isEmptyLong((Long)templateId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ApplyTemplateMasterEditPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)templateId, (DynamicObjectType)this.getModel().getDataEntityType());
        if (model != null) {
            model.set("templatestatus", (Object)status);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
            this.getModel().setValue("templatestatus", (Object)status);
            this.getModel().setDataChanged(false);
        }
        if ("1".equals(status)) {
            String traceId = RequestContext.getOrCreate().getTraceId();
            EpmThreadPools.RULE_EXECUTION_POOL.execute(() -> {
                RequestContext.getOrCreate().setTraceId(traceId);
                Long modelId = this.getModelId();
                Long dateSetId = this.getDateSetId();
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Long busModelId = modelCache.getBusModelByDataSet(dateSetId);
                RuleRelationService.getInstance().bindRuleToApplyTemplate(Collections.singletonList(model), busModelId.longValue(), false);
            });
        } else {
            QFilter delFilter = new QFilter("template", "=", (Object)templateId);
            DeleteServiceHelper.delete((String)"eb_applytemplaterule", (QFilter[])delFilter.toArray());
        }
    }

    private void beforeDoSave(BeforeDoOperationEventArgs e) {
        String number = (String)this.getModel().getValue("number");
        if (!CheckStringsUtil.checkNumber((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u4ee5\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u5c0f\u6570\u70b9\u7ec4\u6210\uff0c\u4e14\u4e0d\u80fd\u5b58\u5728\u4e24\u4e2a\u8fde\u7eed\u7684\u5c0f\u6570\u70b9\u4ee5\u53ca\u4ee5\u5c0f\u6570\u70b9\u5f00\u5934\u548c\u7ed3\u5c3e\u3002", (String)"ApplyTemplateMasterEditPlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (this.checkNumberExist(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApplyTemplateMasterEditPlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (this.checkDimAreaInfoCompleted()) {
            e.setCancel(true);
            return;
        }
        this.addOldColumnKeysToParam(e);
        this.getModel().setValue("idmap", (Object)this.getPageCache().get("idmap"));
    }

    private boolean checkDimAreaInfoCompleted() {
        String columnInfoCache;
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String mainDimFlexInfo = (String)this.getModel().getValue("cachedata_tag");
        DimFlexInfo dimFlexInfo = new DimFlexInfo();
        if (mainDimFlexInfo != null) {
            List tempDimConfigList = SerializationUtils.fromJsonStringToList((String)mainDimFlexInfo, TempDimConfig.class);
            for (TempDimConfig dimConfig : tempDimConfigList) {
                if (TempDimConfigType.HIDEDIM.getValue().equals(dimConfig.getPanel())) {
                    Dimension dimension = orCreate.getDimension(dimConfig.getDimensionNumber());
                    if (StringUtils.isEmpty((CharSequence)dimConfig.getMemberId()) && dimension != null) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e3b\u8868\u5355\u9690\u85cf\u7ef4\u5ea6\u201c%1\u201d\u6210\u5458\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
                        return true;
                    }
                }
                dimFlexInfo.addDimConfig(dimConfig);
            }
        }
        if ((columnInfoCache = (String)this.getModel().getValue("entrycfgjson_tag")) != null) {
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)columnInfoCache, ColumnList.class);
            Collection columns = columnList.getColumns();
            if (this.checkMainFormColumnsInfoCompleted(dimFlexInfo, orCreate, columns)) {
                return true;
            }
            if (this.checkBizFormInfoCompleted(orCreate, columnList, columns)) {
                return true;
            }
            if (this.checkColumnDataMapDimension(orCreate, columns)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkColumnDataMapDimension(IModelCacheHelper modelCacheHelper, Collection<BaseColumn> columns) {
        HashSet<String> dataMapDimensionString = new HashSet<String>(16);
        for (BaseColumn column : columns) {
            List dataMapDimensions;
            if (!dimAreaCfgService.isShowDataDimensionMappingColumn(column) || !ApplyDimAreaPanelEnum.MAIN.getColumnCategory().equals(column.getCategory()) || dimAreaCfgService.auditTrailIsNoLeaf(modelCacheHelper, dataMapDimensions = dimAreaCfgService.getColumnDataMapDimensions(column)) || dataMapDimensions == null || dataMapDimensionString.add(dataMapDimensions.toString())) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e3b\u8868\u5355\u7684\u5217\u201c%1\u201d\u6570\u636e\u5bf9\u5e94\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u5176\u4ed6\u5217\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ApplyTemplateMasterEditPlugin_07", (String)"epm-eb-formplugin", (Object[])new Object[]{column.getTitle()}));
            return true;
        }
        return false;
    }

    private boolean checkMainFormColumnsInfoCompleted(DimFlexInfo dimFlexInfo, IModelCacheHelper orCreate, Collection<BaseColumn> columns) {
        String category = ApplyDimAreaPanelEnum.MAIN.getColumnCategory();
        Set colDims = dimFlexInfo.getColDims();
        List mainFormColumns = columns.stream().filter(e -> category.equals(e.getCategory())).collect(Collectors.toList());
        HashSet<String> existTitles = new HashSet<String>(16);
        for (BaseColumn mainFormColumn : mainFormColumns) {
            List columnDataMapDimensions;
            RowDimensionColumn rowDimensionColumn;
            List dimensionMemberRanges;
            String title = mainFormColumn.getTitle();
            if (StringUtils.isEmpty((CharSequence)title)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u8868\u5355\u5217\u7ef4\u5ea6\u7684\u5217\u6807\u9898\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (!existTitles.add(title)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e3b\u8868\u5355\u5217\u6807\u9898\u201c%1\u201d\u5b58\u5728\u91cd\u590d\u3002", (String)"ApplyTemplateMasterEditPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{title}));
                return true;
            }
            if (mainFormColumn instanceof RowDimensionColumn && CollectionUtils.isEmpty((Collection)(dimensionMemberRanges = (rowDimensionColumn = (RowDimensionColumn)mainFormColumn).getDimensionMemberRanges()))) {
                Dimension dimension = orCreate.getDimension(rowDimensionColumn.getDimNumber());
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e3b\u8868\u5355\u884c\u7ef4\u5ea6\u201c%1\u201d\u6210\u5458\u8303\u56f4\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_08", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension == null ? "" : dimension.getName()}));
                return true;
            }
            if (!dimAreaCfgService.isShowDataDimensionMappingColumn(mainFormColumn) || (columnDataMapDimensions = dimAreaCfgService.getColumnDataMapDimensions(mainFormColumn)) == null) continue;
            for (DataMapDimension dataMapDimension : columnDataMapDimensions) {
                if (!colDims.contains(dataMapDimension.getDimNum()) || !IDUtils.isEmptyLong((Long)dataMapDimension.getDimensionRememberId()).booleanValue()) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e3b\u8868\u5355\u5217\u7ef4\u5ea6\u201c%1\u201d\u5217\u7684\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{title}));
                return true;
            }
        }
        return false;
    }

    private boolean checkBizFormInfoCompleted(IModelCacheHelper orCreate, ColumnList columnList, Collection<BaseColumn> columns) {
        List bizTableConfigList = columnList.getBizTableConfigList();
        for (BizTableConfig bizTableConfig : bizTableConfigList) {
            String tabKey = bizTableConfig.getTabKey();
            DimFlexInfo dimFlexInfo = bizTableConfig.getDimFlexInfo();
            List bizFormColumns = columns.stream().filter(e -> tabKey.equals(e.getBizPlanTabKey())).collect(Collectors.toList());
            if (bizFormColumns.isEmpty()) continue;
            boolean existDimensionDataColumn = bizFormColumns.stream().anyMatch(e -> e instanceof DimensionDataColumn);
            Map hidDimConfig = dimFlexInfo.getHidDimConfig();
            for (TempDimConfig dimConfig : hidDimConfig.values()) {
                if (!existDimensionDataColumn || !StringUtils.isEmpty((CharSequence)dimConfig.getMemberId())) continue;
                Dimension dimension = orCreate.getDimension(dimConfig.getDimensionNumber());
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u201c%1\u201d\u9690\u85cf\u7ef4\u5ea6\u201c%2\u201d\u6210\u5458\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{bizTableConfig.getTabName(), dimension == null ? "" : dimension.getName()}));
                return true;
            }
            HashSet<String> existTitles = new HashSet<String>(16);
            Set colDims = dimFlexInfo.getColDims();
            for (BaseColumn bizFormColumn : bizFormColumns) {
                NumberColumn numberColumn;
                List columnDataMapDimensions;
                RowDimensionColumn rowDimensionColumn;
                List dimensionMemberRanges;
                String title = bizFormColumn.getTitle();
                if (StringUtils.isEmpty((CharSequence)title)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u201c%1\u201d\u5217\u7ef4\u5ea6\u6807\u9898\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{bizTableConfig.getTabName()}));
                    return true;
                }
                if (!existTitles.add(title)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u201c%1\u201d\u5217\u6807\u9898\u201c%2\u201d\u5b58\u5728\u91cd\u590d\u3002", (String)"ApplyTemplateMasterEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{bizTableConfig.getTabName(), title}));
                    return true;
                }
                if (bizFormColumn instanceof RowDimensionColumn && CollectionUtils.isEmpty((Collection)(dimensionMemberRanges = (rowDimensionColumn = (RowDimensionColumn)bizFormColumn).getDimensionMemberRanges()))) {
                    Dimension dimension = orCreate.getDimension(rowDimensionColumn.getDimNumber());
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u201c%1\u201d\u884c\u7ef4\u5ea6\u201c%2\u201d\u6210\u5458\u8303\u56f4\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{bizTableConfig.getTabName(), dimension == null ? "" : dimension.getName()}));
                    return true;
                }
                if (dimAreaCfgService.isShowDataDimensionMappingColumn(bizFormColumn) && (columnDataMapDimensions = dimAreaCfgService.getColumnDataMapDimensions(bizFormColumn)) != null) {
                    for (DataMapDimension dataMapDimension : columnDataMapDimensions) {
                        if (!colDims.contains(dataMapDimension.getDimNum()) || !IDUtils.isEmptyLong((Long)dataMapDimension.getDimensionRememberId()).booleanValue()) continue;
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u201c%1\u201d\u5217\u7ef4\u5ea6\u201c%2\u201d\u5217\u7684\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{bizTableConfig.getTabName(), title}));
                        return true;
                    }
                }
                if (!(bizFormColumn instanceof NumberColumn) || !(numberColumn = (NumberColumn)bizFormColumn).isIssummary() || !StringUtils.isEmpty((CharSequence)numberColumn.getHcolumnkey())) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u201c%1\u201d\u5217\u7ef4\u5ea6\u201c%2\u201d\u5217\u7684\u5bf9\u5e94\u9884\u7b97\u4fe1\u606f\u5217\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"ApplyTemplateMasterEditPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{bizTableConfig.getTabName(), title}));
                return true;
            }
        }
        return false;
    }

    private void addOldColumnKeysToParam(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("oldColumnKeys", SerializationUtils.toJsonString(this.getOldColumnKeys()));
    }

    private void cacheOldColumnKeys(boolean isAfterSave) {
        Set<Object> oldColumnKeys;
        String value = (String)this.getModel().getValue("entrycfgjson_tag");
        if (StringUtils.isEmpty((CharSequence)value)) {
            oldColumnKeys = new HashSet(0);
        } else {
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)value, ColumnList.class);
            Collection columns = columnList.getColumns();
            oldColumnKeys = columns.stream().map(BaseColumn::getKey).collect(Collectors.toSet());
        }
        String jsonString = SerializationUtils.toJsonString(oldColumnKeys);
        this.getPageCache().put("oldColumnKeys", jsonString);
        if (isAfterSave) {
            CommandParam commandParam = new CommandParam("eb_applytemplate", "eb_applytemplate_dimarea", "cacheOldColumnKeys", new Object[]{jsonString});
            this.sendMsg(this.getView(), commandParam);
        }
    }

    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("updateColumnList".equals(operation)) {
            List param = com.getParam();
            this.getModel().setValue("entrycfgjson_tag", param.get(0));
            this.getModel().setDataChanged(((Boolean)param.get(1)).booleanValue());
        } else if ("updateMainPanelDimInfo".equals(operation)) {
            List param = com.getParam();
            this.getModel().setValue("cachedata_tag", param.get(0));
            this.getModel().setDataChanged(((Boolean)param.get(1)).booleanValue());
        }
    }

    private Set<String> getOldColumnKeys() {
        String cache = this.getPageCache().get("oldColumnKeys");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            return new HashSet<String>(16);
        }
        return (Set)SerializationUtils.fromJsonString((String)cache, Set.class);
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("dataset");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.checkTemplateDeleted();
        String name = e.getProperty().getName();
        if ("dataset".equals(name)) {
            this.dataSetPropertyChanged();
        } else if ("name".equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject dataEntity = changeSet[0].getDataEntity();
            String nameStr = dataEntity.getString("name");
            this.checkIllegalCharacter(nameStr, false);
        }
    }

    private void checkIllegalCharacter(String nameStr, Boolean isSave) {
        String regex = "[\\\\/\\?\\*\\[\\]\u3010\u3011\u3001:\uff1f\uff1a]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(nameStr);
        StringBuilder specialChars = new StringBuilder();
        while (matcher.find()) {
            specialChars.append(matcher.group());
        }
        if (specialChars.length() > 0) {
            if (isSave.booleanValue()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u540d\u79f0\u201c%1\u201d\u4e2d\u4e0d\u80fd\u5305\u542b\u201c%2\u201d\u7279\u6b8a\u7b26\u53f7\u3002", (String)"ApplyTemplateMasterEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{nameStr, specialChars.toString()}));
            }
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u540d\u79f0\u201c%1\u201d\u4e2d\u4e0d\u80fd\u5305\u542b\u201c%2\u201d\u7279\u6b8a\u7b26\u53f7\u3002", (String)"ApplyTemplateMasterEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{nameStr, specialChars.toString()}));
        }
    }

    private void dataSetPropertyChanged() {
        Long dateSetId = this.getDateSetId();
        if (IDUtils.isEmptyLong((Long)dateSetId).booleanValue()) {
            return;
        }
        this.cacheIdMap(dateSetId);
        this.getModel().setValue("cachedata_tag", null);
        this.getModel().setValue("entrycfgjson_tag", null);
        this.openDimAreaSettingForm(dateSetId);
    }

    private void cacheIdMap(Long dateSetId) {
        Long bizModelId = ModelCacheContext.getOrCreate((Long)this.getModelId()).getBusModelByDataSet(dateSetId);
        HashMap<String, String> idMap = new HashMap<String, String>(2);
        idMap.put("businessModelId", String.valueOf(bizModelId));
        idMap.put("dataSetId", String.valueOf(dateSetId));
        this.getView().getPageCache().put("idmap", SerializationUtils.serializeToBase64(idMap));
    }

    private void openDimAreaSettingForm(Long dateSetId) {
        this.getPageCache().put("pagePool", SerializationUtils.toJsonString(new HashMap()));
        String pageId = this.getPageIdAndCache(this.getPageCache(), "eb_applytemplate_dimarea");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setPageId(pageId);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("dataSet", (Object)dateSetId);
        showParameter.setCustomParam("panelDimInfo", this.getModel().getValue("cachedata_tag"));
        showParameter.setCustomParam("entryColumnInfo", this.getModel().getValue("entrycfgjson_tag"));
        showParameter.setFormId("eb_applytemplate_dimarea");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("dimareaflex");
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!"bar_close".equals(itemKey)) {
            this.checkTemplateDeleted();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btn_basecfg")) {
            this.openBaseCfgPage();
        }
    }

    private void openBaseCfgPage() {
        this.checkTemplateDeleted();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long templateId = dataEntity.getLong("id");
        if (IDUtils.isEmptyLong((Long)templateId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ApplyTemplateMasterEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List allList = (List)SerializationUtils.fromJsonString((String)((String)this.getModel().getValue("cachedata_tag")), List.class);
        List rowList = allList.stream().filter(a -> StringUtils.equals((CharSequence)((CharSequence)a.get("panel")), (CharSequence)TempDimConfigType.ROWDIM.getValue())).collect(Collectors.toList());
        List hideList = allList.stream().filter(a -> StringUtils.equals((CharSequence)((CharSequence)a.get("panel")), (CharSequence)TempDimConfigType.HIDEDIM.getValue())).collect(Collectors.toList());
        String templateName = dataEntity.getString("name");
        String caption = ResManager.loadResFormat((String)"%1-\u6a21\u677f\u57fa\u7840\u8bbe\u7f6e", (String)"ApplyTemplateMasterEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{templateName == null ? "" : templateName});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_applytemplatecfg");
        formShowParameter.setShowTitle(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("templateId", (Object)templateId);
        formShowParameter.setCustomParam("rowDims", rowList);
        formShowParameter.setCustomParam("hideDims", hideList);
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCustomParam("datasetId", (Object)this.getDateSetId());
        formShowParameter.setCaption(caption);
        formShowParameter.setPageId(this.getView().getPageId() + templateId);
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        formShowParameter.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        this.getView().showForm(formShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("save".equals(operateKey)) {
                this.afterSave();
            } else if ("cancelprepublish".equals(operateKey)) {
                this.afterCancelPublish();
            } else if ("bar_publish".equals(operateKey)) {
                this.afterPublish();
            }
        }
    }

    private void afterPublish() {
        this.sendMsgReloadDimPanelData();
    }

    private void sendMsgReloadDimPanelData() {
        CommandParam commandParam = new CommandParam("eb_applytemplate", "eb_applytemplate_dimarea", "reloadDimPanelData", new Object[0]);
        this.sendMsg(this.getView(), commandParam);
    }

    private void afterCancelPublish() {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        long pkValue = this.getModel().getDataEntity().getLong("id");
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"eb_rptscheme", (QFilter[])filter.toArray());
        Set idsObjs = schemes.keySet();
        List schemeIds = idsObjs.stream().map(t -> Long.valueOf(t.toString())).collect(Collectors.toList());
        QFilter filter1 = new QFilter("scheme.id", "in", schemeIds);
        Map templateOrgMap = BusinessDataServiceHelper.loadFromCache((String)"eb_templateorg", (QFilter[])filter1.toArray());
        HashSet<String> schemeNames = new HashSet<String>(16);
        if (templateOrgMap != null) {
            for (DynamicObject value : templateOrgMap.values()) {
                long id;
                DynamicObject scheme;
                if (value == null || (scheme = value.getDynamicObject("scheme")) == null) continue;
                String name = scheme.getString("name");
                DynamicObject applyTemplate = value.getDynamicObject("applytemplate");
                if (applyTemplate == null || pkValue != (id = applyTemplate.getLong("id"))) continue;
                schemeNames.add(name);
            }
        }
        if (CollectionUtils.isNotEmpty(schemeNames)) {
            String info = String.join((CharSequence)",", schemeNames);
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8be5\u6a21\u677f\u5df2\u7ecf\u88ab\u4ee5\u4e0b\u65b9\u6848\u5f15\u7528:[%1],\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ApplyTemplateMasterEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{info}));
            return;
        }
        this.updateBizStatus("0");
        this.sendMsgReloadDimPanelData();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u53d1\u5e03\u6210\u529f\u3002", (String)"ApplyTemplateMasterEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void checkVarSetAfterSave(ColumnList columnList) {
        DynamicObject obj = this.getModel().getDataEntity();
        int templateStatus = obj.getInt("templatestatus");
        if (ApplyTempStatusEnum.PUBLISH.getValue() != templateStatus || columnList == null) {
            return;
        }
        HashMap<String, Set> varInfo = new HashMap<String, Set>(16);
        String dimConfigStr = (String)this.getModel().getValue("cachedata_tag");
        List allDimConfig = SerializationUtils.fromJsonStringToList((String)dimConfigStr, TempDimConfig.class);
        TemplateVarCommonUtil.selectApplyTempVarInfo((ColumnList)columnList, (List)allDimConfig, varInfo);
        if (varInfo.isEmpty()) {
            return;
        }
        HashMap varInfoList = new HashMap(varInfo.size());
        varInfo.forEach((dimNum, vars) -> varInfoList.put(dimNum, new ArrayList(vars)));
        Map refRptSchemeAssignVars = TemplateVarUtil.getRefRptSchemeVars(Collections.singletonList(obj.getLong("id")));
        Map schemeAssignInfo = ReportSchemeAssignService.getInstance().getSchemeAssignInfoUseOfTip(refRptSchemeAssignVars.keySet());
        StringBuilder sb = new StringBuilder();
        refRptSchemeAssignVars.forEach((assignId, dimVarInfo) -> {
            String errMessage = TemplateVarCommonUtil.checkVarAndRetErrMessage((Map)dimVarInfo, (Map)varInfoList, (String)ResManager.loadResFormat((String)"\u7f16\u5236\u65b9\u6848\u201c%1\u201d", (String)"ApplyTemplateMasterEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeAssignInfo.get(assignId)}), null);
            if (StringUtils.isNotEmpty((CharSequence)errMessage)) {
                sb.append(errMessage).append("\n");
            }
        });
        if (sb.length() > 0) {
            this.getView().showTipNotification(sb.toString());
        }
    }

    private void afterSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long templateId = dataEntity.getLong("id");
        String templateNumber = dataEntity.getString("number");
        if (IDUtils.isEmptyLong((Long)templateId).booleanValue() || StringUtils.isEmpty((CharSequence)templateNumber)) {
            return;
        }
        ApplyTemplateDimCfgService.getInstance().updateDataInitCfg(templateId.longValue());
        String entryCfgJsonTag = (String)this.getModel().getValue("entrycfgjson_tag");
        if (StringUtils.isNotEmpty((CharSequence)entryCfgJsonTag)) {
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)entryCfgJsonTag, ColumnList.class);
            ApplyTemplateCfgService.getInstance().createDefaultCfg(templateId, templateNumber, columnList, this.getModelId());
            this.cacheOldColumnKeys(true);
            this.checkVarSetAfterSave(columnList);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset"});
    }

    private boolean checkNumberExist(String number) {
        Long modelId = this.getModelId();
        QFilter qf1 = new QFilter("number", "=", (Object)number);
        QFilter qf2 = new QFilter("model", "=", (Object)modelId);
        Object id = this.getModel().getValue("id");
        if (id != null && (Long)id != 0L) {
            qf1.and(new QFilter("id", "!=", id));
        }
        return QueryServiceHelper.exists((String)"eb_applytemplate", (QFilter[])new QFilter[]{qf1, qf2});
    }

    private void checkTemplateDeleted() {
        boolean exists;
        Long id = this.getModel().getDataEntity().getLong("id");
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue() && !(exists = QueryServiceHelper.exists((String)"eb_applytemplate", (Object)id))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"ApplyTemplateMasterEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Long getModelId() {
        Object value = this.getModel().getValue("model");
        if (value == null) {
            return 0L;
        }
        return ((DynamicObject)value).getLong("id");
    }

    private Long getDateSetId() {
        Object value = this.getModel().getValue("dataset");
        if (value == null) {
            return 0L;
        }
        return ((DynamicObject)value).getLong("id");
    }
}

