/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.quote.utils.QuoteTemplateBuilder;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.business.template.TemplateFormulaUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TemplateUpdateStatus;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.CloseCallBackUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.report.mob.MobReportDisplayConfig;
import kd.epm.eb.formplugin.report.mob.MobReportHelper;
import kd.epm.eb.formplugin.report.mob.MobReportSettingPlugin;
import kd.epm.eb.formplugin.sonmodel.BgmdMainSubController;
import kd.epm.eb.formplugin.sonmodel.entity.MainSubControlMsg;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.command.event.CellValueEvent;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.command.stylecontroller.styleset.ColDimCenterController;
import kd.epm.eb.spread.command.stylecontroller.styleset.SheetMetricDimStyleController;
import kd.epm.eb.spread.command.stylecontroller.styleset.SheetRowColWidthController;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.TemplateMutexServiceHelper;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.pageviewpanel.PageViewPanelDraw;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spread.ITemplateModelSupport;
import kd.epm.eb.spread.template.spread.style.StyleInfo;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.AttachmentHelper;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import kd.epm.eb.spread.utils.ReportVar.VarException;
import org.apache.commons.collections4.CollectionUtils;

public class DynamicTemplateProcess
extends AbstractReportPlugin
implements ITemplateModelSupport,
BgmdMainSubController {
    private static final String TOOLBARAP = "toolbarap";
    private static final String EB_PARTITIONSETTING = "eb_partitionsetting";
    private static final String EB_MOBREPORTSETTING = "eb_mobreportsetting";
    private static final String EB_METRICCELLSTYLE = "eb_metriccellstyle";
    private static final String CLOSE_CALLBACK_PARTITIONSETTING = "close_calback_partitionsetting";
    private static final String KEY_MODEL_ID = "KEY_MODEL_ID";
    private static final String FORM_TEMPLATE_ENTITY = "eb_templateentity";
    private static final String VARBASEVALUE = "varbaseforeb";
    private static final String ISDATACHANGED = "isdatachanged";
    private static final String TEMPLATEBASEINFOCLOSECALLBACK_EB = "templatebaseinfoclosecallback_eb";
    private ITemplateModel templateModel = null;
    private String spreadKey = "template_spread";
    private static final String ISSETAREA = "issetarea";
    private static final String ALLPROPERTYCACHEKEY = "AllPropertyCacheKey";
    private static final String DIMMEMBER_DEFAULTSHOWTYPE = "defaultshowsetting";
    private Log logger = LogFactory.getLog(DynamicTemplateProcess.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        this.updateDimProperty();
        super.afterCreateNewData(e);
        this.lockReport();
        this.getView().getPageCache().put("rowcoldims", SerializationUtils.serializeToBase64((Object)this.getTemplateModel().getRowcolDims()));
        this.getView().getPageCache().put("members", SerializationUtils.serializeToBase64(this.dealWithMember()));
        this.initDimPropertyData();
        this.getView().setVisible(Boolean.valueOf(!this.isNewEbForm()), new String[]{"btn_rptsection"});
    }

    protected void rebuildPageView() {
        this.rebuildPageView(this.getTemplateModel());
    }

    protected void refreshCellData(OlapQuerySync.ViewArea viewArea) {
        this.cacheSpreadManager();
    }

    protected void initSpreadManager() {
        EbSpreadManager ebSpreadManager = new EbSpreadManager();
        ebSpreadManager.setNeedCheckPerm(false);
        ebSpreadManager.initModelObj(this.templateModel);
        EBook ieBook = new EBook(new String[]{this.templateModel.getTemplateBaseInfo().getNumber()});
        ebSpreadManager.setEbook((IEBook)ieBook);
        ieBook.getSheet(0).setStyleCell(true);
        this.setEbSpreadManager((IEbSpreadManager)ebSpreadManager);
    }

    protected void rebuildSpreadReportView() {
        this.rebuildSpreadView(this.getTemplateModel());
    }

    public void resolveSpreadLockController(List<ISpreadLockControl> spreadLockControls) {
    }

    protected SpreadLockContext getSpreadContext() {
        return new SpreadLockContext(this.getSpreadManager(), this.getTemplateModel());
    }

    protected void resolveSpreadStyleController(List<ISpreadStyleControl> spreadStyleControls) {
        spreadStyleControls.add((ISpreadStyleControl)new SheetMetricDimStyleController());
        spreadStyleControls.add((ISpreadStyleControl)new SheetRowColWidthController());
        spreadStyleControls.add((ISpreadStyleControl)new ColDimCenterController());
    }

    protected void beforeSetSpreadJson() {
        super.beforeSetSpreadJson();
    }

    protected String getDataUnit() {
        return this.getTemplateModel().getTemplateBaseInfo().getDataunit().trim();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_partitionsetting".equals(evt.getItemKey())) {
            if (this.hasMutexPageOpen(EB_PARTITIONSETTING)) {
                return;
            }
            this.showPartitionSettingForm();
        } else if ("btn_save".equals(evt.getItemKey())) {
            this.canDoOperation("btn_save");
            this.checkPropertyExist();
            HashSet<Long> save = new HashSet<Long>(2);
            save.add(this.getTemplateModel().getTemplateBaseInfo().getId());
            this.updateSubSign("btn_save", this.getTemplateModel().getTemplateBaseInfo().getNumber(), save);
            this.actionSave();
        } else if ("btn_shownumber".equals(evt.getItemKey())) {
            this.getF7PropertyMap();
            Map<String, List<PropertyObj>> allPropertysMap = this.getPropertysMap();
            this.buildSpreadRowColDimension(MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex(), allPropertysMap);
        } else if ("btn_closenumber".equals(evt.getItemKey())) {
            Map<String, List<PropertyObj>> allPropertysMap = this.getPropertysMap();
            this.buildSpreadRowColDimension(MemberDisplayTypeEnum.NAME.getIndex(), allPropertysMap);
        } else if ("btn_showonlynumber".equals(evt.getItemKey())) {
            Map<String, List<PropertyObj>> allPropertysMap = this.getPropertysMap();
            this.buildSpreadRowColDimension(MemberDisplayTypeEnum.NUMBER.getIndex(), allPropertysMap);
        } else if ("btn_showsimname".equals(evt.getItemKey())) {
            Map<String, List<PropertyObj>> allPropertysMap = this.getPropertysMap();
            this.buildSpreadRowColDimension(MemberDisplayTypeEnum.SIMPLENAME.getIndex(), allPropertysMap);
        } else if ("btn_showsimnamenum".equals(evt.getItemKey())) {
            Map<String, List<PropertyObj>> allPropertysMap = this.getPropertysMap();
            this.buildSpreadRowColDimension(MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex(), allPropertysMap);
        } else if ("btn_displaysetting".equals(evt.getItemKey())) {
            this.showMetricStyleForm();
        } else if ("btn_metriccellstyle".equals(evt.getItemKey())) {
            this.showMetricStyleForm();
        } else if ("refresh".equals(evt.getItemKey())) {
            this.refreshTemplateModel();
            this.updateDimProperty();
            this.refreshSpread();
        } else if ("btn_baseinfo".equals(evt.getItemKey())) {
            this.showBaseInfoForm();
        } else if ("btn_weavedesc".equals(evt.getItemKey())) {
            this.openWeaveDescPage();
        } else if ("btn_formula".equals(evt.getItemKey())) {
            TemplateFormulaUtil.getInstance().showFormulaPage((AbstractFormPlugin)this, this.getSpreadSelector(), this.getTemplateModel(), false);
        } else if ("btn_rptsection".equals(evt.getItemKey())) {
            AnalyseReportUtil.getInstance().openRptSectionForm4BgTemp(this.getTemplateModel(), this.getView());
        } else if ("btn_mobrptsetting".equals(evt.getItemKey())) {
            if (this.hasMutexPageOpen(EB_MOBREPORTSETTING)) {
                return;
            }
            this.onClickMobReportSetting();
        } else {
            this.changebtnUnit(evt.getItemKey());
        }
    }

    private void checkPropertyExist() {
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (StringUtils.isEmpty((String)f7SelectedStr)) {
            return;
        }
        List f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        DimPropertyHelper.checkPropertyIsExist((Long)this.getModelId(), (List)f7items);
    }

    private void onClickMobReportSetting() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_MOBREPORTSETTING);
        formShowParameter.setPageId(this.getView().getPageId() + EB_MOBREPORTSETTING);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setCustomParam("template_id", (Object)(this.getTemplateModel().getTemplateBaseInfo().getId() + ""));
        formShowParameter.setCustomParam(KEY_MODEL_ID, this.getView().getFormShowParameter().getCustomParam(KEY_MODEL_ID));
        formShowParameter.setCustomParam("KEY_BUSMODEL_ID", (Object)this.getTemplateModel().getTemplateBaseInfo().getBizModel());
        formShowParameter.setCustomParam("DATASETID", (Object)this.getTemplateModel().getTemplateBaseInfo().getDatasetID());
        if (this.getPageCache().get("TemplateModel") != null) {
            formShowParameter.setCustomParam("TemplateModel", (Object)this.getPageCache().get("TemplateModel"));
        } else if (this.getView().getFormShowParameter().getCustomParam("TemplateModel") != null) {
            formShowParameter.setCustomParam("TemplateModel", this.getView().getFormShowParameter().getCustomParam("TemplateModel"));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9884\u7b97\u6a21\u677f\u3002", (String)"MobReportSettingPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm(formShowParameter);
    }

    private ISheet getSheetCellDimMems(SpreadSelector selector) {
        ESheet sheet = new ESheet();
        String[] orderedDimNumbers = this.getTemplateModel().getRowcolDims().toArray(new String[0]);
        int row = selector.getStartRow();
        int rowIndex = 0;
        while (row <= selector.getEndRow()) {
            int col = selector.getStartCol();
            int colIndex = 0;
            while (col <= selector.getEndCol()) {
                Map rowDimMems = this.getSpreadManager().getRowpartitionDimMemsByRow(Integer.valueOf(row));
                Map colDimMems = this.getSpreadManager().getColpartitionDimMemsByCol(Integer.valueOf(col));
                if (rowDimMems != null && rowDimMems.size() != 0 && colDimMems != null && colDimMems.size() != 0) {
                    HashMap memNumbers = new HashMap(16);
                    rowDimMems.forEach((k, v) -> {
                        if (!v.isProperty()) {
                            memNumbers.put(k, v.getDimMemberNumber());
                        }
                    });
                    colDimMems.forEach((k, v) -> {
                        if (!v.isProperty()) {
                            memNumbers.put(k, v.getDimMemberNumber());
                        }
                    });
                    ECell eCell = sheet.getECell(rowIndex, colIndex);
                    eCell.setUserObject("memNumbers", memNumbers);
                    eCell.setValue((Object)MobReportHelper.getMemberDisplay((IModelCacheHelper)this.getModelCacheHelper(), (String[])orderedDimNumbers, memNumbers, (Long)this.getTemplateModel().getTemplateBaseInfo().getBizModel()));
                }
                ++col;
                ++colIndex;
            }
            ++row;
            ++rowIndex;
        }
        return sheet;
    }

    private void showBaseInfoForm() {
        ITemplateModel templateModel = this.getTemplateModel();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TEMPLATEBASEINFOCLOSECALLBACK_EB);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(FORM_TEMPLATE_ENTITY);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("bgtemplate_info", (Object)ObjectSerialUtil.toByteSerialized((Object)templateModel.getTemplateBaseInfo()));
        formShowParameter.setCustomParam(ISSETAREA, (Object)this.getPageCache().get(ISSETAREA));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f", (String)"DynamicTemplateProcess_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void actionSave() {
        if (!this.checkMember().booleanValue()) {
            this.getUserDefinedRowColSize();
        }
        this.getView().getPageCache().put("rowcoldims", SerializationUtils.serializeToBase64((Object)this.getTemplateModel().getRowcolDims()));
        this.getView().getPageCache().put("members", SerializationUtils.serializeToBase64(this.dealWithMember()));
    }

    private Boolean checkMember() {
        Boolean isPageChanged = false;
        Map<String, Collection<String>> collectionMap = this.dealWithMember();
        Map cachedCollectionMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("members"));
        List rowcolDims = this.getTemplateModel().getRowcolDims();
        List cachedrowcolDims = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("rowcoldims"));
        if (CollectionUtils.isNotEmpty((Collection)rowcolDims) && CollectionUtils.isNotEmpty((Collection)cachedrowcolDims)) {
            if (rowcolDims.size() != cachedrowcolDims.size()) {
                isPageChanged = true;
            }
            for (String string : rowcolDims) {
                if (cachedrowcolDims.contains(string)) continue;
                isPageChanged = true;
            }
        }
        if (!collectionMap.isEmpty() && !cachedCollectionMap.isEmpty()) {
            if (collectionMap.size() != cachedCollectionMap.size()) {
                isPageChanged = true;
            }
            for (Map.Entry entry : collectionMap.entrySet()) {
                String key = (String)entry.getKey();
                if (cachedCollectionMap.containsKey(key)) {
                    Collection value = (Collection)entry.getValue();
                    Collection cachedValue = (Collection)cachedCollectionMap.get(key);
                    if (value.size() != cachedValue.size()) {
                        isPageChanged = true;
                    }
                    for (String dim : value) {
                        if (cachedValue.contains(dim)) continue;
                        isPageChanged = true;
                    }
                    continue;
                }
                isPageChanged = true;
            }
        }
        MobReportDisplayConfig mobReportDisplayConfig = null;
        String string = this.getView().getPageCache().get("MobReportDisplayConfig");
        if (StringUtils.isEmpty((String)string)) {
            String mobconfigStr;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_mobreportconfig", (String)"mobconfig", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)this.getTemplateModel().getTemplateBaseInfo().getId())});
            if (dynamicObject != null && kd.bos.util.StringUtils.isNotEmpty((String)dynamicObject.getString("mobconfig")) && kd.bos.util.StringUtils.isNotEmpty((String)(mobconfigStr = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(dynamicObject.getString("mobconfig"))))))) {
                mobReportDisplayConfig = (MobReportDisplayConfig)SerializationUtils.fromJsonString((String)mobconfigStr, MobReportDisplayConfig.class);
            }
        } else if (!"clear".equals(string)) {
            mobReportDisplayConfig = (MobReportDisplayConfig)SerializationUtils.fromJsonString((String)string, MobReportDisplayConfig.class);
        }
        if (mobReportDisplayConfig != null) {
            this.getPageCache().put("MobReportDisplayConfig", SerializationUtils.toJsonString((Object)mobReportDisplayConfig));
            Map mobMap = mobReportDisplayConfig.retrieveQuoteMembers();
            Map<String, Collection<String>> tempMap = this.dealWithMember();
            for (Map.Entry stringCollectionEntry : mobMap.entrySet()) {
                Collection<String> members = tempMap.get(stringCollectionEntry.getKey());
                if (members == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u540c\u6b65\u4fee\u6539\u79fb\u52a8\u7aef\u663e\u793a\u8bbe\u7f6e\u540e\u4fdd\u5b58\u3002", (String)"MobReportSettingPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return true;
                }
                if (members.containsAll((Collection)stringCollectionEntry.getValue())) continue;
                Collection value = (Collection)stringCollectionEntry.getValue();
                value.removeAll(members);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u79fb\u52a8\u8bbe\u7f6e\u4e2d\u6210\u5458\uff1a\u201c%s\u201d\u4e0d\u5728\u6a21\u677f\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58\u3002", (String)"MobReportSettingPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", value)}));
                return true;
            }
        } else {
            return false;
        }
        if (isPageChanged.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\u540c\u6b65\u4fee\u6539\u79fb\u52a8\u7aef\u663e\u793a\u8bbe\u7f6e\u3002", (String)"MobReportSettingPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return false;
    }

    private Map<String, Collection<String>> dealWithMember() {
        Map tempMap = this.getTemplateModel().retrieveQuoteMembersWithChildren(this.getModelId().longValue(), null);
        Map tempMemberMap = this.getTemplateModel().retrieveQuoteMembersWithScope();
        for (Map.Entry tempCollectionEntry : tempMap.entrySet()) {
            Collection members = (Collection)tempMap.get(tempCollectionEntry.getKey());
            Collection vmembers = (Collection)tempMemberMap.get(tempCollectionEntry.getKey());
            if (vmembers == null) continue;
            for (kd.epm.eb.common.model.Member vmember : vmembers) {
                if (members.contains(vmember.getNumber()) || vmember.getNumber() == null) continue;
                if (vmember.getNumber().startsWith("@")) {
                    HashSet<Member> memberSet = new HashSet<Member>(16);
                    for (RowColPartition rowColPartition : this.getTemplateModel().getPartitionSetting().getColPartition()) {
                        this.resolveVar(members, vmember, memberSet, rowColPartition);
                    }
                    for (RowColPartition rowColPartition : this.getTemplateModel().getPartitionSetting().getRowPartition()) {
                        this.resolveVar(members, vmember, memberSet, rowColPartition);
                    }
                    continue;
                }
                members.add(vmember.getNumber());
            }
        }
        return tempMap;
    }

    private void resolveVar(Collection<String> members, kd.epm.eb.common.model.Member vmember, Set<Member> memberSet, RowColPartition rowColPartition) {
        for (IRowColDimensionEntry rowColDimensionEntry : rowColPartition.getRowColDimensionEntries()) {
            if (!rowColDimensionEntry.getDimension().getNumber().equals(vmember.getDimension().getNumber())) continue;
            for (IDimensionMember member : rowColDimensionEntry.getMembers()) {
                if (!member.getNumber().equals(vmember.getNumber())) continue;
                LinkedHashSet objects = new LinkedHashSet();
                TemplateVarUtil.addVar2DimLst((Long)this.getModelId(), (IDimension)rowColDimensionEntry.getDimension(), (IDimensionMember)member, memberSet, objects, null);
                if (CollectionUtils.isNotEmpty(memberSet)) {
                    members.addAll(memberSet.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                }
                if (!CollectionUtils.isNotEmpty(memberSet)) continue;
                members.addAll(memberSet.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
            }
        }
    }

    private void getUserDefinedRowColSize() {
        int i;
        IEbSpreadManager ebSpreadManager = this.getSpreadManager();
        int cols = ebSpreadManager.getEbook().getSheet(0).getRealMaxCols();
        int rows = ebSpreadManager.getEbook().getSheet(0).getRealMaxRows();
        ArrayList<Integer> rowheigths = new ArrayList<Integer>(16);
        ArrayList<Integer> colwidths = new ArrayList<Integer>(16);
        for (i = 0; i < cols; ++i) {
            colwidths.add(i);
        }
        for (i = 0; i < rows; ++i) {
            rowheigths.add(i);
        }
        this.getPageCache().put("cacheColumnsWidth", ObjectSerialUtil.toByteSerialized(colwidths));
        this.getspreadContainer().getRowsHeight(rowheigths, "cacheRowHeight");
    }

    public void cacheColumnsWidth(Object paras) {
        this.logger.info("callPluginMethod:cacheColumnsWidth");
        try {
            if (paras == null) {
                return;
            }
            ITemplateModel templateModel = this.getTemplateModel();
            StyleInfo styleInfo = templateModel.getStyleInfo();
            if (styleInfo == null) {
                styleInfo = new StyleInfo();
            }
            Map parasmap = (Map)Map.class.cast(paras);
            ArrayList infos = (ArrayList)parasmap.get("infos");
            for (Map colwidth : infos) {
                Integer w = (Integer)colwidth.get("w");
                if (w == null || w == 0) {
                    styleInfo.getColWidths().remove(String.valueOf(colwidth.get("c")));
                    continue;
                }
                styleInfo.putColWidth(String.valueOf(colwidth.get("c")), w);
            }
            templateModel.setStyleInfo(styleInfo);
            this.cacheTemplateModel();
            this.getspreadContainer().callbackAction("saveTemplateModel");
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public void cacheRowHeight(Object paras) {
        this.logger.info("callPluginMethod:cacheRowHeight");
        try {
            if (paras == null) {
                return;
            }
            ITemplateModel templateModel = this.getTemplateModel();
            StyleInfo styleInfo = templateModel.getStyleInfo();
            if (styleInfo == null) {
                styleInfo = new StyleInfo();
                templateModel.setStyleInfo(styleInfo);
            }
            Map parasmap = (Map)Map.class.cast(paras);
            ArrayList infos = (ArrayList)parasmap.get("infos");
            int defaultHeight = 20;
            styleInfo.getRowHeigths().clear();
            for (Map info : infos) {
                Integer h = (Integer)info.get("h");
                if (h == null || h == 0 || h == 20) continue;
                styleInfo.putRowHeigth(String.valueOf(info.get("r")), h);
            }
            this.cacheTemplateModel();
            this.getspreadContainer().getColumnsWidth((List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("cacheColumnsWidth")), "cacheColumnsWidth");
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void changebtnUnit(String itemkey) {
        HashSet unitbtns = Sets.newHashSet((Object[])new String[]{"btn_unit0", "btn_unit3", "btn_unit4", "btn_unit6", "btn_unit8"});
        if (unitbtns.contains(itemkey)) {
            String changeunit = itemkey.substring(itemkey.length() - 1, itemkey.length());
            this.getTemplateModel().getTemplateBaseInfo().setDataunit(changeunit);
            this.cacheTemplateModel();
        }
    }

    public String getSpreadKey() {
        return this.spreadKey;
    }

    protected List<ContextMenuItemsEnum> getHideContextMenuItems() {
        return Lists.newArrayList((Object[])new ContextMenuItemsEnum[]{ContextMenuItemsEnum.CLEARCONTENTS, ContextMenuItemsEnum.INSERTROWS, ContextMenuItemsEnum.INSERTCOLUMNS, ContextMenuItemsEnum.INSERTROWMANY, ContextMenuItemsEnum.INSERTCOLUMNMANY, ContextMenuItemsEnum.DELETEROWS, ContextMenuItemsEnum.DELETECOLUMNS, ContextMenuItemsEnum.INSERTSHEET, ContextMenuItemsEnum.DELETESHEET, ContextMenuItemsEnum.SORT, ContextMenuItemsEnum.SLICERSORTASCEND, ContextMenuItemsEnum.SLICERSORTDESCEND, ContextMenuItemsEnum.INSERTCOMMENT, ContextMenuItemsEnum.RICHTEXT, ContextMenuItemsEnum.EDITCOMMENT, ContextMenuItemsEnum.DELETECOMMENT, ContextMenuItemsEnum.TOGGLECOMMENT, ContextMenuItemsEnum.HIDEROWS, ContextMenuItemsEnum.UNHIDEROWS, ContextMenuItemsEnum.HIDECOLUMNS, ContextMenuItemsEnum.UNHIDECOLUMNS, ContextMenuItemsEnum.HIDESHEET, ContextMenuItemsEnum.UNHIDESHEET, ContextMenuItemsEnum.REMOVESLICER, ContextMenuItemsEnum.INSERTROWORCOLUMNS, ContextMenuItemsEnum.CELLSFORMAT});
    }

    protected List<ToolBarItemsEnum> getHideToolBarItems() {
        return Lists.newArrayList((Object[])new ToolBarItemsEnum[]{ToolBarItemsEnum.FONTSTYLE, ToolBarItemsEnum.FONTDECORATION, ToolBarItemsEnum.FOREANDBACKCOLOR, ToolBarItemsEnum.CELLSBORDER, ToolBarItemsEnum.CLEARCELLS, ToolBarItemsEnum.CELLSFORMAT, ToolBarItemsEnum.WORDWRAP, ToolBarItemsEnum.TEXTALIGN, ToolBarItemsEnum.TEXTINDENT, ToolBarItemsEnum.LOCKCELLS, ToolBarItemsEnum.MERGECELLS, ToolBarItemsEnum.INSERTROWANDCOL, ToolBarItemsEnum.FROZENSHEETS, ToolBarItemsEnum.SWITCHVIEW, ToolBarItemsEnum.UPLOADFILE, ToolBarItemsEnum.VERTICALALIGN});
    }

    protected List<Integer> getHideMetricRowIndex() {
        Integer metricRowIndex = this.getSpreadManager().getMetricRowIndex();
        if (metricRowIndex != null) {
            ArrayList<Integer> indexList = new ArrayList<Integer>(1);
            indexList.add(metricRowIndex);
            return indexList;
        }
        return null;
    }

    protected List<Integer> getHideMetricColIndex() {
        Integer metricColIndex = this.getSpreadManager().getMetricColIndex();
        if (metricColIndex != null) {
            ArrayList<Integer> indexList = new ArrayList<Integer>(1);
            indexList.add(metricColIndex);
            return indexList;
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object retObj;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(CLOSE_CALLBACK_PARTITIONSETTING)) {
            this.getPageCache().remove("pageid");
            if (closedCallBackEvent.getReturnData() != null) {
                Set toClearFormulas;
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                this.templateModel = (ITemplateModel)returnData.get("templateModel");
                String clearFormulas = (String)returnData.get("clearFormulas");
                if (clearFormulas != null && (toClearFormulas = (Set)SerializationUtils.fromJsonString((String)clearFormulas, Set.class)) != null && !toClearFormulas.isEmpty()) {
                    TemplateFormulaUtil.getInstance().clearFormulas(this.getspreadContainer(), this.templateModel.getFormulaMap(), toClearFormulas);
                }
                this.getPageCache().put("TemplateModel", TemplateModelJSONUtil.toJSONString((ITemplateModel)this.templateModel));
                this.getPageCache().put(VARBASEVALUE, this.templateModel.getTemplateBaseInfo().getVarBase());
                this.refreshSpread();
                this.getPageCache().put(ISDATACHANGED, "true");
                this.getPageCache().put(ISSETAREA, "true");
            }
        } else if (closedCallBackEvent.getActionId().equals(TEMPLATEBASEINFOCLOSECALLBACK_EB)) {
            if (closedCallBackEvent.getReturnData() != null) {
                this.getPageCache().put("bgtemplate_info", (String)closedCallBackEvent.getReturnData());
                this.getPageCache().put(ISDATACHANGED, "true");
            }
        } else if (closedCallBackEvent.getActionId().equals(EB_METRICCELLSTYLE)) {
            Object obj = closedCallBackEvent.getReturnData();
            if (obj != null) {
                Map map = (Map)SerializationUtils.deSerializeFromBase64((String)((String)obj));
                Object metricCellStyleInfos = map.get("metricCellStyleInfos");
                Object dimMemDefaultShowSetting = map.get("defaultShowSetting");
                this.getTemplateModel().setMetricCellStyleInfo((List)metricCellStyleInfos);
                this.getTemplateModel().getTemplateBaseInfo().setDimMemDefaultDisplayType(((Integer)dimMemDefaultShowSetting).intValue());
                this.cacheTemplateModel();
            }
        } else if (closedCallBackEvent.getActionId().equals("setFormula") && (retObj = closedCallBackEvent.getReturnData()) instanceof Map) {
            this.handleCellFormulaReturnValue((Map)retObj);
            this.cacheTemplateModel();
        }
    }

    private void handleCellFormulaReturnValue(Map<String, String> formulaMap) {
        TemplateFormulaUtil.getInstance().handleCellFormulaReturnValue(this.getSpreadSelector(), this.getspreadContainer(), this.getTemplateModel().getFormulaMap(), formulaMap);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.refreshEbTemplateListView();
        if (this.getPageCache().get("isClose") == null && this.getPageCache().get(ISDATACHANGED) != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u533a\u5df2\u6539\u53d8\u4f46\u672a\u4fdd\u5b58\uff0c\u786e\u8ba4\u9000\u51fa\uff1f", (String)"DynamicTemplateProcess_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isClose"));
            e.setCancel(true);
        } else {
            this.unlockReport();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent m) {
        super.confirmCallBack(m);
        String key = m.getCallBackId();
        if ("isClose".equals(key) && m.getResultValue().equals(MessageBoxResult.Yes.name())) {
            this.getPageCache().put("isClose", "true");
            this.getView().close();
        }
    }

    private void refreshEbTemplateListView() {
        CloseCallBackUtil.reSetParentView((IFormView)this.getView(), (String)((String)this.getView().getFormShowParameter().getCustomParam("parentpageid")));
    }

    protected void rebuildSpreadView(ITemplateModel templateModel) {
        if (templateModel.getPartitionSetting() != null && templateModel.getPartitionSetting().getRowPartition().size() > 0 && templateModel.getPartitionSetting().getColPartition().size() > 0) {
            this.setCacheVar(templateModel, SpreadTypeEnum.SPREADTYPE_VIEW.getIndex());
            try {
                this.getSpreadManager().buildReportManager(templateModel);
            }
            catch (KDBizException e) {
                this.logger.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
        }
        this.dealCellsIndent(this.getSpreadManager());
        this.setEbSpreadManager(this.getSpreadManager());
    }

    protected void rebuildPageView(ITemplateModel templateModel) {
        PageViewPanelDraw pageViewPanelDraw = new PageViewPanelDraw(this.getView(), templateModel, this.getSpreadManager());
        pageViewPanelDraw.setNeedlockpage(true);
        pageViewPanelDraw.setNeedCheckPerm(false);
        pageViewPanelDraw.build();
    }

    public void saveTemplateModel(Object paras) {
        try {
            DynamicObject t;
            this.logger.info("callPluginMethod:saveTemplateModel");
            Long tempId = 0L;
            BgTemplate bgTemplate = null;
            bgTemplate = this.getPageCache().get("bgtemplate_info") != null ? (BgTemplate)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("bgtemplate_info")) : (BgTemplate)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam("bgtemplate_info")));
            QFilter filter = new QFilter("model", "=", (Object)bgTemplate.getModelID());
            if (QueryServiceHelper.exists((String)FORM_TEMPLATE_ENTITY, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bgTemplate.getNumber()).and(filter).and(new QFilter("id", "!=", (Object)bgTemplate.getId()))})) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a%1\u7684\u6a21\u677f\u3002", (String)"DynamicTemplateProcess_2", (String)"epm-eb-formplugin", (Object[])new Object[]{bgTemplate.getNumber()}));
                return;
            }
            String dataStr = this.getPageCache().get("TemplateModel");
            if (StringUtils.isEmpty((String)dataStr) || !dataStr.contains("partitionSetting")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8fdb\u884c\u5206\u533a\u8bbe\u7f6e\u3002", (String)"DynamicTemplateProcess_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.templateModel = this.getTemplateModel();
            if (bgTemplate.getId() == null || bgTemplate.getId().compareTo(0L) == 0) {
                Serializable dimRelation2;
                t = ORM.create().newDynamicObject(FORM_TEMPLATE_ENTITY);
                tempId = DBServiceHelper.genGlobalLongId();
                t.set("id", (Object)String.valueOf(tempId));
                t.set("modifier", (Object)UserUtils.getUserId());
                t.set("creator", (Object)UserUtils.getUserId());
                t.set("name", (Object)bgTemplate.getName());
                t.set("number", (Object)bgTemplate.getNumber());
                t.set("model", (Object)bgTemplate.getModelID());
                t.set("dataunit", (Object)bgTemplate.getDataunit());
                t.set("dataset", (Object)bgTemplate.getDatasetID());
                t.set("templateCatalog", (Object)bgTemplate.getCatalog());
                t.set("tempversion", (Object)TemplateUpdateStatus.SUCCEED.getValue());
                t.set("dimmemdefaultdisplaytype", (Object)bgTemplate.getDimMemDefaultDisplayType());
                t.set("createTime", (Object)TimeServiceHelper.now());
                t.set("modifyTime", (Object)TimeServiceHelper.now());
                t.set("effectivedate", (Object)TimeServiceHelper.now());
                t.set("templatetype", (Object)BgTemplateTypeEnum.DYNAMIC.getNumber());
                bgTemplate.setVarBase(TemplateVarCommonUtil.getVarbaseforeb((Map)this.getTemplateModel().retrieveQuoteMembers()));
                t.set(VARBASEVALUE, (Object)bgTemplate.getVarBase());
                this.templateModel.setTemplateBaseInfo(bgTemplate);
                t.set("data", (Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)this.templateModel));
                t.set("isreadonly", (Object)"1".equals(bgTemplate.getIsReadOnly()));
                t.set("isrelation", (Object)"1".equals(bgTemplate.getIsDimRelation()));
                TemplateHelper.setDynamicObjectRunExamineOrRuleWhenOpen((DynamicObject)t, (BgTemplate)bgTemplate);
                if ("1".equals(bgTemplate.getIsReadOnly())) {
                    t.set("rptreadonly", (Object)true);
                } else {
                    t.set("rptreadonly", (Object)bgTemplate.getRptReadOnly());
                }
                t.set("synccalcrule", (Object)bgTemplate.isSyncCalcRule());
                DynamicObjectCollection dimrelationinfos = t.getDynamicObjectCollection("dimrelationinfo2");
                dimrelationinfos.clear();
                List dimRelations = bgTemplate.getDimRelations();
                if (dimRelations != null) {
                    for (Serializable dimRelation2 : dimRelations) {
                        DynamicObject basedata = new DynamicObject(dimrelationinfos.getDynamicObjectType());
                        basedata.set("fbasedataid", (Object)dimRelation2);
                        dimrelationinfos.add((Object)basedata);
                    }
                }
                TXHandle required = TX.required((String)"");
                dimRelation2 = null;
                try {
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{t});
                        RuleRelationService.getInstance().bindRuleToTemplate(tempId.longValue());
                        AnalyseReportUtil.getInstance().upRptSection4TempChange(this.templateModel);
                    }
                    catch (Exception ex) {
                        required.markRollback();
                        throw ex;
                    }
                }
                catch (Throwable ex) {
                    dimRelation2 = ex;
                    throw ex;
                }
                finally {
                    if (required != null) {
                        if (dimRelation2 != null) {
                            try {
                                required.close();
                            }
                            catch (Throwable ex) {
                                ((Throwable)dimRelation2).addSuppressed(ex);
                            }
                        } else {
                            required.close();
                        }
                    }
                }
                bgTemplate.setId(Long.valueOf(Long.parseLong(t.getString("id"))));
                this.getPageCache().put("bgtemplate_info", ObjectSerialUtil.toByteSerialized((Object)bgTemplate));
            } else {
                tempId = bgTemplate.getId();
                t = BusinessDataServiceHelper.loadSingle((String)FORM_TEMPLATE_ENTITY, (String)"id, number, name, modifier, modifytime, tempversion,data, dataunit, dataset, varbaseforeb, templatecatalog, isreadonly, isrelation,dimrelationinfo2,dimmemdefaultdisplaytype,floatcalculate,runexaminewhenopen,runrulewhenopen,rptreadonly,synccalcrule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bgTemplate.getId())});
                Long templatecatalogid = t.getLong("templatecatalog.id");
                if (!QueryServiceHelper.exists((String)"eb_templatecatalog", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templatecatalogid)})) {
                    QFilter rootqfilter = new QFilter("parent", "=", (Object)0L);
                    DynamicObject root = QueryServiceHelper.queryOne((String)"eb_templatecatalog", (String)"id", (QFilter[])new QFilter[]{filter, rootqfilter});
                    if (root == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b\u6570\u636e\u5f02\u5e38\u3002", (String)"DynamicTemplateProcess_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    templatecatalogid = root.getLong("id");
                }
                if (Boolean.compare("1".equals(bgTemplate.getIsReadOnly()), t.getBoolean("isreadonly")) != 0) {
                    boolean hasInvalidReportStatus = QueryServiceHelper.exists((String)"eb_reportprocess", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)bgTemplate.getModelID()), new QFilter("template", "=", (Object)tempId), new QFilter("status", "in", Arrays.asList(BgTaskStateEnum.UNDERWAY.getNumber(), BgTaskStateEnum.COMPLETED.getNumber()))});
                    if (hasInvalidReportStatus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u5b58\u5728\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u7684\u62a5\u8868\u5b9e\u4f8b\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5206\u6790\u8868\u5c5e\u6027\u3002", (String)"DynamicTemplateProcess_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String updateStatus = "1".equals(bgTemplate.getIsReadOnly()) ? BgTaskStateEnum.READONLY.getNumber() : BgTaskStateEnum.UNPREPARED.getNumber();
                    DB.execute((DBRoute)new DBRoute("epm"), (String)"update t_eb_reportprocess set fstatus = ? where fmodel = ? and ftemplate = ?", (Object[])new Object[]{updateStatus, bgTemplate.getModelID(), tempId});
                }
                if (Boolean.compare(bgTemplate.getRptReadOnly(), t.getBoolean("rptreadonly")) != 0 && bgTemplate.getRptReadOnly().booleanValue()) {
                    DB.execute((DBRoute)new DBRoute("epm"), (String)"update t_eb_reportprocess set fstatus = ? where fmodel = ? and ftemplate = ? and fstatus = '7'", (Object[])new Object[]{BgTaskStateEnum.UNPREPARED.getNumber(), bgTemplate.getModelID(), tempId});
                }
                t.set("tempversion", (Object)TemplateUpdateStatus.SUCCEED);
                t.set("templatecatalog", (Object)templatecatalogid);
                t.set("name", (Object)bgTemplate.getName());
                t.set("number", (Object)bgTemplate.getNumber());
                t.set("modifier", (Object)UserUtils.getUserId());
                t.set("modifyTime", (Object)TimeServiceHelper.now());
                t.set("dataunit", (Object)bgTemplate.getDataunit());
                t.set("dataset", (Object)bgTemplate.getDatasetID());
                t.set("dimmemdefaultdisplaytype", (Object)bgTemplate.getDimMemDefaultDisplayType());
                bgTemplate.setVarBase(TemplateVarCommonUtil.getVarbaseforeb((Map)this.getTemplateModel().retrieveQuoteMembers()));
                t.set(VARBASEVALUE, (Object)bgTemplate.getVarBase());
                this.templateModel.setTemplateBaseInfo(bgTemplate);
                t.set("data", (Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)this.templateModel));
                t.set("isreadonly", (Object)"1".equals(bgTemplate.getIsReadOnly()));
                t.set("isrelation", (Object)"1".equals(bgTemplate.getIsDimRelation()));
                t.set("floatcalculate", (Object)"1".equals(bgTemplate.getFloatcalculate()));
                TemplateHelper.setDynamicObjectRunExamineOrRuleWhenOpen((DynamicObject)t, (BgTemplate)bgTemplate);
                if ("1".equals(bgTemplate.getIsReadOnly())) {
                    t.set("rptreadonly", (Object)true);
                } else {
                    t.set("rptreadonly", (Object)bgTemplate.getRptReadOnly());
                }
                t.set("synccalcrule", (Object)bgTemplate.isSyncCalcRule());
                DynamicObjectCollection dimrelationinfos = t.getDynamicObjectCollection("dimrelationinfo2");
                List dimRelations = bgTemplate.getDimRelations();
                dimrelationinfos.clear();
                if (dimRelations != null) {
                    for (Long dimRelation : dimRelations) {
                        DynamicObject basedata = new DynamicObject(dimrelationinfos.getDynamicObjectType());
                        basedata.set("fbasedataid", (Object)dimRelation);
                        dimrelationinfos.add((Object)basedata);
                    }
                }
                try (TXHandle required = TX.required((String)"");){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{t});
                        RuleRelationService.getInstance().bindRuleToTemplate(tempId.longValue());
                        AnalyseReportUtil.getInstance().upRptSection4TempChange(this.templateModel);
                    }
                    catch (Exception ex) {
                        required.markRollback();
                        throw ex;
                    }
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DynamicTemplateProcess_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(ISDATACHANGED, null);
            this.lockReport();
            ITemplateModel iTemplateModel = this.getTemplateModel();
            iTemplateModel.setTemplateBaseInfo(bgTemplate);
            this.saveMemberQuote(iTemplateModel);
            this.saveWeaveDescAttachment(tempId);
            this.saveF7items();
            MobReportHelper.saveConfig((BgTemplate)bgTemplate, (String)this.getPageCache().get("MobReportDisplayConfig"), (IModelCacheHelper)this.getModelCacheHelper());
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "DynamicTemplateProcess_12", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6a21\u677f\u201c%1$s\u201d\u5df2\u4fdd\u5b58\u3002", "DynamicTemplateProcess_13", "epm-eb-formplugin");
            this.writeLog(bgTemplate.getNumber(), "save", opNameBridge, opDescBridge, new String[]{bgTemplate.getName()});
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            if (e instanceof VarException) {
                this.getView().showMessage(e.getMessage());
            }
            throw new KDBizException(e.getMessage());
        }
    }

    private void showMetricStyleForm() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EB_METRICCELLSTYLE);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_METRICCELLSTYLE);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(KEY_MODEL_ID, this.getView().getFormShowParameter().getCustomParam(KEY_MODEL_ID));
        formShowParameter.setCustomParam(DIMMEMBER_DEFAULTSHOWTYPE, (Object)this.getTemplateModel().getTemplateBaseInfo().getDimMemDefaultDisplayType());
        if (this.getPageCache().get("TemplateModel") != null) {
            formShowParameter.setCustomParam("TemplateModel", (Object)this.getPageCache().get("TemplateModel"));
        } else if (this.getView().getFormShowParameter().getCustomParam("TemplateModel") != null) {
            formShowParameter.setCustomParam("TemplateModel", this.getView().getFormShowParameter().getCustomParam("TemplateModel"));
        }
        this.getView().showForm(formShowParameter);
    }

    private void showPartitionSettingForm() {
        String startPos = "A1";
        if (this.getSpreadSelector() != null) {
            startPos = this.getSpreadSelector().getStartPosition();
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_PARTITIONSETTING);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_PARTITIONSETTING);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5206\u533a\u8bbe\u7f6e", (String)"DynamicTemplateProcess_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("startPos", (Object)startPos);
        formShowParameter.setCustomParam(KEY_MODEL_ID, this.getView().getFormShowParameter().getCustomParam(KEY_MODEL_ID));
        if (this.getPageCache().get("bgtemplate_info") != null) {
            formShowParameter.setCustomParam("bgtemplate_info", (Object)this.getPageCache().get("bgtemplate_info"));
        } else {
            formShowParameter.setCustomParam("bgtemplate_info", this.getView().getFormShowParameter().getCustomParam("bgtemplate_info"));
        }
        if (this.getPageCache().get("TemplateModel") != null) {
            formShowParameter.setCustomParam("TemplateModel", (Object)this.getPageCache().get("TemplateModel"));
        } else if (this.getView().getFormShowParameter().getCustomParam("TemplateModel") != null) {
            formShowParameter.setCustomParam("TemplateModel", this.getView().getFormShowParameter().getCustomParam("TemplateModel"));
        }
        if (this.getPageCache().get(VARBASEVALUE) != null) {
            formShowParameter.setCustomParam(VARBASEVALUE, (Object)this.getPageCache().get(VARBASEVALUE));
        } else if (this.getView().getFormShowParameter().getCustomParam(VARBASEVALUE) != null) {
            formShowParameter.setCustomParam(VARBASEVALUE, this.getView().getFormShowParameter().getCustomParam(VARBASEVALUE));
        }
        this.getView().showForm(formShowParameter);
    }

    public void setTemplateModel(ITemplateModel templateModel) {
        this.templateModel = templateModel;
    }

    public ITemplateModel getTemplateModel() {
        if (this.templateModel != null) {
            return this.templateModel;
        }
        String template = this.getPageCache().get("TemplateModel");
        if (StringUtils.isEmpty((String)template)) {
            template = (String)this.getView().getFormShowParameter().getCustomParam("TemplateModel");
        }
        this.templateModel = StringUtils.isEmpty((String)template) ? TemplateFactory.buildTemplateModel() : TemplateModelJSONUtil.parseITemplateModel((String)template);
        String templateinfo = this.getPageCache().get("bgtemplate_info");
        if (StringUtils.isEmpty((String)templateinfo)) {
            templateinfo = (String)this.getView().getFormShowParameter().getCustomParam("bgtemplate_info");
        }
        if (StringUtils.isNotEmpty((String)templateinfo)) {
            this.templateModel.setTemplateBaseInfo((BgTemplate)ObjectSerialUtil.deSerializedBytes((String)templateinfo));
        }
        return this.templateModel;
    }

    public void cacheTemplateModel() {
        this.getPageCache().put("TemplateModel", TemplateModelJSONUtil.toJSONString((ITemplateModel)this.templateModel));
        this.getPageCache().put("bgtemplate_info", ObjectSerialUtil.toByteSerialized((Object)this.templateModel.getTemplateBaseInfo()));
    }

    public void cellClick(SpreadSelector selector) {
        String pageId = this.getPageCache().get("pageid");
        if (pageId == null) {
            return;
        }
        if (this.getSpreadSelector() != null) {
            IFormView mainPageView = this.getView().getMainView();
            if (mainPageView == null) {
                return;
            }
            IFormView childFormView = mainPageView.getView(pageId);
            if (childFormView == null) {
                return;
            }
            if (EB_PARTITIONSETTING.equals(childFormView.getFormShowParameter().getFormId())) {
                String startfocus;
                IPageCache pageCache = childFormView.getPageCache();
                if (pageCache != null && StringUtils.isNotEmpty((String)(startfocus = pageCache.get("startfocus")))) {
                    IDataModel imodel = childFormView.getModel();
                    imodel.setValue("firstgrid", (Object)this.getSpreadSelector().getStartPosition());
                    this.getView().sendFormAction(childFormView);
                    pageCache.remove("startfocus");
                }
            } else if (EB_MOBREPORTSETTING.equals(childFormView.getFormShowParameter().getFormId())) {
                ISheet sheet = this.getSheetCellDimMems(selector);
                MobReportSettingPlugin plugin = new MobReportSettingPlugin();
                this.getPageCache().put("rect", this.getSpreadSelector().getRect());
                plugin.setView(childFormView);
                plugin.fillSpreadAp(sheet);
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    public void cellValueUpdate(CellValueEvent cellValueEvent) {
        super.cellValueUpdate(cellValueEvent);
    }

    private void refreshTemplateModel() {
        Long id = this.getTemplateModel().getTemplateBaseInfo().getId();
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)FORM_TEMPLATE_ENTITY);
            String template = dynamicObject.getString("data");
            this.templateModel = TemplateModelJSONUtil.parseITemplateModel((String)template);
            this.getPageCache().put("TemplateModel", template);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    private void lockReport() {
        if (this.getView().getEntityId().contains("examine")) {
            return;
        }
        Long templateid = this.getTemplateModel().getTemplateBaseInfo().getId();
        if (templateid != null && templateid != 0L) {
            TemplateMutexServiceHelper.lock((Long)this.getTemplateModel().getTemplateBaseInfo().getId(), (Long)this.getTemplateModel().getModelId());
        }
    }

    private void unlockReport() {
        Long templateid = this.getTemplateModel().getTemplateBaseInfo().getId();
        if (templateid != null && templateid != 0L) {
            TemplateMutexServiceHelper.unlock((Long)templateid, (Long)this.getTemplateModel().getModelId());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void virtualModelCallBack(Object dataInfo) {
        try {
            if (!(dataInfo instanceof LinkedHashMap)) return;
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public void setSpreadKey(String spreadKey) {
        this.spreadKey = spreadKey;
    }

    public void saveMemberQuote(ITemplateModel templateModel) {
        if (templateModel != null) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
            Long resourceId = templateModel.getTemplateBaseInfo().getId();
            Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
            List quotes = QuoteTemplateBuilder.get().build(templateModel.getModelId(), datasetId, templateModel, resourceId, modelCacheHelper);
            if (!quotes.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
            }
        }
    }

    private void saveF7items() {
        Long templateid = this.getTemplateModel().getTemplateBaseInfo().getId();
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (StringUtils.isEmpty((String)f7SelectedStr)) {
            TemplateHelper.delDimproperty(Collections.singletonList(templateid));
            return;
        }
        List f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        List propertyPks = TemplateHelper.isExistsPropertySetDy((long)templateid);
        DynamicObject dimPropertySetDy = null;
        if (propertyPks.size() == 0) {
            Long modelId = this.getTemplateModel().getModelId();
            dimPropertySetDy = TemplateHelper.createDimPropertyDy((List)f7items, (Long)templateid, (String)"", (Long)modelId);
        } else {
            dimPropertySetDy = BusinessDataServiceHelper.loadSingle(propertyPks.get(0), (String)"eb_dimproperty");
            dimPropertySetDy = TemplateHelper.modifyDimPropertyDy((List)f7items, (DynamicObject)dimPropertySetDy);
        }
        try (TXHandle h = TX.requiresNew((String)"epm_DynamicSaveF7items");){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimPropertySetDy});
        }
    }

    private void initDimPropertyData() {
        Long templateid = this.getTemplateModel().getTemplateBaseInfo().getId();
        if (templateid == 0L) {
            return;
        }
        List propertyDyIds = TemplateHelper.isExistsPropertySetDy((long)templateid);
        if (propertyDyIds.size() == 0) {
            return;
        }
        DynamicObject dimPropertySetDy = BusinessDataServiceHelper.loadSingle(propertyDyIds.get(0), (String)"eb_dimproperty");
        if (dimPropertySetDy == null) {
            return;
        }
        List f7items = TemplateHelper.getF7ItemByDy((DynamicObject)dimPropertySetDy);
        if (f7items.size() > 0) {
            this.getPageCache().put("CacheDimPropertySelected", SerializationUtils.toJsonString((Object)f7items));
        }
    }

    private Map<String, List<PropertyObj>> getPropertysMap() {
        Map<String, List<Object>> result = new LinkedHashMap<String, List<PropertyObj>>();
        Map<String, List<PropertyObj>> allPropertysMap = this.getAllPropertysMap();
        List<Map<String, String>> f7items = this.getF7PropertyMap();
        if (f7items.size() == 0 || allPropertysMap.size() == 0) {
            return result;
        }
        result = TemplateHelper.filterDimPropertysByNum(allPropertysMap, f7items);
        return result;
    }

    private List<Map<String, String>> getF7PropertyMap() {
        List<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        String f7dimPropertyJson = this.getPageCache().get("CacheDimPropertySelected");
        if (!StringUtils.isEmpty((String)f7dimPropertyJson)) {
            result = (List)SerializationUtils.fromJsonString((String)f7dimPropertyJson, List.class);
        }
        return result;
    }

    public Map<String, String> getAllDimMembNumByCell(Point point) {
        IEbSpreadManager spreadManager = this.getSpreadManager();
        CellDimMember cellDimMember = null;
        HashMap<String, String> dimNums = new HashMap<String, String>(16);
        if (spreadManager != null) {
            for (Map.Entry entry : spreadManager.getPageViewDims().entrySet()) {
                dimNums.put((String)entry.getKey(), ((PageViewDimMember)entry.getValue()).getNumber());
            }
            Map colPartMembs = spreadManager.getColpartitionDimMemsByCol(Integer.valueOf(point.x));
            for (String dimNum : spreadManager.getColpartitionDims()) {
                if (colPartMembs == null) continue;
                cellDimMember = (CellDimMember)colPartMembs.get(dimNum);
                if (cellDimMember != null) {
                    dimNums.put(dimNum, cellDimMember.getDimMemberNumber());
                    continue;
                }
                dimNums.put(dimNum, null);
            }
            Map map = spreadManager.getRowpartitionDimMemsByRow(Integer.valueOf(point.y));
            for (String dimNum : spreadManager.getRowpartitionDims()) {
                if (map == null) continue;
                cellDimMember = (CellDimMember)map.get(dimNum);
                if (cellDimMember != null) {
                    dimNums.put(dimNum, cellDimMember.getDimMemberNumber());
                    continue;
                }
                dimNums.put(dimNum, null);
            }
        }
        return dimNums;
    }

    private Map<String, List<PropertyObj>> getAllPropertysMap() {
        Map<String, List<PropertyObj>> allPropertyMap = new LinkedHashMap<String, List<PropertyObj>>();
        ArrayList<String> allDimsNum = new ArrayList<String>(16);
        IEbSpreadManager ebSpreadManager = this.getSpreadManager();
        allDimsNum.addAll(ebSpreadManager.getColpartitionDims());
        allDimsNum.addAll(ebSpreadManager.getRowpartitionDims());
        if (allDimsNum.size() > 0) {
            allPropertyMap = this.getPropertyMapByDimNum(allDimsNum);
        }
        return allPropertyMap;
    }

    private Map<String, List<PropertyObj>> getPropertyMapByDimNum(List<String> allDimsNum) {
        HashMap<String, List<PropertyObj>> result = new HashMap<String, List<PropertyObj>>(16);
        Map cachePropertyMap = new HashMap(16);
        if (this.getPageCache().get(ALLPROPERTYCACHEKEY) != null) {
            cachePropertyMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ALLPROPERTYCACHEKEY));
        }
        Set cacheDims = cachePropertyMap.keySet();
        List queryDims = allDimsNum.stream().filter(dimNum -> !cacheDims.contains(dimNum)).collect(Collectors.toList());
        if (queryDims.size() > 0) {
            Map propertyMap = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertysByNum(this.getTemplateModel().getModelId(), queryDims);
            for (String queryDim : queryDims) {
                if (propertyMap.containsKey(queryDim)) {
                    cachePropertyMap.put(queryDim, propertyMap.get(queryDim));
                    continue;
                }
                cachePropertyMap.put(queryDim, new ArrayList(16));
            }
        }
        for (String dimNum2 : allDimsNum) {
            result.put(dimNum2, (List<PropertyObj>)cachePropertyMap.get(dimNum2));
        }
        this.getPageCache().put(ALLPROPERTYCACHEKEY, ObjectSerialUtil.toByteSerialized(cachePropertyMap));
        return result;
    }

    protected void beforeResolveStyles() {
        super.beforeResolveStyles();
        Map rowColDimMemsMap = TemplateHelper.getRowColDimMemsMap((ITemplateModel)this.templateModel);
        List rowColDims = rowColDimMemsMap.keySet().stream().collect(Collectors.toList());
        Map propertyMap = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertysByNum(this.templateModel.getModelId(), rowColDims);
        this.setTitleDimName(this.templateModel, propertyMap);
    }

    private Map<String, Map<String, String>> getTemplateVars() {
        Map<String, Map<String, String>> returns = new HashMap<String, Map<String, String>>(16);
        if ("1".equals(TemplateVarCommonUtil.getVarbaseforeb((Map)this.getTemplateModel().retrieveQuoteMembers()))) {
            returns = TemplateVarCommonUtil.getVarIDNumberMap((String)"isNeedVar", (Long)this.getTemplateModel().getModelId());
        }
        return returns;
    }

    private String getVarDimName(String name, String number, String dimKey, Map<String, Map<String, String>> varNumberNameMap) {
        return TemplateVarCommonUtil.getVarDimName((String)name, (String)number, (String)dimKey, varNumberNameMap);
    }

    public void buildSpreadRowColDimension(int memberDisplayType, Map<String, List<PropertyObj>> propertyMap) {
        String memName;
        String name;
        String memName2;
        ECell cell;
        int col;
        int row;
        ArrayList longDisplayDimNums = new ArrayList(16);
        IEbSpreadManager ebSpreadManager = this.getSpreadManager();
        ISheet sheet = ebSpreadManager.getEbook().getSheet(0);
        int maxcol = ebSpreadManager.getEbook().getSheet(0).getRealMaxCols();
        int maxrow = ebSpreadManager.getEbook().getSheet(0).getRealMaxRows();
        int startcol = ebSpreadManager.getEbook().getSheet(0).getValueAreaColStart();
        int startrow = ebSpreadManager.getEbook().getSheet(0).getValueAreaRowStart();
        int rows = ebSpreadManager.getColpartitionDims().size();
        int cols = ebSpreadManager.getRowpartitionDims().size();
        if (propertyMap != null) {
            rows += DimPropertyHelper.getPropertyCount(propertyMap, (List)ebSpreadManager.getColpartitionDims());
            cols += DimPropertyHelper.getPropertyCount(propertyMap, (List)ebSpreadManager.getRowpartitionDims());
        }
        Map<String, Map<String, String>> varNumberNameMap = this.getTemplateVars();
        LinkedList<ECell> cells = new LinkedList<ECell>();
        for (row = startrow - rows; row < startrow; ++row) {
            for (col = startcol - cols; col < maxcol; ++col) {
                cell = sheet.getECellNotAdd(row, col);
                if (DimPropertyHelper.checkPropertyCell((ECell)cell) && cell.getUserObject("memname") != null) {
                    memName2 = cell.getUserObject("memname").toString();
                    this.setCellValueByDisplayType(memberDisplayType, cell, memName2, longDisplayDimNums);
                    cells.add(cell);
                    continue;
                }
                if (cell == null || cell.getValue() == null || !StringUtils.isNotEmpty((String)String.valueOf(cell.getValue())) || cell.getUserObject("number") == null) continue;
                name = Objects.isNull(cell.getUserObject("name")) ? String.valueOf(cell.getValue()) : String.valueOf(cell.getUserObject("name"));
                memName = this.getVarDimName(name, cell.getUserObject("number").toString(), String.valueOf(cell.getUserObject("dimnumber")), varNumberNameMap);
                this.setCellValueByDisplayType(memberDisplayType, cell, memName, longDisplayDimNums);
                cells.add(cell);
            }
        }
        for (row = startrow; row < maxrow; ++row) {
            for (col = startcol - cols; col < startcol; ++col) {
                cell = sheet.getECellNotAdd(row, col);
                if (DimPropertyHelper.checkPropertyCell((ECell)cell) && cell.getValue() != null && cell.getUserObject("memname") != null) {
                    memName2 = cell.getUserObject("memname").toString();
                    this.setCellValueByDisplayType(memberDisplayType, cell, memName2, longDisplayDimNums);
                    cells.add(cell);
                    continue;
                }
                if (cell == null || cell.getValue() == null || !StringUtils.isNotEmpty((String)String.valueOf(cell.getValue())) || cell.getUserObject("number") == null) continue;
                name = Objects.isNull(cell.getUserObject("name")) ? String.valueOf(cell.getValue()) : String.valueOf(cell.getUserObject("name"));
                memName = this.getVarDimName(name, cell.getUserObject("number").toString(), String.valueOf(cell.getUserObject("dimnumber")), varNumberNameMap);
                this.setCellValueByDisplayType(memberDisplayType, cell, memName, longDisplayDimNums);
                cells.add(cell);
            }
        }
        this.getspreadContainer().updateCellValue2(cells);
    }

    protected void switchAdjustRecordPanel() {
    }

    protected void checkDimsRelation(IFormView view, IModelCacheHelper modelCache, Map<String, String> dimMemberMap, IEbSpreadManager ebSpreadManager) {
    }

    public ITemplateModel updateDimProperty() {
        ITemplateModel templateModel = this.getTemplateModel();
        if (templateModel == null || templateModel.getPartitionSetting() == null) {
            return templateModel;
        }
        if (TemplateHelper.updateDimProperty((ITemplateModel)templateModel)) {
            this.cacheTemplateModel();
        }
        return templateModel;
    }

    private void openWeaveDescPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_weavedescription");
        ITemplateModel templateModel = this.getTemplateModel();
        BgTemplate bgTemplate = templateModel.getTemplateBaseInfo();
        if (bgTemplate.getId() != null && bgTemplate.getId() != 0L) {
            formShowParameter.setCustomParam("templateId", (Object)bgTemplate.getId());
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "weaveDes"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void saveWeaveDescAttachment(Long tempId) {
        if (tempId == null || tempId == 0L) {
            return;
        }
        String url = this.getPageCache().get("file_url");
        String desc = this.getPageCache().get("desc_info");
        String weaveId = this.getPageCache().get("weaveId");
        if (StringUtils.isEmpty((String)weaveId) || StringUtils.isEmpty((String)url) && StringUtils.isEmpty((String)desc)) {
            return;
        }
        AttachmentHelper.saveAttachInTemplate((Long)tempId, (String)url, (String)desc, (String)weaveId);
    }

    protected void afterResolveStyles() {
        super.afterResolveStyles();
        this.replaceFormulaCellValue();
    }

    protected void replaceFormulaCellValue() {
        Set numbers;
        ITemplateModel templateModel = this.getTemplateModel();
        String dataUnit = templateModel.getTemplateBaseInfo().getDataunit();
        Long modelId = templateModel.getModelId();
        Long entityViewId = 0L;
        String currentEntityViewId = this.getCurrentEntityViewId();
        if (StringUtils.isNotEmpty((String)currentEntityViewId)) {
            entityViewId = IDUtils.toLong((Object)currentEntityViewId);
        }
        String entityPageView = null;
        if (!templateModel.getRowcolDims().contains(SysDimensionEnum.Entity.getNumber()) && (numbers = (Set)this.getSpreadManager().getAlldimensionWithMembers().get(SysDimensionEnum.Entity.getNumber())) != null && !numbers.isEmpty()) {
            String entityNumberPageView = (String)numbers.iterator().next();
            Long viewId = (Long)templateModel.getDimemsionViews().get(SysDimensionEnum.Entity.getNumber());
            Member member = this.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), viewId, entityNumberPageView);
            if (member != null) {
                entityPageView = member.getName();
            }
        }
        Map datasMap = TemplateFormulaUtil.ofDatasMap((String)this.getProcessType(), (Long)this.getTaskProcessId(), (String)this.getCurrentEntityNumber(), (String)dataUnit, (Long)modelId, (int)MemberDisplayTypeEnum.NAME.getIndex(), (Long)entityViewId, entityPageView);
        TemplateFormulaUtil.getInstance().replaceFormulaCellValue(this.getSpreadContainer(), templateModel.getFormulaMap(), datasMap);
    }

    public Long getModelId() {
        Long _modelId = IDUtils.toLong((Object)this.getPageCache().get(KEY_MODEL_ID));
        if (IDUtils.isNull((Long)_modelId) && IDUtils.isNotNull((Long)(_modelId = IDUtils.toLong((Object)PluginUtils.getCustomParams((IFormView)this.getView(), (String)KEY_MODEL_ID))))) {
            this.getPageCache().put(KEY_MODEL_ID, _modelId.toString());
        }
        if (IDUtils.isNull((Long)_modelId) && IDUtils.isNotNull((Long)(_modelId = this.getTemplateModel().getModelId()))) {
            this.getPageCache().put(KEY_MODEL_ID, _modelId.toString());
        }
        return _modelId;
    }

    private boolean hasMutexPageOpen(String formId) {
        if (EB_PARTITIONSETTING.equals(formId) || EB_MOBREPORTSETTING.equals(formId)) {
            String pageId = this.getView().getPageId();
            return this.getView().getView(pageId + EB_PARTITIONSETTING) != null || this.getView().getView(pageId + EB_MOBREPORTSETTING) != null;
        }
        return false;
    }

    public String getBaseName(String controlType) {
        return "eb_dynamictemplate";
    }

    public Map<String, MainSubControlMsg> getControlTypeMap() {
        HashMap<String, MainSubControlMsg> controlTypeMap = new HashMap<String, MainSubControlMsg>(16);
        controlTypeMap.put("btn_save", new MainSubControlMsg("1"));
        return controlTypeMap;
    }

    public String getMainSubModelNumber() {
        if (this.getTemplateModel().getTemplateBaseInfo() != null && StringUtils.isNotEmpty((String)this.getTemplateModel().getTemplateBaseInfo().getNumber())) {
            return this.getTemplateModel().getTemplateBaseInfo().getNumber();
        }
        return super.getMainSubModelNumber();
    }

    public String getDataMeta(String controlType) {
        return FORM_TEMPLATE_ENTITY;
    }

    public Boolean needCheckNumber(String controlType) {
        Long id = this.getTemplateModel().getTemplateBaseInfo().getId();
        if (id != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getDataMeta(controlType), (String)"number", (QFilter[])qFilter.toArray());
            if (dynamicObject != null && !StringUtils.equals((String)this.getTemplateModel().getTemplateBaseInfo().getNumber(), (String)dynamicObject.getString("number"))) {
                return true;
            }
        }
        return false;
    }

    public Set<String> getNumbers(String controlType, Map<String, Object> otherParams) {
        HashSet<String> set = new HashSet<String>(2);
        if (this.getTemplateModel().getTemplateBaseInfo() != null && this.getTemplateModel().getTemplateBaseInfo().getId() != 0L && StringUtils.isNotEmpty((String)this.getTemplateModel().getTemplateBaseInfo().getNumber())) {
            set.add(this.getTemplateModel().getTemplateBaseInfo().getNumber());
        }
        return set;
    }
}

