/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgTaskConstant;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.report.reportview.FixReportProcess;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.formplugin.utils.FixReportRowColDeleteHelper;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.pageviewpanel.PageViewPanelDraw;

public class FixTemplatePreview
extends FixReportProcess {
    private static final String SPREADSEIAL = "spreadserial";
    private static final String NOT_REVIEW_TEMPLATE = "notreviewtemplate";
    private static final Log logger = LogFactory.getLog(FixTemplatePreview.class);
    private static final String LARGE_TEMPLAGE = "largeTemplate";
    private static final String FROM_BY_UPDATE = "fromByUpdate";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.queryNeedUpdateTemplate();
        this.setBtnVisible();
    }

    @Override
    protected Object getSpreadDataModelService() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.setIsPreview(true);
        super.afterCreateNewData(e);
    }

    private void setBtnVisible() {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)this.getView().getFormShowParameter().getFormId(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        LinkedList btns = new LinkedList();
        formMeta.getItems().forEach(item -> {
            if (item instanceof BarItemAp && !"btn_close".equals(item.getKey())) {
                if ("updatetemplate".equals(item.getKey())) {
                    String templateNeedUpdate = this.getPageCache().get(NOT_REVIEW_TEMPLATE);
                    if (StringUtils.isEmpty((String)templateNeedUpdate)) {
                        btns.add(item.getKey());
                        logger.info("\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6a21\u677f");
                    } else {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"updatetemplate"});
                    }
                } else {
                    btns.add(item.getKey());
                }
            }
        });
        btns.remove("btn_setgroup");
        btns.remove("btn_cancelgroup");
        btns.remove("btn_savepreview");
        if (!btns.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), btns.toArray(new String[0]));
        }
    }

    protected void invokeWorkOperations() {
    }

    @Override
    protected void firstRefreshData() {
    }

    @Override
    public void resolveSpreadLockController(List<ISpreadLockControl> spreadLockControls) {
    }

    @Override
    public void virtualModelCallBack(Object dataInfo) {
    }

    @Override
    public void cellClick(SpreadSelector selector) {
        this.setIsPreview(true);
        super.cellClick(selector);
    }

    @Override
    public void spreadF7Click(int row, int col) {
        this.setIsPreview(true);
        super.spreadF7Click(row, col);
    }

    protected void rebuildPageView() {
        ITemplateModel templateModel = this.getTemplateModel();
        this.setCacheVar(templateModel, SpreadTypeEnum.SPREADTYPE_VIEW.getIndex());
        PageViewPanelDraw pageViewPanelDraw = new PageViewPanelDraw(this.getView(), templateModel, this.getSpreadManager());
        pageViewPanelDraw.setNeedlockpage(false);
        pageViewPanelDraw.setShowHideDim(false);
        pageViewPanelDraw.setDefaultDimMember(this.getDefaultDimMember());
        pageViewPanelDraw.setExtraQfilter(this.getExtraQfilter());
        pageViewPanelDraw.setDrillthrough_key(this.getDrillthrough_key());
        pageViewPanelDraw.build();
        this.getView().setEnable(Boolean.valueOf(false), BgTaskConstant.getInstance().getF7Keys());
        this.getView().setEnable(Boolean.valueOf(false), BgTaskConstant.getInstance().getFilterKeys());
    }

    @Override
    protected void invokeSpreadJson() {
        String spreadserial = (String)this.getView().getFormShowParameter().getCustomParam(SPREADSEIAL);
        this.getspreadContainer().rebuildSpread(spreadserial);
        List areaRanges = this.getTemplateModel().getAreaRanges();
        FixReportRowColDeleteHelper.hiddenTemplateHyperLink((List)areaRanges, (ISpreadContainer)this.getspreadContainer());
        this.getspreadContainer().closeToolbar();
        this.invokeDeleteRowCol(true);
        this.getspreadContainer().getSpreadJson("replaceSpreadJson");
    }

    public void replaceSpreadJson(Object param) {
        if (this.getTemplateModel() != null && param instanceof Map) {
            String spreadserial = ((Map)param).get("data") + "";
            if (!"false".equals(this.getView().getFormShowParameter().getCustomParam("saveSpreadJson")) && !"true".equals(this.getView().getFormShowParameter().getCustomParam("resetOutLineInfo"))) {
                spreadserial = FixTemplateProcessHelper.replaceOutlineElements(this.getTemplateId(), spreadserial);
            }
            this.getspreadContainer().rebuildSpread(spreadserial);
            if (!"false".equals(this.getView().getFormShowParameter().getCustomParam("saveSpreadJson"))) {
                this.getspreadContainer().getSpreadJson("saveSpreadJson");
            }
        }
    }

    @Override
    public String getSpreadKey() {
        return "template_spread";
    }

    public void saveSpreadJson(Object param) {
        if (this.getTemplateModel() != null && param instanceof Map) {
            String spreadserial = ((Map)param).get("data") + "";
            Long templateId = this.getTemplateId();
            DeleteServiceHelper.delete((String)"eb_exportinfo", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)});
            DynamicObject dynamicObject = ORM.create().newDynamicObject("eb_exportinfo");
            dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
            dynamicObject.set("template", (Object)templateId);
            dynamicObject.set(SPREADSEIAL, (Object)spreadserial);
            dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        String notReviewTemplateStr = this.getPageCache().get(NOT_REVIEW_TEMPLATE);
        String fromByUpdate = this.getPageCache().get(FROM_BY_UPDATE);
        if (StringUtils.isNotEmpty((String)notReviewTemplateStr) && !"end".equals(notReviewTemplateStr) && StringUtils.isNotEmpty((String)fromByUpdate)) {
            List updateTamplate = (List)SerializationUtils.fromJsonString((String)notReviewTemplateStr, List.class);
            this.handleOneTemplateUpdate(updateTamplate);
        } else if ("end".equals(notReviewTemplateStr)) {
            this.getPageCache().remove(NOT_REVIEW_TEMPLATE);
            this.getView().hideLoading();
            String largeTemplateCache = this.getPageCache().get(LARGE_TEMPLAGE);
            if (StringUtils.isEmpty((String)largeTemplateCache)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5347\u7ea7\u5b8c\u6210\u3002", (String)"FixTemplatePreview_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                ArrayList arrayList = (ArrayList)SerializationUtils.fromJsonString((String)largeTemplateCache, ArrayList.class);
                if (CollectionUtils.isNotEmpty((Collection)arrayList)) {
                    this.getView().showConfirm(ResManager.loadResFormat((String)"\u90e8\u5206\u6a21\u677f\u65e0\u6cd5\u81ea\u52a8\u5347\u7ea7\uff0c\u8bf7\u624b\u52a8\u9884\u89c8\u5347\u7ea7\uff0c\u6a21\u677f\u7f16\u7801\u5982\u4e0b\uff1a%1\u3002", (String)"FixTemplatePreview_4", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", arrayList)}), MessageBoxOptions.OK);
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5347\u7ea7\u5b8c\u6210\u3002", (String)"FixTemplatePreview_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getPageCache().remove(LARGE_TEMPLAGE);
            }
        }
    }

    private void handleOneTemplateUpdate(List<Map<String, Object>> templateList) {
        Map<String, Object> map = templateList.get(0);
        templateList.remove(map);
        String fromByUpdate = this.getPageCache().get(FROM_BY_UPDATE);
        if (CollectionUtils.isNotEmpty(templateList)) {
            this.getPageCache().put(NOT_REVIEW_TEMPLATE, SerializationUtils.toJsonString(templateList));
        } else if (StringUtils.isNotEmpty((String)fromByUpdate)) {
            this.getPageCache().put(NOT_REVIEW_TEMPLATE, "end");
            this.getPageCache().remove(FROM_BY_UPDATE);
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)map.get("id"), (String)"eb_templateentity");
        if (dynamicObject == null) {
            return;
        }
        String spreadserial = dynamicObject.getString(SPREADSEIAL);
        logger.info("\u5f00\u59cb\u5347\u7ea7\u6a21\u677fid:{} \u540d\u79f0\uff1a{},size:{}", new Object[]{dynamicObject.getLong("id"), dynamicObject.getString("name"), spreadserial.length()});
        if (StringUtils.isNotEmpty((String)spreadserial) && spreadserial.length() > 250000) {
            logger.info("\u6a21\u677f\u8d85\u8fc7\u5141\u8bb8\u5927\u5c0f\u3001\u8bf7\u624b\u52a8\u9884\u89c8\u5347\u7ea7");
            this.recordErrorAndLargeTemplate(dynamicObject.getString("number"));
            if (CollectionUtils.isNotEmpty(templateList)) {
                this.saveSpreadJson(null);
                return;
            }
        }
        this.getView().getFormShowParameter().setCustomParam("templateid", (Object)dynamicObject.getLong("id"));
        this.getView().getFormShowParameter().setCustomParam(SPREADSEIAL, (Object)dynamicObject.getString(SPREADSEIAL));
        ITemplateModel templateModel = FixtemplateSerializerUtil.read((String)dynamicObject.getString("data"));
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(Long.valueOf(dynamicObject.getLong("id")));
        templateBaseInfo.setModelID(this.getModelId());
        templateBaseInfo.setDatasetID(Long.valueOf(dynamicObject.getLong("dataset.id")));
        templateBaseInfo.setNumber(dynamicObject.getString("number"));
        templateBaseInfo.setName(dynamicObject.getString("name"));
        templateBaseInfo.setTemplatetype(dynamicObject.getInt("templatetype"));
        templateBaseInfo.setVarBase(dynamicObject.getString("varbaseforeb"));
        templateBaseInfo.setDataunit(dynamicObject.getString("dataunit"));
        templateModel.setTemplateBaseInfo(templateBaseInfo);
        this.setTemplateModel(templateModel);
        this.getPageCache().put("bgtemplate_info", ObjectSerialUtil.toByteSerialized((Object)templateBaseInfo));
        try {
            this.afterCreateNewData(null);
        }
        catch (KDBizException e) {
            logger.error("\u5347\u7ea7\u6a21\u677f\u51fa\u9519", (Throwable)e);
            this.recordErrorAndLargeTemplate(dynamicObject.getString("number"));
            this.saveSpreadJson(null);
        }
    }

    private void recordErrorAndLargeTemplate(String templateNumber) {
        String largeTemplateCache = this.getPageCache().get(LARGE_TEMPLAGE);
        if (StringUtils.isEmpty((String)largeTemplateCache)) {
            ArrayList<String> arrayList = new ArrayList<String>(16);
            arrayList.add(templateNumber);
            this.getPageCache().put(LARGE_TEMPLAGE, SerializationUtils.toJsonString(arrayList));
        } else {
            ArrayList arrayList = (ArrayList)SerializationUtils.fromJsonString((String)largeTemplateCache, ArrayList.class);
            arrayList.add(templateNumber);
            this.getPageCache().put(LARGE_TEMPLAGE, SerializationUtils.toJsonString((Object)arrayList));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "updatetemplate": {
                String s = this.getPageCache().get(FROM_BY_UPDATE);
                if (StringUtils.isNotEmpty((String)s)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FixTemplatePreview_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(FROM_BY_UPDATE, "1");
                this.handleTemplateUpdate();
                break;
            }
            case "btn_setgroup": {
                this.setGroup(false);
                break;
            }
            case "btn_cancelgroup": {
                this.setGroup(true);
                break;
            }
            case "btn_savepreview": {
                this.getspreadContainer().getSpreadJson("savePreviewData");
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("eb_roworcolgroup".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            Map returnData = (Map)SerializationUtils.fromJsonString((String)((String)closedCallBackEvent.getReturnData()), Map.class);
            boolean isRow = Boolean.parseBoolean(returnData.get("isRow") + "");
            boolean isHide = Boolean.parseBoolean(returnData.get("isHide") + "");
            this.setColOrRowGroup(this.getSpreadSelector(), isRow, isHide);
        }
    }

    public void savePreviewData(Object param) {
        if (this.getTemplateModel() != null && param instanceof Map) {
            String spreadserial = ((Map)param).get("data") + "";
            Long templateId = this.getTemplateId();
            DeleteServiceHelper.delete((String)"eb_exportinfo", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)});
            DynamicObject dynamicObject = ORM.create().newDynamicObject("eb_exportinfo");
            dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
            dynamicObject.set("template", (Object)templateId);
            dynamicObject.set(SPREADSEIAL, (Object)spreadserial);
            dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DynamicReportProcess_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Long getTemplateId() {
        Long templateId = this.getTemplateModel().getTemplateBaseInfo().getId();
        if (IDUtils.isNull((Long)templateId)) {
            templateId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("templateid"));
        }
        return templateId;
    }

    private void setGroup(boolean isHide) {
        SpreadSelector selector = this.getSpreadSelector();
        if ("false".equals(this.getView().getFormShowParameter().getCustomParam("saveSpreadJson"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u672a\u4fdd\u5b58\uff0c\u8bf7\u9000\u51fa\u9884\u89c8\u540e\u4fdd\u5b58\u6216\u53d1\u5e03\u6a21\u677f\u540e\u518d\u64cd\u4f5c\u3002", (String)"FixTemplatePreview_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selector != null) {
            boolean colHeaderSelected;
            boolean rowHeaderSelected = selector.getStartCol() == 0 && selector.getEndCol() > 0;
            boolean bl = colHeaderSelected = selector.getStartRow() == 0 && selector.getEndRow() > 0;
            if (!rowHeaderSelected && !colHeaderSelected || rowHeaderSelected && colHeaderSelected) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("eb_roworcolgroup");
                showParameter.setCustomParam("isHide", (Object)isHide);
                if (isHide) {
                    showParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u6d88\u7ec4\u5408", (String)"FixTemplatePreview_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "eb_roworcolgroup");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
                return;
            }
            this.setColOrRowGroup(selector, rowHeaderSelected, isHide);
        }
    }

    private void setColOrRowGroup(SpreadSelector selector, boolean isRow, boolean isHide) {
        if (selector != null) {
            int index = isRow ? selector.getStartRow() : selector.getStartCol();
            int count = isRow ? selector.getEndRow() - selector.getStartRow() : selector.getEndCol() - selector.getStartCol();
            this.getspreadContainer().setRowColumnOutlines(count + 1, index, 0, isRow, isHide);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.getPageCache().remove("resetOutLineInfo");
            }
        }
    }

    private void queryNeedUpdateTemplate() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("templatetype", "=", (Object)"4");
        qFilter.and("templatestatus", "=", (Object)"B");
        String selectFields = "id,modifytime";
        DynamicObjectCollection updateTamplate = QueryServiceHelper.query((String)"updateTamplate", (String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        ArrayList templateList = new ArrayList(updateTamplate.size());
        if (CollectionUtils.isNotEmpty((Collection)updateTamplate)) {
            for (DynamicObject next : updateTamplate) {
                HashMap<String, Comparable<Long>> temp = new HashMap<String, Comparable<Long>>(16);
                temp.put("id", Long.valueOf(next.getLong("id")));
                temp.put("modifytime", next.getDate("modifytime"));
                templateList.add(temp);
            }
            Set templateIdSet = updateTamplate.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            QFilter qFilter1 = new QFilter("template", "in", templateIdSet);
            DynamicObjectCollection exportinfo = QueryServiceHelper.query((String)"exportinfo", (String)"eb_exportinfo", (String)"template,createtime", (QFilter[])new QFilter[]{qFilter1}, null);
            if (CollectionUtils.isNotEmpty((Collection)exportinfo)) {
                Map<Long, List<DynamicObject>> exportMap = exportinfo.stream().collect(Collectors.groupingBy(x -> x.getLong("template")));
                Iterator iterator = templateList.iterator();
                while (iterator.hasNext()) {
                    Map next = (Map)iterator.next();
                    List<DynamicObject> dynamicObjects = exportMap.get(IDUtils.toLong(next.get("id")));
                    if (!CollectionUtils.isNotEmpty(dynamicObjects)) continue;
                    DynamicObject dynamicObject = dynamicObjects.get(0);
                    Date createtime = dynamicObject.getDate("createtime");
                    Date modifytime = (Date)next.get("modifytime");
                    if (createtime != null && createtime.compareTo(modifytime) < 0) continue;
                    iterator.remove();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(templateList)) {
            this.getPageCache().put(NOT_REVIEW_TEMPLATE, SerializationUtils.toJsonString(templateList));
        }
    }

    private void handleTemplateUpdate() {
        String notReviewTemplateStr = this.getPageCache().get(NOT_REVIEW_TEMPLATE);
        List<Map<String, Object>> templateList = new ArrayList(16);
        if (StringUtils.isNotEmpty((String)notReviewTemplateStr) && !"end".equals(notReviewTemplateStr)) {
            templateList = (List)SerializationUtils.fromJsonString((String)notReviewTemplateStr, List.class);
        }
        if (CollectionUtils.isEmpty(templateList)) {
            this.queryNeedUpdateTemplate();
            notReviewTemplateStr = this.getPageCache().get(NOT_REVIEW_TEMPLATE);
            if (StringUtils.isNotEmpty((String)notReviewTemplateStr) && !"end".equals(notReviewTemplateStr)) {
                templateList = (List)SerializationUtils.fromJsonString((String)notReviewTemplateStr, List.class);
            }
        }
        if (CollectionUtils.isEmpty(templateList)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5347\u7ea7\u5b8c\u6210\u3002", (String)"FixTemplatePreview_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        logger.info("\u5347\u7ea7\u5f00\u59cb\uff0c\u603b\u5171{}\u4e2a\u6a21\u677f\u5f85\u5347\u7ea7", (Object)templateList.size());
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"FixTemplatePreview_2", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        this.handleOneTemplateUpdate(templateList);
    }

    @Override
    public Long getModelId() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (customParam == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)customParam);
    }
}

