/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.util.DataAndJsonTranslator;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.BorderStyleEnum;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.HorizontalAlignEnum;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.CellHyperLinkPOJO;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.DimPropertyHelper;

public class FixTemplateProcessHelper {
    public static final String ROW = "row";
    public static final String COL = "col";
    public static final String ROWCOL = "rowcol";

    public static IMultiAreaSetting getAreaSettingOnRowCol(int row, int col, List<IMultiAreaSetting> areaSettings) {
        if (areaSettings == null || areaSettings.isEmpty()) {
            return null;
        }
        for (IMultiAreaSetting area : areaSettings) {
            String[] startEndPos;
            if (area.getAreaRange() == null || (startEndPos = area.getAreaRange().split(":")).length != 2) continue;
            Point startPoint = ExcelUtils.pos2Point((String)startEndPos[0]);
            Point endPoint = ExcelUtils.pos2Point((String)startEndPos[1]);
            if (row < startPoint.y || row > endPoint.y || col < startPoint.x || col > endPoint.x) continue;
            return area;
        }
        return null;
    }

    public static ECell getECellOnRowCol(int row, int col, List<IMultiAreaSetting> areaSettings) {
        if (areaSettings == null || areaSettings.isEmpty()) {
            return null;
        }
        IMultiAreaSetting area = FixTemplateProcessHelper.getAreaSettingOnRowCol(row, col, areaSettings);
        if (area != null && area.getAreaSheet() != null) {
            Point dataPoint = FixTemplateProcessHelper.getAbsolutePosPoint(area.getAreaRange(), area.getStartPosition());
            int areaRowIndex = row - (dataPoint == null ? 0 : dataPoint.y);
            int areaColIndex = col - (dataPoint == null ? 0 : dataPoint.x);
            if (areaRowIndex >= 0 && areaColIndex >= 0) {
                return area.getAreaSheet().getECellNotAdd(areaRowIndex, areaColIndex);
            }
        }
        return null;
    }

    public static List<IMultiAreaSetting> getListOverlapAreaRange(String tarArea, List<IMultiAreaSetting> sourceAreas) {
        if (StringUtils.isEmpty((String)tarArea) || sourceAreas == null || sourceAreas.isEmpty()) {
            return null;
        }
        ArrayList<IMultiAreaSetting> areaSettings = new ArrayList<IMultiAreaSetting>(16);
        for (IMultiAreaSetting e : sourceAreas) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRange(), (String)tarArea)) continue;
            areaSettings.add(e);
        }
        return areaSettings;
    }

    public static List<String> getListOverlapAreaRangeStr(String tarArea, List<String> sourceAreas) {
        if (StringUtils.isEmpty((String)tarArea) || sourceAreas == null || sourceAreas.isEmpty()) {
            return null;
        }
        ArrayList<String> areaSettings = new ArrayList<String>(16);
        for (String e : sourceAreas) {
            if (!ExcelUtils.isOverlap((String)e, (String)tarArea)) continue;
            areaSettings.add(e);
        }
        return areaSettings;
    }

    public static String getExpendedAreaRange(String area, int rowCount, int colCount) {
        if (area == null) {
            return null;
        }
        String[] areaRange = area.split(":");
        if (areaRange.length == 2) {
            Point endPoint = ExcelUtils.pos2Point((String)areaRange[1]);
            return areaRange[0] + ":" + ExcelUtils.xy2Pos((int)(endPoint.x + colCount), (int)(endPoint.y + rowCount));
        }
        return null;
    }

    public static String getShrinkedAreaRange(String area, int rowCount, int colCount) {
        if (area == null) {
            return null;
        }
        String[] areaRange = area.split(":");
        if (areaRange.length == 2) {
            Point endPoint = ExcelUtils.pos2Point((String)areaRange[1]);
            return areaRange[0] + ":" + ExcelUtils.xy2Pos((int)(endPoint.x - colCount), (int)(endPoint.y - rowCount));
        }
        return null;
    }

    public static void rePositionAreaRanges(List<Integer> rowindexs, List<Integer> colindexs, List<IMultiAreaSetting> areaRanges, boolean isDeletion) {
        if (areaRanges == null || areaRanges.isEmpty()) {
            return;
        }
        areaRanges.forEach(area -> {
            String[] startEndPos = area.getAreaRange().split(":");
            Point startPoint = ExcelUtils.pos2Point((String)startEndPos[0]);
            Point endPoint = ExcelUtils.pos2Point((String)startEndPos[1]);
            int sr = startPoint.y;
            int sc = startPoint.x;
            int er = endPoint.y;
            int ec = endPoint.x;
            if (rowindexs != null) {
                for (Integer i : rowindexs) {
                    if (isDeletion) {
                        sr = i <= sr ? sr - 1 : sr;
                        er = i <= er ? er - 1 : er;
                        continue;
                    }
                    sr = i <= sr ? sr + 1 : sr;
                    er = i <= er ? er + 1 : er;
                }
            }
            if (colindexs != null) {
                for (Integer i : colindexs) {
                    if (isDeletion) {
                        sc = i <= sc ? sc - 1 : sc;
                        ec = i <= ec ? ec - 1 : ec;
                        continue;
                    }
                    sc = i <= sc ? sc + 1 : sc;
                    ec = i <= ec ? ec + 1 : ec;
                }
            }
            if (sr != startPoint.y || sc != startPoint.x || er != endPoint.y || ec != endPoint.x) {
                area.setAreaRange(ExcelUtils.xy2Pos((int)sc, (int)sr) + ":" + ExcelUtils.xy2Pos((int)ec, (int)er));
            }
        });
    }

    public static String getXYRelatedToAreaRange(String areaRange, String absolutePosition) {
        if (StringUtils.isEmpty((String)areaRange) || StringUtils.isEmpty((String)absolutePosition)) {
            return null;
        }
        String[] areaStartEndPos = areaRange.split(":");
        if (areaStartEndPos.length == 2) {
            Point areaStartPoint = ExcelUtils.pos2Point((String)areaStartEndPos[0]);
            Point absPoint = ExcelUtils.pos2Point((String)absolutePosition);
            return absPoint.x - areaStartPoint.x + ":" + (absPoint.y - areaStartPoint.y);
        }
        return null;
    }

    public static Point absRelatedToAreaDataPoint(IMultiAreaSetting multiAreaSetting, String absolutePosition) {
        if (multiAreaSetting == null || StringUtils.isEmpty((String)absolutePosition)) {
            return null;
        }
        String xyRelated = FixTemplateProcessHelper.getXYRelatedToAreaRange(multiAreaSetting.getAreaRange(), absolutePosition);
        String xyStartPos = multiAreaSetting.getStartPosition();
        if (xyRelated != null && xyStartPos != null) {
            return new Point(Integer.parseInt(xyRelated.split(":")[0]) - Integer.parseInt(xyStartPos.split(":")[0]), Integer.parseInt(xyRelated.split(":")[1]) - Integer.parseInt(xyStartPos.split(":")[1]));
        }
        return null;
    }

    public static Point getAbsolutePosPoint(String areaRange, String relatedPosition) {
        if (StringUtils.isEmpty((String)areaRange) || StringUtils.isEmpty((String)relatedPosition)) {
            return null;
        }
        String[] startEndPos = areaRange.split(":");
        String[] relatedPos = relatedPosition.split(":");
        if (startEndPos.length == 2 || relatedPos.length == 2) {
            Point startPoint = ExcelUtils.pos2Point((String)startEndPos[0]);
            Point dataPoint = new Point(Integer.parseInt(relatedPos[0]), Integer.parseInt(relatedPos[1]));
            return new Point(dataPoint.x + startPoint.x, dataPoint.y + startPoint.y);
        }
        return null;
    }

    public static String getValidFloatRange(IMultiAreaSetting areaSetting, Map<String, List<PropertyObj>> propertyMap) {
        if (areaSetting != null && areaSetting.getStartPosition() != null && areaSetting.getAreaRange() != null) {
            String areaRange = areaSetting.getAreaRange();
            String[] startPosSplit = areaSetting.getStartPosition().split(":");
            String[] areaRangeSplit = areaRange.split(":");
            Point endPos = ExcelUtils.pos2Point((String)areaRangeSplit[1]);
            int startPos_x = Integer.parseInt(startPosSplit[0]);
            int startPos_y = Integer.parseInt(startPosSplit[1]);
            int rowSize = areaSetting.getRowdims().size();
            int colSize = areaSetting.getColdims().size();
            if (propertyMap != null) {
                rowSize += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getRowdims());
                colSize += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getColdims());
            }
            Point startPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaRange, startPos_x + ":" + (startPos_y + colSize));
            Point endPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaRange, startPos_x + rowSize - 1 + ":" + endPos.y);
            if (startPoint != null && endPoint != null) {
                return ExcelUtils.xy2Pos((int)startPoint.x, (int)startPoint.y) + ":" + ExcelUtils.xy2Pos((int)endPoint.x, (int)endPos.y);
            }
        }
        return null;
    }

    public static String checkRowColOverlap(String selectedArea, List<IMultiAreaSetting> areaSettings) {
        if (StringUtils.isEmpty((String)selectedArea) || selectedArea.indexOf(":") < 0 || areaSettings == null || areaSettings.isEmpty()) {
            return null;
        }
        boolean rowOverlap = false;
        boolean colOverlap = false;
        String[] startEndPos = selectedArea.split(":");
        String[] tempStartEndPos = null;
        Point startPoint = ExcelUtils.pos2Point((String)startEndPos[0]);
        Point endPoint = ExcelUtils.pos2Point((String)startEndPos[1]);
        for (IMultiAreaSetting areaSetting : areaSettings) {
            if (areaSetting.getAreaRange() == null || (tempStartEndPos = areaSetting.getAreaRange().split(":")).length != 2) continue;
            Point tempStartPoint = ExcelUtils.pos2Point((String)tempStartEndPos[0]);
            Point tempEndPoint = ExcelUtils.pos2Point((String)tempStartEndPos[1]);
            if (startPoint.y <= tempEndPoint.y && endPoint.y >= tempStartPoint.y) {
                rowOverlap = true;
            }
            if (startPoint.x > tempEndPoint.x || endPoint.x < tempStartPoint.x) continue;
            colOverlap = true;
        }
        return rowOverlap && colOverlap ? ROWCOL : (rowOverlap ? ROW : (colOverlap ? COL : null));
    }

    public static String checkRowColOverlapOnAreas(List<IMultiAreaSetting> areaSettings) {
        if (areaSettings == null || areaSettings.size() < 2) {
            return null;
        }
        boolean rowOverlap = false;
        boolean colOverlap = false;
        for (int i = 0; i < areaSettings.size(); ++i) {
            for (int j = i + 1; j < areaSettings.size(); ++j) {
                String[] startEndPos1 = areaSettings.get(i).getAreaRange().split(":");
                String[] startEndPos2 = areaSettings.get(j).getAreaRange().split(":");
                Point startPoint1 = ExcelUtils.pos2Point((String)startEndPos1[0]);
                Point endPoint1 = ExcelUtils.pos2Point((String)startEndPos1[1]);
                Point startPoint2 = ExcelUtils.pos2Point((String)startEndPos2[0]);
                Point endPoint2 = ExcelUtils.pos2Point((String)startEndPos2[1]);
                if (startPoint1.y <= endPoint2.y && endPoint1.y >= startPoint2.y) {
                    rowOverlap = true;
                }
                if (startPoint1.x <= endPoint2.x && endPoint1.x >= startPoint2.x) {
                    colOverlap = true;
                }
                if (!rowOverlap || !colOverlap) continue;
                return ROWCOL;
            }
        }
        return rowOverlap && colOverlap ? ROWCOL : (rowOverlap ? ROW : (colOverlap ? COL : null));
    }

    public static boolean validateArea(String area) {
        if (StringUtils.isEmpty((String)area.trim())) {
            return false;
        }
        String[] startEndPos = area.split(":");
        if (startEndPos.length == 2) {
            try {
                Point startPoint = ExcelUtils.pos2Point((String)startEndPos[0]);
                Point endPoint = ExcelUtils.pos2Point((String)startEndPos[1]);
                return startPoint.x <= endPoint.x && startPoint.y <= endPoint.y;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String validateAreaStartPosition(String area, String startPosition) {
        if (StringUtils.isEmpty((String)area)) {
            return ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6570\u636e\u533a\u57df\u3002", (String)"FixTemplateProcessHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)startPosition)) {
            return ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8d77\u59cb\u5355\u5143\u683c\u3002", (String)"FixTemplateProcessHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        String[] areaSplit = area.split(":");
        if (areaSplit.length != 2) {
            return ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6570\u636e\u533a\u57df\u3002", (String)"FixTemplateProcessHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        try {
            return ExcelUtils.checkPosValidata((String)areaSplit[0], (String)areaSplit[1], (String)startPosition);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static void sortAreas(List<IMultiAreaSetting> areaSettings) {
        if (areaSettings == null || areaSettings.size() == 0) {
            return;
        }
        if (areaSettings.size() > 1) {
            String overlapType = FixTemplateProcessHelper.checkRowColOverlapOnAreas(areaSettings);
            if (COL.equals(overlapType)) {
                areaSettings.sort(Comparator.comparingInt(a -> ExcelUtils.pos2Point((String)a.getAreaRange().split((String)":")[0]).y));
            } else {
                areaSettings.sort(Comparator.comparingInt(a -> ExcelUtils.pos2Point((String)a.getAreaRange().split((String)":")[0]).x));
            }
        }
        areaSettings.forEach(a -> {
            List floatInfos = a.getFloatInfos();
            if (floatInfos != null && floatInfos.size() > 1) {
                if (a.getFloatOnWhere() == 1) {
                    floatInfos.sort(Comparator.comparingInt(f -> f.getCol_offset()));
                } else {
                    floatInfos.sort(Comparator.comparingInt(f -> f.getRow_offset()));
                }
            }
        });
    }

    public static void copyCellsByUserObject(ISheet source, ISheet target, String userObjKey, Set userObjVals, boolean includeFloatCell) {
        if (source == null || target == null || StringUtils.isEmpty((String)userObjKey) || userObjVals == null) {
            return;
        }
        int maxCols = source.getRealMaxCols();
        int maxRows = source.getRealMaxRows();
        for (int r = 0; r < maxRows; ++r) {
            for (int c = 0; c < maxCols; ++c) {
                ECell eCell = source.getECellNotAdd(r, c);
                if (eCell == null) continue;
                Boolean isPropertyCell = DimPropertyHelper.checkPropertyCell((ECell)eCell);
                String propertyDimNum = "";
                if (eCell.getUserObject("dimnum") != null) {
                    propertyDimNum = eCell.getUserObject("dimnum").toString();
                }
                if ((!isPropertyCell.booleanValue() || !userObjVals.contains(propertyDimNum)) && !userObjVals.contains(eCell.getUserObject(userObjKey)) && (!eCell.isFloatCell() || !includeFloatCell)) continue;
                ECell targetCell = target.getECell(r, c);
                targetCell.setValue(eCell.getValue());
                if (eCell.hasUserObject()) {
                    targetCell.setUserObject(eCell.getUserObject());
                }
                targetCell.setFloatCell(eCell.isFloatCell());
            }
        }
    }

    public static CellArea getDataCellArea(String selectedArea, ITemplateModel templateModel) {
        IMultiAreaSetting areaSetting = templateModel.getAreaRangeByArea(selectedArea);
        if (areaSetting != null) {
            Point startPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaSetting.getAreaRange(), areaSetting.getStartPosition());
            Point endPoint = ExcelUtils.pos2Point((String)areaSetting.getAreaRange().split(":")[1]);
            int dimRowCount = areaSetting.getColdims().size();
            int dimColCount = areaSetting.getRowdims().size();
            if (areaSetting.getDimPropertys() != null && areaSetting.getDimPropertys().size() > 0) {
                dimRowCount += FixTemplateProcessHelper.getPropertyCount(areaSetting.getDimPropertys(), areaSetting.getColdims());
                dimColCount += FixTemplateProcessHelper.getPropertyCount(areaSetting.getDimPropertys(), areaSetting.getRowdims());
            }
            int y = startPoint == null ? 0 : startPoint.y;
            int dataRowStart = y + dimRowCount;
            int x = startPoint == null ? 0 : startPoint.x;
            int dataColStart = x + dimColCount;
            return new CellArea(dataRowStart, dataColStart, endPoint.y - dataRowStart + 1, endPoint.x - dataColStart + 1);
        }
        return null;
    }

    public static int getPropertyCount(Map<String, List<PropertyObj>> propertyMap, List<String> dims) {
        int count = 0;
        if (propertyMap == null || propertyMap.size() == 0) {
            return count;
        }
        for (String dim : dims) {
            if (propertyMap.get(dim) == null) continue;
            count += propertyMap.get(dim).size();
        }
        return count;
    }

    public static void setStylesOnDataCellArea(String selectedArea, ITemplateModel templateModel, ISpreadContainer spreadContainer, CellStyleInfo cellStyleInfo) {
        CellArea dataCellArea;
        if (StringUtils.isEmpty((String)selectedArea) || templateModel == null || spreadContainer == null) {
            return;
        }
        IMultiAreaSetting areaSetting = templateModel.getAreaRangeByArea(selectedArea);
        if (areaSetting != null && (dataCellArea = FixTemplateProcessHelper.getDataCellArea(selectedArea, templateModel)) != null) {
            AreasStyle areasStyle = new AreasStyle();
            areasStyle.setRange((List)Lists.newArrayList((Object[])new CellArea[]{dataCellArea}));
            areasStyle.setStyle(cellStyleInfo);
            spreadContainer.setCellStyle((List)Lists.newArrayList((Object[])new AreasStyle[]{areasStyle}));
        }
    }

    public static CellStyleInfo getDimensionCellStyleInfo(boolean isFloatCell) {
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setHa(HorizontalAlignEnum.LEFT);
        if (isFloatCell) {
            cellStyleInfo.setBkc("#DBE5F1");
        } else {
            cellStyleInfo.setBkc("#66CDAA");
        }
        return cellStyleInfo;
    }

    public static void getFloatCellStyleInfo(ISpreadContainer spreadContainer, List<Object> ranges) {
        spreadContainer.getRangeStyles(ranges, "0", "getFloatStyle");
    }

    public static void updateFloatCellStyle(Map<String, Map<String, Object>> floatStyle, ITemplateModel templateModel, ISpreadContainer spreadContainer, String areaRangeForFloat) {
        List areaSettings = templateModel.getAreaRanges();
        ArrayList<AreasStyle> areasStyles = new ArrayList<AreasStyle>(10);
        if (StringUtils.isEmpty((String)areaRangeForFloat) || floatStyle == null || floatStyle.size() == 0) {
            return;
        }
        for (IMultiAreaSetting areaSetting : areaSettings) {
            if (!areaRangeForFloat.equals(areaSetting.getAreaRange())) continue;
            String areaRange = areaSetting.getAreaRange();
            Point point = FixTemplateProcessHelper.getAbsolutePosPoint(areaRange, areaSetting.getStartPosition());
            if (point == null) {
                return;
            }
            List rowHeaders = areaSetting.getRowHeaders();
            String[] split = areaRange.split(":");
            Point endPoint = ExcelUtils.pos2Point((String)split[1]);
            for (int i = 0; i < rowHeaders.size(); ++i) {
                for (int j = areaSetting.getColdims().size(); j <= endPoint.y - point.y; ++j) {
                    String area = ExcelUtils.xy2Pos((int)(point.x - rowHeaders.size() + i), (int)(point.y + j));
                    Map<String, Object> styleMap = floatStyle.get(area);
                    if (styleMap == null) continue;
                    AreasStyle areasStyle = new AreasStyle();
                    areasStyle.setRange(Collections.singletonList(new CellArea(point.y + j, point.x + i, 1, 1)));
                    CellStyleInfo cellStyleInfo = new CellStyleInfo();
                    cellStyleInfo.setHa(HorizontalAlignEnum.LEFT);
                    if (styleMap.get("backColor") != null) {
                        cellStyleInfo.setBkc(String.valueOf(styleMap.get("backColor")));
                    }
                    if (styleMap.get("borderColor") != null) {
                        cellStyleInfo.setBlc((List)Lists.newArrayList((Object[])new String[]{String.valueOf(styleMap.get("borderColor"))}));
                    }
                    if (styleMap.get("borderStyle") != null) {
                        cellStyleInfo.setBls((List)Lists.newArrayList((Object[])new String[]{BorderStyleEnum.getBorderStyleByIndex((int)((Integer)styleMap.get("borderStyle"))).getStyle()}));
                    }
                    areasStyle.setStyle(cellStyleInfo);
                    areasStyles.add(areasStyle);
                }
            }
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(areasStyles)) {
                spreadContainer.setCellStyle(areasStyles);
            }
            return;
        }
    }

    public static CellStyleInfo getCellHyperLinkStyleInfo(boolean isReset) {
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        if (isReset) {
            cellStyleInfo.setFrc("#000000");
        } else {
            cellStyleInfo.setFrc("#0000FF");
        }
        return cellStyleInfo;
    }

    public static CellStyleInfo getPropertyCellStyleInfo() {
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setHa(HorizontalAlignEnum.Center);
        cellStyleInfo.setBkc("#E6E6E6");
        cellStyleInfo.setL(Boolean.valueOf(true));
        return cellStyleInfo;
    }

    public static boolean hasFloatSettingOnRowCol(int row, int col, List<IMultiAreaSetting> areaSettings) {
        Point relatedPoint;
        IMultiAreaSetting multiAreaSetting = FixTemplateProcessHelper.getAreaSettingOnRowCol(row, col, areaSettings);
        if (multiAreaSetting != null && (multiAreaSetting.getFloatOnWhere() == 0 || multiAreaSetting.getFloatOnWhere() == 1) && (relatedPoint = FixTemplateProcessHelper.absRelatedToAreaDataPoint(multiAreaSetting, ExcelUtils.xy2Pos((int)col, (int)row))) != null) {
            for (MultiAreaSetting.FloatInfo floatInfo : multiAreaSetting.getFloatInfos()) {
                if (multiAreaSetting.getFloatOnWhere() == 0 && relatedPoint.y >= floatInfo.getRow_offset() && relatedPoint.y <= floatInfo.getRowEnd_offset()) {
                    return true;
                }
                if (multiAreaSetting.getFloatOnWhere() != 1 || relatedPoint.x < floatInfo.getCol_offset() || relatedPoint.x > floatInfo.getColEnd_offset()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ECell> getRealECells(List<ECell> originCells, IMultiAreaSetting multiAreaSetting) {
        List<ECell> eCells = new ArrayList<ECell>(16);
        if (originCells == null || originCells.size() == 0) {
            return eCells;
        }
        Point startPoint = FixTemplateProcessHelper.getAbsolutePosPoint(multiAreaSetting.getAreaRange(), multiAreaSetting.getStartPosition());
        eCells = FixTemplateProcessHelper.getRealECells(originCells, startPoint);
        return eCells;
    }

    public static List<ECell> getRealECells(List<ECell> originCells, Point startPoint) {
        ArrayList<ECell> eCells = new ArrayList<ECell>(16);
        if (originCells == null || originCells.size() == 0 || startPoint == null) {
            return eCells;
        }
        int startCol = startPoint.x;
        int startRow = startPoint.y;
        for (ECell cell : originCells) {
            ECell c = new ECell();
            c.setRowAndCol(cell.getRow() + startRow, cell.getCol() + startCol);
            c.setValue(cell.getValue());
            if (cell.hasUserObject()) {
                cell.getUserObject().entrySet().forEach(e -> c.setUserObject((String)e.getKey(), e.getValue()));
            }
            eCells.add(c);
        }
        return eCells;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> insertDelRowCol(ISpreadContainer spreadContainer, List<Integer> indexes, boolean isRow, boolean isInsert, List<IMultiAreaSetting> areaSettings, boolean needCheckTitle) {
        HashMap<String, String> originToAdjusted = new HashMap<String, String>(16);
        if (areaSettings != null && areaSettings.size() > 0 && indexes != null && indexes.size() > 0) {
            HashSet<IMultiAreaSetting> selectedAreas = new HashSet<IMultiAreaSetting>(16);
            HashSet<IMultiAreaSetting> bottomAreas = new HashSet<IMultiAreaSetting>(16);
            HashSet<IMultiAreaSetting> rightAreas = new HashSet<IMultiAreaSetting>(16);
            int maxSelectedIndex = indexes.get(0);
            int minSelectedIndex = indexes.get(0);
            for (Integer index : indexes) {
                if (index > maxSelectedIndex) {
                    maxSelectedIndex = index;
                    continue;
                }
                if (index >= minSelectedIndex) continue;
                minSelectedIndex = index;
            }
            for (IMultiAreaSetting areaSetting : areaSettings) {
                String[] areaStartEndPos = areaSetting.getAreaRange().split(":");
                Point areaStartPoint = ExcelUtils.pos2Point((String)areaStartEndPos[0]);
                Point areaEndPoint = ExcelUtils.pos2Point((String)areaStartEndPos[1]);
                Point dataPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaSetting.getAreaRange(), areaSetting.getStartPosition());
                Map propertyMap = areaSetting.getDimPropertys();
                if (dataPoint == null) continue;
                int start = isRow ? dataPoint.y : dataPoint.x;
                int end = start + (isRow ? areaSetting.getColdims().size() - 1 : areaSetting.getRowdims().size() - 1);
                if (propertyMap != null) {
                    end += isRow ? FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getColdims()) : FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getRowdims());
                }
                if (isInsert) {
                    if (minSelectedIndex > (isRow ? areaStartPoint.y : areaStartPoint.x) && minSelectedIndex <= end) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u5f00\u59cb\u4f4d\u7f6e\u4e0e\u5b9e\u9645\u6570\u636e\u8d77\u59cb\u4f4d\u7f6e\u4e4b\u95f4\u4e0d\u5141\u8bb8\u589e\u5220\u884c\u5217\u3002", (String)"FixTemplateProcess_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (isRow) {
                        if (minSelectedIndex > areaStartPoint.y && minSelectedIndex <= areaEndPoint.y) {
                            selectedAreas.add(areaSetting);
                            continue;
                        }
                        if (minSelectedIndex > areaStartPoint.y) continue;
                        bottomAreas.add(areaSetting);
                        continue;
                    }
                    if (minSelectedIndex > areaStartPoint.x && minSelectedIndex <= areaEndPoint.x) {
                        selectedAreas.add(areaSetting);
                        continue;
                    }
                    if (minSelectedIndex > areaStartPoint.x) continue;
                    rightAreas.add(areaSetting);
                    continue;
                }
                Iterator<Integer> it = indexes.iterator();
                while (it.hasNext()) {
                    Integer index = it.next();
                    if (index == null || index >= start && index <= end) {
                        it.remove();
                        continue;
                    }
                    if (isRow) {
                        if (index >= areaStartPoint.y && index <= areaEndPoint.y) {
                            selectedAreas.add(areaSetting);
                            continue;
                        }
                        if (maxSelectedIndex >= areaStartPoint.y) continue;
                        bottomAreas.add(areaSetting);
                        continue;
                    }
                    if (index >= areaStartPoint.x && index <= areaEndPoint.x) {
                        selectedAreas.add(areaSetting);
                        continue;
                    }
                    if (maxSelectedIndex >= areaStartPoint.x) continue;
                    rightAreas.add(areaSetting);
                }
            }
            if (isInsert && !isRow || !isInsert && !isRow) {
                if (needCheckTitle) {
                    if (FixTemplateProcessHelper.checkConfirmDeleteTitle(selectedAreas)) {
                        spreadContainer.callbackAction("showConfirmDeleteTitle");
                        return originToAdjusted;
                    }
                } else {
                    FixTemplateProcessHelper.deleteDynamicTitle(selectedAreas);
                }
            }
            if (!FixTemplateProcessHelper.insertDelRowCol(spreadContainer, selectedAreas, indexes, isInsert, isRow)) return originToAdjusted;
            originToAdjusted.putAll(FixTemplateProcessHelper.adjustAffectedAreas(bottomAreas, indexes, isInsert, isRow));
            originToAdjusted.putAll(FixTemplateProcessHelper.adjustAffectedAreas(rightAreas, indexes, isInsert, isRow));
            return originToAdjusted;
        } else {
            if (spreadContainer == null) return originToAdjusted;
            if (isInsert) {
                spreadContainer.insertRowCol(isRow ? indexes : null, !isRow ? indexes : null, true);
                return originToAdjusted;
            } else {
                spreadContainer.deleteRowCol(isRow ? indexes : null, !isRow ? indexes : null);
            }
        }
        return originToAdjusted;
    }

    public static void deleteDynamicTitle(Set<IMultiAreaSetting> selectedAreas) {
        for (IMultiAreaSetting selectedArea : selectedAreas) {
            selectedArea.getFixTemplateDynTitle().clear();
        }
    }

    public static boolean checkConfirmDeleteTitle(Set<IMultiAreaSetting> selectedAreas) {
        for (IMultiAreaSetting areaSetting : selectedAreas) {
            List fixTemplateDynTitles = areaSetting.getFixTemplateDynTitle();
            if (!CollectionUtils.isNotEmpty((Collection)fixTemplateDynTitles)) continue;
            return true;
        }
        return false;
    }

    public static boolean insertDelRowCol(ISpreadContainer spreadContainer, Set<IMultiAreaSetting> areaSettings, List<Integer> indexes, boolean isInsert, boolean isRow) {
        if (areaSettings == null || spreadContainer == null || indexes == null || indexes.isEmpty()) {
            return false;
        }
        HashMap areaInnerIndexMap = new HashMap(areaSettings.size());
        for (IMultiAreaSetting areaSetting : areaSettings) {
            MultiAreaSetting.FloatInfo floatInfo2;
            LinkedList<Integer> innerIndexes = new LinkedList<Integer>();
            String[] areaStartEndPos = areaSetting.getAreaRange().split(":");
            Point areaStartPoint = ExcelUtils.pos2Point((String)areaStartEndPos[0]);
            Point areaEndPoint = ExcelUtils.pos2Point((String)areaStartEndPos[1]);
            int areaEndX = areaEndPoint.x;
            int areaEndY = areaEndPoint.y;
            int minIndex = isRow ? areaEndY : areaEndX;
            Point startPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaSetting.getAreaRange(), areaSetting.getStartPosition());
            if (startPoint == null) continue;
            Point realDataStart = new Point(startPoint.x + areaSetting.getRowdims().size(), startPoint.y + areaSetting.getColdims().size());
            Map propertyMap = areaSetting.getDimPropertys();
            if (propertyMap != null && propertyMap.size() > 0) {
                realDataStart = new Point(realDataStart.x + FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getRowdims()), realDataStart.y + FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getColdims()));
            }
            for (Integer n : indexes) {
                int rowColIndex;
                if (n == null || !isInsert && n > (isRow ? areaEndY : areaEndX) || (rowColIndex = isRow ? n - startPoint.y : n - startPoint.x) < 0) continue;
                if (rowColIndex <= minIndex) {
                    minIndex = rowColIndex;
                }
                innerIndexes.add(rowColIndex);
            }
            if (innerIndexes.isEmpty()) {
                return false;
            }
            if (!isInsert && (isRow && areaEndY - innerIndexes.size() < realDataStart.y || !isRow && areaEndX - innerIndexes.size() < realDataStart.x)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4fdd\u7559\u81f3\u5c11\u4e00\u884c\u5217\u6570\u636e\u5355\u5143\u683c\u3002", (String)"FixTemplateProcess_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            boolean copyBefore = false;
            if (isRow && areaSetting.getFloatOnWhere() == 0 && areaSetting.getFloatInfos() != null) {
                for (MultiAreaSetting.FloatInfo floatInfo2 : areaSetting.getFloatInfos()) {
                    if (floatInfo2.getRow_offset() >= minIndex || floatInfo2.getRowEnd_offset() <= minIndex) continue;
                    copyBefore = true;
                }
                FixTemplateProcessHelper.adjustFloatInfos(minIndex, innerIndexes.size(), isInsert, areaSetting.getFloatInfos());
            }
            ISheet iSheet = areaSetting.getAreaSheet();
            floatInfo2 = innerIndexes.iterator();
            while (floatInfo2.hasNext()) {
                Integer index = (Integer)floatInfo2.next();
                if (index == null) continue;
                if (isRow) {
                    if (isInsert) {
                        iSheet.insertRow(minIndex, copyBefore);
                        ++areaEndY;
                        continue;
                    }
                    iSheet.delRow(index.intValue());
                    --areaEndY;
                    continue;
                }
                if (isInsert) {
                    iSheet.insertColumn(minIndex, false);
                    ++areaEndX;
                    continue;
                }
                iSheet.delColumn(index.intValue());
                --areaEndX;
            }
            areaSetting.setAreaRange(new RangeModel(areaStartPoint.x, areaEndX, areaStartPoint.y, areaEndY).toString());
            if (areaSetting.getFloatOnWhere() == 0 && (areaSetting.getFloatInfos() == null || areaSetting.getFloatInfos().isEmpty())) {
                areaSetting.setFloatOnWhere(-1);
            }
            areaInnerIndexMap.put(areaSetting.getAreaRange(), innerIndexes);
        }
        if (spreadContainer != null) {
            if (isInsert) {
                spreadContainer.insertRowCol(isRow ? indexes : null, !isRow ? indexes : null, true);
            } else {
                spreadContainer.deleteRowCol(isRow ? indexes : null, !isRow ? indexes : null);
            }
            if (areaInnerIndexMap.size() > 0) {
                ArrayList<AreasStyle> resetCell = new ArrayList<AreasStyle>(16);
                ArrayList<ECell> eCells = new ArrayList<ECell>(16);
                for (IMultiAreaSetting areaSetting : areaSettings) {
                    CellHyperLinkPOJO cellHyperLinkPOJO1;
                    Set value;
                    List integers;
                    ArrayList<CellHyperLinkPOJO> deleteCell = new ArrayList<CellHyperLinkPOJO>(16);
                    ArrayList<CellHyperLinkPOJO> updateCell = new ArrayList<CellHyperLinkPOJO>(16);
                    Map cellHyperLinkMap = areaSetting.getCellHyperLinkMap();
                    if (cellHyperLinkMap == null || cellHyperLinkMap.size() == 0 || CollectionUtils.isEmpty((Collection)(integers = (List)areaInnerIndexMap.get(areaSetting.getAreaRange())))) continue;
                    Integer max = Collections.max(indexes);
                    Integer min = Collections.min(indexes);
                    Map cellHyperLinkInfo = areaSetting.getCellHyperLinkMap();
                    ISheet areaSheet = areaSetting.getAreaSheet();
                    Point absolutePosPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaSetting.getAreaRange(), areaSetting.getStartPosition());
                    if (absolutePosPoint == null) continue;
                    if (isInsert) {
                        for (Map.Entry entry : cellHyperLinkInfo.entrySet()) {
                            value = (Set)entry.getValue();
                            if (CollectionUtils.isNotEmpty((Collection)value)) {
                                for (CellHyperLinkPOJO cellHyperLinkPOJO : value) {
                                    ECell eCellNotAdd;
                                    AreasStyle areasStyle;
                                    if (isRow) {
                                        if (cellHyperLinkPOJO.getR() + absolutePosPoint.y < min) continue;
                                        if (cellHyperLinkPOJO.getR() + absolutePosPoint.y < min + indexes.size()) {
                                            areasStyle = new AreasStyle();
                                            areasStyle.setRange(Collections.singletonList(new CellArea(cellHyperLinkPOJO.getR() + absolutePosPoint.y, cellHyperLinkPOJO.getC() + absolutePosPoint.x, 1, 1)));
                                            areasStyle.setStyle(FixTemplateProcessHelper.getCellHyperLinkStyleInfo(true));
                                            resetCell.add(areasStyle);
                                            if (areaSheet != null && (eCellNotAdd = areaSheet.getECellNotAdd(cellHyperLinkPOJO.getR() + absolutePosPoint.y, cellHyperLinkPOJO.getC() + absolutePosPoint.x)) != null) {
                                                eCellNotAdd.setValue(null);
                                                eCellNotAdd.removeUserObject("templateId");
                                                eCells.add(eCellNotAdd);
                                            }
                                        }
                                        deleteCell.add(cellHyperLinkPOJO);
                                        cellHyperLinkPOJO1 = new CellHyperLinkPOJO(cellHyperLinkPOJO.getR() + indexes.size(), cellHyperLinkPOJO.getC());
                                        updateCell.add(cellHyperLinkPOJO1);
                                        continue;
                                    }
                                    if (cellHyperLinkPOJO.getC() + absolutePosPoint.x < min) continue;
                                    if (cellHyperLinkPOJO.getC() + absolutePosPoint.x < min + indexes.size()) {
                                        areasStyle = new AreasStyle();
                                        areasStyle.setRange(Collections.singletonList(new CellArea(cellHyperLinkPOJO.getR() + absolutePosPoint.y, cellHyperLinkPOJO.getC() + absolutePosPoint.x, 1, 1)));
                                        areasStyle.setStyle(FixTemplateProcessHelper.getCellHyperLinkStyleInfo(true));
                                        resetCell.add(areasStyle);
                                        if (areaSheet != null && (eCellNotAdd = areaSheet.getECellNotAdd(cellHyperLinkPOJO.getR() + absolutePosPoint.y, cellHyperLinkPOJO.getC() + absolutePosPoint.x)) != null) {
                                            eCellNotAdd.setValue(null);
                                            eCellNotAdd.removeUserObject("templateId");
                                            eCells.add(eCellNotAdd);
                                        }
                                    }
                                    deleteCell.add(cellHyperLinkPOJO);
                                    cellHyperLinkPOJO1 = new CellHyperLinkPOJO(cellHyperLinkPOJO.getR(), cellHyperLinkPOJO.getC() + indexes.size());
                                    updateCell.add(cellHyperLinkPOJO1);
                                }
                            }
                            value.removeAll(deleteCell);
                            value.addAll(updateCell);
                        }
                        continue;
                    }
                    for (Map.Entry entry : cellHyperLinkInfo.entrySet()) {
                        value = (Set)entry.getValue();
                        if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                        for (CellHyperLinkPOJO cellHyperLinkPOJO : value) {
                            if (isRow) {
                                if (cellHyperLinkPOJO.getR() + absolutePosPoint.y >= min && cellHyperLinkPOJO.getR() + absolutePosPoint.y <= max) {
                                    deleteCell.add(cellHyperLinkPOJO);
                                    continue;
                                }
                                if (cellHyperLinkPOJO.getR() + absolutePosPoint.y <= max) continue;
                                cellHyperLinkPOJO1 = new CellHyperLinkPOJO(cellHyperLinkPOJO.getR() - indexes.size(), cellHyperLinkPOJO.getC());
                                updateCell.add(cellHyperLinkPOJO1);
                                deleteCell.add(cellHyperLinkPOJO);
                                continue;
                            }
                            if (cellHyperLinkPOJO.getC() + absolutePosPoint.x >= min && cellHyperLinkPOJO.getC() + absolutePosPoint.x <= max) {
                                deleteCell.add(cellHyperLinkPOJO);
                                continue;
                            }
                            if (cellHyperLinkPOJO.getC() + absolutePosPoint.x <= max) continue;
                            cellHyperLinkPOJO1 = new CellHyperLinkPOJO(cellHyperLinkPOJO.getR(), cellHyperLinkPOJO.getC() - indexes.size());
                            updateCell.add(cellHyperLinkPOJO1);
                            deleteCell.add(cellHyperLinkPOJO);
                        }
                        value.removeAll(deleteCell);
                        value.addAll(updateCell);
                    }
                }
                if (CollectionUtils.isNotEmpty(resetCell)) {
                    spreadContainer.setCellStyle(resetCell);
                }
                if (CollectionUtils.isNotEmpty(eCells)) {
                    spreadContainer.updateCellValue2(eCells);
                }
            }
        }
        return true;
    }

    private static void adjustFloatInfos(int startIndex, int count, boolean isInsert, List<MultiAreaSetting.FloatInfo> floatInfos) {
        if (floatInfos != null) {
            Iterator<MultiAreaSetting.FloatInfo> iterator = floatInfos.iterator();
            while (iterator.hasNext()) {
                MultiAreaSetting.FloatInfo floatInfo = iterator.next();
                if (isInsert) {
                    if (startIndex < floatInfo.getRow_offset()) {
                        floatInfo.setRow_offset(floatInfo.getRow_offset() + count);
                        floatInfo.setRowEnd_offset(floatInfo.getRowEnd_offset() + count);
                        continue;
                    }
                    if (startIndex < floatInfo.getRow_offset() || startIndex > floatInfo.getRowEnd_offset()) continue;
                    floatInfo.setRowEnd_offset(floatInfo.getRowEnd_offset() + count);
                    continue;
                }
                if (isInsert) continue;
                int endIndex = startIndex + count - 1;
                if (startIndex <= floatInfo.getRow_offset() && endIndex >= floatInfo.getRowEnd_offset()) {
                    iterator.remove();
                    continue;
                }
                if (startIndex > floatInfo.getRow_offset() && startIndex <= floatInfo.getRowEnd_offset()) {
                    floatInfo.setRowEnd_offset(endIndex > floatInfo.getRowEnd_offset() ? startIndex : floatInfo.getRowEnd_offset() - count);
                    continue;
                }
                if (startIndex < floatInfo.getRow_offset() && endIndex < floatInfo.getRow_offset()) {
                    floatInfo.setRow_offset(floatInfo.getRow_offset() - count);
                    floatInfo.setRowEnd_offset(floatInfo.getRowEnd_offset() - count);
                    continue;
                }
                if (startIndex > floatInfo.getRowEnd_offset()) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6d6e\u52a8\u8d77\u59cb\u4f4d\u7f6e\u5355\u5143\u683c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FixTemplateProcess_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static Map<String, String> adjustAffectedAreas(Set<IMultiAreaSetting> areaSettings, List<Integer> indexes, boolean isInsert, boolean isRow) {
        HashMap<String, String> originToAdjusted = new HashMap<String, String>(16);
        if (areaSettings != null) {
            int size = isInsert ? indexes.size() : -indexes.size();
            for (IMultiAreaSetting areaSetting : areaSettings) {
                RangeModel rangeModel;
                String[] areaStartEndPos = areaSetting.getAreaRange().split(":");
                Point areaStartPoint = ExcelUtils.pos2Point((String)areaStartEndPos[0]);
                Point areaEndPoint = ExcelUtils.pos2Point((String)areaStartEndPos[1]);
                if (isRow) {
                    int adjustedStartY = areaStartPoint.y + size;
                    int adjustedEndY = areaEndPoint.y + size;
                    rangeModel = new RangeModel(areaStartPoint.x, areaEndPoint.x, adjustedStartY, adjustedEndY);
                    originToAdjusted.put(areaSetting.getAreaRange(), rangeModel.toString());
                    areaSetting.setAreaRange(rangeModel.toString());
                    continue;
                }
                int adjustedStartX = areaStartPoint.x + size;
                int adjustedEndX = areaEndPoint.x + size;
                rangeModel = new RangeModel(adjustedStartX, adjustedEndX, areaStartPoint.y, areaEndPoint.y);
                originToAdjusted.put(areaSetting.getAreaRange(), rangeModel.toString());
                areaSetting.setAreaRange(rangeModel.toString());
            }
        }
        return originToAdjusted;
    }

    public static List<JSONObject> getDataTableFromSpreadjson(JSONObject spreadJson) {
        ArrayList<JSONObject> dataTables = new ArrayList<JSONObject>(10);
        if (spreadJson != null) {
            JSONObject sheets = (JSONObject)spreadJson.get((Object)"sheets");
            for (Map.Entry entry : sheets.entrySet()) {
                JSONObject sheet = (JSONObject)entry.getValue();
                JSONObject data = (JSONObject)sheet.get((Object)"data");
                dataTables.add((JSONObject)data.get((Object)"dataTable"));
            }
        }
        return dataTables;
    }

    public static void setFloatLockInfo(ITemplateModel templateModel, JSONObject spreadJson) {
        if (templateModel instanceof FixTemplateModel) {
            FixTemplateModel fixTemplateModel = (FixTemplateModel)templateModel;
            List<JSONObject> dataTables = null;
            for (IMultiAreaSetting areaSetting : fixTemplateModel.getAreaRanges()) {
                if (areaSetting.getFloatOnWhere() != 0 || areaSetting.getFloatInfos() == null) continue;
                if (dataTables == null) {
                    dataTables = FixTemplateProcessHelper.getDataTableFromSpreadjson(spreadJson);
                }
                if (dataTables.size() <= 0) continue;
                CellArea dataCellArea = FixTemplateProcessHelper.getDataCellArea(areaSetting.getAreaRange(), templateModel);
                Point abs_dataStart = FixTemplateProcessHelper.getAbsolutePosPoint(areaSetting.getAreaRange(), areaSetting.getStartPosition());
                if (dataCellArea == null || abs_dataStart == null) continue;
                JSONObject dataTable = dataTables.get(0);
                for (MultiAreaSetting.FloatInfo floatInfo : areaSetting.getFloatInfos()) {
                    floatInfo.setLockCols(null);
                    JSONObject jsonRow = dataTable.getJSONObject(String.valueOf(abs_dataStart.y + floatInfo.getRow_offset()));
                    if (jsonRow == null) continue;
                    for (int i = 0; i < dataCellArea.getCc(); ++i) {
                        JSONObject jsonCell = jsonRow.getJSONObject(String.valueOf(dataCellArea.getC() + i));
                        if (jsonCell == null || jsonCell.getJSONObject("style") == null || !Boolean.TRUE.equals(jsonCell.getJSONObject("style").getBoolean("locked"))) continue;
                        HashSet<Integer> lockCols = floatInfo.getLockCols();
                        if (lockCols == null) {
                            lockCols = new HashSet<Integer>(16);
                            floatInfo.setLockCols(lockCols);
                        }
                        lockCols.add(i);
                    }
                }
            }
        }
    }

    public static String getAreaIndexFromViewKey(String viewKey) {
        if (FixTemplateProcessHelper.isAreaViewKey(viewKey)) {
            return viewKey.split("_")[1];
        }
        return null;
    }

    public static boolean isAreaViewKey(String viewKey) {
        return viewKey != null && viewKey.contains("_");
    }

    public static boolean removeInvalidDimensionViews(ITemplateModel templateModel) {
        FixTemplateModel fixTemplateModel;
        Map dimensionViews;
        if (templateModel instanceof FixTemplateModel && (dimensionViews = (fixTemplateModel = (FixTemplateModel)templateModel).getDimemsionViews()) != null && dimensionViews.size() > 0) {
            Set areaIndexes = fixTemplateModel.getAreaRanges().stream().map(areaSetting -> areaSetting.getAreaRange().split(":")[0]).collect(Collectors.toSet());
            Set<Object> invalidKeys = new HashSet(16);
            if (areaIndexes.isEmpty()) {
                invalidKeys = dimensionViews.keySet().stream().filter(e -> e.contains("_")).collect(Collectors.toSet());
            } else {
                for (Map.Entry entry : dimensionViews.entrySet()) {
                    String viewKey = (String)entry.getKey();
                    String areaIndex = FixTemplateProcessHelper.getAreaIndexFromViewKey(viewKey);
                    if (areaIndex == null || areaIndexes.contains(areaIndex)) continue;
                    invalidKeys.add(viewKey);
                }
            }
            for (String string : invalidKeys) {
                dimensionViews.remove(string);
            }
            return invalidKeys.size() > 0;
        }
        return false;
    }

    public static Map<String, String> updateView(ITemplateModel templateModel, IModelCacheHelper modelCacheHelper, boolean isUpdate) {
        Map dimemsionViews = templateModel.getDimemsionViews();
        Long modelId = templateModel.getTemplateBaseInfo().getModelID();
        Long bizModel = templateModel.getTemplateBaseInfo().getBizModel();
        HashMap<String, String> errmessage = new HashMap<String, String>(16);
        for (IMultiAreaSetting areaRange : templateModel.getAreaRanges()) {
            ArrayList<String> errorDim = new ArrayList<String>(16);
            errorDim.addAll(FixTemplateProcessHelper.handelEmptyColViewId(templateModel, modelCacheHelper, areaRange, isUpdate));
            errorDim.addAll(FixTemplateProcessHelper.handleEmptyViewIdRow(templateModel, modelCacheHelper, areaRange, isUpdate));
            List areaViewpointmembentry = areaRange.getAreaViewpointmembentry();
            for (IViewPointDimensionEntry entry : areaViewpointmembentry) {
                Dimension dimension;
                if (View.NoViewDimNums.contains(entry.getDimension().getNumber()) || dimemsionViews != null && dimemsionViews.containsKey(entry.getDimension().getNumber() + "_" + areaRange.getAreaRangeStart()) && !isUpdate) continue;
                Long viewId = DimensionViewServiceHelper.getViewId((Map)dimemsionViews, (String)entry.getDimension().getNumber(), (String)areaRange.getAreaRangeStart());
                Member memberByAnyView = modelCacheHelper.getMemberByAnyView(entry.getDimension().getNumber(), entry.getMember().getNumber());
                if (memberByAnyView != null) {
                    dimension = modelCacheHelper.getDimension(entry.getDimension().getNumber());
                    Long viewGroupByBusModelAndDimNumber = modelCacheHelper.getViewGroupByBusModelAndDimNumber(bizModel, dimension.getNumber());
                    Long search = DimensionViewServiceHelper.queryViewIdByMemberId((Long)modelId, (Long)bizModel, (Long)dimension.getId(), (Long)viewGroupByBusModelAndDimNumber, Collections.singleton(memberByAnyView.getId()), (Long)viewId);
                    if (IDUtils.isNotNull((Long)search)) {
                        viewId = search;
                    }
                }
                if (IDUtils.isNotNull((Long)viewId)) {
                    dimemsionViews.put(entry.getDimension().getNumber() + "_" + areaRange.getAreaRangeStart(), viewId);
                    continue;
                }
                dimension = modelCacheHelper.getDimension(entry.getDimension().getNumber());
                if (dimension == null) continue;
                errorDim.add(dimension.getName());
            }
            if (!CollectionUtils.isNotEmpty(errorDim)) continue;
            errmessage.put(areaRange.getAreaRange(), String.join((CharSequence)",", errorDim));
        }
        return errmessage;
    }

    public static List<String> handelEmptyColViewId(ITemplateModel templateModel, IModelCacheHelper modelCacheHelper, IMultiAreaSetting areaRange, boolean isUpdate) {
        List colHeaders = areaRange.getColHeaders();
        int index = 0;
        ArrayList<String> errorViewDimemsionView = new ArrayList<String>(16);
        for (IHeaderInfo headerInfo : colHeaders) {
            String type;
            ++index;
            String coldim = headerInfo.getNumber();
            if (View.NoViewDimNums.contains(coldim) || "Property".equals(type = headerInfo.getType()) || templateModel.getDimemsionViews() != null && templateModel.getDimemsionViews().containsKey(coldim + "_" + areaRange.getAreaRangeStart()) && !isUpdate) continue;
            Dimension dimension = modelCacheHelper.getDimension(coldim);
            HashSet<Long> set = new HashSet<Long>(16);
            Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)coldim, (String)areaRange.getAreaRangeStart());
            int realMaxCols = areaRange.getAreaSheet().getRealMaxCols();
            for (int i = 0; i < realMaxCols; ++i) {
                Member memberByAnyView;
                String number;
                ECell eCellNotAdd = areaRange.getAreaSheet().getECellNotAdd(index - 1, i);
                if (eCellNotAdd == null || eCellNotAdd.getValue() == null || !StringUtils.isNotEmpty((String)(number = (String)eCellNotAdd.getUserObject("number"))) || (memberByAnyView = modelCacheHelper.getMemberByAnyView(dimension.getNumber(), number)) == null) continue;
                set.add(memberByAnyView.getId());
            }
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(set)) {
                Long viewGroupByBusModelAndDimNumber = modelCacheHelper.getViewGroupByBusModelAndDimNumber(templateModel.getTemplateBaseInfo().getBizModel(), dimension.getNumber());
                Long search = DimensionViewServiceHelper.queryViewIdByMemberId((Long)templateModel.getTemplateBaseInfo().getModelID(), (Long)templateModel.getTemplateBaseInfo().getBizModel(), (Long)dimension.getId(), (Long)viewGroupByBusModelAndDimNumber, set, (Long)viewId);
                if (IDUtils.isNotNull((Long)search)) {
                    viewId = search;
                }
            }
            if (IDUtils.isNotNull((Long)viewId)) {
                templateModel.getDimemsionViews().put(coldim + "_" + areaRange.getAreaRangeStart(), viewId);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(set)) continue;
            errorViewDimemsionView.add(dimension.getName());
        }
        return errorViewDimemsionView;
    }

    public static List<String> handleEmptyViewIdRow(ITemplateModel templateModel, IModelCacheHelper modelCacheHelper, IMultiAreaSetting areaRange, boolean isUpdate) {
        List rowHeaders = areaRange.getRowHeaders();
        int index = 0;
        ArrayList<String> errorViewDimemsionView = new ArrayList<String>(16);
        for (IHeaderInfo headerInfo : rowHeaders) {
            String type;
            ++index;
            String rowdim = headerInfo.getNumber();
            if (View.NoViewDimNums.contains(rowdim) || "Property".equals(type = headerInfo.getType()) || templateModel.getDimemsionViews() != null && templateModel.getDimemsionViews().containsKey(rowdim + "_" + areaRange.getAreaRangeStart()) && !isUpdate) continue;
            Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)rowdim, (String)areaRange.getAreaRangeStart());
            List floatInfos = areaRange.getFloatInfos();
            HashSet<Long> set = new HashSet<Long>(16);
            Dimension dimension = modelCacheHelper.getDimension(rowdim);
            FixTemplateProcessHelper.getFloatMemberId(rowdim, floatInfos, set, modelCacheHelper);
            FixTemplateProcessHelper.getFixMemberId(areaRange, index, set, dimension, modelCacheHelper);
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(set)) {
                Long viewGroupByBusModelAndDimNumber = modelCacheHelper.getViewGroupByBusModelAndDimNumber(templateModel.getTemplateBaseInfo().getBizModel(), rowdim);
                Long search = DimensionViewServiceHelper.queryViewIdByMemberId((Long)templateModel.getTemplateBaseInfo().getModelID(), (Long)templateModel.getTemplateBaseInfo().getBizModel(), (Long)dimension.getId(), (Long)viewGroupByBusModelAndDimNumber, set, (Long)viewId);
                if (IDUtils.isNotNull((Long)search)) {
                    viewId = search;
                }
            }
            if (IDUtils.isNotNull((Long)viewId)) {
                templateModel.getDimemsionViews().put(rowdim + "_" + areaRange.getAreaRangeStart(), viewId);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(set)) continue;
            errorViewDimemsionView.add(dimension.getName());
        }
        return errorViewDimemsionView;
    }

    public static void getFixMemberId(IMultiAreaSetting areaRange, int index, Set<Long> set, Dimension dimension, IModelCacheHelper modelCacheHelper) {
        int realMaxRows = areaRange.getAreaSheet().getRealMaxRows();
        for (int i = 0; i < realMaxRows; ++i) {
            Member memberByAnyView;
            String number;
            ECell eCell = areaRange.getAreaSheet().getECell(i, index - 1);
            if (eCell == null || eCell.getValue() == null || !StringUtils.isNotEmpty((String)(number = (String)eCell.getUserObject("number"))) || (memberByAnyView = modelCacheHelper.getMemberByAnyView(dimension.getNumber(), number)) == null) continue;
            set.add(memberByAnyView.getId());
        }
    }

    public static void getFloatMemberId(String rowdim, List<MultiAreaSetting.FloatInfo> floatInfos, Set<Long> set, IModelCacheHelper modelCacheHelper) {
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(floatInfos)) {
            for (MultiAreaSetting.FloatInfo floatInfo : floatInfos) {
                List rowColDimensionEntries = floatInfo.getPartition().getRowColDimensionEntries();
                for (IRowColDimensionEntry rowColDimensionEntry : rowColDimensionEntries) {
                    if (!rowdim.equals(rowColDimensionEntry.getDimension().getNumber())) continue;
                    List members = rowColDimensionEntry.getMembers();
                    for (IDimensionMember member : members) {
                        Member memberByAnyView;
                        if (!RangeF7PropertyCataEnum.Member.getIndex().equals(member.getType()) && !StringUtils.isEmpty((String)member.getType()) || (memberByAnyView = modelCacheHelper.getMemberByAnyView(rowColDimensionEntry.getDimension().getNumber(), member.getNumber())) == null) continue;
                        set.add(memberByAnyView.getId());
                    }
                }
            }
        }
    }

    public static void adjustDimensionViews(ITemplateModel templateModel, Map<String, String> originToAdjustedRanges) {
        if (templateModel instanceof FixTemplateModel && originToAdjustedRanges != null && !originToAdjustedRanges.isEmpty() && templateModel.getDimemsionViews() != null && !templateModel.getDimemsionViews().isEmpty()) {
            HashMap refreshedViews = new HashMap(16);
            Map dimensionViews = templateModel.getDimemsionViews();
            HashMap originToAdjustedAreaIndex = new HashMap(16);
            originToAdjustedRanges.forEach((k, v) -> originToAdjustedAreaIndex.put(k.split(":")[0], v.split(":")[0]));
            for (Map.Entry entry : dimensionViews.entrySet()) {
                String viewKey = (String)entry.getKey();
                String[] viewKeySplit = viewKey.split("_");
                if (viewKeySplit.length > 1) {
                    String dimNumber = viewKeySplit[0];
                    String areaIndex = viewKeySplit[1];
                    String adjustedAreaIndex = (String)originToAdjustedAreaIndex.get(areaIndex);
                    if (adjustedAreaIndex != null) {
                        refreshedViews.put(dimNumber + "_" + adjustedAreaIndex, entry.getValue());
                        continue;
                    }
                    refreshedViews.put(viewKey, entry.getValue());
                    continue;
                }
                refreshedViews.put(viewKey, entry.getValue());
            }
            templateModel.setDimemsionViews(refreshedViews);
        }
    }

    public static void applyLockedCells(List<Integer[]> lockedCells, ITemplateModel templateModel) {
        if (templateModel != null) {
            for (IMultiAreaSetting multiAreaSetting : templateModel.getAreaRanges()) {
                List rowCols;
                Point dataAreaStart = FixTemplateProcessHelper.getAbsolutePosPoint(multiAreaSetting.getAreaRange(), multiAreaSetting.getStartPosition());
                if (dataAreaStart == null) continue;
                Point dataAreaEnd = ExcelUtils.pos2Point((String)multiAreaSetting.getAreaRange().split(":")[1]);
                int rowStart = dataAreaStart.y;
                int rowEnd = dataAreaEnd.y;
                int colStart = dataAreaStart.x;
                int colEnd = dataAreaEnd.x;
                ISheet sheet = multiAreaSetting.getAreaSheet();
                sheet.iteratorECells(e -> e.removeUserObject("l"));
                if (lockedCells == null || lockedCells.isEmpty() || (rowCols = lockedCells.stream().filter(e -> e[0] >= rowStart && e[0] <= rowEnd && e[1] >= colStart && e[1] <= colEnd).collect(Collectors.toList())).isEmpty()) continue;
                int maxRow = sheet.getRealMaxRows();
                int maxCol = sheet.getRealMaxCols();
                for (Integer[] rowCol : rowCols) {
                    int r = rowCol[0] - rowStart;
                    int c = rowCol[1] - colStart;
                    if (r < 0 || r >= maxRow || c < 0 || c >= maxCol) continue;
                    sheet.getECell(r, c).setUserObject("l", (Object)true);
                }
            }
        }
    }

    public static String replaceOutlineElements(Long templateId, String spreadSerial) {
        DynamicObject dynamicObject;
        if (IDUtils.isNotNull((Long)templateId) && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_exportinfo", (String)"spreadserial", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)})) != null) {
            String spreadSerialFromPreview = dynamicObject.getString("spreadserial");
            spreadSerial = DataAndJsonTranslator.replaceOutlineElements((String)spreadSerialFromPreview, (String)spreadSerial);
        }
        return spreadSerial;
    }

    public static void templateHasOutLineElements(IFormView formView, Long templateId) {
        String spreadSerialFromPreview;
        boolean result;
        if (IDUtils.isNull((Long)templateId)) {
            return;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_exportinfo", (String)"spreadserial", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)});
        if (dynamicObject != null && (result = DataAndJsonTranslator.templateHasOutLineElements((String)(spreadSerialFromPreview = dynamicObject.getString("spreadserial"))))) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u8bbe\u7f6e\u4e86\u7ec4\u5408\uff0c\u4fee\u6539\u6a21\u677f\u5c06\u6e05\u9664\u7ec4\u5408\u4fe1\u606f\uff0c\u8bf7\u4fdd\u5b58\u6216\u53d1\u5e03\u540e\u5230\u9884\u89c8\u9875\u9762\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FixTemplateProcessHelper_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            formView.getPageCache().put("resetOutLineInfo", "true");
        }
    }
}

