/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.templateperm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.templateperm.TemplatePermQueryUtil;
import kd.epm.eb.business.templateperm.TemplatePermUpgradeHelper;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.constant.TempUserPermConstant;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.UserSelectModel;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.templateperm.EntityTypeEnum;
import kd.epm.eb.common.templateperm.ShowWayEnum;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.templateperm.TemplateUserVo;
import kd.epm.eb.common.templateperm.UserTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserSelectServiceHelperNew;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.reportscheme.helper.TemplateUserPermHelper;
import kd.epm.eb.formplugin.templateperm.vo.SearchResult;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class TemplateUserPermPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
AfterF7SelectListener,
SearchEnterListener,
RowClickEventListener,
TreeNodeClickListener,
TreeNodeCheckListener {
    private static final Log log = LogFactory.getLog(TemplateUserPermPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl("tree_template");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entity_user");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl("entity_entity");
        entryGrid1.addRowClickListener((RowClickEventListener)this);
        this.addF7SelectListener(this, new String[]{"model"});
        this.addAfterF7SelectListener(this, new String[]{"model"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_allocate_cancel", "btn_allocate", "btn_select_user", "btn_select_usergroup", "btn_remove_user", "btn_select_entity", "btn_remove_entity", "searchnext", "searchbefore"});
        Search searchCtro = (Search)this.getControl("searchap");
        searchCtro.addEnterListener((SearchEnterListener)this);
    }

    private void updateGridColumns() {
        List<BaseColumn> toShowCols = this.getToShowCols();
        EntryAp entryAp = this.getEntryAp(toShowCols);
        this.addCtrlTip(entryAp);
        ExecuteAnalyseUtil.getInstance().updateGridColumns(entryAp, this.getView(), "entity_allocate");
    }

    private void addCtrlTip(EntryAp entryAp) {
        if (entryAp == null) {
            return;
        }
        List items = entryAp.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            return;
        }
        for (ControlAp controlAp : items) {
            String key = controlAp.getKey();
            Tips colTip = this.getCtrlTip(key);
            if (colTip == null || !(controlAp instanceof FieldAp)) continue;
            ((FieldAp)controlAp).setCtlTips(colTip);
        }
    }

    private Tips getCtrlTip(String controlKey) {
        LocaleString content = null;
        if ("entity_exclude".equals(controlKey)) {
            content = new LocaleString(ResManager.loadKDString((String)"\u79fb\u9664\u4e3a'\u662f'\uff0c\u8868\u793a\u5bf9\u5e94\u7684\u7ec4\u7ec7\u8303\u56f4\u548c\u6a21\u677f\u8bb0\u5f55\u65e0\u6743\u3002", (String)"TemplateUserPermPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (content == null) {
            return null;
        }
        Tips tips = new Tips();
        tips.setTriggerType("hover");
        tips.setType("text");
        tips.setContent(content);
        return tips;
    }

    private EntryAp getEntryAp(List<BaseColumn> toShowCols) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entity_allocate");
        entryAp.setPageRow(20);
        entryAp.setSplitPage(true);
        entryAp.setShowSelChexkbox(true);
        entryAp.setLock("new,edit,view");
        ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, toShowCols, (boolean)true, null);
        return entryAp;
    }

    private List<BaseColumn> getToShowCols() {
        ShowWayEnum baseShowWayEnum = this.getShowWayEnum();
        ArrayList<BaseColumn> cols = new ArrayList<BaseColumn>(16);
        this.addShowWayRelateCols(cols, baseShowWayEnum);
        for (ShowWayEnum showWayEnum : ShowWayEnum.values()) {
            if (showWayEnum == baseShowWayEnum) continue;
            this.addShowWayRelateCols(cols, showWayEnum);
        }
        this.addCols(cols, TempUserPermConstant.HIDE_COLS, TempUserPermConstant.HIDE_COLS, false);
        return cols;
    }

    private ShowWayEnum getShowWayEnum() {
        ShowWayEnum baseShowWayEnum;
        String showWay = (String)this.getCache("showWay", String.class);
        if (StringUtils.isEmpty((String)showWay)) {
            baseShowWayEnum = ShowWayEnum.TEMPLATE_SHOW;
        } else {
            baseShowWayEnum = ShowWayEnum.getShowWayEnumByCode((String)showWay);
            if (baseShowWayEnum == null) {
                baseShowWayEnum = ShowWayEnum.TEMPLATE_SHOW;
            }
        }
        return baseShowWayEnum;
    }

    private void addShowWayRelateCols(List<BaseColumn> cols, ShowWayEnum showWay) {
        List toAddCols = null;
        List toAddCols_names = null;
        switch (showWay) {
            case TEMPLATE_SHOW: {
                toAddCols = TempUserPermConstant.TEMPLATE_SHOW_COLS;
                toAddCols_names = TempUserPermConstant.TEMPLATE_SHOW_COLS_NAMES;
                break;
            }
            case USER_SHOW: {
                toAddCols = TempUserPermConstant.USER_SHOW_COLS;
                toAddCols_names = TempUserPermConstant.USER_SHOW_COLS_NAMES;
                break;
            }
            case ENTITY_SHOW: {
                toAddCols = TempUserPermConstant.ENTITY_SHOW_COLS;
                toAddCols_names = TempUserPermConstant.ENTITY_SHOW_COLS_NAMES;
                break;
            }
        }
        this.addCols(cols, toAddCols, toAddCols_names, true);
    }

    private void addCols(List<BaseColumn> cols, List<String> toAddCols, List<String> toAddCols_names, boolean enableView) {
        if (toAddCols == null) {
            return;
        }
        for (int i = 0; i < toAddCols.size(); ++i) {
            String colNumber = toAddCols.get(i);
            String colName = toAddCols_names.get(i);
            TextColumn column = new TextColumn();
            column.setKey(colNumber);
            column.setTitle(colName);
            column.setIsmustinput(false);
            column.setIgnoreDB(true);
            column.setBaseVisible(enableView);
            column.setEnable(false);
            cols.add((BaseColumn)column);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String name = ((BasedataEdit)afterF7SelectEvent.getSource()).getFieldKey();
        if ("model".equals(name)) {
            this.handleModelPropertyChange();
        }
    }

    public boolean isCheckModel() {
        return false;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        if (StringUtils.isNotEmpty((String)text)) {
            this.searchTemplate(text);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"TemplateUserPermPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.buildAllocatedRecords();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((String)itemKey, (String)"btn_exit") || StringUtils.equals((String)itemKey, (String)"btn_query")) {
            return;
        }
        Long modelIdStr = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelIdStr).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"TemplateUserPermPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        super.beforeItemClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (!"btn_allocate".equals(key) && "btn_query".equals(key)) {
            this.showTemplateQueryForm();
        }
    }

    private void showTemplateQueryForm() {
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        HashMap<String, Long> paramMap = new HashMap<String, Long>(16);
        paramMap.put("model", this.getModelId());
        reportShowParameter.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u6743\u9650\u67e5\u8be2", (String)"TemplateUserPermPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        reportShowParameter.setCustomParams(paramMap);
        reportShowParameter.setFormId("eb_usertemplatereport");
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
        this.writeLog("view", new MultiLangEnumBridge("\u67e5\u8be2", "TemplateUserPermPlugin_28", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6a21\u677f\u6743\u9650\u67e5\u8be2", "TemplateUserPermPlugin_21", "epm-eb-formplugin"));
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        this.buildAllocatedRecords();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.buildAllocatedRecords();
    }

    public void beforeClick(BeforeClickEvent evt) {
        Long modelIdStr = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelIdStr).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"TemplateUserPermPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_allocate_cancel": {
                this.handleAllocateCancel();
                break;
            }
            case "btn_select_usergroup": {
                this.handleSelectUserGroup();
                break;
            }
            case "btn_select_user": {
                this.handleSelectUser();
                break;
            }
            case "btn_remove_user": {
                this.handleRemoveUser();
                break;
            }
            case "searchbefore": {
                this.searchNext(-1);
                break;
            }
            case "searchnext": {
                this.searchNext(1);
                break;
            }
            case "btn_select_entity": {
                this.handleSelectEntity();
                break;
            }
            case "btn_remove_entity": {
                this.handleRemoveEntity();
                break;
            }
            case "btn_allocate": {
                try {
                    this.handleAllocate();
                    break;
                }
                catch (Exception exception) {
                    throw new KDBizException(ThrowableHelper.toString((Exception)exception));
                }
            }
        }
    }

    private void searchTemplate(String text) {
        TreeView treeView = (TreeView)this.getControl("tree_template");
        TreeNode root = (TreeNode)this.getCache("treeCacheName", TreeNode.class);
        if (root == null) {
            return;
        }
        ArrayList hitNode = new ArrayList(16);
        root.getTreeNodeListByText(hitNode, text, 999);
        TreeNode exceptNode = null;
        for (TreeNode treeNode : hitNode) {
            String id = treeNode.getId();
            if (!StringUtils.isEmpty((String)id)) continue;
            exceptNode = treeNode;
            break;
        }
        if (exceptNode != null) {
            hitNode.remove(exceptNode);
        }
        SearchResult result = null;
        if (hitNode.size() > 0) {
            List children;
            TreeNode next;
            List hitNodesCache = (List)this.getCache("hitNodes", ArrayList.class);
            if (CollectionUtils.isNotEmpty((Collection)hitNodesCache)) {
                for (Map node : hitNodesCache) {
                    treeView.uncheckNode((String)node.get("id"));
                }
            }
            next.setLeaf((children = (next = (result = new SearchResult(hitNode)).next(1)).getChildren()) == null || children.size() == 0);
            treeView.checkNode(next);
            Map treeNodeMap = (Map)this.getCache("treeNodeMapCache", HashMap.class);
            if (treeNodeMap == null) {
                return;
            }
            this.expandSearchTreeNode(treeView, next, treeNodeMap);
            treeView.treeNodeCheck(next.getParentid(), next.getId(), Boolean.valueOf(true));
            treeView.focusNode(next);
            this.putCache("hitNodes", hitNode);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u540e\u91cd\u65b0\u641c\u7d22\u3002", (String)"TemplateUserPermPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (result == null) {
            this.getPageCache().remove("search_result");
        }
        this.getPageCache().put("search_result", result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
    }

    private void expandSearchTreeNode(TreeView treeView, TreeNode node, Map<String, String> treeNodeMap) {
        if (node == null || treeView == null || StringUtils.isEmpty((String)node.getParentid())) {
            return;
        }
        String parentId = node.getParentid();
        treeView.expand(node.getId());
        TreeNode parentNode = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeMap.get(parentId), TreeNode.class);
        treeView.expand(parentNode.getId());
        this.expandSearchTreeNode(treeView, parentNode, treeNodeMap);
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get("search_result");
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl("tree_template");
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u884c\u5185\u5bb9\u3002", (String)"TemplateUserPermPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u884c\u5185\u5bb9\u3002", (String)"TemplateUserPermPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else {
                List children;
                TreeNode pre = result.pre(i);
                if (pre != null) {
                    tree.uncheckNode(pre.getId());
                }
                next.setLeaf((children = next.getChildren()) == null || children.size() == 0);
                tree.checkNode(next);
                Map treeNodeMap = (Map)this.getCache("treeNodeMapCache", HashMap.class);
                if (treeNodeMap == null) {
                    return;
                }
                this.expandSearchTreeNode(tree, next, treeNodeMap);
                tree.treeNodeClick(next.getParentid(), next.getId());
                tree.focusNode(next);
                pageCache.put("search_result", ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"TemplateUserPermPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void handleRemoveUser() {
        EntryGrid userEntity = (EntryGrid)this.getControl("entity_user");
        int[] selectedRows = userEntity.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u7528\u6237\u7ec4\u6216\u7528\u6237\u8bb0\u5f55\u3002", (String)"TemplateUserPermPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows("entity_user", selectedRows);
        this.getView().updateView("entity_user");
        int currentUserCount = this.getModel().getEntryRowCount("entity_user");
        if (currentUserCount > 0) {
            userEntity.selectRows(0);
            userEntity.entryRowClick(Integer.valueOf(0));
        }
        this.buildAllocatedRecords();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        Object backData = closedCallBackEvent.getReturnData();
        if (backData == null) {
            return;
        }
        switch (actionKey) {
            case "addBaseUser": 
            case "addBaseUserGroup": {
                this.handleUserClosedCallBack(actionKey, backData);
                this.buildAllocatedRecords();
                break;
            }
            case "select_entity": {
                this.handleEntityClosedCallBack(backData);
                this.buildAllocatedRecords();
                break;
            }
        }
    }

    private void handleEntityClosedCallBack(Object backData) {
        DynamicObjectCollection selectedRows = (DynamicObjectCollection)backData;
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entity_entity");
        HashSet<String> selectEntitySigns = new HashSet<String>(16);
        boolean containProperty = false;
        boolean containExclude = false;
        for (DynamicObject object : entity) {
            String type = object.getString("entitytype");
            Long entityId = object.getLong("selectentity_id");
            Long viewGroupId = object.getLong("viewgroup_id");
            selectEntitySigns.add(String.format("%d_%d", entityId, viewGroupId));
            if (EntityTypeEnum.DEFINED_PROPERTY.getCode().equals(type)) {
                containProperty = true;
            }
            if (!object.getBoolean("isexclude")) continue;
            containExclude = true;
        }
        Long modelId = this.getModelId();
        Map viewGroupIdOfView = TemplatePermQueryUtil.getViewToViewGroupMap((Long)modelId);
        boolean remove = selectedRows.removeIf(e -> selectEntitySigns.contains(String.format("%d_%d", e.getLong("mid"), viewGroupIdOfView.get(e.getLong("viewid")))));
        if (remove) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u8df3\u8fc7\u5df2\u9009\u62e9\u7684\u7ec4\u7ec7", (String)"TemplateUserPermPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (selectedRows.isEmpty()) {
                return;
            }
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entity_entity");
        int[] selectRows = entryGrid.getSelectRows();
        this.fillOrgEntryEntity(selectedRows, containProperty, containExclude, viewGroupIdOfView);
        this.setDefaultSelectRows(selectedRows.size(), entity.size(), "entity_entity", selectRows);
    }

    private void fillOrgEntryEntity(DynamicObjectCollection dynamicObjects, boolean containProperty, boolean containExclude, Map<Long, Long> viewGroupIdOfView) {
        HashSet entityIds = new HashSet(16);
        HashSet viewIds = new HashSet(16);
        HashSet viewGroupIds = new HashSet(16);
        dynamicObjects.forEach(e -> {
            entityIds.add(e.getLong("mid"));
            viewIds.add(e.getLong("viewid"));
            viewGroupIds.add(viewGroupIdOfView.get(e.getLong("viewid")));
        });
        Map entityMap = BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,number,name", (QFilter[])new QFilter("id", "in", entityIds).toArray());
        Map propertyMap = BusinessDataServiceHelper.loadFromCache((String)"eb_custompropertyvalue", (String)"id,number,name", (QFilter[])new QFilter("id", "in", entityIds).toArray());
        Map viewMap = BusinessDataServiceHelper.loadFromCache((String)"eb_dimensionview", (String)"id,number,name", (QFilter[])new QFilter("id", "in", viewIds).toArray());
        Map viewGroupMap = BusinessDataServiceHelper.loadFromCache((String)"eb_dimensionview_group", (String)"id,number,name", (QFilter[])new QFilter("id", "in", viewGroupIds).toArray());
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        int[] index = this.getModel().batchCreateNewEntryRow("entity_entity", dynamicObjects.size());
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            Object entity;
            DynamicObject selectedRow = (DynamicObject)dynamicObjects.get(i);
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entity_entity", index[i]);
            EntityTypeEnum type = this.getType(selectedRow);
            Long mid = selectedRow.getLong("mid");
            Long viewId = selectedRow.getLong("viewid");
            Long viewGroupId = viewGroupIdOfView.get(viewId);
            Object v = entity = EntityTypeEnum.DEFINED_PROPERTY == type ? propertyMap.get(mid) : entityMap.get(mid);
            if (EntityTypeEnum.DEFINED_PROPERTY == type) {
                containProperty = true;
            }
            if (selectedRow.getBoolean("exclude")) {
                containExclude = true;
            }
            rowEntity.set("entitytype", (Object)type.getCode());
            rowEntity.set("selectentity", entity);
            rowEntity.set("selectentityrange", (Object)selectedRow.getString("scope"));
            rowEntity.set("isexclude", (Object)selectedRow.getString("exclude"));
            rowEntity.set("view", viewMap.get(viewId));
            rowEntity.set("viewgroup", viewGroupMap.get(viewGroupId));
        }
        this.getModel().endInit();
        this.getView().updateView("entity_entity");
        this.getView().setVisible(Boolean.valueOf(containProperty), new String[]{"entitytype"});
        this.getView().setVisible(Boolean.valueOf(containExclude), new String[]{"isexclude"});
    }

    private EntityTypeEnum getType(DynamicObject selectedRow) {
        String type = selectedRow.getString("type");
        if (RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
            return EntityTypeEnum.DEFINED_PROPERTY;
        }
        return EntityTypeEnum.ENTITY;
    }

    private List<TemplateUserVo> queryTemplateUserList() {
        List<Map<String, Object>> selectedTemplate = this.getSelectedTemplate();
        List<DynamicObject> selectedUser = this.getSelectedUser();
        List<DynamicObject> selectedEntity = this.getSelectedEntity();
        ArrayList<Long> templateIds = new ArrayList<Long>(16);
        ArrayList<Long> userIds = new ArrayList<Long>(16);
        HashMap<Long, Set<Long>> viewGroupEntityIdsMap = new HashMap<Long, Set<Long>>(16);
        if (CollectionUtils.isEmpty(selectedTemplate) && CollectionUtils.isEmpty(selectedUser) && CollectionUtils.isEmpty(selectedEntity)) {
            return new ArrayList<TemplateUserVo>(16);
        }
        for (Map<String, Object> stringObjectMap : selectedTemplate) {
            templateIds.add(Convert.toLong((Object)stringObjectMap.get("id")));
        }
        for (DynamicObject dynamicObject : selectedUser) {
            userIds.add(dynamicObject.getLong("selectuser_id"));
        }
        for (DynamicObject dynamicObject : selectedEntity) {
            long entityId = dynamicObject.getLong("selectentity_id");
            long viewGroupId = dynamicObject.getLong("viewgroup_id");
            Set entityIds = viewGroupEntityIdsMap.computeIfAbsent(viewGroupId, e -> new HashSet(16));
            entityIds.add(entityId);
        }
        QFilter filter = new QFilter("modelid", "=", (Object)this.getModelId());
        if (CollectionUtils.isNotEmpty(templateIds)) {
            filter.and(new QFilter("templateid", "in", templateIds).or("applytemplate", "in", templateIds));
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            filter.and("userid", "in", userIds);
        }
        if (viewGroupEntityIdsMap.size() > 0) {
            HashSet entityIds = new HashSet(16);
            viewGroupEntityIdsMap.values().forEach(entityIds::addAll);
            filter.and("entityid", "in", entityIds).and("viewgroup", "in", viewGroupEntityIdsMap.keySet());
        }
        return this.buildTemplateUserVoListFromDB(filter, viewGroupEntityIdsMap);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<TemplateUserVo> buildTemplateUserVoListFromDB(QFilter filter, Map<Long, Set<Long>> viewGroupEntityIdsMap) {
        long id;
        QFilter qFilter;
        ArrayList<TemplateUserVo> templateUserVos = new ArrayList<TemplateUserVo>(16);
        if (filter == null) {
            return templateUserVos;
        }
        Map<Long, DynamicObject> templates = this.getTemplate();
        log.info("allTemplateDataFormDB" + SerializationUtils.toJsonString(templates));
        HashSet<Long> userIds = new HashSet<Long>(16);
        HashSet<Long> userGrpIds = new HashSet<Long>(16);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        HashSet<Long> definedProperties = new HashSet<Long>(16);
        HashSet<Long> viewGroupIds = new HashSet<Long>(16);
        int count = ORM.create().count("queryTotalCount", "eb_templateuser_entity", filter.toArray());
        if (count > 100000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u5df2\u5206\u914d\u6570\u91cf\u8d85\u8fc710\u4e07\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TemplateUserPermPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return templateUserVos;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateuser_entity", (String)"id, templateid, userid, usertype, modelid, applytemplate, templatetype, entityid, entity_range, entity_exclude, entitytype, viewgroup", (QFilter[])filter.toArray());
        for (DynamicObject object : query) {
            TemplateUserVo templateUserVo = new TemplateUserVo();
            templateUserVo.setId(Long.valueOf(object.getLong("id")));
            String templateType = object.getString("templatetype");
            TemplateTypeEnum templateTypeEnum = TemplateTypeEnum.getTemplateTypeEnumByCode((String)templateType);
            if (templateTypeEnum != null) {
                if (TemplateTypeEnum.APPLY == templateTypeEnum) {
                    templateUserVo.setTemplateId(Long.valueOf(object.getLong("applytemplate")));
                } else {
                    templateUserVo.setTemplateId(Long.valueOf(object.getLong("templateid")));
                }
                templateUserVo.setTemplateType(templateTypeEnum);
                DynamicObject templateInfo = templates.get(templateUserVo.getTemplateId());
                if (templateInfo != null) {
                    templateUserVo.setTemplateName(templateInfo.getString("name"));
                    templateUserVo.setTemplateNumber(templateInfo.getString("number"));
                }
            }
            String userType = object.getString("usertype");
            long userId = object.getLong("userid");
            if (UserTypeEnum.USER.getCode().equals(userType)) {
                userIds.add(userId);
                templateUserVo.setUserType(UserTypeEnum.USER);
            } else if (UserTypeEnum.USERGROUP.getCode().equals(userType)) {
                userGrpIds.add(userId);
                templateUserVo.setUserType(UserTypeEnum.USERGROUP);
            }
            templateUserVo.setUserId(Long.valueOf(userId));
            long entityId = object.getLong("entityid");
            if (entityId != 0L) {
                String entityType = object.getString("entitytype");
                EntityTypeEnum entityTypeEnum = EntityTypeEnum.getEnumByCode((String)entityType);
                if (EntityTypeEnum.ENTITY == entityTypeEnum) {
                    entityIds.add(entityId);
                } else if (EntityTypeEnum.DEFINED_PROPERTY == entityTypeEnum) {
                    definedProperties.add(entityId);
                }
                templateUserVo.setEntityRange(RangeEnum.getRangeByVal((int)Integer.parseInt(object.getString("entity_range"))));
                if (entityTypeEnum != null) {
                    templateUserVo.setEntityType(entityTypeEnum);
                }
                templateUserVo.setEntityExclude(object.getBoolean("entity_exclude"));
            }
            templateUserVo.setEntityId(Long.valueOf(entityId));
            Long viewGroupId = object.getLong("viewgroup");
            viewGroupIds.add(viewGroupId);
            templateUserVo.setViewGroupId(viewGroupId);
            templateUserVos.add(templateUserVo);
        }
        HashMap<Long, BasedataPojo> userInfos = new HashMap<Long, BasedataPojo>(16);
        HashMap userGroupInfos = new HashMap(16);
        if (userIds.size() != 0) {
            Map userInfoByID = TemplatePermQueryUtil.getUsrObjById(new ArrayList(userIds));
            for (Map.Entry entry : userInfoByID.entrySet()) {
                Object id2 = entry.getKey();
                Long pkId = ConvertUtils.toLong(id2);
                DynamicObject userDetail = (DynamicObject)entry.getValue();
                userInfos.put(pkId, new BasedataPojo(pkId, userDetail.getString("name"), userDetail.getString("number")));
            }
        }
        if (userGrpIds.size() != 0) {
            userGroupInfos.putAll(TemplatePermQueryUtil.getUsrGrpObjById(new ArrayList(userGrpIds)));
        }
        HashMap<Long, BasedataPojo> entityInfos = new HashMap<Long, BasedataPojo>(16);
        HashMap<Long, BasedataPojo> definedMap = new HashMap<Long, BasedataPojo>(16);
        HashMap<Long, BasedataPojo> hashMap = new HashMap<Long, BasedataPojo>(16);
        if (entityIds.size() != 0) {
            qFilter = new QFilter("id", "in", entityIds);
            DynamicObjectCollection entities = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject entity : entities) {
                id = entity.getLong("id");
                entityInfos.put(id, new BasedataPojo(Long.valueOf(id), entity.getString("name"), entity.getString("number")));
            }
        }
        if (definedProperties.size() != 0) {
            qFilter = new QFilter("id", "in", definedProperties);
            DynamicObjectCollection entities = QueryServiceHelper.query((String)EntityTypeEnum.DEFINED_PROPERTY.getCode(), (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject entity : entities) {
                id = entity.getLong("id");
                definedMap.put(id, new BasedataPojo(Long.valueOf(id), entity.getString("name"), entity.getString("number")));
            }
        }
        if (viewGroupIds.size() != 0) {
            qFilter = new QFilter("id", "in", viewGroupIds);
            DynamicObjectCollection entities = QueryServiceHelper.query((String)"eb_dimensionview_group", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject entity : entities) {
                id = entity.getLong("id");
                hashMap.put(id, new BasedataPojo(Long.valueOf(id), entity.getString("name"), entity.getString("number")));
            }
        }
        ArrayList<TemplateUserVo> toRemoveTemplateVos = new ArrayList<TemplateUserVo>(16);
        Iterator iterator = templateUserVos.iterator();
        while (true) {
            Long viewGroupId;
            Long entityId;
            TemplateUserVo templateUserVo;
            block34: {
                if (!iterator.hasNext()) {
                    templateUserVos.removeAll(toRemoveTemplateVos);
                    return templateUserVos;
                }
                templateUserVo = (TemplateUserVo)iterator.next();
                Long userId = templateUserVo.getUserId();
                BasedataPojo userInfo = (BasedataPojo)userInfos.get(userId);
                if (userInfo == null) {
                    DynamicObject usrGrpUser = (DynamicObject)userGroupInfos.get(userId);
                    if (usrGrpUser != null) {
                        templateUserVo.setUserName(usrGrpUser.getString("name"));
                        templateUserVo.setUserNumber(usrGrpUser.getString("number"));
                        break block34;
                    } else {
                        toRemoveTemplateVos.add(templateUserVo);
                        continue;
                    }
                }
                templateUserVo.setUserName(userInfo.getName());
                templateUserVo.setUserNumber(userInfo.getNumber());
            }
            if ((entityId = templateUserVo.getEntityId()) == 0L) continue;
            BasedataPojo entityInfo = (BasedataPojo)entityInfos.get(entityId);
            if (entityInfo == null) {
                entityInfo = (BasedataPojo)definedMap.get(entityId);
            }
            if (entityInfo != null) {
                templateUserVo.setEntityName(entityInfo.getName());
                templateUserVo.setEntityNumber(entityInfo.getNumber());
            } else {
                toRemoveTemplateVos.add(templateUserVo);
            }
            if ((viewGroupId = templateUserVo.getViewGroupId()) == 0L) continue;
            BasedataPojo viewGroupInfo = (BasedataPojo)hashMap.get(viewGroupId);
            if (viewGroupInfo != null) {
                templateUserVo.setViewGroupName(viewGroupInfo.getName());
                templateUserVo.setViewGroupNumber(viewGroupInfo.getNumber());
            } else {
                toRemoveTemplateVos.add(templateUserVo);
            }
            if (viewGroupEntityIdsMap.get(viewGroupId) == null || viewGroupEntityIdsMap.get(viewGroupId).contains(entityId)) continue;
            toRemoveTemplateVos.add(templateUserVo);
        }
    }

    private void handleUserClosedCallBack(String actionKey, Object backData) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)backData;
        ArrayList selectIds = new ArrayList(16);
        selectedRows.forEach(row -> selectIds.add(row.getPrimaryKeyValue()));
        IDataModel dataModel = this.getModel();
        String userType = UserTypeEnum.USER.getCode();
        if ("addBaseUserGroup".equals(actionKey)) {
            userType = UserTypeEnum.USERGROUP.getCode();
        }
        int counts = dataModel.getEntryRowCount("entity_user");
        dataModel.batchCreateNewEntryRow("entity_user", selectIds.size());
        for (int i = counts; i < counts + selectIds.size(); ++i) {
            this.getModel().setValue("usertype", (Object)userType, i);
            this.getModel().setValue("selectuser", selectIds.get(i - counts), i);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entity_user");
        this.setDefaultSelectRows(selectIds.size(), counts, "entity_user", entryGrid.getSelectRows());
    }

    private void setDefaultSelectRows(int size, int counts, String entryKey, int[] selectRows) {
        ArrayList<Integer> toSelects = new ArrayList<Integer>(10);
        for (int i = 0; i < size; ++i) {
            toSelects.add(counts + i);
        }
        for (int selectRow : selectRows) {
            toSelects.add(selectRow);
        }
        toSelects.sort(Comparator.comparingInt(Integer::intValue));
        int[] rowIndex = toSelects.stream().mapToInt(Integer::intValue).toArray();
        if (rowIndex.length > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
            entryGrid.selectRows(rowIndex, rowIndex[0]);
        }
    }

    private void handleSelectUser() {
        this.showUserOrGroupForm(UserTypeEnum.USER.getCode(), "addBaseUser");
    }

    private void handleSelectUserGroup() {
        this.showUserOrGroupForm(UserTypeEnum.USERGROUP.getCode(), "addBaseUserGroup");
    }

    private void showUserOrGroupForm(String entityType, String callBackKey) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityType, (boolean)true);
        this.addUserAndGroupFilter(entityType, listShowParameter);
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void handleSelectEntity() {
        Long modelId = this.getModelId();
        MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)DynamicObject.class.getName());
        f8Param.setShowCustomProperty(true);
        f8Param.setReturnAllData(true);
        f8Param.setShowExclude(true);
        f8Param.setEnableView(true);
        f8Param.setRangeType(F7RangeTypeEnum.CUSTOMIZE);
        f8Param.setLoadDefaultBusModel(false);
        List entityViewIds = this.getIModelCacheHelper().getDimension(SysDimensionEnum.Entity.getNumber()).getViewList();
        if (entityViewIds.size() > 0) {
            f8Param.setViewId((Long)entityViewIds.get(0));
        }
        f8Param.setCusRange(Arrays.asList(RangeEnum.ONLY.getIndStr(), RangeEnum.DIRECTSUB_EXCLUDE.getIndStr(), RangeEnum.DIRECTSUB.getIndStr(), RangeEnum.ALL_EXCLUDE.getIndStr(), RangeEnum.ALL.getIndStr(), RangeEnum.ALL_DETAIL.getIndStr(), RangeEnum.ALL_NOTDETAIL.getIndStr()));
        f8Param.setDefRangeValue(RangeEnum.ONLY);
        NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "select_entity"));
    }

    private void handleRemoveEntity() {
        EntryGrid entityEntry = (EntryGrid)this.getControl("entity_entity");
        int[] selectedRows = entityEntry.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u7ec4\u7ec7\u8bb0\u5f55\u3002", (String)"TemplateUserPermPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows("entity_entity", selectedRows);
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entity_entity");
        boolean containProperty = false;
        boolean containExclude = false;
        for (DynamicObject dynamicObject : entity) {
            String entityType = dynamicObject.getString("entitytype");
            if (EntityTypeEnum.DEFINED_PROPERTY.getCode().equals(entityType)) {
                containProperty = true;
            }
            if (!dynamicObject.getBoolean("isexclude")) continue;
            containExclude = true;
        }
        this.getView().setVisible(Boolean.valueOf(containProperty), new String[]{"entitytype"});
        this.getView().setVisible(Boolean.valueOf(containExclude), new String[]{"isexclude"});
        this.buildAllocatedRecords();
    }

    private void addUserAndGroupFilter(String userType, ListShowParameter listShowParameter) {
        DynamicObjectCollection us = this.getModel().getEntryEntity("entity_user");
        ArrayList selectedIds = new ArrayList(16);
        long currentUserId = this.getUserId();
        if (us != null && !us.isEmpty()) {
            us.forEach(u -> {
                if (StringUtils.equals((String)userType, (String)u.getString("usertype")) && currentUserId != u.getLong("id")) {
                    selectedIds.add(u.getLong("selectuser_id"));
                }
            });
        }
        selectedIds.addAll(TemplateUserPermHelper.getAdminUserOrGroups((String)userType, (Long)this.getModelId()));
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (!selectedIds.isEmpty()) {
            qFilters.add(new QFilter("id", "not in", selectedIds));
        }
    }

    private void handleAllocate() {
        List<Map<String, Object>> selectTemplateNodes = this.getSelectedTemplate();
        if (CollectionUtils.isEmpty(selectTemplateNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6a21\u677f\u3002", (String)"TemplateUserPermPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkTemplateExist(selectTemplateNodes)) {
            return;
        }
        List<DynamicObject> selectUsers = this.getSelectedUser();
        if (CollectionUtils.isEmpty(selectUsers)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7528\u6237\u7ec4\u6216\u7528\u6237\u3002", (String)"TemplateUserPermPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkUserExist(selectUsers)) {
            return;
        }
        List<DynamicObject> selectedEntities = this.getSelectedEntity();
        if (this.checkEntityExist(selectedEntities)) {
            return;
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        boolean existSame = this.buildTemplateUserEntity(dynamicObjects, selectTemplateNodes, selectUsers, selectedEntities);
        if (existSame) {
            if (dynamicObjects.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6ca1\u6709\u53d8\u5316\uff0c\u65e0\u9700\u4fdd\u5b58\u3002", (String)"TemplateUserPermPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u7684\u6a21\u677f\u3001\u7528\u6237\u3001\u7ec4\u7ec7\u7ec4\u5408\u4e0d\u4f1a\u6dfb\u52a0\u5230\u5df2\u5206\u914d\u5217\u8868\u3002", (String)"TemplateUserPermPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        HashSet<String> userNumbers = new HashSet<String>(16);
        for (DynamicObject selectUser : selectUsers) {
            DynamicObject dynamicObject = selectUser.getDynamicObject("selectuser");
            if (dynamicObject == null) continue;
            userNumbers.add(dynamicObject.getString("number"));
        }
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        try {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"TemplateUserPermPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog(null, "allocation", new MultiLangEnumBridge("\u5206\u914d", "TemplateUserPermPlugin_24", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bf9\u7528\u6237/\u7528\u6237\u7ec4\u201c%1$s\u201d\u5206\u914d\u4f53\u7cfb\u201c%2$s\u201d\u7684\u6a21\u677f\u6743\u9650\u8bb0\u5f55", "TemplateUserPermPlugin_25", "epm-eb-formplugin"), new String[]{String.join((CharSequence)"\u3001", userNumbers), modelCacheHelper.getModelobj().getNumber()});
        }
        catch (Throwable throwable) {
            log.error(throwable);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002", (String)"TemplateUserPermPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.buildAllocatedRecords();
    }

    private boolean checkEntityExist(List<DynamicObject> selectedEntities) {
        if (CollectionUtils.isEmpty(selectedEntities)) {
            return false;
        }
        for (DynamicObject selectedEntity : selectedEntities) {
            if (selectedEntity.getDynamicObject("selectentity") != null) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u9009\u62e9\u7684\u7b2c%1\u884c\u7ec4\u7ec7\u6210\u5458\u6216\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"UserTemplatePermListDataPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{selectedEntity.getInt("seq")}));
            return true;
        }
        return false;
    }

    private boolean checkUserExist(List<DynamicObject> selectedEntities) {
        if (CollectionUtils.isEmpty(selectedEntities)) {
            return false;
        }
        for (DynamicObject selectedEntity : selectedEntities) {
            if (selectedEntity.getDynamicObject("selectuser") != null) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u9009\u62e9\u7684\u7b2c%1\u884c\u7528\u6237\u6216\u7528\u6237\u7ec4\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"UserTemplatePermListDataPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{selectedEntity.getInt("seq")}));
            return true;
        }
        return false;
    }

    private boolean checkTemplateExist(List<Map<String, Object>> selectTemplateNodes) {
        DynamicObjectCollection query1;
        if (CollectionUtils.isEmpty(selectTemplateNodes)) {
            return false;
        }
        Set ids = selectTemplateNodes.stream().map(e -> IDUtils.toLong(e.get("id"))).collect(Collectors.toSet());
        HashSet existTemplateIds = new HashSet(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateentity", (String)"id", (QFilter[])new QFilter("id", "in", ids).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            query.forEach(e -> existTemplateIds.add(e.getString("id")));
        }
        if (CollectionUtils.isNotEmpty((Collection)(query1 = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id", (QFilter[])new QFilter("id", "in", ids).toArray())))) {
            query1.forEach(e -> existTemplateIds.add(e.getString("id")));
        }
        for (Map<String, Object> node : selectTemplateNodes) {
            if (existTemplateIds.contains((String)node.get("id"))) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"UserTemplatePermListDataPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{node.get("text")}));
            return true;
        }
        return false;
    }

    private void buildAllocatedRecords() {
        this.getModel().deleteEntryData("entity_allocate");
        List<TemplateUserVo> templateUserFormDB = this.queryTemplateUserList();
        log.info("allocateTemplateDataFormDB" + SerializationUtils.toJsonString(templateUserFormDB));
        if (templateUserFormDB.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entity_type", "entity_exclude"});
            return;
        }
        Map<String, TemplateUserVo> templateUserVoMap = this.collectTemplateUserRecordKey(templateUserFormDB);
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        int[] rows = this.getModel().batchCreateNewEntryRow("entity_allocate", templateUserFormDB.size());
        boolean containProperty = false;
        boolean containExclude = false;
        List<String> sortedKeys = this.sortTemplateRecordKeys(templateUserVoMap.keySet());
        String excludeText = ResManager.loadKDString((String)"\u662f", (String)"UserTemplatePermListDataPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < sortedKeys.size(); ++i) {
            EntityTypeEnum entityType;
            String sortedKey = sortedKeys.get(i);
            TemplateUserVo templateUserVo = templateUserVoMap.get(sortedKey);
            int row = rows[i];
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entity_allocate", row);
            entryRowEntity.set("temp_type", (Object)templateUserVo.getTemplateType().getDesc());
            entryRowEntity.set("temp_number", (Object)templateUserVo.getTemplateNumber());
            entryRowEntity.set("temp_name", (Object)templateUserVo.getTemplateName());
            entryRowEntity.set("user_name", (Object)templateUserVo.getUserName());
            entryRowEntity.set("entity", (Object)templateUserVo.getEntityName());
            RangeEnum entityRange = templateUserVo.getEntityRange();
            if (entityRange != null) {
                entryRowEntity.set("entity_range", (Object)entityRange.getName());
            }
            entryRowEntity.set("entity_exclude", (Object)(templateUserVo.isEntityExclude() ? excludeText : null));
            if (templateUserVo.isEntityExclude()) {
                containExclude = true;
            }
            if ((entityType = templateUserVo.getEntityType()) != null) {
                entryRowEntity.set("entity_type", (Object)entityType.getDesc());
                if (EntityTypeEnum.DEFINED_PROPERTY == entityType) {
                    containProperty = true;
                }
            }
            entryRowEntity.set("entity_viewgroup", (Object)templateUserVo.getViewGroupName());
            entryRowEntity.set("allocate_id", (Object)templateUserVo.getId());
        }
        this.getModel().endInit();
        this.getView().setVisible(Boolean.valueOf(containProperty), new String[]{"entity_type"});
        this.getView().setVisible(Boolean.valueOf(containExclude), new String[]{"entity_exclude"});
        this.getModel().updateCache();
        this.getView().updateView("entity_allocate");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entity_allocate");
        Integer index = entryGrid.getEntryState().getCurrentPageIndex();
        if (index > 1) {
            entryGrid.setPageIndex(1);
        }
    }

    private List<String> sortTemplateRecordKeys(Set<String> recordKeys) {
        ArrayList<String> toSortKeys = new ArrayList<String>(recordKeys);
        toSortKeys.sort((key1, key2) -> {
            char[] chars1 = key1.toCharArray();
            char[] chars2 = key2.toCharArray();
            for (int i = 0; i < chars1.length && i < chars2.length; ++i) {
                if (chars1[i] == chars2[i]) continue;
                if (chars1[i] == '!') {
                    return -1;
                }
                if (chars2[i] == '!') {
                    return 1;
                }
                if (chars1[i] < chars2[i]) {
                    return -1;
                }
                return 1;
            }
            return 0;
        });
        return toSortKeys;
    }

    private Map<String, TemplateUserVo> collectTemplateUserRecordKey(List<TemplateUserVo> templateUserFormDB) {
        HashMap<String, TemplateUserVo> templatePermRecordMap = new HashMap<String, TemplateUserVo>(16);
        ShowWayEnum showWayEnum = this.getShowWayEnum();
        if (showWayEnum == null) {
            showWayEnum = ShowWayEnum.TEMPLATE_SHOW;
        }
        for (TemplateUserVo templateUserVo : templateUserFormDB) {
            String keyByShowWay = this.getKeyByShowWay(templateUserVo, showWayEnum);
            if (templatePermRecordMap.containsKey(keyByShowWay)) {
                templatePermRecordMap.put(keyByShowWay, templateUserVo);
            }
            templatePermRecordMap.put(keyByShowWay, templateUserVo);
        }
        return templatePermRecordMap;
    }

    private String getKeyByShowWay(TemplateUserVo templateUserVo, ShowWayEnum showWayEnum) {
        ArrayList<String> recordKeys = new ArrayList<String>(16);
        switch (showWayEnum) {
            case TEMPLATE_SHOW: {
                this.addToKey(recordKeys, templateUserVo.getTemplateNumber());
                this.addToKey(recordKeys, templateUserVo.getViewGroupNumber());
                this.addToKey(recordKeys, templateUserVo.getEntityNumber());
                this.addToKey(recordKeys, templateUserVo.getUserNumber());
                this.addToKey(recordKeys, templateUserVo.getTemplateType().getCode());
                this.addToKey(recordKeys, EntityTypeEnum.ENTITY == templateUserVo.getEntityType() ? "0" : "1");
                this.addToKey(recordKeys, UserTypeEnum.USER == templateUserVo.getUserType() ? "0" : "1");
                break;
            }
            case USER_SHOW: {
                this.addToKey(recordKeys, templateUserVo.getUserNumber());
                this.addToKey(recordKeys, templateUserVo.getTemplateNumber());
                this.addToKey(recordKeys, templateUserVo.getViewGroupNumber());
                this.addToKey(recordKeys, templateUserVo.getEntityNumber());
                this.addToKey(recordKeys, UserTypeEnum.USER == templateUserVo.getUserType() ? "0" : "1");
                this.addToKey(recordKeys, templateUserVo.getTemplateType().getCode());
                this.addToKey(recordKeys, EntityTypeEnum.ENTITY == templateUserVo.getEntityType() ? "0" : "1");
                break;
            }
            case ENTITY_SHOW: {
                this.addToKey(recordKeys, templateUserVo.getViewGroupNumber());
                this.addToKey(recordKeys, templateUserVo.getEntityNumber());
                this.addToKey(recordKeys, templateUserVo.getTemplateNumber());
                this.addToKey(recordKeys, templateUserVo.getUserNumber());
                this.addToKey(recordKeys, EntityTypeEnum.ENTITY == templateUserVo.getEntityType() ? "0" : "1");
                this.addToKey(recordKeys, templateUserVo.getTemplateType().getCode());
                this.addToKey(recordKeys, UserTypeEnum.USER == templateUserVo.getUserType() ? "0" : "1");
                break;
            }
        }
        return String.join((CharSequence)"!", recordKeys);
    }

    private void addToKey(List<String> recordKeys, String number) {
        if (StringUtils.isNotEmpty((String)number)) {
            recordKeys.add(number);
        } else {
            recordKeys.add("");
        }
    }

    private void clearTreeNodes() {
        TreeView treeView = (TreeView)this.getControl("tree_template");
        treeView.deleteAllNodes();
    }

    private void unSelectUserList() {
        this.getModel().deleteEntryData("entity_user");
    }

    private void unSelectEntityList() {
        this.getModel().deleteEntryData("entity_entity");
    }

    private List<DynamicObject> getSelectedUser() {
        ArrayList<DynamicObject> selectUser = new ArrayList<DynamicObject>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entity_user");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return selectUser;
        }
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entity_user", selectRow);
            selectUser.add(entryRowEntity);
        }
        return selectUser;
    }

    private List<DynamicObject> getSelectedEntity() {
        ArrayList<DynamicObject> selectEntity = new ArrayList<DynamicObject>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entity_entity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return selectEntity;
        }
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entity_entity", selectRow);
            if (entryRowEntity == null) continue;
            selectEntity.add(entryRowEntity);
        }
        return selectEntity;
    }

    private List<Map<String, Object>> getSelectedTemplate() {
        ArrayList<Map<String, Object>> selectTemplate = new ArrayList<Map<String, Object>>(16);
        ArrayList<String> selectTemplateIds = new ArrayList<String>(16);
        TreeView treeView = (TreeView)this.getControl("tree_template");
        List selectedNodes = treeView.getTreeState().getSelectedNodes();
        if (CollectionUtils.isEmpty((Collection)selectedNodes)) {
            return selectTemplate;
        }
        for (Map selectedNode : selectedNodes) {
            Object isParent = selectedNode.get("isParent");
            Object leaf = selectedNode.get("leaf");
            Object parentId = selectedNode.get("parentid");
            if (isParent == null && leaf == null || parentId == null || StringUtils.isEmpty((String)parentId.toString())) continue;
            boolean aBoolean = isParent == null ? !Convert.toBool(leaf).booleanValue() : Convert.toBool(isParent);
            if (aBoolean) continue;
            selectTemplate.add(selectedNode);
            selectTemplateIds.add(selectedNode.get("id").toString());
        }
        this.putCache("selecttemplate_key", selectTemplateIds);
        return selectTemplate;
    }

    private boolean buildTemplateUserEntity(List<DynamicObject> templateUserEntityList, List<Map<String, Object>> selectTemplateNodes, List<DynamicObject> selectUsers, List<DynamicObject> selectedEntities) {
        boolean existSame = false;
        Long modelId = this.getModelId();
        QFilter filter = new QFilter("modelid", "=", (Object)modelId);
        DynamicObjectCollection signKeyCollections = QueryServiceHelper.query((String)"eb_templateuser_entity", (String)"sign_key", (QFilter[])filter.toArray());
        Set signKeys = signKeyCollections.stream().map(e -> e.getString("sign_key")).collect(Collectors.toSet());
        TreeNode rootNode = (TreeNode)this.getCache("treeCacheName", TreeNode.class);
        for (Map<String, Object> selectTemplateNode : selectTemplateNodes) {
            String templateType = this.getTemplateType(selectTemplateNode, rootNode);
            for (DynamicObject userDynamic : selectUsers) {
                Long selectTemplateId = ConvertUtils.toLong((Object)selectTemplateNode.get("id"));
                long selectUserId = userDynamic.getDynamicObject("selectuser").getLong("id");
                String userType = userDynamic.getString("usertype");
                StringBuilder signKey = new StringBuilder().append(selectTemplateId).append('!').append(selectUserId).append('!');
                if (selectedEntities.size() == 0) {
                    signKey.append("0!").append("0");
                    if (signKeys.contains(signKey.toString())) {
                        existSame = true;
                        continue;
                    }
                    templateUserEntityList.add(this.buildEntryRecord(modelId, selectTemplateId, templateType, selectUserId, userType, 0L, 0L, String.valueOf(RangeEnum.ONLY.getIndex()), false, SysDimensionEnum.Entity.getMemberTreemodel(), signKey.toString()));
                    continue;
                }
                for (DynamicObject selectedEntity : selectedEntities) {
                    StringBuilder signKey_tmp = new StringBuilder();
                    signKey_tmp.append((CharSequence)signKey);
                    Long selectEntityId = selectedEntity.getLong("selectentity_id");
                    Long entityViewGroupId = selectedEntity.getLong("viewgroup_id");
                    String selectEntityRange = selectedEntity.getString("selectentityrange");
                    boolean isExclude = selectedEntity.getBoolean("isexclude");
                    String entityType = selectedEntity.getString("entitytype");
                    signKey_tmp.append(selectEntityId).append("!").append(entityViewGroupId);
                    if (signKeys.contains(signKey_tmp.toString())) {
                        existSame = true;
                        continue;
                    }
                    templateUserEntityList.add(this.buildEntryRecord(modelId, selectTemplateId, templateType, selectUserId, userType, selectEntityId, entityViewGroupId, selectEntityRange, isExclude, entityType, signKey_tmp.toString()));
                }
            }
        }
        return existSame;
    }

    private DynamicObject buildEntryRecord(Long modelId, Long selectTemplateId, String templateType, Long selectUserId, String userType, Long selectEntityId, Long viewGroupId, String rangeIndex, boolean isExclude, String entityType, String signKey) {
        DynamicObject templateUserEntity = BusinessDataServiceHelper.newDynamicObject((String)"eb_templateuser_entity");
        templateUserEntity.set("templatetype", (Object)templateType);
        if (TemplateTypeEnum.APPLY.getCode().equals(templateType)) {
            templateUserEntity.set("applytemplate", (Object)selectTemplateId);
        } else {
            templateUserEntity.set("templateid", (Object)selectTemplateId);
        }
        templateUserEntity.set("usertype", (Object)userType);
        templateUserEntity.set("userid", (Object)selectUserId);
        templateUserEntity.set("modelid", (Object)modelId);
        templateUserEntity.set("entityid", (Object)selectEntityId);
        templateUserEntity.set("entity_range", (Object)rangeIndex);
        templateUserEntity.set("entity_exclude", (Object)isExclude);
        templateUserEntity.set("entitytype", (Object)entityType);
        templateUserEntity.set("viewgroup", (Object)viewGroupId);
        templateUserEntity.set("sign_key", (Object)signKey);
        Long userId = this.getUserId();
        Date now = TimeServiceHelper.now();
        templateUserEntity.set("creator", (Object)userId);
        templateUserEntity.set("createtime", (Object)now);
        templateUserEntity.set("modifier", (Object)userId);
        templateUserEntity.set("modifydate", (Object)now);
        return templateUserEntity;
    }

    private void handleAllocateCancel() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entity_allocate");
        int[] selectedRows = entryGrid.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u7684\u8bb0\u5f55\u3002", (String)"TemplateUserPermPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u53cd\u5206\u914d\uff1f", (String)"TemplateUserPermPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("handleCancelAllocate", (IFormPlugin)this));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((String)propName, (String)"model")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            QFilter qFilter = new QFilter("reporttype", "in", (Object)new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BG.getIndex()});
            qFilter.and("status", "=", (Object)"C").and("enable", "!=", (Object)"0");
            qFilterList.add(qFilter);
            Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
            QFilter qIds = new QFilter("id", "in", (Object)modelIds);
            qFilterList.add(qIds);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            showParameter.setSelectedRow((Object)this.getModelId());
            beforeF7SelectEvent.setFormShowParameter((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValueObj = e.getChangeSet()[0].getNewValue();
        Object oldValueObj = e.getChangeSet()[0].getOldValue();
        if ("select_showway".equals(key)) {
            if (newValueObj == null || oldValueObj == null) {
                return;
            }
            boolean hasPermModelList = this.isHasPermModelList(this.getModelId());
            if (!hasPermModelList) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"TemplateUserPermPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String newValue = newValueObj.toString();
            this.handleShowWayPropertyChange(newValue);
        }
    }

    private void handleShowWayPropertyChange(String newValue) {
        this.putCache("showWay", newValue);
        this.updateGridColumns();
        this.buildAllocatedRecords();
    }

    private void handleModelPropertyChange() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null) {
            Long modelId = model.getLong("id");
            boolean hasPermModelList = this.isHasPermModelList(modelId);
            if (!hasPermModelList) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"TemplateUserPermPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("model", null);
                return;
            }
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            this.putCache("model", modelId);
            this.initLeftTree();
            TemplatePermUpgradeHelper.getInstance().upgradeModelTemplatePermData(modelId);
        } else {
            this.getPageCache().remove("model");
            this.clearTreeNodes();
        }
        this.getModel().deleteEntryData("entity_allocate");
        this.unSelectUserList();
        this.unSelectEntityList();
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getPageCache().remove("model");
            this.putCache("showWay", ShowWayEnum.TEMPLATE_SHOW.getCode());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"TemplateUserPermPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            Set limitedModelListByUser = MemberPermHelper.getLimitedModelListByUser();
            if (CollectionUtils.isEmpty((Collection)limitedModelListByUser)) {
                this.getPageCache().remove("model");
                this.getModel().setValue("model", null);
            } else {
                QFilter qFilter;
                DynamicObjectCollection query;
                DynamicObject object;
                boolean hasPermModelList = limitedModelListByUser.contains(modelId);
                if (!hasPermModelList && (object = (DynamicObject)(query = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])(qFilter = new QFilter("id", "in", (Object)limitedModelListByUser)).toArray(), (String)"modifytime desc")).get(0)) != null) {
                    modelId = object.getLong("id");
                }
                if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
                    this.putCache("model", modelId);
                    UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                    this.getModel().setValue("model", (Object)modelId);
                    this.initLeftTree();
                    TemplatePermUpgradeHelper.getInstance().upgradeModelTemplatePermData(modelId);
                }
            }
            this.putCache("showWay", ShowWayEnum.TEMPLATE_SHOW.getCode());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entitytype", "entity_type", "entity_exclude", "isexclude"});
        }
    }

    private boolean isHasPermModelList(Long modelId) {
        List modelFilter = ModelUtil.getModelFilter((IFormView)this.getView());
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"epm_model", (QFilter[])modelFilter.toArray(new QFilter[0]));
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectMap.get(modelId);
        return dynamicObject != null;
    }

    public Long getModelId() {
        Long modelId = (Long)this.getCache("model", Long.class);
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            UserSelectModel userSelect = UserSelectServiceHelperNew.getUserSelect((Long)UserUtils.getUserId(), (String)"id,model,application,entity,period,currency,modifier,onlymodel,formid,date,version,bizmodel,modeltype", (ApplicationTypeEnum)ApplicationTypeEnum.BGMD, (IFormView)this.getView());
            if (userSelect != null) {
                modelId = userSelect.getModel();
            } else {
                Set modelIds = ModelServiceHelper.getLimitedModelListByUser((ApplicationTypeEnum)ApplicationTypeEnum.BGMD);
                if (modelIds.size() != 0) {
                    modelId = (Long)modelIds.iterator().next();
                } else {
                    modelIds = ModelServiceHelper.getLimitedModelListByUser((ApplicationTypeEnum)ApplicationTypeEnum.BG);
                    if (modelIds.size() != 0) {
                        modelId = (Long)modelIds.iterator().next();
                    }
                }
            }
            if (modelId == null) {
                this.getPageCache().remove("model");
            } else {
                this.putCache("model", modelId);
            }
        }
        return modelId;
    }

    private void initLeftTree() {
        TreeView treeView = (TreeView)this.getControl("tree_template");
        treeView.deleteAllNodes();
        TreeNode allNode = this.getAllNode();
        this.putCache("treeCacheName", allNode);
        if (allNode != null) {
            this.deleteNoTempCatalog(allNode);
            allNode.setParentid("");
            treeView.updateNode(allNode);
            treeView.addNode(allNode);
            treeView.expand(allNode.getId());
        }
        TreeSearchUtil.clearSearchPageCache((IPageCache)this.getPageCache(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam("tree_template"));
    }

    private void deleteNoTempCatalog(TreeNode root) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        this.getNeedDeleteList(root, list);
        if (list.size() == 0) {
            return;
        }
        for (TreeNode treeNode : list) {
            String nodeId = treeNode.getId();
            root.getTreeNode(nodeId, 20);
            root.deleteChildNode(nodeId);
        }
    }

    private void getNeedDeleteList(TreeNode root, List<TreeNode> list) {
        if (root == null || root.getChildren() == null || root.getChildren().size() == 0) {
            return;
        }
        List childs = root.getChildren();
        for (TreeNode child : childs) {
            this.getNeedDeleteList(child, list);
            Map dataMap = (Map)child.getData();
            if ("1".equals(dataMap.get("flag"))) {
                Map rootMap = (Map)root.getData();
                rootMap.put("flag", "1");
                continue;
            }
            list.add(child);
        }
    }

    private TreeNode getAllNode() {
        TreeNode rootNode = null;
        TreeNode budgetNodes = this.getAllBudgetTemplateNode();
        TreeNode applyNodes = this.getAllApplyTemplateNode();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
        if (budgetNodes != null) {
            budgetNodes.setText(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f", (String)"TemplateUserPermPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            children.add(budgetNodes);
        }
        if (applyNodes != null) {
            applyNodes.setText(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f", (String)"TemplateUserPermPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            children.add(applyNodes);
        }
        if (budgetNodes != null || applyNodes != null) {
            rootNode = new TreeNode("", "", ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"TemplateUserPermPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            dataMap.put("type", "template");
            dataMap.put("flag", "0");
            rootNode.setData(dataMap);
            rootNode.setChildren(children);
        }
        return rootNode;
    }

    private TreeNode getAllApplyTemplateNode() {
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        HashMap<String, ArrayList<TreeNode>> map = new HashMap<String, ArrayList<TreeNode>>(16);
        Map treeNodeMapCache = (Map)this.getCache("treeNodeMapCache", HashMap.class, () -> new HashMap(16));
        try (DataSet templateDataSet = QueryServiceHelper.queryDataSet((String)"queryApplyTemplate", (String)"eb_applytemplate", (String)"id,name,number,templatetype as templatecatalog,templatestatus", (QFilter[])new QFilter[]{modelQf}, (String)"number");){
            while (templateDataSet.hasNext()) {
                Row next = templateDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("number") + " " + next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "1");
                dataMap.put("templatetype", "1");
                treeNode.setData(dataMap);
                ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)map.get(next.getString("templatecatalog"));
                treeNode.setParentid(next.getString("templatecatalog"));
                if (treeNodes == null) {
                    treeNodes = new ArrayList<TreeNode>(16);
                    map.put(next.getString("templatecatalog"), treeNodes);
                }
                treeNodes.add(treeNode);
                treeNodeMapCache.put(treeNode.getId(), SerializationUtils.toJsonString((Object)treeNode));
            }
        }
        TreeNode rootNode = null;
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        try (DataSet catalogDataSet = QueryServiceHelper.queryDataSet((String)"queryApplyTemplateCatalog", (String)"eb_applytemplatelog", (String)"id,name,number,parent", (QFilter[])modelQf.toArray(), (String)"level,sequence");){
            while (catalogDataSet.hasNext()) {
                Row next = catalogDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "0");
                dataMap.put("templatetype", "1");
                treeNode.setData(dataMap);
                catalogMap.put(next.getString("id"), treeNode);
                String parent = next.getString("parent");
                if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)parent) || "0".equals(parent)) {
                    rootNode = treeNode;
                } else {
                    treeNode.setParentid(parent);
                    TreeNode treeNode1 = (TreeNode)catalogMap.get(parent);
                    ArrayList<TreeNode> children = treeNode1.getChildren();
                    if (children == null) {
                        children = new ArrayList<TreeNode>(16);
                        treeNode1.setChildren(children);
                    }
                    children.add(treeNode);
                }
                treeNodeMapCache.put(treeNode.getId(), SerializationUtils.toJsonString((Object)treeNode));
                if (!map.containsKey(next.getString("id"))) continue;
                List treeNodes = (List)map.get(next.getString("id"));
                treeNode.setChildren(treeNodes);
            }
        }
        this.putCache("treeNodeMapCache", treeNodeMapCache);
        return rootNode;
    }

    private TreeNode getAllBudgetTemplateNode() {
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        HashMap<String, ArrayList<TreeNode>> map = new HashMap<String, ArrayList<TreeNode>>(16);
        HashSet<String> templateIds = new HashSet<String>(16);
        HashMap<String, String> treeNodeMapCache = new HashMap<String, String>(128);
        try (DataSet templateDataSet = QueryServiceHelper.queryDataSet((String)"queryebtemplate", (String)"eb_templateentity", (String)"id,name,number,templatecatalog,templatetype,templatestatus", (QFilter[])new QFilter[]{modelQf}, (String)"number");){
            while (templateDataSet.hasNext()) {
                Row next = templateDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                templateIds.add(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("number") + " " + next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "1");
                dataMap.put("templatetype", "0");
                treeNode.setData(dataMap);
                ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)map.get(next.getString("templatecatalog"));
                treeNode.setParentid(next.getString("templatecatalog"));
                if (treeNodes == null) {
                    treeNodes = new ArrayList<TreeNode>(16);
                    map.put(next.getString("templatecatalog"), treeNodes);
                }
                treeNodes.add(treeNode);
                treeNodeMapCache.put(treeNode.getId(), SerializationUtils.toJsonString((Object)treeNode));
            }
        }
        this.putCache("templatecacheids", templateIds);
        TreeNode rootNode = null;
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        try (DataSet catalogDataSet = QueryServiceHelper.queryDataSet((String)"querytemplatecatalog", (String)"eb_templatecatalog", (String)"id,name,number,parent", (QFilter[])modelQf.toArray(), (String)"level,sequence");){
            while (catalogDataSet.hasNext()) {
                Row next = catalogDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "0");
                dataMap.put("templatetype", "0");
                treeNode.setData(dataMap);
                catalogMap.put(next.getString("id"), treeNode);
                String parent = next.getString("parent");
                if ((StringUtils.isEmpty((String)parent) || "0".equals(parent)) && rootNode == null) {
                    rootNode = treeNode;
                } else {
                    TreeNode treeNode1 = (TreeNode)catalogMap.get(parent);
                    if (treeNode1 == null) continue;
                    treeNode.setParentid(parent);
                    ArrayList<TreeNode> children = treeNode1.getChildren();
                    if (children == null) {
                        children = new ArrayList<TreeNode>(16);
                        treeNode1.setChildren(children);
                    }
                    children.add(treeNode);
                }
                treeNodeMapCache.put(treeNode.getId(), SerializationUtils.toJsonString((Object)treeNode));
                if (!map.containsKey(next.getString("id"))) continue;
                List treeNodes = (List)map.get(next.getString("id"));
                treeNode.setChildren(treeNodes);
            }
        }
        this.putCache("treeNodeMapCache", treeNodeMapCache);
        return rootNode;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("handleCancelAllocate".equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            int[] selectedRows;
            String showWay = (String)this.getCache("showWay", String.class);
            if (StringUtils.isEmpty((String)showWay)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c55\u793a\u65b9\u5f0f\u3002", (String)"TemplateUserPermPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entity_allocate");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entity_allocate");
            ArrayList<Long> deleteTemplateIds = new ArrayList<Long>(16);
            for (int selectedRow : selectedRows = entryGrid.getSelectRows()) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectedRow);
                long templateUserId = dynamicObject.getLong("allocate_id");
                if (IDUtils.isNull((long)templateUserId)) continue;
                deleteTemplateIds.add(templateUserId);
            }
            HashSet userNumbers = new HashSet(16);
            HashSet<Long> userIds = new HashSet<Long>(16);
            HashSet<Long> userGroupIds = new HashSet<Long>(16);
            DynamicObjectCollection records = QueryServiceHelper.query((String)"eb_templateuser_entity", (String)"userid, usertype", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteTemplateIds)});
            for (DynamicObject record : records) {
                if (UserTypeEnum.USER.getCode().equals(record.getString("usertype"))) {
                    userIds.add(record.getLong("userid"));
                    continue;
                }
                userGroupIds.add(record.getLong("userid"));
            }
            if (userIds.size() != 0) {
                List userInfos = UserServiceHelper.getUserInfoByID(new ArrayList(userIds));
                userInfos.forEach(e -> userNumbers.add((String)e.get("number")));
            }
            if (userGroupIds.size() != 0) {
                Map usrGrpInfoMapByIds = TemplatePermQueryUtil.getUsrGrpObjById(new ArrayList(userGroupIds));
                usrGrpInfoMapByIds.forEach((key, value) -> userNumbers.add(value.getString("number")));
            }
            Long modelId = this.getModelId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            QFilter filter = new QFilter("id", "in", deleteTemplateIds).and("modelid", "=", (Object)modelId);
            DeleteServiceHelper.delete((String)"eb_templateuser_entity", (QFilter[])filter.toArray());
            this.getModel().deleteEntryRows("entity_allocate", selectedRows);
            this.writeLog(null, "unAllocation", new MultiLangEnumBridge("\u53cd\u5206\u914d", "TemplateUserPermPlugin_26", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bf9\u7528\u6237/\u7528\u6237\u7ec4\u201c%1$s\u201d\u53cd\u5206\u914d\u4f53\u7cfb\u201c%2$s\u201d\u7684\u6a21\u677f\u6743\u9650\u8bb0\u5f55", "TemplateUserPermPlugin_27", "epm-eb-formplugin"), new String[]{String.join((CharSequence)"\u3001", userNumbers), modelCacheHelper.getModelobj().getNumber()});
        }
    }

    private String getTemplateType(Map<String, Object> selectedNode, TreeNode rootNode) {
        String templateType = null;
        if (rootNode != null) {
            TreeNode node = rootNode.getTreeNode((String)selectedNode.get("id"), 20);
            HashMap map = (HashMap)node.getData();
            templateType = (String)map.get("templatetype");
        }
        return templateType;
    }

    private Map<Long, DynamicObject> getTemplate() {
        HashMap<Long, DynamicObject> templates = new HashMap<Long, DynamicObject>();
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"querytemplatecatalog", (String)"eb_templateentity", (String)"id, name, number", (QFilter[])new QFilter[]{filter}, null);
        DynamicObjectCollection query1 = QueryServiceHelper.query((String)"queryApplyTemplateCatalog", (String)"eb_applytemplate", (String)"id, name, number", (QFilter[])new QFilter[]{filter}, null);
        if (query != null) {
            for (DynamicObject object : query) {
                templates.put(object.getLong("id"), object);
            }
        }
        if (query1 != null) {
            for (DynamicObject object : query1) {
                templates.put(object.getLong("id"), object);
            }
        }
        return templates;
    }
}

