/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.olapdao.FloatRows;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportSortDiminfoDto;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class FixReportSortUtils {
    public static List<Map<String, Object>> getSubMenus() {
        LinkedList<Map<String, Object>> subMenus = new LinkedList<Map<String, Object>>();
        HashMap<String, String> subMenu1 = new HashMap<String, String>();
        subMenu1.put("text", ResManager.loadKDString((String)"\u5347\u5e8f", (String)"FixReportSortUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        subMenu1.put("name", "orderByAsc");
        HashMap<String, String> subMenu2 = new HashMap<String, String>();
        subMenu2.put("text", ResManager.loadKDString((String)"\u964d\u5e8f", (String)"FixReportSortUtils_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        subMenu2.put("name", "orderByDesc");
        HashMap<String, String> subMenu3 = new HashMap<String, String>();
        subMenu3.put("text", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f", (String)"FixReportSortUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        subMenu3.put("name", "orderByCustom");
        subMenus.add(subMenu1);
        subMenus.add(subMenu2);
        subMenus.add(subMenu3);
        return subMenus;
    }

    public static void buildMemberName(IModelCacheHelper modelCache, List<String> floatDims, List<FloatRows.FloatRow> floatRows1) {
        for (int j = 0; j < floatDims.size(); ++j) {
            String s = floatDims.get(j);
            for (FloatRows.FloatRow row : floatRows1) {
                Dimension dimension;
                if (row.getColItems().size() != floatDims.size() || (dimension = modelCache.getDimension(s)) == null) continue;
                Member structOfMember = dimension.getStructOfMember((String)row.getColItems().get(j));
                ArrayList<String> colItemNames = row.getColItemNames();
                if (colItemNames == null) {
                    colItemNames = new ArrayList<String>(row.getColItems().size());
                    row.setColItemNames(colItemNames);
                }
                if (structOfMember == null) continue;
                colItemNames.add(structOfMember.getName());
            }
        }
    }

    public static void sortByUserConfig(FloatRows floatRows, List<FixReportSortDiminfoDto> sortInfo) {
        List floatRows1 = floatRows.getFloatRows();
        if (CollectionUtils.isEmpty((Collection)floatRows1)) {
            return;
        }
        List floatDims = floatRows.getFloatDims();
        Comparator<FloatRows.FloatRow> comparator = null;
        for (FixReportSortDiminfoDto fixReportSortDiminfoDto : sortInfo) {
            Comparator nameComparator;
            int index = floatDims.indexOf(fixReportSortDiminfoDto.getDimnumber());
            String orderBy = fixReportSortDiminfoDto.getOrderBy();
            String sortOrder = fixReportSortDiminfoDto.getSortOrder();
            if (index >= 0 && "0".equals(orderBy)) {
                if ("0".equals(sortOrder)) {
                    if (comparator == null) {
                        comparator = Comparator.comparing(x -> (String)x.getColItems().get(index));
                        continue;
                    }
                    comparator = comparator.thenComparing(Comparator.comparing(x -> (String)x.getColItems().get(index)));
                    continue;
                }
                if (comparator == null) {
                    comparator = Comparator.comparing(x -> (String)x.getColItems().get(index), Comparator.reverseOrder());
                    continue;
                }
                comparator = comparator.thenComparing(Comparator.comparing(x -> (String)x.getColItems().get(index), Comparator.reverseOrder()));
                continue;
            }
            if (index < 0 || !"1".equals(orderBy)) continue;
            Collator instance = Collator.getInstance(Locale.CHINA);
            if ("0".equals(sortOrder)) {
                if (comparator == null) {
                    comparator = (o1, o2) -> instance.compare((String)o1.getColItemNames().get(index), (String)o2.getColItemNames().get(index));
                    continue;
                }
                nameComparator = (o1, o2) -> instance.compare((String)o1.getColItemNames().get(index), (String)o2.getColItemNames().get(index));
                comparator = comparator.thenComparing(nameComparator);
                continue;
            }
            if (comparator == null) {
                comparator = (o1, o2) -> instance.compare((String)o2.getColItemNames().get(index), (String)o1.getColItemNames().get(index));
                continue;
            }
            nameComparator = (o1, o2) -> instance.compare((String)o2.getColItemNames().get(index), (String)o1.getColItemNames().get(index));
            comparator = comparator.thenComparing(nameComparator);
        }
        if (comparator != null) {
            floatRows1.sort(comparator);
        }
    }

    public static void sortByMemberNumber(List<FloatRows.FloatRow> floatRows1) {
        Collections.sort(floatRows1, new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void sortTotalRowByTemplateConfig(FloatRows floatRows, List<FixReportSortDiminfoDto> sortInfo) {
        List floatRows1 = floatRows.getFloatRows();
        if (CollectionUtils.isEmpty((Collection)floatRows1)) {
            return;
        }
        List floatDims = floatRows.getFloatDims();
        Comparator<FloatRows.FloatRow> comparator = null;
        for (FixReportSortDiminfoDto fixReportSortDiminfoDto : sortInfo) {
            int index = floatDims.indexOf(fixReportSortDiminfoDto.getDimnumber());
            if (index < 0) continue;
            String levelCombo = fixReportSortDiminfoDto.getLevelCombo();
            if ("0".equals(levelCombo)) {
                if (comparator == null) {
                    comparator = Comparator.comparing(x -> x.getSortSeq()[index]);
                    continue;
                }
                comparator = comparator.thenComparing(Comparator.comparing(x -> x.getSortSeq()[index]));
                continue;
            }
            if (!"1".equals(levelCombo)) continue;
            if (comparator == null) {
                comparator = Comparator.comparing(x -> x.getSortSeq()[index], Comparator.reverseOrder());
                continue;
            }
            comparator = comparator.thenComparing(Comparator.comparing(x -> x.getSortSeq()[index], Comparator.reverseOrder()));
        }
        if (comparator != null) {
            floatRows1.sort(comparator);
        }
    }

    public static void sortByPageConfig(List<FloatRows> floatRows, Map<String, List<Map<String, Object>>> sortInfoMap, ITemplateModel templateModel, IModelCacheHelper modelCacheHelper, List<FloatRows> floatMemberInfo) {
        for (int i = 0; i < floatRows.size(); ++i) {
            FloatRows floatRow = floatRows.get(i);
            List floatDims = floatRow.getFloatDims();
            List floatRows1 = floatRow.getFloatRows();
            List<Map<String, Object>> sortDiminfoDtos = sortInfoMap.get(floatRow.getNumber());
            IMultiAreaSetting areaSetting = FixReportSortUtils.getAreaRange(floatRow, templateModel);
            int rangeType = 0;
            if (areaSetting != null) {
                MultiAreaSetting.FloatInfo floatInfo = (MultiAreaSetting.FloatInfo)areaSetting.getFloatInfos().get(floatRow.getSeq());
                rangeType = floatInfo.getRangeType();
            }
            if (CollectionUtils.isNotEmpty(sortDiminfoDtos) && rangeType == 0) {
                ArrayList<FixReportSortDiminfoDto> userSortMap = new ArrayList<FixReportSortDiminfoDto>(sortDiminfoDtos.size());
                block1: for (String floatDim : floatDims) {
                    boolean isBuildName = false;
                    for (Map<String, Object> sortDiminfoDto : sortDiminfoDtos) {
                        if (!String.valueOf(sortDiminfoDto.get("dimnumber")).equals(floatDim)) continue;
                        FixReportSortDiminfoDto temp = new FixReportSortDiminfoDto();
                        if ("1".equals(String.valueOf(sortDiminfoDto.get("orderBy"))) && !isBuildName) {
                            FixReportSortUtils.buildMemberName(modelCacheHelper, floatDims, floatRows1);
                            isBuildName = true;
                        }
                        temp.setOrderBy((String)sortDiminfoDto.get("orderBy"));
                        temp.setIndex(((Integer)sortDiminfoDto.get("index")).intValue());
                        temp.setSortOrder((String)sortDiminfoDto.get("sortOrder"));
                        temp.setDimnumber(floatDim);
                        temp.setCustom(((Boolean)sortDiminfoDto.get("custom")).booleanValue());
                        userSortMap.add(temp);
                        continue block1;
                    }
                }
                userSortMap.sort((a, b) -> Integer.compare(a.getIndex(), b.getIndex()));
                FixReportSortUtils.sortByUserConfig(floatRow, userSortMap);
                continue;
            }
            FixReportSortUtils.defaultSort(floatRows, floatMemberInfo, i, templateModel);
        }
    }

    public static void defaultSort(List<FloatRows> floatRows, List<FloatRows> floatMemberInfo, int i, ITemplateModel templateModel) {
        FloatRows floatRow = floatRows.get(i);
        IMultiAreaSetting areaSetting = FixReportSortUtils.getAreaRange(floatRow, templateModel);
        int rangeType = 0;
        if (areaSetting != null) {
            rangeType = ((MultiAreaSetting.FloatInfo)areaSetting.getFloatInfos().get(floatRow.getSeq())).getRangeType();
        }
        List<FixReportSortDiminfoDto> totalRowSortInfo = new ArrayList(16);
        if (areaSetting != null) {
            MultiAreaSetting.FloatInfo floatInfo = (MultiAreaSetting.FloatInfo)areaSetting.getFloatInfos().get(floatRow.getSeq());
            rangeType = floatInfo.getRangeType();
            totalRowSortInfo = floatInfo.getTotalRowSortInfos();
        }
        List floatRows1 = floatRow.getFloatRows();
        FixReportSortUtils.sortByMemberNumber(floatRows1);
        if (rangeType == 0) {
            if (floatMemberInfo != null && floatMemberInfo.size() > 0) {
                for (FloatRows rows : floatMemberInfo) {
                    if (!floatRow.equals((Object)rows)) continue;
                    List queryFloatRow = floatRow.getFloatRows();
                    List floatDims = floatRow.getFloatDims();
                    List recordFloatRow = rows.getFloatRows();
                    if (CollectionUtils.isEmpty((Collection)queryFloatRow) || CollectionUtils.isEmpty((Collection)recordFloatRow)) continue;
                    HashSet querySet = new HashSet(queryFloatRow);
                    Iterator iterator = recordFloatRow.iterator();
                    while (iterator.hasNext()) {
                        FloatRows.FloatRow next = (FloatRows.FloatRow)iterator.next();
                        if (next.getColItems().size() == floatDims.size()) {
                            if (querySet.contains(next)) continue;
                            iterator.remove();
                            continue;
                        }
                        iterator.remove();
                    }
                    querySet.clear();
                    HashSet recordSet = new HashSet(recordFloatRow);
                    ArrayList<FloatRows.FloatRow> notInRecord = new ArrayList<FloatRows.FloatRow>(16);
                    for (FloatRows.FloatRow next : queryFloatRow) {
                        if (recordSet.contains(next)) continue;
                        notInRecord.add(next);
                    }
                    recordSet.clear();
                    queryFloatRow.clear();
                    queryFloatRow.addAll(recordFloatRow);
                    queryFloatRow.addAll(notInRecord);
                }
            }
        } else if (CollectionUtils.isNotEmpty(totalRowSortInfo)) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getTemplateBaseInfo().getModelID());
            for (FixReportSortDiminfoDto fixReportSortDiminfoDto : totalRowSortInfo) {
                int index = floatRow.getFloatDims().indexOf(fixReportSortDiminfoDto.getDimnumber());
                Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (Long)templateModel.getTemplateBaseInfo().getDatasetID(), (String)fixReportSortDiminfoDto.getDimnumber(), (String)areaSetting.getAreaRangeStart());
                Member member = modelCacheHelper.getMember(fixReportSortDiminfoDto.getDimnumber(), viewId, fixReportSortDiminfoDto.getDimnumber());
                List<Member> allMembers = FixReportSortUtils.getAllMembers(member, fixReportSortDiminfoDto.getOrderBy(), fixReportSortDiminfoDto.getSortOrder(), fixReportSortDiminfoDto.getLevelCombo());
                List collect = allMembers.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                for (FloatRows.FloatRow row : floatRow.getFloatRows()) {
                    int index1;
                    row.getSortSeq()[index] = index1 = collect.indexOf(row.getColItems().get(index));
                }
            }
            FixReportSortUtils.sortTotalRowByTemplateConfig(floatRow, totalRowSortInfo);
        }
    }

    public static IMultiAreaSetting getAreaRange(FloatRows floatRow, ITemplateModel templateModel) {
        List areaRanges = templateModel.getAreaRanges();
        for (IMultiAreaSetting areaRange : areaRanges) {
            if (!areaRange.getAreaRange().startsWith(floatRow.getNumber() + ":")) continue;
            return areaRange;
        }
        return null;
    }

    public static List<Member> getAllMembers(Member member, @NotNull String orderBy, @NotNull String sortBy, @NotNull String levelCombo) {
        ArrayList<Member> members = new ArrayList<Member>();
        members.add(member);
        List children = member.getChildren();
        if (children != null && !children.isEmpty()) {
            List sortedList = children.stream().sorted((o1, o2) -> {
                if ("0".equals(orderBy)) {
                    if ("0".equals(levelCombo)) {
                        if ("0".equals(sortBy)) {
                            return o1.getNumber().compareToIgnoreCase(o2.getNumber());
                        }
                        return o2.getNumber().compareToIgnoreCase(o1.getNumber());
                    }
                    if ("0".equals(sortBy)) {
                        return o2.getNumber().compareToIgnoreCase(o1.getNumber());
                    }
                    return o1.getNumber().compareToIgnoreCase(o2.getNumber());
                }
                Collator instance = Collator.getInstance(RequestContext.get().getLang().getLocale());
                if (StringUtils.isEmpty((String)o1.getName()) || StringUtils.isEmpty((String)o2.getName())) {
                    return 0;
                }
                if ("0".equals(levelCombo)) {
                    if ("0".equals(sortBy)) {
                        return instance.compare(o1.getName(), o2.getName());
                    }
                    return instance.compare(o2.getName(), o1.getName());
                }
                if ("0".equals(sortBy)) {
                    return instance.compare(o2.getName(), o1.getName());
                }
                return instance.compare(o1.getName(), o2.getName());
            }).collect(Collectors.toList());
            for (Member temp : sortedList) {
                members.addAll(FixReportSortUtils.getAllMembers(temp, orderBy, sortBy, levelCombo));
            }
        }
        return members;
    }
}

