/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.decompose.BasedataEnum;
import kd.epm.eb.common.decompose.entity.AdjustParam;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.UserServiceHelper;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.utils.ReportHelper;
import org.apache.commons.collections.CollectionUtils;

public class ReportAdjustUtils {
    private static final Log LOGGER = LogFactory.getLog(ReportAdjustUtils.class);
    public static final String MODEL_COLLECTION_KEY = "modelCollection";
    public static final String SELECTED_DIMENSIONS_KEY = "selectedDimensions";
    private static final String ID = "id";

    public static boolean trylock(Long modelId, String lockKey, Consumer<String> addLockKey) {
        long lockTime;
        DLock dLock;
        boolean lock;
        String msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u6216\u5176\u4e0a\u7ea7\u3001\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u8c03\u6574\u3002", (String)"Fn_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        DLockInfo lockInfo = DLock.getLockInfo((String)lockKey);
        Long operator = UserUtils.getUserId();
        if (lockInfo != null && lockInfo.getDesc() != null) {
            String desc = lockInfo.getDesc();
            Long userId = Long.parseLong(desc);
            long createTime = lockInfo.getCreateTime().getTime();
            long nowTime = System.currentTimeMillis();
            long diff = nowTime - createTime;
            if (diff >= 1800000L || operator.equals(userId)) {
                DLock.forceClear((String[])new String[]{lockKey});
            } else if (IDUtils.isNotNull((Long)userId)) {
                String username = UserServiceHelper.getUsernameByUserid((Object)userId);
                msg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408\u6216\u5176\u4e0a\u7ea7\u3001\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408\u6b63\u5728\u88ab\u7528\u6237\uff1a%s\u8c03\u6574\u3002", (String)"Fn_18", (String)"epm-eb-formplugin", (Object[])new Object[]{username});
                throw new KDBizException(msg);
            }
        }
        if (!(lock = (dLock = DLock.createReentrant((String)lockKey, (String)operator.toString()).fastMode()).tryLock(lockTime = 3000L))) {
            lockInfo = DLock.getLockInfo((String)lockKey);
            if (lockInfo != null && lockInfo.getDesc() != null) {
                String desc = lockInfo.getDesc();
                Long userId = Long.parseLong(desc);
                if (operator.equals(userId)) {
                    return false;
                }
                String username = UserServiceHelper.getUsernameByUserid((Object)userId);
                msg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408\u6216\u5176\u4e0a\u7ea7\u3001\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408\u6b63\u5728\u88ab\u7528\u6237\uff1a%s\u8c03\u6574\u3002", (String)"Fn_18", (String)"epm-eb-formplugin", (Object[])new Object[]{username});
            }
            throw new KDBizException(msg);
        }
        addLockKey.accept(lockKey);
        return false;
    }

    public static void unlock(List<String> dLockList) {
        try {
            if (CollectionUtils.isEmpty(dLockList)) {
                return;
            }
            DLock.forceUnlock((String[])dLockList.toArray(new String[dLockList.size()]));
        }
        catch (Exception e) {
            LOGGER.error("reportview.CommonUtils.unlock error:", (Throwable)e);
        }
    }

    public static void unlock(Long modelId, List<Map<String, String>> selectedDimensions, List<Map<String, String>> dimViewList) {
        if (selectedDimensions == null || selectedDimensions.size() == 0 || CollectionUtils.isEmpty(dimViewList)) {
            return;
        }
        ArrayList<String> collect = new ArrayList<String>(16);
        for (int i = 0; i < selectedDimensions.size(); ++i) {
            Map<String, String> dimMemMap = selectedDimensions.get(i);
            Map<String, String> dimViewMap = dimViewList.get(i);
            String lockKey = AdjustServiceHelper.loadUpperDimenMd5LockKey((Long)modelId, dimMemMap, dimViewMap);
            collect.add(lockKey);
        }
        ReportAdjustUtils.unlock(collect);
    }

    public static boolean checkLock(Long modelId, Map<String, String> dimenData, Consumer<String> tip, Map<String, String> viewMap) {
        String lockKey = AdjustServiceHelper.loadUpperDimenMd5LockKey((Long)modelId, dimenData, viewMap);
        DLockInfo lockInfo = DLock.getLockInfo((String)lockKey);
        if (lockInfo != null && lockInfo.getDesc() != null) {
            String desc = lockInfo.getDesc();
            Long userId = Long.parseLong(desc);
            Long operator = UserUtils.getUserId();
            if (operator.equals(userId)) {
                return true;
            }
            String username = UserServiceHelper.getUsernameByUserid((Object)userId);
            tip.accept(ResManager.loadResFormat((String)"\u64cd\u4f5c\u4e2d\u6b62\uff0c\u5f53\u524d\u8c03\u6574\u754c\u9762\u88ab\u7528\u6237%1\u5360\u7528\uff0c\u8bf7\u5728\u8be5\u7528\u6237\u64cd\u4f5c\u5b8c\u6210\u540e\u91cd\u65b0\u8fdb\u5165\u8c03\u6574\u754c\u9762\u3002", (String)"CommonUtils_0", (String)"epm-eb-formplugin", (Object[])new Object[]{username}));
            return false;
        }
        tip.accept(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e2d\u6b62\uff0c\u5f53\u524d\u8c03\u6574\u64cd\u4f5c\u672a\u9501\u5b9a\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u9501\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u8c03\u6574\u754c\u9762\u3002", (String)"CommonUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return false;
    }

    public static void checkDimsRelation(IFormView view, IModelCacheHelper modelCache, Map<String, String> dimMemberMap, IEbSpreadManager ebSpreadManager) {
        boolean isInvalid;
        Long reportProcessId = ebSpreadManager.getReportProcessId();
        Long periodId = IDUtils.toLong((Object)view.getPageCache().get("CURRENT_PERIOD"));
        Map dimRelationMap = ReportHelper.getDimRelationMap((IFormView)view, (Long)reportProcessId);
        List dimRelationList = ReportHelper.getDimRelation((IFormView)view, (Long)reportProcessId);
        Long bizModelId = ebSpreadManager.getBusModelid();
        boolean bl = isInvalid = !DimensionRelationUtils.isValidRelation((IModelCacheHelper)modelCache, (long)bizModelId, (Long)periodId, dimMemberMap, (Map)dimRelationMap, (List)dimRelationList);
        if (isInvalid) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5ba1\u6279\u8c03\u6574\u3002\u5ba1\u6279\u8c03\u6574\u4ec5\u9650\u4e8e\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb\u5b9a\u4e49\u7684\u6709\u6548\u7ef4\u5ea6\u7ec4\u5408\u8303\u56f4\u5185\u3002", (String)"Fn_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static void canAdjust(IModelCacheHelper modelCacheHelper, Long bizModelId, Long datasetId, Map<String, String> dimViewMap, Map<String, String> dimenData, AdjustParam adjustParam, Long reportProcessId) {
        AdjustServiceHelper.checkMetric((IModelCacheHelper)modelCacheHelper, dimenData, (AdjustParam)adjustParam);
    }

    public static void dealAdjustParameter(FormShowParameter parameter, List<Map<String, String>> selectedDimensions, List<Map<String, String>> selectedDimViewMap, Map<String, List<String>> rowAndCol, String unit) {
        parameter.setCustomParam(SELECTED_DIMENSIONS_KEY, selectedDimensions);
        parameter.setCustomParam("dimViewMaps", selectedDimViewMap);
        parameter.setCustomParam("rowAndCol", rowAndCol);
        parameter.setCustomParam("unit", (Object)unit);
    }

    public static void loadDynamicDimenData(FormShowParameter parameter, Long modelId, ITemplateModel templateModel) {
        BgTemplate templateBaseInfo;
        LinkedHashMap<String, Long> notDimenMa = new LinkedHashMap<String, Long>();
        notDimenMa.put(BasedataEnum.MODEL.getKey(), modelId);
        if (templateModel != null && (templateBaseInfo = templateModel.getTemplateBaseInfo()) != null) {
            Long bizModelId = templateBaseInfo.getBizModel();
            notDimenMa.put(BasedataEnum.BUSINESSMODEL.getKey(), bizModelId);
            parameter.setCustomParam("bizModelId", (Object)bizModelId);
            Long datasetId = templateBaseInfo.getDatasetID();
            notDimenMa.put(BasedataEnum.DATASET.getKey(), datasetId);
            parameter.setCustomParam("datasetId", (Object)datasetId);
        }
        parameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        parameter.setCustomParam(MODEL_COLLECTION_KEY, notDimenMa);
    }

    public static boolean trylocks(Long modelId, List<Map<String, String>> selectedDimensions, List<Map<String, String>> dimViewList, Consumer<String> addLockKey) {
        if (selectedDimensions == null || selectedDimensions.size() == 0) {
            return false;
        }
        HashSet<String> collect = new HashSet<String>(16);
        for (int i = 0; i < selectedDimensions.size(); ++i) {
            Map<String, String> selectedDimension = selectedDimensions.get(i);
            Map<String, String> dimViewMap = dimViewList.get(i);
            String lockKey = AdjustServiceHelper.loadUpperDimenMd5LockKey((Long)modelId, selectedDimension, dimViewMap);
            collect.add(lockKey);
        }
        for (String lockKey : collect) {
            boolean trylock = ReportAdjustUtils.trylock(modelId, lockKey, addLockKey);
            if (!trylock) continue;
            selectedDimensions.clear();
            return true;
        }
        return false;
    }

    public static Map<String, String> getDimViewMap(Map<String, Long> dimemsionViews, Map<String, String> dimenData, IModelCacheHelper modelCacheHelper, Map<String, CellDimMember> rowpartitionDimMems, Map<String, CellDimMember> colpartitionDimMems) {
        HashMap<String, String> dimViewMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> stringEntry : dimenData.entrySet()) {
            Long viewId;
            String dim = stringEntry.getKey();
            String mem = stringEntry.getValue();
            CellDimMember cellDimMember = rowpartitionDimMems.get(dim);
            if (cellDimMember == null) {
                cellDimMember = colpartitionDimMems.get(dim);
            }
            if ((viewId = cellDimMember != null ? DimensionViewServiceHelper.getViewId(dimemsionViews, (String)dim, (String)cellDimMember.getPartition()) : dimemsionViews.get(dim)) == null) continue;
            dimViewMap.put(dim, String.valueOf(viewId));
        }
        return dimViewMap;
    }

    public static Map<String, String> getDimViewMapFix(Map<String, Long> dimemsionViews, Map<String, String> dimenData, IModelCacheHelper modelCacheHelper, String partition) {
        HashMap<String, String> dimViewMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> stringEntry : dimenData.entrySet()) {
            String dim = stringEntry.getKey();
            String mem = stringEntry.getValue();
            Long viewId = DimensionViewServiceHelper.getViewId(dimemsionViews, (String)dim, (String)partition);
            if (viewId == null) {
                viewId = dimemsionViews.get(dim);
            }
            if (viewId == null) continue;
            dimViewMap.put(dim, String.valueOf(viewId));
        }
        return dimViewMap;
    }
}

