/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versioncopy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.elasticsearch.OlapDataAuditService;
import kd.epm.eb.common.enums.CopyDataEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.versioncopy.VersionCopyApiUtils;
import kd.epm.eb.formplugin.versioncopy.VersionCopySchemeExecuteEntity;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class VersionCopyExecutePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private final String SELECT_FILEDS = "schemetype,schemename,effectivedate,expirationdate,businessmodel,srcversion,ent_srctrial,ent_srctrial.srctrial,tarversion,ent_tartrial,ent_tartrial.tartrial,datalock,schemenum,billstatus,model,ent_period,ent_period.period,ent_datatype,ent_datatype.datatype,orgview,dimmemberjson";
    private static final List<String> DEFAULT_DIM = Arrays.asList(SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber());
    private static final List<String> DEFAULT_FILTER_DIM = Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.AuditTrail.getNumber());
    private static final String[] TEXT_FILEDS = new String[]{"schemenum", "schemename", "srcversion", "srctrialname", "tarversion", "tartrialname"};
    private static final String SCHEME_NUM = "schemenum";
    private static final String SCHEME_NAME = "schemename";
    private static final String SRC_VERSION = "srcversion";
    private static final String SRC_VERSION_ID = "srcversionid";
    private static final String SRC_TRIAL_NAME = "srctrialname";
    private static final String TAR_VERSION = "tarversion";
    private static final String TAR_VERSION_ID = "tarversionid";
    private static final String TAR_TRIAL_NAME = "tartrialname";
    private static final String EXECUTE_BTN = "execute";
    private static final String BIZ_MODEL = "bizmodel";
    private static final String DATA_TYPE = "datatype";
    private static final String PERIOD = "period";
    private static final String SRC_TRIAL_ENT = "src_trial_ent";
    private static final String DIM_TRIAL_SRC = "dim_trial_src";
    private static final String TAR_TRIAL_ENT = "tar_trial_ent";
    private static final String DIM_TRIAL_TAR = "dim_trial_tar";
    private static final String DYNAMIC_DATA = "dynamicdata";
    private static final int HEART_RATE = 1200;
    private static final String FLAG_MSG = "existOlapData";
    private static final String PROGRESS_PAGE = "progresspage";
    private static final String CACHEKEY_PROGRESS = "cache_progress";
    private static final String FLEXPANNELAP = "flexpanelap";
    private static final String FLEXPANNELAP1 = "flexpanelap1";
    private static final String FLEXPANNELAP2 = "flexpanelap2";
    private static final String FLEXPANNELAP9 = "flexpanelap9";
    private static final String FLEXPANNELAP111 = "flexpanelap111";
    private static final String FLEXPANNELAP9112 = "flexpanelap112";
    private static final String BACK_RUN = "buttonap1";
    private static final String CLOSE = "close";
    private static final String PROGRESS = "progressbarap";
    private static final String RECORD_ID = "recordid";
    private static final String FAIL_MSG = "failmessage";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DIM = "dim";
    private static final String MEMBER = "member";
    private static final String DIMVIEW = "dimview";
    private static List<VersionCopyConditionDto> versionCopyConditionDtos = null;
    private static final Log log = LogFactory.getLog(VersionCopyExecutePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EXECUTE_BTN, BACK_RUN, CLOSE});
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        String memberMap = (String)this.getView().getFormShowParameter().getCustomParam("memberMap");
        if (StringUtils.isNotEmpty((String)memberMap)) {
            this.getPageCache().put("memberMap", memberMap);
            this.getPageCache().put("isValidation", "true");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANNELAP, FLEXPANNELAP1, FLEXPANNELAP2, FLEXPANNELAP9});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANNELAP111, FLEXPANNELAP9112});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BACK_RUN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CLOSE});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANNELAP, FLEXPANNELAP1, FLEXPANNELAP2, FLEXPANNELAP9});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANNELAP111, FLEXPANNELAP9112});
            this.setViewEnable(TEXT_FILEDS);
        }
    }

    public void afterCreateNewData(EventObject e) {
        QFilter qFilter = new QFilter("id", "in", this.getView().getFormShowParameter().getCustomParam("pkid"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_versioncopyscheme", (String)"model", (QFilter[])qFilter.toArray());
        String modelId = dynamicObject.getString("model");
        if (StringUtils.isEmpty((String)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"VersionCopyExecutePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("model", modelId);
        this.setDefauleValue();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (EXECUTE_BTN.equals(key)) {
            this.start();
        } else if (BACK_RUN.equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5173\u95ed\u5f53\u524d\u9875\u9762\u5728\u540e\u53f0\u8fd0\u884c\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"VersionCopyExecutePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_comfirm", (IFormPlugin)this));
        } else if (CLOSE.equals(key)) {
            this.getView().close();
        }
    }

    public void onProgress(ProgressEvent e) {
        String cacheProgress = this.getPageCache().get(CACHEKEY_PROGRESS);
        int progress = 0;
        if (StringUtils.isNotEmpty((String)cacheProgress)) {
            progress = Double.valueOf(cacheProgress).intValue();
        }
        if (progress >= 100) {
            progress = 100;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BACK_RUN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CLOSE});
            if (this.isFromValidation()) {
                String failMsg = this.getPageCache().get(FAIL_MSG);
                if (StringUtils.isNotEmpty((String)failMsg)) {
                    this.getView().returnDataToParent((Object)failMsg);
                } else {
                    this.getView().returnDataToParent((Object)"executesuccess");
                }
                this.getView().close();
            }
        }
        e.setProgress(progress);
        Label label = (Label)this.getControl("percent");
        label.setText(progress + "%");
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("copy_comfirm".equals(key) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            VersionCopySchemeExecuteEntity versionCopyEntity = this.createViewsionCopyObj();
            this.beginExecute(versionCopyEntity, true);
        } else if (this.isFromValidation()) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        Object list = null;
        switch (key) {
            case "progresspage": {
                this.getView().returnDataToParent(evt.getReturnData());
                this.getView().close();
            }
        }
    }

    private void beginExecute(VersionCopySchemeExecuteEntity versionCopyEntity, boolean hasData) {
        if (versionCopyEntity != null) {
            DynamicObject schemeDynamicObject = this.getSchemeDynamicObject();
            if (schemeDynamicObject != null) {
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7248\u672c\u590d\u5236", "VersionCopyExecutePlugin_23", "epm-eb-formplugin");
                if (this.isFromValidation()) {
                    opName = new MultiLangEnumBridge("\u7248\u672c\u6570\u636e\u751f\u6548", "VersionCopyExecutePlugin_24", "epm-eb-formplugin");
                }
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u6267\u884c\u65b9\u6848\u540d\u79f0\uff1a%1$S\u3002", "VersionCopyExecutePlugin_25", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), (String)"", (String)EXECUTE_BTN, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{schemeDynamicObject.getString(SCHEME_NAME)});
            }
            EBThreadPoolExecutor es = new EBThreadPoolExecutor(2, Runtime.getRuntime().availableProcessors() + 1, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue());
            String loginIP = RequestContext.getOrCreate().getLoginIP();
            es.execute(() -> {
                block5: {
                    try {
                        RequestContext.getOrCreate().setLoginIP(loginIP);
                        this.execute(versionCopyEntity, hasData);
                    }
                    catch (Exception e) {
                        DynamicObject[] load;
                        log.error("---beginExecutefail--", (Throwable)e);
                        String recordIdStr = this.getPageCache().get(RECORD_ID);
                        if (StringUtils.isNotEmpty((String)recordIdStr)) {
                            this.saveExecuteLog(ResManager.loadResFormat((String)"\u7248\u672c\u590d\u5236\u6267\u884c\u5931\u8d25\uff1a%1\u3002", (String)"VersionCopyExecutePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}), CopyDataEnum.FAILED.getIndex(), IDUtils.toLong((Object)recordIdStr), versionCopyEntity, true);
                        }
                        if (!StringUtils.isNotEmpty((String)recordIdStr) || (load = BusinessDataServiceHelper.load((String)"eb_copyrecord_entity", (String)"failmsg", (QFilter[])new QFilter[]{new QFilter(RECORD_ID, "=", (Object)IDUtils.toLong((Object)recordIdStr))}, (String)" createdate desc", (int)1)) == null || load.length <= 0) break block5;
                        DynamicObject dynamicObject = load[0];
                        String stackTraceStr = CommonServiceHelper.getStackTraceStr((Throwable)e);
                        if (stackTraceStr.length() > 2000) {
                            dynamicObject.set("failmsg", (Object)stackTraceStr.substring(0, 1997));
                        } else {
                            dynamicObject.set("failmsg", (Object)stackTraceStr);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    }
                }
            });
            es.shutdown();
            if (this.isFromValidation()) {
                this.updateProcess();
            } else {
                this.openCopyProgressPage();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u6570\u636e\u5f02\u5e38\u3002", (String)"VersionCopyExecutePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void openCopyProgressPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_copyprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u4e2d", (String)"VersionCopyExecutePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        DynamicObject version1 = (DynamicObject)this.getModel().getValue(SRC_VERSION_ID);
        DynamicObject version2 = (DynamicObject)this.getModel().getValue(TAR_VERSION_ID);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ResManager.loadResFormat((String)"\u6b63\u5728\u6267\u884c%1\u5230%2\u7684\u6570\u636e\u590d\u5236", (String)"VersionCopyExecutePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{version1.getString("name"), version2.getString("name")}));
        showParameter.setCustomParam("msg", (Object)stringBuilder.toString());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PROGRESS_PAGE);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    private void updateProcess() {
        DynamicObject version1 = (DynamicObject)this.getModel().getValue(SRC_VERSION_ID);
        DynamicObject version2 = (DynamicObject)this.getModel().getValue(TAR_VERSION_ID);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ResManager.loadResFormat((String)"\u6b63\u5728\u6267\u884c%1\u5230%2\u7684\u6570\u636e\u590d\u5236", (String)"VersionCopyExecutePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{version1.getString("name"), version2.getString("name")}));
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS);
        progressBar.start();
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"VersionCopyExecutePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("msg", (Object)stringBuilder.toString());
    }

    private void execute(VersionCopySchemeExecuteEntity versionCopyEntity, boolean hasData) throws InterruptedException, ExecutionException {
        log.info("\u7248\u672c\u590d\u5236\u5f00\u59cb");
        long start = System.currentTimeMillis();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (CollectionUtils.isEmpty((Collection)versionCopyEntity.getDateSetList())) {
            log.info("dataset is empty");
            return;
        }
        Double percentOfDataset = 100.0 / (double)versionCopyEntity.getDateSetList().size();
        Double percent = 0.0;
        Long recordId = this.saveExecuteLog("0%", CopyDataEnum.EXECUTING.getIndex(), 0L, versionCopyEntity, true);
        if (recordId == -1L) {
            return;
        }
        this.getPageCache().put(RECORD_ID, recordId.toString());
        if (hasData) {
            try {
                long startTime = System.currentTimeMillis();
                boolean isCancel = this.cleanOlapData(versionCopyEntity, modelCache);
                log.info("cleanOlapData time: " + (System.currentTimeMillis() - startTime));
                if (isCancel) {
                    return;
                }
            }
            catch (Exception e) {
                log.error("---cleanOlapDatafail--", (Throwable)e);
                this.saveExecuteLog(ResManager.loadResFormat((String)"\u6570\u636e\u6e05\u9664\u5931\u8d25\uff1a%1\u3002", (String)"VersionCopyExecutePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}), CopyDataEnum.FAILED.getIndex(), Long.parseLong(this.getPageCache().get("recordId")), versionCopyEntity, true);
                return;
            }
        }
        Map<Long, Map<String, Set<Member>>> datasetDimAndMem = this.getDatasetDimAndMem(modelCache, versionCopyEntity, true);
        int i = 0;
        log.info("\u5171" + versionCopyEntity.getDateSetList().size() + "\u4e2a\u6570\u636e\u96c6--");
        Boolean openfilteragg = (Boolean)CommonUtils.getMetaDataFieldDefaultValue((String)"eb_executeversioncopy", (String)"openfilteragg", () -> true);
        log.info("openfilteragg:{}", (Object)openfilteragg);
        Set metricNumbersHasAgg = openfilteragg != false ? MetricUtils.getMetricNumberHasAgg((Long)this.getModelId()) : new HashSet(16);
        for (int i1 = 0; i1 < versionCopyEntity.getDateSetList().size(); ++i1) {
            Long tarBusModelId;
            Long datasetId = ((Dataset)versionCopyEntity.getDateSetList().get(i)).getId();
            log.info("\u5f00\u59cb\u590d\u5236\u7b2c" + ++i + "\u4e2a\u6570\u636e\u96c6----datasetid" + datasetId);
            this.saveExecuteLog(ConvertUtils.formatDouble((double)percent, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), recordId, versionCopyEntity, true);
            Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
            Long busModelId = null;
            if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getBusinessModelId()) && !(busModelId = (Long)versionCopyEntity.getBusinessModelId().get(0)).equals(tarBusModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId))) {
                percent = percent + percentOfDataset;
                this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(percent));
                continue;
            }
            Map<String, Set<Member>> memberMap = datasetDimAndMem.get(datasetId);
            Set<Member> accounts = memberMap.get(SysDimensionEnum.Account.getNumber());
            if (CollectionUtils.isEmpty(accounts)) {
                percent = percent + percentOfDataset;
                this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(percent));
                continue;
            }
            HashMap metricMap = new HashMap(2);
            if (CollectionUtils.isNotEmpty(metricNumbersHasAgg)) {
                Set<Member> members = memberMap.get(SysDimensionEnum.Metric.getNumber());
                if (CollectionUtils.isEmpty(members)) {
                    members = new HashSet<Member>(16);
                    members.addAll(modelCache.getMember(SysDimensionEnum.Metric.getNumber(), Long.valueOf(0L), SysDimensionEnum.Metric.getNumber(), RangeEnum.ALL.getIndex()));
                }
                if (CollectionUtils.isNotEmpty(members)) {
                    Set detail;
                    Set noDetail = members.stream().filter(x -> metricNumbersHasAgg.contains(x.getNumber())).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(noDetail)) {
                        metricMap.put("hasAgg", noDetail);
                    }
                    if (CollectionUtils.isNotEmpty(detail = members.stream().filter(x -> !metricNumbersHasAgg.contains(x.getNumber())).collect(Collectors.toSet()))) {
                        metricMap.put("noAgg", detail);
                    }
                }
            }
            if (metricMap.isEmpty()) {
                percent = this.doExecute(versionCopyEntity, modelCache, percentOfDataset, percent, dataset, busModelId, memberMap, accounts, null);
            } else {
                double metricpercent = percentOfDataset / (double)metricMap.size();
                for (Map.Entry map : metricMap.entrySet()) {
                    if ("noAgg".equals(map.getKey())) {
                        log.info("noAgg");
                        percent = this.doExecute(versionCopyEntity, modelCache, metricpercent, percent, dataset, busModelId, memberMap, accounts, (Set)map.getValue());
                        continue;
                    }
                    log.info("haAgg");
                    HashMap<String, Set<Member>> tempMap = new HashMap<String, Set<Member>>(memberMap.size());
                    boolean isEmptyMember = false;
                    for (Map.Entry<String, Set<Member>> dimMemberMap : memberMap.entrySet()) {
                        if (dimMemberMap.getKey().equals(SysDimensionEnum.AuditTrail.getNumber())) {
                            tempMap.put(dimMemberMap.getKey(), dimMemberMap.getValue());
                            continue;
                        }
                        Set collect = dimMemberMap.getValue().stream().filter(x -> x.isLeaf()).collect(Collectors.toSet());
                        if (CollectionUtils.isEmpty(collect)) {
                            isEmptyMember = true;
                            break;
                        }
                        tempMap.put(dimMemberMap.getKey(), collect);
                    }
                    if (isEmptyMember) {
                        percent = percent + metricpercent;
                        continue;
                    }
                    percent = this.doExecute(versionCopyEntity, modelCache, metricpercent, percent, dataset, busModelId, tempMap, accounts, (Set)map.getValue());
                }
            }
            if (percent != null) continue;
            return;
        }
        percent = 100.0;
        this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(percent));
        this.saveExecuteLog(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u6210\u529f\u3002", (String)"VersionCopyExecutePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), CopyDataEnum.SUCCESS.getIndex(), recordId, versionCopyEntity, true);
        this.updateSchemeBillStatus();
        log.info("\u7248\u672c\u590d\u5236\u6210\u529f \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
    }

    @Nullable
    private Double doExecute(VersionCopySchemeExecuteEntity versionCopyEntity, IModelCacheHelper modelCache, Double percentOfDataset, Double percent, Dataset dataset, Long busModelId, Map<String, Set<Member>> memberMap, Set<Member> accounts, Set<Member> metricList) {
        Double accountPercent = percentOfDataset / (double)accounts.size();
        Integer accountmembernum = (Integer)CommonUtils.getMetaDataFieldDefaultValue((String)"eb_executeversioncopy", (String)"accountmembernum", () -> 50);
        if (accountmembernum > 100 || accountmembernum < 10) {
            accountmembernum = 50;
        }
        log.info("accountmembernum:{}", (Object)accountmembernum);
        List<Set<Member>> sp_accountlist = this.splitList(accounts, accountmembernum);
        Set<Member> entList = memberMap.get(SysDimensionEnum.Entity.getNumber());
        Integer orgmembernum = (Integer)CommonUtils.getMetaDataFieldDefaultValue((String)"eb_executeversioncopy", (String)"orgmembernum", () -> 10);
        if (orgmembernum > 100 || orgmembernum < 10) {
            orgmembernum = 10;
        }
        log.info("orgmembernum:{}", (Object)orgmembernum);
        List<Set<Member>> sp_entList = this.splitList(entList, orgmembernum);
        Double entPercent = accountPercent / (double)sp_entList.size();
        double tempprocess = 0.0;
        for (Set<Member> entspList : sp_entList) {
            for (Set<Member> accountlist : sp_accountlist) {
                this.saveExecuteLogDetail(Long.parseLong(this.getPageCache().get("recordId")), busModelId, versionCopyEntity, modelCache, dataset, entspList, accountlist, metricList);
                this.copyData(versionCopyEntity, modelCache, dataset, entspList, accountlist, memberMap, metricList);
                if (tempprocess == 0.0) {
                    tempprocess = percent;
                }
                percent = percent + entPercent;
                this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(percent));
                if (!(percent - tempprocess > 1.0)) continue;
                tempprocess = percent;
                Long cancelFlag = this.saveExecuteLog(ConvertUtils.formatDouble((double)percent, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), Long.parseLong(this.getPageCache().get("recordId")), versionCopyEntity, true);
                if (cancelFlag != -1L) continue;
                log.info("\u7528\u6237\u53d6\u6d88\u590d\u5236");
                return null;
            }
        }
        return percent;
    }

    private void copyData(VersionCopySchemeExecuteEntity versionCopyEntity, IModelCacheHelper modelCache, Dataset dataset, Set<Member> entList, Set<Member> accountlist, Map<String, Set<Member>> memberMap, Set<Member> metricList) {
        log.info("copydata begin");
        long start = System.currentTimeMillis();
        ArrayList<String> srcMember = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getTrial_1()) && versionCopyEntity.getTrial_1().size() == 1) {
            srcMember.add(SysDimensionEnum.AuditTrail.getNumber() + '@' + (String)versionCopyEntity.getTrial_1().get(0));
        }
        srcMember.add(SysDimensionEnum.Version.getNumber() + '@' + versionCopyEntity.getVersion_1());
        ArrayList<String> tarMember = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getTrial_2()) && versionCopyEntity.getTrial_2().size() == 1) {
            tarMember.add(SysDimensionEnum.AuditTrail.getNumber() + '@' + (String)versionCopyEntity.getTrial_2().get(0));
        }
        tarMember.add(SysDimensionEnum.Version.getNumber() + '@' + versionCopyEntity.getVersion_2());
        if (!srcMember.isEmpty() && !tarMember.isEmpty()) {
            ComputingCommandInfo computing = new ComputingCommandInfo();
            List<String> entityList = entList.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            computing.addFilter(SysDimensionEnum.Entity.getNumber(), entityList.toArray(new String[entityList.size()]));
            List<String> accountMemberList = accountlist.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            computing.addFilter(SysDimensionEnum.Account.getNumber(), accountMemberList.toArray(new String[accountMemberList.size()]));
            if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getTrial_2()) && versionCopyEntity.getTrial_2().size() > 1 && memberMap.get(SysDimensionEnum.AuditTrail.getNumber()) != null) {
                computing.addFilter(SysDimensionEnum.AuditTrail.getNumber(), versionCopyEntity.getTrial_2().toArray(new String[0]));
            }
            Set<Member> members = memberMap.get(SysDimensionEnum.DataType.getNumber());
            List<String> dataType = members.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            computing.addFilter(SysDimensionEnum.DataType.getNumber(), dataType.toArray(new String[0]));
            Set<Member> budgetPeriod = memberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            List<String> collect = budgetPeriod.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            computing.addFilter(SysDimensionEnum.BudgetPeriod.getNumber(), collect.toArray(new String[0]));
            boolean hasMetric = false;
            for (Map.Entry<String, Set<Member>> stringListEntry : memberMap.entrySet()) {
                if (DEFAULT_FILTER_DIM.contains(stringListEntry.getKey())) continue;
                if (SysDimensionEnum.Metric.getNumber().equals(stringListEntry.getKey())) {
                    hasMetric = true;
                }
                if (SysDimensionEnum.Metric.getNumber().equals(stringListEntry.getKey()) && CollectionUtils.isNotEmpty(metricList)) {
                    List<String> collect1 = metricList.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                    computing.addFilter(stringListEntry.getKey(), collect1.toArray(new String[0]));
                    continue;
                }
                Set<Member> value = stringListEntry.getValue();
                if (!CollectionUtils.isNotEmpty(value)) continue;
                List<String> collect1 = value.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                computing.addFilter(stringListEntry.getKey(), collect1.toArray(new String[0]));
            }
            if (!hasMetric && CollectionUtils.isNotEmpty(metricList)) {
                List<String> collect1 = metricList.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                computing.addFilter(SysDimensionEnum.Metric.getNumber(), collect1.toArray(new String[0]));
            }
            FelLambdaExpressionItem expr = new FelLambdaExpressionItem();
            expr.setExpressLeft(StringUtils.join(tarMember, (char)','));
            expr.setExpression("value('" + StringUtils.join(srcMember, (char)',') + "')");
            computing.getExpressionItems().add(expr);
            computing.setMainMeaName(FacTabFieldDefEnum.FIELD_MONEY.getField());
            computing.setMainDimName(SysDimensionEnum.DataType.getNumber());
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)computing, null);
            OlapTraceServiceHelper.setTraceOpInfo((String)((String)this.getModel().getValue(SCHEME_NUM)));
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.VersionCopy));
            OlapDataAuditService.getInstance().enhanceCommandWithAudit(modelCache.getModelobj().getNumber(), ShrekOlapUtils.getCubeNumber((Dataset)dataset), (CommandInfo)computing);
            log.info("copy-computing-data:" + computing.toString());
            OlapCommand command = new OlapCommand(ShrekOlapServiceHelper.getConnection((Model)modelCache.getModelobj(), (Dataset)dataset), (CommandInfo)computing);
            command.executeCompute();
            log.info("copyData end time:{}", (Object)(System.currentTimeMillis() - start));
        } else {
            log.warn("copy-computing-warring:" + JSONUtils.toString((Object)versionCopyEntity));
        }
    }

    private void updateSchemeBillStatus() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_versioncopyscheme");
        dynamicObject.set("id", this.getView().getFormShowParameter().getCustomParam("pkid"));
        dynamicObject.set("billstatus", (Object)1);
        dynamicObject.set("modifier", (Object)UserUtils.getUserId());
        dynamicObject.set("modifytime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private <T> List<Set<T>> splitList(Set<T> list, int L) {
        ArrayList<Set<T>> parts = new ArrayList<Set<T>>(16);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<T> temp = new ArrayList<T>(list);
            int N = temp.size();
            for (int i = 0; i < N; i += L) {
                parts.add(new HashSet(temp.subList(i, Math.min(N, i + L))));
            }
        }
        return parts;
    }

    private boolean cleanOlapData(VersionCopySchemeExecuteEntity versionCopyEntity, IModelCacheHelper modelCache) {
        Model model = modelCache.getModelobj();
        Map<Long, Map<String, Set<Member>>> datasetDimAndMem = this.getDatasetDimAndMem(modelCache, versionCopyEntity, false);
        List datasets = versionCopyEntity.getDateSetList();
        for (Dataset dataset : datasets) {
            Object dimension2;
            Set<Member> accountList;
            Map<String, Set<Member>> memberMap;
            Long tarBusModelId;
            List dimensionList = modelCache.getDimensionList(dataset.getId());
            Long busModelId = null;
            if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getBusinessModelId()) && !(busModelId = (Long)versionCopyEntity.getBusinessModelId().get(0)).equals(tarBusModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)dataset.getId())) || (memberMap = datasetDimAndMem.get(dataset.getId())).size() == 0 || CollectionUtils.isEmpty(accountList = memberMap.get(SysDimensionEnum.Account.getNumber()))) continue;
            ComputingCommandInfo computing = new ComputingCommandInfo();
            for (Object dimension2 : dimensionList) {
                Set<Member> members;
                if (SysDimensionEnum.DataType.getNumber().equals(dimension2.getNumber())) continue;
                if (SysDimensionEnum.Version.getNumber().equals(dimension2.getNumber())) {
                    members = memberMap.get(dimension2.getNumber());
                    String tarVersionNumber = versionCopyEntity.getVersion_2();
                    members.removeIf(e -> !e.getNumber().equals(tarVersionNumber));
                }
                if (SysDimensionEnum.AuditTrail.getNumber().equals(dimension2.getNumber()) && memberMap.get(dimension2.getNumber()) != null) {
                    members = memberMap.get(dimension2.getNumber());
                    List trial_2 = versionCopyEntity.getTrial_2();
                    for (String s : trial_2) {
                        members.removeIf(e -> !e.getNumber().equals(s));
                    }
                }
                if (!memberMap.containsKey(dimension2.getNumber()) || CollectionUtils.isEmpty(members = memberMap.get(dimension2.getNumber()))) continue;
                List<String> collect = members.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                computing.addFilter(dimension2.getNumber(), collect.toArray(new String[0]));
            }
            Set<Member> members = memberMap.get(SysDimensionEnum.DataType.getNumber());
            dimension2 = members.iterator();
            while (dimension2.hasNext()) {
                Member member = (Member)dimension2.next();
                FelLambdaExpressionItem expr = new FelLambdaExpressionItem();
                expr.setExpressLeft(SysDimensionEnum.DataType.getNumber() + '@' + member.getNumber());
                expr.setExpression("null");
                computing.getExpressionItems().add(expr);
            }
            computing.setMainMeaName(FacTabFieldDefEnum.FIELD_MONEY.getField());
            computing.setMainDimName(SysDimensionEnum.DataType.getNumber());
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)computing, null);
            log.info("versioncopy-clear-data:" + computing.toString());
            OlapCommand command = new OlapCommand(ShrekOlapServiceHelper.getConnection((Model)model, (Dataset)dataset), (CommandInfo)computing);
            command.executeCompute();
        }
        return false;
    }

    private String check(VersionCopySchemeExecuteEntity versionCopyEntity) {
        List versionCopyConditionDtoList = versionCopyEntity.getVersionCopyConditionDtoList();
        String version_1 = versionCopyEntity.getVersion_1();
        String version_2 = versionCopyEntity.getVersion_2();
        List trialList_1 = versionCopyEntity.getTrial_1();
        List trialList_2 = versionCopyEntity.getTrial_2();
        DynamicObject aimVersion = (DynamicObject)this.getModel().getValue(TAR_VERSION_ID);
        Long tarVersionId = aimVersion.getLong("id");
        List dataTypeCondition = new ArrayList(16);
        List periodCondition = new ArrayList(16);
        if (CollectionUtils.isNotEmpty((Collection)versionCopyConditionDtoList)) {
            Optional<VersionCopyConditionDto> periodFind;
            Optional<VersionCopyConditionDto> dataTypeFind = versionCopyConditionDtoList.stream().filter(x -> x.getDimNumber().equals(SysDimensionEnum.DataType.getNumber())).findFirst();
            if (dataTypeFind.isPresent()) {
                dataTypeCondition = dataTypeFind.get().getConditions();
            }
            if ((periodFind = versionCopyConditionDtoList.stream().filter(x -> x.getDimNumber().equals(SysDimensionEnum.BudgetPeriod.getNumber())).findFirst()).isPresent()) {
                periodCondition = periodFind.get().getConditions();
            }
        }
        if (CollectionUtils.isEmpty((Collection)versionCopyConditionDtoList) || CollectionUtils.isEmpty(dataTypeCondition) || CollectionUtils.isEmpty(periodCondition)) {
            return ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u53c2\u6570\u672a\u914d\u7f6e\u5b8c\u6574\u3002", (String)"VersionCopyExecutePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (trialList_1.size() != trialList_2.size()) {
            return ResManager.loadKDString((String)"\u7ebf\u7d22\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0d\u5339\u914d\u3002", (String)"VersionCopyExecutePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (version_2.equals(version_1)) {
            return ResManager.loadKDString((String)"\u6e90\u7248\u672c\u548c\u76ee\u6807\u7248\u672c\u4e0d\u5141\u8bb8\u76f8\u540c\u3002", (String)"VersionCopyExecutePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return this.checkOlapData(versionCopyEntity, tarVersionId);
    }

    private String checkOlapData(VersionCopySchemeExecuteEntity versionCopyEntity, Long tarVersionId) {
        long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List datasets = versionCopyEntity.getDateSetList();
        Map<Long, Map<String, Set<Member>>> datasetDimAndMem = this.getDatasetDimAndMem(modelCache, versionCopyEntity, false);
        int count = 0;
        HashSet<Member> entList = new HashSet(16);
        for (Dataset dataset : versionCopyEntity.getDateSetList()) {
            MembersKey membersKey;
            Map<String, Set<Member>> memberMap;
            Set<Member> accounts;
            Long tarBusModelId;
            if (count > 0) break;
            List dimensionList = modelCache.getDimensionList(dataset.getId());
            Long busModelId = null;
            if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getBusinessModelId()) && !(busModelId = (Long)versionCopyEntity.getBusinessModelId().get(0)).equals(tarBusModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)dataset.getId())) || CollectionUtils.isEmpty(accounts = (memberMap = datasetDimAndMem.get(dataset.getId())).get(SysDimensionEnum.Account.getNumber())) || CollectionUtils.isEmpty(entList = memberMap.get(SysDimensionEnum.Entity.getNumber())) || CollectionUtils.isEmpty(accounts) || (membersKey = this.getShrekOlapReader(modelCache, dataset, dimensionList, memberMap, accounts, entList)) == null) continue;
            ++count;
        }
        if (count == 0) {
            return "";
        }
        return FLAG_MSG;
    }

    private MembersKey getShrekOlapReader(IModelCacheHelper modelCache, Dataset dataset, List<Dimension> dimensionList, Map<String, Set<Member>> memberMap, Set<Member> accountlist, Set<Member> memNumbers) {
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        List<String> accountMemberList = accountlist.stream().map(x -> x.getNumber()).collect(Collectors.toList());
        queryInfo.addFilter(SysDimensionEnum.Account.getNumber(), accountMemberList.toArray(new String[accountMemberList.size()]));
        List<String> entityList = memNumbers.stream().map(x -> x.getNumber()).collect(Collectors.toList());
        queryInfo.addFilter(SysDimensionEnum.Entity.getNumber(), entityList.toArray(new String[entityList.size()]));
        for (Dimension dimension : dimensionList) {
            if (memberMap.get(dimension.getNumber()) == null) continue;
            String dimNumber = dimension.getNumber();
            queryInfo.addDims(new String[]{dimension.getNumber()});
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) || SysDimensionEnum.Entity.getNumber().equals(dimNumber)) continue;
            Set<Member> membersNumber = memberMap.get(dimension.getNumber());
            if (!CollectionUtils.isEmpty(membersNumber)) {
                List<String> collect = membersNumber.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                queryInfo.addFilter(dimension.getNumber(), collect.toArray(new String[collect.size()]));
                continue;
            }
            log.info("dimNumer members empty");
        }
        log.info("queryInfoFilter:" + queryInfo.getFilter().toString());
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        queryInfo.setDimensions(Arrays.asList(modelCache.getDimensionNums(dataset.getId())));
        return ShrekOlapServiceHelper.queryOne((Model)modelCache.getModelobj(), (Dataset)dataset, (SelectCommandInfo)queryInfo);
    }

    private Map<Long, Map<String, Set<Member>>> getDatasetDimAndMem(IModelCacheHelper modelCache, VersionCopySchemeExecuteEntity versionCopyEntity, boolean isSrcVision) {
        if (this.isFromValidation()) {
            List<Member> entityNumber = this.getEntityNumber();
            return VersionCopyApiUtils.getDatasetDimAndMem((IModelCacheHelper)modelCache, (VersionCopySchemeExecuteEntity)versionCopyEntity, (boolean)isSrcVision, (boolean)this.isFromValidation(), (Set)(CollectionUtils.isEmpty(entityNumber) ? new HashSet(16) : Sets.newHashSet(entityNumber)));
        }
        return VersionCopyApiUtils.getDatasetDimAndMem((IModelCacheHelper)modelCache, (VersionCopySchemeExecuteEntity)versionCopyEntity, (boolean)isSrcVision, (boolean)this.isFromValidation(), null);
    }

    private boolean checkVersionCopyRunning(VersionCopySchemeExecuteEntity versionCopyEntity) {
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"query_top1", (String)"eb_versioncopyrecord", (String)"id,lasttime,status", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())}, (String)"executetime desc", (int)1);
        if (ds != null && ds.size() > 0) {
            DynamicObject d = (DynamicObject)ds.get(0);
            if (CopyDataEnum.EXECUTING.getIndex().equals(d.getString("status"))) {
                Date now = TimeServiceHelper.now();
                if (d.getDate("lasttime") == null) {
                    Long id = d.getLong("id");
                    this.saveExecuteLog(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u6267\u884c\u5931\u8d25\uff0c\u6700\u540e\u6267\u884c\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"VersionCopyExecutePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), CopyDataEnum.FAILED.getIndex(), id, versionCopyEntity, true);
                    return false;
                }
                Date begin = d.getDate("lasttime");
                long second = (now.getTime() - begin.getTime()) / 1000L;
                if (second >= 1200L) {
                    Long id = d.getLong("id");
                    this.saveExecuteLog(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u6267\u884c\u5931\u8d25\uff0c\u6267\u884c\u8d85\u65f6\u3002", (String)"VersionCopyExecutePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), CopyDataEnum.FAILED.getIndex(), id, versionCopyEntity, true);
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private void saveExecuteLogDetail(long id, Long bizModel, VersionCopySchemeExecuteEntity versionCopyEntity, IModelCacheHelper modelCache, Dataset dataset, Set<Member> entList, Set<Member> accountlist, Set<Member> metricList) {
        DynamicObject[] collect;
        if (IDUtils.isNull((long)id)) {
            log.error("saveExecuteLogDetail id is null ");
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_copyrecord_entity");
        dynamicObject.set("dataset", (Object)dataset.getId());
        dynamicObject.set("model", (Object)this.getModelId());
        dynamicObject.set(BIZ_MODEL, (Object)bizModel);
        dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
        dynamicObject.set("creater", (Object)UserUtils.getUserId());
        dynamicObject.set(RECORD_ID, (Object)id);
        ArrayList<String> entityNames = new ArrayList<String>(entList.size());
        for (Member member : entList) {
            entityNames.add(member.getNumber() + " " + member.getName());
        }
        dynamicObject.set("entity", (Object)this.getLimitStr(entityNames, 2000));
        ArrayList<String> accountNames = new ArrayList<String>(accountlist.size());
        for (Member member : accountlist) {
            accountNames.add(member.getNumber() + " " + member.getName());
        }
        dynamicObject.set("account", (Object)this.getLimitStr(accountNames, 2000));
        ArrayList arrayList = new ArrayList(16);
        if (CollectionUtils.isNotEmpty(arrayList)) {
            collect = new ArrayList(16);
            if (CollectionUtils.isNotEmpty(metricList)) {
                Dimension dimension = modelCache.getDimension(SysDimensionEnum.Metric.getNumber());
                VersionCopyConditionDto copyConditionDto = new VersionCopyConditionDto();
                copyConditionDto.setViewId(Long.valueOf(0L));
                copyConditionDto.setDimNumber(SysDimensionEnum.Metric.getNumber());
                copyConditionDto.setDimId(dimension.getId());
                ArrayList<MemberCondition> memberConditions = new ArrayList<MemberCondition>(16);
                copyConditionDto.setConditions(memberConditions);
                collect.add(copyConditionDto);
                for (Member member : metricList) {
                    memberConditions.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
                }
            }
            if (CollectionUtils.isNotEmpty(collect)) {
                dynamicObject.set("dimmemberjson", (Object)kd.bos.login.actions.SerializationUtils.toJsonString((Object)collect));
            }
        }
        try {
            collect = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Exception e) {
            log.error("saveExecuteLogDetail error:{}", (Object)CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
    }

    private Long saveExecuteLog(String msg, String status, long id, VersionCopySchemeExecuteEntity versionCopyEntity, boolean isUpdateLastTime) {
        if (CopyDataEnum.FAILED.getIndex().equals(status)) {
            this.getPageCache().put(FAIL_MSG, msg);
            this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(100.0f));
        }
        DynamicObject record = null;
        if (id != 0L) {
            record = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_versioncopyrecord");
            boolean isCancel = record.getBoolean("iscancel");
            if (isCancel) {
                status = CopyDataEnum.CANCEL.getIndex();
                msg = ResManager.loadKDString((String)"\u7528\u6237\u53d6\u6d88\u6267\u884c", (String)"VersionCopyExecutePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getPageCache().put(FAIL_MSG, msg);
                this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(100.0f));
            }
        } else {
            DynamicObject dynamicObject;
            LinkedHashSet<Member> members;
            record = BusinessDataServiceHelper.newDynamicObject((String)"eb_versioncopyrecord");
            Long userId = UserUtils.getUserId();
            record.set("executor", (Object)userId);
            record.set("executetime", (Object)TimeServiceHelper.now());
            record.set("model", (Object)this.getModelId());
            record.set("iscancel", (Object)false);
            String version1_id = this.getPageCache().get("version1_id");
            String version2_id = this.getPageCache().get("version2_id");
            if (StringUtils.isNotEmpty((String)version1_id) && StringUtils.isNotEmpty((String)version2_id)) {
                record.set(SRC_VERSION, (Object)version1_id);
                record.set(TAR_VERSION, (Object)version2_id);
            }
            ArrayList<String> datatypeList = new ArrayList<String>(16);
            ArrayList<String> periodList = new ArrayList<String>(16);
            DynamicObjectCollection ent_datatype = record.getDynamicObjectCollection("ent_datatype");
            ent_datatype.clear();
            this.fillDatatypeEntity(ent_datatype, datatypeList, versionCopyEntity);
            record.set("ent_datatype", (Object)ent_datatype);
            DynamicObjectCollection ent_period = record.getDynamicObjectCollection("ent_period");
            ent_period.clear();
            this.fillPeriodEntity(ent_period, periodList, versionCopyEntity);
            record.set("ent_period", (Object)ent_period);
            DynamicObjectCollection ent_trial = record.getDynamicObjectCollection("ent_trial");
            ent_trial.clear();
            this.fillTrialEntity(ent_trial);
            record.set("ent_trial", (Object)ent_trial);
            record.set("periodtext", (Object)this.getLimitStr(periodList, 1000));
            record.set("datatypetext", (Object)this.getLimitStr(datatypeList, 1000));
            record.set("executeparam", (Object)this.createParamString(versionCopyEntity));
            record.set("orgview", (Object)versionCopyEntity.getOrgView());
            record.set("dimmemberjson", (Object)kd.bos.login.actions.SerializationUtils.toJsonString((Object)versionCopyEntity.getVersionCopyConditionDtoList()));
            if (this.isFromValidation() && (members = this.getMemberList()) != null && members.size() > 0) {
                record.set("entitytext", (Object)((Member)members.iterator().next()).getName());
                record.set("entitynum", (Object)((Member)members.iterator().next()).getNumber());
                DynamicObjectCollection ent_entity = record.getDynamicObjectCollection("ent_entity");
                ent_entity.clear();
                this.fillEntityEntity(ent_entity, members);
                record.set("ent_entity", (Object)ent_entity);
            }
            if ((dynamicObject = this.getSchemeDynamicObject()) != null) {
                record.set(SCHEME_NUM, (Object)dynamicObject.getString(SCHEME_NUM));
                record.set(SCHEME_NAME, (Object)dynamicObject.getString(SCHEME_NAME));
                record.set("businessmodel", (Object)dynamicObject.getDynamicObject("businessmodel").getLong("id"));
                record.set("schemetype", (Object)dynamicObject.getString("schemetype"));
            }
        }
        record.set("status", (Object)status);
        record.set("msg", (Object)msg);
        if (isUpdateLastTime) {
            record.set("lasttime", (Object)TimeServiceHelper.now());
        }
        try {
            DynamicObject[] data = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
            if (data != null && data.length > 0) {
                id = data[0].getLong("id");
                this.getPageCache().put("recordId", String.valueOf(id));
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5fc3\u8df3\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            throw e;
        }
        return id;
    }

    private String getLimitStr(List<String> list, Integer limit) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String str = String.join((CharSequence)",", list);
        if (limit == null || limit < 3) {
            log.warn("limit is :{}", (Object)limit);
            return str;
        }
        if (str.length() > limit) {
            String substring = str.substring(0, limit - 3);
            return substring + ResManager.loadKDString((String)"...", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return str;
    }

    private void fillDatatypeEntity(DynamicObjectCollection ent_datatype, List<String> nameList, VersionCopySchemeExecuteEntity versionCopyEntity) {
        Optional<VersionCopyConditionDto> first = versionCopyEntity.getVersionCopyConditionDtoList().stream().filter(x -> x.getDimNumber().equals(SysDimensionEnum.DataType.getNumber())).findFirst();
        if (first.isPresent()) {
            List conditions = first.get().getConditions();
            if (CollectionUtils.isEmpty((Collection)conditions)) {
                return;
            }
            for (MemberCondition memberCondition : conditions) {
                nameList.add(memberCondition.getName());
                DynamicObject row = new DynamicObject(ent_datatype.getDynamicObjectType());
                row.set(DATA_TYPE, (Object)IDUtils.toLong((Object)memberCondition.getId()));
                ent_datatype.add((Object)row);
            }
        }
    }

    private void fillPeriodEntity(DynamicObjectCollection ent_period, List<String> nameList, VersionCopySchemeExecuteEntity versionCopyEntity) {
        Optional<VersionCopyConditionDto> first = versionCopyEntity.getVersionCopyConditionDtoList().stream().filter(x -> x.getDimNumber().equals(SysDimensionEnum.BudgetPeriod.getNumber())).findFirst();
        if (first.isPresent()) {
            List conditions = first.get().getConditions();
            if (CollectionUtils.isEmpty((Collection)conditions)) {
                return;
            }
            for (MemberCondition memberCondition : conditions) {
                nameList.add(memberCondition.getName());
                DynamicObject row = new DynamicObject(ent_period.getDynamicObjectType());
                row.set(PERIOD, (Object)IDUtils.toLong((Object)memberCondition.getId()));
                ent_period.add((Object)row);
            }
        }
    }

    private void fillTrialEntity(DynamicObjectCollection ent_trial) {
        DynamicObject row;
        DynamicObjectCollection srcTrials = this.getModel().getEntryEntity(SRC_TRIAL_ENT);
        DynamicObjectCollection tarTrials = this.getModel().getEntryEntity(TAR_TRIAL_ENT);
        if (CollectionUtils.isEmpty((Collection)srcTrials) || CollectionUtils.isEmpty((Collection)tarTrials)) {
            return;
        }
        for (DynamicObject object : srcTrials) {
            row = new DynamicObject(ent_trial.getDynamicObjectType());
            row.set("trial", (Object)object.getLong("id"));
            row.set("source", (Object)"0");
            ent_trial.add((Object)row);
        }
        for (DynamicObject object : tarTrials) {
            row = new DynamicObject(ent_trial.getDynamicObjectType());
            row.set("trial", (Object)object.getLong("id"));
            row.set("source", (Object)"1");
            ent_trial.add((Object)row);
        }
    }

    private void fillEntityEntity(DynamicObjectCollection ent_entity, Set<Member> members) {
        for (Member member : members) {
            DynamicObject row = new DynamicObject(ent_entity.getDynamicObjectType());
            row.set("entity", (Object)member.getId());
            ent_entity.add((Object)row);
        }
    }

    private String createParamString(VersionCopySchemeExecuteEntity versionCopyEntity) {
        StringBuilder s = new StringBuilder();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)versionCopyEntity.getModelId());
        Member srcVersion = orCreate.getMember(SysDimensionEnum.Version.getNumber(), Long.valueOf(0L), versionCopyEntity.getVersion_1());
        Member tarVersion = orCreate.getMember(SysDimensionEnum.Version.getNumber(), Long.valueOf(0L), versionCopyEntity.getVersion_2());
        String version_1 = srcVersion != null ? srcVersion.getName() : versionCopyEntity.getVersionName_1();
        String version_2 = tarVersion != null ? tarVersion.getName() : versionCopyEntity.getVersionName_2();
        List trial_1 = versionCopyEntity.getTrialName_1();
        List trial_2 = versionCopyEntity.getTrialName_2();
        s.append(ResManager.loadResFormat((String)"\u6e90\u7248\u672c:[%1],\u76ee\u6807\u7248\u672c:[%2],\u6e90\u7ebf\u7d22:[%3],\u76ee\u6807\u7ebf\u7d22:[%4]", (String)"VersionCopyExecutePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{version_1, version_2, String.join((CharSequence)",", trial_1), String.join((CharSequence)",", trial_2)}));
        String str = s.toString();
        return str.length() > 2000 ? str.substring(0, 2000) : str;
    }

    private VersionCopySchemeExecuteEntity createViewsionCopyObj() {
        ArrayList<String> trail_1 = new ArrayList<String>(16);
        ArrayList<String> trail_2 = new ArrayList<String>(16);
        ArrayList<String> trailName_1 = new ArrayList<String>(16);
        ArrayList<String> trailName_2 = new ArrayList<String>(16);
        ArrayList<Long> businessModel = new ArrayList<Long>(16);
        DynamicObject dynamicObject = this.getSchemeDynamicObject();
        VersionCopySchemeExecuteEntity versionCopyEntity = null;
        if (dynamicObject != null) {
            IModelCacheHelper orCreate;
            Map viewsByBusModel;
            List<DynamicObject> bizModelList = this.getObjectListByIds(BIZ_MODEL, String.valueOf(dynamicObject.getDynamicObject("businessmodel").getLong("id")));
            for (DynamicObject obj : bizModelList) {
                businessModel.add(obj.getLong("id"));
            }
            List<VersionCopyConditionDto> versionCopyConditionDtos = new ArrayList(16);
            String dimmemberjson = dynamicObject.getString("dimmemberjson");
            if (StringUtils.isNotEmpty((String)dimmemberjson)) {
                versionCopyConditionDtos = SerializationUtils.fromJsonStringToList((String)dimmemberjson, VersionCopyConditionDto.class);
            } else {
                IModelCacheHelper orCreate2 = ModelCacheContext.getOrCreate((Long)this.getModelId());
                for (String dimNumber : DEFAULT_DIM) {
                    String idKey;
                    Dimension dimension = orCreate2.getDimension(dimNumber);
                    String entityName = SysDimensionEnum.DataType.getNumber().equals(dimNumber) ? "ent_datatype" : "ent_period";
                    String string = idKey = SysDimensionEnum.DataType.getNumber().equals(dimNumber) ? "datatype.id" : "period.id";
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entityName);
                    if (dynamicObjectCollection.isEmpty()) continue;
                    VersionCopyConditionDto versionCopyConditionDto = new VersionCopyConditionDto();
                    versionCopyConditionDto.setDimId(dimension.getId());
                    versionCopyConditionDto.setViewId(Long.valueOf(0L));
                    versionCopyConditionDto.setDimNumber(dimNumber);
                    ArrayList<MemberCondition> conditions = new ArrayList<MemberCondition>(16);
                    ArrayList<String> names = new ArrayList<String>(16);
                    for (DynamicObject object : dynamicObjectCollection) {
                        Member member = orCreate2.getMember(dimNumber, null, Long.valueOf(object.getLong(idKey)));
                        if (member == null) continue;
                        conditions.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
                        names.add(member.getName() + RangeEnum.ONLY.getName());
                    }
                    versionCopyConditionDto.setConditions(conditions);
                    versionCopyConditionDtos.add(versionCopyConditionDto);
                }
            }
            DynamicObjectCollection trails_1 = this.getModel().getEntryEntity(SRC_TRIAL_ENT);
            for (Object trail : trails_1) {
                trail_1.add(trail.getString("dim_trial_src.number"));
                trailName_1.add(trail.getString("dim_trial_src.name"));
            }
            DynamicObjectCollection trails_2 = this.getModel().getEntryEntity(TAR_TRIAL_ENT);
            for (DynamicObject trail : trails_2) {
                trail_2.add(trail.getString("dim_trial_tar.number"));
                trailName_2.add(trail.getString("dim_trial_tar.name"));
            }
            String version_1 = (String)this.getValue(SRC_VERSION_ID, "number");
            String version_2 = (String)this.getValue(TAR_VERSION_ID, "number");
            OrmLocaleValue name_1 = (OrmLocaleValue)this.getValue(SRC_VERSION_ID, "name");
            OrmLocaleValue name_2 = (OrmLocaleValue)this.getValue(TAR_VERSION_ID, "name");
            String versionName_1 = name_1.getLocaleValue();
            String versionName_2 = name_2.getLocaleValue();
            boolean isLeaf = false;
            if (trails_1.size() > 1) {
                isLeaf = true;
            } else if (trails_1.size() == 1) {
                DynamicObject srcTrialObj = (DynamicObject)trails_1.get(0);
                isLeaf = srcTrialObj.getDynamicObject(DIM_TRIAL_SRC).getBoolean("isleaf");
            }
            DynamicObject orgViewDyn = (DynamicObject)dynamicObject.get("orgview");
            Long viewId = 0L;
            if (orgViewDyn != null) {
                viewId = orgViewDyn.getLong("id");
            }
            if (viewId == 0L && (viewsByBusModel = (orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId())).getViewsByBusModel(Long.valueOf(dynamicObject.getDynamicObject("businessmodel").getLong("id")))) != null) {
                viewId = viewsByBusModel.getOrDefault(SysDimensionEnum.Entity.getNumber(), 0L);
            }
            versionCopyEntity = new VersionCopySchemeExecuteEntity(businessModel, version_1, version_2, trail_1, trail_2, versionCopyConditionDtos, viewId, isLeaf);
            versionCopyEntity.setVersionName_1(versionName_1);
            versionCopyEntity.setVersionName_2(versionName_2);
            versionCopyEntity.setTrialName_1(trailName_1);
            versionCopyEntity.setTrialName_2(trailName_2);
            versionCopyEntity.setVersion_1_id((Long)this.getValue(SRC_VERSION_ID, "id"));
            versionCopyEntity.setVersion_2_id((Long)this.getValue(TAR_VERSION_ID, "id"));
            DynamicObject versionObj1 = (DynamicObject)this.getModel().getValue(SRC_VERSION_ID);
            String version_1_id = versionObj1.getString("id");
            this.getPageCache().put("version1_id", version_1_id);
            DynamicObject versionObj2 = (DynamicObject)this.getModel().getValue(TAR_VERSION_ID);
            String version_2_id = versionObj2.getString("id");
            this.getPageCache().put("version2_id", version_2_id);
            long modelId = dynamicObject.getLong("model.id");
            versionCopyEntity.setModelId(Long.valueOf(modelId));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List dataSetIdByBusModelIds = DatasetServiceHelper.getDataSetIdByBusModelIds(Collections.singleton(dynamicObject.getDynamicObject("businessmodel").getLong("id")));
            List datasets = Dataset.of((DynamicObjectCollection)DatasetServiceHelper.loadDatasets((Long[])dataSetIdByBusModelIds.toArray(new Long[0])));
            versionCopyEntity.setDateSetList(datasets);
        }
        return versionCopyEntity;
    }

    private List<DynamicObject> getObjectListByIds(String propertyName, String ids) {
        String[] split = ids.split(",");
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(split.length);
        for (String s : split) {
            this.getModel().setValue(propertyName, (Object)s);
            DynamicObject value = (DynamicObject)this.getModel().getValue(propertyName);
            dynamicObjects.add(value);
        }
        return dynamicObjects;
    }

    private void setViewEnable(String[] textFields) {
        if (textFields.length > 0) {
            for (String textField : textFields) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{textField});
            }
        }
    }

    private void setDefauleValue() {
        DynamicObject dynamicObject = this.getSchemeDynamicObject();
        if (dynamicObject != null) {
            DynamicObject tarVersion;
            this.getModel().setValue(SCHEME_NAME, (Object)dynamicObject.getString(SCHEME_NAME));
            this.getModel().setValue(SCHEME_NUM, (Object)dynamicObject.getString(SCHEME_NUM));
            this.getModel().setValue(SRC_VERSION_ID, (Object)dynamicObject.getDynamicObject(SRC_VERSION).getLong("id"));
            List ent_srctrial = dynamicObject.getDynamicObjectCollection("ent_srctrial").stream().map(x -> x.getString("srctrial.name")).collect(Collectors.toList());
            this.getModel().setValue(SRC_TRIAL_NAME, (Object)String.join((CharSequence)",", ent_srctrial));
            this.getModel().setValue(TAR_VERSION_ID, (Object)dynamicObject.getDynamicObject(TAR_VERSION).getLong("id"));
            List ent_tartrial = dynamicObject.getDynamicObjectCollection("ent_tartrial").stream().map(x -> x.getString("tartrial.name")).collect(Collectors.toList());
            this.getModel().setValue(TAR_TRIAL_NAME, (Object)String.join((CharSequence)",", ent_tartrial));
            DynamicObject srcVersion = (DynamicObject)this.getModel().getValue(SRC_VERSION_ID);
            if (srcVersion != null) {
                this.getModel().setValue(SRC_VERSION, (Object)srcVersion.getString("name"));
            }
            if ((tarVersion = (DynamicObject)this.getModel().getValue(TAR_VERSION_ID)) != null) {
                this.getModel().setValue(TAR_VERSION, (Object)tarVersion.getString("name"));
            }
            this.setTrail(dynamicObject, "ent_srctrial", SRC_TRIAL_ENT, DIM_TRIAL_SRC, "srctrial.id");
            this.setTrail(dynamicObject, "ent_tartrial", TAR_TRIAL_ENT, DIM_TRIAL_TAR, "tartrial.id");
            String dimmemberjson = dynamicObject.getString("dimmemberjson");
            IDataModel dataModel = this.getModel();
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            int index = 0;
            if (StringUtils.isNotEmpty((String)dimmemberjson)) {
                List versionCopyConditionDtos = SerializationUtils.fromJsonStringToList((String)dimmemberjson, VersionCopyConditionDto.class);
                if (CollectionUtils.isNotEmpty((Collection)versionCopyConditionDtos)) {
                    dataModel.batchCreateNewEntryRow(ENTRYENTITY, versionCopyConditionDtos.size());
                    for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                        Dimension dimension = modelCacheHelper.getDimension(versionCopyConditionDto.getDimNumber());
                        if (dimension == null) continue;
                        this.getModel().setValue(DIM, (Object)dimension.getId(), index);
                        List conditions = versionCopyConditionDto.getConditions();
                        ArrayList<String> names = new ArrayList<String>(16);
                        Long viewId = versionCopyConditionDto.getViewId();
                        for (MemberCondition condition : conditions) {
                            RangeEnum rangeByNumber;
                            Member member = modelCacheHelper.getMember(dimension.getNumber(), viewId, condition.getNumber());
                            if (member == null || (rangeByNumber = RangeEnum.getRangeByVal((String)condition.getRange())) == null) continue;
                            names.add(member.getName() + rangeByNumber.getName());
                        }
                        this.getModel().setValue(DIMVIEW, (Object)viewId, index);
                        if (CollectionUtils.isNotEmpty(names)) {
                            this.getModel().setValue(MEMBER, (Object)String.join((CharSequence)";", names), index);
                        }
                        ++index;
                    }
                    this.cacheVersionCopyConditions(versionCopyConditionDtos);
                }
            } else {
                dataModel.batchCreateNewEntryRow(ENTRYENTITY, 2);
                versionCopyConditionDtos = new ArrayList<VersionCopyConditionDto>(2);
                for (String dimNumber : DEFAULT_DIM) {
                    Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                    this.getModel().setValue(DIM, (Object)dimension.getId(), index);
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{DIM});
                    String entityName = SysDimensionEnum.DataType.getNumber().equals(dimNumber) ? "ent_datatype" : "ent_period";
                    String idKey = SysDimensionEnum.DataType.getNumber().equals(dimNumber) ? "datatype.id" : "period.id";
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entityName);
                    if (!dynamicObjectCollection.isEmpty()) {
                        VersionCopyConditionDto versionCopyConditionDto = new VersionCopyConditionDto();
                        versionCopyConditionDto.setDimId(dimension.getId());
                        versionCopyConditionDto.setViewId(Long.valueOf(0L));
                        versionCopyConditionDto.setDimNumber(dimNumber);
                        ArrayList<MemberCondition> conditions = new ArrayList<MemberCondition>(16);
                        ArrayList<String> names = new ArrayList<String>(16);
                        for (DynamicObject object : dynamicObjectCollection) {
                            Member member = modelCacheHelper.getMember(dimNumber, null, Long.valueOf(object.getLong(idKey)));
                            if (member == null) continue;
                            conditions.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
                            names.add(member.getName() + RangeEnum.ONLY.getName());
                        }
                        versionCopyConditionDto.setConditions(conditions);
                        versionCopyConditionDtos.add(versionCopyConditionDto);
                        if (CollectionUtils.isNotEmpty(names)) {
                            this.getModel().setValue(MEMBER, (Object)String.join((CharSequence)";", names), index);
                        }
                    }
                    ++index;
                }
                this.cacheVersionCopyConditions(versionCopyConditionDtos);
            }
            if (this.isFromValidation()) {
                this.start();
            }
        }
    }

    private void cacheVersionCopyConditions(List<VersionCopyConditionDto> versionCopyConditionDtos) {
        if (CollectionUtils.isEmpty(versionCopyConditionDtos)) {
            this.getPageCache().remove("versionCopyCondition");
        }
        this.getPageCache().put("versionCopyCondition", kd.bos.login.actions.SerializationUtils.toJsonString(versionCopyConditionDtos));
    }

    private List<VersionCopyConditionDto> getVersionCopyConditionDtos() {
        String versionCopyCondition = this.getPageCache().get("versionCopyCondition");
        if (StringUtils.isNotEmpty((String)versionCopyCondition)) {
            return kd.bos.login.actions.SerializationUtils.fromJsonStringToList((String)versionCopyCondition, VersionCopyConditionDto.class);
        }
        return new ArrayList<VersionCopyConditionDto>(16);
    }

    private void setTrail(DynamicObject dynamicObject, String entname, String tarTrialEnt, String dimTrialTar, String idpros) {
        block3: {
            block2: {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entname);
                this.getModel().deleteEntryData(tarTrialEnt);
                if (!CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) break block2;
                this.getModel().batchCreateNewEntryRow(tarTrialEnt, dynamicObjectCollection.size());
                for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                    this.getModel().setValue(dimTrialTar, (Object)((DynamicObject)dynamicObjectCollection.get(i)).getLong(idpros), i);
                }
                break block3;
            }
            List<Member> trailLeafNode = this.getTrailLeafNode();
            if (CollectionUtils.isEmpty(trailLeafNode)) break block3;
            this.getModel().batchCreateNewEntryRow(tarTrialEnt, trailLeafNode.size());
            for (int i = 0; i < trailLeafNode.size(); ++i) {
                Member member = trailLeafNode.get(i);
                this.getModel().setValue(dimTrialTar, (Object)member.getId(), i);
            }
        }
    }

    private List<Member> getTrailLeafNode() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String businessModel = this.getPageCache().get("businessModel");
        List dataSetIdByBusModelIds = DatasetServiceHelper.getDataSetIdByBusModelIds(Collections.singleton(IDUtils.toLong((Object)businessModel)));
        List<Object> members = new ArrayList<Member>();
        for (Long datasetId : dataSetIdByBusModelIds) {
            List dimensions = DatasetServiceHelper.getInstance().listDimensionByDatasetId(datasetId);
            for (kd.epm.eb.common.model.Dimension dim : dimensions) {
                if (!dim.getNumber().equals(SysDimensionEnum.AuditTrail.getNumber())) continue;
                String number = dim.getNumber();
                List dimMembers = modelCache.getMembers(dim.getViewId(), number);
                members = dimMembers.stream().collect(Collectors.toList());
            }
        }
        return members;
    }

    private boolean isFromValidation() {
        String isValidation = this.getPageCache().get("isValidation");
        return StringUtils.isNotEmpty((String)isValidation);
    }

    private DynamicObject getSchemeDynamicObject() {
        String s;
        QFilter qFilter;
        DynamicObject[] dynamicObject;
        DynamicObject dynamicObject2;
        String dataStr = this.getPageCache().get(DYNAMIC_DATA);
        if (StringUtils.isNotEmpty((String)dataStr) && (dynamicObject2 = (DynamicObject)kd.bos.login.actions.SerializationUtils.deSerializeFromBase64((String)dataStr)) != null) {
            this.getPageCache().put("businessModel", dynamicObject2.getDynamicObject("businessmodel").getString("id"));
            return dynamicObject2;
        }
        Object pkid = this.getView().getFormShowParameter().getCustomParam("pkid");
        if (pkid != null && (dynamicObject = BusinessDataServiceHelper.load((String)"eb_versioncopyscheme", (String)"schemetype,schemename,effectivedate,expirationdate,businessmodel,srcversion,ent_srctrial,ent_srctrial.srctrial,tarversion,ent_tartrial,ent_tartrial.tartrial,datalock,schemenum,billstatus,model,ent_period,ent_period.period,ent_datatype,ent_datatype.datatype,orgview,dimmemberjson", (QFilter[])(qFilter = new QFilter("id", "=", (Object)Long.valueOf(s = String.valueOf(pkid)))).toArray())) != null && dynamicObject.length > 0) {
            this.getPageCache().put(DYNAMIC_DATA, kd.bos.login.actions.SerializationUtils.serializeToBase64((Object)dynamicObject[0]));
            DynamicObject dynamicObject1 = dynamicObject[0];
            this.getPageCache().put("businessModel", dynamicObject1.getDynamicObject("businessmodel").getString("id"));
            return dynamicObject1;
        }
        return null;
    }

    private List<Member> getEntityNumber() {
        String memberMap = (String)this.getView().getFormShowParameter().getCustomParam("memberMap");
        Object o = kd.bos.login.actions.SerializationUtils.deSerializeFromBase64((String)memberMap);
        if (o != null) {
            Map map = (Map)o;
            List members = (List)map.get(SysDimensionEnum.Entity.getNumber());
            if (CollectionUtils.isEmpty((Collection)members)) {
                return null;
            }
            ArrayList<Member> collect = new ArrayList<Member>(16);
            this.getAllEntityNumber(collect, members);
            return collect;
        }
        return null;
    }

    private void getAllEntityNumber(List<Member> collect, List<Member> members) {
        for (Member member : members) {
            collect.add(member);
            if (!CollectionUtils.isNotEmpty((Collection)member.getChildren())) continue;
            this.getAllEntityNumber(collect, member.getChildren());
        }
    }

    private LinkedHashSet<Member> getMemberList() {
        String memberMap = (String)this.getView().getFormShowParameter().getCustomParam("memberMap");
        Object o = kd.bos.login.actions.SerializationUtils.deSerializeFromBase64((String)memberMap);
        if (o != null) {
            Map map = (Map)o;
            List members = (List)map.get(SysDimensionEnum.Entity.getNumber());
            if (CollectionUtils.isNotEmpty((Collection)members)) {
                LinkedHashSet<Member> collect = new LinkedHashSet<Member>(16);
                for (Member member : members) {
                    collect.addAll(member.getAllMembers());
                }
                return collect;
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void start() {
        VersionCopySchemeExecuteEntity versionCopyEntity = this.createViewsionCopyObj();
        if (versionCopyEntity == null) return;
        if (this.checkVersionCopyRunning(versionCopyEntity)) {
            if (this.isFromValidation()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u7248\u672c\u590d\u5236\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"VersionCopyExecutePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u7248\u672c\u590d\u5236\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"VersionCopyExecutePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isLock = this.checkDimemsionLock(versionCopyEntity);
        if (isLock) {
            if (!this.isFromValidation()) throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u8303\u56f4\u5185\u6570\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u590d\u5236\u3002", (String)"VersionCopyExecutePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u65b9\u6848\u8303\u56f4\u5185\u6570\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u590d\u5236\u3002", (String)"VersionCopyExecutePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        String msg = this.check(versionCopyEntity);
        if (!StringUtils.isNotEmpty((String)msg)) {
            this.beginExecute(versionCopyEntity, false);
            return;
        }
        if (FLAG_MSG.equals(msg)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5df2\u5b58\u5728\u6570\u636e\uff0c\u7ee7\u7eed\u6267\u884c\u5c06\u8986\u76d6\u5df2\u6709\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"VersionCopyExecutePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("copy_comfirm", (IFormPlugin)this));
            return;
        }
        this.getView().showTipNotification(msg);
    }

    private boolean checkDimemsionLock(VersionCopySchemeExecuteEntity versionCopyEntity) {
        long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List datasets = versionCopyEntity.getDateSetList();
        Map<Long, Map<String, Set<Member>>> datasetDimAndMem = this.getDatasetDimAndMem(modelCache, versionCopyEntity, false);
        List businessModelId = versionCopyEntity.getBusinessModelId();
        if (CollectionUtils.isEmpty((Collection)businessModelId)) {
            return false;
        }
        long busModelId = (Long)businessModelId.get(0);
        List member = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), Long.valueOf(0L), SysDimensionEnum.AuditTrail.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
        for (Dataset dataset : datasets) {
            IBgmdDataLockCache checker = BgmdDataLockService.getInstance().getDataLockCache(Long.valueOf(modelId), Long.valueOf(busModelId));
            Map<String, Set<Member>> map = datasetDimAndMem.get(dataset.getId());
            HashMap checkMap = new HashMap(5);
            for (String s : VersionCopyApiUtils.CHECK_LOCK_DIM) {
                Set<Member> members = map.get(s);
                if (CollectionUtils.isNotEmpty(members)) {
                    Set memberNumbers = members.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                    checkMap.put(s, memberNumbers);
                    continue;
                }
                if (!SysDimensionEnum.AuditTrail.getNumber().equals(s) || !CollectionUtils.isNotEmpty((Collection)member)) continue;
                checkMap.put(s, member.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
            }
            if (checker == null || !checker.isDataLockScope(checkMap)) continue;
            return true;
        }
        return false;
    }
}

